CREATE TABLE interests (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));

INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.00', '1.B.1.a', 'OI', 1.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.00', '1.B.1.b', 'OI', 3.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.00', '1.B.1.c', 'OI', 2.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.00', '1.B.1.d', 'OI', 3.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.00', '1.B.1.e', 'OI', 6.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.00', '1.B.1.f', 'OI', 4.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.03', '1.B.1.a', 'OI', 2.04, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.03', '1.B.1.b', 'OI', 4.78, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.03', '1.B.1.c', 'OI', 2.48, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.03', '1.B.1.d', 'OI', 3.55, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.03', '1.B.1.e', 'OI', 6.68, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.03', '1.B.1.f', 'OI', 4.49, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.03', '1.B.1.g', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.03', '1.B.1.h', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1011.03', '1.B.1.i', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1021.00', '1.B.1.a', 'OI', 2.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1021.00', '1.B.1.b', 'OI', 2.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1021.00', '1.B.1.c', 'OI', 1.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1021.00', '1.B.1.d', 'OI', 3.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1021.00', '1.B.1.e', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1021.00', '1.B.1.f', 'OI', 5.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1021.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1021.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1031.00', '1.B.1.a', 'OI', 1.54, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1031.00', '1.B.1.b', 'OI', 3.35, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1031.00', '1.B.1.c', 'OI', 2.70, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1031.00', '1.B.1.d', 'OI', 3.69, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1031.00', '1.B.1.e', 'OI', 5.52, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1031.00', '1.B.1.f', 'OI', 3.62, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1031.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1031.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-1031.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2011.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2011.00', '1.B.1.b', 'OI', 1.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2011.00', '1.B.1.c', 'OI', 3.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2011.00', '1.B.1.d', 'OI', 3.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2011.00', '1.B.1.e', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2011.00', '1.B.1.f', 'OI', 4.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2011.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2011.00', '1.B.1.i', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2021.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2021.00', '1.B.1.b', 'OI', 2.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2021.00', '1.B.1.c', 'OI', 2.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2021.00', '1.B.1.d', 'OI', 2.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2021.00', '1.B.1.e', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2021.00', '1.B.1.f', 'OI', 4.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2021.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2021.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2022.00', '1.B.1.a', 'OI', 1.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2022.00', '1.B.1.b', 'OI', 1.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2022.00', '1.B.1.c', 'OI', 1.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2022.00', '1.B.1.d', 'OI', 3.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2022.00', '1.B.1.e', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2022.00', '1.B.1.f', 'OI', 5.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2022.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2022.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2022.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2032.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2032.00', '1.B.1.b', 'OI', 2.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2032.00', '1.B.1.c', 'OI', 3.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2032.00', '1.B.1.d', 'OI', 4.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2032.00', '1.B.1.e', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2032.00', '1.B.1.f', 'OI', 4.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2032.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2032.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2032.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2033.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2033.00', '1.B.1.b', 'OI', 2.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2033.00', '1.B.1.c', 'OI', 2.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2033.00', '1.B.1.d', 'OI', 3.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2033.00', '1.B.1.e', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2033.00', '1.B.1.f', 'OI', 4.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2033.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2033.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-2033.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3012.00', '1.B.1.a', 'OI', 1.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3012.00', '1.B.1.b', 'OI', 2.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3012.00', '1.B.1.c', 'OI', 1.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3012.00', '1.B.1.d', 'OI', 3.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3012.00', '1.B.1.e', 'OI', 6.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3012.00', '1.B.1.f', 'OI', 6.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3012.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3012.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3012.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.00', '1.B.1.a', 'OI', 4.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.00', '1.B.1.b', 'OI', 2.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.00', '1.B.1.c', 'OI', 1.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.00', '1.B.1.d', 'OI', 3.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.00', '1.B.1.e', 'OI', 5.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.00', '1.B.1.f', 'OI', 5.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.01', '1.B.1.a', 'OI', 3.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.01', '1.B.1.b', 'OI', 3.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.01', '1.B.1.c', 'OI', 1.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.01', '1.B.1.d', 'OI', 2.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.01', '1.B.1.e', 'OI', 5.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.01', '1.B.1.f', 'OI', 5.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.01', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3013.01', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3021.00', '1.B.1.a', 'OI', 2.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3021.00', '1.B.1.b', 'OI', 4.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3021.00', '1.B.1.c', 'OI', 1.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3021.00', '1.B.1.d', 'OI', 2.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3021.00', '1.B.1.e', 'OI', 5.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3021.00', '1.B.1.f', 'OI', 5.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3021.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3021.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3021.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.00', '1.B.1.a', 'OI', 1.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.00', '1.B.1.b', 'OI', 2.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.00', '1.B.1.c', 'OI', 1.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.00', '1.B.1.d', 'OI', 3.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.00', '1.B.1.e', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.00', '1.B.1.f', 'OI', 5.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.01', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.01', '1.B.1.b', 'OI', 2.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.01', '1.B.1.c', 'OI', 1.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.01', '1.B.1.d', 'OI', 2.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.01', '1.B.1.e', 'OI', 6.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.01', '1.B.1.f', 'OI', 6.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.01', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.01', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.01', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.03', '1.B.1.a', 'OI', 1.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.03', '1.B.1.b', 'OI', 3.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.03', '1.B.1.c', 'OI', 1.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.03', '1.B.1.d', 'OI', 2.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.03', '1.B.1.e', 'OI', 6.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.03', '1.B.1.f', 'OI', 5.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.03', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.03', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3031.03', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.00', '1.B.1.a', 'OI', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.00', '1.B.1.b', 'OI', 2.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.00', '1.B.1.c', 'OI', 1.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.00', '1.B.1.d', 'OI', 1.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.00', '1.B.1.e', 'OI', 6.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.00', '1.B.1.f', 'OI', 5.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.01', '1.B.1.a', 'OI', 3.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.01', '1.B.1.b', 'OI', 4.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.01', '1.B.1.c', 'OI', 1.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.01', '1.B.1.d', 'OI', 2.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.01', '1.B.1.e', 'OI', 5.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.01', '1.B.1.f', 'OI', 5.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.01', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.01', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.01', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.02', '1.B.1.a', 'OI', 5.35, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.02', '1.B.1.b', 'OI', 3.35, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.02', '1.B.1.c', 'OI', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.02', '1.B.1.d', 'OI', 2.07, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.02', '1.B.1.e', 'OI', 4.58, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.02', '1.B.1.f', 'OI', 4.82, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.02', '1.B.1.g', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.02', '1.B.1.h', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.02', '1.B.1.i', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.03', '1.B.1.a', 'OI', 4.59, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.03', '1.B.1.b', 'OI', 3.74, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.03', '1.B.1.c', 'OI', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.03', '1.B.1.d', 'OI', 1.83, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.03', '1.B.1.e', 'OI', 5.41, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.03', '1.B.1.f', 'OI', 5.06, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.03', '1.B.1.g', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.03', '1.B.1.h', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.03', '1.B.1.i', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.04', '1.B.1.a', 'OI', 5.12, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.04', '1.B.1.b', 'OI', 3.19, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.04', '1.B.1.c', 'OI', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.04', '1.B.1.d', 'OI', 1.72, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.04', '1.B.1.e', 'OI', 4.86, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.04', '1.B.1.f', 'OI', 5.34, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.04', '1.B.1.g', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.04', '1.B.1.h', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.04', '1.B.1.i', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.06', '1.B.1.a', 'OI', 5.37, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.06', '1.B.1.b', 'OI', 3.64, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.06', '1.B.1.c', 'OI', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.06', '1.B.1.d', 'OI', 1.83, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.06', '1.B.1.e', 'OI', 4.57, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.06', '1.B.1.f', 'OI', 5.02, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.06', '1.B.1.g', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.06', '1.B.1.h', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3051.06', '1.B.1.i', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3061.00', '1.B.1.a', 'OI', 2.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3061.00', '1.B.1.b', 'OI', 1.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3061.00', '1.B.1.c', 'OI', 1.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3061.00', '1.B.1.d', 'OI', 2.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3061.00', '1.B.1.e', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3061.00', '1.B.1.f', 'OI', 5.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3061.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3061.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3061.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.00', '1.B.1.a', 'OI', 3.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.00', '1.B.1.b', 'OI', 2.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.00', '1.B.1.d', 'OI', 2.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.00', '1.B.1.e', 'OI', 5.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.00', '1.B.1.f', 'OI', 5.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.04', '1.B.1.a', 'OI', 3.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.04', '1.B.1.b', 'OI', 2.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.04', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.04', '1.B.1.d', 'OI', 2.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.04', '1.B.1.e', 'OI', 6.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.04', '1.B.1.f', 'OI', 5.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.04', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.04', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3071.04', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3111.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3111.00', '1.B.1.b', 'OI', 2.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3111.00', '1.B.1.c', 'OI', 1.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3111.00', '1.B.1.d', 'OI', 3.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3111.00', '1.B.1.e', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3111.00', '1.B.1.f', 'OI', 5.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3111.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3111.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3111.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3121.00', '1.B.1.a', 'OI', 1.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3121.00', '1.B.1.b', 'OI', 2.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3121.00', '1.B.1.c', 'OI', 1.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3121.00', '1.B.1.d', 'OI', 3.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3121.00', '1.B.1.e', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3121.00', '1.B.1.f', 'OI', 5.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3121.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3121.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3121.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3131.00', '1.B.1.a', 'OI', 1.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3131.00', '1.B.1.b', 'OI', 3.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3131.00', '1.B.1.c', 'OI', 2.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3131.00', '1.B.1.d', 'OI', 5.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3131.00', '1.B.1.e', 'OI', 6.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3131.00', '1.B.1.f', 'OI', 4.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3131.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3131.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-3131.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9013.00', '1.B.1.a', 'OI', 5.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9013.00', '1.B.1.b', 'OI', 2.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9013.00', '1.B.1.c', 'OI', 1.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9013.00', '1.B.1.d', 'OI', 2.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9013.00', '1.B.1.e', 'OI', 5.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9013.00', '1.B.1.f', 'OI', 4.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9013.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9013.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9013.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9021.00', '1.B.1.a', 'OI', 4.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9021.00', '1.B.1.b', 'OI', 3.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9021.00', '1.B.1.c', 'OI', 1.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9021.00', '1.B.1.d', 'OI', 2.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9021.00', '1.B.1.e', 'OI', 5.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9021.00', '1.B.1.f', 'OI', 4.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9021.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9021.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9021.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9031.00', '1.B.1.a', 'OI', 1.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9031.00', '1.B.1.b', 'OI', 2.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9031.00', '1.B.1.c', 'OI', 2.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9031.00', '1.B.1.d', 'OI', 6.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9031.00', '1.B.1.e', 'OI', 4.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9031.00', '1.B.1.f', 'OI', 4.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9031.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9031.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9031.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9032.00', '1.B.1.a', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9032.00', '1.B.1.b', 'OI', 3.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9032.00', '1.B.1.c', 'OI', 2.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9032.00', '1.B.1.d', 'OI', 5.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9032.00', '1.B.1.e', 'OI', 5.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9032.00', '1.B.1.f', 'OI', 4.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9032.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9032.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9032.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9033.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9033.00', '1.B.1.b', 'OI', 3.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9033.00', '1.B.1.c', 'OI', 2.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9033.00', '1.B.1.d', 'OI', 5.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9033.00', '1.B.1.e', 'OI', 5.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9033.00', '1.B.1.f', 'OI', 4.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9033.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9033.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9033.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.00', '1.B.1.a', 'OI', 2.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.00', '1.B.1.b', 'OI', 4.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.00', '1.B.1.c', 'OI', 2.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.00', '1.B.1.d', 'OI', 2.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.00', '1.B.1.e', 'OI', 6.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.00', '1.B.1.f', 'OI', 4.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.01', '1.B.1.a', 'OI', 4.16, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.01', '1.B.1.b', 'OI', 5.84, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.01', '1.B.1.c', 'OI', 2.11, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.01', '1.B.1.d', 'OI', 2.10, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.01', '1.B.1.e', 'OI', 4.70, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.01', '1.B.1.f', 'OI', 3.51, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.01', '1.B.1.h', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9041.01', '1.B.1.i', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9051.00', '1.B.1.a', 'OI', 4.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9051.00', '1.B.1.b', 'OI', 1.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9051.00', '1.B.1.c', 'OI', 1.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9051.00', '1.B.1.d', 'OI', 3.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9051.00', '1.B.1.e', 'OI', 5.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9051.00', '1.B.1.f', 'OI', 5.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9051.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9051.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9051.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9071.00', '1.B.1.a', 'OI', 2.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9071.00', '1.B.1.b', 'OI', 1.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9071.00', '1.B.1.c', 'OI', 1.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9071.00', '1.B.1.d', 'OI', 2.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9071.00', '1.B.1.e', 'OI', 6.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9071.00', '1.B.1.f', 'OI', 5.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9071.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9071.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9071.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9072.00', '1.B.1.a', 'OI', 3.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9072.00', '1.B.1.b', 'OI', 1.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9072.00', '1.B.1.c', 'OI', 1.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9072.00', '1.B.1.d', 'OI', 3.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9072.00', '1.B.1.e', 'OI', 6.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9072.00', '1.B.1.f', 'OI', 5.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9072.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9072.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9072.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9081.00', '1.B.1.a', 'OI', 2.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9081.00', '1.B.1.b', 'OI', 1.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9081.00', '1.B.1.c', 'OI', 1.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9081.00', '1.B.1.d', 'OI', 4.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9081.00', '1.B.1.e', 'OI', 6.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9081.00', '1.B.1.f', 'OI', 5.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9081.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9081.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9081.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9111.00', '1.B.1.a', 'OI', 2.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9111.00', '1.B.1.b', 'OI', 3.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9111.00', '1.B.1.c', 'OI', 1.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9111.00', '1.B.1.d', 'OI', 4.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9111.00', '1.B.1.e', 'OI', 5.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9111.00', '1.B.1.f', 'OI', 5.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9111.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9111.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9111.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.00', '1.B.1.a', 'OI', 2.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.00', '1.B.1.b', 'OI', 5.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.00', '1.B.1.c', 'OI', 2.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.00', '1.B.1.d', 'OI', 3.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.00', '1.B.1.e', 'OI', 5.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.00', '1.B.1.f', 'OI', 4.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.01', '1.B.1.a', 'OI', 1.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.01', '1.B.1.b', 'OI', 5.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.01', '1.B.1.c', 'OI', 1.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.01', '1.B.1.d', 'OI', 3.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.01', '1.B.1.e', 'OI', 4.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.01', '1.B.1.f', 'OI', 4.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.01', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.02', '1.B.1.a', 'OI', 4.45, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.02', '1.B.1.b', 'OI', 5.80, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.02', '1.B.1.c', 'OI', 1.78, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.02', '1.B.1.d', 'OI', 2.58, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.02', '1.B.1.e', 'OI', 3.53, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.02', '1.B.1.f', 'OI', 4.17, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.02', '1.B.1.g', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.02', '1.B.1.h', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9121.02', '1.B.1.i', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9131.00', '1.B.1.a', 'OI', 2.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9131.00', '1.B.1.b', 'OI', 1.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9131.00', '1.B.1.c', 'OI', 1.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9131.00', '1.B.1.d', 'OI', 3.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9131.00', '1.B.1.e', 'OI', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9131.00', '1.B.1.f', 'OI', 5.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9131.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9131.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9131.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9141.00', '1.B.1.a', 'OI', 3.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9141.00', '1.B.1.b', 'OI', 2.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9141.00', '1.B.1.c', 'OI', 1.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9141.00', '1.B.1.d', 'OI', 3.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9141.00', '1.B.1.e', 'OI', 6.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9141.00', '1.B.1.f', 'OI', 5.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9141.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9141.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9141.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9151.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9151.00', '1.B.1.b', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9151.00', '1.B.1.c', 'OI', 2.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9151.00', '1.B.1.d', 'OI', 5.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9151.00', '1.B.1.e', 'OI', 6.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9151.00', '1.B.1.f', 'OI', 4.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9151.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9151.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9151.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9161.00', '1.B.1.a', 'OI', 3.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9161.00', '1.B.1.b', 'OI', 4.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9161.00', '1.B.1.c', 'OI', 1.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9161.00', '1.B.1.d', 'OI', 4.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9161.00', '1.B.1.e', 'OI', 5.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9161.00', '1.B.1.f', 'OI', 4.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9161.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9161.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9161.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9171.00', '1.B.1.a', 'OI', 2.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9171.00', '1.B.1.b', 'OI', 2.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9171.00', '1.B.1.c', 'OI', 1.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9171.00', '1.B.1.d', 'OI', 4.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9171.00', '1.B.1.e', 'OI', 6.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9171.00', '1.B.1.f', 'OI', 4.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9171.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9171.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9171.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.01', '1.B.1.a', 'OI', 3.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.01', '1.B.1.b', 'OI', 2.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.01', '1.B.1.c', 'OI', 2.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.01', '1.B.1.d', 'OI', 5.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.01', '1.B.1.e', 'OI', 5.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.01', '1.B.1.f', 'OI', 3.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.01', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.01', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.01', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.02', '1.B.1.a', 'OI', 2.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.02', '1.B.1.b', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.02', '1.B.1.c', 'OI', 1.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.02', '1.B.1.d', 'OI', 4.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.02', '1.B.1.e', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.02', '1.B.1.f', 'OI', 4.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.02', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.02', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9179.02', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.01', '1.B.1.a', 'OI', 1.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.01', '1.B.1.b', 'OI', 2.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.01', '1.B.1.c', 'OI', 1.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.01', '1.B.1.d', 'OI', 2.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.01', '1.B.1.e', 'OI', 6.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.01', '1.B.1.f', 'OI', 5.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.01', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.01', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.02', '1.B.1.a', 'OI', 1.92, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.02', '1.B.1.b', 'OI', 2.98, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.02', '1.B.1.c', 'OI', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.02', '1.B.1.d', 'OI', 3.10, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.02', '1.B.1.e', 'OI', 5.93, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.02', '1.B.1.f', 'OI', 6.30, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.02', '1.B.1.g', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.02', '1.B.1.h', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.02', '1.B.1.i', 'IH', 0.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.08', '1.B.1.a', 'OI', 3.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.08', '1.B.1.b', 'OI', 3.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.08', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.08', '1.B.1.d', 'OI', 2.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.08', '1.B.1.e', 'OI', 5.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.08', '1.B.1.f', 'OI', 5.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.08', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.08', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.08', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.09', '1.B.1.a', 'OI', 4.16, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.09', '1.B.1.b', 'OI', 3.04, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.09', '1.B.1.c', 'OI', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.09', '1.B.1.d', 'OI', 2.34, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.09', '1.B.1.e', 'OI', 6.47, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.09', '1.B.1.f', 'OI', 5.24, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.09', '1.B.1.g', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.09', '1.B.1.h', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.09', '1.B.1.i', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.10', '1.B.1.a', 'OI', 3.44, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.10', '1.B.1.b', 'OI', 3.86, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.10', '1.B.1.c', 'OI', 1.66, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.10', '1.B.1.d', 'OI', 2.38, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.10', '1.B.1.e', 'OI', 6.71, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.10', '1.B.1.f', 'OI', 4.82, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.10', '1.B.1.g', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.10', '1.B.1.h', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.10', '1.B.1.i', 'IH', 0.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.11', '1.B.1.a', 'OI', 4.49, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.11', '1.B.1.b', 'OI', 4.31, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.11', '1.B.1.c', 'OI', 1.46, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.11', '1.B.1.d', 'OI', 2.03, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.11', '1.B.1.e', 'OI', 4.54, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.11', '1.B.1.f', 'OI', 4.69, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.11', '1.B.1.g', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.11', '1.B.1.h', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('11-9199.11', '1.B.1.i', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1011.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1011.00', '1.B.1.b', 'OI', 1.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1011.00', '1.B.1.c', 'OI', 3.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1011.00', '1.B.1.d', 'OI', 4.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1011.00', '1.B.1.e', 'OI', 6.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1011.00', '1.B.1.f', 'OI', 3.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1011.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1011.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1011.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1021.00', '1.B.1.a', 'OI', 4.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1021.00', '1.B.1.b', 'OI', 1.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1021.00', '1.B.1.c', 'OI', 1.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1021.00', '1.B.1.d', 'OI', 1.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1021.00', '1.B.1.e', 'OI', 4.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1021.00', '1.B.1.f', 'OI', 4.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1021.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1021.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1021.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1022.00', '1.B.1.a', 'OI', 3.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1022.00', '1.B.1.b', 'OI', 1.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1022.00', '1.B.1.c', 'OI', 1.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1022.00', '1.B.1.d', 'OI', 2.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1022.00', '1.B.1.e', 'OI', 5.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1022.00', '1.B.1.f', 'OI', 5.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1022.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1022.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1022.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1023.00', '1.B.1.a', 'OI', 3.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1023.00', '1.B.1.b', 'OI', 1.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1023.00', '1.B.1.c', 'OI', 1.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1023.00', '1.B.1.d', 'OI', 1.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1023.00', '1.B.1.e', 'OI', 5.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1023.00', '1.B.1.f', 'OI', 5.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1023.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1023.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1023.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1031.00', '1.B.1.a', 'OI', 1.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1031.00', '1.B.1.b', 'OI', 3.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1031.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1031.00', '1.B.1.d', 'OI', 2.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1031.00', '1.B.1.e', 'OI', 4.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1031.00', '1.B.1.f', 'OI', 6.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1031.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1031.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1031.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1032.00', '1.B.1.a', 'OI', 5.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1032.00', '1.B.1.b', 'OI', 3.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1032.00', '1.B.1.c', 'OI', 1.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1032.00', '1.B.1.d', 'OI', 1.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1032.00', '1.B.1.e', 'OI', 3.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1032.00', '1.B.1.f', 'OI', 5.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1032.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1032.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1032.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.00', '1.B.1.a', 'OI', 2.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.00', '1.B.1.b', 'OI', 3.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.00', '1.B.1.d', 'OI', 2.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.00', '1.B.1.e', 'OI', 4.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.00', '1.B.1.f', 'OI', 6.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.01', '1.B.1.a', 'OI', 4.57, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.01', '1.B.1.b', 'OI', 4.77, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.01', '1.B.1.c', 'OI', 1.05, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.01', '1.B.1.d', 'OI', 2.35, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.01', '1.B.1.e', 'OI', 3.21, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.01', '1.B.1.f', 'OI', 5.84, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.01', '1.B.1.g', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.01', '1.B.1.i', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.03', '1.B.1.a', 'OI', 1.23, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.03', '1.B.1.b', 'OI', 3.01, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.03', '1.B.1.c', 'OI', 1.73, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.03', '1.B.1.d', 'OI', 4.24, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.03', '1.B.1.e', 'OI', 5.37, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.03', '1.B.1.f', 'OI', 5.21, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.03', '1.B.1.g', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.03', '1.B.1.h', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.03', '1.B.1.i', 'IH', 4.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.04', '1.B.1.a', 'OI', 3.09, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.04', '1.B.1.b', 'OI', 3.32, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.04', '1.B.1.c', 'OI', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.04', '1.B.1.d', 'OI', 2.41, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.04', '1.B.1.e', 'OI', 4.20, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.04', '1.B.1.f', 'OI', 6.26, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.04', '1.B.1.g', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.04', '1.B.1.h', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.04', '1.B.1.i', 'IH', 0.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.06', '1.B.1.a', 'OI', 4.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.06', '1.B.1.b', 'OI', 4.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.06', '1.B.1.c', 'OI', 1.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.06', '1.B.1.d', 'OI', 3.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.06', '1.B.1.e', 'OI', 4.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.06', '1.B.1.f', 'OI', 4.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.06', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.06', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.06', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.07', '1.B.1.a', 'OI', 1.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.07', '1.B.1.b', 'OI', 3.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.07', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.07', '1.B.1.d', 'OI', 2.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.07', '1.B.1.e', 'OI', 4.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.07', '1.B.1.f', 'OI', 6.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.07', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.07', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.07', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.08', '1.B.1.a', 'OI', 2.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.08', '1.B.1.b', 'OI', 1.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.08', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.08', '1.B.1.d', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.08', '1.B.1.e', 'OI', 5.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.08', '1.B.1.f', 'OI', 6.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.08', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.08', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1041.08', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1051.00', '1.B.1.a', 'OI', 3.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1051.00', '1.B.1.b', 'OI', 3.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1051.00', '1.B.1.c', 'OI', 1.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1051.00', '1.B.1.d', 'OI', 1.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1051.00', '1.B.1.e', 'OI', 4.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1051.00', '1.B.1.f', 'OI', 6.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1051.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1051.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1051.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1071.00', '1.B.1.a', 'OI', 1.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1071.00', '1.B.1.b', 'OI', 2.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1071.00', '1.B.1.c', 'OI', 1.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1071.00', '1.B.1.d', 'OI', 3.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1071.00', '1.B.1.e', 'OI', 5.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1071.00', '1.B.1.f', 'OI', 5.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1071.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1071.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1071.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1074.00', '1.B.1.a', 'OI', 4.85, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1074.00', '1.B.1.b', 'OI', 1.54, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1074.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1074.00', '1.B.1.d', 'OI', 3.24, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1074.00', '1.B.1.e', 'OI', 4.99, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1074.00', '1.B.1.f', 'OI', 4.39, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1074.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1074.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1074.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1075.00', '1.B.1.a', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1075.00', '1.B.1.b', 'OI', 3.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1075.00', '1.B.1.c', 'OI', 1.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1075.00', '1.B.1.d', 'OI', 3.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1075.00', '1.B.1.e', 'OI', 5.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1075.00', '1.B.1.f', 'OI', 4.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1075.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1075.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1075.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.00', '1.B.1.a', 'OI', 2.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.00', '1.B.1.b', 'OI', 3.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.00', '1.B.1.c', 'OI', 1.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.00', '1.B.1.d', 'OI', 2.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.00', '1.B.1.e', 'OI', 5.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.00', '1.B.1.f', 'OI', 5.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.01', '1.B.1.a', 'OI', 4.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.01', '1.B.1.b', 'OI', 5.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.01', '1.B.1.c', 'OI', 1.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.01', '1.B.1.d', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.01', '1.B.1.e', 'OI', 3.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.01', '1.B.1.f', 'OI', 5.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.01', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.01', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.02', '1.B.1.a', 'OI', 2.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.02', '1.B.1.b', 'OI', 4.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.02', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.02', '1.B.1.d', 'OI', 1.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.02', '1.B.1.e', 'OI', 4.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.02', '1.B.1.f', 'OI', 6.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.02', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.02', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1081.02', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1082.00', '1.B.1.a', 'OI', 1.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1082.00', '1.B.1.b', 'OI', 2.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1082.00', '1.B.1.c', 'OI', 1.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1082.00', '1.B.1.d', 'OI', 3.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1082.00', '1.B.1.e', 'OI', 6.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1082.00', '1.B.1.f', 'OI', 5.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1082.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1082.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1082.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1111.00', '1.B.1.a', 'OI', 1.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1111.00', '1.B.1.b', 'OI', 5.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1111.00', '1.B.1.c', 'OI', 1.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1111.00', '1.B.1.d', 'OI', 2.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1111.00', '1.B.1.e', 'OI', 4.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1111.00', '1.B.1.f', 'OI', 6.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1111.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1111.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1111.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1121.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1121.00', '1.B.1.b', 'OI', 1.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1121.00', '1.B.1.c', 'OI', 2.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1121.00', '1.B.1.d', 'OI', 4.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1121.00', '1.B.1.e', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1121.00', '1.B.1.f', 'OI', 4.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1121.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1121.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1121.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1131.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1131.00', '1.B.1.b', 'OI', 2.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1131.00', '1.B.1.c', 'OI', 3.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1131.00', '1.B.1.d', 'OI', 4.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1131.00', '1.B.1.e', 'OI', 6.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1131.00', '1.B.1.f', 'OI', 4.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1131.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1131.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1131.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1141.00', '1.B.1.a', 'OI', 1.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1141.00', '1.B.1.b', 'OI', 3.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1141.00', '1.B.1.c', 'OI', 1.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1141.00', '1.B.1.d', 'OI', 3.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1141.00', '1.B.1.e', 'OI', 5.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1141.00', '1.B.1.f', 'OI', 5.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1141.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1141.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1141.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1151.00', '1.B.1.a', 'OI', 2.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1151.00', '1.B.1.b', 'OI', 4.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1151.00', '1.B.1.c', 'OI', 3.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1151.00', '1.B.1.d', 'OI', 5.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1151.00', '1.B.1.e', 'OI', 3.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1151.00', '1.B.1.f', 'OI', 3.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1151.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1151.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1151.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.00', '1.B.1.a', 'OI', 1.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.00', '1.B.1.b', 'OI', 4.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.00', '1.B.1.c', 'OI', 2.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.00', '1.B.1.d', 'OI', 2.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.00', '1.B.1.e', 'OI', 5.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.00', '1.B.1.f', 'OI', 4.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.01', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.01', '1.B.1.b', 'OI', 3.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.01', '1.B.1.c', 'OI', 3.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.01', '1.B.1.d', 'OI', 2.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.01', '1.B.1.e', 'OI', 5.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.01', '1.B.1.f', 'OI', 4.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.01', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1161.01', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.04', '1.B.1.a', 'OI', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.04', '1.B.1.b', 'OI', 4.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.04', '1.B.1.c', 'OI', 1.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.04', '1.B.1.d', 'OI', 3.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.04', '1.B.1.e', 'OI', 5.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.04', '1.B.1.f', 'OI', 5.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.04', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.04', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.04', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.05', '1.B.1.a', 'OI', 2.06, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.05', '1.B.1.b', 'OI', 5.20, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.05', '1.B.1.c', 'OI', 2.50, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.05', '1.B.1.d', 'OI', 2.95, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.05', '1.B.1.e', 'OI', 5.09, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.05', '1.B.1.f', 'OI', 4.41, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.05', '1.B.1.g', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.05', '1.B.1.h', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.05', '1.B.1.i', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.06', '1.B.1.a', 'OI', 2.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.06', '1.B.1.b', 'OI', 1.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.06', '1.B.1.c', 'OI', 1.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.06', '1.B.1.d', 'OI', 2.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.06', '1.B.1.e', 'OI', 5.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.06', '1.B.1.f', 'OI', 5.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.06', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.06', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.06', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.07', '1.B.1.a', 'OI', 3.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.07', '1.B.1.b', 'OI', 5.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.07', '1.B.1.c', 'OI', 1.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.07', '1.B.1.d', 'OI', 1.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.07', '1.B.1.e', 'OI', 3.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.07', '1.B.1.f', 'OI', 5.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.07', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.07', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-1199.07', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2011.00', '1.B.1.a', 'OI', 1.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2011.00', '1.B.1.b', 'OI', 3.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2011.00', '1.B.1.c', 'OI', 1.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2011.00', '1.B.1.d', 'OI', 2.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2011.00', '1.B.1.e', 'OI', 3.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2011.00', '1.B.1.f', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2011.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2011.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2011.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2022.00', '1.B.1.a', 'OI', 3.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2022.00', '1.B.1.b', 'OI', 2.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2022.00', '1.B.1.c', 'OI', 2.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2022.00', '1.B.1.d', 'OI', 1.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2022.00', '1.B.1.e', 'OI', 4.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2022.00', '1.B.1.f', 'OI', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2022.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2022.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2022.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2023.00', '1.B.1.a', 'OI', 2.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2023.00', '1.B.1.b', 'OI', 2.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2023.00', '1.B.1.c', 'OI', 1.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2023.00', '1.B.1.d', 'OI', 2.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2023.00', '1.B.1.e', 'OI', 4.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2023.00', '1.B.1.f', 'OI', 5.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2023.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2023.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2023.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2031.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2031.00', '1.B.1.b', 'OI', 3.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2031.00', '1.B.1.c', 'OI', 1.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2031.00', '1.B.1.d', 'OI', 2.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2031.00', '1.B.1.e', 'OI', 4.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2031.00', '1.B.1.f', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2031.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2031.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2031.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2041.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2041.00', '1.B.1.b', 'OI', 3.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2041.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2041.00', '1.B.1.d', 'OI', 2.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2041.00', '1.B.1.e', 'OI', 4.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2041.00', '1.B.1.f', 'OI', 6.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2041.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2041.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2041.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2051.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2051.00', '1.B.1.b', 'OI', 5.06, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2051.00', '1.B.1.c', 'OI', 1.78, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2051.00', '1.B.1.d', 'OI', 2.25, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2051.00', '1.B.1.e', 'OI', 5.09, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2051.00', '1.B.1.f', 'OI', 5.54, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2051.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2051.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2051.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2052.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2052.00', '1.B.1.b', 'OI', 3.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2052.00', '1.B.1.c', 'OI', 1.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2052.00', '1.B.1.d', 'OI', 4.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2052.00', '1.B.1.e', 'OI', 5.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2052.00', '1.B.1.f', 'OI', 5.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2052.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2052.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2052.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2053.00', '1.B.1.a', 'OI', 1.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2053.00', '1.B.1.b', 'OI', 3.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2053.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2053.00', '1.B.1.d', 'OI', 2.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2053.00', '1.B.1.e', 'OI', 4.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2053.00', '1.B.1.f', 'OI', 6.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2053.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2053.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2053.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2054.00', '1.B.1.a', 'OI', 1.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2054.00', '1.B.1.b', 'OI', 4.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2054.00', '1.B.1.c', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2054.00', '1.B.1.d', 'OI', 2.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2054.00', '1.B.1.e', 'OI', 4.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2054.00', '1.B.1.f', 'OI', 5.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2054.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2054.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2054.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2061.00', '1.B.1.a', 'OI', 1.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2061.00', '1.B.1.b', 'OI', 3.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2061.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2061.00', '1.B.1.d', 'OI', 2.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2061.00', '1.B.1.e', 'OI', 4.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2061.00', '1.B.1.f', 'OI', 6.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2061.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2061.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2061.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2071.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2071.00', '1.B.1.b', 'OI', 2.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2071.00', '1.B.1.c', 'OI', 1.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2071.00', '1.B.1.d', 'OI', 4.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2071.00', '1.B.1.e', 'OI', 4.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2071.00', '1.B.1.f', 'OI', 5.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2071.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2071.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2071.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2072.00', '1.B.1.a', 'OI', 1.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2072.00', '1.B.1.b', 'OI', 2.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2072.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2072.00', '1.B.1.d', 'OI', 3.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2072.00', '1.B.1.e', 'OI', 4.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2072.00', '1.B.1.f', 'OI', 6.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2072.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2072.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2072.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2081.00', '1.B.1.a', 'OI', 1.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2081.00', '1.B.1.b', 'OI', 2.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2081.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2081.00', '1.B.1.d', 'OI', 3.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2081.00', '1.B.1.e', 'OI', 4.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2081.00', '1.B.1.f', 'OI', 6.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2081.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2081.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2081.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2082.00', '1.B.1.a', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2082.00', '1.B.1.b', 'OI', 2.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2082.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2082.00', '1.B.1.d', 'OI', 2.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2082.00', '1.B.1.e', 'OI', 3.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2082.00', '1.B.1.f', 'OI', 6.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2082.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2082.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2082.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.01', '1.B.1.a', 'OI', 1.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.01', '1.B.1.b', 'OI', 6.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.01', '1.B.1.c', 'OI', 1.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.01', '1.B.1.d', 'OI', 1.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.01', '1.B.1.e', 'OI', 3.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.01', '1.B.1.f', 'OI', 5.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.01', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.04', '1.B.1.a', 'OI', 2.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.04', '1.B.1.b', 'OI', 4.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.04', '1.B.1.c', 'OI', 1.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.04', '1.B.1.d', 'OI', 1.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.04', '1.B.1.e', 'OI', 4.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.04', '1.B.1.f', 'OI', 5.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.04', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.04', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('13-2099.04', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.00', '1.B.1.a', 'OI', 3.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.00', '1.B.1.b', 'OI', 6.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.00', '1.B.1.c', 'OI', 1.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.00', '1.B.1.d', 'OI', 1.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.00', '1.B.1.e', 'OI', 2.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.00', '1.B.1.f', 'OI', 5.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.01', '1.B.1.a', 'OI', 2.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.01', '1.B.1.b', 'OI', 6.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.01', '1.B.1.c', 'OI', 1.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.01', '1.B.1.d', 'OI', 4.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.01', '1.B.1.e', 'OI', 2.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.01', '1.B.1.f', 'OI', 4.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1211.01', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1212.00', '1.B.1.a', 'OI', 3.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1212.00', '1.B.1.b', 'OI', 5.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1212.00', '1.B.1.c', 'OI', 1.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1212.00', '1.B.1.d', 'OI', 2.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1212.00', '1.B.1.e', 'OI', 2.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1212.00', '1.B.1.f', 'OI', 6.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1212.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1212.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1212.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1221.00', '1.B.1.a', 'OI', 3.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1221.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1221.00', '1.B.1.c', 'OI', 2.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1221.00', '1.B.1.d', 'OI', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1221.00', '1.B.1.e', 'OI', 2.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1221.00', '1.B.1.f', 'OI', 4.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1221.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1221.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1221.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1231.00', '1.B.1.a', 'OI', 4.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1231.00', '1.B.1.b', 'OI', 4.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1231.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1231.00', '1.B.1.d', 'OI', 2.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1231.00', '1.B.1.e', 'OI', 2.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1231.00', '1.B.1.f', 'OI', 5.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1231.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1231.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1231.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1232.00', '1.B.1.a', 'OI', 4.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1232.00', '1.B.1.b', 'OI', 3.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1232.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1232.00', '1.B.1.d', 'OI', 3.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1232.00', '1.B.1.e', 'OI', 2.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1232.00', '1.B.1.f', 'OI', 6.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1232.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1232.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1232.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.00', '1.B.1.a', 'OI', 4.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.00', '1.B.1.b', 'OI', 5.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.00', '1.B.1.c', 'OI', 2.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.00', '1.B.1.d', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.00', '1.B.1.e', 'OI', 3.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.00', '1.B.1.f', 'OI', 5.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.01', '1.B.1.a', 'OI', 4.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.01', '1.B.1.b', 'OI', 4.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.01', '1.B.1.c', 'OI', 1.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.01', '1.B.1.d', 'OI', 2.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.01', '1.B.1.e', 'OI', 3.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.01', '1.B.1.f', 'OI', 4.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.01', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.01', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1241.01', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1242.00', '1.B.1.a', 'OI', 2.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1242.00', '1.B.1.b', 'OI', 4.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1242.00', '1.B.1.c', 'OI', 1.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1242.00', '1.B.1.d', 'OI', 2.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1242.00', '1.B.1.e', 'OI', 2.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1242.00', '1.B.1.f', 'OI', 6.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1242.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1242.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1242.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.00', '1.B.1.a', 'OI', 2.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.00', '1.B.1.b', 'OI', 5.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.00', '1.B.1.c', 'OI', 2.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.00', '1.B.1.d', 'OI', 1.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.00', '1.B.1.e', 'OI', 2.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.00', '1.B.1.f', 'OI', 6.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.01', '1.B.1.a', 'OI', 2.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.01', '1.B.1.b', 'OI', 4.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.01', '1.B.1.c', 'OI', 1.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.01', '1.B.1.d', 'OI', 2.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.01', '1.B.1.e', 'OI', 3.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.01', '1.B.1.f', 'OI', 6.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.01', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1243.01', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1244.00', '1.B.1.a', 'OI', 4.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1244.00', '1.B.1.b', 'OI', 4.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1244.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1244.00', '1.B.1.d', 'OI', 2.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1244.00', '1.B.1.e', 'OI', 3.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1244.00', '1.B.1.f', 'OI', 6.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1244.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1244.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1244.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1251.00', '1.B.1.a', 'OI', 3.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1251.00', '1.B.1.b', 'OI', 5.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1251.00', '1.B.1.c', 'OI', 2.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1251.00', '1.B.1.d', 'OI', 1.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1251.00', '1.B.1.e', 'OI', 2.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1251.00', '1.B.1.f', 'OI', 5.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1251.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1251.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1251.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1252.00', '1.B.1.a', 'OI', 3.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1252.00', '1.B.1.b', 'OI', 6.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1252.00', '1.B.1.c', 'OI', 2.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1252.00', '1.B.1.d', 'OI', 1.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1252.00', '1.B.1.e', 'OI', 1.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1252.00', '1.B.1.f', 'OI', 5.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1252.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1252.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1252.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1253.00', '1.B.1.a', 'OI', 3.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1253.00', '1.B.1.b', 'OI', 5.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1253.00', '1.B.1.c', 'OI', 1.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1253.00', '1.B.1.d', 'OI', 1.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1253.00', '1.B.1.e', 'OI', 1.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1253.00', '1.B.1.f', 'OI', 5.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1253.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1253.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1253.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1254.00', '1.B.1.a', 'OI', 2.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1254.00', '1.B.1.b', 'OI', 5.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1254.00', '1.B.1.c', 'OI', 3.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1254.00', '1.B.1.d', 'OI', 2.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1254.00', '1.B.1.e', 'OI', 2.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1254.00', '1.B.1.f', 'OI', 5.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1254.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1254.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1254.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.00', '1.B.1.a', 'OI', 2.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.00', '1.B.1.b', 'OI', 4.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.00', '1.B.1.c', 'OI', 4.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.00', '1.B.1.d', 'OI', 2.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.00', '1.B.1.e', 'OI', 3.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.00', '1.B.1.f', 'OI', 4.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.01', '1.B.1.a', 'OI', 2.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.01', '1.B.1.b', 'OI', 4.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.01', '1.B.1.c', 'OI', 6.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.01', '1.B.1.d', 'OI', 2.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.01', '1.B.1.e', 'OI', 3.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.01', '1.B.1.f', 'OI', 3.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.01', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1255.01', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.01', '1.B.1.a', 'OI', 2.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.01', '1.B.1.b', 'OI', 4.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.01', '1.B.1.c', 'OI', 2.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.01', '1.B.1.d', 'OI', 2.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.01', '1.B.1.e', 'OI', 3.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.01', '1.B.1.f', 'OI', 5.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.01', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.01', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.02', '1.B.1.a', 'OI', 4.26, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.02', '1.B.1.b', 'OI', 5.19, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.02', '1.B.1.c', 'OI', 2.31, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.02', '1.B.1.d', 'OI', 1.93, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.02', '1.B.1.e', 'OI', 1.93, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.02', '1.B.1.f', 'OI', 5.88, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.02', '1.B.1.g', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.02', '1.B.1.h', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.02', '1.B.1.i', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.03', '1.B.1.a', 'OI', 1.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.03', '1.B.1.b', 'OI', 3.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.03', '1.B.1.c', 'OI', 1.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.03', '1.B.1.d', 'OI', 2.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.03', '1.B.1.e', 'OI', 2.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.03', '1.B.1.f', 'OI', 6.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.03', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.03', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.03', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.04', '1.B.1.a', 'OI', 3.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.04', '1.B.1.b', 'OI', 5.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.04', '1.B.1.c', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.04', '1.B.1.d', 'OI', 1.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.04', '1.B.1.e', 'OI', 2.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.04', '1.B.1.f', 'OI', 5.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.04', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.04', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.04', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.05', '1.B.1.a', 'OI', 4.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.05', '1.B.1.b', 'OI', 5.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.05', '1.B.1.c', 'OI', 1.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.05', '1.B.1.d', 'OI', 1.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.05', '1.B.1.e', 'OI', 2.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.05', '1.B.1.f', 'OI', 6.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.05', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.05', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.05', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.06', '1.B.1.a', 'OI', 3.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.06', '1.B.1.b', 'OI', 6.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.06', '1.B.1.c', 'OI', 1.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.06', '1.B.1.d', 'OI', 1.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.06', '1.B.1.e', 'OI', 2.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.06', '1.B.1.f', 'OI', 6.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.06', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.06', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.06', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.07', '1.B.1.a', 'OI', 3.40, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.07', '1.B.1.b', 'OI', 5.28, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.07', '1.B.1.c', 'OI', 2.07, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.07', '1.B.1.d', 'OI', 1.57, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.07', '1.B.1.e', 'OI', 3.39, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.07', '1.B.1.f', 'OI', 5.69, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.07', '1.B.1.g', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.07', '1.B.1.h', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.07', '1.B.1.i', 'IH', 0.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.08', '1.B.1.a', 'OI', 4.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.08', '1.B.1.b', 'OI', 5.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.08', '1.B.1.c', 'OI', 1.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.08', '1.B.1.d', 'OI', 2.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.08', '1.B.1.e', 'OI', 3.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.08', '1.B.1.f', 'OI', 5.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.08', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.08', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.08', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.09', '1.B.1.a', 'OI', 1.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.09', '1.B.1.b', 'OI', 3.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.09', '1.B.1.c', 'OI', 1.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.09', '1.B.1.d', 'OI', 2.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.09', '1.B.1.e', 'OI', 5.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.09', '1.B.1.f', 'OI', 5.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.09', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.09', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-1299.09', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2011.00', '1.B.1.a', 'OI', 1.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2011.00', '1.B.1.b', 'OI', 4.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2011.00', '1.B.1.c', 'OI', 1.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2011.00', '1.B.1.d', 'OI', 2.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2011.00', '1.B.1.e', 'OI', 3.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2011.00', '1.B.1.f', 'OI', 6.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2011.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2011.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2011.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2021.00', '1.B.1.a', 'OI', 3.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2021.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2021.00', '1.B.1.c', 'OI', 3.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2021.00', '1.B.1.d', 'OI', 1.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2021.00', '1.B.1.e', 'OI', 1.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2021.00', '1.B.1.f', 'OI', 5.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2021.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2021.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2031.00', '1.B.1.a', 'OI', 1.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2031.00', '1.B.1.b', 'OI', 6.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2031.00', '1.B.1.c', 'OI', 2.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2031.00', '1.B.1.d', 'OI', 2.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2031.00', '1.B.1.e', 'OI', 3.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2031.00', '1.B.1.f', 'OI', 5.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2031.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2031.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2031.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.00', '1.B.1.a', 'OI', 2.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.00', '1.B.1.b', 'OI', 6.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.00', '1.B.1.c', 'OI', 1.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.00', '1.B.1.d', 'OI', 1.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.00', '1.B.1.e', 'OI', 1.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.00', '1.B.1.f', 'OI', 6.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.01', '1.B.1.a', 'OI', 2.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.01', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.01', '1.B.1.c', 'OI', 2.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.01', '1.B.1.d', 'OI', 3.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.01', '1.B.1.e', 'OI', 1.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.01', '1.B.1.f', 'OI', 4.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2041.01', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.00', '1.B.1.a', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.00', '1.B.1.b', 'OI', 6.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.00', '1.B.1.c', 'OI', 2.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.00', '1.B.1.d', 'OI', 1.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.00', '1.B.1.e', 'OI', 1.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.00', '1.B.1.f', 'OI', 5.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.01', '1.B.1.a', 'OI', 1.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.01', '1.B.1.b', 'OI', 5.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.01', '1.B.1.c', 'OI', 1.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.01', '1.B.1.d', 'OI', 1.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.01', '1.B.1.e', 'OI', 4.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.01', '1.B.1.f', 'OI', 5.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.01', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.01', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.02', '1.B.1.a', 'OI', 1.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.02', '1.B.1.b', 'OI', 5.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.02', '1.B.1.c', 'OI', 1.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.02', '1.B.1.d', 'OI', 2.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.02', '1.B.1.e', 'OI', 3.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.02', '1.B.1.f', 'OI', 6.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.02', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.02', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2051.02', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2099.01', '1.B.1.a', 'OI', 3.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2099.01', '1.B.1.b', 'OI', 6.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2099.01', '1.B.1.c', 'OI', 1.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2099.01', '1.B.1.d', 'OI', 1.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2099.01', '1.B.1.e', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2099.01', '1.B.1.f', 'OI', 6.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2099.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2099.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('15-2099.01', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1011.00', '1.B.1.a', 'OI', 4.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1011.00', '1.B.1.b', 'OI', 3.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1011.00', '1.B.1.c', 'OI', 4.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1011.00', '1.B.1.d', 'OI', 2.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1011.00', '1.B.1.e', 'OI', 3.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1011.00', '1.B.1.f', 'OI', 4.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1011.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1011.00', '1.B.1.i', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1012.00', '1.B.1.a', 'OI', 5.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1012.00', '1.B.1.b', 'OI', 4.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1012.00', '1.B.1.c', 'OI', 4.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1012.00', '1.B.1.d', 'OI', 2.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1012.00', '1.B.1.e', 'OI', 3.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1012.00', '1.B.1.f', 'OI', 3.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1012.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1012.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1012.00', '1.B.1.i', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1021.00', '1.B.1.a', 'OI', 4.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1021.00', '1.B.1.b', 'OI', 5.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1021.00', '1.B.1.c', 'OI', 3.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1021.00', '1.B.1.d', 'OI', 1.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1021.00', '1.B.1.e', 'OI', 1.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1021.00', '1.B.1.f', 'OI', 5.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1021.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1021.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1021.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.00', '1.B.1.a', 'OI', 5.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.00', '1.B.1.b', 'OI', 4.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.00', '1.B.1.c', 'OI', 2.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.00', '1.B.1.d', 'OI', 1.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.00', '1.B.1.e', 'OI', 1.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.00', '1.B.1.f', 'OI', 5.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.01', '1.B.1.a', 'OI', 5.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.01', '1.B.1.b', 'OI', 5.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.01', '1.B.1.c', 'OI', 1.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.01', '1.B.1.d', 'OI', 1.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.01', '1.B.1.e', 'OI', 1.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.01', '1.B.1.f', 'OI', 5.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.01', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-1022.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2011.00', '1.B.1.a', 'OI', 5.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2011.00', '1.B.1.b', 'OI', 6.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2011.00', '1.B.1.c', 'OI', 2.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2011.00', '1.B.1.d', 'OI', 1.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2011.00', '1.B.1.e', 'OI', 2.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2011.00', '1.B.1.f', 'OI', 4.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2011.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2011.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2011.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2021.00', '1.B.1.a', 'OI', 6.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2021.00', '1.B.1.b', 'OI', 6.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2021.00', '1.B.1.c', 'OI', 2.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2021.00', '1.B.1.d', 'OI', 1.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2021.00', '1.B.1.e', 'OI', 2.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2021.00', '1.B.1.f', 'OI', 3.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2021.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2021.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2031.00', '1.B.1.a', 'OI', 5.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2031.00', '1.B.1.b', 'OI', 6.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2031.00', '1.B.1.c', 'OI', 2.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2031.00', '1.B.1.d', 'OI', 2.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2031.00', '1.B.1.e', 'OI', 1.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2031.00', '1.B.1.f', 'OI', 4.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2031.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2031.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2031.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2041.00', '1.B.1.a', 'OI', 6.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2041.00', '1.B.1.b', 'OI', 5.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2041.00', '1.B.1.c', 'OI', 1.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2041.00', '1.B.1.d', 'OI', 1.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2041.00', '1.B.1.e', 'OI', 1.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2041.00', '1.B.1.f', 'OI', 4.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2041.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2041.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2041.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.00', '1.B.1.a', 'OI', 6.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.00', '1.B.1.b', 'OI', 5.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.00', '1.B.1.c', 'OI', 2.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.00', '1.B.1.d', 'OI', 1.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.00', '1.B.1.e', 'OI', 2.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.00', '1.B.1.f', 'OI', 4.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.01', '1.B.1.a', 'OI', 5.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.01', '1.B.1.b', 'OI', 5.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.01', '1.B.1.c', 'OI', 2.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.01', '1.B.1.d', 'OI', 1.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.01', '1.B.1.e', 'OI', 3.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.01', '1.B.1.f', 'OI', 4.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.01', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.02', '1.B.1.a', 'OI', 5.62, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.02', '1.B.1.b', 'OI', 5.35, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.02', '1.B.1.c', 'OI', 1.85, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.02', '1.B.1.d', 'OI', 1.76, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.02', '1.B.1.e', 'OI', 2.90, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.02', '1.B.1.f', 'OI', 4.53, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.02', '1.B.1.g', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.02', '1.B.1.h', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2051.02', '1.B.1.i', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2061.00', '1.B.1.a', 'OI', 5.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2061.00', '1.B.1.b', 'OI', 5.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2061.00', '1.B.1.c', 'OI', 1.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2061.00', '1.B.1.d', 'OI', 1.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2061.00', '1.B.1.e', 'OI', 1.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2061.00', '1.B.1.f', 'OI', 5.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2061.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2061.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2061.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2071.00', '1.B.1.a', 'OI', 6.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2071.00', '1.B.1.b', 'OI', 5.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2071.00', '1.B.1.c', 'OI', 2.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2071.00', '1.B.1.d', 'OI', 1.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2071.00', '1.B.1.e', 'OI', 2.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2071.00', '1.B.1.f', 'OI', 4.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2071.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2071.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2071.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.00', '1.B.1.a', 'OI', 6.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.00', '1.B.1.b', 'OI', 5.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.00', '1.B.1.c', 'OI', 2.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.00', '1.B.1.d', 'OI', 1.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.00', '1.B.1.e', 'OI', 1.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.00', '1.B.1.f', 'OI', 4.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.01', '1.B.1.a', 'OI', 5.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.01', '1.B.1.b', 'OI', 4.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.01', '1.B.1.c', 'OI', 1.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.01', '1.B.1.d', 'OI', 1.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.01', '1.B.1.e', 'OI', 1.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.01', '1.B.1.f', 'OI', 5.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.01', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.01', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2072.01', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2081.00', '1.B.1.a', 'OI', 5.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2081.00', '1.B.1.b', 'OI', 6.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2081.00', '1.B.1.c', 'OI', 1.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2081.00', '1.B.1.d', 'OI', 2.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2081.00', '1.B.1.e', 'OI', 3.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2081.00', '1.B.1.f', 'OI', 4.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2081.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2081.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2081.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.00', '1.B.1.a', 'OI', 5.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.00', '1.B.1.b', 'OI', 5.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.00', '1.B.1.c', 'OI', 1.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.00', '1.B.1.d', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.00', '1.B.1.e', 'OI', 2.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.00', '1.B.1.f', 'OI', 4.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.02', '1.B.1.a', 'OI', 6.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.02', '1.B.1.b', 'OI', 5.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.02', '1.B.1.c', 'OI', 1.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.02', '1.B.1.d', 'OI', 2.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.02', '1.B.1.e', 'OI', 2.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.02', '1.B.1.f', 'OI', 4.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.02', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.02', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2111.02', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.00', '1.B.1.a', 'OI', 4.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.00', '1.B.1.b', 'OI', 4.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.00', '1.B.1.c', 'OI', 1.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.00', '1.B.1.d', 'OI', 1.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.00', '1.B.1.e', 'OI', 3.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.00', '1.B.1.f', 'OI', 5.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.01', '1.B.1.a', 'OI', 4.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.01', '1.B.1.b', 'OI', 6.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.01', '1.B.1.c', 'OI', 2.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.01', '1.B.1.d', 'OI', 2.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.01', '1.B.1.e', 'OI', 2.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.01', '1.B.1.f', 'OI', 4.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.01', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.02', '1.B.1.a', 'OI', 4.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.02', '1.B.1.b', 'OI', 5.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.02', '1.B.1.c', 'OI', 1.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.02', '1.B.1.d', 'OI', 1.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.02', '1.B.1.e', 'OI', 2.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.02', '1.B.1.f', 'OI', 5.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.02', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.02', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.02', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.03', '1.B.1.a', 'OI', 5.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.03', '1.B.1.b', 'OI', 4.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.03', '1.B.1.c', 'OI', 2.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.03', '1.B.1.d', 'OI', 1.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.03', '1.B.1.e', 'OI', 3.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.03', '1.B.1.f', 'OI', 4.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.03', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.03', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2112.03', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2121.00', '1.B.1.a', 'OI', 5.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2121.00', '1.B.1.b', 'OI', 5.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2121.00', '1.B.1.c', 'OI', 2.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2121.00', '1.B.1.d', 'OI', 1.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2121.00', '1.B.1.e', 'OI', 3.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2121.00', '1.B.1.f', 'OI', 4.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2121.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2121.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2121.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2131.00', '1.B.1.a', 'OI', 5.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2131.00', '1.B.1.b', 'OI', 5.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2131.00', '1.B.1.c', 'OI', 2.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2131.00', '1.B.1.d', 'OI', 1.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2131.00', '1.B.1.e', 'OI', 2.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2131.00', '1.B.1.f', 'OI', 4.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2131.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2131.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2131.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.00', '1.B.1.a', 'OI', 6.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.00', '1.B.1.b', 'OI', 5.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.00', '1.B.1.c', 'OI', 2.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.00', '1.B.1.d', 'OI', 1.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.00', '1.B.1.e', 'OI', 1.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.00', '1.B.1.f', 'OI', 4.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.01', '1.B.1.a', 'OI', 5.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.01', '1.B.1.b', 'OI', 5.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.01', '1.B.1.c', 'OI', 1.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.01', '1.B.1.d', 'OI', 1.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.01', '1.B.1.e', 'OI', 2.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.01', '1.B.1.f', 'OI', 4.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.01', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.02', '1.B.1.a', 'OI', 6.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.02', '1.B.1.b', 'OI', 5.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.02', '1.B.1.c', 'OI', 2.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.02', '1.B.1.d', 'OI', 1.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.02', '1.B.1.e', 'OI', 2.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.02', '1.B.1.f', 'OI', 4.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.02', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.02', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2141.02', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2151.00', '1.B.1.a', 'OI', 6.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2151.00', '1.B.1.b', 'OI', 5.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2151.00', '1.B.1.c', 'OI', 1.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2151.00', '1.B.1.d', 'OI', 1.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2151.00', '1.B.1.e', 'OI', 2.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2151.00', '1.B.1.f', 'OI', 4.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2151.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2151.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2151.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2161.00', '1.B.1.a', 'OI', 4.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2161.00', '1.B.1.b', 'OI', 6.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2161.00', '1.B.1.c', 'OI', 2.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2161.00', '1.B.1.d', 'OI', 1.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2161.00', '1.B.1.e', 'OI', 2.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2161.00', '1.B.1.f', 'OI', 4.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2161.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2161.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2161.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2171.00', '1.B.1.a', 'OI', 5.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2171.00', '1.B.1.b', 'OI', 5.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2171.00', '1.B.1.c', 'OI', 1.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2171.00', '1.B.1.d', 'OI', 1.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2171.00', '1.B.1.e', 'OI', 3.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2171.00', '1.B.1.f', 'OI', 4.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2171.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2171.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2171.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.03', '1.B.1.a', 'OI', 5.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.03', '1.B.1.b', 'OI', 4.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.03', '1.B.1.c', 'OI', 2.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.03', '1.B.1.d', 'OI', 2.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.03', '1.B.1.e', 'OI', 3.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.03', '1.B.1.f', 'OI', 4.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.03', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.03', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.03', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.05', '1.B.1.a', 'OI', 5.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.05', '1.B.1.b', 'OI', 5.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.05', '1.B.1.c', 'OI', 2.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.05', '1.B.1.d', 'OI', 1.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.05', '1.B.1.e', 'OI', 1.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.05', '1.B.1.f', 'OI', 4.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.05', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.05', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.05', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.06', '1.B.1.a', 'OI', 5.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.06', '1.B.1.b', 'OI', 6.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.06', '1.B.1.c', 'OI', 1.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.06', '1.B.1.d', 'OI', 1.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.06', '1.B.1.e', 'OI', 1.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.06', '1.B.1.f', 'OI', 4.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.06', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.06', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.06', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.07', '1.B.1.a', 'OI', 5.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.07', '1.B.1.b', 'OI', 5.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.07', '1.B.1.c', 'OI', 2.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.07', '1.B.1.d', 'OI', 1.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.07', '1.B.1.e', 'OI', 1.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.07', '1.B.1.f', 'OI', 3.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.07', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.07', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.07', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.08', '1.B.1.a', 'OI', 6.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.08', '1.B.1.b', 'OI', 5.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.08', '1.B.1.c', 'OI', 1.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.08', '1.B.1.d', 'OI', 1.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.08', '1.B.1.e', 'OI', 1.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.08', '1.B.1.f', 'OI', 4.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.08', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.08', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.08', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.09', '1.B.1.a', 'OI', 5.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.09', '1.B.1.b', 'OI', 6.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.09', '1.B.1.c', 'OI', 2.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.09', '1.B.1.d', 'OI', 1.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.09', '1.B.1.e', 'OI', 2.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.09', '1.B.1.f', 'OI', 4.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.09', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.09', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.09', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.10', '1.B.1.a', 'OI', 5.90, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.10', '1.B.1.b', 'OI', 4.54, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.10', '1.B.1.c', 'OI', 2.22, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.10', '1.B.1.d', 'OI', 1.43, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.10', '1.B.1.e', 'OI', 3.12, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.10', '1.B.1.f', 'OI', 4.12, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.10', '1.B.1.g', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.10', '1.B.1.h', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.10', '1.B.1.i', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.11', '1.B.1.a', 'OI', 5.97, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.11', '1.B.1.b', 'OI', 5.02, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.11', '1.B.1.c', 'OI', 2.11, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.11', '1.B.1.d', 'OI', 1.90, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.11', '1.B.1.e', 'OI', 3.05, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.11', '1.B.1.f', 'OI', 3.96, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.11', '1.B.1.g', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.11', '1.B.1.h', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-2199.11', '1.B.1.i', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3011.00', '1.B.1.a', 'OI', 5.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3011.00', '1.B.1.b', 'OI', 4.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3011.00', '1.B.1.c', 'OI', 4.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3011.00', '1.B.1.d', 'OI', 1.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3011.00', '1.B.1.e', 'OI', 1.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3011.00', '1.B.1.f', 'OI', 4.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3011.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3011.00', '1.B.1.i', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3012.00', '1.B.1.a', 'OI', 5.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3012.00', '1.B.1.b', 'OI', 3.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3012.00', '1.B.1.c', 'OI', 3.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3012.00', '1.B.1.d', 'OI', 1.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3012.00', '1.B.1.e', 'OI', 1.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3012.00', '1.B.1.f', 'OI', 5.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3012.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3012.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3012.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3013.00', '1.B.1.a', 'OI', 5.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3013.00', '1.B.1.b', 'OI', 3.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3013.00', '1.B.1.c', 'OI', 3.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3013.00', '1.B.1.d', 'OI', 1.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3013.00', '1.B.1.e', 'OI', 1.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3013.00', '1.B.1.f', 'OI', 4.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3013.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3013.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3013.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3021.00', '1.B.1.a', 'OI', 6.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3021.00', '1.B.1.b', 'OI', 5.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3021.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3021.00', '1.B.1.d', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3021.00', '1.B.1.e', 'OI', 1.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3021.00', '1.B.1.f', 'OI', 5.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3021.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3021.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3021.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3022.00', '1.B.1.a', 'OI', 5.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3022.00', '1.B.1.b', 'OI', 5.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3022.00', '1.B.1.c', 'OI', 2.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3022.00', '1.B.1.d', 'OI', 1.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3022.00', '1.B.1.e', 'OI', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3022.00', '1.B.1.f', 'OI', 5.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3022.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3022.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3022.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3023.00', '1.B.1.a', 'OI', 6.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3023.00', '1.B.1.b', 'OI', 5.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3023.00', '1.B.1.c', 'OI', 1.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3023.00', '1.B.1.d', 'OI', 1.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3023.00', '1.B.1.e', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3023.00', '1.B.1.f', 'OI', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3023.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3023.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3023.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.00', '1.B.1.a', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.00', '1.B.1.b', 'OI', 4.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.00', '1.B.1.c', 'OI', 1.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.00', '1.B.1.d', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.00', '1.B.1.e', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.00', '1.B.1.f', 'OI', 4.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.01', '1.B.1.a', 'OI', 6.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.01', '1.B.1.b', 'OI', 3.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.01', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.01', '1.B.1.d', 'OI', 1.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.01', '1.B.1.e', 'OI', 1.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.01', '1.B.1.f', 'OI', 4.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.01', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3024.01', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3025.00', '1.B.1.a', 'OI', 6.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3025.00', '1.B.1.b', 'OI', 5.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3025.00', '1.B.1.c', 'OI', 1.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3025.00', '1.B.1.d', 'OI', 1.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3025.00', '1.B.1.e', 'OI', 1.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3025.00', '1.B.1.f', 'OI', 4.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3025.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3025.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3025.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.00', '1.B.1.a', 'OI', 5.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.00', '1.B.1.b', 'OI', 5.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.00', '1.B.1.c', 'OI', 1.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.00', '1.B.1.d', 'OI', 1.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.00', '1.B.1.e', 'OI', 2.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.00', '1.B.1.f', 'OI', 5.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.01', '1.B.1.a', 'OI', 6.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.01', '1.B.1.b', 'OI', 4.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.01', '1.B.1.c', 'OI', 1.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.01', '1.B.1.d', 'OI', 1.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.01', '1.B.1.e', 'OI', 2.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.01', '1.B.1.f', 'OI', 4.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.01', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3026.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.00', '1.B.1.a', 'OI', 6.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.00', '1.B.1.b', 'OI', 5.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.00', '1.B.1.c', 'OI', 2.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.00', '1.B.1.d', 'OI', 1.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.00', '1.B.1.e', 'OI', 1.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.00', '1.B.1.f', 'OI', 4.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.01', '1.B.1.a', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.01', '1.B.1.b', 'OI', 5.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.01', '1.B.1.c', 'OI', 1.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.01', '1.B.1.d', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.01', '1.B.1.e', 'OI', 1.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.01', '1.B.1.f', 'OI', 4.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.01', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3027.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3028.00', '1.B.1.a', 'OI', 6.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3028.00', '1.B.1.b', 'OI', 4.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3028.00', '1.B.1.c', 'OI', 1.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3028.00', '1.B.1.d', 'OI', 1.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3028.00', '1.B.1.e', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3028.00', '1.B.1.f', 'OI', 5.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3028.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3028.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3028.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.01', '1.B.1.a', 'OI', 6.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.01', '1.B.1.b', 'OI', 4.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.01', '1.B.1.c', 'OI', 1.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.01', '1.B.1.d', 'OI', 1.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.01', '1.B.1.e', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.01', '1.B.1.f', 'OI', 4.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.01', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.08', '1.B.1.a', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.08', '1.B.1.b', 'OI', 4.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.08', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.08', '1.B.1.d', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.08', '1.B.1.e', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.08', '1.B.1.f', 'OI', 5.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.08', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.08', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3029.08', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3031.00', '1.B.1.a', 'OI', 5.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3031.00', '1.B.1.b', 'OI', 4.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3031.00', '1.B.1.c', 'OI', 1.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3031.00', '1.B.1.d', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3031.00', '1.B.1.e', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3031.00', '1.B.1.f', 'OI', 5.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3031.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3031.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('17-3031.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1011.00', '1.B.1.a', 'OI', 5.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1011.00', '1.B.1.b', 'OI', 6.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1011.00', '1.B.1.c', 'OI', 1.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1011.00', '1.B.1.d', 'OI', 1.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1011.00', '1.B.1.e', 'OI', 2.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1011.00', '1.B.1.f', 'OI', 3.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1011.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1011.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1011.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1012.00', '1.B.1.a', 'OI', 5.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1012.00', '1.B.1.b', 'OI', 5.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1012.00', '1.B.1.c', 'OI', 2.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1012.00', '1.B.1.d', 'OI', 2.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1012.00', '1.B.1.e', 'OI', 2.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1012.00', '1.B.1.f', 'OI', 3.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1012.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1012.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1012.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1013.00', '1.B.1.a', 'OI', 6.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1013.00', '1.B.1.b', 'OI', 6.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1013.00', '1.B.1.c', 'OI', 2.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1013.00', '1.B.1.d', 'OI', 1.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1013.00', '1.B.1.e', 'OI', 1.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1013.00', '1.B.1.f', 'OI', 3.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1013.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1013.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1013.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1021.00', '1.B.1.a', 'OI', 5.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1021.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1021.00', '1.B.1.c', 'OI', 2.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1021.00', '1.B.1.d', 'OI', 2.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1021.00', '1.B.1.e', 'OI', 1.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1021.00', '1.B.1.f', 'OI', 3.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1021.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1021.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1022.00', '1.B.1.a', 'OI', 5.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1022.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1022.00', '1.B.1.c', 'OI', 1.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1022.00', '1.B.1.d', 'OI', 1.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1022.00', '1.B.1.e', 'OI', 1.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1022.00', '1.B.1.f', 'OI', 3.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1022.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1022.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1022.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1023.00', '1.B.1.a', 'OI', 5.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1023.00', '1.B.1.b', 'OI', 6.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1023.00', '1.B.1.c', 'OI', 2.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1023.00', '1.B.1.d', 'OI', 2.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1023.00', '1.B.1.e', 'OI', 2.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1023.00', '1.B.1.f', 'OI', 3.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1023.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1023.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1023.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.01', '1.B.1.a', 'OI', 3.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.01', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.01', '1.B.1.c', 'OI', 2.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.01', '1.B.1.d', 'OI', 1.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.01', '1.B.1.e', 'OI', 1.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.01', '1.B.1.f', 'OI', 5.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.01', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.02', '1.B.1.a', 'OI', 5.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.02', '1.B.1.b', 'OI', 6.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.02', '1.B.1.c', 'OI', 1.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.02', '1.B.1.d', 'OI', 2.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.02', '1.B.1.e', 'OI', 2.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.02', '1.B.1.f', 'OI', 5.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.02', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.02', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.02', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.03', '1.B.1.a', 'OI', 4.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.03', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.03', '1.B.1.c', 'OI', 2.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.03', '1.B.1.d', 'OI', 2.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.03', '1.B.1.e', 'OI', 1.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.03', '1.B.1.f', 'OI', 4.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.03', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.03', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.03', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.04', '1.B.1.a', 'OI', 4.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.04', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.04', '1.B.1.c', 'OI', 2.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.04', '1.B.1.d', 'OI', 2.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.04', '1.B.1.e', 'OI', 2.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.04', '1.B.1.f', 'OI', 4.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.04', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.04', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1029.04', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.00', '1.B.1.a', 'OI', 5.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.00', '1.B.1.b', 'OI', 5.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.00', '1.B.1.c', 'OI', 1.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.00', '1.B.1.d', 'OI', 2.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.00', '1.B.1.e', 'OI', 3.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.00', '1.B.1.f', 'OI', 3.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.02', '1.B.1.a', 'OI', 5.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.02', '1.B.1.b', 'OI', 5.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.02', '1.B.1.c', 'OI', 1.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.02', '1.B.1.d', 'OI', 2.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.02', '1.B.1.e', 'OI', 4.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.02', '1.B.1.f', 'OI', 3.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.02', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.02', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.02', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.03', '1.B.1.a', 'OI', 4.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.03', '1.B.1.b', 'OI', 4.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.03', '1.B.1.c', 'OI', 3.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.03', '1.B.1.d', 'OI', 4.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.03', '1.B.1.e', 'OI', 3.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.03', '1.B.1.f', 'OI', 3.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.03', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.03', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1031.03', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1032.00', '1.B.1.a', 'OI', 5.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1032.00', '1.B.1.b', 'OI', 4.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1032.00', '1.B.1.c', 'OI', 1.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1032.00', '1.B.1.d', 'OI', 2.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1032.00', '1.B.1.e', 'OI', 3.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1032.00', '1.B.1.f', 'OI', 4.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1032.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1032.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1032.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1041.00', '1.B.1.a', 'OI', 2.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1041.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1041.00', '1.B.1.c', 'OI', 2.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1041.00', '1.B.1.d', 'OI', 4.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1041.00', '1.B.1.e', 'OI', 2.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1041.00', '1.B.1.f', 'OI', 3.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1041.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1041.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1041.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1042.00', '1.B.1.a', 'OI', 4.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1042.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1042.00', '1.B.1.c', 'OI', 2.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1042.00', '1.B.1.d', 'OI', 3.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1042.00', '1.B.1.e', 'OI', 2.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1042.00', '1.B.1.f', 'OI', 3.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1042.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1042.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-1042.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2011.00', '1.B.1.a', 'OI', 5.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2011.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2011.00', '1.B.1.c', 'OI', 3.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2011.00', '1.B.1.d', 'OI', 2.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2011.00', '1.B.1.e', 'OI', 1.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2011.00', '1.B.1.f', 'OI', 4.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2011.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2011.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2011.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2012.00', '1.B.1.a', 'OI', 4.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2012.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2012.00', '1.B.1.c', 'OI', 2.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2012.00', '1.B.1.d', 'OI', 2.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2012.00', '1.B.1.e', 'OI', 1.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2012.00', '1.B.1.f', 'OI', 4.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2012.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2012.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2012.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2021.00', '1.B.1.a', 'OI', 4.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2021.00', '1.B.1.b', 'OI', 6.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2021.00', '1.B.1.c', 'OI', 2.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2021.00', '1.B.1.d', 'OI', 2.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2021.00', '1.B.1.e', 'OI', 2.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2021.00', '1.B.1.f', 'OI', 4.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2021.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2021.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2021.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2031.00', '1.B.1.a', 'OI', 5.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2031.00', '1.B.1.b', 'OI', 6.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2031.00', '1.B.1.c', 'OI', 1.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2031.00', '1.B.1.d', 'OI', 1.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2031.00', '1.B.1.e', 'OI', 1.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2031.00', '1.B.1.f', 'OI', 4.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2031.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2031.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2031.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2032.00', '1.B.1.a', 'OI', 5.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2032.00', '1.B.1.b', 'OI', 6.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2032.00', '1.B.1.c', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2032.00', '1.B.1.d', 'OI', 1.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2032.00', '1.B.1.e', 'OI', 1.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2032.00', '1.B.1.f', 'OI', 4.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2032.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2032.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2032.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.00', '1.B.1.a', 'OI', 4.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.00', '1.B.1.c', 'OI', 1.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.00', '1.B.1.d', 'OI', 2.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.00', '1.B.1.e', 'OI', 2.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.00', '1.B.1.f', 'OI', 4.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.01', '1.B.1.a', 'OI', 1.37, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.01', '1.B.1.b', 'OI', 6.73, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.01', '1.B.1.c', 'OI', 3.11, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.01', '1.B.1.d', 'OI', 3.17, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.01', '1.B.1.e', 'OI', 4.69, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.01', '1.B.1.f', 'OI', 4.06, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.01', '1.B.1.h', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.02', '1.B.1.a', 'OI', 5.31, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.02', '1.B.1.b', 'OI', 6.25, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.02', '1.B.1.c', 'OI', 2.24, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.02', '1.B.1.d', 'OI', 2.12, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.02', '1.B.1.e', 'OI', 3.63, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.02', '1.B.1.f', 'OI', 4.13, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.02', '1.B.1.g', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.02', '1.B.1.h', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.02', '1.B.1.i', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.03', '1.B.1.a', 'OI', 4.62, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.03', '1.B.1.b', 'OI', 7.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.03', '1.B.1.c', 'OI', 2.14, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.03', '1.B.1.d', 'OI', 1.95, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.03', '1.B.1.e', 'OI', 3.04, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.03', '1.B.1.f', 'OI', 3.98, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.03', '1.B.1.g', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.03', '1.B.1.h', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2041.03', '1.B.1.i', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2042.00', '1.B.1.a', 'OI', 5.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2042.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2042.00', '1.B.1.c', 'OI', 2.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2042.00', '1.B.1.d', 'OI', 2.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2042.00', '1.B.1.e', 'OI', 1.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2042.00', '1.B.1.f', 'OI', 4.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2042.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2042.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2042.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2043.00', '1.B.1.a', 'OI', 5.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2043.00', '1.B.1.b', 'OI', 6.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2043.00', '1.B.1.c', 'OI', 1.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2043.00', '1.B.1.d', 'OI', 2.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2043.00', '1.B.1.e', 'OI', 2.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2043.00', '1.B.1.f', 'OI', 4.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2043.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2043.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2043.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2099.01', '1.B.1.a', 'OI', 4.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2099.01', '1.B.1.b', 'OI', 6.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2099.01', '1.B.1.c', 'OI', 1.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2099.01', '1.B.1.d', 'OI', 1.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2099.01', '1.B.1.e', 'OI', 1.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2099.01', '1.B.1.f', 'OI', 4.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2099.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2099.01', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-2099.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.00', '1.B.1.a', 'OI', 1.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.00', '1.B.1.c', 'OI', 2.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.00', '1.B.1.d', 'OI', 2.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.00', '1.B.1.e', 'OI', 3.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.00', '1.B.1.f', 'OI', 4.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.01', '1.B.1.a', 'OI', 2.74, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.01', '1.B.1.b', 'OI', 7.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.01', '1.B.1.c', 'OI', 2.53, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.01', '1.B.1.d', 'OI', 2.28, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.01', '1.B.1.e', 'OI', 4.11, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.01', '1.B.1.f', 'OI', 4.08, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.01', '1.B.1.h', 'IH', 5.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3011.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3022.00', '1.B.1.a', 'OI', 1.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3022.00', '1.B.1.b', 'OI', 6.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3022.00', '1.B.1.c', 'OI', 2.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3022.00', '1.B.1.d', 'OI', 2.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3022.00', '1.B.1.e', 'OI', 3.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3022.00', '1.B.1.f', 'OI', 5.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3022.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3022.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3022.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3032.00', '1.B.1.a', 'OI', 1.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3032.00', '1.B.1.b', 'OI', 5.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3032.00', '1.B.1.c', 'OI', 3.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3032.00', '1.B.1.d', 'OI', 3.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3032.00', '1.B.1.e', 'OI', 4.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3032.00', '1.B.1.f', 'OI', 4.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3032.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3032.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3032.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3033.00', '1.B.1.a', 'OI', 1.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3033.00', '1.B.1.b', 'OI', 5.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3033.00', '1.B.1.c', 'OI', 3.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3033.00', '1.B.1.d', 'OI', 6.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3033.00', '1.B.1.e', 'OI', 2.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3033.00', '1.B.1.f', 'OI', 3.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3033.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3033.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3033.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3034.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3034.00', '1.B.1.b', 'OI', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3034.00', '1.B.1.c', 'OI', 3.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3034.00', '1.B.1.d', 'OI', 6.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3034.00', '1.B.1.e', 'OI', 2.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3034.00', '1.B.1.f', 'OI', 4.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3034.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3034.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3034.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.02', '1.B.1.a', 'OI', 2.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.02', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.02', '1.B.1.c', 'OI', 3.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.02', '1.B.1.d', 'OI', 5.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.02', '1.B.1.e', 'OI', 1.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.02', '1.B.1.f', 'OI', 3.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.02', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.02', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.02', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.03', '1.B.1.a', 'OI', 2.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.03', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.03', '1.B.1.c', 'OI', 2.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.03', '1.B.1.d', 'OI', 5.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.03', '1.B.1.e', 'OI', 2.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.03', '1.B.1.f', 'OI', 3.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.03', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.03', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3039.03', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3041.00', '1.B.1.a', 'OI', 1.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3041.00', '1.B.1.b', 'OI', 6.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3041.00', '1.B.1.c', 'OI', 3.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3041.00', '1.B.1.d', 'OI', 4.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3041.00', '1.B.1.e', 'OI', 3.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3041.00', '1.B.1.f', 'OI', 3.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3041.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3041.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3041.00', '1.B.1.i', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3051.00', '1.B.1.a', 'OI', 3.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3051.00', '1.B.1.b', 'OI', 5.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3051.00', '1.B.1.c', 'OI', 3.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3051.00', '1.B.1.d', 'OI', 3.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3051.00', '1.B.1.e', 'OI', 4.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3051.00', '1.B.1.f', 'OI', 3.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3051.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3051.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3051.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3091.00', '1.B.1.a', 'OI', 3.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3091.00', '1.B.1.b', 'OI', 6.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3091.00', '1.B.1.c', 'OI', 4.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3091.00', '1.B.1.d', 'OI', 3.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3091.00', '1.B.1.e', 'OI', 1.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3091.00', '1.B.1.f', 'OI', 3.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3091.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3091.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3091.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3092.00', '1.B.1.a', 'OI', 5.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3092.00', '1.B.1.b', 'OI', 6.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3092.00', '1.B.1.c', 'OI', 3.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3092.00', '1.B.1.d', 'OI', 2.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3092.00', '1.B.1.e', 'OI', 2.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3092.00', '1.B.1.f', 'OI', 3.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3092.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3092.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3092.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3093.00', '1.B.1.a', 'OI', 2.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3093.00', '1.B.1.b', 'OI', 5.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3093.00', '1.B.1.c', 'OI', 3.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3093.00', '1.B.1.d', 'OI', 3.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3093.00', '1.B.1.e', 'OI', 2.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3093.00', '1.B.1.f', 'OI', 4.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3093.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3093.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3093.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3094.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3094.00', '1.B.1.b', 'OI', 6.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3094.00', '1.B.1.c', 'OI', 3.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3094.00', '1.B.1.d', 'OI', 3.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3094.00', '1.B.1.e', 'OI', 3.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3094.00', '1.B.1.f', 'OI', 3.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3094.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3094.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3094.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3099.01', '1.B.1.a', 'OI', 3.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3099.01', '1.B.1.b', 'OI', 5.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3099.01', '1.B.1.c', 'OI', 2.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3099.01', '1.B.1.d', 'OI', 1.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3099.01', '1.B.1.e', 'OI', 3.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3099.01', '1.B.1.f', 'OI', 4.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3099.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3099.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-3099.01', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.00', '1.B.1.a', 'OI', 6.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.00', '1.B.1.b', 'OI', 4.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.00', '1.B.1.d', 'OI', 1.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.00', '1.B.1.e', 'OI', 1.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.00', '1.B.1.f', 'OI', 4.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.01', '1.B.1.a', 'OI', 6.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.01', '1.B.1.b', 'OI', 5.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.01', '1.B.1.c', 'OI', 1.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.01', '1.B.1.d', 'OI', 1.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.01', '1.B.1.e', 'OI', 2.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.01', '1.B.1.f', 'OI', 4.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.01', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4012.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4013.00', '1.B.1.a', 'OI', 5.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4013.00', '1.B.1.b', 'OI', 4.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4013.00', '1.B.1.c', 'OI', 1.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4013.00', '1.B.1.d', 'OI', 1.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4013.00', '1.B.1.e', 'OI', 1.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4013.00', '1.B.1.f', 'OI', 5.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4013.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4013.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4013.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4021.00', '1.B.1.a', 'OI', 5.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4021.00', '1.B.1.b', 'OI', 5.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4021.00', '1.B.1.c', 'OI', 1.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4021.00', '1.B.1.d', 'OI', 1.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4021.00', '1.B.1.e', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4021.00', '1.B.1.f', 'OI', 5.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4021.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4021.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4021.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4031.00', '1.B.1.a', 'OI', 5.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4031.00', '1.B.1.b', 'OI', 5.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4031.00', '1.B.1.c', 'OI', 1.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4031.00', '1.B.1.d', 'OI', 1.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4031.00', '1.B.1.e', 'OI', 1.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4031.00', '1.B.1.f', 'OI', 5.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4031.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4031.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4031.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4042.00', '1.B.1.a', 'OI', 5.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4042.00', '1.B.1.b', 'OI', 5.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4042.00', '1.B.1.c', 'OI', 1.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4042.00', '1.B.1.d', 'OI', 1.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4042.00', '1.B.1.e', 'OI', 1.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4042.00', '1.B.1.f', 'OI', 4.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4042.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4042.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4042.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4043.00', '1.B.1.a', 'OI', 5.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4043.00', '1.B.1.b', 'OI', 5.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4043.00', '1.B.1.c', 'OI', 1.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4043.00', '1.B.1.d', 'OI', 1.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4043.00', '1.B.1.e', 'OI', 1.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4043.00', '1.B.1.f', 'OI', 5.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4043.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4043.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4043.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4044.00', '1.B.1.a', 'OI', 5.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4044.00', '1.B.1.b', 'OI', 4.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4044.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4044.00', '1.B.1.d', 'OI', 1.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4044.00', '1.B.1.e', 'OI', 1.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4044.00', '1.B.1.f', 'OI', 5.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4044.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4044.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4044.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.00', '1.B.1.a', 'OI', 5.75, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.00', '1.B.1.b', 'OI', 4.57, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.00', '1.B.1.d', 'OI', 1.83, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.00', '1.B.1.e', 'OI', 2.26, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.00', '1.B.1.f', 'OI', 5.07, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2023-11-01', 'yyyy-mm-dd'), 'Machine Learning');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.02', '1.B.1.a', 'OI', 6.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.02', '1.B.1.b', 'OI', 4.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.02', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.02', '1.B.1.d', 'OI', 1.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.02', '1.B.1.e', 'OI', 1.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.02', '1.B.1.f', 'OI', 5.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.02', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.02', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4051.02', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4061.00', '1.B.1.a', 'OI', 2.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4061.00', '1.B.1.b', 'OI', 6.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4061.00', '1.B.1.c', 'OI', 1.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4061.00', '1.B.1.d', 'OI', 2.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4061.00', '1.B.1.e', 'OI', 2.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4061.00', '1.B.1.f', 'OI', 5.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4061.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4061.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4061.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4071.00', '1.B.1.a', 'OI', 6.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4071.00', '1.B.1.b', 'OI', 4.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4071.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4071.00', '1.B.1.d', 'OI', 2.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4071.00', '1.B.1.e', 'OI', 2.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4071.00', '1.B.1.f', 'OI', 4.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4071.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4071.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4071.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4092.00', '1.B.1.a', 'OI', 5.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4092.00', '1.B.1.b', 'OI', 5.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4092.00', '1.B.1.c', 'OI', 1.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4092.00', '1.B.1.d', 'OI', 1.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4092.00', '1.B.1.e', 'OI', 1.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4092.00', '1.B.1.f', 'OI', 4.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4092.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4092.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4092.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.01', '1.B.1.a', 'OI', 4.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.01', '1.B.1.b', 'OI', 4.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.01', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.01', '1.B.1.d', 'OI', 1.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.01', '1.B.1.e', 'OI', 2.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.01', '1.B.1.f', 'OI', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.01', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.01', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.03', '1.B.1.a', 'OI', 5.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.03', '1.B.1.b', 'OI', 4.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.03', '1.B.1.c', 'OI', 2.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.03', '1.B.1.d', 'OI', 1.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.03', '1.B.1.e', 'OI', 1.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.03', '1.B.1.f', 'OI', 5.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.03', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.03', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-4099.03', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5011.00', '1.B.1.a', 'OI', 4.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5011.00', '1.B.1.b', 'OI', 4.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5011.00', '1.B.1.c', 'OI', 1.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5011.00', '1.B.1.d', 'OI', 3.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5011.00', '1.B.1.e', 'OI', 3.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5011.00', '1.B.1.f', 'OI', 4.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5011.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5011.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5012.00', '1.B.1.a', 'OI', 5.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5012.00', '1.B.1.b', 'OI', 4.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5012.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5012.00', '1.B.1.d', 'OI', 2.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5012.00', '1.B.1.e', 'OI', 2.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5012.00', '1.B.1.f', 'OI', 5.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5012.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5012.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('19-5012.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1011.00', '1.B.1.a', 'OI', 1.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1011.00', '1.B.1.b', 'OI', 3.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1011.00', '1.B.1.c', 'OI', 2.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1011.00', '1.B.1.d', 'OI', 6.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1011.00', '1.B.1.e', 'OI', 2.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1011.00', '1.B.1.f', 'OI', 3.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1011.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1011.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1011.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1012.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1012.00', '1.B.1.b', 'OI', 3.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1012.00', '1.B.1.c', 'OI', 3.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1012.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1012.00', '1.B.1.e', 'OI', 3.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1012.00', '1.B.1.f', 'OI', 4.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1012.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1012.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1012.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1013.00', '1.B.1.a', 'OI', 1.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1013.00', '1.B.1.b', 'OI', 5.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1013.00', '1.B.1.c', 'OI', 3.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1013.00', '1.B.1.d', 'OI', 6.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1013.00', '1.B.1.e', 'OI', 1.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1013.00', '1.B.1.f', 'OI', 2.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1013.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1013.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1013.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1014.00', '1.B.1.a', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1014.00', '1.B.1.b', 'OI', 4.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1014.00', '1.B.1.c', 'OI', 3.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1014.00', '1.B.1.d', 'OI', 6.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1014.00', '1.B.1.e', 'OI', 2.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1014.00', '1.B.1.f', 'OI', 3.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1014.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1014.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1014.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1015.00', '1.B.1.a', 'OI', 1.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1015.00', '1.B.1.b', 'OI', 3.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1015.00', '1.B.1.c', 'OI', 2.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1015.00', '1.B.1.d', 'OI', 6.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1015.00', '1.B.1.e', 'OI', 3.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1015.00', '1.B.1.f', 'OI', 3.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1015.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1015.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1015.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1021.00', '1.B.1.a', 'OI', 1.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1021.00', '1.B.1.b', 'OI', 3.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1021.00', '1.B.1.c', 'OI', 2.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1021.00', '1.B.1.d', 'OI', 6.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1021.00', '1.B.1.e', 'OI', 2.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1021.00', '1.B.1.f', 'OI', 3.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1021.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1021.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1022.00', '1.B.1.a', 'OI', 1.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1022.00', '1.B.1.b', 'OI', 4.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1022.00', '1.B.1.c', 'OI', 2.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1022.00', '1.B.1.d', 'OI', 6.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1022.00', '1.B.1.e', 'OI', 2.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1022.00', '1.B.1.f', 'OI', 3.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1022.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1022.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1022.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1023.00', '1.B.1.a', 'OI', 1.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1023.00', '1.B.1.b', 'OI', 4.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1023.00', '1.B.1.c', 'OI', 2.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1023.00', '1.B.1.d', 'OI', 6.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1023.00', '1.B.1.e', 'OI', 2.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1023.00', '1.B.1.f', 'OI', 3.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1023.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1023.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1023.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1091.00', '1.B.1.a', 'OI', 1.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1091.00', '1.B.1.b', 'OI', 5.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1091.00', '1.B.1.c', 'OI', 2.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1091.00', '1.B.1.d', 'OI', 6.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1091.00', '1.B.1.e', 'OI', 3.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1091.00', '1.B.1.f', 'OI', 3.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1091.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1091.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1091.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1092.00', '1.B.1.a', 'OI', 2.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1092.00', '1.B.1.b', 'OI', 3.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1092.00', '1.B.1.c', 'OI', 2.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1092.00', '1.B.1.d', 'OI', 5.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1092.00', '1.B.1.e', 'OI', 3.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1092.00', '1.B.1.f', 'OI', 4.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1092.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1092.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1092.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1093.00', '1.B.1.a', 'OI', 1.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1093.00', '1.B.1.b', 'OI', 2.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1093.00', '1.B.1.c', 'OI', 1.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1093.00', '1.B.1.d', 'OI', 6.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1093.00', '1.B.1.e', 'OI', 3.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1093.00', '1.B.1.f', 'OI', 4.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1093.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1093.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1093.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1094.00', '1.B.1.a', 'OI', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1094.00', '1.B.1.b', 'OI', 3.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1094.00', '1.B.1.c', 'OI', 2.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1094.00', '1.B.1.d', 'OI', 6.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1094.00', '1.B.1.e', 'OI', 3.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1094.00', '1.B.1.f', 'OI', 3.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1094.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1094.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-1094.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2011.00', '1.B.1.a', 'OI', 2.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2011.00', '1.B.1.b', 'OI', 2.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2011.00', '1.B.1.c', 'OI', 3.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2011.00', '1.B.1.d', 'OI', 5.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2011.00', '1.B.1.e', 'OI', 4.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2011.00', '1.B.1.f', 'OI', 2.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2011.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2011.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2011.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2021.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2021.00', '1.B.1.b', 'OI', 2.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2021.00', '1.B.1.c', 'OI', 3.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2021.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2021.00', '1.B.1.e', 'OI', 6.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2021.00', '1.B.1.f', 'OI', 3.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2021.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2021.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('21-2021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1011.00', '1.B.1.a', 'OI', 1.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1011.00', '1.B.1.b', 'OI', 4.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1011.00', '1.B.1.c', 'OI', 2.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1011.00', '1.B.1.d', 'OI', 3.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1011.00', '1.B.1.e', 'OI', 5.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1011.00', '1.B.1.f', 'OI', 4.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1011.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1011.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1012.00', '1.B.1.a', 'OI', 1.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1012.00', '1.B.1.b', 'OI', 4.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1012.00', '1.B.1.c', 'OI', 2.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1012.00', '1.B.1.d', 'OI', 3.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1012.00', '1.B.1.e', 'OI', 4.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1012.00', '1.B.1.f', 'OI', 5.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1012.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1012.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1012.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1021.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1021.00', '1.B.1.b', 'OI', 4.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1021.00', '1.B.1.c', 'OI', 1.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1021.00', '1.B.1.d', 'OI', 3.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1021.00', '1.B.1.e', 'OI', 5.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1021.00', '1.B.1.f', 'OI', 5.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1021.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1021.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1021.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1022.00', '1.B.1.a', 'OI', 1.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1022.00', '1.B.1.b', 'OI', 3.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1022.00', '1.B.1.c', 'OI', 2.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1022.00', '1.B.1.d', 'OI', 4.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1022.00', '1.B.1.e', 'OI', 4.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1022.00', '1.B.1.f', 'OI', 4.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1022.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1022.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1022.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1023.00', '1.B.1.a', 'OI', 2.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1023.00', '1.B.1.b', 'OI', 3.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1023.00', '1.B.1.c', 'OI', 2.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1023.00', '1.B.1.d', 'OI', 3.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1023.00', '1.B.1.e', 'OI', 5.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1023.00', '1.B.1.f', 'OI', 4.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1023.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1023.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-1023.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2011.00', '1.B.1.a', 'OI', 1.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2011.00', '1.B.1.b', 'OI', 5.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2011.00', '1.B.1.c', 'OI', 2.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2011.00', '1.B.1.d', 'OI', 3.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2011.00', '1.B.1.e', 'OI', 3.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2011.00', '1.B.1.f', 'OI', 5.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2011.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2011.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2011.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2093.00', '1.B.1.a', 'OI', 2.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2093.00', '1.B.1.b', 'OI', 2.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2093.00', '1.B.1.c', 'OI', 1.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2093.00', '1.B.1.d', 'OI', 2.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2093.00', '1.B.1.e', 'OI', 3.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2093.00', '1.B.1.f', 'OI', 6.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2093.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2093.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('23-2093.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1011.00', '1.B.1.a', 'OI', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1011.00', '1.B.1.b', 'OI', 4.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1011.00', '1.B.1.c', 'OI', 3.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1011.00', '1.B.1.d', 'OI', 6.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1011.00', '1.B.1.e', 'OI', 3.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1011.00', '1.B.1.f', 'OI', 3.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1011.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1011.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1011.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1021.00', '1.B.1.a', 'OI', 3.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1021.00', '1.B.1.b', 'OI', 5.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1021.00', '1.B.1.c', 'OI', 3.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1021.00', '1.B.1.d', 'OI', 5.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1021.00', '1.B.1.e', 'OI', 2.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1021.00', '1.B.1.f', 'OI', 3.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1021.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1021.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1022.00', '1.B.1.a', 'OI', 2.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1022.00', '1.B.1.b', 'OI', 5.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1022.00', '1.B.1.c', 'OI', 3.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1022.00', '1.B.1.d', 'OI', 6.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1022.00', '1.B.1.e', 'OI', 1.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1022.00', '1.B.1.f', 'OI', 4.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1022.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1022.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1022.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1031.00', '1.B.1.a', 'OI', 3.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1031.00', '1.B.1.b', 'OI', 5.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1031.00', '1.B.1.c', 'OI', 4.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1031.00', '1.B.1.d', 'OI', 6.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1031.00', '1.B.1.e', 'OI', 2.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1031.00', '1.B.1.f', 'OI', 3.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1031.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1031.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1031.00', '1.B.1.i', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1032.00', '1.B.1.a', 'OI', 4.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1032.00', '1.B.1.b', 'OI', 5.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1032.00', '1.B.1.c', 'OI', 3.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1032.00', '1.B.1.d', 'OI', 5.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1032.00', '1.B.1.e', 'OI', 2.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1032.00', '1.B.1.f', 'OI', 3.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1032.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1032.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1032.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1041.00', '1.B.1.a', 'OI', 3.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1041.00', '1.B.1.b', 'OI', 5.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1041.00', '1.B.1.c', 'OI', 2.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1041.00', '1.B.1.d', 'OI', 6.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1041.00', '1.B.1.e', 'OI', 2.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1041.00', '1.B.1.f', 'OI', 3.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1041.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1041.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1041.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1042.00', '1.B.1.a', 'OI', 3.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1042.00', '1.B.1.b', 'OI', 5.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1042.00', '1.B.1.c', 'OI', 3.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1042.00', '1.B.1.d', 'OI', 6.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1042.00', '1.B.1.e', 'OI', 2.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1042.00', '1.B.1.f', 'OI', 3.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1042.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1042.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1042.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1043.00', '1.B.1.a', 'OI', 3.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1043.00', '1.B.1.b', 'OI', 5.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1043.00', '1.B.1.c', 'OI', 3.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1043.00', '1.B.1.d', 'OI', 6.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1043.00', '1.B.1.e', 'OI', 2.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1043.00', '1.B.1.f', 'OI', 3.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1043.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1043.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1043.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1051.00', '1.B.1.a', 'OI', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1051.00', '1.B.1.b', 'OI', 5.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1051.00', '1.B.1.c', 'OI', 3.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1051.00', '1.B.1.d', 'OI', 6.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1051.00', '1.B.1.e', 'OI', 2.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1051.00', '1.B.1.f', 'OI', 3.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1051.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1051.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1051.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1052.00', '1.B.1.a', 'OI', 4.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1052.00', '1.B.1.b', 'OI', 5.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1052.00', '1.B.1.c', 'OI', 2.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1052.00', '1.B.1.d', 'OI', 5.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1052.00', '1.B.1.e', 'OI', 2.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1052.00', '1.B.1.f', 'OI', 3.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1052.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1052.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1052.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1053.00', '1.B.1.a', 'OI', 3.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1053.00', '1.B.1.b', 'OI', 6.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1053.00', '1.B.1.c', 'OI', 3.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1053.00', '1.B.1.d', 'OI', 6.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1053.00', '1.B.1.e', 'OI', 2.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1053.00', '1.B.1.f', 'OI', 3.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1053.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1053.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1053.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1054.00', '1.B.1.a', 'OI', 3.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1054.00', '1.B.1.b', 'OI', 5.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1054.00', '1.B.1.c', 'OI', 3.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1054.00', '1.B.1.d', 'OI', 6.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1054.00', '1.B.1.e', 'OI', 2.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1054.00', '1.B.1.f', 'OI', 3.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1054.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1054.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1054.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1061.00', '1.B.1.a', 'OI', 3.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1061.00', '1.B.1.b', 'OI', 5.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1061.00', '1.B.1.c', 'OI', 3.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1061.00', '1.B.1.d', 'OI', 6.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1061.00', '1.B.1.e', 'OI', 2.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1061.00', '1.B.1.f', 'OI', 3.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1061.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1061.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1061.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1062.00', '1.B.1.a', 'OI', 3.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1062.00', '1.B.1.b', 'OI', 5.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1062.00', '1.B.1.c', 'OI', 3.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1062.00', '1.B.1.d', 'OI', 6.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1062.00', '1.B.1.e', 'OI', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1062.00', '1.B.1.f', 'OI', 3.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1062.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1062.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1062.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1063.00', '1.B.1.a', 'OI', 2.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1063.00', '1.B.1.b', 'OI', 5.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1063.00', '1.B.1.c', 'OI', 3.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1063.00', '1.B.1.d', 'OI', 6.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1063.00', '1.B.1.e', 'OI', 3.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1063.00', '1.B.1.f', 'OI', 3.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1063.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1063.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1063.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1064.00', '1.B.1.a', 'OI', 3.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1064.00', '1.B.1.b', 'OI', 5.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1064.00', '1.B.1.c', 'OI', 3.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1064.00', '1.B.1.d', 'OI', 6.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1064.00', '1.B.1.e', 'OI', 2.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1064.00', '1.B.1.f', 'OI', 3.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1064.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1064.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1064.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1065.00', '1.B.1.a', 'OI', 1.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1065.00', '1.B.1.b', 'OI', 5.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1065.00', '1.B.1.c', 'OI', 3.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1065.00', '1.B.1.d', 'OI', 6.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1065.00', '1.B.1.e', 'OI', 3.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1065.00', '1.B.1.f', 'OI', 3.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1065.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1065.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1065.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1066.00', '1.B.1.a', 'OI', 2.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1066.00', '1.B.1.b', 'OI', 5.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1066.00', '1.B.1.c', 'OI', 3.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1066.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1066.00', '1.B.1.e', 'OI', 2.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1066.00', '1.B.1.f', 'OI', 3.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1066.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1066.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1066.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1067.00', '1.B.1.a', 'OI', 2.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1067.00', '1.B.1.b', 'OI', 5.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1067.00', '1.B.1.c', 'OI', 3.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1067.00', '1.B.1.d', 'OI', 6.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1067.00', '1.B.1.e', 'OI', 2.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1067.00', '1.B.1.f', 'OI', 3.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1067.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1067.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1067.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1071.00', '1.B.1.a', 'OI', 3.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1071.00', '1.B.1.b', 'OI', 5.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1071.00', '1.B.1.c', 'OI', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1071.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1071.00', '1.B.1.e', 'OI', 1.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1071.00', '1.B.1.f', 'OI', 3.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1071.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1071.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1071.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1072.00', '1.B.1.a', 'OI', 2.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1072.00', '1.B.1.b', 'OI', 4.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1072.00', '1.B.1.c', 'OI', 3.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1072.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1072.00', '1.B.1.e', 'OI', 2.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1072.00', '1.B.1.f', 'OI', 3.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1072.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1072.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1072.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1081.00', '1.B.1.a', 'OI', 2.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1081.00', '1.B.1.b', 'OI', 4.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1081.00', '1.B.1.c', 'OI', 3.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1081.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1081.00', '1.B.1.e', 'OI', 2.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1081.00', '1.B.1.f', 'OI', 3.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1081.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1081.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1081.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1082.00', '1.B.1.a', 'OI', 2.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1082.00', '1.B.1.b', 'OI', 5.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1082.00', '1.B.1.c', 'OI', 3.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1082.00', '1.B.1.d', 'OI', 6.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1082.00', '1.B.1.e', 'OI', 2.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1082.00', '1.B.1.f', 'OI', 4.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1082.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1082.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1082.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1111.00', '1.B.1.a', 'OI', 2.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1111.00', '1.B.1.b', 'OI', 4.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1111.00', '1.B.1.c', 'OI', 3.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1111.00', '1.B.1.d', 'OI', 6.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1111.00', '1.B.1.e', 'OI', 3.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1111.00', '1.B.1.f', 'OI', 3.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1111.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1111.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1111.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1112.00', '1.B.1.a', 'OI', 2.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1112.00', '1.B.1.b', 'OI', 5.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1112.00', '1.B.1.c', 'OI', 3.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1112.00', '1.B.1.d', 'OI', 6.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1112.00', '1.B.1.e', 'OI', 3.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1112.00', '1.B.1.f', 'OI', 3.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1112.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1112.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1112.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1113.00', '1.B.1.a', 'OI', 2.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1113.00', '1.B.1.b', 'OI', 5.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1113.00', '1.B.1.c', 'OI', 3.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1113.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1113.00', '1.B.1.e', 'OI', 2.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1113.00', '1.B.1.f', 'OI', 3.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1113.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1113.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1113.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1121.00', '1.B.1.a', 'OI', 3.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1121.00', '1.B.1.b', 'OI', 4.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1121.00', '1.B.1.c', 'OI', 5.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1121.00', '1.B.1.d', 'OI', 6.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1121.00', '1.B.1.e', 'OI', 2.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1121.00', '1.B.1.f', 'OI', 2.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1121.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1121.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1121.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1122.00', '1.B.1.a', 'OI', 2.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1122.00', '1.B.1.b', 'OI', 4.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1122.00', '1.B.1.c', 'OI', 3.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1122.00', '1.B.1.d', 'OI', 6.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1122.00', '1.B.1.e', 'OI', 3.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1122.00', '1.B.1.f', 'OI', 3.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1122.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1122.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1122.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1123.00', '1.B.1.a', 'OI', 2.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1123.00', '1.B.1.b', 'OI', 4.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1123.00', '1.B.1.c', 'OI', 4.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1123.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1123.00', '1.B.1.e', 'OI', 2.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1123.00', '1.B.1.f', 'OI', 3.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1123.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1123.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1123.00', '1.B.1.i', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1124.00', '1.B.1.a', 'OI', 2.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1124.00', '1.B.1.b', 'OI', 4.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1124.00', '1.B.1.c', 'OI', 4.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1124.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1124.00', '1.B.1.e', 'OI', 2.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1124.00', '1.B.1.f', 'OI', 3.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1124.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1124.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1124.00', '1.B.1.i', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1125.00', '1.B.1.a', 'OI', 2.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1125.00', '1.B.1.b', 'OI', 5.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1125.00', '1.B.1.c', 'OI', 3.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1125.00', '1.B.1.d', 'OI', 6.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1125.00', '1.B.1.e', 'OI', 2.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1125.00', '1.B.1.f', 'OI', 3.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1125.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1125.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1125.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1126.00', '1.B.1.a', 'OI', 2.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1126.00', '1.B.1.b', 'OI', 5.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1126.00', '1.B.1.c', 'OI', 3.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1126.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1126.00', '1.B.1.e', 'OI', 2.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1126.00', '1.B.1.f', 'OI', 3.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1126.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1126.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1126.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1192.00', '1.B.1.a', 'OI', 2.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1192.00', '1.B.1.b', 'OI', 4.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1192.00', '1.B.1.c', 'OI', 3.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1192.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1192.00', '1.B.1.e', 'OI', 2.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1192.00', '1.B.1.f', 'OI', 3.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1192.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1192.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1192.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1193.00', '1.B.1.a', 'OI', 3.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1193.00', '1.B.1.b', 'OI', 4.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1193.00', '1.B.1.c', 'OI', 3.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1193.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1193.00', '1.B.1.e', 'OI', 2.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1193.00', '1.B.1.f', 'OI', 3.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1193.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1193.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1193.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1194.00', '1.B.1.a', 'OI', 3.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1194.00', '1.B.1.b', 'OI', 4.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1194.00', '1.B.1.c', 'OI', 3.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1194.00', '1.B.1.d', 'OI', 6.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1194.00', '1.B.1.e', 'OI', 2.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1194.00', '1.B.1.f', 'OI', 3.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1194.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1194.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-1194.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2011.00', '1.B.1.a', 'OI', 2.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2011.00', '1.B.1.b', 'OI', 2.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2011.00', '1.B.1.c', 'OI', 3.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2011.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2011.00', '1.B.1.e', 'OI', 2.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2011.00', '1.B.1.f', 'OI', 3.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2011.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2011.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2011.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2012.00', '1.B.1.a', 'OI', 2.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2012.00', '1.B.1.b', 'OI', 3.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2012.00', '1.B.1.c', 'OI', 3.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2012.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2012.00', '1.B.1.e', 'OI', 2.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2012.00', '1.B.1.f', 'OI', 3.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2012.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2012.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2012.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2021.00', '1.B.1.a', 'OI', 2.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2021.00', '1.B.1.b', 'OI', 3.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2021.00', '1.B.1.c', 'OI', 3.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2021.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2021.00', '1.B.1.e', 'OI', 2.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2021.00', '1.B.1.f', 'OI', 3.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2021.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2021.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2022.00', '1.B.1.a', 'OI', 2.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2022.00', '1.B.1.b', 'OI', 3.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2022.00', '1.B.1.c', 'OI', 4.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2022.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2022.00', '1.B.1.e', 'OI', 2.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2022.00', '1.B.1.f', 'OI', 3.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2022.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2022.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2022.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2023.00', '1.B.1.a', 'OI', 3.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2023.00', '1.B.1.b', 'OI', 3.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2023.00', '1.B.1.c', 'OI', 3.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2023.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2023.00', '1.B.1.e', 'OI', 2.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2023.00', '1.B.1.f', 'OI', 3.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2023.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2023.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2023.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2031.00', '1.B.1.a', 'OI', 2.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2031.00', '1.B.1.b', 'OI', 3.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2031.00', '1.B.1.c', 'OI', 3.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2031.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2031.00', '1.B.1.e', 'OI', 2.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2031.00', '1.B.1.f', 'OI', 3.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2031.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2031.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2031.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2032.00', '1.B.1.a', 'OI', 2.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2032.00', '1.B.1.b', 'OI', 3.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2032.00', '1.B.1.c', 'OI', 3.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2032.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2032.00', '1.B.1.e', 'OI', 2.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2032.00', '1.B.1.f', 'OI', 3.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2032.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2032.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2032.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2051.00', '1.B.1.a', 'OI', 2.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2051.00', '1.B.1.b', 'OI', 3.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2051.00', '1.B.1.c', 'OI', 3.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2051.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2051.00', '1.B.1.e', 'OI', 1.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2051.00', '1.B.1.f', 'OI', 3.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2051.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2051.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2051.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2055.00', '1.B.1.a', 'OI', 2.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2055.00', '1.B.1.b', 'OI', 3.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2055.00', '1.B.1.c', 'OI', 3.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2055.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2055.00', '1.B.1.e', 'OI', 1.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2055.00', '1.B.1.f', 'OI', 3.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2055.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2055.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2055.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2056.00', '1.B.1.a', 'OI', 2.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2056.00', '1.B.1.b', 'OI', 3.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2056.00', '1.B.1.c', 'OI', 3.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2056.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2056.00', '1.B.1.e', 'OI', 1.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2056.00', '1.B.1.f', 'OI', 3.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2056.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2056.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2056.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2057.00', '1.B.1.a', 'OI', 2.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2057.00', '1.B.1.b', 'OI', 3.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2057.00', '1.B.1.c', 'OI', 3.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2057.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2057.00', '1.B.1.e', 'OI', 1.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2057.00', '1.B.1.f', 'OI', 3.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2057.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2057.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2057.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2058.00', '1.B.1.a', 'OI', 2.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2058.00', '1.B.1.b', 'OI', 3.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2058.00', '1.B.1.c', 'OI', 3.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2058.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2058.00', '1.B.1.e', 'OI', 1.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2058.00', '1.B.1.f', 'OI', 3.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2058.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2058.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2058.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2059.01', '1.B.1.a', 'OI', 4.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2059.01', '1.B.1.b', 'OI', 3.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2059.01', '1.B.1.c', 'OI', 2.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2059.01', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2059.01', '1.B.1.e', 'OI', 1.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2059.01', '1.B.1.f', 'OI', 4.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2059.01', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2059.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-2059.01', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3011.00', '1.B.1.a', 'OI', 2.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3011.00', '1.B.1.b', 'OI', 3.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3011.00', '1.B.1.c', 'OI', 3.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3011.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3011.00', '1.B.1.e', 'OI', 2.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3011.00', '1.B.1.f', 'OI', 3.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3011.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3011.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3011.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3021.00', '1.B.1.a', 'OI', 2.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3021.00', '1.B.1.b', 'OI', 2.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3021.00', '1.B.1.c', 'OI', 4.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3021.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3021.00', '1.B.1.e', 'OI', 3.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3021.00', '1.B.1.f', 'OI', 3.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3021.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3021.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3031.00', '1.B.1.a', 'OI', 2.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3031.00', '1.B.1.b', 'OI', 2.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3031.00', '1.B.1.c', 'OI', 3.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3031.00', '1.B.1.d', 'OI', 6.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3031.00', '1.B.1.e', 'OI', 2.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3031.00', '1.B.1.f', 'OI', 3.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3031.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3031.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3031.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3041.00', '1.B.1.a', 'OI', 2.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3041.00', '1.B.1.b', 'OI', 2.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3041.00', '1.B.1.c', 'OI', 3.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3041.00', '1.B.1.d', 'OI', 6.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3041.00', '1.B.1.e', 'OI', 1.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3041.00', '1.B.1.f', 'OI', 3.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3041.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3041.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-3041.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4011.00', '1.B.1.a', 'OI', 2.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4011.00', '1.B.1.b', 'OI', 4.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4011.00', '1.B.1.c', 'OI', 2.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4011.00', '1.B.1.d', 'OI', 2.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4011.00', '1.B.1.e', 'OI', 1.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4011.00', '1.B.1.f', 'OI', 5.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4011.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4011.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4011.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4012.00', '1.B.1.a', 'OI', 2.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4012.00', '1.B.1.b', 'OI', 3.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4012.00', '1.B.1.c', 'OI', 2.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4012.00', '1.B.1.d', 'OI', 3.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4012.00', '1.B.1.e', 'OI', 3.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4012.00', '1.B.1.f', 'OI', 5.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4012.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4012.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4012.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4013.00', '1.B.1.a', 'OI', 5.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4013.00', '1.B.1.b', 'OI', 3.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4013.00', '1.B.1.c', 'OI', 3.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4013.00', '1.B.1.d', 'OI', 2.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4013.00', '1.B.1.e', 'OI', 1.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4013.00', '1.B.1.f', 'OI', 4.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4013.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4013.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4013.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4022.00', '1.B.1.a', 'OI', 2.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4022.00', '1.B.1.b', 'OI', 3.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4022.00', '1.B.1.c', 'OI', 2.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4022.00', '1.B.1.d', 'OI', 4.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4022.00', '1.B.1.e', 'OI', 2.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4022.00', '1.B.1.f', 'OI', 5.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4022.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4022.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4022.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4031.00', '1.B.1.a', 'OI', 3.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4031.00', '1.B.1.b', 'OI', 2.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4031.00', '1.B.1.c', 'OI', 1.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4031.00', '1.B.1.d', 'OI', 4.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4031.00', '1.B.1.e', 'OI', 1.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4031.00', '1.B.1.f', 'OI', 6.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4031.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4031.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-4031.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9021.00', '1.B.1.a', 'OI', 3.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9021.00', '1.B.1.b', 'OI', 4.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9021.00', '1.B.1.c', 'OI', 2.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9021.00', '1.B.1.d', 'OI', 4.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9021.00', '1.B.1.e', 'OI', 3.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9021.00', '1.B.1.f', 'OI', 3.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9021.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9021.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9021.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9031.00', '1.B.1.a', 'OI', 1.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9031.00', '1.B.1.b', 'OI', 4.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9031.00', '1.B.1.c', 'OI', 3.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9031.00', '1.B.1.d', 'OI', 6.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9031.00', '1.B.1.e', 'OI', 4.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9031.00', '1.B.1.f', 'OI', 3.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9031.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9031.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9031.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9042.00', '1.B.1.a', 'OI', 2.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9042.00', '1.B.1.b', 'OI', 2.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9042.00', '1.B.1.c', 'OI', 2.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9042.00', '1.B.1.d', 'OI', 6.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9042.00', '1.B.1.e', 'OI', 2.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9042.00', '1.B.1.f', 'OI', 4.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9042.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9042.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9042.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9043.00', '1.B.1.a', 'OI', 1.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9043.00', '1.B.1.b', 'OI', 3.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9043.00', '1.B.1.c', 'OI', 3.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9043.00', '1.B.1.d', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9043.00', '1.B.1.e', 'OI', 2.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9043.00', '1.B.1.f', 'OI', 3.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9043.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9043.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9043.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9044.00', '1.B.1.a', 'OI', 2.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9044.00', '1.B.1.b', 'OI', 3.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9044.00', '1.B.1.c', 'OI', 2.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9044.00', '1.B.1.d', 'OI', 6.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9044.00', '1.B.1.e', 'OI', 2.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9044.00', '1.B.1.f', 'OI', 4.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9044.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9044.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('25-9044.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1011.00', '1.B.1.a', 'OI', 2.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1011.00', '1.B.1.b', 'OI', 2.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1011.00', '1.B.1.c', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1011.00', '1.B.1.d', 'OI', 2.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1011.00', '1.B.1.e', 'OI', 5.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1011.00', '1.B.1.f', 'OI', 3.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1011.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1011.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1011.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1012.00', '1.B.1.a', 'OI', 5.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1012.00', '1.B.1.b', 'OI', 1.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1012.00', '1.B.1.c', 'OI', 5.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1012.00', '1.B.1.d', 'OI', 1.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1012.00', '1.B.1.e', 'OI', 2.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1012.00', '1.B.1.f', 'OI', 2.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1012.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1012.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1012.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1013.00', '1.B.1.a', 'OI', 4.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1013.00', '1.B.1.b', 'OI', 2.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1013.00', '1.B.1.c', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1013.00', '1.B.1.d', 'OI', 2.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1013.00', '1.B.1.e', 'OI', 2.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1013.00', '1.B.1.f', 'OI', 2.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1013.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1013.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1013.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1014.00', '1.B.1.a', 'OI', 3.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1014.00', '1.B.1.b', 'OI', 2.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1014.00', '1.B.1.c', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1014.00', '1.B.1.d', 'OI', 2.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1014.00', '1.B.1.e', 'OI', 2.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1014.00', '1.B.1.f', 'OI', 3.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1014.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1014.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1014.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1021.00', '1.B.1.a', 'OI', 4.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1021.00', '1.B.1.b', 'OI', 4.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1021.00', '1.B.1.c', 'OI', 5.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1021.00', '1.B.1.d', 'OI', 1.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1021.00', '1.B.1.e', 'OI', 3.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1021.00', '1.B.1.f', 'OI', 3.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1021.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1021.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1021.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1022.00', '1.B.1.a', 'OI', 4.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1022.00', '1.B.1.b', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1022.00', '1.B.1.c', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1022.00', '1.B.1.d', 'OI', 2.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1022.00', '1.B.1.e', 'OI', 3.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1022.00', '1.B.1.f', 'OI', 2.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1022.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1022.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1022.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1023.00', '1.B.1.a', 'OI', 5.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1023.00', '1.B.1.b', 'OI', 1.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1023.00', '1.B.1.c', 'OI', 4.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1023.00', '1.B.1.d', 'OI', 2.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1023.00', '1.B.1.e', 'OI', 3.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1023.00', '1.B.1.f', 'OI', 3.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1023.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1023.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1023.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1024.00', '1.B.1.a', 'OI', 3.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1024.00', '1.B.1.b', 'OI', 2.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1024.00', '1.B.1.c', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1024.00', '1.B.1.d', 'OI', 2.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1024.00', '1.B.1.e', 'OI', 3.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1024.00', '1.B.1.f', 'OI', 3.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1024.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1024.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1024.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1025.00', '1.B.1.a', 'OI', 4.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1025.00', '1.B.1.b', 'OI', 3.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1025.00', '1.B.1.c', 'OI', 5.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1025.00', '1.B.1.d', 'OI', 2.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1025.00', '1.B.1.e', 'OI', 3.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1025.00', '1.B.1.f', 'OI', 3.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1025.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1025.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1025.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1026.00', '1.B.1.a', 'OI', 4.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1026.00', '1.B.1.b', 'OI', 1.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1026.00', '1.B.1.c', 'OI', 4.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1026.00', '1.B.1.d', 'OI', 2.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1026.00', '1.B.1.e', 'OI', 4.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1026.00', '1.B.1.f', 'OI', 3.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1026.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1026.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1026.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1027.00', '1.B.1.a', 'OI', 3.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1027.00', '1.B.1.b', 'OI', 2.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1027.00', '1.B.1.c', 'OI', 6.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1027.00', '1.B.1.d', 'OI', 3.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1027.00', '1.B.1.e', 'OI', 3.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1027.00', '1.B.1.f', 'OI', 3.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1027.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1027.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-1027.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2011.00', '1.B.1.a', 'OI', 2.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2011.00', '1.B.1.b', 'OI', 2.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2011.00', '1.B.1.c', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2011.00', '1.B.1.d', 'OI', 4.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2011.00', '1.B.1.e', 'OI', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2011.00', '1.B.1.f', 'OI', 1.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2011.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2011.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2011.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.00', '1.B.1.a', 'OI', 2.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.00', '1.B.1.b', 'OI', 2.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.00', '1.B.1.c', 'OI', 6.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.00', '1.B.1.d', 'OI', 3.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.00', '1.B.1.e', 'OI', 5.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.00', '1.B.1.f', 'OI', 3.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.03', '1.B.1.a', 'OI', 1.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.03', '1.B.1.b', 'OI', 2.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.03', '1.B.1.c', 'OI', 4.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.03', '1.B.1.d', 'OI', 3.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.03', '1.B.1.e', 'OI', 6.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.03', '1.B.1.f', 'OI', 4.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.03', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.03', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.03', '1.B.1.i', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.04', '1.B.1.a', 'OI', 1.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.04', '1.B.1.b', 'OI', 1.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.04', '1.B.1.c', 'OI', 5.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.04', '1.B.1.d', 'OI', 4.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.04', '1.B.1.e', 'OI', 5.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.04', '1.B.1.f', 'OI', 3.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.04', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.04', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.04', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.05', '1.B.1.a', 'OI', 3.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.05', '1.B.1.b', 'OI', 2.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.05', '1.B.1.c', 'OI', 3.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.05', '1.B.1.d', 'OI', 2.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.05', '1.B.1.e', 'OI', 5.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.05', '1.B.1.f', 'OI', 4.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.05', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.05', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2012.05', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2021.00', '1.B.1.a', 'OI', 5.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2021.00', '1.B.1.b', 'OI', 1.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2021.00', '1.B.1.c', 'OI', 2.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2021.00', '1.B.1.d', 'OI', 4.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2021.00', '1.B.1.e', 'OI', 4.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2021.00', '1.B.1.f', 'OI', 3.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2021.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2021.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2021.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2022.00', '1.B.1.a', 'OI', 4.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2022.00', '1.B.1.b', 'OI', 2.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2022.00', '1.B.1.c', 'OI', 2.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2022.00', '1.B.1.d', 'OI', 5.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2022.00', '1.B.1.e', 'OI', 5.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2022.00', '1.B.1.f', 'OI', 3.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2022.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2022.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2022.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2023.00', '1.B.1.a', 'OI', 4.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2023.00', '1.B.1.b', 'OI', 1.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2023.00', '1.B.1.c', 'OI', 1.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2023.00', '1.B.1.d', 'OI', 3.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2023.00', '1.B.1.e', 'OI', 5.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2023.00', '1.B.1.f', 'OI', 4.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2023.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2023.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2023.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2031.00', '1.B.1.a', 'OI', 4.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2031.00', '1.B.1.b', 'OI', 1.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2031.00', '1.B.1.c', 'OI', 6.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2031.00', '1.B.1.d', 'OI', 3.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2031.00', '1.B.1.e', 'OI', 3.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2031.00', '1.B.1.f', 'OI', 1.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2031.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2031.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2031.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2032.00', '1.B.1.a', 'OI', 3.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2032.00', '1.B.1.b', 'OI', 2.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2032.00', '1.B.1.c', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2032.00', '1.B.1.d', 'OI', 3.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2032.00', '1.B.1.e', 'OI', 3.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2032.00', '1.B.1.f', 'OI', 2.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2032.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2032.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2032.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2041.00', '1.B.1.a', 'OI', 2.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2041.00', '1.B.1.b', 'OI', 2.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2041.00', '1.B.1.c', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2041.00', '1.B.1.d', 'OI', 3.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2041.00', '1.B.1.e', 'OI', 4.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2041.00', '1.B.1.f', 'OI', 2.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2041.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2041.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2041.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2042.00', '1.B.1.a', 'OI', 2.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2042.00', '1.B.1.b', 'OI', 1.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2042.00', '1.B.1.c', 'OI', 6.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2042.00', '1.B.1.d', 'OI', 3.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2042.00', '1.B.1.e', 'OI', 3.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2042.00', '1.B.1.f', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2042.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2042.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2042.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2091.00', '1.B.1.a', 'OI', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2091.00', '1.B.1.b', 'OI', 1.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2091.00', '1.B.1.c', 'OI', 4.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2091.00', '1.B.1.d', 'OI', 2.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2091.00', '1.B.1.e', 'OI', 3.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2091.00', '1.B.1.f', 'OI', 3.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2091.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2091.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-2091.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3011.00', '1.B.1.a', 'OI', 1.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3011.00', '1.B.1.b', 'OI', 2.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3011.00', '1.B.1.c', 'OI', 5.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3011.00', '1.B.1.d', 'OI', 3.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3011.00', '1.B.1.e', 'OI', 4.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3011.00', '1.B.1.f', 'OI', 3.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3011.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3011.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3011.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3023.00', '1.B.1.a', 'OI', 1.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3023.00', '1.B.1.b', 'OI', 4.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3023.00', '1.B.1.c', 'OI', 5.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3023.00', '1.B.1.d', 'OI', 2.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3023.00', '1.B.1.e', 'OI', 3.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3023.00', '1.B.1.f', 'OI', 3.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3023.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3023.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3023.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3031.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3031.00', '1.B.1.b', 'OI', 2.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3031.00', '1.B.1.c', 'OI', 4.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3031.00', '1.B.1.d', 'OI', 3.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3031.00', '1.B.1.e', 'OI', 5.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3031.00', '1.B.1.f', 'OI', 3.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3031.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3031.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3031.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3041.00', '1.B.1.a', 'OI', 1.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3041.00', '1.B.1.b', 'OI', 2.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3041.00', '1.B.1.c', 'OI', 5.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3041.00', '1.B.1.d', 'OI', 2.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3041.00', '1.B.1.e', 'OI', 4.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3041.00', '1.B.1.f', 'OI', 4.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3041.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3041.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3041.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3042.00', '1.B.1.a', 'OI', 2.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3042.00', '1.B.1.b', 'OI', 3.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3042.00', '1.B.1.c', 'OI', 4.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3042.00', '1.B.1.d', 'OI', 2.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3042.00', '1.B.1.e', 'OI', 1.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3042.00', '1.B.1.f', 'OI', 5.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3042.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3042.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3042.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.00', '1.B.1.a', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.00', '1.B.1.b', 'OI', 3.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.00', '1.B.1.c', 'OI', 6.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.00', '1.B.1.d', 'OI', 2.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.00', '1.B.1.e', 'OI', 4.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.00', '1.B.1.f', 'OI', 3.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.05', '1.B.1.a', 'OI', 1.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.05', '1.B.1.b', 'OI', 3.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.05', '1.B.1.c', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.05', '1.B.1.d', 'OI', 2.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.05', '1.B.1.e', 'OI', 3.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.05', '1.B.1.f', 'OI', 2.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.05', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.05', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3043.05', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3091.00', '1.B.1.a', 'OI', 1.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3091.00', '1.B.1.b', 'OI', 3.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3091.00', '1.B.1.c', 'OI', 4.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3091.00', '1.B.1.d', 'OI', 3.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3091.00', '1.B.1.e', 'OI', 1.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3091.00', '1.B.1.f', 'OI', 4.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3091.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3091.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3091.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3092.00', '1.B.1.a', 'OI', 2.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3092.00', '1.B.1.b', 'OI', 2.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3092.00', '1.B.1.c', 'OI', 2.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3092.00', '1.B.1.d', 'OI', 2.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3092.00', '1.B.1.e', 'OI', 2.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3092.00', '1.B.1.f', 'OI', 5.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3092.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3092.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-3092.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4011.00', '1.B.1.a', 'OI', 5.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4011.00', '1.B.1.b', 'OI', 2.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4011.00', '1.B.1.c', 'OI', 3.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4011.00', '1.B.1.d', 'OI', 1.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4011.00', '1.B.1.e', 'OI', 1.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4011.00', '1.B.1.f', 'OI', 4.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4011.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4011.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4012.00', '1.B.1.a', 'OI', 4.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4012.00', '1.B.1.b', 'OI', 2.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4012.00', '1.B.1.c', 'OI', 2.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4012.00', '1.B.1.d', 'OI', 2.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4012.00', '1.B.1.e', 'OI', 2.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4012.00', '1.B.1.f', 'OI', 5.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4012.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4012.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4012.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4014.00', '1.B.1.a', 'OI', 5.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4014.00', '1.B.1.b', 'OI', 2.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4014.00', '1.B.1.c', 'OI', 4.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4014.00', '1.B.1.d', 'OI', 1.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4014.00', '1.B.1.e', 'OI', 2.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4014.00', '1.B.1.f', 'OI', 4.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4014.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4014.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4014.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4015.00', '1.B.1.a', 'OI', 6.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4015.00', '1.B.1.b', 'OI', 2.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4015.00', '1.B.1.c', 'OI', 2.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4015.00', '1.B.1.d', 'OI', 1.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4015.00', '1.B.1.e', 'OI', 1.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4015.00', '1.B.1.f', 'OI', 4.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4015.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4015.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4015.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4021.00', '1.B.1.a', 'OI', 5.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4021.00', '1.B.1.b', 'OI', 2.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4021.00', '1.B.1.c', 'OI', 5.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4021.00', '1.B.1.d', 'OI', 1.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4021.00', '1.B.1.e', 'OI', 2.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4021.00', '1.B.1.f', 'OI', 3.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4021.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4021.00', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4031.00', '1.B.1.a', 'OI', 4.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4031.00', '1.B.1.b', 'OI', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4031.00', '1.B.1.c', 'OI', 5.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4031.00', '1.B.1.d', 'OI', 1.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4031.00', '1.B.1.e', 'OI', 2.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4031.00', '1.B.1.f', 'OI', 3.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4031.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4031.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4031.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4032.00', '1.B.1.a', 'OI', 3.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4032.00', '1.B.1.b', 'OI', 1.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4032.00', '1.B.1.c', 'OI', 5.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4032.00', '1.B.1.d', 'OI', 1.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4032.00', '1.B.1.e', 'OI', 3.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4032.00', '1.B.1.f', 'OI', 3.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4032.00', '1.B.1.g', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4032.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('27-4032.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1011.00', '1.B.1.a', 'OI', 5.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1011.00', '1.B.1.b', 'OI', 4.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1011.00', '1.B.1.c', 'OI', 1.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1011.00', '1.B.1.d', 'OI', 5.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1011.00', '1.B.1.e', 'OI', 2.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1011.00', '1.B.1.f', 'OI', 3.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1011.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1011.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1011.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1021.00', '1.B.1.a', 'OI', 5.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1021.00', '1.B.1.b', 'OI', 5.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1021.00', '1.B.1.c', 'OI', 1.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1021.00', '1.B.1.d', 'OI', 4.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1021.00', '1.B.1.e', 'OI', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1021.00', '1.B.1.f', 'OI', 3.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1021.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1021.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1021.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1022.00', '1.B.1.a', 'OI', 5.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1022.00', '1.B.1.b', 'OI', 5.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1022.00', '1.B.1.c', 'OI', 1.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1022.00', '1.B.1.d', 'OI', 4.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1022.00', '1.B.1.e', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1022.00', '1.B.1.f', 'OI', 3.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1022.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1022.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1022.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1023.00', '1.B.1.a', 'OI', 5.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1023.00', '1.B.1.b', 'OI', 5.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1023.00', '1.B.1.c', 'OI', 1.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1023.00', '1.B.1.d', 'OI', 4.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1023.00', '1.B.1.e', 'OI', 1.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1023.00', '1.B.1.f', 'OI', 4.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1023.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1023.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1023.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1024.00', '1.B.1.a', 'OI', 6.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1024.00', '1.B.1.b', 'OI', 5.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1024.00', '1.B.1.c', 'OI', 1.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1024.00', '1.B.1.d', 'OI', 4.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1024.00', '1.B.1.e', 'OI', 1.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1024.00', '1.B.1.f', 'OI', 3.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1024.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1024.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1024.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1031.00', '1.B.1.a', 'OI', 3.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1031.00', '1.B.1.b', 'OI', 4.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1031.00', '1.B.1.c', 'OI', 2.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1031.00', '1.B.1.d', 'OI', 5.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1031.00', '1.B.1.e', 'OI', 3.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1031.00', '1.B.1.f', 'OI', 3.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1031.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1031.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1031.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1041.00', '1.B.1.a', 'OI', 4.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1041.00', '1.B.1.b', 'OI', 5.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1041.00', '1.B.1.c', 'OI', 1.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1041.00', '1.B.1.d', 'OI', 5.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1041.00', '1.B.1.e', 'OI', 2.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1041.00', '1.B.1.f', 'OI', 3.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1041.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1041.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1041.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1051.00', '1.B.1.a', 'OI', 2.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1051.00', '1.B.1.b', 'OI', 5.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1051.00', '1.B.1.c', 'OI', 1.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1051.00', '1.B.1.d', 'OI', 4.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1051.00', '1.B.1.e', 'OI', 2.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1051.00', '1.B.1.f', 'OI', 4.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1051.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1051.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1051.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.00', '1.B.1.a', 'OI', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.00', '1.B.1.b', 'OI', 4.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.00', '1.B.1.c', 'OI', 1.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.00', '1.B.1.d', 'OI', 5.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.00', '1.B.1.e', 'OI', 1.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.00', '1.B.1.f', 'OI', 4.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.01', '1.B.1.a', 'OI', 4.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.01', '1.B.1.b', 'OI', 4.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.01', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.01', '1.B.1.d', 'OI', 4.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.01', '1.B.1.e', 'OI', 1.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.01', '1.B.1.f', 'OI', 5.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.01', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.01', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1071.01', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1081.00', '1.B.1.a', 'OI', 5.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1081.00', '1.B.1.b', 'OI', 5.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1081.00', '1.B.1.c', 'OI', 1.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1081.00', '1.B.1.d', 'OI', 4.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1081.00', '1.B.1.e', 'OI', 2.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1081.00', '1.B.1.f', 'OI', 3.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1081.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1081.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1081.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.00', '1.B.1.a', 'OI', 3.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.00', '1.B.1.b', 'OI', 4.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.00', '1.B.1.c', 'OI', 3.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.00', '1.B.1.d', 'OI', 6.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.00', '1.B.1.e', 'OI', 1.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.00', '1.B.1.f', 'OI', 3.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.01', '1.B.1.a', 'OI', 3.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.01', '1.B.1.b', 'OI', 3.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.01', '1.B.1.c', 'OI', 3.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.01', '1.B.1.d', 'OI', 6.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.01', '1.B.1.e', 'OI', 2.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.01', '1.B.1.f', 'OI', 2.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.01', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.01', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1122.01', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1123.00', '1.B.1.a', 'OI', 4.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1123.00', '1.B.1.b', 'OI', 4.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1123.00', '1.B.1.c', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1123.00', '1.B.1.d', 'OI', 5.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1123.00', '1.B.1.e', 'OI', 2.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1123.00', '1.B.1.f', 'OI', 3.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1123.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1123.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1123.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1124.00', '1.B.1.a', 'OI', 4.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1124.00', '1.B.1.b', 'OI', 4.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1124.00', '1.B.1.c', 'OI', 1.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1124.00', '1.B.1.d', 'OI', 4.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1124.00', '1.B.1.e', 'OI', 1.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1124.00', '1.B.1.f', 'OI', 4.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1124.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1124.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1124.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1125.00', '1.B.1.a', 'OI', 3.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1125.00', '1.B.1.b', 'OI', 4.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1125.00', '1.B.1.c', 'OI', 2.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1125.00', '1.B.1.d', 'OI', 6.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1125.00', '1.B.1.e', 'OI', 2.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1125.00', '1.B.1.f', 'OI', 2.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1125.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1125.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1125.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1126.00', '1.B.1.a', 'OI', 5.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1126.00', '1.B.1.b', 'OI', 4.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1126.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1126.00', '1.B.1.d', 'OI', 4.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1126.00', '1.B.1.e', 'OI', 1.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1126.00', '1.B.1.f', 'OI', 3.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1126.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1126.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1126.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1127.00', '1.B.1.a', 'OI', 2.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1127.00', '1.B.1.b', 'OI', 5.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1127.00', '1.B.1.c', 'OI', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1127.00', '1.B.1.d', 'OI', 6.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1127.00', '1.B.1.e', 'OI', 1.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1127.00', '1.B.1.f', 'OI', 4.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1127.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1127.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1127.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1128.00', '1.B.1.a', 'OI', 5.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1128.00', '1.B.1.b', 'OI', 4.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1128.00', '1.B.1.c', 'OI', 1.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1128.00', '1.B.1.d', 'OI', 4.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1128.00', '1.B.1.e', 'OI', 2.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1128.00', '1.B.1.f', 'OI', 3.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1128.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1128.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1128.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.01', '1.B.1.a', 'OI', 2.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.01', '1.B.1.b', 'OI', 3.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.01', '1.B.1.c', 'OI', 5.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.01', '1.B.1.d', 'OI', 5.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.01', '1.B.1.e', 'OI', 2.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.01', '1.B.1.f', 'OI', 2.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.01', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.01', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.01', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.02', '1.B.1.a', 'OI', 2.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.02', '1.B.1.b', 'OI', 4.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.02', '1.B.1.c', 'OI', 4.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.02', '1.B.1.d', 'OI', 5.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.02', '1.B.1.e', 'OI', 2.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.02', '1.B.1.f', 'OI', 3.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.02', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.02', '1.B.1.h', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1129.02', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1131.00', '1.B.1.a', 'OI', 5.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1131.00', '1.B.1.b', 'OI', 5.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1131.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1131.00', '1.B.1.d', 'OI', 3.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1131.00', '1.B.1.e', 'OI', 1.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1131.00', '1.B.1.f', 'OI', 3.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1131.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1131.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1131.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.00', '1.B.1.a', 'OI', 3.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.00', '1.B.1.b', 'OI', 4.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.00', '1.B.1.c', 'OI', 1.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.00', '1.B.1.d', 'OI', 5.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.00', '1.B.1.e', 'OI', 2.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.00', '1.B.1.f', 'OI', 4.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.01', '1.B.1.a', 'OI', 3.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.01', '1.B.1.b', 'OI', 5.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.01', '1.B.1.c', 'OI', 1.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.01', '1.B.1.d', 'OI', 5.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.01', '1.B.1.e', 'OI', 1.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.01', '1.B.1.f', 'OI', 3.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.01', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.01', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.02', '1.B.1.a', 'OI', 2.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.02', '1.B.1.b', 'OI', 5.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.02', '1.B.1.c', 'OI', 2.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.02', '1.B.1.d', 'OI', 6.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.02', '1.B.1.e', 'OI', 2.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.02', '1.B.1.f', 'OI', 3.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.02', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.02', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.02', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.03', '1.B.1.a', 'OI', 3.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.03', '1.B.1.b', 'OI', 5.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.03', '1.B.1.c', 'OI', 1.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.03', '1.B.1.d', 'OI', 5.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.03', '1.B.1.e', 'OI', 2.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.03', '1.B.1.f', 'OI', 4.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.03', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.03', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.03', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.04', '1.B.1.a', 'OI', 2.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.04', '1.B.1.b', 'OI', 4.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.04', '1.B.1.c', 'OI', 1.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.04', '1.B.1.d', 'OI', 6.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.04', '1.B.1.e', 'OI', 3.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.04', '1.B.1.f', 'OI', 4.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.04', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.04', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1141.04', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1151.00', '1.B.1.a', 'OI', 4.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1151.00', '1.B.1.b', 'OI', 5.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1151.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1151.00', '1.B.1.d', 'OI', 5.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1151.00', '1.B.1.e', 'OI', 1.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1151.00', '1.B.1.f', 'OI', 4.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1151.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1151.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1151.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1161.00', '1.B.1.a', 'OI', 3.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1161.00', '1.B.1.b', 'OI', 4.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1161.00', '1.B.1.c', 'OI', 1.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1161.00', '1.B.1.d', 'OI', 5.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1161.00', '1.B.1.e', 'OI', 2.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1161.00', '1.B.1.f', 'OI', 3.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1161.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1161.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1161.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1171.00', '1.B.1.a', 'OI', 3.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1171.00', '1.B.1.b', 'OI', 5.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1171.00', '1.B.1.c', 'OI', 1.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1171.00', '1.B.1.d', 'OI', 5.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1171.00', '1.B.1.e', 'OI', 2.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1171.00', '1.B.1.f', 'OI', 4.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1171.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1171.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1171.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1181.00', '1.B.1.a', 'OI', 3.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1181.00', '1.B.1.b', 'OI', 5.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1181.00', '1.B.1.c', 'OI', 2.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1181.00', '1.B.1.d', 'OI', 5.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1181.00', '1.B.1.e', 'OI', 1.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1181.00', '1.B.1.f', 'OI', 3.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1181.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1181.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1181.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1211.00', '1.B.1.a', 'OI', 5.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1211.00', '1.B.1.b', 'OI', 5.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1211.00', '1.B.1.c', 'OI', 1.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1211.00', '1.B.1.d', 'OI', 5.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1211.00', '1.B.1.e', 'OI', 2.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1211.00', '1.B.1.f', 'OI', 3.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1211.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1211.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1211.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1212.00', '1.B.1.a', 'OI', 4.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1212.00', '1.B.1.b', 'OI', 6.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1212.00', '1.B.1.c', 'OI', 1.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1212.00', '1.B.1.d', 'OI', 4.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1212.00', '1.B.1.e', 'OI', 2.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1212.00', '1.B.1.f', 'OI', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1212.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1212.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1212.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1213.00', '1.B.1.a', 'OI', 4.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1213.00', '1.B.1.b', 'OI', 6.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1213.00', '1.B.1.c', 'OI', 1.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1213.00', '1.B.1.d', 'OI', 4.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1213.00', '1.B.1.e', 'OI', 1.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1213.00', '1.B.1.f', 'OI', 3.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1213.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1213.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1213.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1214.00', '1.B.1.a', 'OI', 4.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1214.00', '1.B.1.b', 'OI', 5.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1214.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1214.00', '1.B.1.d', 'OI', 5.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1214.00', '1.B.1.e', 'OI', 2.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1214.00', '1.B.1.f', 'OI', 4.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1214.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1214.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1214.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1215.00', '1.B.1.a', 'OI', 3.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1215.00', '1.B.1.b', 'OI', 6.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1215.00', '1.B.1.c', 'OI', 1.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1215.00', '1.B.1.d', 'OI', 6.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1215.00', '1.B.1.e', 'OI', 2.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1215.00', '1.B.1.f', 'OI', 3.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1215.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1215.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1215.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1216.00', '1.B.1.a', 'OI', 4.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1216.00', '1.B.1.b', 'OI', 6.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1216.00', '1.B.1.c', 'OI', 1.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1216.00', '1.B.1.d', 'OI', 6.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1216.00', '1.B.1.e', 'OI', 2.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1216.00', '1.B.1.f', 'OI', 3.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1216.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1216.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1216.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1217.00', '1.B.1.a', 'OI', 4.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1217.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1217.00', '1.B.1.c', 'OI', 2.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1217.00', '1.B.1.d', 'OI', 5.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1217.00', '1.B.1.e', 'OI', 2.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1217.00', '1.B.1.f', 'OI', 3.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1217.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1217.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1217.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1218.00', '1.B.1.a', 'OI', 4.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1218.00', '1.B.1.b', 'OI', 5.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1218.00', '1.B.1.c', 'OI', 1.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1218.00', '1.B.1.d', 'OI', 5.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1218.00', '1.B.1.e', 'OI', 2.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1218.00', '1.B.1.f', 'OI', 3.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1218.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1218.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1218.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1221.00', '1.B.1.a', 'OI', 3.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1221.00', '1.B.1.b', 'OI', 6.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1221.00', '1.B.1.c', 'OI', 1.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1221.00', '1.B.1.d', 'OI', 6.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1221.00', '1.B.1.e', 'OI', 2.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1221.00', '1.B.1.f', 'OI', 3.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1221.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1221.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1221.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1222.00', '1.B.1.a', 'OI', 4.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1222.00', '1.B.1.b', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1222.00', '1.B.1.c', 'OI', 1.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1222.00', '1.B.1.d', 'OI', 3.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1222.00', '1.B.1.e', 'OI', 1.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1222.00', '1.B.1.f', 'OI', 4.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1222.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1222.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1222.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1223.00', '1.B.1.a', 'OI', 2.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1223.00', '1.B.1.b', 'OI', 6.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1223.00', '1.B.1.c', 'OI', 2.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1223.00', '1.B.1.d', 'OI', 5.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1223.00', '1.B.1.e', 'OI', 1.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1223.00', '1.B.1.f', 'OI', 3.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1223.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1223.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1223.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1224.00', '1.B.1.a', 'OI', 4.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1224.00', '1.B.1.b', 'OI', 6.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1224.00', '1.B.1.c', 'OI', 1.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1224.00', '1.B.1.d', 'OI', 3.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1224.00', '1.B.1.e', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1224.00', '1.B.1.f', 'OI', 4.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1224.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1224.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1224.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.01', '1.B.1.a', 'OI', 3.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.01', '1.B.1.b', 'OI', 6.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.01', '1.B.1.c', 'OI', 1.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.01', '1.B.1.d', 'OI', 5.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.01', '1.B.1.e', 'OI', 2.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.01', '1.B.1.f', 'OI', 3.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.01', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.01', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.02', '1.B.1.a', 'OI', 3.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.02', '1.B.1.b', 'OI', 4.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.02', '1.B.1.c', 'OI', 1.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.02', '1.B.1.d', 'OI', 6.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.02', '1.B.1.e', 'OI', 3.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.02', '1.B.1.f', 'OI', 3.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.02', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.02', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.02', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.03', '1.B.1.a', 'OI', 4.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.03', '1.B.1.b', 'OI', 6.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.03', '1.B.1.c', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.03', '1.B.1.d', 'OI', 5.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.03', '1.B.1.e', 'OI', 2.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.03', '1.B.1.f', 'OI', 3.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.03', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.03', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.03', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.04', '1.B.1.a', 'OI', 4.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.04', '1.B.1.b', 'OI', 6.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.04', '1.B.1.c', 'OI', 1.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.04', '1.B.1.d', 'OI', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.04', '1.B.1.e', 'OI', 1.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.04', '1.B.1.f', 'OI', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.04', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.04', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.04', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.05', '1.B.1.a', 'OI', 3.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.05', '1.B.1.b', 'OI', 6.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.05', '1.B.1.c', 'OI', 1.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.05', '1.B.1.d', 'OI', 5.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.05', '1.B.1.e', 'OI', 2.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.05', '1.B.1.f', 'OI', 3.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.05', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.05', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.05', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.06', '1.B.1.a', 'OI', 5.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.06', '1.B.1.b', 'OI', 5.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.06', '1.B.1.c', 'OI', 1.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.06', '1.B.1.d', 'OI', 5.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.06', '1.B.1.e', 'OI', 3.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.06', '1.B.1.f', 'OI', 3.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.06', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.06', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1229.06', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1241.00', '1.B.1.a', 'OI', 4.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1241.00', '1.B.1.b', 'OI', 6.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1241.00', '1.B.1.c', 'OI', 1.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1241.00', '1.B.1.d', 'OI', 5.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1241.00', '1.B.1.e', 'OI', 2.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1241.00', '1.B.1.f', 'OI', 3.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1241.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1241.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1241.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1242.00', '1.B.1.a', 'OI', 5.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1242.00', '1.B.1.b', 'OI', 6.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1242.00', '1.B.1.c', 'OI', 1.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1242.00', '1.B.1.d', 'OI', 4.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1242.00', '1.B.1.e', 'OI', 2.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1242.00', '1.B.1.f', 'OI', 3.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1242.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1242.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1242.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1243.00', '1.B.1.a', 'OI', 4.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1243.00', '1.B.1.b', 'OI', 6.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1243.00', '1.B.1.c', 'OI', 1.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1243.00', '1.B.1.d', 'OI', 4.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1243.00', '1.B.1.e', 'OI', 2.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1243.00', '1.B.1.f', 'OI', 3.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1243.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1243.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1243.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1291.00', '1.B.1.a', 'OI', 4.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1291.00', '1.B.1.b', 'OI', 5.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1291.00', '1.B.1.c', 'OI', 2.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1291.00', '1.B.1.d', 'OI', 5.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1291.00', '1.B.1.e', 'OI', 1.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1291.00', '1.B.1.f', 'OI', 3.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1291.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1291.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1291.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1292.00', '1.B.1.a', 'OI', 5.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1292.00', '1.B.1.b', 'OI', 4.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1292.00', '1.B.1.c', 'OI', 1.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1292.00', '1.B.1.d', 'OI', 5.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1292.00', '1.B.1.e', 'OI', 1.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1292.00', '1.B.1.f', 'OI', 4.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1292.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1292.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1292.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.01', '1.B.1.a', 'OI', 4.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.01', '1.B.1.b', 'OI', 5.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.01', '1.B.1.c', 'OI', 1.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.01', '1.B.1.d', 'OI', 5.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.01', '1.B.1.e', 'OI', 1.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.01', '1.B.1.f', 'OI', 3.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.01', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.01', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.02', '1.B.1.a', 'OI', 4.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.02', '1.B.1.b', 'OI', 5.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.02', '1.B.1.c', 'OI', 1.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.02', '1.B.1.d', 'OI', 4.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.02', '1.B.1.e', 'OI', 1.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.02', '1.B.1.f', 'OI', 3.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.02', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.02', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-1299.02', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.00', '1.B.1.a', 'OI', 5.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.00', '1.B.1.b', 'OI', 6.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.00', '1.B.1.c', 'OI', 1.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.00', '1.B.1.d', 'OI', 2.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.00', '1.B.1.e', 'OI', 1.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.00', '1.B.1.f', 'OI', 4.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.01', '1.B.1.a', 'OI', 5.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.01', '1.B.1.b', 'OI', 5.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.01', '1.B.1.c', 'OI', 1.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.01', '1.B.1.d', 'OI', 1.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.01', '1.B.1.e', 'OI', 1.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.01', '1.B.1.f', 'OI', 5.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.01', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.02', '1.B.1.a', 'OI', 5.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.02', '1.B.1.b', 'OI', 6.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.02', '1.B.1.c', 'OI', 1.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.02', '1.B.1.d', 'OI', 2.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.02', '1.B.1.e', 'OI', 1.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.02', '1.B.1.f', 'OI', 4.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.02', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.02', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.02', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.04', '1.B.1.a', 'OI', 5.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.04', '1.B.1.b', 'OI', 6.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.04', '1.B.1.c', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.04', '1.B.1.d', 'OI', 2.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.04', '1.B.1.e', 'OI', 1.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.04', '1.B.1.f', 'OI', 5.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.04', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.04', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2011.04', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.00', '1.B.1.a', 'OI', 6.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.00', '1.B.1.b', 'OI', 5.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.00', '1.B.1.d', 'OI', 2.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.00', '1.B.1.e', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.00', '1.B.1.f', 'OI', 4.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.01', '1.B.1.a', 'OI', 6.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.01', '1.B.1.b', 'OI', 5.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.01', '1.B.1.c', 'OI', 1.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.01', '1.B.1.d', 'OI', 2.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.01', '1.B.1.e', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.01', '1.B.1.f', 'OI', 5.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.01', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.01', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2012.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2031.00', '1.B.1.a', 'OI', 5.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2031.00', '1.B.1.b', 'OI', 5.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2031.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2031.00', '1.B.1.d', 'OI', 4.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2031.00', '1.B.1.e', 'OI', 1.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2031.00', '1.B.1.f', 'OI', 4.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2031.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2031.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2031.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2032.00', '1.B.1.a', 'OI', 5.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2032.00', '1.B.1.b', 'OI', 4.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2032.00', '1.B.1.c', 'OI', 1.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2032.00', '1.B.1.d', 'OI', 4.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2032.00', '1.B.1.e', 'OI', 1.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2032.00', '1.B.1.f', 'OI', 5.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2032.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2032.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2032.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2033.00', '1.B.1.a', 'OI', 5.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2033.00', '1.B.1.b', 'OI', 5.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2033.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2033.00', '1.B.1.d', 'OI', 3.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2033.00', '1.B.1.e', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2033.00', '1.B.1.f', 'OI', 5.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2033.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2033.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2033.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2034.00', '1.B.1.a', 'OI', 5.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2034.00', '1.B.1.b', 'OI', 4.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2034.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2034.00', '1.B.1.d', 'OI', 3.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2034.00', '1.B.1.e', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2034.00', '1.B.1.f', 'OI', 5.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2034.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2034.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2034.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2035.00', '1.B.1.a', 'OI', 5.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2035.00', '1.B.1.b', 'OI', 4.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2035.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2035.00', '1.B.1.d', 'OI', 3.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2035.00', '1.B.1.e', 'OI', 1.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2035.00', '1.B.1.f', 'OI', 4.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2035.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2035.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2035.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2036.00', '1.B.1.a', 'OI', 4.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2036.00', '1.B.1.b', 'OI', 5.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2036.00', '1.B.1.c', 'OI', 1.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2036.00', '1.B.1.d', 'OI', 3.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2036.00', '1.B.1.e', 'OI', 2.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2036.00', '1.B.1.f', 'OI', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2036.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2036.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2036.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2042.00', '1.B.1.a', 'OI', 5.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2042.00', '1.B.1.b', 'OI', 4.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2042.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2042.00', '1.B.1.d', 'OI', 5.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2042.00', '1.B.1.e', 'OI', 1.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2042.00', '1.B.1.f', 'OI', 3.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2042.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2042.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2042.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2043.00', '1.B.1.a', 'OI', 5.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2043.00', '1.B.1.b', 'OI', 5.03, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2043.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2043.00', '1.B.1.d', 'OI', 5.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2043.00', '1.B.1.e', 'OI', 1.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2043.00', '1.B.1.f', 'OI', 3.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2043.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2043.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2043.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2051.00', '1.B.1.a', 'OI', 3.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2051.00', '1.B.1.b', 'OI', 3.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2051.00', '1.B.1.c', 'OI', 2.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2051.00', '1.B.1.d', 'OI', 5.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2051.00', '1.B.1.e', 'OI', 2.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2051.00', '1.B.1.f', 'OI', 3.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2051.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2051.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2051.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2052.00', '1.B.1.a', 'OI', 4.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2052.00', '1.B.1.b', 'OI', 2.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2052.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2052.00', '1.B.1.d', 'OI', 3.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2052.00', '1.B.1.e', 'OI', 2.52, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2052.00', '1.B.1.f', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2052.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2052.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2052.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2053.00', '1.B.1.a', 'OI', 3.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2053.00', '1.B.1.b', 'OI', 4.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2053.00', '1.B.1.c', 'OI', 2.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2053.00', '1.B.1.d', 'OI', 6.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2053.00', '1.B.1.e', 'OI', 1.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2053.00', '1.B.1.f', 'OI', 3.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2053.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2053.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2053.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2055.00', '1.B.1.a', 'OI', 6.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2055.00', '1.B.1.b', 'OI', 3.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2055.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2055.00', '1.B.1.d', 'OI', 3.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2055.00', '1.B.1.e', 'OI', 1.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2055.00', '1.B.1.f', 'OI', 4.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2055.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2055.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2055.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2056.00', '1.B.1.a', 'OI', 6.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2056.00', '1.B.1.b', 'OI', 5.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2056.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2056.00', '1.B.1.d', 'OI', 3.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2056.00', '1.B.1.e', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2056.00', '1.B.1.f', 'OI', 4.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2056.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2056.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2056.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2057.00', '1.B.1.a', 'OI', 5.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2057.00', '1.B.1.b', 'OI', 4.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2057.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2057.00', '1.B.1.d', 'OI', 4.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2057.00', '1.B.1.e', 'OI', 1.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2057.00', '1.B.1.f', 'OI', 4.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2057.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2057.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2057.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2061.00', '1.B.1.a', 'OI', 4.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2061.00', '1.B.1.b', 'OI', 3.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2061.00', '1.B.1.c', 'OI', 1.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2061.00', '1.B.1.d', 'OI', 5.50, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2061.00', '1.B.1.e', 'OI', 2.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2061.00', '1.B.1.f', 'OI', 4.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2061.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2061.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2061.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2072.00', '1.B.1.a', 'OI', 2.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2072.00', '1.B.1.b', 'OI', 4.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2072.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2072.00', '1.B.1.d', 'OI', 3.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2072.00', '1.B.1.e', 'OI', 1.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2072.00', '1.B.1.f', 'OI', 6.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2072.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2072.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2072.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2081.00', '1.B.1.a', 'OI', 4.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2081.00', '1.B.1.b', 'OI', 2.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2081.00', '1.B.1.c', 'OI', 1.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2081.00', '1.B.1.d', 'OI', 3.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2081.00', '1.B.1.e', 'OI', 3.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2081.00', '1.B.1.f', 'OI', 5.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2081.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2081.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2081.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2091.00', '1.B.1.a', 'OI', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2091.00', '1.B.1.b', 'OI', 5.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2091.00', '1.B.1.c', 'OI', 1.99, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2091.00', '1.B.1.d', 'OI', 4.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2091.00', '1.B.1.e', 'OI', 1.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2091.00', '1.B.1.f', 'OI', 3.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2091.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2091.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2091.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2092.00', '1.B.1.a', 'OI', 3.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2092.00', '1.B.1.b', 'OI', 4.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2092.00', '1.B.1.c', 'OI', 1.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2092.00', '1.B.1.d', 'OI', 4.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2092.00', '1.B.1.e', 'OI', 1.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2092.00', '1.B.1.f', 'OI', 4.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2092.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2092.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2092.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.01', '1.B.1.a', 'OI', 5.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.01', '1.B.1.b', 'OI', 5.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.01', '1.B.1.c', 'OI', 1.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.01', '1.B.1.d', 'OI', 3.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.01', '1.B.1.e', 'OI', 1.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.01', '1.B.1.f', 'OI', 4.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.01', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.01', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.05', '1.B.1.a', 'OI', 5.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.05', '1.B.1.b', 'OI', 4.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.05', '1.B.1.c', 'OI', 1.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.05', '1.B.1.d', 'OI', 4.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.05', '1.B.1.e', 'OI', 2.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.05', '1.B.1.f', 'OI', 4.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.05', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.05', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.05', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.08', '1.B.1.a', 'OI', 1.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.08', '1.B.1.b', 'OI', 4.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.08', '1.B.1.c', 'OI', 1.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.08', '1.B.1.d', 'OI', 6.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.08', '1.B.1.e', 'OI', 3.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.08', '1.B.1.f', 'OI', 3.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.08', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.08', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-2099.08', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9021.00', '1.B.1.a', 'OI', 2.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9021.00', '1.B.1.b', 'OI', 5.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9021.00', '1.B.1.c', 'OI', 1.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9021.00', '1.B.1.d', 'OI', 3.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9021.00', '1.B.1.e', 'OI', 2.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9021.00', '1.B.1.f', 'OI', 5.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9021.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9021.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9021.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9091.00', '1.B.1.a', 'OI', 5.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9091.00', '1.B.1.b', 'OI', 4.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9091.00', '1.B.1.c', 'OI', 1.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9091.00', '1.B.1.d', 'OI', 5.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9091.00', '1.B.1.e', 'OI', 2.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9091.00', '1.B.1.f', 'OI', 3.22, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9091.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9091.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9091.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9092.00', '1.B.1.a', 'OI', 1.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9092.00', '1.B.1.b', 'OI', 5.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9092.00', '1.B.1.c', 'OI', 2.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9092.00', '1.B.1.d', 'OI', 5.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9092.00', '1.B.1.e', 'OI', 2.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9092.00', '1.B.1.f', 'OI', 3.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9092.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9092.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9092.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9093.00', '1.B.1.a', 'OI', 5.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9093.00', '1.B.1.b', 'OI', 3.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9093.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9093.00', '1.B.1.d', 'OI', 3.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9093.00', '1.B.1.e', 'OI', 1.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9093.00', '1.B.1.f', 'OI', 4.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9093.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9093.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9093.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9099.01', '1.B.1.a', 'OI', 3.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9099.01', '1.B.1.b', 'OI', 3.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9099.01', '1.B.1.c', 'OI', 1.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9099.01', '1.B.1.d', 'OI', 6.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9099.01', '1.B.1.e', 'OI', 2.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9099.01', '1.B.1.f', 'OI', 3.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9099.01', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9099.01', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('29-9099.01', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1121.00', '1.B.1.a', 'OI', 4.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1121.00', '1.B.1.b', 'OI', 3.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1121.00', '1.B.1.c', 'OI', 1.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1121.00', '1.B.1.d', 'OI', 6.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1121.00', '1.B.1.e', 'OI', 1.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1121.00', '1.B.1.f', 'OI', 3.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1121.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1121.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1121.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1122.00', '1.B.1.a', 'OI', 3.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1122.00', '1.B.1.b', 'OI', 1.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1122.00', '1.B.1.c', 'OI', 1.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1122.00', '1.B.1.d', 'OI', 6.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1122.00', '1.B.1.e', 'OI', 2.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1122.00', '1.B.1.f', 'OI', 3.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1122.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1122.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1122.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1131.00', '1.B.1.a', 'OI', 4.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1131.00', '1.B.1.b', 'OI', 2.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1131.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1131.00', '1.B.1.d', 'OI', 5.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1131.00', '1.B.1.e', 'OI', 1.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1131.00', '1.B.1.f', 'OI', 4.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1131.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1131.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1131.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1132.00', '1.B.1.a', 'OI', 5.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1132.00', '1.B.1.b', 'OI', 2.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1132.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1132.00', '1.B.1.d', 'OI', 4.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1132.00', '1.B.1.e', 'OI', 1.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1132.00', '1.B.1.f', 'OI', 4.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1132.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1132.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1132.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1133.00', '1.B.1.a', 'OI', 3.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1133.00', '1.B.1.b', 'OI', 4.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1133.00', '1.B.1.c', 'OI', 1.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1133.00', '1.B.1.d', 'OI', 6.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1133.00', '1.B.1.e', 'OI', 1.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1133.00', '1.B.1.f', 'OI', 3.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1133.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1133.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-1133.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2011.00', '1.B.1.a', 'OI', 3.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2011.00', '1.B.1.b', 'OI', 3.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2011.00', '1.B.1.c', 'OI', 2.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2011.00', '1.B.1.d', 'OI', 6.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2011.00', '1.B.1.e', 'OI', 1.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2011.00', '1.B.1.f', 'OI', 4.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2011.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2011.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2012.00', '1.B.1.a', 'OI', 3.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2012.00', '1.B.1.b', 'OI', 2.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2012.00', '1.B.1.c', 'OI', 1.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2012.00', '1.B.1.d', 'OI', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2012.00', '1.B.1.e', 'OI', 1.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2012.00', '1.B.1.f', 'OI', 3.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2012.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2012.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2012.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2021.00', '1.B.1.a', 'OI', 4.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2021.00', '1.B.1.b', 'OI', 3.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2021.00', '1.B.1.c', 'OI', 1.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2021.00', '1.B.1.d', 'OI', 6.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2021.00', '1.B.1.e', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2021.00', '1.B.1.f', 'OI', 3.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2021.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2021.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2021.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2022.00', '1.B.1.a', 'OI', 4.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2022.00', '1.B.1.b', 'OI', 2.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2022.00', '1.B.1.c', 'OI', 1.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2022.00', '1.B.1.d', 'OI', 5.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2022.00', '1.B.1.e', 'OI', 2.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2022.00', '1.B.1.f', 'OI', 3.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2022.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2022.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-2022.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9011.00', '1.B.1.a', 'OI', 4.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9011.00', '1.B.1.b', 'OI', 3.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9011.00', '1.B.1.c', 'OI', 2.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9011.00', '1.B.1.d', 'OI', 5.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9011.00', '1.B.1.e', 'OI', 2.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9011.00', '1.B.1.f', 'OI', 2.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9011.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9011.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9011.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9091.00', '1.B.1.a', 'OI', 4.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9091.00', '1.B.1.b', 'OI', 3.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9091.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9091.00', '1.B.1.d', 'OI', 4.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9091.00', '1.B.1.e', 'OI', 1.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9091.00', '1.B.1.f', 'OI', 5.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9091.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9091.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9091.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9092.00', '1.B.1.a', 'OI', 4.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9092.00', '1.B.1.b', 'OI', 3.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9092.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9092.00', '1.B.1.d', 'OI', 4.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9092.00', '1.B.1.e', 'OI', 1.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9092.00', '1.B.1.f', 'OI', 5.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9092.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9092.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9092.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9093.00', '1.B.1.a', 'OI', 6.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9093.00', '1.B.1.b', 'OI', 3.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9093.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9093.00', '1.B.1.d', 'OI', 2.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9093.00', '1.B.1.e', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9093.00', '1.B.1.f', 'OI', 5.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9093.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9093.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9093.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9094.00', '1.B.1.a', 'OI', 2.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9094.00', '1.B.1.b', 'OI', 3.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9094.00', '1.B.1.c', 'OI', 1.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9094.00', '1.B.1.d', 'OI', 3.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9094.00', '1.B.1.e', 'OI', 1.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9094.00', '1.B.1.f', 'OI', 6.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9094.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9094.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9094.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9095.00', '1.B.1.a', 'OI', 3.75, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9095.00', '1.B.1.b', 'OI', 1.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9095.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9095.00', '1.B.1.d', 'OI', 3.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9095.00', '1.B.1.e', 'OI', 3.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9095.00', '1.B.1.f', 'OI', 6.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9095.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9095.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9095.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9096.00', '1.B.1.a', 'OI', 6.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9096.00', '1.B.1.b', 'OI', 4.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9096.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9096.00', '1.B.1.d', 'OI', 3.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9096.00', '1.B.1.e', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9096.00', '1.B.1.f', 'OI', 3.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9096.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9096.00', '1.B.1.h', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9096.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9097.00', '1.B.1.a', 'OI', 5.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9097.00', '1.B.1.b', 'OI', 4.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9097.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9097.00', '1.B.1.d', 'OI', 3.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9097.00', '1.B.1.e', 'OI', 1.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9097.00', '1.B.1.f', 'OI', 5.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9097.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9097.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9097.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.01', '1.B.1.a', 'OI', 2.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.01', '1.B.1.b', 'OI', 4.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.01', '1.B.1.c', 'OI', 2.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.01', '1.B.1.d', 'OI', 5.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.01', '1.B.1.e', 'OI', 1.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.01', '1.B.1.f', 'OI', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.01', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.01', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.01', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.02', '1.B.1.a', 'OI', 6.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.02', '1.B.1.b', 'OI', 4.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.02', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.02', '1.B.1.d', 'OI', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.02', '1.B.1.e', 'OI', 1.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.02', '1.B.1.f', 'OI', 5.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.02', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.02', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('31-9099.02', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1011.00', '1.B.1.a', 'OI', 3.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1011.00', '1.B.1.b', 'OI', 1.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1011.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1011.00', '1.B.1.d', 'OI', 4.54, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1011.00', '1.B.1.e', 'OI', 6.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1011.00', '1.B.1.f', 'OI', 5.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1011.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1011.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1012.00', '1.B.1.a', 'OI', 3.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1012.00', '1.B.1.b', 'OI', 2.34, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1012.00', '1.B.1.c', 'OI', 1.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1012.00', '1.B.1.d', 'OI', 3.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1012.00', '1.B.1.e', 'OI', 6.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1012.00', '1.B.1.f', 'OI', 5.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1012.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1012.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1012.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1021.00', '1.B.1.a', 'OI', 5.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1021.00', '1.B.1.b', 'OI', 2.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1021.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1021.00', '1.B.1.d', 'OI', 3.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1021.00', '1.B.1.e', 'OI', 6.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1021.00', '1.B.1.f', 'OI', 4.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1021.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1021.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1021.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1091.00', '1.B.1.a', 'OI', 4.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1091.00', '1.B.1.b', 'OI', 1.82, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1091.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1091.00', '1.B.1.d', 'OI', 3.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1091.00', '1.B.1.e', 'OI', 5.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1091.00', '1.B.1.f', 'OI', 5.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1091.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1091.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-1091.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2011.00', '1.B.1.a', 'OI', 6.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2011.00', '1.B.1.b', 'OI', 2.92, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2011.00', '1.B.1.c', 'OI', 1.31, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2011.00', '1.B.1.d', 'OI', 3.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2011.00', '1.B.1.e', 'OI', 3.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2011.00', '1.B.1.f', 'OI', 3.47, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2011.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2011.00', '1.B.1.h', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2011.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2021.00', '1.B.1.a', 'OI', 5.49, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2021.00', '1.B.1.b', 'OI', 4.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2021.00', '1.B.1.c', 'OI', 1.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2021.00', '1.B.1.d', 'OI', 2.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2021.00', '1.B.1.e', 'OI', 3.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2021.00', '1.B.1.f', 'OI', 5.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2021.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2021.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2021.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2022.00', '1.B.1.a', 'OI', 6.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2022.00', '1.B.1.b', 'OI', 3.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2022.00', '1.B.1.c', 'OI', 1.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2022.00', '1.B.1.d', 'OI', 3.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2022.00', '1.B.1.e', 'OI', 3.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2022.00', '1.B.1.f', 'OI', 4.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2022.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2022.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-2022.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3011.00', '1.B.1.a', 'OI', 4.79, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3011.00', '1.B.1.b', 'OI', 2.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3011.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3011.00', '1.B.1.d', 'OI', 3.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3011.00', '1.B.1.e', 'OI', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3011.00', '1.B.1.f', 'OI', 4.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3011.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3011.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3012.00', '1.B.1.a', 'OI', 5.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3012.00', '1.B.1.b', 'OI', 1.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3012.00', '1.B.1.c', 'OI', 1.05, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3012.00', '1.B.1.d', 'OI', 3.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3012.00', '1.B.1.e', 'OI', 3.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3012.00', '1.B.1.f', 'OI', 4.81, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3012.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3012.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3012.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.00', '1.B.1.a', 'OI', 4.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.00', '1.B.1.b', 'OI', 4.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.00', '1.B.1.c', 'OI', 1.20, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.00', '1.B.1.d', 'OI', 2.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.00', '1.B.1.e', 'OI', 4.04, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.00', '1.B.1.f', 'OI', 4.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.00', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.02', '1.B.1.a', 'OI', 4.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.02', '1.B.1.b', 'OI', 3.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.02', '1.B.1.c', 'OI', 1.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.02', '1.B.1.d', 'OI', 1.97, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.02', '1.B.1.e', 'OI', 2.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.02', '1.B.1.f', 'OI', 5.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.02', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.02', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.02', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.06', '1.B.1.a', 'OI', 2.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.06', '1.B.1.b', 'OI', 5.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.06', '1.B.1.c', 'OI', 2.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.06', '1.B.1.d', 'OI', 1.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.06', '1.B.1.e', 'OI', 3.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.06', '1.B.1.f', 'OI', 5.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.06', '1.B.1.g', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.06', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3021.06', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3031.00', '1.B.1.a', 'OI', 6.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3031.00', '1.B.1.b', 'OI', 3.91, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3031.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3031.00', '1.B.1.d', 'OI', 2.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3031.00', '1.B.1.e', 'OI', 3.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3031.00', '1.B.1.f', 'OI', 4.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3031.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3031.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3031.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3041.00', '1.B.1.a', 'OI', 6.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3041.00', '1.B.1.b', 'OI', 1.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3041.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3041.00', '1.B.1.d', 'OI', 2.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3041.00', '1.B.1.e', 'OI', 3.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3041.00', '1.B.1.f', 'OI', 5.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3041.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3041.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3041.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.00', '1.B.1.a', 'OI', 5.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.00', '1.B.1.b', 'OI', 2.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.00', '1.B.1.c', 'OI', 1.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.00', '1.B.1.d', 'OI', 3.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.00', '1.B.1.e', 'OI', 4.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.00', '1.B.1.f', 'OI', 4.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.04', '1.B.1.a', 'OI', 3.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.04', '1.B.1.b', 'OI', 2.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.04', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.04', '1.B.1.d', 'OI', 2.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.04', '1.B.1.e', 'OI', 4.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.04', '1.B.1.f', 'OI', 5.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.04', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.04', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3051.04', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3052.00', '1.B.1.a', 'OI', 6.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3052.00', '1.B.1.b', 'OI', 2.28, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3052.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3052.00', '1.B.1.d', 'OI', 2.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3052.00', '1.B.1.e', 'OI', 3.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3052.00', '1.B.1.f', 'OI', 4.94, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3052.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3052.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-3052.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9011.00', '1.B.1.a', 'OI', 5.93, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9011.00', '1.B.1.b', 'OI', 3.59, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9011.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9011.00', '1.B.1.d', 'OI', 2.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9011.00', '1.B.1.e', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9011.00', '1.B.1.f', 'OI', 3.89, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9011.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9011.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9021.00', '1.B.1.a', 'OI', 2.39, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9021.00', '1.B.1.b', 'OI', 3.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9021.00', '1.B.1.c', 'OI', 1.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9021.00', '1.B.1.d', 'OI', 2.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9021.00', '1.B.1.e', 'OI', 4.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9021.00', '1.B.1.f', 'OI', 5.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9021.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9021.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9021.00', '1.B.1.i', 'IH', 2.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9031.00', '1.B.1.a', 'OI', 4.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9031.00', '1.B.1.b', 'OI', 2.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9031.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9031.00', '1.B.1.d', 'OI', 2.15, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9031.00', '1.B.1.e', 'OI', 4.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9031.00', '1.B.1.f', 'OI', 5.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9031.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9031.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9031.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9032.00', '1.B.1.a', 'OI', 6.41, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9032.00', '1.B.1.b', 'OI', 2.29, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9032.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9032.00', '1.B.1.d', 'OI', 2.64, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9032.00', '1.B.1.e', 'OI', 2.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9032.00', '1.B.1.f', 'OI', 4.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9032.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9032.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9032.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9091.00', '1.B.1.a', 'OI', 5.86, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9091.00', '1.B.1.b', 'OI', 1.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9091.00', '1.B.1.c', 'OI', 1.11, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9091.00', '1.B.1.d', 'OI', 3.08, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9091.00', '1.B.1.e', 'OI', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9091.00', '1.B.1.f', 'OI', 3.62, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9091.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9091.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9091.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9092.00', '1.B.1.a', 'OI', 6.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9092.00', '1.B.1.b', 'OI', 2.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9092.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9092.00', '1.B.1.d', 'OI', 4.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9092.00', '1.B.1.e', 'OI', 2.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9092.00', '1.B.1.f', 'OI', 3.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9092.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9092.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9092.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9093.00', '1.B.1.a', 'OI', 5.21, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9093.00', '1.B.1.b', 'OI', 2.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9093.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9093.00', '1.B.1.d', 'OI', 2.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9093.00', '1.B.1.e', 'OI', 2.61, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9093.00', '1.B.1.f', 'OI', 5.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9093.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9093.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9093.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9094.00', '1.B.1.a', 'OI', 3.43, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9094.00', '1.B.1.b', 'OI', 1.51, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9094.00', '1.B.1.c', 'OI', 1.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9094.00', '1.B.1.d', 'OI', 5.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9094.00', '1.B.1.e', 'OI', 1.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9094.00', '1.B.1.f', 'OI', 4.76, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9094.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9094.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9094.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9099.02', '1.B.1.a', 'OI', 3.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9099.02', '1.B.1.b', 'OI', 3.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9099.02', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9099.02', '1.B.1.d', 'OI', 2.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9099.02', '1.B.1.e', 'OI', 4.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9099.02', '1.B.1.f', 'OI', 5.67, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9099.02', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9099.02', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('33-9099.02', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1011.00', '1.B.1.a', 'OI', 4.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1011.00', '1.B.1.b', 'OI', 1.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1011.00', '1.B.1.c', 'OI', 2.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1011.00', '1.B.1.d', 'OI', 2.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1011.00', '1.B.1.e', 'OI', 5.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1011.00', '1.B.1.f', 'OI', 4.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1011.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1011.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1011.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1012.00', '1.B.1.a', 'OI', 4.60, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1012.00', '1.B.1.b', 'OI', 1.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1012.00', '1.B.1.c', 'OI', 1.25, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1012.00', '1.B.1.d', 'OI', 3.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1012.00', '1.B.1.e', 'OI', 6.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1012.00', '1.B.1.f', 'OI', 4.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1012.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1012.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-1012.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2011.00', '1.B.1.a', 'OI', 6.33, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2011.00', '1.B.1.b', 'OI', 1.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2011.00', '1.B.1.c', 'OI', 1.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2011.00', '1.B.1.d', 'OI', 2.42, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2011.00', '1.B.1.e', 'OI', 3.36, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2011.00', '1.B.1.f', 'OI', 4.32, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2011.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2011.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2012.00', '1.B.1.a', 'OI', 5.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2012.00', '1.B.1.b', 'OI', 1.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2012.00', '1.B.1.c', 'OI', 2.01, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2012.00', '1.B.1.d', 'OI', 3.17, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2012.00', '1.B.1.e', 'OI', 3.16, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2012.00', '1.B.1.f', 'OI', 4.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2012.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2012.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2012.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2013.00', '1.B.1.a', 'OI', 4.98, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2013.00', '1.B.1.b', 'OI', 1.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2013.00', '1.B.1.c', 'OI', 3.77, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2013.00', '1.B.1.d', 'OI', 3.78, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2013.00', '1.B.1.e', 'OI', 3.55, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2013.00', '1.B.1.f', 'OI', 3.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2013.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2013.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2013.00', '1.B.1.i', 'IH', 3.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2014.00', '1.B.1.a', 'OI', 5.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2014.00', '1.B.1.b', 'OI', 1.56, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2014.00', '1.B.1.c', 'OI', 2.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2014.00', '1.B.1.d', 'OI', 2.88, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2014.00', '1.B.1.e', 'OI', 3.69, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2014.00', '1.B.1.f', 'OI', 3.80, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2014.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2014.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2014.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2015.00', '1.B.1.a', 'OI', 6.13, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2015.00', '1.B.1.b', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2015.00', '1.B.1.c', 'OI', 2.27, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2015.00', '1.B.1.d', 'OI', 3.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2015.00', '1.B.1.e', 'OI', 3.68, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2015.00', '1.B.1.f', 'OI', 4.37, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2015.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2015.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2015.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2021.00', '1.B.1.a', 'OI', 6.40, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2021.00', '1.B.1.b', 'OI', 1.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2021.00', '1.B.1.c', 'OI', 1.90, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2021.00', '1.B.1.d', 'OI', 2.71, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2021.00', '1.B.1.e', 'OI', 2.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2021.00', '1.B.1.f', 'OI', 4.18, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2021.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2021.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-2021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3011.00', '1.B.1.a', 'OI', 4.65, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3011.00', '1.B.1.b', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3011.00', '1.B.1.c', 'OI', 2.30, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3011.00', '1.B.1.d', 'OI', 3.74, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3011.00', '1.B.1.e', 'OI', 3.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3011.00', '1.B.1.f', 'OI', 4.53, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3011.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3011.00', '1.B.1.i', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.00', '1.B.1.a', 'OI', 4.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.00', '1.B.1.b', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.00', '1.B.1.c', 'OI', 1.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.00', '1.B.1.d', 'OI', 3.48, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.00', '1.B.1.e', 'OI', 3.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.00', '1.B.1.f', 'OI', 4.96, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.00', '1.B.1.h', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.01', '1.B.1.a', 'OI', 5.58, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.01', '1.B.1.b', 'OI', 1.07, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.01', '1.B.1.c', 'OI', 2.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.01', '1.B.1.d', 'OI', 3.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.01', '1.B.1.e', 'OI', 3.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.01', '1.B.1.f', 'OI', 3.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.01', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.01', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3023.01', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3031.00', '1.B.1.a', 'OI', 4.12, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3031.00', '1.B.1.b', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3031.00', '1.B.1.c', 'OI', 1.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3031.00', '1.B.1.d', 'OI', 4.72, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3031.00', '1.B.1.e', 'OI', 4.06, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3031.00', '1.B.1.f', 'OI', 4.95, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3031.00', '1.B.1.g', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3031.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3031.00', '1.B.1.i', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3041.00', '1.B.1.a', 'OI', 4.84, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3041.00', '1.B.1.b', 'OI', 1.46, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3041.00', '1.B.1.c', 'OI', 2.10, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3041.00', '1.B.1.d', 'OI', 4.23, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3041.00', '1.B.1.e', 'OI', 2.85, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3041.00', '1.B.1.f', 'OI', 3.87, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3041.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3041.00', '1.B.1.h', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-3041.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9011.00', '1.B.1.a', 'OI', 5.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9011.00', '1.B.1.b', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9011.00', '1.B.1.c', 'OI', 1.02, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9011.00', '1.B.1.d', 'OI', 3.66, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9011.00', '1.B.1.e', 'OI', 2.26, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9011.00', '1.B.1.f', 'OI', 4.57, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9011.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9011.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9011.00', '1.B.1.i', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9021.00', '1.B.1.a', 'OI', 7.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9021.00', '1.B.1.b', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9021.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9021.00', '1.B.1.d', 'OI', 1.83, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9021.00', '1.B.1.e', 'OI', 1.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9021.00', '1.B.1.f', 'OI', 4.45, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9021.00', '1.B.1.g', 'IH', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9021.00', '1.B.1.h', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9021.00', '1.B.1.i', 'IH', 0.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9031.00', '1.B.1.a', 'OI', 3.19, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9031.00', '1.B.1.b', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9031.00', '1.B.1.c', 'OI', 1.73, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9031.00', '1.B.1.d', 'OI', 5.24, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9031.00', '1.B.1.e', 'OI', 4.44, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9031.00', '1.B.1.f', 'OI', 4.09, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9031.00', '1.B.1.g', 'IH', 4.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9031.00', '1.B.1.h', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('35-9031.00', '1.B.1.i', 'IH', 6.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('37-1011.00', '1.B.1.a', 'OI', 4.14, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('37-1011.00', '1.B.1.b', 'OI', 1.38, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('37-1011.00', '1.B.1.c', 'OI', 1.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('37-1011.00', '1.B.1.d', 'OI', 3.63, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('37-1011.00', '1.B.1.e', 'OI', 5.70, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('37-1011.00', '1.B.1.f', 'OI', 5.35, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT INTO interests (onetsoc_code, element_id, scale_id, data_value, date_updated, domain_source) VALUES ('37-1011.00', '1.B.1.g', 'IH', 5.00, TO_DATE('2026-02-01', 'yyyy-mm-dd'), 'Machine Learning/Expert');
INSERT 