CREATE TABLE education_training_experience (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  category DECIMAL(3,0),
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(7,4),
  lower_ci_bound DECIMAL(7,4),
  upper_ci_bound DECIMAL(7,4),
  recommend_suppress CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id),
  FOREIGN KEY (element_id, scale_id, category) REFERENCES ete_categories(element_id, scale_id, category));

INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 1, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 2, 4.46, 28, 4.1428, 0.6307, 25.5524, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 3, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 4, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 5, 5.15, 28, 5.2236, 0.6000, 32.7756, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 6, 32.29, 28, 12.7266, 12.6247, 61.1586, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 7, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 8, 45.91, 28, 16.6480, 17.6593, 77.0570, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 9, 3.94, 28, 4.0634, 0.4511, 27.0734, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 10, 0.55, 28, 0.5831, 0.0637, 4.6529, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 11, 4.92, 28, 4.7695, 0.6342, 29.5426, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 12, 2.78, 28, 2.7428, 0.3548, 18.6644, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.4.a', 'IM', NULL, 3.01, 28, 0.2773, 2.4454, 3.5834, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 1, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 2, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 3, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 4, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 5, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 6, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 7, 9.69, 28, 6.3839, 2.3430, 32.4046, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 8, 5.87, 28, 5.3299, 0.8563, 31.0831, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 9, 15.09, 28, 7.8957, 4.7774, 38.6230, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 10, 1.11, 28, 0.8635, 0.2226, 5.3397, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 11, 68.24, 28, 11.8645, 41.1361, 86.8556, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 1, 10.22, 28, 5.9266, 2.9333, 29.9919, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 2, 3.82, 28, 3.2307, 0.6490, 19.4416, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 3, 5.15, 28, 5.2236, 0.6000, 32.7756, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 4, 6.66, 28, 5.6415, 1.0945, 31.4820, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 5, 16.79, 28, 9.5074, 4.7552, 44.9103, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 6, 0.52, 28, 0.5467, 0.0594, 4.3785, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 7, 6.62, 28, 5.4201, 1.1603, 29.9909, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 8, 15.92, 28, 9.0158, 4.5374, 42.9918, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 9, 34.32, 28, 19.3096, 8.2639, 75.1852, 'Y', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 1, 4.57, 27, 3.2099, 1.0455, 17.8546, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 2, 8.50, 27, 5.9928, 1.8698, 31.1658, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 3, 5.31, 27, 5.3962, 0.6139, 33.7379, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 4, 13.38, 27, 9.2844, 2.8931, 44.4923, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 5, 9.67, 27, 5.6173, 2.7775, 28.6472, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 6, 4.60, 27, 4.2836, 0.6447, 26.3896, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 7, 6.68, 27, 5.5870, 1.1200, 31.1239, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 8, 12.03, 27, 8.7135, 2.4541, 42.6272, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 9, 35.25, 27, 19.6375, 8.4995, 76.1430, 'Y', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.4.a', 'IM', NULL, 2.20, 27, 0.3437, 1.4926, 2.9055, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 2, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 3, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 4, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 5, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 6, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 8, 74.07, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 9, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 10, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 11, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 12, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.4.a', 'IM', NULL, 2.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 2, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 3, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 4, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 5, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 6, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 7, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 8, 40.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 9, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 10, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 11, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 1, 40.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 2, 22.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 3, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 4, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 5, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 6, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 7, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 8, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 9, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 1, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 2, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 3, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 4, 22.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 5, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 6, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 8, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 9, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.4.a', 'IM', NULL, 1.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 1, 10.35, 28, 7.6848, 2.0646, 38.7124, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 2, 28.76, 28, 11.3910, 11.4276, 55.8159, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 3, 5.72, 28, 5.6980, 0.6906, 34.6394, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 4, 21.59, 28, 11.0866, 6.7027, 51.3506, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 5, 5.99, 28, 5.8141, 0.7609, 34.6341, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 6, 27.30, 28, 10.5201, 11.2316, 52.6984, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 7, 0.14, 28, 0.1380, 0.0167, 1.0888, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 8, 0.15, 28, 0.1576, 0.0191, 1.2422, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 9, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 10, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 11, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 12, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.4.a', 'IM', NULL, 1.88, 28, 0.2508, 1.3704, 2.3996, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 1, 10.35, 28, 7.6848, 2.0646, 38.7124, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 2, 1.50, 28, 1.5086, 0.1872, 11.0086, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 3, 0.22, 28, 0.2188, 0.0266, 1.7166, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 4, 2.03, 28, 2.0460, 0.2502, 14.6100, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 5, 15.26, 28, 7.9256, 4.8711, 38.7749, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 6, 3.66, 28, 2.6840, 0.7893, 15.3387, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 7, 18.97, 28, 8.6803, 6.8471, 42.7210, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 8, 24.23, 28, 10.8936, 8.6443, 51.9317, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 9, 5.72, 28, 5.6980, 0.6906, 34.6394, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 10, 0.14, 28, 0.1380, 0.0167, 1.0888, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 11, 17.93, 28, 9.3027, 5.6373, 44.4253, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 1, 10.96, 28, 7.6113, 2.4224, 37.8850, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 2, 8.14, 28, 7.4393, 1.1380, 40.5598, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 3, 18.09, 28, 10.1270, 5.1511, 47.3032, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 4, 0.35, 28, 0.2629, 0.0750, 1.6211, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 5, 18.11, 28, 9.0523, 5.9424, 43.6214, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 6, 15.09, 28, 9.6322, 3.6642, 45.3852, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 7, 25.62, 28, 11.8118, 8.8083, 55.1339, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 8, 3.47, 28, 3.4510, 0.4318, 22.9446, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 9, 0.17, 28, 0.1592, 0.0255, 1.1450, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 1, 3.47, 28, 3.4192, 0.4402, 22.6022, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 2, 14.53, 28, 8.7609, 3.8459, 41.9585, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 3, 16.13, 28, 9.8235, 4.1568, 46.0417, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 4, 10.54, 28, 7.6843, 2.1656, 38.5448, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 5, 11.56, 28, 7.2557, 2.9574, 35.9256, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 6, 8.30, 28, 7.9610, 1.0479, 43.6278, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 7, 26.08, 28, 11.4614, 9.4375, 54.4415, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 8, 9.21, 28, 6.6333, 1.9512, 34.0648, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 9, 0.17, 28, 0.1592, 0.0255, 1.1450, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.4.a', 'IM', NULL, 2.33, 28, 0.3483, 1.6139, 3.0434, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 1, 6.16, 27, 5.8830, 0.8030, 34.7229, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 2, 9.82, 27, 5.9417, 2.6660, 30.1917, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 3, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 4, 7.67, 27, 5.3186, 1.7443, 28.0021, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 5, 8.04, 27, 5.4789, 1.8701, 28.6249, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 6, 60.02, 27, 9.9779, 38.9731, 77.9195, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 7, 2.42, 27, 2.4071, 0.3051, 16.7618, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 8, 5.87, 27, 4.1933, 1.2953, 22.8803, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 9, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 10, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 11, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 12, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.4.a', 'IM', NULL, 1.98, 23, 0.2188, 1.5213, 2.4288, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 1, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 2, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 3, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 4, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 5, 14.20, 27, 7.6408, 4.3592, 37.5267, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 6, 13.73, 27, 6.8311, 4.6361, 34.2430, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 7, 21.74, 27, 8.1455, 9.4071, 42.6353, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 8, 26.52, 27, 8.5010, 12.8328, 46.9437, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 9, 16.49, 27, 7.7712, 5.8299, 38.6461, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 10, 2.42, 27, 2.4071, 0.3051, 16.7618, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 11, 4.90, 27, 4.7467, 0.6314, 29.4806, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 1, 22.39, 27, 7.6973, 10.4024, 41.7642, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 2, 25.12, 27, 8.6005, 11.5865, 46.1975, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 3, 21.26, 27, 8.5247, 8.6603, 43.4747, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 4, 10.12, 27, 6.9195, 2.3010, 34.9747, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 5, 7.34, 27, 5.1171, 1.6583, 27.1113, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 6, 6.45, 27, 4.5591, 1.4358, 24.5809, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 7, 2.42, 27, 2.4071, 0.3051, 16.7618, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 8, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 9, 4.90, 27, 4.7467, 0.6314, 29.4806, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 1, 10.58, 27, 5.9086, 3.1722, 29.9305, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 2, 38.54, 27, 9.4179, 21.6906, 58.6792, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 3, 21.64, 27, 8.3068, 9.1617, 43.0476, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 4, 7.65, 27, 5.3080, 1.7375, 27.9588, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 5, 11.03, 27, 6.1635, 3.2966, 31.0742, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 6, 5.66, 27, 3.9648, 1.2873, 21.6324, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 7, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 8, 4.90, 27, 4.7467, 0.6314, 29.4806, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 9, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.4.a', 'IM', NULL, 2.11, 23, 0.2544, 1.5844, 2.6395, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 2, 3.53, 37, 3.5620, 0.4361, 23.3951, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 3, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 4, 2.80, 37, 2.0719, 0.6128, 11.8824, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 5, 3.03, 37, 2.0620, 0.7458, 11.4833, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 6, 55.76, 37, 16.9574, 23.8203, 83.5595, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 7, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 8, 24.36, 37, 9.6023, 10.0622, 48.0946, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 9, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 10, 10.52, 37, 8.9995, 1.6635, 44.9712, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 11, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 12, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 2, 1.43, 37, 1.4643, 0.1742, 10.6928, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 3, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 5, 9.04, 37, 6.8513, 1.8003, 35.0039, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 6, 7.23, 37, 4.3381, 2.0538, 22.4421, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 7, 12.08, 37, 6.2721, 3.9854, 31.2783, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 8, 18.80, 37, 8.0633, 7.3473, 40.3270, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 9, 14.98, 37, 8.9214, 4.0801, 42.1768, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 10, 33.99, 37, 10.8577, 16.1724, 57.8730, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 11, 2.47, 37, 1.6953, 0.6019, 9.5512, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 1, 33.95, 37, 9.4145, 17.9882, 54.6333, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 2, 14.98, 37, 6.5228, 5.8714, 33.2384, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 3, 32.96, 37, 10.1881, 16.1781, 55.6048, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 4, 11.25, 37, 6.8045, 3.0868, 33.5521, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 5, 5.71, 37, 3.2713, 1.7339, 17.1954, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 6, 1.15, 37, 1.1818, 0.1399, 8.7657, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 7, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 8, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 9, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 1, 2.40, 36, 2.4391, 0.2947, 16.9400, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 2, 8.91, 36, 4.5292, 3.0559, 23.2947, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 3, 52.82, 36, 11.2501, 30.9263, 73.6795, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 4, 15.63, 36, 7.8113, 5.2728, 38.1430, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 5, 9.71, 36, 4.3396, 3.7861, 22.7050, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 6, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 7, 10.53, 36, 9.0090, 1.6626, 45.0518, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 8, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 9, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 2, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 4, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 5, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 6, 71.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 8, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 10, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 11, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 12, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.4.a', 'IM', NULL, 1.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 4, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 5, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 6, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 7, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 8, 38.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 9, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 10, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 11, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 2, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 3, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 4, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 5, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 6, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 8, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 2, 28.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 3, 28.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 4, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 5, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 6, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 8, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.4.a', 'IM', NULL, 1.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.1', 'RL', 1, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.1', 'RL', 2, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.1', 'RL', 3, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.1', 'RL', 4, 19.65, 19, 16.9674, 2.4934, 70.0457, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.1', 'RL', 5, 3.93, 19, 4.5932, 0.3177, 34.4798, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.1', 'RL', 6, 65.49, 19, 18.5953, 25.1986, 91.4426, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.1', 'RL', 7, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.1', 'RL', 8, 10.93, 19, 7.4357, 2.4079, 37.9113, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.1', 'RL', 9, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.1', 'RL', 10, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.1', 'RL', 11, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.1', 'RL', 12, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '2.D.4.a', 'IM', NULL, 1.50, 19, 0.1507, 1.1845, 1.8179, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.1', 'RW', 1, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.1', 'RW', 2, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.1', 'RW', 3, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.1', 'RW', 4, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.1', 'RW', 5, 3.93, 19, 4.5932, 0.3177, 34.4798, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.1', 'RW', 6, 3.93, 19, 4.0546, 0.4281, 28.0617, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.1', 'RW', 7, 55.32, 19, 19.9116, 18.5578, 87.0554, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.1', 'RW', 8, 1.88, 19, 2.0191, 0.1921, 16.0331, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.1', 'RW', 9, 9.30, 19, 6.7496, 1.8713, 35.5198, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.1', 'RW', 10, 0.08, 19, 0.0836, 0.0081, 0.7411, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.1', 'RW', 11, 25.56, 19, 17.4117, 4.7816, 70.1324, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.2', 'PT', 1, 6.30, 19, 5.5821, 0.9141, 32.8937, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.2', 'PT', 2, 45.30, 19, 12.8645, 21.7687, 71.1410, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.2', 'PT', 3, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.2', 'PT', 4, 7.04, 19, 4.9605, 1.5159, 27.1312, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.2', 'PT', 5, 12.09, 19, 7.8028, 2.8549, 39.1390, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.2', 'PT', 6, 21.07, 19, 11.6643, 5.7646, 53.8138, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.2', 'PT', 7, 2.29, 19, 2.3944, 0.2466, 18.1713, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.2', 'PT', 8, 5.91, 19, 6.1025, 0.6233, 38.6394, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.2', 'PT', 9, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.3', 'OJ', 1, 2.37, 19, 2.4052, 0.2715, 17.7562, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.3', 'OJ', 2, 0.29, 19, 0.3108, 0.0302, 2.7138, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.3', 'OJ', 3, 42.72, 19, 19.2717, 12.4766, 79.5960, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.3', 'OJ', 4, 32.69, 19, 22.5263, 5.3518, 80.6688, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.3', 'OJ', 5, 16.02, 19, 8.9536, 4.5004, 43.5724, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.3', 'OJ', 6, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.3', 'OJ', 7, 5.91, 19, 6.1025, 0.6233, 38.6394, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.3', 'OJ', 8, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.3', 'OJ', 9, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2033.00', '3.A.4.a', 'IM', NULL, 1.18, 18, 0.1267, 1.0000, 1.4478, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 1, 0.00, 45, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 2, 33.56, 45, 14.3476, 12.1309, 64.8795, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 3, 13.16, 45, 6.1415, 4.8797, 30.9207, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 4, 13.18, 45, 6.4728, 4.6284, 32.1877, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 5, 11.84, 45, 5.3593, 4.5551, 27.4302, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 6, 24.28, 45, 8.7153, 10.9819, 45.4639, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 7, 0.00, 45, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 8, 3.87, 45, 2.3439, 1.1157, 12.5372, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 9, 0.06, 45, 0.0617, 0.0074, 0.4795, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 10, 0.00, 45, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 11, 0.06, 45, 0.0617, 0.0074, 0.4795, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 12, 0.00, 45, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 1, 3.21, 45, 3.0126, 0.4684, 18.9605, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 2, 0.00, 45, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 3, 0.00, 45, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 4, 2.52, 45, 2.5493, 0.3201, 17.2819, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 5, 1.67, 45, 1.7020, 0.2110, 12.0426, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 6, 26.78, 45, 15.0960, 7.1916, 63.3145, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 7, 31.24, 45, 9.5182, 15.6865, 52.6027, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 8, 21.73, 45, 9.0807, 8.6498, 44.8837, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 9, 6.92, 45, 3.8597, 2.1732, 19.9187, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 10, 5.02, 45, 3.2469, 1.3240, 17.2509, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 11, 0.89, 45, 0.8640, 0.1264, 6.0469, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 1, 13.82, 45, 6.6191, 4.9739, 32.9549, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 2, 14.50, 45, 7.1774, 5.0125, 35.2594, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 3, 34.62, 45, 14.4451, 12.7613, 65.7075, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 4, 13.03, 45, 7.3577, 3.8904, 35.6684, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 5, 17.86, 45, 7.3313, 7.3574, 37.3154, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 6, 3.39, 45, 2.4299, 0.7806, 13.5332, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 7, 1.38, 45, 1.3902, 0.1773, 9.8970, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 8, 1.41, 45, 1.4403, 0.1766, 10.3523, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 9, 0.00, 45, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 1, 1.13, 44, 1.1112, 0.1540, 7.8213, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 2, 15.92, 44, 5.9542, 7.1656, 31.7087, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 3, 48.28, 44, 12.6144, 25.2085, 72.1123, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 4, 15.80, 44, 6.0273, 6.9953, 31.8727, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 5, 11.87, 44, 5.0240, 4.8643, 26.1872, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 6, 6.88, 44, 3.5742, 2.3431, 18.5399, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 7, 0.12, 44, 0.1268, 0.0151, 0.9835, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 8, 0.00, 44, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 9, 0.00, 44, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.1', 'RL', 1, 0.00, 32, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.1', 'RL', 2, 14.59, 32, 7.3592, 4.8695, 36.2919, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.1', 'RL', 3, 9.36, 32, 5.2948, 2.8122, 26.9415, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.1', 'RL', 4, 11.30, 32, 5.6857, 3.8483, 28.8319, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.1', 'RL', 5, 57.34, 32, 12.3743, 32.3842, 79.0385, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.1', 'RL', 6, 7.06, 32, 3.8640, 2.2347, 20.1575, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.1', 'RL', 7, 0.18, 32, 0.1862, 0.0220, 1.4654, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.1', 'RL', 8, 0.18, 32, 0.1862, 0.0220, 1.4654, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.1', 'RL', 9, 0.00, 32, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.1', 'RL', 10, 0.00, 32, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.1', 'RL', 11, 0.00, 32, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.1', 'RL', 12, 0.00, 32, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '2.D.4.a', 'IM', NULL, 2.78, 33, 0.2656, 2.2355, 3.3176, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.1', 'RW', 1, 2.13, 33, 2.1725, 0.2615, 15.3566, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.1', 'RW', 2, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.1', 'RW', 3, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.1', 'RW', 4, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.1', 'RW', 5, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.1', 'RW', 6, 3.52, 33, 2.9844, 0.6046, 17.9381, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.1', 'RW', 7, 49.01, 33, 14.2149, 23.1802, 75.3825, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.1', 'RW', 8, 21.74, 33, 12.1863, 6.0689, 54.4418, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.1', 'RW', 9, 0.87, 33, 0.6841, 0.1756, 4.2218, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.1', 'RW', 10, 22.31, 33, 11.2773, 7.0892, 51.9391, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.1', 'RW', 11, 0.41, 33, 0.4200, 0.0501, 3.2487, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.2', 'PT', 1, 5.23, 33, 4.9073, 0.7301, 29.3034, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.2', 'PT', 2, 15.46, 33, 11.7038, 2.8645, 53.1245, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.2', 'PT', 3, 26.16, 33, 12.8635, 8.3589, 57.9006, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.2', 'PT', 4, 18.28, 33, 11.6825, 4.3483, 52.3853, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.2', 'PT', 5, 8.94, 33, 5.2584, 2.5640, 26.7916, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.2', 'PT', 6, 0.41, 33, 0.4215, 0.0497, 3.2728, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.2', 'PT', 7, 11.12, 33, 7.3798, 2.6601, 36.4112, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.2', 'PT', 8, 14.42, 33, 9.8246, 3.2201, 46.0295, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.2', 'PT', 9, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.3', 'OJ', 1, 6.26, 33, 5.0551, 1.1422, 27.8544, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.3', 'OJ', 2, 4.84, 33, 4.6332, 0.6497, 28.3142, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.3', 'OJ', 3, 24.48, 33, 12.4331, 7.6128, 56.0548, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.3', 'OJ', 4, 17.47, 33, 11.6430, 3.9239, 52.3042, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.3', 'OJ', 5, 22.30, 33, 12.2793, 6.3467, 54.8663, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.3', 'OJ', 6, 3.11, 33, 2.7693, 0.4913, 17.2656, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.3', 'OJ', 7, 4.61, 33, 4.2485, 0.6689, 25.7117, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.3', 'OJ', 8, 16.94, 33, 10.8103, 4.0881, 49.3775, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.3', 'OJ', 9, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '3.A.4.a', 'IM', NULL, 2.36, 33, 0.3350, 1.6813, 3.0461, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.1', 'RL', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.1', 'RL', 3, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.1', 'RL', 5, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.1', 'RL', 6, 70.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.1', 'RL', 8, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '2.D.4.a', 'IM', NULL, 3.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.1', 'RW', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.1', 'RW', 5, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.1', 'RW', 6, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.1', 'RW', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.1', 'RW', 8, 45.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.1', 'RW', 9, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.1', 'RW', 10, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.1', 'RW', 11, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.2', 'PT', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.2', 'PT', 2, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.2', 'PT', 3, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.2', 'PT', 4, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.2', 'PT', 5, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.2', 'PT', 6, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.2', 'PT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.2', 'PT', 8, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.3', 'OJ', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.3', 'OJ', 2, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.3', 'OJ', 3, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.3', 'OJ', 4, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.3', 'OJ', 5, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.3', 'OJ', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.3', 'OJ', 7, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.3', 'OJ', 8, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.01', '3.A.4.a', 'IM', NULL, 1.80, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 1, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 2, 1.26, 26, 1.3040, 0.1467, 9.9608, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 3, 5.77, 26, 5.7846, 0.6800, 35.3899, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 4, 25.96, 26, 15.1556, 6.4646, 64.0123, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 5, 2.16, 26, 1.6643, 0.4359, 10.0459, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 6, 47.68, 26, 17.0585, 18.2258, 78.8440, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 7, 2.80, 26, 2.8780, 0.3263, 20.2551, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 8, 14.36, 26, 10.1865, 2.9565, 48.0057, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 9, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 10, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 11, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 12, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 1, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 2, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 4, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 5, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 6, 1.08, 26, 1.1206, 0.1263, 8.6374, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 7, 11.15, 26, 6.7607, 2.9881, 33.8487, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 8, 23.94, 26, 12.4866, 7.1231, 56.3752, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 9, 40.02, 26, 16.3262, 14.1197, 73.0305, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 10, 10.55, 26, 8.8806, 1.6680, 45.0357, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 11, 13.25, 26, 8.7162, 3.1068, 42.1326, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 1, 16.82, 26, 10.7615, 3.9820, 49.6430, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 2, 31.64, 26, 17.9804, 7.7087, 71.9444, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 3, 5.33, 26, 3.4363, 1.3682, 18.6234, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 4, 6.90, 26, 4.5371, 1.7025, 24.0923, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 5, 23.00, 26, 14.3043, 5.3572, 61.1869, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 6, 9.72, 26, 9.1986, 1.2292, 48.2471, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 7, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 8, 6.58, 26, 6.2235, 0.8684, 36.1673, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 9, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 1, 0.76, 26, 0.7957, 0.0871, 6.3043, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 2, 15.17, 26, 8.7238, 4.2392, 41.9421, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 3, 24.43, 26, 11.1767, 8.5008, 52.9359, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 4, 23.48, 26, 11.9674, 7.2231, 54.7472, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 5, 32.63, 26, 15.7759, 9.9491, 67.9850, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 6, 3.53, 26, 2.9986, 0.5915, 18.3366, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 7, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 8, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 9, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.1', 'RL', 1, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.1', 'RL', 2, 14.24, 17, 10.0015, 2.8418, 48.5174, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.1', 'RL', 3, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.1', 'RL', 4, 4.56, 17, 4.8580, 0.4449, 33.7679, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.1', 'RL', 5, 3.90, 17, 4.4191, 0.3311, 33.1023, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.1', 'RL', 6, 56.31, 17, 7.3020, 40.7241, 70.7451, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.1', 'RL', 7, 21.00, 17, 13.0856, 4.7548, 58.5932, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.1', 'RL', 8, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.1', 'RL', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.1', 'RL', 10, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.1', 'RL', 11, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.1', 'RL', 12, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '2.D.4.a', 'IM', NULL, 3.20, 17, 0.3806, 2.3926, 4.0064, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.1', 'RW', 1, 9.76, 17, 9.1009, 1.1945, 49.1638, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.1', 'RW', 2, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.1', 'RW', 3, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.1', 'RW', 4, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.1', 'RW', 5, 3.90, 17, 4.4191, 0.3311, 33.1023, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.1', 'RW', 6, 22.48, 17, 12.6494, 5.8610, 57.4659, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.1', 'RW', 7, 7.75, 17, 5.9805, 1.4052, 33.1068, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.1', 'RW', 8, 41.91, 17, 7.6170, 27.0991, 58.3435, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.1', 'RW', 9, 11.83, 17, 11.1427, 1.3734, 56.3711, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.1', 'RW', 10, 1.48, 17, 1.6051, 0.1469, 13.3707, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.1', 'RW', 11, 0.89, 17, 1.0420, 0.0737, 9.8790, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.2', 'PT', 1, 34.21, 17, 9.0317, 18.1772, 54.9066, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.2', 'PT', 2, 28.55, 17, 11.7533, 10.5382, 57.5439, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.2', 'PT', 3, 12.70, 17, 11.3065, 1.6460, 55.8298, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.2', 'PT', 4, 7.67, 17, 6.0284, 1.3504, 33.5421, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.2', 'PT', 5, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.2', 'PT', 6, 11.24, 17, 9.2717, 1.7362, 47.5901, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.2', 'PT', 7, 0.87, 17, 0.9577, 0.0834, 8.4547, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.2', 'PT', 8, 4.75, 17, 5.0928, 0.4571, 35.1473, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.2', 'PT', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.3', 'OJ', 1, 2.29, 17, 2.4937, 0.2213, 19.8973, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.3', 'OJ', 2, 21.00, 17, 13.0856, 4.7548, 58.5932, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.3', 'OJ', 3, 21.12, 17, 13.8055, 4.4170, 60.8030, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.3', 'OJ', 4, 39.56, 17, 8.0654, 24.2514, 57.2300, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.3', 'OJ', 5, 16.03, 17, 9.3127, 4.2182, 45.2810, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.3', 'OJ', 6, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.3', 'OJ', 7, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.3', 'OJ', 8, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.3', 'OJ', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '3.A.4.a', 'IM', NULL, 1.45, 17, 0.2392, 1.0000, 1.9611, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 1, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 2, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 3, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 4, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 5, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 6, 56.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 7, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 8, 32.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 9, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 10, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 11, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 12, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.4.a', 'IM', NULL, 3.52, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 1, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 2, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 3, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 4, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 5, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 6, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 7, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 8, 20.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 9, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 10, 16.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 11, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 1, 28.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 2, 16.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 3, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 4, 20.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 5, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 6, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 8, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 9, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 1, 28.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 2, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 3, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 4, 20.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 5, 16.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 6, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 8, 16.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 9, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.4.a', 'IM', NULL, 1.71, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 1, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 2, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 3, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 6, 32.66, 25, 13.0514, 12.4743, 62.2746, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 7, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 8, 63.33, 25, 12.7575, 35.7219, 84.2915, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 9, 2.01, 25, 2.0273, 0.2427, 14.6814, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 10, 2.01, 25, 2.0273, 0.2427, 14.6814, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 11, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 12, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 1, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 2, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 3, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 6, 1.51, 25, 1.5885, 0.1699, 12.1794, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 7, 1.51, 25, 1.5666, 0.1751, 11.8579, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 8, 24.86, 25, 9.9643, 9.9147, 49.8732, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 9, 16.35, 25, 4.8719, 8.5704, 28.9647, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 10, 28.36, 25, 12.1315, 10.3492, 57.5836, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 11, 27.40, 25, 8.4552, 13.5651, 47.5704, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 1, 27.75, 25, 10.2697, 11.7720, 52.5037, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 2, 14.84, 25, 5.0006, 7.1503, 28.2818, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 3, 13.11, 25, 9.7700, 2.5066, 46.9740, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 4, 9.18, 25, 6.8425, 1.8228, 35.4827, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 5, 14.96, 25, 9.5913, 3.5761, 45.4696, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 6, 10.58, 25, 5.6579, 3.3301, 28.9036, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 7, 6.07, 25, 4.6159, 1.1985, 25.5803, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 8, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 9, 3.52, 25, 2.5864, 0.7509, 14.9466, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 1, 16.19, 24, 8.9483, 4.7018, 43.0466, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 2, 13.53, 24, 6.5053, 4.7210, 33.0791, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 3, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 4, 9.47, 24, 4.7742, 3.1999, 24.8696, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 5, 28.63, 24, 10.7246, 11.9295, 54.2982, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 6, 20.10, 24, 10.2688, 6.2820, 48.5671, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 7, 8.51, 24, 5.8381, 1.9329, 30.4963, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 8, 1.54, 24, 1.5699, 0.1819, 11.7811, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 9, 2.04, 24, 2.0606, 0.2446, 14.9771, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 1, 5.26, 33, 5.2030, 0.6564, 31.7838, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 2, 29.42, 33, 9.3469, 14.2857, 51.0477, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 3, 16.21, 33, 7.4543, 5.9491, 37.1738, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 4, 11.51, 33, 7.8627, 2.6285, 38.5277, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 5, 8.10, 33, 5.7824, 1.7800, 30.0139, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 6, 25.80, 33, 9.9630, 10.7535, 50.0952, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 7, 2.45, 33, 2.4962, 0.2984, 17.4088, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 8, 1.24, 33, 1.2469, 0.1591, 9.0546, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 9, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 10, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 11, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 12, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.4.a', 'IM', NULL, 1.66, 34, 0.1624, 1.3274, 1.9882, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 1, 7.50, 34, 5.0377, 1.8177, 26.2119, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 2, 0.00, 34, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 3, 0.00, 34, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 4, 2.48, 34, 2.5254, 0.3028, 17.5498, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 5, 3.06, 34, 3.0001, 0.4030, 19.7956, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 6, 28.44, 34, 9.0189, 13.8948, 49.4749, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 7, 12.95, 34, 6.3925, 4.4851, 32.0464, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 8, 21.21, 34, 7.3958, 9.8600, 39.8441, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 9, 9.97, 34, 6.0659, 2.7232, 30.4567, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 10, 1.22, 34, 1.2260, 0.1572, 8.8864, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 11, 13.16, 34, 6.4138, 4.6124, 32.1892, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 1, 10.41, 33, 6.5655, 2.6970, 32.7710, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 2, 15.30, 33, 6.7071, 5.9241, 34.1423, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 3, 17.30, 33, 8.1888, 6.1172, 40.1616, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 4, 11.06, 33, 6.6241, 3.0597, 32.8942, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 5, 14.28, 33, 6.8193, 5.0855, 34.1319, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 6, 16.13, 33, 7.0452, 6.2435, 35.7150, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 7, 4.80, 33, 3.1987, 1.1989, 17.3402, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 8, 5.25, 33, 3.4448, 1.3363, 18.5034, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 9, 5.45, 33, 5.3376, 0.6957, 32.2059, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 1, 5.85, 34, 5.1755, 0.9089, 29.6019, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 2, 14.58, 34, 9.4975, 3.4894, 44.6110, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 3, 17.11, 34, 7.3522, 6.7083, 37.2119, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 4, 12.34, 34, 6.7444, 3.8076, 33.3560, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 5, 26.73, 34, 10.2630, 11.1604, 51.4438, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 6, 9.53, 34, 5.0409, 3.1041, 25.7103, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 7, 3.71, 34, 2.8523, 0.7558, 16.3484, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 8, 4.98, 34, 3.2824, 1.2631, 17.6899, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 9, 5.17, 34, 5.0784, 0.6592, 30.9557, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.4.a', 'IM', NULL, 2.21, 34, 0.2546, 1.6905, 2.7265, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 1, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 2, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 3, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 4, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 5, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 6, 100.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 7, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 8, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 10, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 11, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 12, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.4.a', 'IM', NULL, 3.00, 17, 0.2438, 2.4813, 3.5148, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 1, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 2, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 3, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 4, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 5, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 6, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 7, 10.63, 17, 6.6661, 2.6194, 34.4870, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 8, 41.89, 17, 10.7193, 22.0795, 64.7040, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 9, 8.05, 17, 6.4670, 1.3544, 35.8165, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 10, 2.53, 17, 2.6862, 0.2571, 20.7190, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 11, 36.90, 17, 11.5539, 16.9622, 62.6097, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 1, 2.75, 17, 2.9154, 0.2797, 22.1871, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 2, 32.71, 17, 11.3811, 13.9748, 59.2633, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 3, 16.81, 17, 10.1331, 4.1662, 48.4244, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 4, 4.42, 17, 4.6130, 0.4563, 31.8589, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 5, 9.82, 17, 5.4806, 2.8513, 28.7934, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 6, 0.91, 17, 0.9581, 0.0974, 8.0060, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 7, 24.52, 17, 13.5588, 6.4324, 60.5559, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 8, 8.05, 17, 6.4670, 1.3544, 35.8165, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 1, 5.52, 17, 5.6641, 0.5807, 36.8769, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 2, 2.75, 17, 2.9154, 0.2797, 22.1871, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 3, 36.81, 17, 12.5222, 15.6854, 64.5833, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 4, 19.67, 17, 9.8502, 6.1287, 47.8624, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 5, 8.13, 17, 6.3382, 1.4444, 34.8408, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 6, 4.93, 17, 3.6997, 0.9628, 21.6571, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 7, 19.67, 17, 12.9875, 4.1095, 58.3077, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 8, 2.53, 17, 2.6862, 0.2571, 20.7190, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.4.a', 'IM', NULL, 2.01, 17, 0.3586, 1.2537, 2.7740, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 1, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 2, 11.15, 20, 7.2391, 2.6458, 36.6782, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 3, 18.91, 20, 9.3151, 6.1366, 45.4020, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 4, 47.61, 20, 14.8545, 20.7188, 75.9690, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 5, 2.72, 20, 2.8732, 0.2888, 21.3130, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 6, 14.61, 20, 12.3434, 2.1128, 57.5720, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 7, 4.99, 20, 4.8947, 0.6023, 31.3014, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 8, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 9, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 10, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 11, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 12, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 5, 11.46, 21, 5.9550, 3.6664, 30.5690, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 6, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 7, 14.67, 21, 8.2453, 4.1680, 40.4501, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 8, 19.57, 21, 8.7157, 7.1198, 43.5773, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 9, 12.48, 21, 8.1021, 2.9441, 40.1220, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 10, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 11, 41.82, 21, 12.7796, 19.3781, 68.2568, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 1, 2.61, 21, 2.7759, 0.2739, 20.7282, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 3, 9.56, 21, 5.5754, 2.6769, 28.8654, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 4, 7.19, 21, 5.4162, 1.4056, 29.6328, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 5, 23.73, 21, 9.6326, 9.2998, 48.5679, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 6, 18.48, 21, 10.7640, 4.8609, 50.1575, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 7, 2.61, 21, 2.7759, 0.2739, 20.7282, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 8, 30.16, 21, 10.1689, 13.6248, 54.1729, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 9, 5.66, 21, 4.4116, 1.0589, 25.1624, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 1, 2.61, 21, 2.7759, 0.2739, 20.7282, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 3, 6.81, 21, 5.3598, 1.2390, 29.8506, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 4, 2.61, 21, 2.7759, 0.2739, 20.7282, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 5, 30.54, 21, 6.6459, 18.6156, 45.8058, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 6, 16.33, 21, 6.9829, 6.2954, 36.1730, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 7, 15.02, 21, 8.8139, 4.0159, 42.7362, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 8, 20.43, 21, 10.2620, 6.4358, 48.9283, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 9, 5.66, 21, 4.4116, 1.0589, 25.1624, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 1, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 2, 14.00, 23, 7.6610, 4.1676, 37.8552, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 3, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 4, 19.13, 23, 9.7106, 6.0489, 46.5109, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 5, 14.83, 23, 7.2719, 5.0090, 36.4925, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 6, 45.44, 23, 12.1150, 23.2163, 69.6499, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 7, 6.60, 23, 6.5156, 0.7823, 38.7585, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 8, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 9, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 10, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 11, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 12, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 1, 12.69, 23, 6.8250, 3.8951, 34.2731, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 2, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 3, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 4, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 5, 4.46, 23, 4.2150, 0.5971, 26.6339, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 6, 17.76, 23, 8.8174, 5.8191, 43.0295, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 7, 34.62, 23, 11.5861, 15.4850, 60.4900, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 8, 27.59, 23, 10.6157, 11.2355, 53.4223, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 9, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 10, 2.87, 23, 2.8990, 0.3393, 20.3653, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 11, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 1, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 2, 12.70, 23, 7.1482, 3.6782, 35.6483, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 3, 11.06, 23, 7.5051, 2.4915, 37.6994, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 4, 27.19, 23, 10.5583, 10.9994, 53.0248, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 5, 37.32, 23, 11.5892, 17.5639, 62.4531, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 6, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 7, 6.73, 23, 4.2264, 1.7564, 22.5715, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 8, 5.00, 23, 4.9424, 0.6047, 31.2896, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 9, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 1, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 2, 9.83, 23, 6.6273, 2.2609, 33.9463, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 3, 18.29, 23, 8.5158, 6.4257, 42.1877, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 4, 16.13, 23, 9.2399, 4.4597, 44.2233, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 5, 26.25, 23, 9.7650, 11.1111, 50.3234, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 6, 11.17, 23, 7.3929, 2.6101, 37.0930, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 7, 13.33, 23, 7.5190, 3.8359, 37.2299, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 8, 5.00, 23, 4.9424, 0.6047, 31.2896, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 9, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 2, 6.83, 21, 6.8149, 0.7781, 40.6420, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 3, 13.23, 21, 10.2292, 2.3213, 49.4495, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 4, 1.75, 21, 1.3661, 0.3402, 8.5350, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 5, 16.70, 21, 10.2457, 4.1377, 48.2331, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 6, 61.49, 21, 15.2219, 29.4611, 85.9191, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 7, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 8, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 9, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 10, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 11, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 12, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.4.a', 'IM', NULL, 2.78, 21, 0.4138, 1.9177, 3.6439, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 6, 9.56, 21, 7.1410, 1.8526, 37.1857, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 7, 5.24, 21, 3.9416, 1.0426, 22.4649, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 8, 18.23, 21, 13.4260, 3.2958, 59.3360, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 9, 12.43, 21, 9.5135, 2.2411, 46.7752, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 10, 13.65, 21, 12.6344, 1.6611, 59.6613, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 11, 40.89, 21, 17.0987, 13.6564, 75.1606, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 1, 1.76, 21, 1.3692, 0.3410, 8.5533, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 2, 16.55, 21, 13.4235, 2.5469, 60.0957, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 4, 28.49, 21, 15.1097, 7.8174, 65.1750, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 5, 16.39, 21, 12.6599, 2.7729, 57.3870, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 6, 0.90, 21, 0.9489, 0.0978, 7.7343, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 7, 6.83, 21, 6.8149, 0.7781, 40.6420, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 8, 28.21, 21, 15.6482, 7.2708, 66.3227, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 9, 0.88, 21, 0.9273, 0.0955, 7.5683, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 1, 13.65, 21, 12.6344, 1.6611, 59.6613, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 2, 16.55, 21, 13.4235, 2.5469, 60.0957, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 4, 17.18, 21, 12.6748, 3.1342, 57.0833, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 5, 23.72, 21, 13.2117, 6.3502, 58.7845, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 6, 4.35, 21, 3.7528, 0.6882, 22.9865, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 7, 6.83, 21, 6.8149, 0.7781, 40.6420, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 8, 0.97, 21, 1.0278, 0.1060, 8.3362, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 9, 16.74, 21, 14.2675, 2.3228, 62.9729, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.4.a', 'IM', NULL, 2.57, 21, 0.4356, 1.6639, 3.4812, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 1, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 2, 13.59, 29, 6.1816, 5.0782, 31.6155, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 3, 28.95, 29, 8.5747, 14.7862, 48.9064, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 4, 14.08, 29, 6.1067, 5.5056, 31.5470, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 5, 21.28, 29, 8.1747, 9.0474, 42.3469, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 6, 14.85, 29, 6.4285, 5.8022, 33.0720, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 7, 7.24, 29, 5.1456, 1.6006, 27.2672, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 8, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 9, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 10, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 11, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 12, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 1, 3.03, 29, 3.0153, 0.3804, 20.3642, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 2, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 3, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 4, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 5, 2.97, 29, 2.9541, 0.3722, 20.0128, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 6, 10.24, 29, 5.9222, 2.9607, 29.9213, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 7, 7.99, 29, 5.5251, 1.8275, 28.8198, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 8, 29.66, 29, 9.4408, 14.3034, 51.5865, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 9, 23.20, 29, 9.3106, 9.3874, 46.8394, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 10, 8.28, 29, 4.7594, 2.4364, 24.5805, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 11, 14.63, 29, 6.7064, 5.3975, 33.9839, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 1, 4.48, 29, 4.2072, 0.6222, 26.0019, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 2, 8.70, 29, 4.9705, 2.5735, 25.5599, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 3, 10.27, 29, 5.9774, 2.9442, 30.1762, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 4, 11.68, 29, 5.8325, 3.9899, 29.6319, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 5, 10.61, 29, 6.0569, 3.1062, 30.5121, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 6, 16.04, 29, 7.1396, 6.0589, 36.1402, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 7, 26.46, 29, 8.4703, 12.8544, 46.7411, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 8, 11.76, 29, 5.6076, 4.2206, 28.7327, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 9, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 1, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 2, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 3, 11.46, 29, 6.4333, 3.4118, 32.1728, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 4, 18.56, 29, 7.3698, 7.7420, 38.2207, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 5, 14.50, 29, 6.6296, 5.3676, 33.6494, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 6, 18.02, 29, 9.4789, 5.5754, 45.0006, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 7, 15.03, 29, 7.2269, 5.2596, 36.0533, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 8, 18.56, 29, 6.9982, 8.1144, 37.0430, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 9, 3.87, 29, 3.8143, 0.4891, 24.7618, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 1, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 2, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 3, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 4, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 5, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 6, 52.63, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 8, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 9, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 10, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 11, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 12, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.4.a', 'IM', NULL, 3.42, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 1, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 2, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 3, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 4, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 5, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 6, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 7, 31.58, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 8, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 9, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 10, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 11, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 1, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 2, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 3, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 4, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 5, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 6, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 7, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 8, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 9, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 1, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 2, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 3, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 4, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 5, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 6, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 7, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 8, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 9, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.4.a', 'IM', NULL, 1.58, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 2, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 4, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 5, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 6, 66.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 7, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 8, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 10, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 11, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 12, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 4, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 5, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 6, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 7, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 8, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 9, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 10, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 11, 33.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 1, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 2, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 3, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 4, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 5, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 6, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 7, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 8, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 1, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 2, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 3, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 4, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 5, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 6, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 8, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 9, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 2, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 4, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 5, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 6, 76.19, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 7, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 8, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 10, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 11, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 12, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.4.a', 'IM', NULL, 3.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 4, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 5, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 6, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 8, 52.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 9, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 10, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 11, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 1, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 2, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 3, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 4, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 5, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 6, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 8, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 1, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 2, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 3, 28.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 4, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 5, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 6, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 8, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.4.a', 'IM', NULL, 1.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 2, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 3, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 5, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 6, 81.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 7, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 8, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.4.a', 'IM', NULL, 3.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 5, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 6, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 8, 63.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 9, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 10, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 11, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 1, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 2, 40.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 3, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 5, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 7, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 8, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 1, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 2, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 3, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 4, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 6, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 7, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 8, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.4.a', 'IM', NULL, 1.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 1, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 2, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 3, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 4, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 5, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 6, 71.43, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 7, 7.14, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 8, 21.43, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 9, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 10, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 11, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 12, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.4.a', 'IM', NULL, 3.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 1, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 2, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 3, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 4, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 5, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 6, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 7, 10.71, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 8, 50.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 9, 21.43, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 10, 14.29, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 11, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 1, 14.29, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 2, 32.14, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 3, 10.71, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 4, 17.86, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 5, 7.14, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 6, 7.14, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 7, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 8, 7.14, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 9, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 1, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 2, 28.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 3, 25.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 4, 25.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 5, 10.71, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 6, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 7, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 8, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 9, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.4.a', 'IM', NULL, 1.61, 28, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 2, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 3, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 4, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 5, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 6, 40.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 8, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.4.a', 'IM', NULL, 2.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 1, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 5, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 6, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 7, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 8, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 9, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 10, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 11, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 1, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 2, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 3, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 5, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 7, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 8, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 9, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 1, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 3, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 4, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 5, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 6, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 7, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 8, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.4.a', 'IM', NULL, 2.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 1, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 2, 25.65, 27, 12.9051, 7.9086, 58.0980, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 3, 6.18, 27, 5.9797, 0.7840, 35.4361, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 4, 19.70, 27, 10.0020, 6.2684, 47.3647, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 5, 31.95, 27, 19.0524, 7.1912, 73.9833, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 6, 10.33, 27, 4.7598, 3.8538, 24.8841, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 7, 5.97, 27, 5.8229, 0.7466, 34.8772, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 8, 0.22, 27, 0.1711, 0.0455, 1.0768, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 9, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 10, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 11, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 12, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 1, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 2, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 4, 6.14, 26, 6.2358, 0.6986, 37.7999, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 5, 27.37, 26, 13.8986, 8.1997, 61.3986, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 6, 17.40, 26, 9.7264, 4.9700, 45.9157, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 7, 36.38, 26, 18.9947, 9.5434, 75.6091, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 8, 12.59, 26, 7.7689, 3.2548, 38.1364, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 9, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 10, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 11, 0.11, 26, 0.1195, 0.0131, 0.9812, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 1, 9.82, 26, 6.4826, 2.3538, 32.9659, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 2, 20.06, 26, 9.6448, 6.7818, 46.4120, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 3, 14.26, 26, 8.5800, 3.7741, 41.3728, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 4, 6.25, 26, 6.2443, 0.7375, 37.4391, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 5, 8.22, 26, 6.4952, 1.4989, 34.5292, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 6, 8.31, 26, 6.7516, 1.4388, 35.9897, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 7, 29.79, 26, 19.7060, 5.7434, 74.7079, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 8, 3.28, 26, 3.3852, 0.3769, 23.3654, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 9, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 1, 18.86, 27, 9.7405, 5.9087, 46.2370, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 2, 22.77, 27, 10.2476, 8.1750, 49.4141, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 3, 17.63, 27, 8.5814, 5.9704, 41.8971, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 4, 0.22, 27, 0.1711, 0.0455, 1.0768, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 5, 5.90, 27, 5.8174, 0.7210, 35.0916, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 6, 6.09, 27, 6.0731, 0.7260, 36.5153, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 7, 25.97, 27, 19.8198, 4.0424, 74.4889, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 8, 2.57, 27, 2.6645, 0.2945, 19.0443, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 9, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 1, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 2, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 3, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 4, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 5, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 6, 23.72, 20, 14.6894, 5.3786, 62.9747, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 7, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 8, 60.71, 20, 13.7962, 31.5303, 83.8309, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 9, 15.57, 20, 8.6675, 4.4346, 42.2980, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 10, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 11, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 12, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.4.a', 'IM', NULL, 4.00, 20, 0.3465, 3.2706, 4.7212, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 1, 7.42, 20, 6.7315, 1.0185, 38.4042, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 2, 1.85, 20, 1.9397, 0.2022, 14.9642, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 3, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 4, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 5, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 6, 3.47, 20, 3.1412, 0.5043, 20.3590, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 7, 37.73, 20, 17.3095, 11.4775, 73.9061, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 8, 11.22, 20, 8.8503, 1.9302, 44.7978, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 9, 1.18, 20, 1.2411, 0.1278, 9.9919, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 10, 31.71, 20, 14.9691, 9.8529, 66.3691, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 11, 5.41, 20, 4.1560, 1.0349, 23.8376, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 1, 13.09, 19, 8.0750, 3.2806, 40.0875, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 2, 46.94, 19, 18.0798, 16.1438, 80.2594, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 3, 3.58, 19, 2.7800, 0.6778, 16.7854, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 4, 2.12, 19, 2.1949, 0.2338, 16.6653, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 5, 8.67, 19, 7.7023, 1.2143, 42.2906, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 6, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 7, 13.12, 19, 9.8939, 2.3777, 48.3338, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 8, 12.49, 19, 9.9641, 2.0574, 49.2148, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 9, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 1, 15.44, 20, 8.2454, 4.6425, 40.6444, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 2, 4.65, 20, 3.4314, 0.9574, 19.7637, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 3, 32.50, 20, 15.0270, 10.2965, 66.8805, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 4, 1.81, 20, 1.8720, 0.2039, 14.2988, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 5, 7.95, 20, 6.7372, 1.2436, 37.2248, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 6, 12.51, 20, 8.9005, 2.5411, 43.9554, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 7, 10.68, 20, 8.8945, 1.6710, 45.6999, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 8, 14.45, 20, 13.1773, 1.7819, 61.1274, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 9, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.4.a', 'IM', NULL, 2.45, 20, 0.5842, 1.2270, 3.6725, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 3, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 4, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 6, 7.62, 40, 5.1225, 1.8578, 26.4399, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 7, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 8, 47.94, 40, 10.0989, 28.8821, 67.6084, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 9, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 10, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 11, 37.24, 40, 10.0688, 19.8904, 58.6514, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 12, 7.20, 40, 5.4548, 1.4671, 28.7992, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.4.a', 'IM', NULL, 2.36, 40, 0.2996, 1.7525, 2.9645, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 3, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 4, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 5, 0.39, 40, 0.3985, 0.0500, 3.0059, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 6, 5.60, 40, 4.4135, 1.0847, 24.3022, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 7, 8.55, 40, 5.4101, 2.2560, 27.4807, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 8, 33.56, 40, 10.9960, 15.6999, 57.7959, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 9, 18.42, 40, 6.6405, 8.4519, 35.5613, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 10, 7.96, 40, 4.9566, 2.1567, 25.3607, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 11, 25.52, 40, 9.1448, 11.4627, 47.5534, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 1, 32.56, 40, 7.6408, 19.2800, 49.3928, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 2, 1.56, 40, 1.0266, 0.4075, 5.7742, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 3, 13.24, 40, 7.3269, 4.0329, 35.6695, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 4, 12.90, 40, 6.8221, 4.1544, 33.5874, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 5, 14.35, 40, 6.7912, 5.1952, 33.8747, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 6, 15.25, 40, 6.4911, 6.1166, 33.1977, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 7, 9.57, 40, 6.6563, 2.1828, 33.4009, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 8, 0.57, 40, 0.5910, 0.0709, 4.4816, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 9, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 1, 16.34, 40, 6.3520, 7.0920, 33.3325, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 2, 11.45, 40, 6.0075, 3.7557, 30.0044, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 3, 9.33, 40, 5.9311, 2.4330, 29.8196, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 4, 25.65, 40, 7.7118, 13.2159, 43.8749, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 5, 12.00, 40, 6.4796, 3.7927, 32.0538, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 6, 10.47, 40, 5.1421, 3.7097, 26.1819, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 7, 9.97, 40, 6.7032, 2.3862, 33.4032, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 8, 4.78, 40, 4.7114, 0.6161, 28.9319, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 9, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.4.a', 'IM', NULL, 1.53, 40, 0.2040, 1.1154, 1.9407, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 1, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 2, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 3, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 4, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 5, 1.15, 23, 1.2225, 0.1238, 9.7953, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 6, 45.52, 23, 9.4702, 27.4563, 64.8468, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 7, 1.15, 23, 1.2225, 0.1238, 9.7953, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 8, 27.04, 23, 6.9297, 15.1742, 43.4353, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 9, 11.85, 23, 11.4453, 1.3667, 56.6011, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 10, 12.15, 23, 8.0669, 2.8029, 39.8698, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 11, 1.15, 23, 1.2225, 0.1238, 9.7953, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 12, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.4.a', 'IM', NULL, 3.10, 23, 0.4839, 2.0942, 4.1014, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 1, 5.05, 23, 5.3054, 0.5342, 34.5259, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 2, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 3, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 4, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 5, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 6, 5.23, 23, 5.1220, 0.6413, 32.0157, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 7, 1.15, 23, 1.2352, 0.1209, 10.0030, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 8, 6.20, 23, 5.5531, 0.9039, 32.3814, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 9, 31.23, 23, 10.0539, 14.6733, 54.5211, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 10, 15.05, 23, 9.1446, 3.8662, 43.8478, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 11, 36.10, 23, 12.7771, 15.1874, 64.0503, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 1, 6.53, 23, 5.6842, 1.0038, 32.5152, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 2, 18.35, 23, 7.9000, 7.0007, 40.1466, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 3, 5.23, 23, 5.1220, 0.6413, 32.0157, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 4, 9.03, 23, 7.0191, 1.6581, 36.8704, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 5, 16.26, 23, 12.0076, 3.0223, 54.7341, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 6, 5.94, 23, 5.2154, 0.9020, 30.4485, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 7, 20.15, 23, 7.6541, 8.6015, 40.3642, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 8, 5.23, 23, 5.1220, 0.6413, 32.0157, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 9, 13.29, 23, 7.7900, 3.6381, 38.3756, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 1, 0.00, 23, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 2, 17.20, 23, 8.0291, 6.0619, 40.0760, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 3, 7.35, 23, 5.8611, 1.3119, 32.1066, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 4, 8.36, 23, 5.8040, 1.8601, 30.5080, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 5, 23.03, 23, 13.4826, 5.8220, 59.1656, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 6, 5.05, 23, 5.3054, 0.5342, 34.5259, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 7, 13.95, 23, 7.6283, 4.1611, 37.7179, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 8, 12.91, 23, 8.0411, 3.2514, 39.5156, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 9, 12.15, 23, 8.0669, 2.8029, 39.8698, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.4.a', 'IM', NULL, 2.13, 23, 0.4747, 1.1425, 3.1115, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 1, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 2, 1.33, 33, 1.4023, 0.1543, 10.5850, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 3, 4.77, 33, 4.6765, 0.6100, 28.9832, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 4, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 5, 5.82, 33, 4.8034, 1.0285, 26.9065, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 6, 55.44, 33, 15.9506, 25.0344, 82.2527, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 7, 1.24, 33, 1.3235, 0.1399, 10.1643, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 8, 28.62, 33, 14.4012, 8.7108, 62.7637, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 9, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 10, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 11, 1.33, 33, 1.4197, 0.1502, 10.8418, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 12, 1.43, 33, 1.2339, 0.2450, 7.9297, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 1, 1.33, 33, 1.4023, 0.1543, 10.5850, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 2, 1.57, 33, 1.6666, 0.1770, 12.5476, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 3, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 4, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 5, 7.16, 33, 5.2763, 1.5077, 27.9788, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 6, 4.77, 33, 4.4315, 0.6804, 26.7737, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 7, 54.02, 33, 15.9050, 24.1753, 81.2384, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 8, 5.29, 33, 3.8674, 1.1470, 21.2016, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 9, 2.00, 33, 1.8070, 0.3118, 11.7686, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 10, 4.50, 33, 3.5042, 0.8869, 19.8761, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 11, 19.35, 33, 13.3058, 4.0560, 57.6712, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 1, 17.45, 33, 7.5754, 6.7518, 38.1566, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 2, 13.28, 33, 6.9669, 4.2722, 34.4297, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 3, 26.16, 33, 12.9773, 8.2681, 58.1933, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 4, 15.25, 33, 9.8854, 3.6489, 46.0797, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 5, 18.00, 33, 9.7977, 5.3708, 45.9024, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 6, 7.96, 33, 4.3506, 2.5146, 22.4747, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 7, 0.38, 33, 0.4014, 0.0423, 3.2456, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 8, 1.54, 33, 1.6145, 0.1794, 12.0168, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 9, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 1, 1.10, 33, 1.1699, 0.1233, 9.0661, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 2, 13.99, 33, 5.9531, 5.6040, 30.8232, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 3, 28.79, 33, 9.3880, 13.7237, 50.6780, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 4, 32.90, 33, 9.6811, 16.7120, 54.4991, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 5, 3.44, 33, 2.2965, 0.8662, 12.7107, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 6, 4.89, 33, 2.9613, 1.3848, 15.8314, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 7, 14.90, 33, 12.9571, 2.1358, 58.3986, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 8, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 9, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 1, 16.14, 36, 13.6610, 2.4201, 59.8966, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 2, 29.66, 36, 15.1324, 8.8202, 64.7714, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 3, 21.34, 36, 12.2687, 5.7984, 54.4696, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 4, 4.56, 36, 4.1619, 0.6817, 24.9729, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 5, 18.56, 36, 13.0154, 3.8183, 56.6896, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 6, 9.73, 36, 6.5211, 2.3305, 32.7332, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 7, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 8, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 9, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 10, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 11, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 12, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.4.a', 'IM', NULL, 2.87, 36, 0.3570, 2.1407, 3.5903, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 1, 15.46, 35, 13.6632, 2.1394, 60.4784, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 2, 13.18, 35, 11.8071, 1.8312, 55.2733, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 3, 1.09, 35, 1.1110, 0.1342, 8.2376, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 4, 13.67, 35, 11.7919, 2.0366, 54.6763, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 5, 0.79, 35, 0.8180, 0.0953, 6.2306, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 6, 19.81, 35, 12.2668, 4.8893, 54.2662, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 7, 18.31, 35, 12.0532, 4.1772, 53.5479, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 8, 10.73, 35, 7.6143, 2.3335, 37.6805, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 9, 0.00, 35, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 10, 0.00, 35, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 11, 6.96, 35, 6.1160, 1.0857, 33.7708, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 1, 8.37, 36, 6.8387, 1.4725, 35.8268, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 2, 14.01, 36, 7.6977, 4.2661, 37.3490, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 3, 40.45, 36, 15.6478, 15.3758, 71.7499, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 4, 19.62, 36, 12.0704, 4.9062, 53.5831, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 5, 11.08, 36, 7.5184, 2.5780, 36.9727, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 6, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 7, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 8, 6.47, 36, 6.0015, 0.9143, 34.1314, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 9, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 1, 8.39, 36, 6.8418, 1.4832, 35.8080, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 2, 10.44, 36, 6.8452, 2.5689, 34.0066, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 3, 45.77, 36, 15.4640, 19.2440, 74.9383, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 4, 5.04, 36, 3.2083, 1.3429, 17.1482, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 5, 23.88, 36, 13.2013, 6.7031, 57.8138, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 6, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 7, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 8, 6.47, 36, 6.0015, 0.9143, 34.1314, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 9, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.4.a', 'IM', NULL, 2.30, 36, 0.3453, 1.5944, 2.9962, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 1, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 2, 56.51, 27, 8.6163, 38.7293, 72.7630, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 3, 6.74, 27, 4.5306, 1.6143, 24.1292, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 4, 30.01, 27, 7.8189, 16.6346, 47.9638, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 5, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 6, 6.74, 27, 4.7671, 1.4958, 25.5740, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 7, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 8, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 9, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 10, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 11, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 12, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.4.a', 'IM', NULL, 2.10, 26, 0.3607, 1.3573, 2.8430, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 1, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 2, 0.76, 26, 0.7813, 0.0905, 6.0760, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 4, 7.91, 26, 7.3167, 1.0721, 40.4789, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 5, 2.60, 26, 2.6161, 0.3161, 18.3213, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 6, 12.77, 26, 7.0900, 3.7970, 35.1927, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 7, 33.55, 26, 11.5706, 14.7735, 59.5179, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 8, 23.87, 26, 9.7568, 9.4014, 48.6495, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 9, 12.77, 26, 7.8744, 3.3019, 38.5666, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 10, 1.92, 26, 1.8838, 0.2491, 13.3140, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 11, 3.86, 26, 3.6685, 0.5200, 23.5350, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 1, 3.44, 26, 2.2875, 0.8554, 12.8260, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 2, 26.10, 26, 12.7111, 8.3304, 57.8458, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 3, 31.43, 26, 11.1765, 13.6059, 57.1473, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 4, 11.76, 26, 8.9602, 2.2029, 44.1000, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 5, 17.50, 26, 8.6133, 5.8456, 42.0216, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 6, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 7, 5.67, 26, 3.7447, 1.4002, 20.2696, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 8, 4.11, 26, 3.3023, 0.7551, 19.4132, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 9, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 1, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 2, 30.10, 26, 9.9242, 14.0132, 53.2160, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 3, 25.04, 26, 10.8117, 9.2556, 52.2440, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 4, 22.27, 26, 11.3001, 6.9473, 52.3580, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 5, 3.90, 26, 3.2255, 0.6849, 19.2793, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 6, 7.00, 26, 4.9245, 1.5584, 26.3361, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 7, 11.70, 26, 6.6865, 3.3762, 33.4439, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 8, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 9, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.4.a', 'IM', NULL, 2.01, 26, 0.2105, 1.5753, 2.4423, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.1', 'RL', 1, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.1', 'RL', 2, 0.69, 18, 0.7179, 0.0745, 6.0031, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.1', 'RL', 3, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.1', 'RL', 4, 23.06, 18, 11.5413, 7.0589, 54.1764, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.1', 'RL', 5, 16.79, 18, 13.7663, 2.4597, 61.7379, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.1', 'RL', 6, 52.12, 18, 15.1081, 23.2838, 79.6129, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.1', 'RL', 7, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.1', 'RL', 8, 7.35, 18, 7.5177, 0.7664, 44.8952, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.1', 'RL', 9, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.1', 'RL', 10, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.1', 'RL', 11, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.1', 'RL', 12, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '2.D.4.a', 'IM', NULL, 2.60, 18, 0.3572, 1.8508, 3.3582, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.1', 'RW', 1, 0.55, 18, 0.5760, 0.0611, 4.8206, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.1', 'RW', 2, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.1', 'RW', 3, 2.73, 18, 2.8252, 0.2968, 20.9355, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.1', 'RW', 4, 25.21, 18, 19.6338, 3.6099, 75.2052, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.1', 'RW', 5, 2.11, 18, 1.7202, 0.3690, 11.1154, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.1', 'RW', 6, 11.76, 18, 9.5696, 1.8697, 48.2556, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.1', 'RW', 7, 32.95, 18, 17.7015, 8.3110, 72.7110, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.1', 'RW', 8, 2.73, 18, 2.8064, 0.3012, 20.6891, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.1', 'RW', 9, 21.40, 18, 15.3559, 3.8180, 65.1381, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.1', 'RW', 10, 0.55, 18, 0.5760, 0.0611, 4.8206, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.1', 'RW', 11, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.2', 'PT', 1, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.2', 'PT', 2, 45.38, 18, 18.4392, 14.7433, 79.9662, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.2', 'PT', 3, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.2', 'PT', 4, 20.70, 18, 11.3001, 5.7556, 52.7291, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.2', 'PT', 5, 17.89, 18, 13.8337, 2.9020, 61.3734, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.2', 'PT', 6, 15.48, 18, 13.5912, 2.0041, 62.1129, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.2', 'PT', 7, 0.55, 18, 0.5760, 0.0611, 4.8206, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.2', 'PT', 8, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.2', 'PT', 9, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.3', 'OJ', 1, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.3', 'OJ', 2, 20.17, 18, 9.1563, 7.0749, 45.6134, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.3', 'OJ', 3, 21.64, 18, 11.5992, 6.1199, 53.9012, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.3', 'OJ', 4, 12.22, 18, 8.3146, 2.6413, 41.6691, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.3', 'OJ', 5, 31.36, 18, 17.6691, 7.4824, 72.0826, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.3', 'OJ', 6, 14.61, 18, 13.5205, 1.7084, 62.7405, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.3', 'OJ', 7, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.3', 'OJ', 8, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.3', 'OJ', 9, 0.00, 18, 0.0000, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9072.00', '3.A.4.a', 'IM', NULL, 1.86, 18, 0.2062, 1.4243, 2.2942, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 1, 18.32, 15, 16.4142, 2.0884, 70.2222, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 2, 1.15, 15, 0.8828, 0.2174, 5.8092, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 3, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 4, 5.89, 15, 4.3890, 1.1314, 25.4876, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 5, 3.05, 15, 2.6925, 0.4448, 18.1466, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 6, 71.60, 15, 16.6749, 30.2771, 93.6026, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 7, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 8, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 9, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 10, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 11, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 12, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 1, 18.32, 15, 16.4142, 2.0884, 70.2222, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 2, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 3, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 4, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 5, 0.57, 15, 0.6054, 0.0590, 5.3290, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 6, 19.08, 15, 12.4885, 3.9958, 57.1998, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 7, 43.13, 15, 19.0903, 12.5019, 80.1043, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 8, 18.89, 15, 16.3956, 2.2933, 69.8021, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 9, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 10, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 11, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 1, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 2, 18.32, 15, 16.4142, 2.0884, 70.2222, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 3, 35.85, 15, 17.9346, 9.4958, 74.8510, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 4, 24.88, 15, 16.1631, 4.9287, 67.9137, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 5, 1.31, 15, 1.3719, 0.1353, 11.4691, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 6, 1.32, 15, 1.0210, 0.2499, 6.6952, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 7, 18.32, 15, 16.4142, 2.0884, 70.2222, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 8, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 9, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 1, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 2, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 3, 41.06, 15, 18.6043, 11.8106, 78.3675, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 4, 3.62, 15, 2.8170, 0.6623, 17.4970, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 5, 17.93, 15, 14.8252, 2.4563, 65.4683, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 6, 19.07, 15, 16.3979, 2.3558, 69.7071, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 7, 18.32, 15, 16.4142, 2.0884, 70.2222, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 8, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 9, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 1, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 2, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 3, 7.14, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 4, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 5, 10.71, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 6, 46.43, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 7, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 8, 21.43, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 9, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 10, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 11, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 12, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.4.a', 'IM', NULL, 3.67, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 2, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 3, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 4, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 5, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 6, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 7, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 8, 37.04, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 9, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 10, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 11, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 1, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 2, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 3, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 4, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 5, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 6, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 7, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 8, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 9, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 2, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 3, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 4, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 5, 33.33, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 6, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 7, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 8, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 9, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.4.a', 'IM', NULL, 2.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 1, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 2, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 3, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 5, 7.29, 25, 7.2903, 0.8418, 42.1459, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 6, 35.07, 25, 7.6296, 21.2892, 51.8868, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 7, 2.24, 25, 2.2363, 0.2784, 15.8521, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 8, 15.07, 25, 6.9655, 5.4594, 35.3013, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 9, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 10, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 11, 13.62, 25, 9.6449, 2.8226, 46.1262, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 12, 26.70, 25, 9.5632, 11.7304, 49.9668, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.4.a', 'IM', NULL, 1.95, 25, 0.2703, 1.3964, 2.5120, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 1, 3.32, 25, 2.4602, 0.7037, 14.3039, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 2, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 3, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 6, 15.93, 25, 10.8054, 3.4625, 50.0433, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 7, 25.71, 25, 7.7399, 13.0375, 44.4031, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 8, 19.31, 25, 9.6320, 6.2615, 46.1534, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 9, 7.27, 25, 6.1106, 1.1910, 33.7427, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 10, 13.70, 25, 7.2367, 4.2948, 35.9583, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 11, 14.76, 25, 9.8923, 3.3047, 46.7350, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 1, 9.68, 25, 6.1586, 2.4424, 31.4437, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 2, 36.79, 25, 8.1861, 21.9660, 54.6209, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 3, 12.08, 25, 7.4141, 3.1517, 36.7227, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 4, 7.27, 25, 6.1106, 1.1910, 33.7427, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 5, 6.30, 25, 5.3010, 1.0449, 30.0130, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 6, 12.46, 25, 9.4074, 2.3423, 45.7745, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 7, 8.13, 25, 5.5333, 1.8815, 28.9919, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 8, 7.29, 25, 7.2903, 0.8418, 42.1459, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 9, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 1, 2.41, 25, 2.4075, 0.2988, 16.9430, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 2, 16.36, 25, 7.0619, 6.3195, 36.2062, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 3, 24.58, 25, 11.1308, 8.6217, 52.9462, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 4, 7.27, 25, 6.1106, 1.1910, 33.7427, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 5, 8.72, 25, 5.6793, 2.1424, 29.4087, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 6, 25.24, 25, 8.2887, 12.0027, 45.5333, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 7, 8.13, 25, 5.6578, 1.8190, 29.7052, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 8, 7.29, 25, 7.2903, 0.8418, 42.1459, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 9, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.4.a', 'IM', NULL, 1.73, 25, 0.1733, 1.3764, 2.0916, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 1, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 2, 7.03, 19, 6.1035, 1.0535, 34.9660, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 3, 11.58, 19, 8.6244, 2.1811, 43.4607, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 4, 9.24, 19, 8.7329, 1.1294, 47.5767, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 5, 5.92, 19, 4.9004, 0.9824, 28.5450, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 6, 60.13, 19, 12.6964, 33.1391, 82.1022, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 7, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 8, 4.83, 19, 5.1096, 0.4888, 34.3999, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 9, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 10, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 11, 1.27, 19, 1.3033, 0.1448, 10.2478, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 12, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.4.a', 'IM', NULL, 2.65, 19, 0.4303, 1.7491, 3.5570, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 1, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 2, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 3, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 4, 14.07, 19, 9.4511, 3.0705, 45.8309, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 5, 11.62, 19, 6.9061, 3.1026, 35.0665, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 6, 33.58, 19, 12.9053, 13.0368, 63.0310, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 7, 25.63, 19, 8.9694, 11.3671, 48.0853, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 8, 13.83, 19, 9.5861, 2.8757, 46.5181, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 9, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 10, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 11, 1.27, 19, 1.3033, 0.1448, 10.2478, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 1, 9.16, 19, 6.8597, 1.7531, 36.3013, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 2, 25.69, 19, 11.4139, 8.9619, 54.8342, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 3, 17.02, 19, 7.9736, 5.8948, 40.1775, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 4, 27.27, 19, 11.1829, 10.2867, 55.0713, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 5, 20.86, 19, 11.8646, 5.5044, 54.4024, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 6, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 7, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 8, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 9, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 1, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 2, 7.03, 19, 6.1035, 1.0535, 34.9660, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 3, 12.48, 19, 8.7763, 2.5672, 43.5469, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 4, 35.92, 19, 7.6022, 21.8774, 52.8716, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 5, 41.96, 19, 8.6882, 25.4698, 60.4742, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 6, 2.61, 19, 2.0634, 0.4823, 12.8663, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 7, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 8, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 9, 0.00, 19, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.4.a', 'IM', NULL, 1.87, 19, 0.1664, 1.5242, 2.2236, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 2, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 5, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 6, 50.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 8, 50.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.4.a', 'IM', NULL, 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 1, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 3, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 4, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 6, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 7, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 8, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 9, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 10, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 11, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 1, 40.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 2, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 3, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 4, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 6, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 7, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 8, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 9, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 1, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 2, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 3, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 4, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 6, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 7, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 8, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 9, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.4.a', 'IM', NULL, 1.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 1, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 2, 62.10, 29, 8.5429, 43.7911, 77.5115, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 3, 6.69, 29, 6.5234, 0.8375, 37.8659, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 4, 11.07, 29, 6.0584, 3.4080, 30.5124, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 5, 6.69, 29, 6.0169, 0.9873, 34.0434, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 6, 13.44, 29, 6.7756, 4.4981, 33.8591, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 7, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 8, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 9, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 10, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 11, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 12, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 1, 27.12, 29, 9.8523, 11.8206, 50.8140, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 2, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 3, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 4, 6.69, 29, 6.0028, 0.9918, 33.9397, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 5, 10.82, 29, 6.1784, 3.1659, 31.0525, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 6, 12.22, 29, 6.5335, 3.8459, 32.6495, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 7, 7.10, 29, 4.2861, 1.9762, 22.4392, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 8, 18.87, 29, 8.5609, 6.8858, 42.2362, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 9, 3.81, 29, 3.7931, 0.4721, 24.8263, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 10, 10.43, 29, 7.0772, 2.4091, 35.4661, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 11, 2.94, 29, 2.1398, 0.6475, 12.3379, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 1, 6.69, 29, 6.5234, 0.8375, 37.8659, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 2, 19.04, 29, 7.2100, 8.2753, 38.0056, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 3, 13.34, 29, 7.2690, 4.0756, 35.8198, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 4, 26.46, 29, 7.7469, 13.7285, 44.8478, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 5, 13.39, 29, 6.4804, 4.6893, 32.6888, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 6, 4.75, 29, 4.7067, 0.5889, 29.5755, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 7, 6.69, 29, 6.5234, 0.8375, 37.8659, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 8, 9.63, 29, 6.7174, 2.1473, 34.1188, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 9, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 1, 6.86, 28, 6.6872, 0.8537, 38.6688, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 2, 11.41, 28, 6.7074, 3.1955, 33.4476, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 3, 27.11, 28, 8.6171, 13.1942, 47.6435, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 4, 18.68, 28, 7.9713, 7.2589, 40.2701, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 5, 17.83, 28, 7.2966, 7.2438, 37.6122, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 6, 1.41, 28, 1.4429, 0.1682, 10.7697, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 7, 1.41, 28, 1.4362, 0.1699, 10.6742, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 8, 15.30, 28, 9.2822, 3.9867, 43.9894, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 9, 0.00, 28, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 2, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 3, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 4, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 5, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 6, 55.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 8, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 10, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.4.a', 'IM', NULL, 3.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 5, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 6, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 7, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 8, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 9, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 10, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 1, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 2, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 3, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 4, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 5, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 6, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 7, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 8, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 9, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 2, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 3, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 4, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 5, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 7, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 8, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.4.a', 'IM', NULL, 2.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 1, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 2, 7.24, 27, 7.0927, 0.8842, 40.6111, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 3, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 4, 2.19, 27, 2.2047, 0.2677, 15.6878, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 5, 8.15, 27, 6.2267, 1.5809, 32.9053, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 6, 50.36, 27, 11.8760, 27.6483, 72.9293, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 7, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 8, 23.93, 27, 9.4009, 9.8154, 47.6286, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 9, 8.12, 27, 6.3404, 1.5182, 33.6396, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 10, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 11, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 12, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.4.a', 'IM', NULL, 2.73, 23, 0.3046, 2.1021, 3.3653, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 1, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 2, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 3, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 4, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 5, 12.31, 27, 7.4732, 3.2701, 36.8113, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 6, 17.39, 27, 8.0447, 6.2457, 39.9608, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 7, 18.42, 27, 6.6415, 8.3398, 35.8982, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 8, 26.13, 27, 10.4742, 10.3915, 51.9051, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 9, 18.02, 27, 9.7642, 5.3460, 46.0983, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 10, 5.91, 27, 5.7617, 0.7420, 34.5655, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 11, 1.82, 27, 1.7467, 0.2481, 12.1435, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 1, 16.12, 27, 8.2682, 5.1826, 40.3134, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 2, 19.72, 27, 8.1972, 7.8150, 41.5939, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 3, 39.94, 27, 12.5956, 18.4350, 66.1824, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 4, 10.49, 27, 6.9389, 2.4993, 34.8690, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 5, 11.25, 27, 7.7953, 2.4861, 38.6815, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 6, 2.48, 27, 2.3168, 0.3517, 15.4345, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 7, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 8, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 9, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 1, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 2, 10.25, 27, 5.8698, 2.9871, 29.7717, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 3, 33.44, 27, 9.7214, 16.9910, 55.2152, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 4, 13.20, 27, 5.3577, 5.4952, 28.4503, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 5, 33.58, 27, 10.9109, 15.6109, 58.0193, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 6, 9.53, 27, 4.6200, 3.3810, 24.0646, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 7, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 8, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 9, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.4.a', 'IM', NULL, 2.02, 23, 0.2262, 1.5481, 2.4864, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 2, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 4, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 5, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 6, 59.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 7, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 8, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.4.a', 'IM', NULL, 3.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 5, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 6, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 7, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 8, 50.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 9, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 10, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 11, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 1, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 2, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 3, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 4, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 5, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 6, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 7, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 8, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 1, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 2, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 3, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 4, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 5, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 6, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 7, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 8, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.4.a', 'IM', NULL, 2.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 1, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 2, 25.54, 17, 11.4699, 8.7143, 55.1932, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 3, 14.63, 17, 12.8869, 1.8854, 60.4337, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 4, 3.49, 17, 3.6178, 0.3684, 26.0843, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 5, 49.85, 17, 13.6199, 23.8531, 75.9346, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 6, 1.16, 17, 1.2286, 0.1219, 10.1885, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 7, 5.33, 17, 5.3750, 0.5868, 34.9821, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 8, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 10, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 11, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 12, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.4.a', 'IM', NULL, 3.62, 17, 0.3800, 2.8119, 4.4233, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 1, 28.09, 17, 13.5666, 8.5975, 61.8642, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 2, 1.47, 17, 1.5897, 0.1466, 13.2223, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 3, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 4, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 5, 14.69, 17, 12.8971, 1.9062, 60.4092, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 6, 15.75, 17, 11.5278, 2.8787, 54.1088, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 7, 28.64, 17, 11.8541, 10.5063, 57.8532, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 8, 11.35, 17, 6.5458, 3.1247, 33.7072, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 10, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 11, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 1, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 2, 29.52, 17, 11.3404, 11.6556, 57.0851, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 3, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 4, 1.47, 17, 1.5895, 0.1466, 13.2211, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 5, 34.59, 17, 13.3803, 13.1137, 64.9423, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 6, 29.77, 17, 15.9421, 7.7625, 68.0941, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 7, 3.49, 17, 3.6178, 0.3684, 26.0843, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 8, 1.16, 17, 1.2286, 0.1219, 10.1885, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 1, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 2, 25.60, 17, 16.1681, 5.3832, 67.5390, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 3, 2.95, 17, 2.3174, 0.5420, 14.4699, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 4, 30.61, 17, 13.5783, 10.2115, 63.1038, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 5, 15.79, 17, 10.2425, 3.5332, 48.9759, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 6, 25.06, 17, 12.4506, 7.5797, 57.6892, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 7, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 8, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.4.a', 'IM', NULL, 3.47, 17, 0.4585, 2.4979, 4.4417, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 1, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 2, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 3, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 4, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 5, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 6, 42.31, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 7, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 8, 50.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 9, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 10, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 11, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 12, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.4.a', 'IM', NULL, 4.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 1, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 2, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 3, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 4, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 5, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 6, 26.92, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 7, 46.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 8, 15.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 9, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 10, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 11, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 1, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 2, 38.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 3, 15.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 4, 11.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 5, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 6, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 7, 7.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 8, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 9, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 1, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 2, 38.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 3, 11.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 4, 26.92, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 5, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 6, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 7, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 8, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 9, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.4.a', 'IM', NULL, 2.73, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 2, 6.23, 21, 4.0449, 1.5447, 21.9723, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 3, 33.66, 21, 21.0333, 6.6381, 78.3515, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 4, 13.83, 21, 14.6167, 1.2287, 67.4508, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 5, 25.29, 21, 16.6090, 5.1329, 67.9281, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 6, 20.55, 21, 16.7844, 2.9412, 68.8287, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 7, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 8, 0.44, 21, 0.4534, 0.0493, 3.7319, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 9, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 10, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 11, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 12, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 1, 0.05, 21, 0.0528, 0.0055, 0.4528, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 3, 13.04, 21, 14.4835, 1.0323, 68.2937, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 4, 0.72, 21, 0.7534, 0.0789, 6.1752, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 5, 2.93, 21, 2.9879, 0.3372, 21.2473, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 6, 5.98, 21, 4.3582, 1.2484, 24.2620, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 7, 41.46, 21, 22.7368, 9.1199, 83.3296, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 8, 30.13, 21, 16.5642, 7.7126, 69.0029, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 9, 0.47, 21, 0.5006, 0.0522, 4.1693, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 10, 5.21, 21, 5.2508, 0.5961, 33.5367, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 11, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 1, 18.72, 21, 16.0238, 2.4976, 67.4446, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 2, 23.97, 21, 16.3772, 4.6129, 67.2653, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 3, 40.59, 21, 22.7749, 8.7003, 83.0511, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 4, 8.58, 21, 7.3058, 1.3269, 39.5766, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 5, 6.96, 21, 5.1631, 1.3962, 28.3039, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 6, 1.18, 21, 0.9299, 0.2248, 5.9335, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 7, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 8, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 9, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 1, 4.48, 21, 4.1407, 0.6205, 26.0790, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 2, 23.62, 21, 16.4246, 4.4250, 67.3804, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 3, 59.53, 21, 15.7907, 27.2642, 85.2356, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 4, 1.11, 21, 0.8874, 0.2056, 5.7262, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 5, 10.36, 21, 7.7924, 1.9690, 39.9487, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 6, 0.90, 21, 0.6953, 0.1771, 4.4202, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 7, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 8, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 9, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 1, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 2, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 3, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 4, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 5, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 6, 73.91, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 7, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 8, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 9, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 10, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 11, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 12, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.4.a', 'IM', NULL, 2.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 1, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 2, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 3, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 4, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 5, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 6, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 7, 34.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 8, 26.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 9, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 10, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 11, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 1, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 2, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 3, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 4, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 5, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 7, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 8, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 9, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 2, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 3, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 4, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 5, 27.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 6, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 7, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 8, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.4.a', 'IM', NULL, 1.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 1, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 2, 8.93, 24, 5.6272, 2.2923, 29.0916, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 3, 6.72, 24, 6.4931, 0.8380, 38.0446, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 4, 1.27, 24, 1.3131, 0.1464, 10.1107, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 5, 5.33, 24, 4.3197, 0.9471, 24.8682, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 6, 63.38, 24, 11.9817, 37.2981, 83.4287, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 7, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 8, 14.21, 24, 7.4992, 4.4326, 37.1585, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 9, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 10, 0.17, 24, 0.1740, 0.0194, 1.4263, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 11, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 12, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.4.a', 'IM', NULL, 3.27, 24, 0.3403, 2.5696, 3.9776, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 1, 13.44, 24, 9.0249, 3.0249, 43.5902, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 2, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 3, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 4, 1.27, 24, 1.3131, 0.1464, 10.1107, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 5, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 6, 9.81, 24, 6.5952, 2.2738, 33.7049, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 7, 42.56, 24, 14.2516, 18.1584, 71.2231, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 8, 18.38, 24, 8.0118, 6.9436, 40.4681, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 9, 4.58, 24, 4.5230, 0.5598, 29.0089, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 10, 5.02, 24, 3.8264, 0.9953, 21.7517, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 11, 4.94, 24, 3.7918, 0.9691, 21.6373, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 1, 4.41, 24, 3.5883, 0.7857, 21.1652, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 2, 5.08, 24, 4.2560, 0.8563, 24.9310, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 3, 14.06, 24, 12.6916, 1.8280, 58.9666, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 4, 12.05, 24, 7.6616, 2.9768, 37.9387, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 5, 13.74, 24, 7.1792, 4.3539, 35.8018, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 6, 30.86, 24, 10.3796, 14.0279, 54.9757, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 7, 18.53, 24, 9.8779, 5.5514, 46.8233, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 8, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 9, 1.27, 24, 1.3324, 0.1418, 10.4037, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 1, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 2, 8.85, 24, 5.8545, 2.1181, 30.3481, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 3, 27.04, 24, 14.0097, 7.8618, 61.6918, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 4, 20.96, 24, 9.4833, 7.5046, 46.4259, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 5, 13.87, 24, 6.7375, 4.7717, 34.0852, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 6, 22.56, 24, 9.4594, 8.6811, 47.1730, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 7, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 8, 0.00, 24, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 9, 6.72, 24, 6.6118, 0.8060, 38.9726, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.4.a', 'IM', NULL, 2.35, 23, 0.2748, 1.7780, 2.9179, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 2, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 3, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 4, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 6, 54.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 7, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 8, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.4.a', 'IM', NULL, 3.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 3, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 5, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 6, 27.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 7, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 8, 31.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 10, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 11, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 1, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 2, 28.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 3, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 4, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 5, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 6, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 8, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 2, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 3, 31.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 4, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 5, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 6, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 7, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 8, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.4.a', 'IM', NULL, 1.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 1, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 2, 14.92, 20, 11.3171, 2.6401, 53.1263, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 3, 7.07, 20, 4.4618, 1.8052, 23.9628, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 4, 3.55, 20, 3.3624, 0.4706, 22.3095, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 5, 39.70, 20, 16.6486, 13.3137, 73.8400, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 6, 34.76, 20, 14.8418, 11.9232, 67.7018, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 7, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 8, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 9, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 10, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 11, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 12, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.4.a', 'IM', NULL, 2.30, 20, 0.3844, 1.4970, 3.1063, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 1, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 2, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 3, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 4, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 5, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 6, 25.03, 20, 15.0017, 5.8938, 64.0201, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 7, 9.70, 20, 5.9619, 2.5221, 30.8645, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 8, 38.80, 20, 15.6845, 13.7282, 71.6436, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 9, 4.64, 20, 3.4965, 0.9240, 20.2719, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 10, 2.67, 20, 2.7638, 0.2970, 20.2281, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 11, 19.15, 20, 14.2735, 3.3236, 61.9941, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 1, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 2, 3.23, 20, 3.3245, 0.3607, 23.5888, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 3, 7.95, 20, 4.8887, 2.0903, 25.9035, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 4, 2.93, 20, 3.0201, 0.3260, 21.7903, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 5, 45.51, 20, 16.2035, 17.5432, 76.6307, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 6, 16.58, 20, 12.5262, 2.8999, 56.9511, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 7, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 8, 23.79, 20, 14.3278, 5.6344, 62.0064, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 9, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 1, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 2, 3.23, 20, 3.3245, 0.3607, 23.5888, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 3, 10.56, 20, 5.8872, 3.1056, 30.3249, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 4, 15.55, 20, 12.3886, 2.4906, 57.0176, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 5, 37.79, 20, 16.4981, 12.2687, 72.5197, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 6, 9.08, 20, 5.4843, 2.4231, 28.6304, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 7, 3.23, 20, 3.3245, 0.3607, 23.5888, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 8, 20.56, 20, 14.2193, 4.0139, 61.5511, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 9, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.4.a', 'IM', NULL, 1.74, 20, 0.2063, 1.3108, 2.1745, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 1, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 2, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 3, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 4, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 5, 18.27, 16, 12.3359, 3.6984, 56.5307, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 6, 66.85, 16, 15.0733, 32.1165, 89.5761, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 7, 2.61, 16, 2.7248, 0.2714, 20.8548, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 8, 12.28, 16, 11.4868, 1.4211, 57.6107, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 9, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 10, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 11, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 12, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 1, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 2, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 3, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 4, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 5, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 6, 24.41, 16, 12.3793, 7.1705, 57.4347, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 7, 14.96, 16, 13.3352, 1.8471, 62.1675, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 8, 33.56, 16, 11.3881, 14.5379, 60.0076, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 9, 20.15, 16, 11.9693, 4.9159, 55.1978, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 10, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 11, 6.92, 16, 5.3189, 1.2642, 30.1703, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 1, 11.34, 16, 7.0090, 2.8138, 36.1100, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 2, 6.14, 16, 5.7434, 0.7756, 35.3735, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 3, 27.85, 16, 13.2940, 8.6082, 61.2579, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 4, 16.02, 16, 8.4111, 4.7919, 41.9661, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 5, 8.75, 16, 6.8363, 1.5213, 37.2986, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 6, 6.14, 16, 5.7434, 0.7756, 35.3735, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 7, 2.67, 16, 2.7257, 0.2930, 20.4061, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 8, 21.09, 16, 13.4366, 4.5656, 59.9024, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 9, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 1, 6.14, 16, 5.7434, 0.7756, 35.3735, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 2, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 3, 22.58, 16, 12.7349, 5.8150, 57.9457, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 4, 22.24, 16, 12.0524, 6.0792, 55.8156, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 5, 16.53, 16, 8.8698, 4.7904, 43.8043, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 6, 17.56, 16, 8.0937, 6.0749, 41.2219, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 7, 14.96, 16, 13.3352, 1.8471, 62.1675, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 8, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 9, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 2, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 5, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 6, 77.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 7, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 8, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 9, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.4.a', 'IM', NULL, 2.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 1, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 5, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 6, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 7, 31.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 8, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 9, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 10, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 11, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 1, 36.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 2, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 5, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 6, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 7, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 8, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 9, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 1, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 2, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 3, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 4, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 5, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 6, 27.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 7, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 8, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.4.a', 'IM', NULL, 1.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 1, 1.34, 22, 1.3393, 0.1642, 10.0588, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 2, 37.97, 22, 14.5245, 14.5158, 68.8202, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 4, 2.56, 22, 1.4676, 0.7669, 8.1981, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 6, 41.33, 22, 13.3374, 18.3260, 68.8555, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 7, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 8, 16.80, 22, 11.4504, 3.5468, 52.5905, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 9, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 10, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 11, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 12, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 3, 10.30, 22, 9.2897, 1.3981, 48.1717, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 5, 17.63, 22, 11.0183, 4.2323, 50.9063, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 6, 36.61, 22, 15.4602, 12.6286, 69.7731, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 7, 11.52, 22, 9.5694, 1.8142, 47.8448, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 8, 14.25, 22, 9.6327, 3.1249, 46.1252, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 9, 9.69, 22, 9.2592, 1.1734, 49.2122, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 10, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 11, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 1, 32.29, 22, 13.7861, 11.3846, 63.8931, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 2, 33.10, 22, 13.6157, 12.1047, 63.9906, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 3, 10.30, 22, 9.5060, 1.3326, 49.3882, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 4, 3.90, 22, 2.6598, 0.9179, 15.0798, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 5, 14.43, 22, 7.5758, 4.4929, 37.6567, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 6, 6.00, 22, 5.5724, 0.8097, 33.2639, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 7, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 8, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 9, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 2, 31.07, 22, 15.1697, 9.3679, 66.2909, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 3, 34.44, 22, 13.6097, 13.0385, 64.7859, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 4, 18.12, 22, 10.5351, 4.8087, 49.2106, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 5, 2.43, 22, 1.9272, 0.4586, 11.8888, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 6, 13.94, 22, 7.5197, 4.2145, 37.3612, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 7, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 8, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 9, 0.00, 22, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 1, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 2, 7.60, 20, 6.7449, 1.0914, 38.0346, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 3, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 4, 7.28, 20, 6.4553, 1.0503, 36.7499, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 5, 8.29, 20, 7.3909, 1.1669, 40.8861, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 6, 76.83, 20, 11.6006, 45.8778, 92.8400, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 7, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 8, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 9, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 10, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 11, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 12, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 1, 11.27, 20, 8.6637, 2.0312, 43.7769, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 2, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 3, 10.11, 20, 8.7174, 1.4882, 45.5765, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 4, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 5, 7.60, 20, 6.7550, 1.0881, 38.1059, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 6, 13.89, 20, 9.6623, 2.8872, 46.6651, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 7, 13.91, 20, 8.2198, 3.7018, 40.4648, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 8, 7.97, 20, 6.6046, 1.2974, 36.3172, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 9, 1.48, 20, 1.5326, 0.1658, 11.9474, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 10, 15.67, 20, 13.7152, 2.0744, 61.9913, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 11, 18.09, 20, 10.3618, 4.8607, 48.8343, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 1, 5.18, 20, 5.3659, 0.5533, 34.9461, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 2, 18.69, 20, 13.5647, 3.4255, 59.8205, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 3, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 4, 21.12, 20, 11.1934, 6.1582, 52.2137, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 5, 22.07, 20, 17.2784, 3.3433, 69.8692, 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 6, 9.92, 20, 6.9271, 2.1294, 35.8071, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 7, 10.11, 20, 9.4680, 1.2549, 49.8865, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 8, 6.29, 20, 6.4339, 0.6776, 39.7461, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 9, 6.62, 20, 6.7493, 0.7154, 41.0714, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 1, 5.18, 20, 5.3659, 0.5533, 34.9461, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 2, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 3, 18.32, 20, 13.6185, 3.2287, 60.1111, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 4, 29.99, 20, 13.5687, 9.9716, 62.3600, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 5, 3.78, 20, 2.8727, 0.7454, 17.0304, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 6, 29.83, 20, 17.0204, 7.1926, 69.9830, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 7, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 8, 12.90, 20, 9.1120, 2.6432, 44.7066, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 9, 0.00, 20, 0.0000, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 1, 13.92, 29, 9.0469, 3.3266, 43.1604, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 2, 20.30, 29, 13.2100, 4.5648, 57.5626, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 3, 10.30, 29, 9.7474, 1.3074, 49.9099, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 4, 8.21, 29, 5.9908, 1.7253, 31.3079, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 5, 11.43, 29, 8.4619, 2.2761, 41.6936, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 6, 34.65, 29, 16.2670, 10.8497, 69.7838, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 7, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 8, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 9, 1.19, 29, 1.2451, 0.1380, 9.5222, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 10, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 11, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 12, 0.00, 29, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 1, 15.45, 27, 11.4053, 2.9472, 52.3720, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 2, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 3, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 4, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 5, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 6, 22.47, 27, 14.1205, 5.1922, 60.5303, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 7, 48.58, 27, 17.7637, 17.9703, 80.2991, 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 8, 12.79, 27, 9.1443, 2.6489, 44.1620, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 9, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 10, 0.70, 27, 0.5153, 0.1551, 3.1271, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 11, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 1, 28.19, 27, 18.7255, 5.5385, 72.4393, 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 2, 6.02, 27, 4.4268, 1.2638, 24.2450, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 3, 21.74, 27, 14.0885, 4.8176, 60.3777, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 4, 12.84, 27, 10.7402, 2.0094, 51.4330, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 5, 3.63, 27, 2.3306, 0.9466, 12.9065, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 6, 17.11, 27, 12.0607, 3.4681, 54.2444, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 7, 10.48, 27, 8.9052, 1.6371, 45.1667, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 8, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 9, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 1, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 2, 5.52, 26, 4.9302, 0.8259, 29.0543, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 3, 17.27, 26, 11.9811, 3.5788, 54.0029, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 4, 42.07, 26, 19.8624, 11.9387, 79.5551, 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 5, 21.78, 26, 13.5862, 5.1100, 58.9983, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 6, 12.96, 26, 10.1391, 2.2831, 48.6705, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 7, 0.41, 26, 0.4329, 0.0456, 3.5464, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 8, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 9, 0.00, 26, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 2, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 5, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 6, 65.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 7, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 8, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.4.a', 'IM', NULL, 3.20, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 5, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 6, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 7, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 8, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 9, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 1, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 2, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 3, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 5, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 6, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 8, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 2, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 3, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 4, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 5, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 6, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 8, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.4.a', 'IM', NULL, 1.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.1', 'RL', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.1', 'RL', 2, 13.11, 40, 6.1933, 4.7803, 31.1818, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.1', 'RL', 3, 2.59, 40, 2.2562, 0.4346, 13.9559, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.1', 'RL', 4, 11.93, 40, 3.9781, 5.9260, 22.5625, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.1', 'RL', 5, 12.01, 40, 6.8408, 3.5571, 33.5790, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.1', 'RL', 6, 55.82, 40, 7.7423, 40.1071, 70.4548, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.1', 'RL', 7, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.1', 'RL', 8, 0.58, 40, 0.5823, 0.0754, 4.3087, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.1', 'RL', 9, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.1', 'RL', 10, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.1', 'RL', 11, 3.95, 40, 4.1403, 0.4515, 27.1950, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.1', 'RL', 12, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '2.D.4.a', 'IM', NULL, 3.21, 39, 0.2174, 2.7680, 3.6481, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.1', 'RW', 1, 7.41, 40, 3.3345, 2.9077, 17.6204, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.1', 'RW', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.1', 'RW', 3, 1.69, 40, 1.7776, 0.1955, 13.0502, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.1', 'RW', 4, 1.51, 40, 1.6033, 0.1747, 11.9103, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.1', 'RW', 5, 10.32, 40, 9.3547, 1.4692, 47.0555, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.1', 'RW', 6, 19.04, 40, 9.0486, 6.6901, 43.5324, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.1', 'RW', 7, 21.75, 40, 9.7936, 7.9856, 47.0939, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.1', 'RW', 8, 11.43, 40, 4.5358, 4.9520, 24.2057, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.1', 'RW', 9, 16.55, 40, 5.9909, 7.6192, 32.2904, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.1', 'RW', 10, 5.58, 40, 3.2856, 1.6453, 17.2626, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.1', 'RW', 11, 4.73, 40, 2.8988, 1.3318, 15.4266, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.2', 'PT', 1, 7.14, 40, 5.7998, 1.2923, 31.0923, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.2', 'PT', 2, 16.38, 40, 8.4920, 5.2911, 40.7041, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.2', 'PT', 3, 18.40, 40, 8.1744, 6.9714, 40.4124, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.2', 'PT', 4, 13.46, 40, 5.8148, 5.3609, 29.9178, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.2', 'PT', 5, 19.63, 40, 6.9295, 9.1280, 37.2574, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.2', 'PT', 6, 13.68, 40, 6.2220, 5.1793, 31.5120, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.2', 'PT', 7, 9.74, 40, 5.3421, 3.0572, 26.9460, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.2', 'PT', 8, 1.00, 40, 1.0393, 0.1225, 7.7495, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.2', 'PT', 9, 0.58, 40, 0.5823, 0.0754, 4.3087, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.3', 'OJ', 1, 7.14, 40, 5.7998, 1.2923, 31.0923, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.3', 'OJ', 2, 5.74, 40, 5.2697, 0.8425, 30.3916, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.3', 'OJ', 3, 13.34, 40, 6.7404, 4.5190, 33.3615, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.3', 'OJ', 4, 16.40, 40, 7.0913, 6.4474, 35.8343, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.3', 'OJ', 5, 36.97, 40, 12.0489, 17.0848, 62.5330, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.3', 'OJ', 6, 11.77, 40, 6.0180, 3.9691, 30.1073, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.3', 'OJ', 7, 7.64, 40, 3.8280, 2.6856, 19.8610, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.3', 'OJ', 8, 1.00, 40, 1.0393, 0.1225, 7.7495, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.3', 'OJ', 9, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '3.A.4.a', 'IM', NULL, 2.38, 39, 0.1897, 1.9978, 2.7660, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 1, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 2, 23.88, 16, 11.5827, 7.4658, 54.9566, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 3, 28.84, 16, 12.1747, 10.2724, 58.9372, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 4, 30.60, 16, 16.2880, 7.9156, 69.3357, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 5, 15.21, 16, 11.8482, 2.4669, 55.9735, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 6, 1.47, 16, 1.6119, 0.1393, 13.7768, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 7, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 8, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 9, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 10, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 11, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 12, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 1, 15.94, 16, 14.7023, 1.7964, 66.2846, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 2, 0.74, 16, 0.8060, 0.0704, 7.2285, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 3, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 4, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 5, 0.74, 16, 0.7960, 0.0725, 7.0364, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 6, 15.39, 16, 11.3793, 2.7475, 53.9484, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 7, 36.05, 16, 18.3309, 9.3808, 75.4280, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 8, 30.41, 16, 23.6964, 3.8626, 82.6185, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 9, 0.74, 16, 0.9023, 0.0532, 9.3559, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 10, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 11, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 1, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 2, 66.46, 16, 17.1021, 27.8595, 91.0455, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 3, 1.47, 16, 1.6119, 0.1393, 13.7768, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 4, 28.39, 16, 16.6229, 6.4895, 69.3725, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 5, 1.47, 16, 1.2184, 0.2482, 8.2211, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 6, 2.21, 16, 1.8938, 0.3463, 12.7774, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 7, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 8, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 9, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 1, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 2, 50.52, 16, 12.9546, 25.2783, 75.4985, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 3, 17.41, 16, 11.8957, 3.4895, 55.1441, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 4, 28.39, 16, 16.6229, 6.4895, 69.3725, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 5, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 6, 3.68, 16, 3.0836, 0.5936, 19.6226, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 7, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 8, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 9, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 2, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 5, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 6, 75.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 8, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.4.a', 'IM', NULL, 3.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 1, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 5, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 6, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 7, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 8, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 9, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 2, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 3, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 4, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 5, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 6, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 8, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 3, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 4, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 5, 40.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 6, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 7, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 8, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.4.a', 'IM', NULL, 1.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 1, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 2, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 3, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 4, 14.07, 33, 9.3999, 3.2495, 44.3789, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 5, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 6, 65.76, 33, 10.9428, 41.6465, 83.7889, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 7, 4.44, 33, 3.4910, 0.8625, 19.8889, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 8, 11.87, 33, 5.7719, 4.1968, 29.2998, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 9, 1.09, 33, 1.1052, 0.1352, 8.1889, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 10, 2.77, 33, 2.7046, 0.3670, 18.0538, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 11, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 12, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 1, 6.78, 32, 7.0086, 0.7514, 41.1178, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 2, 0.00, 32, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 3, 0.00, 32, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 4, 0.00, 32, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 5, 7.92, 32, 7.0778, 1.1761, 38.3612, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 6, 8.44, 32, 4.7994, 2.5315, 24.6508, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 7, 43.94, 32, 14.9082, 18.5715, 72.9216, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 8, 20.26, 32, 7.5793, 8.8895, 39.8109, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 9, 3.59, 32, 3.7555, 0.4070, 25.3752, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 10, 7.06, 32, 4.2148, 2.0059, 21.9709, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 11, 2.01, 32, 2.0368, 0.2495, 14.4389, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 1, 17.27, 32, 7.0785, 7.0656, 36.4454, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 2, 15.37, 32, 9.3402, 4.0326, 43.9944, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 3, 21.73, 32, 8.9550, 8.6648, 44.8278, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 4, 7.16, 32, 4.0008, 2.2079, 20.8360, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 5, 10.64, 32, 5.0530, 3.8713, 26.0350, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 6, 16.09, 32, 7.7447, 5.6185, 38.1876, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 7, 2.49, 32, 2.5051, 0.3098, 17.3249, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 8, 9.24, 32, 5.1826, 2.8089, 26.4194, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 9, 0.00, 32, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 1, 5.61, 32, 4.3689, 1.0912, 24.2338, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 2, 20.21, 32, 14.0317, 4.1173, 59.9040, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 3, 12.20, 32, 8.0699, 2.9005, 39.2444, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 4, 25.96, 32, 10.4764, 10.3460, 51.5921, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 5, 14.23, 32, 5.6880, 6.0294, 30.0326, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 6, 8.56, 32, 5.4858, 2.1951, 28.1045, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 7, 0.00, 32, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 8, 13.22, 32, 5.7940, 5.1612, 29.9114, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 9, 0.00, 32, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 1, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 2, 9.44, 17, 9.2782, 1.0327, 50.9987, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 3, 16.22, 17, 8.5317, 4.8667, 42.2871, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 4, 10.32, 17, 7.7771, 1.9011, 40.5939, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 5, 24.68, 17, 4.5121, 16.3820, 35.4104, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 6, 39.34, 17, 13.1933, 16.7267, 67.6761, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 7, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 8, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 10, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 11, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 12, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 1, 11.13, 17, 9.7340, 1.5294, 50.2238, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 2, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 3, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 4, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 5, 38.50, 17, 8.3969, 22.7873, 57.0353, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 6, 0.94, 17, 1.0256, 0.0920, 8.9198, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 7, 16.08, 17, 10.3396, 3.6363, 49.3012, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 8, 21.67, 17, 15.4738, 3.8491, 65.6458, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 9, 10.32, 17, 7.7771, 1.9011, 40.5939, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 10, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 11, 1.38, 17, 1.2169, 0.2079, 8.5408, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 1, 9.00, 17, 9.2097, 0.9044, 51.7473, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 2, 3.59, 17, 3.1232, 0.5485, 20.1265, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 3, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 4, 32.30, 17, 5.8452, 21.3011, 45.6739, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 5, 43.33, 17, 9.1266, 25.7981, 62.7006, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 6, 1.46, 17, 1.3382, 0.2061, 9.6167, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 7, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 8, 10.32, 17, 7.7771, 1.9011, 40.5939, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 1, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 2, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 3, 13.03, 17, 10.1238, 2.2057, 49.8871, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 4, 21.17, 17, 9.1563, 7.7434, 46.2180, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 5, 44.35, 17, 9.0794, 26.7618, 63.4821, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 6, 11.13, 17, 9.7340, 1.5294, 50.2238, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 7, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 8, 10.32, 17, 7.7771, 1.9011, 40.5939, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 9, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 2, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 3, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 4, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 5, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 6, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 7, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 8, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.4.a', 'IM', NULL, 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 1, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 2, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 4, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 5, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 6, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 7, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 8, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 9, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 2, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 3, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 4, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 5, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 6, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 8, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 3, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 4, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 5, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 6, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 7, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 8, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.4.a', 'IM', NULL, 2.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 5, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 6, 80.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 8, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 12, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.4.a', 'IM', NULL, 2.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 5, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 6, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 7, 55.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 8, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 1, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 2, 40.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 4, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 5, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 6, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 8, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 2, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 3, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 4, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 5, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 8, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.4.a', 'IM', NULL, 1.58, 19, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 2, 45.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 3, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 5, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 6, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 8, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 1, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 5, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 6, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 7, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 8, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 9, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 10, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 11, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 1, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 2, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 3, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 4, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 5, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 6, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 8, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 9, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 1, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 2, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 3, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 4, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 5, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 6, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 8, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 9, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 2, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 6, 81.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 8, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.4.a', 'IM', NULL, 2.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 1, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 5, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 6, 27.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 7, 50.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 8, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 10, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 11, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 1, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 2, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 3, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 4, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 5, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 6, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 7, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 8, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 2, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 4, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 5, 27.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 6, 36.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 7, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 8, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.4.a', 'IM', NULL, 2.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 1, 0.00, 41, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 2, 13.52, 41, 7.1128, 4.3690, 34.8357, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 3, 1.31, 41, 1.3491, 0.1598, 9.8803, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 4, 4.82, 41, 3.1990, 1.2228, 17.1680, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 5, 7.16, 41, 4.2700, 2.0639, 22.0258, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 6, 46.59, 41, 14.8309, 20.7341, 74.4236, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 7, 1.69, 41, 1.7422, 0.2065, 12.5116, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 8, 24.91, 41, 19.3996, 3.9175, 72.9625, 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 9, 0.00, 41, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 10, 0.00, 41, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 11, 0.00, 41, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 12, 0.00, 41, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.4.a', 'IM', NULL, 1.93, 40, 0.1089, 1.7120, 2.1524, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 1, 1.62, 40, 1.6738, 0.1955, 12.1263, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 3, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 4, 2.68, 40, 2.6885, 0.3414, 18.1311, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 5, 1.96, 40, 1.8059, 0.2967, 11.8120, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 6, 30.02, 40, 11.3097, 12.6135, 56.0317, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 7, 7.77, 40, 3.8938, 2.7269, 20.1808, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 8, 50.88, 40, 15.5770, 22.6946, 78.5116, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 9, 4.60, 40, 3.2584, 1.0598, 17.8027, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 10, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 11, 0.49, 40, 0.5149, 0.0590, 3.9816, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 1, 32.29, 40, 18.1692, 8.1556, 71.9188, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 2, 8.32, 40, 4.5061, 2.6708, 23.0635, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 3, 13.99, 40, 7.5636, 4.3602, 36.7091, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 4, 8.00, 40, 4.3694, 2.5512, 22.4168, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 5, 7.60, 40, 4.0989, 2.4666, 21.1257, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 6, 20.10, 40, 9.2823, 7.2450, 44.7425, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 7, 9.71, 40, 9.1835, 1.2748, 47.2309, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 8, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 9, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 1, 1.36, 40, 1.4108, 0.1650, 10.3506, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 2, 13.78, 40, 6.4348, 5.0760, 32.3413, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 3, 11.89, 40, 7.1171, 3.3030, 34.7791, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 4, 0.73, 40, 0.5893, 0.1425, 3.6655, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 5, 50.13, 40, 15.5953, 22.1545, 78.0209, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 6, 8.63, 40, 4.6174, 2.8105, 23.5910, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 7, 12.98, 40, 9.5512, 2.6247, 45.2076, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 8, 0.49, 40, 0.5149, 0.0590, 3.9816, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 9, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.4.a', 'IM', NULL, 1.91, 39, 0.3189, 1.2608, 2.5521, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 1, 48.00, 13, 21.8770, 12.0292, 86.1726, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 2, 42.83, 13, 22.3450, 9.3020, 84.5457, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 3, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 4, 8.90, 13, 9.1269, 0.8325, 53.1771, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 5, 0.14, 13, 0.1607, 0.0110, 1.7171, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 6, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 7, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 8, 0.14, 13, 0.1507, 0.0128, 1.4715, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 9, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 10, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 11, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 12, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 1, 18.06, 13, 16.6385, 1.8661, 71.8606, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 2, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 3, 1.38, 13, 1.2720, 0.1827, 9.6776, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 4, 3.83, 13, 4.0406, 0.3631, 30.3091, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 5, 24.37, 13, 20.4471, 2.7936, 78.3237, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 6, 33.54, 13, 21.2292, 5.9600, 80.0791, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 7, 18.68, 13, 16.7281, 2.0427, 71.6750, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 8, 0.14, 13, 0.1507, 0.0128, 1.4715, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 9, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 10, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 11, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 1, 46.65, 13, 22.2083, 11.1231, 85.9385, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 2, 0.14, 13, 0.1507, 0.0128, 1.4707, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 3, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 4, 1.10, 13, 1.1938, 0.1031, 10.7809, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 5, 33.41, 13, 21.1791, 5.9289, 79.9695, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 6, 18.70, 13, 16.7166, 2.0517, 71.6301, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 7, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 8, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 9, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 1, 21.89, 13, 17.0469, 3.0921, 71.0998, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 2, 1.38, 13, 1.2720, 0.1827, 9.6776, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 3, 24.63, 13, 20.3797, 2.9019, 78.1344, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 4, 0.14, 13, 0.1507, 0.0128, 1.4715, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 5, 33.41, 13, 21.1791, 5.9289, 79.9695, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 6, 0.14, 13, 0.1607, 0.0110, 1.7171, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 7, 18.42, 13, 16.7010, 1.9656, 71.7754, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 8, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 9, 0.00, 13, 0.0000, NULL, NULL, 'Y', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 1, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 2, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 3, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 4, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 5, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 6, 33.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 7, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 8, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 10, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 11, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 12, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.4.a', 'IM', NULL, 2.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 3, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 4, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 5, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 6, 33.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 7, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 8, 28.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 10, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 11, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 1, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 2, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 3, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 4, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 5, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 6, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 8, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 2, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 3, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 4, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 5, 42.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 6, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 8, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 9, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.4.a', 'IM', NULL, 2.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 2, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 3, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 4, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 5, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 6, 75.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 8, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 1, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 5, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 6, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 7, 25.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 8, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 9, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 10, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 11, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 1, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 2, 25.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 3, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 4, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 5, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 6, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 7, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 8, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 1, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 2, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 3, 37.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 4, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 5, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 6, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 8, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 1, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 2, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 3, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 4, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 5, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 6, 73.91, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 8, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 9, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 10, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 11, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 12, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.4.a', 'IM', NULL, 2.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 1, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 2, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 3, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 4, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 5, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 6, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 7, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 8, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 9, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 10, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 11, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 1, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 2, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 3, 39.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 4, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 5, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 6, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 8, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 9, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 1, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 2, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 3, 34.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 4, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 5, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 7, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 8, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 9, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.4.a', 'IM', NULL, 1.91, 23, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 2, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 3, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 4, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 5, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 6, 63.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 8, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 9, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.4.a', 'IM', NULL, 2.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 4, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 5, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 6, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 7, 28.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 8, 38.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 9, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 10, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 11, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 1, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 2, 36.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 3, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 4, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 5, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 6, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 7, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 8, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 9, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 1, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE(