/*! START TRANSACTION */;
CREATE TABLE skills (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(7,4),
  lower_ci_bound DECIMAL(7,4),
  upper_ci_bound DECIMAL(7,4),
  recommend_suppress CHARACTER(1),
  not_relevant CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));
/*! COMMIT */;
/*! START TRANSACTION */;

INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.a', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.b', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.c', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.c', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.d', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.d', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.e', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.e', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.f', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.f', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.a', 'IM', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.a', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.b', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.d', 'LV', 5.25, 8, 0.2500, 4.7600, 5.7400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.b', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.b', 'LV', 4.88, 8, 0.2266, 4.4309, 5.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.c', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.c', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.d', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.d', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.e', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.f', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.f', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.2.i', 'IM', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.2.i', 'LV', 4.88, 8, 0.1250, 4.6300, 5.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.a', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.b', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.b', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.c', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.c', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.e', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.e', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.g', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.g', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.h', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.h', 'LV', 1.38, 8, 0.2631, 0.8594, 1.8906, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.k', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.k', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.m', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.m', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.4.e', 'IM', 4.75, 8, 0.1637, 4.4292, 5.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.4.e', 'LV', 5.38, 8, 0.2631, 4.8594, 5.8906, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.4.g', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.4.g', 'LV', 5.12, 8, 0.2266, 4.6809, 5.5691, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.4.h', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.4.h', 'LV', 5.00, 8, 0.1890, 4.6296, 5.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.a', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.b', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.b', 'LV', 5.25, 8, 0.2500, 4.7600, 5.7400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.c', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.c', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.d', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.d', 'LV', 5.25, 8, 0.2500, 4.7600, 5.7400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.c', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.c', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.e', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.f', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.f', 'LV', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.c', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.c', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.d', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.e', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.f', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.f', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.2.i', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.2.i', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.a', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.a', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.b', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.b', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.c', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.c', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.e', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.e', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.g', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.g', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.h', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.h', 'LV', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.k', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.k', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.m', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.m', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.4.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.4.e', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.4.g', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.4.g', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.4.h', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.4.h', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.a', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.b', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.b', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.c', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.c', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.d', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.c', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.c', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.e', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.e', 'LV', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.f', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.f', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.c', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.b', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.d', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.d', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.e', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.f', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.f', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.2.i', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.2.i', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.a', 'IM', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.a', 'LV', 2.38, 8, 0.3750, 1.6400, 3.1100, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.b', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.b', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.e', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.e', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.g', 'IM', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.g', 'LV', 2.12, 8, 0.3504, 1.4383, 2.8117, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.h', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.h', 'LV', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.k', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.k', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.m', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.m', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.4.e', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.4.e', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.4.g', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.4.g', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.4.h', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.4.h', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.a', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.b', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.b', 'LV', 3.38, 8, 0.3239, 2.7402, 4.0098, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.c', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.c', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.d', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.b', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.c', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.e', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.f', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.f', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.b', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.c', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.d', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.d', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.c', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.e', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.e', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.f', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.f', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.2.i', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.2.i', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.a', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.a', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.b', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.b', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.c', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.c', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.e', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.e', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.g', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.g', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.h', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.h', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.k', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.k', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.m', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.m', 'LV', 1.00, 8, 0.3273, 0.3584, 1.6416, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.4.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.4.e', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.4.g', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.4.g', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.4.h', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.4.h', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.b', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.c', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.c', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.c', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.e', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.f', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.f', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.d', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.c', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.e', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.f', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.f', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.2.i', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.2.i', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.a', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.b', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.b', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.e', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.e', 'LV', 1.25, 8, 0.2500, 0.7600, 1.7400, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.g', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.g', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.h', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.h', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.k', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.k', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.m', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.m', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.4.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.4.e', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.4.g', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.4.g', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.4.h', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.4.h', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.b', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.c', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.c', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.d', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.f', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.f', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.d', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.c', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.f', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.f', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.2.i', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.2.i', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.a', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.a', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.b', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.b', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.e', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.e', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.g', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.g', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.h', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.h', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.k', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.k', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.m', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.m', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.4.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.4.e', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.4.g', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.4.g', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.4.h', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.4.h', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.b', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.c', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.c', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.1.b', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.1.c', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.1.c', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.1.d', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.1.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.1.e', 'IM', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.1.e', 'LV', 2.75, 8, 0.3134, 2.1358, 3.3642, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.1.f', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.1.f', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.2.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.2.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.2.b', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.2.b', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.2.c', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.2.c', 'LV', 2.75, 8, 0.3134, 2.1358, 3.3642, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.2.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.A.2.d', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.1.a', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.1.b', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.1.c', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.1.c', 'LV', 3.50, 8, 0.3273, 2.8584, 4.1416, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.1.d', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.1.d', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.1.e', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.1.e', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.1.f', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.1.f', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.2.i', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.2.i', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.a', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.a', 'LV', 1.88, 8, 0.3981, 1.0947, 2.6553, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.b', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.b', 'LV', 0.88, 8, 0.3504, 0.1883, 1.5617, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.e', 'IM', 1.88, 8, 0.3504, 1.1883, 2.5617, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.e', 'LV', 1.00, 8, 0.3780, 0.2592, 1.7408, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.g', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.g', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.h', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.h', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.k', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.k', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.m', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.3.m', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.4.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.4.e', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.4.g', 'IM', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.4.g', 'LV', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.4.h', 'IM', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.4.h', 'LV', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.5.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.5.a', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.5.b', 'IM', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.5.b', 'LV', 3.62, 8, 0.3750, 2.8900, 4.3600, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.5.c', 'IM', 2.62, 8, 0.3239, 1.9902, 3.2598, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.5.c', 'LV', 2.38, 8, 0.4199, 1.5519, 3.1981, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.5.d', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '2.B.5.d', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.e', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.e', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.f', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.f', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.b', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.b', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.c', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.d', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.d', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.a', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.c', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.d', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.e', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.f', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.f', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.2.i', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.2.i', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.a', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.a', 'LV', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.b', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.b', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.c', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.c', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.e', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.e', 'LV', 0.62, 8, 0.3239, 0.0000, 1.2598, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.g', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.g', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.h', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.h', 'LV', 1.00, 8, 0.3273, 0.3584, 1.6416, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.k', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.k', 'LV', 1.25, 8, 0.2500, 0.7600, 1.7400, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.m', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.m', 'LV', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.4.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.4.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.4.g', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.4.g', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.4.h', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.4.h', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.b', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.b', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.c', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.c', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.d', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.1.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.1.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.1.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.1.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.1.e', 'IM', 2.75, 8, 0.3134, 2.1358, 3.3642, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.1.e', 'LV', 2.75, 8, 0.3134, 2.1358, 3.3642, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.1.f', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.1.f', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.2.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.2.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.2.b', 'IM', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.2.b', 'LV', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.2.c', 'IM', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.2.c', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.2.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.A.2.d', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.1.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.1.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.1.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.1.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.1.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.1.c', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.1.d', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.1.d', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.1.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.1.e', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.1.f', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.1.f', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.2.i', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.2.i', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.a', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.a', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.b', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.b', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.c', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.c', 'LV', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.d', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.d', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.e', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.e', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.g', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.g', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.h', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.h', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.j', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.j', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.k', 'IM', 2.62, 8, 0.2631, 2.1094, 3.1406, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.k', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.l', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.l', 'LV', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.m', 'IM', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.3.m', 'LV', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.4.e', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.4.e', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.4.g', 'IM', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.4.g', 'LV', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.4.h', 'IM', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.4.h', 'LV', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.5.a', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.5.b', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.5.b', 'LV', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.5.c', 'IM', 2.75, 8, 0.3134, 2.1358, 3.3642, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.5.c', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.5.d', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.B.5.d', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.1.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.1.a', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.1.b', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.1.b', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.1.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.1.c', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.1.d', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.1.d', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.1.e', 'IM', 2.50, 8, 0.3273, 1.8584, 3.1416, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.1.e', 'LV', 2.38, 8, 0.4605, 1.4724, 3.2776, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.1.f', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.1.f', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.2.a', 'IM', 4.25, 8, 0.2500, 3.7600, 4.7400, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.2.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.2.b', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.2.b', 'LV', 3.62, 8, 0.3239, 2.9902, 4.2598, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.2.c', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.2.c', 'LV', 3.50, 8, 0.3273, 2.8584, 4.1416, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.2.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.A.2.d', 'LV', 4.62, 8, 0.2631, 4.1094, 5.1406, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.1.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.1.b', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.1.b', 'LV', 4.12, 8, 0.3504, 3.4383, 4.8117, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.1.c', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.1.c', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.1.d', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.1.d', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.1.e', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.1.e', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.1.f', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.1.f', 'LV', 3.25, 8, 0.4119, 2.4427, 4.0573, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.2.i', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.2.i', 'LV', 4.00, 8, 0.3780, 3.2592, 4.7408, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.a', 'IM', 2.25, 8, 0.3660, 1.5327, 2.9673, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.a', 'LV', 2.00, 8, 0.6547, 0.7169, 3.2831, 'Y', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.b', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.b', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.c', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.c', 'LV', 1.50, 8, 0.2673, 0.9762, 2.0238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.e', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.e', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.g', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.g', 'LV', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.h', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.h', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.j', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.j', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.k', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.k', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.l', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.l', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.m', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.3.m', 'LV', 2.38, 8, 0.3750, 1.6400, 3.1100, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.4.e', 'IM', 4.12, 8, 0.2950, 3.5467, 4.7033, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.4.e', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.4.g', 'IM', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.4.g', 'LV', 3.12, 8, 0.3504, 2.4383, 3.8117, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.4.h', 'IM', 3.38, 8, 0.3750, 2.6400, 4.1100, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.4.h', 'LV', 3.25, 8, 0.3660, 2.5327, 3.9673, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.5.a', 'IM', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.5.b', 'IM', 3.62, 8, 0.3750, 2.8900, 4.3600, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.5.b', 'LV', 3.62, 8, 0.3750, 2.8900, 4.3600, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.5.c', 'IM', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.5.c', 'LV', 3.12, 8, 0.3504, 2.4383, 3.8117, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.5.d', 'IM', 3.75, 8, 0.3134, 3.1358, 4.3642, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '2.B.5.d', 'LV', 3.75, 8, 0.3660, 3.0327, 4.4673, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.f', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.f', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.b', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.b', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.d', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.b', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.d', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.d', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.f', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.f', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.2.i', 'IM', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.2.i', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.a', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.a', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.b', 'IM', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.b', 'LV', 2.00, 8, 0.3273, 1.3584, 2.6416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.c', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.c', 'LV', 2.00, 8, 0.5000, 1.0200, 2.9800, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.e', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.e', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.g', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.g', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.h', 'IM', 2.00, 8, 0.2673, 1.4762, 2.5238, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.h', 'LV', 1.62, 8, 0.4199, 0.8019, 2.4481, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.j', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.j', 'LV', 0.62, 8, 0.3239, 0.0000, 1.2598, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.k', 'IM', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.k', 'LV', 2.50, 8, 0.4629, 1.5927, 3.4073, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.l', 'IM', 1.50, 8, 0.2673, 1.0000, 2.0238, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.l', 'LV', 0.75, 8, 0.4119, 0.0000, 1.5573, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.m', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.m', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.4.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.4.e', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.4.g', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.4.g', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.4.h', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.4.h', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.a', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.b', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.b', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.c', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.c', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.a', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.a', 'LV', 4.38, 8, 0.2631, 3.8594, 4.8906, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.b', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.b', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.d', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.d', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.e', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.e', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.f', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.f', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.b', 'LV', 4.00, 8, 0.2673, 3.4762, 4.5238, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.c', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.c', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.d', 'IM', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.d', 'LV', 4.12, 8, 0.3504, 3.4383, 4.8117, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.b', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.b', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.e', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.e', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.f', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.f', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.2.i', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.2.i', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.a', 'IM', 1.75, 8, 0.3660, 1.0327, 2.4673, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.a', 'LV', 1.12, 8, 0.5154, 0.1148, 2.1352, 'Y', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.b', 'IM', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.b', 'LV', 0.88, 8, 0.3981, 0.0947, 1.6553, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.c', 'IM', 1.25, 8, 0.2500, 1.0000, 1.7400, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.c', 'LV', 0.38, 8, 0.3750, 0.0000, 1.1100, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.e', 'IM', 1.88, 8, 0.2950, 1.2967, 2.4533, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.e', 'LV', 1.62, 8, 0.5957, 0.4573, 2.7927, 'Y', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.g', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.g', 'LV', 1.38, 8, 0.3750, 0.6400, 2.1100, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.h', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.h', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.k', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.k', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.m', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.m', 'LV', 1.50, 8, 0.4226, 0.6717, 2.3283, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.4.e', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.4.e', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.4.g', 'IM', 3.00, 8, 0.3273, 2.3584, 3.6416, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.4.g', 'LV', 3.25, 8, 0.5261, 2.2188, 4.2812, 'Y', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.4.h', 'IM', 3.00, 8, 0.3780, 2.2592, 3.7408, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.4.h', 'LV', 3.25, 8, 0.5590, 2.1543, 4.3457, 'Y', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.b', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.b', 'LV', 3.62, 8, 0.3750, 2.8900, 4.3600, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.c', 'IM', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.c', 'LV', 2.12, 8, 0.3981, 1.3447, 2.9053, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.d', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.d', 'LV', 4.00, 8, 0.2673, 3.4762, 4.5238, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.b', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.c', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.d', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.e', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.f', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.f', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.a', 'LV', 4.75, 8, 0.2500, 4.2600, 5.2400, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.b', 'LV', 4.25, 8, 0.3134, 3.6358, 4.8642, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.c', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.d', 'LV', 4.50, 8, 0.2673, 3.9762, 5.0238, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.a', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.b', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.b', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.c', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.d', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.e', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.e', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.f', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.f', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.2.i', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.2.i', 'LV', 4.38, 8, 0.2631, 3.8594, 4.8906, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.a', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.a', 'LV', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.b', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.b', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.e', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.e', 'LV', 1.00, 8, 0.3273, 0.3584, 1.6416, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.g', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.g', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.h', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.h', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.k', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.k', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.m', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.m', 'LV', 1.38, 8, 0.3750, 0.6400, 2.1100, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.4.e', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.4.e', 'LV', 4.62, 8, 0.2631, 4.1094, 5.1406, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.4.g', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.4.g', 'LV', 4.25, 8, 0.3134, 3.6358, 4.8642, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.4.h', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.4.h', 'LV', 4.25, 8, 0.3134, 3.6358, 4.8642, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.a', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.a', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.b', 'LV', 5.00, 8, 0.1890, 4.6296, 5.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.c', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.c', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.d', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.a', 'IM', 4.00, 8, 0.2673, 3.4762, 4.5238, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.b', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.c', 'IM', 3.62, 8, 0.3239, 2.9902, 4.2598, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.c', 'LV', 3.88, 8, 0.2950, 3.2967, 4.4533, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.d', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.d', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.e', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.e', 'LV', 3.62, 8, 0.3239, 2.9902, 4.2598, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.f', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.f', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.a', 'IM', 4.00, 8, 0.3273, 3.3584, 4.6416, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.a', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.b', 'IM', 3.75, 8, 0.3134, 3.1358, 4.3642, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.b', 'LV', 3.88, 8, 0.2950, 3.2967, 4.4533, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.c', 'IM', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.c', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.d', 'IM', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.d', 'LV', 4.00, 8, 0.3273, 3.3584, 4.6416, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.a', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.a', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.b', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.b', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.c', 'LV', 3.50, 8, 0.3273, 2.8584, 4.1416, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.d', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.d', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.e', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.f', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.f', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.2.i', 'IM', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.2.i', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.a', 'IM', 2.00, 8, 0.4226, 1.1717, 2.8283, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.a', 'LV', 1.62, 8, 0.6797, 0.2927, 2.9573, 'Y', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.b', 'IM', 1.88, 8, 0.2950, 1.2967, 2.4533, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.b', 'LV', 1.38, 8, 0.5324, 0.3314, 2.4186, 'Y', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.e', 'IM', 1.75, 8, 0.3660, 1.0327, 2.4673, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.e', 'LV', 1.12, 8, 0.6105, 0.0000, 2.3217, 'Y', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.g', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.g', 'LV', 1.50, 8, 0.4629, 0.5927, 2.4073, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.h', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.h', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.k', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.k', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.m', 'IM', 1.50, 8, 0.3780, 1.0000, 2.2408, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.m', 'LV', 0.75, 8, 0.5261, 0.0000, 1.7812, 'Y', 'Y', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.4.e', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.4.e', 'LV', 4.25, 8, 0.2500, 3.7600, 4.7400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.4.g', 'IM', 3.38, 8, 0.3750, 2.6400, 4.1100, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.4.g', 'LV', 3.75, 8, 0.4532, 2.8618, 4.6382, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.4.h', 'IM', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.4.h', 'LV', 3.75, 8, 0.3660, 3.0327, 4.4673, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.a', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.b', 'IM', 2.75, 8, 0.4119, 1.9427, 3.5573, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.b', 'LV', 3.00, 8, 0.6547, 1.7169, 4.2831, 'Y', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.c', 'IM', 2.25, 8, 0.4119, 1.4427, 3.0573, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.c', 'LV', 2.12, 8, 0.5806, 0.9871, 3.2629, 'Y', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.d', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.d', 'LV', 3.38, 8, 0.3239, 2.7402, 4.0098, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.e', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.e', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.f', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.f', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.d', 'LV', 4.88, 8, 0.1250, 4.6300, 5.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.c', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.d', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.e', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.f', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.f', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.2.i', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.2.i', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.a', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.a', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.b', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.b', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.c', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.c', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.e', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.e', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.g', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.g', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.h', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.h', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.j', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.j', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.k', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.k', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.l', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.l', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.m', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.m', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.4.e', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.4.e', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.4.g', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.4.g', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.4.h', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.4.h', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.b', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.d', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.c', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.c', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.e', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.f', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.f', 'LV', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.c', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.d', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.a', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.b', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.d', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.d', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.e', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.f', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.f', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.2.i', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.2.i', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.a', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.a', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.b', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.b', 'LV', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.c', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.c', 'LV', 1.38, 8, 0.2631, 0.8594, 1.8906, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.e', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.e', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.g', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.g', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.h', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.h', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.j', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.j', 'LV', 1.50, 8, 0.3780, 0.7592, 2.2408, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.k', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.k', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.l', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.l', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.m', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.m', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.4.e', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.4.e', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.4.g', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.4.g', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.4.h', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.4.h', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.b', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.b', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.c', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.c', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.d', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.d', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.b', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.b', 'LV', 3.62, 8, 0.3239, 2.9902, 4.2598, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.d', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.e', 'LV', 3.75, 8, 0.3134, 3.1358, 4.3642, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.f', 'IM', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.f', 'LV', 2.50, 8, 0.5669, 1.3888, 3.6112, 'Y', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.a', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.b', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.c', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.d', 'LV', 4.38, 8, 0.3750, 3.6400, 5.1100, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.b', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.c', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.d', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.d', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.e', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.f', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.f', 'LV', 3.00, 8, 0.4226, 2.1717, 3.8283, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.2.i', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.2.i', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.a', 'IM', 2.00, 8, 0.3273, 1.3584, 2.6416, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.a', 'LV', 2.38, 8, 0.7304, 0.9434, 3.8066, 'Y', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.b', 'IM', 2.00, 8, 0.2673, 1.4762, 2.5238, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.b', 'LV', 1.88, 8, 0.5806, 0.7371, 3.0129, 'Y', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.c', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.c', 'LV', 2.62, 8, 0.3239, 1.9902, 3.2598, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.e', 'IM', 1.88, 8, 0.2950, 1.2967, 2.4533, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.e', 'LV', 1.25, 8, 0.4532, 0.3618, 2.1382, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.g', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.g', 'LV', 3.50, 8, 0.4226, 2.6717, 4.3283, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.h', 'IM', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.h', 'LV', 2.88, 8, 0.5154, 1.8648, 3.8852, 'Y', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.j', 'IM', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.j', 'LV', 2.75, 8, 0.5590, 1.6543, 3.8457, 'Y', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.k', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.k', 'LV', 3.12, 8, 0.3981, 2.3447, 3.9053, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.l', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.l', 'LV', 3.00, 8, 0.5000, 2.0200, 3.9800, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.m', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.m', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.4.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.4.e', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.4.g', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.4.g', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.4.h', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.4.h', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.b', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.b', 'LV', 3.75, 8, 0.3660, 3.0327, 4.4673, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.c', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.c', 'LV', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.d', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.a', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.a', 'LV', 4.00, 8, 0.2673, 3.4762, 4.5238, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.b', 'IM', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.b', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.c', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.d', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.d', 'LV', 4.00, 8, 0.2673, 3.4762, 4.5238, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.e', 'IM', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.e', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.f', 'IM', 3.00, 8, 0.3273, 2.3584, 3.6416, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.f', 'LV', 3.50, 8, 0.3780, 2.7592, 4.2408, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.a', 'LV', 3.88, 8, 0.2950, 3.2967, 4.4533, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.b', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.b', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.d', 'IM', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.d', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.a', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.a', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.b', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.c', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.d', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.d', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.e', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.f', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.f', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.2.i', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.2.i', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.a', 'IM', 2.12, 8, 0.3504, 1.4383, 2.8117, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.a', 'LV', 2.00, 8, 0.6268, 0.7715, 3.2285, 'Y', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.b', 'IM', 1.88, 8, 0.2950, 1.2967, 2.4533, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.b', 'LV', 1.50, 8, 0.5345, 0.4523, 2.5477, 'Y', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.c', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.c', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.e', 'IM', 2.12, 8, 0.2950, 1.5467, 2.7033, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.e', 'LV', 1.62, 8, 0.4978, 0.6494, 2.6006, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.g', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.g', 'LV', 3.50, 8, 0.3273, 2.8584, 4.1416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.h', 'IM', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.h', 'LV', 3.38, 8, 0.3239, 2.7402, 4.0098, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.j', 'IM', 1.50, 8, 0.3780, 1.0000, 2.2408, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.j', 'LV', 0.75, 8, 0.5261, 0.0000, 1.7812, 'Y', 'Y', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.k', 'IM', 2.25, 8, 0.3134, 1.6358, 2.8642, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.k', 'LV', 2.00, 8, 0.4226, 1.1717, 2.8283, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.l', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.l', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.m', 'IM', 2.62, 8, 0.2631, 2.1094, 3.1406, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.m', 'LV', 3.12, 8, 0.3504, 2.4383, 3.8117, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.4.e', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.4.e', 'LV', 3.88, 8, 0.3504, 3.1883, 4.5617, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.4.g', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.4.g', 'LV', 3.50, 8, 0.3273, 2.8584, 4.1416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.4.h', 'IM', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.4.h', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.a', 'LV', 3.75, 8, 0.3134, 3.1358, 4.3642, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.b', 'IM', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.b', 'LV', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.c', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.c', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.d', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.d', 'LV', 3.62, 8, 0.3239, 2.9902, 4.2598, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.e', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.f', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.f', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.b', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.b', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.c', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.c', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.d', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.a', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.c', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.c', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.d', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.d', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.e', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.f', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.f', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.2.i', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.2.i', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.a', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.a', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.b', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.b', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.c', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.c', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.e', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.e', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.g', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.g', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.h', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.h', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.j', 'IM', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.j', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.k', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.k', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.l', 'IM', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.l', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.m', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.m', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.4.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.4.e', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.4.g', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.4.g', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.4.h', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.4.h', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.b', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.a', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.b', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.c', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.c', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.d', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.e', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.e', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.f', 'IM', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.f', 'LV', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.d', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.a', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.a', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.b', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.d', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.d', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.e', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.f', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.f', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.2.i', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.2.i', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.a', 'IM', 2.12, 8, 0.3981, 1.3447, 2.9053, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.a', 'LV', 2.00, 8, 0.6547, 0.7169, 3.2831, 'Y', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.b', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.b', 'LV', 1.38, 8, 0.3750, 0.6400, 2.1100, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.c', 'IM', 2.12, 8, 0.2950, 1.5467, 2.7033, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.c', 'LV', 1.88, 8, 0.4407, 1.0113, 2.7387, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.d', 'IM', 1.25, 8, 0.2500, 1.0000, 1.7400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.d', 'LV', 0.38, 8, 0.3750, 0.0000, 1.1100, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.e', 'IM', 2.12, 8, 0.3504, 1.4383, 2.8117, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.e', 'LV', 1.38, 8, 0.4199, 0.5519, 2.1981, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.g', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.g', 'LV', 3.62, 8, 0.3239, 2.9902, 4.2598, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.h', 'IM', 3.25, 8, 0.3660, 2.5327, 3.9673, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.h', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.j', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.j', 'LV', 2.62, 8, 0.3239, 1.9902, 3.2598, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.k', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.k', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.l', 'IM', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.l', 'LV', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.m', 'IM', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.m', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.4.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.4.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.4.g', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.4.g', 'LV', 3.38, 8, 0.3750, 2.6400, 4.1100, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.4.h', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.4.h', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.b', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.b', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.c', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.c', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.d', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.c', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.f', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.f', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.b', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.c', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.e', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.f', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.f', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.2.i', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.2.i', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.a', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.a', 'LV', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.b', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.b', 'LV', 1.38, 8, 0.2631, 0.8594, 1.8906, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.e', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.e', 'LV', 1.25, 8, 0.2500, 0.7600, 1.7400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.g', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.g', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.h', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.h', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.k', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.k', 'LV', 1.12, 8, 0.1250, 0.8800, 1.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.m', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.m', 'LV', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.4.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.4.e', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.4.g', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.4.g', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.4.h', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.4.h', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.b', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.b', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.c', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.e', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.e', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.f', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.f', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.c', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.d', 'LV', 3.75, 8, 0.3134, 3.1358, 4.3642, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.a', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.a', 'LV', 3.38, 8, 0.3239, 2.7402, 4.0098, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.b', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.c', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.d', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.e', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.e', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.f', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.f', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.2.i', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.2.i', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.a', 'IM', 2.12, 8, 0.3981, 1.3447, 2.9053, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.a', 'LV', 1.88, 8, 0.6105, 0.6783, 3.0717, 'Y', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.b', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.b', 'LV', 1.12, 8, 0.3981, 0.3447, 1.9053, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.c', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.c', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.d', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.d', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.e', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.e', 'LV', 1.12, 8, 0.3981, 0.3447, 1.9053, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.g', 'IM', 2.62, 8, 0.2631, 2.1094, 3.1406, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.g', 'LV', 2.50, 8, 0.3273, 1.8584, 3.1416, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.h', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.h', 'LV', 1.62, 8, 0.3239, 0.9902, 2.2598, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.j', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.j', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.k', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.k', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.m', 'IM', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.m', 'LV', 2.25, 8, 0.4119, 1.4427, 3.0573, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.4.e', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.4.e', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.4.g', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.4.g', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.4.h', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.4.h', 'LV', 3.50, 8, 0.3273, 2.8584, 4.1416, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.b', 'IM', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.b', 'LV', 3.12, 8, 0.5154, 2.1148, 4.1352, 'Y', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.c', 'IM', 3.00, 8, 0.3273, 2.3584, 3.6416, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.c', 'LV', 3.00, 8, 0.5000, 2.0200, 3.9800, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.d', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.d', 'LV', 3.38, 8, 0.4199, 2.5519, 4.1981, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.c', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.e', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.e', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.f', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.f', 'LV', 0.38, 8, 0.3750, 0.0000, 1.1100, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.a', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.c', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.e', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.f', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.f', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.2.i', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.2.i', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.a', 'IM', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.a', 'LV', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.b', 'IM', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.b', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.e', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.e', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.g', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.g', 'LV', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.h', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.h', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.k', 'IM', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.k', 'LV', 0.88, 8, 0.3981, 0.0947, 1.6553, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.m', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.m', 'LV', 1.62, 8, 0.3239, 0.9902, 2.2598, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.4.e', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.4.e', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.4.g', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.4.g', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.4.h', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.4.h', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.b', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.b', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.d', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.c', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.c', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.e', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.e', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.f', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.f', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.a', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.b', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.c', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.d', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.d', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.b', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.b', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.c', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.d', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.f', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.f', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.2.i', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.2.i', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.a', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.a', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.b', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.b', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.e', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.e', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.g', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.g', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.h', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.h', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.k', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.k', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.m', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.m', 'LV', 0.88, 8, 0.3504, 0.1883, 1.5617, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.4.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.4.e', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.4.g', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.4.g', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.4.h', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.4.h', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.b', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.c', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.c', 'LV', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.d', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.a', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.a', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.b', 'IM', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.c', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.d', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.e', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.f', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.f', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.c', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.b', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.b', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.c', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.e', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.f', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.f', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.2.i', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.2.i', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.a', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.a', 'LV', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.b', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.b', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.e', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.e', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.g', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.g', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.h', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.h', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.k', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.k', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.m', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.m', 'LV', 1.00, 8, 0.3273, 0.3584, 1.6416, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.4.e', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.4.e', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.4.g', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.4.g', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.4.h', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.4.h', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.b', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.b', 'LV', 4.00, 8, 0.2673, 3.4762, 4.5238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.c', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.c', 'LV', 2.62, 8, 0.2631, 2.1094, 3.1406, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.d', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.d', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.c', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.c', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.d', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.e', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.e', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.f', 'IM', 1.50, 8, 0.2673, 1.0000, 2.0238, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.f', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.b', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.c', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.c', 'LV', 5.25, 8, 0.1637, 4.9292, 5.5708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.d', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.d', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.d', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.e', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.e', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.f', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.f', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.2.i', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.2.i', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.a', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.a', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.b', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.b', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.e', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.e', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.g', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.g', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.h', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.h', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.k', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.k', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.m', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.m', 'LV', 1.88, 8, 0.2950, 1.2967, 2.4533, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.4.e', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.4.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.4.g', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.4.g', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.4.h', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.4.h', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.c', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.c', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.d', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.e', 'IM', 2.88, 8, 0.3504, 2.1883, 3.5617, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.e', 'LV', 3.00, 8, 0.5000, 2.0200, 3.9800, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.f', 'IM', 2.62, 8, 0.2631, 2.1094, 3.1406, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.f', 'LV', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.a', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.b', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.b', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.c', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.c', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.d', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.d', 'LV', 3.75, 8, 0.3134, 3.1358, 4.3642, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.a', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.c', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.d', 'IM', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.d', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.e', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.e', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.f', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.f', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.2.i', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.2.i', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.a', 'IM', 2.12, 8, 0.2950, 1.5467, 2.7033, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.a', 'LV', 1.88, 8, 0.5806, 0.7371, 3.0129, 'Y', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.b', 'IM', 1.88, 8, 0.3504, 1.1883, 2.5617, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.b', 'LV', 1.12, 8, 0.4795, 0.1852, 2.0648, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.c', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.c', 'LV', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.e', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.e', 'LV', 1.25, 8, 0.3660, 0.5327, 1.9673, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.g', 'IM', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.g', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.h', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.h', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.j', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.j', 'LV', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.k', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.k', 'LV', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.l', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.l', 'LV', 2.50, 8, 0.3273, 1.8584, 3.1416, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.m', 'IM', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.m', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.4.e', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.4.e', 'LV', 3.75, 8, 0.3134, 3.1358, 4.3642, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.4.g', 'IM', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.4.g', 'LV', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.4.h', 'IM', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.4.h', 'LV', 3.25, 8, 0.3660, 2.5327, 3.9673, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.a', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.b', 'IM', 3.00, 8, 0.3273, 2.3584, 3.6416, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.b', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.c', 'IM', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.c', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.d', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.d', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.c', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.e', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.f', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.f', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.a', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.c', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.d', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.b', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.b', 'LV', 4.50, 8, 0.2673, 3.9762, 5.0238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.c', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.e', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.f', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.f', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.2.i', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.2.i', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.a', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.a', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.b', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.b', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.c', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.c', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.e', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.e', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.g', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.g', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.h', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.h', 'LV', 1.62, 8, 0.3239, 0.9902, 2.2598, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.j', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.j', 'LV', 1.00, 8, 0.3273, 0.3584, 1.6416, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.k', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.k', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.l', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.l', 'LV', 1.38, 8, 0.4199, 0.5519, 2.1981, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.m', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.m', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.4.e', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.4.e', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.4.g', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.4.g', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.4.h', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.4.h', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.b', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.d', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.c', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.e', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.e', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.f', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.f', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.b', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.c', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.d', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.f', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.f', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.2.i', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.2.i', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.a', 'IM', 1.88, 8, 0.2950, 1.2967, 2.4533, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.a', 'LV', 1.00, 8, 0.3780, 0.2592, 1.7408, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.b', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.b', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
/*! COMMIT */;
/*! START TRANSACTION */;
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.e', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.e', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.g', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.g', 'LV', 1.50, 8, 0.3780, 0.7592, 2.2408, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.h', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.h', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.k', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.k', 'LV', 0.88, 8, 0.1250, 0.6300, 1.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.m', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.m', 'LV', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.4.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.4.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.4.g', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.4.g', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.4.h', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.4.h', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.b', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.b', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.c', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.a', 'IM', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.a', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.b', 'IM', 4.75, 8, 0.1637, 4.4292, 5.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.b', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.c', 'IM', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.c', 'LV', 4.88, 8, 0.1250, 4.6300, 5.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.d', 'IM', 4.88, 8, 0.1250, 4.6300, 5.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.d', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.e', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.f', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.f', 'LV', 1.25, 8, 0.3660, 0.5327, 1.9673, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.a', 'IM', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.a', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.c', 'IM', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.c', 'LV', 5.00, 8, 0.1890, 4.6296, 5.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.d', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.d', 'LV', 4.88, 8, 0.1250, 4.6300, 5.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.a', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.a', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.b', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.c', 'IM', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.c', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.e', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.e', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.f', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.f', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.2.i', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.2.i', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.a', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.a', 'LV', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.b', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.b', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.c', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.c', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.e', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.e', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.g', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.g', 'LV', 1.25, 8, 0.2500, 0.7600, 1.7400, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.h', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.h', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.k', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.k', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.m', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.m', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.4.e', 'IM', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.4.e', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.4.g', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.4.g', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.4.h', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.4.h', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.c', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.d', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.d', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.a', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.b', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.c', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.c', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.d', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.e', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.f', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.f', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.d', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.e', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.e', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.f', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.f', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.2.i', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.2.i', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.a', 'IM', 1.62, 8, 0.3239, 1.0000, 2.2598, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.a', 'LV', 0.88, 8, 0.4795, 0.0000, 1.8148, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.b', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.b', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.e', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.e', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.g', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.g', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.h', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.h', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.k', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.k', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.m', 'IM', 1.38, 8, 0.2631, 1.0000, 1.8906, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.m', 'LV', 0.50, 8, 0.3780, 0.0000, 1.2408, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.4.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.4.e', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.4.g', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.4.g', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.4.h', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.4.h', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.b', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.b', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.c', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.a', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.c', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.c', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.e', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.f', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.f', 'LV', 2.75, 8, 0.3134, 2.1358, 3.3642, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.c', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.e', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.f', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.f', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.2.i', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.2.i', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.a', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.a', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.b', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.b', 'LV', 1.75, 8, 0.3134, 1.1358, 2.3642, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.e', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.e', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.g', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.g', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.h', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.h', 'LV', 1.12, 8, 0.4407, 0.2613, 1.9887, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.j', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.j', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.k', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.k', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.m', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.m', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.4.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.4.e', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.4.g', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.4.g', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.4.h', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.4.h', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.b', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.b', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.c', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.c', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.d', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.a', 'LV', 4.25, 8, 0.2500, 3.7600, 4.7400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.c', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.d', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.e', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.e', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.f', 'IM', 3.12, 8, 0.4795, 2.1852, 4.0648, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.f', 'LV', 3.00, 8, 0.6814, 1.6645, 4.3355, 'Y', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.a', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.b', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.b', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.c', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.c', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.d', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.d', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.a', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.a', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.b', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.b', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.c', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.c', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.d', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.d', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.e', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.f', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.f', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.2.i', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.2.i', 'LV', 3.88, 8, 0.3981, 3.0947, 4.6553, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.a', 'IM', 2.38, 8, 0.4605, 1.4724, 3.2776, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.a', 'LV', 2.25, 8, 0.7258, 0.8274, 3.6726, 'Y', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.b', 'IM', 2.12, 8, 0.3981, 1.3447, 2.9053, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.b', 'LV', 1.62, 8, 0.6250, 0.4000, 2.8500, 'Y', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.c', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.c', 'LV', 2.12, 8, 0.3981, 1.3447, 2.9053, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.d', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.d', 'LV', 0.38, 8, 0.3750, 0.0000, 1.1100, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.e', 'IM', 2.00, 8, 0.3273, 1.3584, 2.6416, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.e', 'LV', 1.38, 8, 0.4605, 0.4724, 2.2776, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.g', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.g', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.h', 'IM', 2.25, 8, 0.3660, 1.5327, 2.9673, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.h', 'LV', 1.75, 8, 0.5590, 0.6543, 2.8457, 'Y', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.j', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.j', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.k', 'IM', 2.00, 8, 0.2673, 1.4762, 2.5238, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.k', 'LV', 1.62, 8, 0.4199, 0.8019, 2.4481, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.l', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.l', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.m', 'IM', 3.12, 8, 0.3504, 2.4383, 3.8117, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.m', 'LV', 3.00, 8, 0.4226, 2.1717, 3.8283, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.4.e', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.4.e', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.4.g', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.4.g', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.4.h', 'IM', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.4.h', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.a', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.a', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.b', 'IM', 2.00, 8, 0.2673, 1.4762, 2.5238, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.b', 'LV', 1.88, 8, 0.5154, 0.8648, 2.8852, 'Y', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.c', 'IM', 2.00, 8, 0.2673, 1.4762, 2.5238, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.c', 'LV', 1.88, 8, 0.5154, 0.8648, 2.8852, 'Y', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.d', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.b', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.c', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.e', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.e', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.f', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.f', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.b', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.c', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.c', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.d', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.e', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.f', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.f', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.2.i', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.2.i', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.a', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.a', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.b', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.b', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.c', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.c', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.e', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.e', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.g', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.g', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.h', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.h', 'LV', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.j', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.j', 'LV', 1.00, 8, 0.1890, 0.6296, 1.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.k', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.k', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.l', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.l', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.m', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.m', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.4.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.4.e', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.4.g', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.4.g', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.4.h', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.4.h', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.b', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.b', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.c', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.c', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.c', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.d', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.f', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.f', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.c', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.c', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.d', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.d', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.e', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.e', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.f', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.f', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.2.i', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.2.i', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.a', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.a', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.b', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.b', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.e', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.e', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.g', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.g', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.h', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.h', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.k', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.k', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.m', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.m', 'LV', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.4.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.4.e', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.4.g', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.4.g', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.4.h', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.4.h', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.b', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.b', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.c', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.c', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.1.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.1.b', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.1.e', 'IM', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.1.e', 'LV', 2.38, 8, 0.3750, 1.6400, 3.1100, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.1.f', 'IM', 1.25, 8, 0.2500, 1.0000, 1.7400, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.1.f', 'LV', 0.50, 8, 0.5000, 0.0000, 1.4800, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.2.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.2.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.2.b', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.2.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.2.c', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.2.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.2.d', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.A.2.d', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.1.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.1.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.1.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.1.c', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.1.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.1.d', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.1.d', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.1.e', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.1.e', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.1.f', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.1.f', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.2.i', 'IM', 3.25, 8, 0.3660, 2.5327, 3.9673, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.2.i', 'LV', 2.88, 8, 0.4795, 1.9352, 3.8148, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.a', 'IM', 1.88, 8, 0.3981, 1.0947, 2.6553, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.a', 'LV', 1.50, 8, 0.5976, 0.3287, 2.6713, 'Y', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.b', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.b', 'LV', 0.62, 8, 0.3239, 0.0000, 1.2598, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.e', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.e', 'LV', 0.50, 8, 0.3273, 0.0000, 1.1416, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.g', 'IM', 2.12, 8, 0.2950, 1.5467, 2.7033, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.g', 'LV', 2.00, 8, 0.4629, 1.0927, 2.9073, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.h', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.h', 'LV', 1.38, 8, 0.4199, 0.5519, 2.1981, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.k', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.k', 'LV', 0.88, 8, 0.3504, 0.1883, 1.5617, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.m', 'IM', 2.00, 8, 0.2673, 1.4762, 2.5238, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.3.m', 'LV', 1.62, 8, 0.4199, 0.8019, 2.4481, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.4.e', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.4.e', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.4.g', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.4.g', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.4.h', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.4.h', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.5.a', 'IM', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.5.a', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.5.b', 'IM', 2.88, 8, 0.3504, 2.1883, 3.5617, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.5.b', 'LV', 3.00, 8, 0.4629, 2.0927, 3.9073, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.5.c', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.5.c', 'LV', 2.75, 8, 0.4119, 1.9427, 3.5573, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.5.d', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '2.B.5.d', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2025-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.b', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.c', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.e', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.e', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.f', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.f', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.e', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.f', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.f', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.2.i', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.2.i', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.a', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.a', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.b', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.b', 'LV', 1.00, 8, 0.1890, 0.6296, 1.3704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.c', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.c', 'LV', 0.75, 8, 0.3660, 0.0327, 1.4673, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.e', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.e', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.g', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.g', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.h', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.h', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.j', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.j', 'LV', 0.75, 8, 0.3660, 0.0327, 1.4673, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.k', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.k', 'LV', 1.50, 8, 0.2673, 0.9762, 2.0238, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.l', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.l', 'LV', 0.75, 8, 0.3660, 0.0327, 1.4673, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.m', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.m', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.4.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.4.e', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.4.g', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.4.g', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.4.h', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.4.h', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.b', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.b', 'LV', 3.50, 8, 0.3780, 2.7592, 4.2408, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.c', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.c', 'LV', 3.62, 8, 0.3750, 2.8900, 4.3600, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.c', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.d', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.e', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.e', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.f', 'IM', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.f', 'LV', 2.50, 8, 0.3780, 1.7592, 3.2408, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.c', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.c', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.d', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.f', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.f', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.2.i', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.2.i', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.b', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.b', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.e', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.e', 'LV', 1.38, 8, 0.3750, 0.6400, 2.1100, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.g', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.g', 'LV', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.h', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.h', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.k', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.k', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.m', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.m', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.4.e', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.4.e', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.4.g', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.4.g', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.4.h', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.4.h', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.b', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.a', 'LV', 5.00, 8, 0.0000, 5.0000, 5.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.b', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.c', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.c', 'LV', 5.00, 8, 0.0000, 5.0000, 5.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.d', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.e', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.f', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.f', 'LV', 4.88, 8, 0.1250, 4.6300, 5.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.a', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.b', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.c', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.c', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.d', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.a', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.b', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.d', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.f', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.f', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.2.i', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.2.i', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.a', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.b', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.b', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.c', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.c', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.e', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.e', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.g', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.g', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.h', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.h', 'LV', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.k', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.k', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.m', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.m', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.4.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.4.e', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.4.g', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.4.g', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.4.h', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.4.h', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.a', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.b', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.c', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.c', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.d', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.a', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.c', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.e', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.e', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.f', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.f', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.b', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.c', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.c', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.c', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.d', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.d', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.e', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.f', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.f', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.2.i', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.2.i', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.a', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.a', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.b', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.b', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.c', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.c', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.e', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.e', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.g', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.g', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.h', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.h', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.k', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.k', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.m', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.m', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.4.e', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.4.e', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.4.g', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.4.g', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.4.h', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.4.h', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.b', 'IM', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.b', 'LV', 2.25, 8, 0.3660, 1.5327, 2.9673, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.c', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.c', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.d', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.d', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.c', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.e', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.f', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.f', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.b', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.c', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.d', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.a', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.b', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.b', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.d', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.d', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.e', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.e', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.f', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.f', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.2.i', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.2.i', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.a', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.a', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.b', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.b', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.e', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.e', 'LV', 1.50, 8, 0.2673, 0.9762, 2.0238, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.g', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.g', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.h', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.h', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.k', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.k', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.m', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.m', 'LV', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.4.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.4.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.4.g', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.4.g', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.4.h', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.4.h', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.b', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.b', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.c', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.c', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.d', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.d', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.b', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.e', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.e', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.f', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.f', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.b', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.b', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.c', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.d', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.a', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.b', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.d', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.e', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.f', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.f', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.2.i', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.2.i', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.a', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.a', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.b', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.b', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.e', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.e', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.g', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.g', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.h', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.h', 'LV', 1.25, 8, 0.3660, 0.5327, 1.9673, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.k', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.k', 'LV', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.m', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.m', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.4.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.4.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.4.g', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.4.g', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.4.h', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.4.h', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.b', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.b', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.c', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.c', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.d', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.e', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.e', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.f', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.f', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.b', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.b', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.c', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.c', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.d', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.a', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.a', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.b', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.d', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.e', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.f', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.f', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.2.i', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.2.i', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.a', 'IM', 2.12, 8, 0.2950, 1.5467, 2.7033, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.a', 'LV', 1.88, 8, 0.4407, 1.0113, 2.7387, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.b', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.b', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.c', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.c', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.e', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.e', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.g', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.g', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.h', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.h', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.k', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.k', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.m', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.m', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.4.e', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.4.e', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.4.g', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.4.g', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.4.h', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.4.h', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.a', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.a', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.b', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.b', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.c', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.c', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.d', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.b', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.c', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.d', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.e', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.e', 'LV', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.f', 'IM', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.f', 'LV', 2.00, 8, 0.3780, 1.2592, 2.7408, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.a', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.c', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.c', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.d', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.e', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.e', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.f', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.f', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.2.i', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.2.i', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.a', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.a', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.b', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.b', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.e', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.e', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.g', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.g', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.h', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.h', 'LV', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.k', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.k', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.m', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.m', 'LV', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.4.e', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.4.e', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.4.g', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.4.g', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.4.h', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.4.h', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.b', 'IM', 2.62, 8, 0.3239, 1.9902, 3.2598, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.b', 'LV', 3.12, 8, 0.5154, 2.1148, 4.1352, 'Y', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.c', 'IM', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.c', 'LV', 2.38, 8, 0.4199, 1.5519, 3.1981, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.d', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.c', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.c', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.d', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.d', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.e', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.f', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.f', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.a', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.b', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.c', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.c', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.d', 'LV', 4.62, 8, 0.2631, 4.1094, 5.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.b', 'LV', 5.00, 8, 0.1890, 4.6296, 5.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.c', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.c', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.d', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.d', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.e', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.f', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.f', 'LV', 5.25, 8, 0.1637, 4.9292, 5.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.2.i', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.2.i', 'LV', 5.38, 8, 0.1830, 5.0164, 5.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.a', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.a', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.b', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.b', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.e', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.e', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.g', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.g', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.h', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.h', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.k', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.k', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.m', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.m', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.4.e', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.4.e', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.4.g', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.4.g', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.4.h', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.4.h', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.b', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.b', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.c', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.c', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.d', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.b', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.d', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.e', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.e', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.f', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.f', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.a', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.b', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.b', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.c', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.c', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.d', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.d', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.a', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.a', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.b', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.b', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.d', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.d', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.e', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.e', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.f', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.f', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.2.i', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.2.i', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.a', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.a', 'LV', 0.62, 8, 0.3239, 0.0000, 1.2598, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.b', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.b', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.c', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.c', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.e', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.e', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.g', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.g', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.h', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.h', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.k', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.k', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.m', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.m', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.4.e', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.4.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.4.g', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.4.g', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.4.h', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.4.h', 'LV', 2.75, 8, 0.3134, 2.1358, 3.3642, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.b', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.b', 'LV', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.c', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.c', 'LV', 2.62, 8, 0.2631, 2.1094, 3.1406, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.d', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.d', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.a', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.c', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.e', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.e', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.f', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.f', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.b', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.b', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.c', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.d', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.d', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.b', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.d', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.d', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.e', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.e', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.f', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.f', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.2.i', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.2.i', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.a', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.a', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.b', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.b', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.c', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.c', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.e', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.e', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.g', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.g', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.h', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.h', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.j', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.j', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.k', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.k', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.l', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.l', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.m', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.m', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.4.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.4.e', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.4.g', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.4.g', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.4.h', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.4.h', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.a', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.a', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.b', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.b', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.c', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.c', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.d', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.d', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.a', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.b', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.b', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.c', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.d', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.e', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.e', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.f', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.f', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.b', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.c', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.c', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.d', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.d', 'LV', 4.12, 8, 0.3504, 3.4383, 4.8117, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.a', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.b', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.c', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.c', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.d', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.d', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.e', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.e', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.f', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.f', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.2.i', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.2.i', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.a', 'IM', 1.62, 8, 0.3239, 1.0000, 2.2598, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.a', 'LV', 0.88, 8, 0.5154, 0.0000, 1.8852, 'Y', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.b', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.b', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.c', 'IM', 1.38, 8, 0.2631, 1.0000, 1.8906, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.c', 'LV', 0.50, 8, 0.3273, 0.0000, 1.1416, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.e', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.e', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.g', 'IM', 2.62, 8, 0.3239, 1.9902, 3.2598, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.g', 'LV', 2.00, 8, 0.3273, 1.3584, 2.6416, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.h', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.h', 'LV', 1.62, 8, 0.3239, 0.9902, 2.2598, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.k', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.k', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.m', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.m', 'LV', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.4.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.4.e', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.4.g', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.4.g', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.4.h', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.4.h', 'LV', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.a', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.b', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.b', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.c', 'IM', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.c', 'LV', 3.50, 8, 0.3273, 2.8584, 4.1416, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.d', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2012-07-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.a', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.b', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.b', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.c', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.c', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.d', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.e', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.e', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.f', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.f', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.a', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.a', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.b', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.c', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.d', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.a', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.a', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.b', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.b', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.c', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.c', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.d', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.d', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.e', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.e', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.f', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.f', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.2.i', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.2.i', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.a', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.a', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.b', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.b', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.c', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.c', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.d', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.d', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.e', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.e', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.g', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.g', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.h', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.h', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.j', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.j', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.k', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.k', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.l', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.l', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.m', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.m', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.4.e', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.4.e', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.4.g', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.4.g', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.4.h', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.4.h', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.a', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.a', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.b', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.b', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.c', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.c', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.d', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.d', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2024-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.a', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2019-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.a', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2019-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.b', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2019-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.b', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2019-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.c', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2019-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.c', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2019-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.d', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2019-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.d', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2019-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.e', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2019-08-01', 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.e'