CREATE TABLE emerging_tasks (
  onetsoc_code CHARACTER(10) NOT NULL,
  task CHARACTER VARYING(1000) NOT NULL,
  category CHARACTER VARYING(8) NOT NULL,
  original_task_id DECIMAL(8,0),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (original_task_id) REFERENCES task_statements(task_id));

INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-2022.00', 'Coach staff on sales tactics.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-2022.00', 'Establish and monitor staff''s sales goals.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-2033.00', 'Manage stewardship activities to maintain connection with donors.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-3013.00', 'Plan, create, and manage budgets for contracts, equipment, and supplies.', 'Revision', 21280, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-3013.00', 'Review and approve payroll for employees.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-3051.02', 'Conduct employee safety training.', 'New', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-3051.06', 'Train employees in power plant operations.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-3071.00', 'Direct the use of drones and autonomous vehicles for efficient and cost-effective delivery of goods and inventory management.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-3131.00', 'Confer with management or stakeholders and conduct surveys to identify training needs based on projected production processes, changes, and other factors.', 'Revision', 1012, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-3131.00', 'Evaluate instructor performance and the effectiveness of training programs, providing data and recommendations for improvement.', 'Revision', 1009, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-3131.00', 'Train instructors, supervisors, and other leaders in techniques and skills for training and interacting with employees.', 'Revision', 1017, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-9021.00', 'Direct how drone technology is used for site inspections and progress monitoring, ensuring accurate and timely project completion.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-9032.00', 'Supervise student pick-up or drop-off.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-9071.00', 'Monitor the performance of the gaming floor, relocating games and installing new games as necessary.', 'New', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('11-9199.01', 'Develop and review regulatory strategies, development plans, and implementation plans for the preparation and submission of new products.', 'Revision', 18026, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1032.00', 'Contact vendors to locate replacement parts for vehicles.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1032.00', 'Discuss insurance claims with customers or damage claimants.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1032.00', 'Review repair cost estimates and negotiate with automobile repair shops to secure agreement on cost of repairs.', 'Revision', 7247, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1041.03', 'Develop guidelines for nondiscriminatory employment practices, such as affirmative action plans and equal opportunity employment policies.', 'Revision', 20722, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1041.03', 'Train employees on equal opportunity laws, guidelines, or policies, such as discrimination, diversity, harassment, or affirmative action.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1041.04', 'Use emerging technologies, such as drones, for remote or automated inspections.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1041.06', 'Complete or review death certificates, including the assignment of cause and manner of death.', 'Revision', 8915, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1041.06', 'Observe and record the positions and conditions of bodies and related evidence at the scene, through documentation or photographs.', 'Revision', 8916, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1041.07', 'Develop regulatory strategies for products.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1051.00', 'Use remote sensing technologies or drones to evaluate site conditions when in-person visits are not feasible.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1081.01', 'Evaluate the use of technologies, such as global positioning systems (GPS), radio-frequency identification (RFID), route navigation software, drone or robotic technology, or satellite linkup systems, to improve transportation efficiency.', 'Revision', 19998, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1121.00', 'Contact potential clients, meet with professional and trade associations, and produce brochures and other publications to promote conference, convention, and trade show services.', 'Revision', 1228, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1121.00', 'Plan and develop programs, agendas, budgets, menus, and services according to customer requirements.', 'Revision', 1213, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1199.05', 'Deliver sustainability training to employees.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1199.07', 'Prepare written reports or presentations on findings and recommendations.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-1199.07', 'Train personnel and vendors in security procedures or use of security equipment.', 'Revision', 21504, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-2031.00', 'Communicate financial reports and budgets to stakeholders.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-2031.00', 'Submit and monitor salary raises.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('13-2053.00', 'Answer agents'' questions about insurance coverage.', 'New', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('15-1211.00', 'Write code to perform desired actions.', 'New', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('15-2011.00', 'Analyze data to determine premium rates required and cash reserves and liabilities necessary to ensure payment of future benefits.', 'Revision', 3500, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-1011.00', 'Inspect the condition of structures.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-1012.00', 'Develop and facilitate community engagement campaigns and workshops to better understand the community''s needs.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-1012.00', 'Prepare ecological restoration or mitigation design plans to enhance or restore habitats.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-1012.00', 'Use drone technology to survey large areas and gather accurate topographical data.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-1021.00', 'Estimate resources, such as production hours, required for projects.', 'New', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-1021.00', 'Use drone technology to capture high-resolution images and data for map creation and updating.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-1022.01', 'Determine orientation of tracts of land, including position, boundaries, size, and shape, using theodolites, electronic distance-measuring equipment, satellite-based positioning equipment, drones, land information systems, or other geodetic survey equipment.', 'Revision', 16301, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2011.00', 'Develop and test autonomous systems for uncrewed aerospace vehicles.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2011.00', 'Develop software for aerospace systems.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2021.00', 'Communicate results in peer-reviewed research articles or at workshops or conferences.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2021.00', 'Use agricultural drones for crop monitoring, irrigation management, and pest control.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2041.00', 'Adapt processes to convert from small-scale laboratory operations to large-scale commercial production.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2041.00', 'Develop process flow diagrams or pipe and instrumentation diagrams.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2051.00', 'Use drone technology for site surveying, inspection, and monitoring of infrastructure projects.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2051.01', 'Develop plans for integration of drone technology into transportation systems for purposes such as delivery of goods or traffic monitoring.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2111.02', 'Develop or modify building codes and fire codes.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2111.02', 'Perform testing on fire protection equipment or building features, such as fire doors or smoke control systems.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2111.02', 'Review building plans to verify compliance with fire and building codes.', 'Revision', 24004, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2112.01', 'Assess systems to identify and quantify risk factors.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2121.00', 'Develop plans for safely drydocking vessels, including structural integrity, block loading, and stability.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2141.00', 'Investigate equipment failures or diagnose faulty operations and recommend or perform remedial actions.', 'Revision', 20734, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2151.00', 'Use drone technology for aerial surveys and inspections of mining sites to enhance safety and efficiency.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2161.00', 'Recommend preventive measures to be taken in handling nuclear technology based on data obtained from operations monitoring, systematic analysis, or evaluation of test results.', 'Revision', 5386, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2171.00', 'Use drone technology for aerial surveying and monitoring of drilling sites.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2199.10', 'Analyze meteorological data.', 'New', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2199.10', 'Design electrical interconnections.', 'New', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2199.10', 'Design wind turbine components.', 'New', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-2199.10', 'Estimate energy production by analyzing wind data.', 'New', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-3011.00', 'Use drone technology to capture aerial views and topographical data for civil engineering projects.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-3013.00', 'Create bills of materials.', 'New', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-3021.00', 'Operate, test, and troubleshoot uncrewed aerial systems, commonly known as drones, to ensure optimal performance.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-3022.00', 'Operate drones for site surveying and inspection, providing detailed aerial views of project sites.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-3024.00', 'Program and calibrate drones for specific missions or tasks, ensuring proper functionality and performance.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-3029.01', 'Operate drones for remote inspection of large or hard-to-reach structures, such as wind turbines, bridges, or tall buildings.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('17-3031.00', 'Use drone technology to capture aerial images or videos for creating detailed and accurate maps.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-1012.00', 'Test processing equipment to ensure products are produced according to specifications.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-1021.00', 'Analyze biochemical or biophysical data.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-1022.00', 'Perform tests on water, food, and the environment to detect harmful microorganisms or to obtain information about sources of pollution, contamination, or infection and interpret the results.', 'Revision', 15213, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-1023.00', 'Use advanced technologies, such as GIS, remote sensing, and drone technology, for wildlife tracking, habitat mapping, and population studies.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-1029.04', 'Inventory and order lab supplies.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-1031.02', 'Apply herbicide to eliminate harmful plants.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-1031.03', 'Train staff and volunteers on park programs.', 'Revision', 23959, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-1041.00', 'Teach epidemiology to students in public health programs.', 'New', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-2011.00', 'Write and review scientific proposals and research papers.', 'Revision', 20049, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-2012.00', 'Perform peer reviews of scientific papers.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-2032.00', 'Research or design methods of processing, forming, and firing materials to develop products, such as ceramic dental fillings, unbreakable dinner plates, and telescope lenses.', 'Revision', 9094, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-2032.00', 'Review and select materials for products to meet product design and cost requirements.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-2041.03', 'Conduct life cycle assessments of products.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-2043.00', 'Prepare reports or presentations describing research results, using illustrations, maps, appendices, and other information.', 'Revision', 18618, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-2099.01', 'Develop protocols and procedures for planning and executing drone-based remote sensing missions to ensure they comply with standards and requirements.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-3011.00', 'Construct and manage economic datasets.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-3011.00', 'Present research at seminars and conferences.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-3011.00', 'Review documents written by others, such as referee reports.', 'Revision', 23988, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-3032.00', 'Develop and administer surveys to employees of organizations.', 'New', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-3032.00', 'Teach industrial-organizational psychology courses to undergraduate or graduate students.', 'New', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-3039.03', 'Provide feedback to patients and their families on the results of neuropsychological evaluations and recommendations.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-3041.00', 'Mentor sociology students.', 'New', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-3041.00', 'Review sociological research and articles.', 'New', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-3091.00', 'Write, present, and publish research findings for a variety of specialized and general audiences.', 'Revision', 22234, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-3093.00', 'Coordinate artifact donations on behalf of a museum.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-3093.00', 'Create and revise scripts for the tour guides.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-3093.00', 'Write policies and procedures for archival collection care and research protocols.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4012.01', 'Operate drone technology to capture aerial imagery and data for crop monitoring and analysis.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4051.02', 'Calibrate, maintain, and repair chemical instrumentation sensing elements and sampling system equipment, using calibration instruments and hand tools.', 'Revision', 7608, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4051.02', 'Document results from radiation and contamination surveys.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4051.02', 'Inspect, test, and maintain respiratory protection equipment.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4051.02', 'Write radiological work permits.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4061.00', 'Write grant proposals.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4071.00', 'Develop contracts related to operations.', 'New', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4071.00', 'Monitor environmental conditions such as temperature or humidity.', 'New', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4071.00', 'Operate and manage drone technology for aerial surveys and mapping, wildlife monitoring, and forest health assessments.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4071.00', 'Write reports on forestry or conservation activities.', 'New', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4092.00', 'Enter data into databases.', 'New', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4092.00', 'Operate drones to capture aerial footage or photographs of crime scenes for further analysis.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('19-4099.03', 'Operate remote sensing equipment on drones to collect data in areas that are difficult to access or require high-resolution imagery.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('21-1013.00', 'Diagnose mental and emotional disorders in clients.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('21-1014.00', 'Guide clients in the development of skills or strategies for dealing with their problems and coping with triggering factors.', 'Revision', 1593, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('21-1014.00', 'Respond to client communications by monitoring voicemail and email, returning phone calls, and making follow-up calls for missed appointments.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('21-1022.00', 'Conduct psychological assessment of clients.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('21-1093.00', 'Teach parenting techniques to family members.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('23-1023.00', 'Issue search or arrest warrants.', 'Revision', 21182, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('23-2011.00', 'Manage attorneys'' calendars and schedule meetings.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('23-2011.00', 'Request, review, and summarize relevant records for the cases.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1022.00', 'Hire adjunct faculty.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1042.00', 'Write letters of recommendation for students.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1043.00', 'Monitor research program budgets.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1051.00', 'Prepare and deliver lectures to undergraduate or graduate students on topics such as structural geology, micrometeorology, atmospheric thermodynamics, and physics.', 'Revision', 5849, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1054.00', 'Review articles to determine their suitability for publication.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1066.00', 'Mentor other faculty members.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1067.00', 'Give presentations to community groups.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1067.00', 'Review manuscripts.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1067.00', 'Write letters of recommendation for students.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1081.00', 'Deliver presentations at professional conferences.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1082.00', 'Serve as a mentor.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1121.00', 'Direct theater productions.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1121.00', 'Mentor students.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1125.00', 'Evaluate faculty members.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-1193.00', 'Monitor department budgets.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-2057.00', 'Track students'' progress on computer-based programs, such as reading fluency and comprehension.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-2058.00', 'Monitor students using personal electronics or school-issued technology.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-2059.01', 'Discuss with education professionals the physical abilities or disabilities of students and the accommodations required to enhance their school performance.', 'Revision', 17015, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-3031.00', 'Provide teachers with notes summarizing the day''s activities and feedback on any issues or events that occurred.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-4011.00', 'Write grants and apply for funding to support archival work.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-4031.00', 'Open and close the library.', 'New', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('25-9044.00', 'Correspond with students through email to address their questions and concerns.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-1025.00', 'Review contractor bids to subcontract fabrication, installation, and arrangement of carpeting, fixtures, accessories, draperies, paint and wall coverings, art work, furniture, and related items.', 'Revision', 1739, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-2012.05', 'Coordinate the use of drone technology for aerial filming and photography.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-2032.00', 'Plan and direct rehearsals to instruct dancers in dance steps and in techniques to achieve desired effects.', 'Revision', 11028, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-3041.00', 'Respond to questions from the public.', 'New', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-3041.00', 'Write text, such as headlines, stories, articles, editorials, or newsletters.', 'Revision', 21000, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-3092.00', 'File exhibits.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-3092.00', 'Perform secretarial tasks for the court.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-3092.00', 'Swear in witnesses.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-4011.00', 'Operate drones for aerial videography and photography during live events or for pre-recorded material.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-4011.00', 'Purchase audio or video equipment.', 'New', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-4012.00', 'Develop budgets.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-4021.00', 'Engage in research to learn technological developments and techniques or to develop new photographic procedures and materials.', 'Revision', 9363, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-4021.00', 'Operate drones to capture aerial photographs and videos, following all regulatory guidelines.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-4031.00', 'Operate drones to capture aerial or unique angle footage for film, television, or video productions.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('27-4032.00', 'Write scripts.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1011.00', 'Provide guidance to patients on exercises they can perform to improve mobility.', 'New', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1011.00', 'Take x-rays.', 'New', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1022.00', 'Evaluate and treat problems related to the temperomandibular joint (TMJ).', 'New', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1024.00', 'Consult with patients about treatment options.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1024.00', 'Create treatment plans for patients.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1071.00', 'Refer patients to other healthcare providers.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1122.00', 'Recommend adaptive equipment to individuals to increase independence in daily living activities.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1126.00', 'Attend high-risk and caesarian section infant deliveries to provide neonatal respiratory care as needed.', 'New', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1141.02', 'Mentor nursing students.', 'New', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1141.04', 'Develop and evaluate work processes based on evidence-based standards.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1161.00', 'Evaluate mental health of patients.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1161.00', 'Screen patients for gynecologic conditions such as infections.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1211.00', 'Place invasive intravascular monitors into patients.', 'New', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1211.00', 'Teach anesthesiology principles to residents.', 'New', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1214.00', 'Consult and direct other medical personnel on patient care.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1214.00', 'Process patient transfers to and from other hospitals.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-1223.00', 'Perform mental health evaluations to provide information to courts of law on patients'' mental states.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-2011.00', 'Conduct blood typing and antibody screening.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-2011.04', 'Cut sections of body tissues for microscopic examination, using microtomes or cryostats.', 'Revision', 22780, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-2011.04', 'Select and maintain controls for stains.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-2012.00', 'Perform quality control analyses to ensure accuracy of test results.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-2012.01', 'Load slides onto staining equipment.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-2031.00', 'Perform general administrative tasks, such as answering telephones, scheduling appointments, or ordering supplies or equipment.', 'Revision', 15234, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-2033.00', 'Schedule patients for nuclear medicine exams and procedures.', 'New', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-2055.00', 'Schedule surgical procedures for patients.', 'New', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-2055.00', 'Transport patients to and from the operating room.', 'New', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-2057.00', 'Order supplies.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-2057.00', 'Perform examinations using ophthalmic equipment, such as autorefractors, phoropters, tomographs, or retinoscopes.', 'Revision', 19250, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-9091.00', 'Develop emergency action plans for sports facilities.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('29-9099.01', 'Test patients for sexually transmitted infections.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('31-1121.00', 'Assist patients with toileting and incontinent care.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('31-1121.00', 'Feed patients.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('31-1122.00', 'Administer bedside or personal care, such as assistance with ambulation, dressing, feeding, or personal hygiene.', 'Revision', 2370, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('31-2012.00', 'Sanitize equipment.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('31-9093.00', 'Order medical supplies for healthcare facilities or laboratories.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('31-9097.00', 'Confirm the identities of patients by verifying their personal information.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-1012.00', 'Read and review subordinates'' reports to ensure legal standards are met and there are no mistakes.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-1021.00', 'Deploy and monitor drones for aerial surveillance and assessment of fire situations.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-2022.00', 'Operate drones to monitor and assess fire conditions, track fire progress, and identify safe access points for firefighters.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-3012.00', 'Conduct security checks of the premises.', 'New', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-3021.00', 'Operate drones for aerial surveillance or to gather evidence from difficult to reach locations.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-3021.02', 'Use drone technology for aerial photography and videography of crime scenes.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-3021.06', 'Make recommendations for investigations and subpoenas.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-3031.00', 'Operate drones for surveillance of large areas and tracking of wildlife.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-3041.00', 'Perform traffic control duties such as setting up barricades and temporary signs, placing bags on parking meters to limit their use, or directing traffic or pedestrians.', 'Revision', 7949, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-9011.00', 'Deliver educational presentations on wildlife topics, such as animal safety, at schools and community events.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-9011.00', 'Pick up deceased animals from roadways and dispose of the animal carcasses.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-9011.00', 'Testify at court hearings when citations are contested.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-9011.00', 'Transport injured or ill wildlife to rescues.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-9021.00', 'Serve documents to parties named in legal proceedings.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-9021.00', 'Use advanced technology, such as drones, GPS trackers, and surveillance cameras, to facilitate investigations.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('33-9099.02', 'Use drone technology for surveillance and loss prevention.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('35-2011.00', 'Take out garbage.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('35-2021.00', 'Check and log refrigerator, freezer, and cooler temperatures.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('35-3011.00', 'Provide customers with directions or answers to questions.', 'New', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('35-3023.00', 'Check and monitor food temperatures while cooking.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('35-3031.00', 'Check with customers to see if they want to apply any rewards to their purchase.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('35-3031.00', 'Perform routine tasks, such as refilling syrups, sanitizer bottles, and other essential supplies.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('35-9011.00', 'Prepare food, such as sandwiches, for customers.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('35-9021.00', 'Clean and sanitize the dining area, including tables.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('37-1012.00', 'Repair irrigation systems.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('37-3011.00', 'Move furniture.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('37-3012.00', 'Establish driving routes for pesticide applications.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('37-3012.00', 'Record information about pesticide applications, such as the type used and amount applied.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('37-3012.00', 'Use new technology and equipment, such as drones or GPS systems, to apply pesticides more accurately and efficiently.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-2011.00', 'Teach owners how to train their dogs.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-2011.00', 'Teach people with visual impairments to use guide dogs.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-2021.00', 'Scuba dive in aquariums to perform exhibit maintenance.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-2021.00', 'Train volunteers and facility staff.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-3012.00', 'Provide race or game information to patrons.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-3012.00', 'Serve drinks to patrons.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-3021.00', 'Download digital keys to unlock digital movie files.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-3021.00', 'Ingest digital content, such as films, advertisements, or trailers, into servers or projectors.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-3092.00', 'Create patterns for costumes based on designer''s drawings.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-3092.00', 'Schedule costume fittings for actors.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-3093.00', 'Maintain or repair athletic equipment.', 'New', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-5091.00', 'Clean and sanitize supplies, such as makeup brushes.', 'Revision', 24008, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-5093.00', 'Assist hair stylists with chemical services, such as neutralizing perms and applying hair color.', 'New', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-5093.00', 'Launder and fold the towels that are used for drying customers'' hair.', 'New', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-5093.00', 'Refill and stock work stations with supplies, such as shampoos and conditioners.', 'New', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-5093.00', 'Rinse out hair color or permanent solutions from customers'' hair.', 'New', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-5093.00', 'Sweep hair from the salon floor.', 'New', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-9031.00', 'Adjust workout programs and provide variations to address injuries or muscle soreness.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('39-9041.00', 'Advise student organizations.', 'New', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('41-4011.07', 'Log client information and sales leads into tracking documents or software.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('41-9091.00', 'Contact customers to ensure their satisfaction with products or services.', 'New', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('41-9091.00', 'Train new recruits or other employees.', 'New', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('43-4121.00', 'Hire library staff such as student assistants.', 'New', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('43-4171.00', 'Enter and update databases of contact information, such as names, addresses, and phone numbers.', 'New', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('43-5041.00', 'Dig dirt away from meters to take readings.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('43-5041.00', 'Install new or replace broken meters.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('43-5051.00', 'Stock lobby with retail merchandise.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('43-6011.00', 'Keep track of employees'' time.', 'New', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('43-9081.00', 'Check the facts of stories using the internet.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('43-9081.00', 'Design page layouts using text, photographs, graphics, and other elements.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('43-9111.00', 'Present results of statistical analyses to stakeholders.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('43-9111.00', 'Write code for statistical applications.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('45-2091.00', 'Operate drones to monitor crop health, growth and pest infestations, and apply targeted treatments.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('45-3031.00', 'Operate and maintain drone technology for aerial surveillance of hunting and fishing areas.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('45-4011.00', 'Create field maps using geographic information systems technology.', 'New', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('45-4022.00', 'Operate remote-controlled logging machines and drones for dangerous or hard-to-reach tasks.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('45-4023.00', 'Move logs using heavy equipment such as log loaders.', 'New', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-2021.00', 'Use drone technology to inspect and assess the condition of tall structures.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-2031.00', 'Use drones for site surveying and to inspect hard-to-reach areas of a structure.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-2041.00', 'Cut and install vinyl composition tile or vinyl base.', 'New', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-2141.00', 'Clean tools and equipment, such as brushes and rollers.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-2141.00', 'Hang wallpaper.', 'New', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-2171.00', 'Unload rebar from trucks.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-2171.00', 'Use forklifts or cranes to move construction material, such as rebar.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-2221.00', 'Assemble or inspect hoisting equipment or rigging, such as cables, pulleys, or hooks, to move heavy equipment or materials.', 'Revision', 11554, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-2221.00', 'Lift steel beams, girders, or columns using cranes or forklifts, or by signaling hoisting equipment operators to lift or position structural steel members.', 'Revision', 20795, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-3012.00', 'Cut or weld metal.', 'New', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-4011.00', 'Inspect structures to determine cause and origin of damage.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-4011.01', 'Evaluate the energy performance of buildings using modeling software.', 'New', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-4071.00', 'Pump, clean, and repair septic tanks, sewer lines, or related structures such as manholes, culverts, and catch basins.', 'Revision', 11610, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-5013.00', 'Maintain and perform safety inspections on rigs, equipment, and other tools.', 'Revision', 20451, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-5032.00', 'Operate drones for aerial survey of blast sites and for post-blast damage assessment.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-5043.00', 'Check roof or ribs for hazardous conditions.', 'New', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('47-5043.00', 'Clean equipment, such as dust collectors.', 'New', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-2021.00', 'Use drone technology to inspect towers and antennas for damage or maintenance needs.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-2091.00', 'Perform installation, testing, adjustment, and repair of avionics equipment in uncrewed aerial vehicles, such as drones.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-2095.00', 'Calibrate instruments, such as transmitters.', 'New', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-2095.00', 'Use drones for inspection of high-voltage lines and other hard-to-reach equipment.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-3051.00', 'Explain repair procedures to customers.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-3051.00', 'Repair or replace engine mechanical equipment, such as power tilts, water pumps, bilge pumps, or power take-offs.', 'Revision', 13770, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-3052.00', 'Diagnose electrical problems.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-3091.00', 'Estimate costs of repairing bicycles and write service tickets.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-3091.00', 'Make adjustments to bicycles to improve customer fit and riding position.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-3092.00', 'Inspect and install lights, such as headlights and taillights.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-9043.00', 'Troubleshoot electrical, hydraulic, or mechanical equipment and machines.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-9044.00', 'Inventory and store parts, tools, and equipment.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-9045.00', 'Reline furnaces using ramming material.', 'New', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-9052.00', 'Set up service for customers, installing, connecting, testing, or adjusting equipment, such as digital subscriber line modems.', 'Revision', 11850, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-9061.00', 'Adjust or repair cameras, photographic mechanisms, or equipment such as range and view finders, shutters, light meters, or lens systems, using hand tools.', 'Revision', 8437, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-9061.00', 'Repair and calibrate drone cameras and equipment for aerial photography and videography.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-9063.00', 'Adjust the neck angle on fretted instruments.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-9071.00', 'Use drones for inspecting roofs, gutters, and other hard-to-reach areas of buildings.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('49-9094.00', 'Read blueprints and project specification manuals to recommend appropriate hardware and electronic locking devices.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-2041.00', 'Troubleshoot and repair electrical or mechanical equipment.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-3021.00', 'Clean and sanitize meat cases and cutting equipment.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-3022.00', 'Clean meat cutting equipment.', 'New', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-4111.00', 'Troubleshoot malfunctions in manufacturing equipment.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-5111.00', 'Correct color in photographs or digital images.', 'New', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-6051.00', 'Patch materials, such as cotton or leather.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-8031.00', 'Complete wastewater discharge monitoring reports and maintenance logs.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-8031.00', 'Maintain and repair portable safety equipment and permanent safety infrastructure to ensure operational readiness and compliance with safety protocols.', 'New', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9011.00', 'Load products into tanks for shipment.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9071.00', 'Measure, cut, and file pieces of jewelry, such as rings, brooches, bracelets, and lockets.', 'Revision', 23625, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9081.00', 'Meet with dentists or patients to discuss dental appliances.', 'New', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9081.00', 'Order parts or materials needed to make dental appliances.', 'New', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9081.00', 'Scan dental models to create digital files.', 'New', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9081.00', 'Stain porcelain on dental appliances to match the color of patients'' teeth.', 'New', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9082.00', 'Order parts or supplies for orthotic or prosthetic devices.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9083.00', 'Tint lenses according to customer specifications.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9151.00', 'Adjust digital images using software.', 'New', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9195.05', 'Apply glazes to pottery pieces, using tools such as spray guns.', 'Revision', 21211, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9195.05', 'Decorate pottery using tools such as brushes.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9195.05', 'Load and unload pottery from kilns.', 'New', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('51-9195.05', 'Mix chemicals according to recipes to create glazes.', 'Revision', 21211, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-2012.00', 'Operate large scale uncrewed aerial vehicles (UAVs) or drones for various commercial purposes, such as aerial photography, surveying land and structures, or monitoring wildlife.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-2021.00', 'Monitor, direct, or sequence the movement of aircraft within an assigned air space or on the ground at airports to minimize delays and maximize safety.', 'Revision', 12729, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-2022.00', 'Inspect airfield conditions to ensure safety and compliance with federal regulatory requirements.', 'Revision', 23939, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-2022.00', 'Issue notices to advise flight crews of airfield status.', 'New', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-2022.00', 'Monitor and manage the operation of drones within the airport airspace to ensure safe aircraft operations.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-2022.00', 'Train operations staff on topics such as driving on airfields and security identification display area (SIDA) procedures.', 'Revision', 10618, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-5021.00', 'Oversee the use of drones for inspection and maintenance of hard-to-reach parts of the vessel.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-5031.00', 'Use drone technology for ship inspections, maintenance, or other tasks.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-6051.01', 'Inspect uncrewed aircraft systems, such as drones, to ensure compliance with safety and operation regulations.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-7021.00', 'Inspect crane site conditions to determine ground stability.', 'New', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-7031.00', 'Perform maintenance on dredge equipment, such as changing engine oil.', 'New', NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-7062.00', 'Inspect products for damage or leaks.', 'New', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, date_updated, domain_source) VALUES ('53-7073.00', 'Conduct regular inspections of equipment using drones or other advanced technology.', 'New', NULL, TO_DATE('2025-05-01', 'yyyy-mm-dd'), 'AI/SME');

