CREATE TABLE work_activities (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(7,4),
  lower_ci_bound DECIMAL(7,4),
  upper_ci_bound DECIMAL(7,4),
  recommend_suppress CHARACTER(1),
  not_relevant CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));

INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.a.1', 'IM', 4.56, 29, 0.1559, 4.2369, 4.8756, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.a.1', 'LV', 4.89, 30, 0.1727, 4.5393, 5.2458, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.a.2', 'IM', 4.25, 30, 0.2125, 3.8130, 4.6823, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.a.2', 'LV', 5.21, 30, 0.3872, 4.4133, 5.9971, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.b.1', 'IM', 4.23, 29, 0.1544, 3.9180, 4.5507, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.b.1', 'LV', 5.13, 29, 0.1662, 4.7899, 5.4709, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.b.2', 'IM', 2.51, 29, 0.2813, 1.9346, 3.0871, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.b.2', 'LV', 2.23, 30, 0.4174, 1.3738, 3.0810, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.b.3', 'IM', 3.26, 30, 0.2750, 2.6958, 3.8208, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.b.3', 'LV', 3.08, 30, 0.3209, 2.4190, 3.7318, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.1', 'IM', 4.18, 29, 0.1854, 3.7985, 4.5582, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.1', 'LV', 4.43, 30, 0.2695, 3.8740, 4.9763, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.2', 'IM', 4.46, 30, 0.1958, 4.0630, 4.8637, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.2', 'LV', 4.98, 28, 0.3276, 4.3107, 5.6552, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.3', 'IM', 4.49, 30, 0.1788, 4.1194, 4.8509, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.3', 'LV', 4.85, 29, 0.3415, 4.1471, 5.5461, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.4', 'IM', 4.38, 29, 0.1936, 3.9872, 4.7803, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.4', 'LV', 4.84, 29, 0.1939, 4.4400, 5.2343, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.1', 'IM', 4.85, 30, 0.0660, 4.7182, 4.9882, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.1', 'LV', 6.00, 29, 0.3380, 5.3048, 6.6897, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.2', 'IM', 4.32, 30, 0.1898, 3.9352, 4.7114, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.2', 'LV', 4.45, 29, 0.3092, 3.8181, 5.0849, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.3', 'IM', 4.31, 30, 0.1693, 3.9632, 4.6559, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.3', 'LV', 5.09, 29, 0.3169, 4.4438, 5.7422, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.4', 'IM', 4.57, 28, 0.1592, 4.2396, 4.8928, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.4', 'LV', 5.46, 28, 0.2799, 4.8904, 6.0389, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.5', 'IM', 3.83, 28, 0.2288, 3.3563, 4.2954, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.5', 'LV', 4.41, 28, 0.3017, 3.7885, 5.0266, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.6', 'IM', 4.53, 28, 0.1525, 4.2145, 4.8405, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.6', 'LV', 5.69, 27, 0.1606, 5.3557, 6.0160, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.1', 'IM', 1.96, 29, 0.2139, 1.5216, 2.3980, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.1', 'LV', 1.90, 29, 0.4093, 1.0604, 2.7374, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.2', 'IM', 1.86, 29, 0.2168, 1.4144, 2.3026, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.2', 'LV', 2.08, 30, 0.4715, 1.1107, 3.0393, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.3', 'IM', 2.04, 30, 0.2664, 1.4990, 2.5886, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.3', 'LV', 1.82, 30, 0.4025, 1.0010, 2.6474, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.4', 'IM', 2.67, 29, 0.4147, 1.8229, 3.5219, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.4', 'LV', 1.88, 30, 0.2802, 1.3079, 2.4541, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.1', 'IM', 4.17, 30, 0.2397, 3.6782, 4.6589, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.1', 'LV', 3.03, 30, 0.2388, 2.5442, 3.5210, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.2', 'IM', 1.62, 30, 0.1532, 1.3023, 1.9291, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.2', 'LV', 1.25, 30, 0.3659, 0.5028, 1.9997, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.4', 'IM', 1.21, 30, 0.1144, 1.0000, 1.4471, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.4', 'LV', 0.27, 30, 0.1357, 0.0000, 0.5436, 'Y', 'Y', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.5', 'IM', 1.45, 30, 0.2044, 1.0355, 1.8718, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.5', 'LV', 0.49, 30, 0.1961, 0.0907, 0.8931, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.6', 'IM', 3.60, 30, 0.4357, 2.7099, 4.4921, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.6', 'LV', 3.80, 30, 0.3430, 3.0955, 4.4987, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.1', 'IM', 4.15, 29, 0.2535, 3.6305, 4.6691, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.1', 'LV', 3.38, 30, 0.3299, 2.7017, 4.0513, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.2', 'IM', 4.75, 29, 0.1074, 4.5309, 4.9711, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.2', 'LV', 5.82, 30, 0.2797, 5.2481, 6.3922, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.3', 'IM', 4.55, 29, 0.1545, 4.2315, 4.8644, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.3', 'LV', 5.47, 29, 0.3826, 4.6868, 6.2542, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.4', 'IM', 4.80, 30, 0.1007, 4.5904, 5.0000, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.4', 'LV', 6.54, 30, 0.1480, 6.2407, 6.8460, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.5', 'IM', 3.31, 29, 0.4571, 2.3759, 4.2486, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.5', 'LV', 3.10, 30, 0.5378, 2.0003, 4.2001, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.6', 'IM', 3.81, 30, 0.2638, 3.2731, 4.3520, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.6', 'LV', 4.91, 30, 0.6182, 3.6476, 6.1764, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.7', 'IM', 4.47, 30, 0.1643, 4.1338, 4.8060, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.7', 'LV', 5.74, 30, 0.3077, 5.1156, 6.3743, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.8', 'IM', 3.90, 30, 0.2362, 3.4185, 4.3847, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.8', 'LV', 4.40, 29, 0.4529, 3.4728, 5.3283, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.1', 'IM', 4.10, 30, 0.2285, 3.6291, 4.5639, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.1', 'LV', 5.60, 28, 0.2049, 5.1761, 6.0168, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.2', 'IM', 4.63, 30, 0.1404, 4.3457, 4.9200, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.2', 'LV', 5.38, 30, 0.2452, 4.8797, 5.8826, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.3', 'IM', 4.01, 30, 0.2587, 3.4806, 4.5388, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.3', 'LV', 4.76, 30, 0.2743, 4.1978, 5.3200, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.4', 'IM', 4.74, 30, 0.1116, 4.5119, 4.9683, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.4', 'LV', 6.07, 29, 0.2540, 5.5529, 6.5936, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.5', 'IM', 4.71, 29, 0.1175, 4.4668, 4.9482, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.5', 'LV', 5.85, 29, 0.2822, 5.2737, 6.4298, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.6', 'IM', 3.95, 30, 0.4770, 2.9715, 4.9225, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.6', 'LV', 5.42, 29, 0.8460, 3.6843, 7.0000, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.c.1', 'IM', 4.02, 30, 0.2283, 3.5532, 4.4870, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.c.1', 'LV', 4.65, 29, 0.3521, 3.9269, 5.3696, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.c.2', 'IM', 3.78, 29, 0.4591, 2.8359, 4.7168, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.c.2', 'LV', 4.80, 30, 0.7415, 3.2788, 6.3117, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.c.3', 'IM', 4.11, 30, 0.1845, 3.7282, 4.4829, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.c.3', 'LV', 4.75, 30, 0.3444, 4.0483, 5.4568, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.a.1', 'IM', 4.78, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.a.1', 'LV', 5.37, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.a.2', 'IM', 3.48, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.a.2', 'LV', 4.07, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.b.1', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.b.1', 'LV', 4.54, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.b.2', 'IM', 2.11, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.b.2', 'LV', 2.37, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.b.3', 'IM', 3.54, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.b.3', 'LV', 4.35, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.1', 'IM', 3.85, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.1', 'LV', 4.38, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.2', 'IM', 3.96, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.2', 'LV', 4.78, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.3', 'IM', 3.67, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.3', 'LV', 4.37, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.4', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.4', 'LV', 4.81, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.1', 'IM', 4.63, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.1', 'LV', 5.59, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.2', 'IM', 4.33, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.2', 'LV', 4.85, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.3', 'IM', 4.30, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.3', 'LV', 5.59, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.4', 'IM', 4.50, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.4', 'LV', 5.56, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.5', 'IM', 3.63, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.5', 'LV', 4.93, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.6', 'IM', 4.37, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.6', 'LV', 6.07, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.1', 'IM', 1.81, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.1', 'LV', 1.67, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.2', 'IM', 1.44, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.2', 'LV', 1.30, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.3', 'IM', 1.56, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.3', 'LV', 1.00, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.4', 'IM', 1.70, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.4', 'LV', 1.11, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.1', 'IM', 4.15, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.1', 'LV', 3.22, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.2', 'IM', 2.00, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.2', 'LV', 2.11, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.4', 'IM', 1.41, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.4', 'LV', 0.78, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.5', 'IM', 1.48, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.5', 'LV', 0.93, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.6', 'IM', 3.44, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.6', 'LV', 3.41, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.1', 'IM', 4.44, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.1', 'LV', 5.00, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.2', 'IM', 4.81, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.2', 'LV', 5.93, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.3', 'IM', 4.48, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.3', 'LV', 6.11, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.4', 'IM', 4.67, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.4', 'LV', 6.30, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.5', 'IM', 2.74, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.5', 'LV', 2.67, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.6', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.6', 'LV', 5.07, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.7', 'IM', 3.44, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.7', 'LV', 4.70, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.8', 'IM', 3.56, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.8', 'LV', 4.41, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.1', 'IM', 4.07, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.1', 'LV', 5.04, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.2', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.2', 'LV', 4.81, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.3', 'IM', 3.63, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.3', 'LV', 4.22, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.4', 'IM', 3.78, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.4', 'LV', 4.93, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.5', 'IM', 3.93, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.5', 'LV', 4.78, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.6', 'IM', 3.93, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.6', 'LV', 5.30, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.c.1', 'IM', 3.30, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.c.1', 'LV', 3.89, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.c.2', 'IM', 3.26, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.c.2', 'LV', 4.26, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.c.3', 'IM', 3.88, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.c.3', 'LV', 4.81, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.a.1', 'IM', 4.42, 32, 0.1606, 4.0895, 4.7446, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.a.1', 'LV', 4.07, 32, 0.3743, 3.3015, 4.8285, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.a.2', 'IM', 3.91, 32, 0.2053, 3.4909, 4.3282, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.a.2', 'LV', 3.83, 31, 0.4200, 2.9682, 4.6836, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.b.1', 'IM', 4.22, 32, 0.1594, 3.8905, 4.5408, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.b.1', 'LV', 3.56, 32, 0.3752, 2.7943, 4.3247, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.b.2', 'IM', 2.62, 32, 0.3126, 1.9817, 3.2567, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.b.2', 'LV', 2.31, 32, 0.5076, 1.2722, 3.3429, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.b.3', 'IM', 3.23, 32, 0.2252, 2.7755, 3.6940, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.b.3', 'LV', 2.95, 32, 0.2819, 2.3730, 3.5230, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.1', 'IM', 4.10, 31, 0.1698, 3.7491, 4.4426, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.1', 'LV', 3.88, 32, 0.3885, 3.0855, 4.6700, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.2', 'IM', 4.08, 32, 0.1862, 3.7009, 4.4604, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.2', 'LV', 4.13, 32, 0.3827, 3.3490, 4.9101, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.3', 'IM', 3.59, 31, 0.2799, 3.0229, 4.1661, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.3', 'LV', 3.49, 32, 0.5073, 2.4594, 4.5285, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.4', 'IM', 4.04, 32, 0.1905, 3.6481, 4.4250, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.4', 'LV', 4.27, 31, 0.4513, 3.3508, 5.1941, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.1', 'IM', 4.33, 32, 0.1482, 4.0316, 4.6361, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.1', 'LV', 4.88, 32, 0.5837, 3.6916, 6.0724, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.2', 'IM', 3.70, 32, 0.2364, 3.2189, 4.1831, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.2', 'LV', 3.95, 31, 0.4725, 2.9872, 4.9173, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.3', 'IM', 3.80, 32, 0.2847, 3.2182, 4.3796, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.3', 'LV', 4.17, 32, 0.6787, 2.7847, 5.5532, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.4', 'IM', 3.84, 32, 0.1522, 3.5340, 4.1549, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.4', 'LV', 3.54, 32, 0.2752, 2.9802, 4.1029, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.5', 'IM', 3.81, 32, 0.2607, 3.2762, 4.3396, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.5', 'LV', 3.92, 32, 0.4297, 3.0423, 4.7952, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.6', 'IM', 4.20, 32, 0.1295, 3.9319, 4.4602, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.6', 'LV', 4.60, 32, 0.5196, 3.5413, 5.6606, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.1', 'IM', 2.11, 32, 0.2268, 1.6508, 2.5758, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.1', 'LV', 2.13, 32, 0.4095, 1.2998, 2.9700, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.2', 'IM', 2.00, 32, 0.2060, 1.5802, 2.4205, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.2', 'LV', 2.62, 32, 0.4816, 1.6419, 3.6062, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.3', 'IM', 2.07, 32, 0.1898, 1.6795, 2.4539, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.3', 'LV', 1.88, 32, 0.3327, 1.1991, 2.5563, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.4', 'IM', 1.90, 32, 0.1876, 1.5215, 2.2866, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.4', 'LV', 1.71, 32, 0.3634, 0.9719, 2.4541, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.1', 'IM', 4.46, 32, 0.2178, 4.0149, 4.9035, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.1', 'LV', 4.15, 32, 0.3676, 3.4001, 4.8993, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.2', 'IM', 2.12, 32, 0.2969, 1.5194, 2.7305, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.2', 'LV', 1.62, 32, 0.3029, 1.0024, 2.2378, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.4', 'IM', 1.83, 31, 0.1788, 1.4684, 2.1988, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.4', 'LV', 1.91, 31, 0.4546, 0.9812, 2.8378, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.5', 'IM', 1.89, 32, 0.1739, 1.5319, 2.2412, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.5', 'LV', 1.87, 32, 0.4378, 0.9755, 2.7612, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.6', 'IM', 3.94, 32, 0.2045, 3.5231, 4.3573, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.6', 'LV', 3.37, 32, 0.2135, 2.9347, 3.8057, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.1', 'IM', 3.72, 32, 0.1719, 3.3669, 4.0683, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.1', 'LV', 2.92, 32, 0.3419, 2.2232, 3.6178, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.2', 'IM', 4.34, 32, 0.1565, 4.0197, 4.6582, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.2', 'LV', 4.85, 32, 0.3173, 4.2064, 5.5006, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.3', 'IM', 3.57, 32, 0.4892, 2.5761, 4.5714, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.3', 'LV', 4.42, 32, 0.5008, 3.4015, 5.4443, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.4', 'IM', 4.28, 32, 0.1479, 3.9821, 4.5853, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.4', 'LV', 5.26, 32, 0.1843, 4.8856, 5.6372, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.5', 'IM', 3.02, 31, 0.3802, 2.2462, 3.7991, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.5', 'LV', 3.03, 31, 0.4800, 2.0470, 4.0076, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.6', 'IM', 3.58, 32, 0.2313, 3.1050, 4.0485, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.6', 'LV', 3.76, 32, 0.4105, 2.9185, 4.5930, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.7', 'IM', 3.88, 32, 0.2234, 3.4291, 4.3405, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.7', 'LV', 4.89, 32, 0.4051, 4.0676, 5.7201, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.8', 'IM', 2.54, 31, 0.5574, 1.4050, 3.6815, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.8', 'LV', 2.33, 32, 0.8079, 0.6783, 3.9737, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.1', 'IM', 3.99, 32, 0.1293, 3.7270, 4.2546, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.1', 'LV', 4.62, 32, 0.2924, 4.0204, 5.2130, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.2', 'IM', 3.81, 32, 0.2187, 3.3614, 4.2536, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.2', 'LV', 3.88, 32, 0.4412, 2.9757, 4.7754, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.3', 'IM', 3.41, 32, 0.2963, 2.8065, 4.0152, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.3', 'LV', 3.79, 32, 0.3326, 3.1086, 4.4651, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.4', 'IM', 4.20, 30, 0.1332, 3.9303, 4.4752, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.4', 'LV', 4.80, 31, 0.3112, 4.1676, 5.4387, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.5', 'IM', 3.91, 32, 0.1749, 3.5487, 4.2621, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.5', 'LV', 4.53, 31, 0.2480, 4.0249, 5.0380, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.6', 'IM', 3.66, 32, 0.2277, 3.1971, 4.1261, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.6', 'LV', 4.39, 32, 0.4229, 3.5235, 5.2484, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.c.1', 'IM', 3.40, 31, 0.3350, 2.7159, 4.0844, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.c.1', 'LV', 3.71, 32, 0.3987, 2.9011, 4.5276, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.c.2', 'IM', 3.70, 32, 0.1849, 3.3232, 4.0775, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.c.2', 'LV', 4.33, 31, 0.2690, 3.7824, 4.8812, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.c.3', 'IM', 3.86, 32, 0.1748, 3.5039, 4.2170, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.c.3', 'LV', 4.52, 32, 0.3092, 3.8886, 5.1497, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.a.1', 'IM', 4.32, 21, 0.1509, 4.0071, 4.6368, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.a.1', 'LV', 4.67, 20, 0.2083, 4.2319, 5.1041, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.a.2', 'IM', 2.78, 21, 0.3005, 2.1547, 3.4084, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.a.2', 'LV', 3.08, 19, 0.5152, 1.9979, 4.1627, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.b.1', 'IM', 3.60, 21, 0.2375, 3.1005, 4.0915, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.b.1', 'LV', 3.88, 20, 0.3676, 3.1079, 4.6468, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.b.2', 'IM', 1.77, 21, 0.2462, 1.2544, 2.2815, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.b.2', 'LV', 1.08, 20, 0.3619, 0.3184, 1.8332, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.b.3', 'IM', 2.79, 20, 0.3131, 2.1360, 3.4466, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.b.3', 'LV', 2.58, 20, 0.4188, 1.7032, 3.4564, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.1', 'IM', 3.37, 21, 0.2715, 2.7989, 3.9314, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.1', 'LV', 3.66, 20, 0.4371, 2.7472, 4.5771, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.2', 'IM', 3.51, 21, 0.2227, 3.0495, 3.9787, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.2', 'LV', 4.12, 21, 0.3452, 3.3988, 4.8388, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.3', 'IM', 2.35, 21, 0.2934, 1.7342, 2.9581, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.3', 'LV', 2.04, 21, 0.4241, 1.1580, 2.9273, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.4', 'IM', 3.26, 20, 0.1765, 2.8955, 3.6345, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.4', 'LV', 4.06, 20, 0.2753, 3.4877, 4.6402, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.1', 'IM', 3.82, 21, 0.1814, 3.4414, 4.1983, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.1', 'LV', 4.18, 20, 0.2988, 3.5588, 4.8094, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.2', 'IM', 4.05, 21, 0.2191, 3.5893, 4.5036, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.2', 'LV', 4.73, 20, 0.2506, 4.2030, 5.2519, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.3', 'IM', 3.78, 20, 0.2541, 3.2501, 4.3140, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.3', 'LV', 4.49, 20, 0.4006, 3.6505, 5.3274, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.4', 'IM', 3.42, 21, 0.2607, 2.8727, 3.9602, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.4', 'LV', 3.90, 20, 0.3780, 3.1062, 4.6886, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.5', 'IM', 3.34, 21, 0.2865, 2.7425, 3.9377, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.5', 'LV', 4.06, 20, 0.4163, 3.1894, 4.9322, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.6', 'IM', 4.17, 21, 0.2091, 3.7355, 4.6078, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.6', 'LV', 5.56, 20, 0.2741, 4.9850, 6.1323, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.1', 'IM', 1.90, 21, 0.2588, 1.3574, 2.4370, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.1', 'LV', 1.56, 21, 0.3960, 0.7357, 2.3879, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.2', 'IM', 2.08, 20, 0.2972, 1.4531, 2.6974, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.2', 'LV', 2.45, 20, 0.5645, 1.2662, 3.6291, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.3', 'IM', 1.85, 20, 0.2931, 1.2404, 2.4673, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.3', 'LV', 1.39, 20, 0.4677, 0.4063, 2.3640, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.4', 'IM', 1.82, 20, 0.2681, 1.2574, 2.3796, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.4', 'LV', 1.06, 20, 0.2993, 0.4329, 1.6859, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.1', 'IM', 4.61, 19, 0.1668, 4.2632, 4.9641, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.1', 'LV', 3.94, 19, 0.3331, 3.2370, 4.6368, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.2', 'IM', 1.28, 21, 0.1301, 1.0112, 1.5538, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.2', 'LV', 0.54, 21, 0.2408, 0.0403, 1.0448, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.4', 'IM', 1.21, 21, 0.0961, 1.0065, 1.4073, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.4', 'LV', 0.66, 21, 0.3116, 0.0067, 1.3066, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.5', 'IM', 1.34, 21, 0.1763, 1.0000, 1.7040, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.5', 'LV', 0.48, 21, 0.2292, 0.0000, 0.9536, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.6', 'IM', 3.31, 21, 0.2700, 2.7480, 3.8743, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.6', 'LV', 3.05, 20, 0.3264, 2.3639, 3.7302, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.1', 'IM', 3.01, 20, 0.2716, 2.4454, 3.5823, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.1', 'LV', 2.90, 20, 0.3344, 2.1969, 3.5966, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.2', 'IM', 4.25, 20, 0.1451, 3.9489, 4.5561, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.2', 'LV', 5.15, 20, 0.2716, 4.5841, 5.7212, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.3', 'IM', 4.37, 20, 0.1790, 3.9950, 4.7444, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.3', 'LV', 5.70, 20, 0.2868, 5.1031, 6.3038, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.4', 'IM', 4.01, 20, 0.1539, 3.6839, 4.3280, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.4', 'LV', 5.22, 20, 0.2131, 4.7715, 5.6637, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.5', 'IM', 2.37, 21, 0.2715, 1.8053, 2.9381, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.5', 'LV', 2.00, 20, 0.3746, 1.2138, 2.7820, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.6', 'IM', 3.64, 21, 0.3314, 2.9523, 4.3349, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.6', 'LV', 4.51, 20, 0.5964, 3.2611, 5.7575, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.7', 'IM', 2.82, 21, 0.2284, 2.3439, 3.2967, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.7', 'LV', 3.47, 20, 0.3806, 2.6762, 4.2694, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.8', 'IM', 3.18, 20, 0.3186, 2.5136, 3.8473, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.8', 'LV', 3.81, 19, 0.4692, 2.8229, 4.7945, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.1', 'IM', 3.07, 21, 0.2714, 2.5063, 3.6385, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.1', 'LV', 3.87, 20, 0.4452, 2.9338, 4.7973, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.2', 'IM', 2.96, 21, 0.2748, 2.3850, 3.5313, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.2', 'LV', 3.11, 20, 0.4405, 2.1872, 4.0313, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.3', 'IM', 2.74, 21, 0.2902, 2.1366, 3.3471, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.3', 'LV', 2.83, 21, 0.4676, 1.8569, 3.8076, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.4', 'IM', 2.98, 21, 0.3214, 2.3113, 3.6520, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.4', 'LV', 3.26, 21, 0.4910, 2.2389, 4.2872, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.5', 'IM', 2.62, 21, 0.2457, 2.1064, 3.1313, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.5', 'LV', 3.28, 20, 0.4706, 2.2907, 4.2606, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.6', 'IM', 2.31, 21, 0.2773, 1.7322, 2.8890, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.6', 'LV', 2.52, 20, 0.5233, 1.4273, 3.6178, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.c.1', 'IM', 3.11, 21, 0.2750, 2.5317, 3.6791, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.c.1', 'LV', 3.65, 20, 0.4013, 2.8131, 4.4930, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.c.2', 'IM', 2.29, 21, 0.2714, 1.7188, 2.8512, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.c.2', 'LV', 2.31, 20, 0.4899, 1.2864, 3.3370, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.c.3', 'IM', 2.52, 21, 0.2485, 2.0008, 3.0374, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.c.3', 'LV', 3.08, 20, 0.4706, 2.0933, 4.0634, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.a.1', 'IM', 4.33, 40, 0.1297, 4.0688, 4.5936, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.a.1', 'LV', 4.98, 40, 0.1432, 4.6893, 5.2686, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.a.2', 'IM', 3.27, 40, 0.2183, 2.8280, 3.7112, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.a.2', 'LV', 3.62, 40, 0.1900, 3.2390, 4.0078, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.b.1', 'IM', 4.24, 40, 0.1784, 3.8759, 4.5974, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.b.1', 'LV', 4.56, 40, 0.1420, 4.2778, 4.8522, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.b.2', 'IM', 1.45, 40, 0.1333, 1.1831, 1.7226, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.b.2', 'LV', 0.72, 40, 0.2138, 0.2904, 1.1553, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.b.3', 'IM', 3.59, 40, 0.3254, 2.9353, 4.2518, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.b.3', 'LV', 3.04, 39, 0.3914, 2.2450, 3.8298, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.1', 'IM', 3.37, 40, 0.2850, 2.7916, 3.9443, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.1', 'LV', 3.53, 40, 0.4509, 2.6154, 4.4396, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.2', 'IM', 3.36, 40, 0.2840, 2.7883, 3.9371, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.2', 'LV', 3.92, 40, 0.4667, 2.9711, 4.8591, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.3', 'IM', 2.61, 39, 0.2605, 2.0824, 3.1371, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.3', 'LV', 2.57, 39, 0.4138, 1.7306, 3.4058, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.4', 'IM', 3.75, 40, 0.1354, 3.4726, 4.0204, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.4', 'LV', 4.04, 40, 0.1952, 3.6479, 4.4375, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.1', 'IM', 4.34, 40, 0.2373, 3.8627, 4.8228, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.1', 'LV', 4.67, 40, 0.2765, 4.1138, 5.2324, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.2', 'IM', 4.28, 40, 0.1717, 3.9339, 4.6286, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.2', 'LV', 4.71, 40, 0.1751, 4.3544, 5.0628, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.3', 'IM', 3.83, 40, 0.1886, 3.4480, 4.2110, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.3', 'LV', 4.52, 40, 0.4014, 3.7066, 5.3305, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.4', 'IM', 4.07, 40, 0.2529, 3.5584, 4.5815, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.4', 'LV', 4.17, 40, 0.2691, 3.6286, 4.7173, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.5', 'IM', 3.40, 39, 0.4005, 2.5843, 4.2058, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.5', 'LV', 3.96, 40, 0.5926, 2.7651, 5.1623, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.6', 'IM', 4.35, 40, 0.1062, 4.1303, 4.5600, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.6', 'LV', 5.86, 40, 0.0899, 5.6771, 6.0406, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.1', 'IM', 1.71, 40, 0.2826, 1.1339, 2.2772, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.1', 'LV', 1.06, 40, 0.3848, 0.2847, 1.8413, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.2', 'IM', 1.37, 40, 0.1411, 1.0803, 1.6509, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.2', 'LV', 0.81, 40, 0.2985, 0.2068, 1.4145, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.3', 'IM', 1.20, 40, 0.0688, 1.0578, 1.3363, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.3', 'LV', 0.37, 40, 0.1315, 0.0995, 0.6316, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.4', 'IM', 1.78, 40, 0.3477, 1.0766, 2.4831, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.4', 'LV', 0.94, 40, 0.2701, 0.3960, 1.4887, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.1', 'IM', 4.40, 39, 0.1374, 4.1209, 4.6772, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.1', 'LV', 3.12, 40, 0.2506, 2.6142, 3.6281, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.2', 'IM', 1.29, 39, 0.1086, 1.0706, 1.5102, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.2', 'LV', 0.63, 39, 0.2980, 0.0309, 1.2375, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.4', 'IM', 1.14, 39, 0.0943, 1.0000, 1.3334, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.4', 'LV', 0.28, 39, 0.1886, 0.0000, 0.6668, 'Y', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.5', 'IM', 1.15, 39, 0.0716, 1.0081, 1.2978, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.5', 'LV', 0.31, 39, 0.1584, 0.0000, 0.6319, 'Y', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.6', 'IM', 3.00, 39, 0.2981, 2.3997, 3.6068, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.6', 'LV', 2.53, 39, 0.2416, 2.0397, 3.0181, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.1', 'IM', 3.39, 40, 0.2778, 2.8304, 3.9542, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.1', 'LV', 2.98, 40, 0.2087, 2.5548, 3.3992, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.2', 'IM', 4.75, 40, 0.0847, 4.5799, 4.9227, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.2', 'LV', 5.28, 40, 0.2503, 4.7760, 5.7885, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.3', 'IM', 4.20, 40, 0.1886, 3.8151, 4.5781, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.3', 'LV', 5.60, 40, 0.2168, 5.1631, 6.0400, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.4', 'IM', 4.68, 40, 0.0981, 4.4804, 4.8773, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.4', 'LV', 5.88, 40, 0.1457, 5.5838, 6.1733, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.5', 'IM', 2.44, 40, 0.3313, 1.7743, 3.1145, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.5', 'LV', 2.21, 40, 0.4390, 1.3185, 3.0946, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.6', 'IM', 4.27, 40, 0.2743, 3.7160, 4.8256, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.6', 'LV', 5.43, 40, 0.4908, 4.4343, 6.4196, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.7', 'IM', 3.68, 39, 0.1489, 3.3793, 3.9822, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.7', 'LV', 4.94, 40, 0.1885, 4.5568, 5.3194, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.8', 'IM', 2.81, 40, 0.3841, 2.0300, 3.5837, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.8', 'LV', 3.07, 40, 0.6606, 1.7296, 4.4018, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.1', 'IM', 3.97, 40, 0.1461, 3.6735, 4.2644, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.1', 'LV', 4.83, 40, 0.2306, 4.3673, 5.3002, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.2', 'IM', 4.08, 40, 0.1471, 3.7873, 4.3822, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.2', 'LV', 4.26, 40, 0.2311, 3.7902, 4.7250, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.3', 'IM', 3.14, 38, 0.1820, 2.7710, 3.5087, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.3', 'LV', 3.34, 39, 0.2396, 2.8565, 3.8266, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.4', 'IM', 3.84, 40, 0.1728, 3.4933, 4.1923, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.4', 'LV', 4.23, 40, 0.2553, 3.7086, 4.7415, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.5', 'IM', 3.36, 40, 0.1838, 2.9930, 3.7365, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.5', 'LV', 3.74, 40, 0.2981, 3.1334, 4.3393, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.6', 'IM', 3.18, 40, 0.1393, 2.9023, 3.4659, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.6', 'LV', 4.34, 40, 0.2521, 3.8262, 4.8459, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.c.1', 'IM', 2.59, 40, 0.1503, 2.2814, 2.8892, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.c.1', 'LV', 2.95, 40, 0.2530, 2.4429, 3.4664, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.c.2', 'IM', 2.25, 40, 0.2950, 1.6582, 2.8516, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.c.2', 'LV', 2.18, 40, 0.5194, 1.1288, 3.2298, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.c.3', 'IM', 3.18, 40, 0.1491, 2.8825, 3.4857, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.c.3', 'LV', 3.85, 40, 0.3132, 3.2168, 4.4837, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.a.1', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.a.1', 'LV', 4.57, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.a.2', 'IM', 3.10, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.a.2', 'LV', 3.57, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.b.1', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.b.1', 'LV', 4.29, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.b.2', 'IM', 1.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.b.2', 'LV', 1.10, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.b.3', 'IM', 3.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.b.3', 'LV', 2.95, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.1', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.1', 'LV', 4.86, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.2', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.2', 'LV', 4.19, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.3', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.3', 'LV', 3.76, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.4', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.4', 'LV', 4.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.1', 'IM', 4.63, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.1', 'LV', 5.48, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.2', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.2', 'LV', 4.43, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.3', 'IM', 3.95, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.3', 'LV', 4.71, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.4', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.4', 'LV', 4.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.5', 'IM', 3.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.5', 'LV', 4.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.6', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.6', 'LV', 5.43, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.1', 'IM', 1.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.1', 'LV', 0.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.2', 'IM', 1.20, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.2', 'LV', 0.76, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.3', 'IM', 1.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.3', 'LV', 0.86, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.4', 'IM', 1.76, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.4', 'LV', 1.24, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.1', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.1', 'LV', 3.62, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.2', 'IM', 1.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.2', 'LV', 0.67, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.4', 'IM', 1.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.4', 'LV', 0.10, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.5', 'IM', 1.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.5', 'LV', 0.29, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.6', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.6', 'LV', 3.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.1', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.1', 'LV', 3.57, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.2', 'IM', 4.70, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.2', 'LV', 5.52, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.3', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.3', 'LV', 5.48, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.4', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.4', 'LV', 5.76, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.5', 'IM', 2.95, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.5', 'LV', 3.33, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.6', 'IM', 4.86, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.6', 'LV', 6.33, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.7', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.7', 'LV', 5.86, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.8', 'IM', 3.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.8', 'LV', 4.24, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.1', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.1', 'LV', 5.33, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.2', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.2', 'LV', 5.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.3', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.3', 'LV', 5.19, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.4', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.4', 'LV', 5.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.5', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.5', 'LV', 5.67, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.6', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.6', 'LV', 6.10, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.c.1', 'IM', 3.15, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.c.1', 'LV', 3.95, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.c.2', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.c.2', 'LV', 4.76, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.c.3', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.c.3', 'LV', 4.24, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.1.a.1', 'IM', 4.34, 21, 0.2166, 3.8908, 4.7943, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.1.a.1', 'LV', 4.61, 21, 0.1982, 4.1915, 5.0185, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.1.a.2', 'IM', 3.24, 21, 0.3003, 2.6119, 3.8648, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.1.a.2', 'LV', 3.16, 21, 0.5122, 2.0918, 4.2287, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.1.b.1', 'IM', 3.11, 19, 0.2209, 2.6464, 3.5748, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.1.b.1', 'LV', 3.09, 21, 0.5298, 1.9861, 4.1962, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.1.b.2', 'IM', 1.87, 21, 0.3749, 1.0892, 2.6532, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.1.b.2', 'LV', 1.78, 21, 0.7462, 0.2195, 3.3328, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.1.b.3', 'IM', 2.25, 21, 0.2975, 1.6300, 2.8710, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.1.b.3', 'LV', 1.88, 21, 0.4065, 1.0303, 2.7262, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.a.1', 'IM', 3.00, 20, 0.3919, 2.1835, 3.8240, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.a.1', 'LV', 2.71, 21, 0.4471, 1.7813, 3.6466, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.a.2', 'IM', 4.05, 20, 0.3917, 3.2253, 4.8648, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.a.2', 'LV', 4.68, 21, 0.3154, 4.0246, 5.3403, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.a.3', 'IM', 3.70, 20, 0.2953, 3.0796, 4.3159, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.a.3', 'LV', 3.91, 21, 0.2990, 3.2897, 4.5373, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.a.4', 'IM', 3.40, 20, 0.3201, 2.7329, 4.0727, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.a.4', 'LV', 3.94, 21, 0.4344, 3.0316, 4.8437, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.b.1', 'IM', 3.57, 21, 0.2884, 2.9671, 4.1702, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.b.1', 'LV', 4.54, 21, 0.2302, 4.0588, 5.0192, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.b.2', 'IM', 3.49, 19, 0.2101, 3.0508, 3.9337, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.b.2', 'LV', 4.50, 21, 0.2992, 3.8751, 5.1234, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.b.3', 'IM', 4.17, 20, 0.2377, 3.6733, 4.6683, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.b.3', 'LV', 5.04, 20, 0.2079, 4.6021, 5.4724, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.b.4', 'IM', 3.89, 21, 0.2304, 3.4081, 4.3694, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.b.4', 'LV', 4.25, 21, 0.4566, 3.2952, 5.2002, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.b.5', 'IM', 3.09, 20, 0.4693, 2.1063, 4.0708, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.b.5', 'LV', 3.57, 20, 0.7249, 2.0558, 5.0903, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.b.6', 'IM', 4.07, 21, 0.2609, 3.5228, 4.6111, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.2.b.6', 'LV', 5.66, 21, 0.3137, 5.0081, 6.3171, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.a.1', 'IM', 2.24, 21, 0.1692, 1.8898, 2.5956, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.a.1', 'LV', 2.10, 20, 0.2331, 1.6161, 2.5918, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.a.2', 'IM', 1.72, 21, 0.2526, 1.1908, 2.2445, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.a.2', 'LV', 1.67, 21, 0.5847, 0.4531, 2.8926, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.a.3', 'IM', 1.49, 21, 0.2105, 1.0508, 1.9292, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.a.3', 'LV', 0.75, 21, 0.3177, 0.0849, 1.4104, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.a.4', 'IM', 1.77, 21, 0.3093, 1.1230, 2.4135, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.a.4', 'LV', 1.07, 21, 0.3836, 0.2742, 1.8746, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.b.1', 'IM', 4.14, 20, 0.3951, 3.3142, 4.9680, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.b.1', 'LV', 3.88, 21, 0.2490, 3.3578, 4.3966, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.b.2', 'IM', 1.04, 21, 0.0275, 1.0000, 1.0935, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.b.2', 'LV', 0.11, 21, 0.0932, 0.0000, 0.3068, 'Y', 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.b.4', 'IM', 1.03, 21, 0.0250, 1.0000, 1.0835, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.b.4', 'LV', 0.09, 21, 0.0702, 0.0000, 0.2316, 'Y', 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.b.5', 'IM', 1.26, 21, 0.1507, 1.0000, 1.5713, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.b.5', 'LV', 0.31, 21, 0.1634, 0.0000, 0.6477, 'Y', 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.b.6', 'IM', 3.76, 19, 0.3167, 3.0923, 4.4229, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.3.b.6', 'LV', 3.79, 20, 0.1731, 3.4278, 4.1523, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.1', 'IM', 3.15, 21, 0.3747, 2.3688, 3.9321, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.1', 'LV', 3.13, 21, 0.4285, 2.2340, 4.0218, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.2', 'IM', 4.36, 21, 0.2136, 3.9110, 4.8020, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.2', 'LV', 5.04, 21, 0.1596, 4.7093, 5.3751, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.3', 'IM', 3.94, 19, 0.4183, 3.0577, 4.8154, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.3', 'LV', 5.05, 20, 0.4396, 4.1253, 5.9656, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.4', 'IM', 4.38, 21, 0.2250, 3.9141, 4.8527, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.4', 'LV', 5.47, 21, 0.2021, 5.0476, 5.8908, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.5', 'IM', 2.39, 20, 0.3179, 1.7251, 3.0557, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.5', 'LV', 2.37, 21, 0.3147, 1.7183, 3.0311, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.6', 'IM', 3.39, 21, 0.5568, 2.2286, 4.5517, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.6', 'LV', 3.44, 21, 0.6045, 2.1751, 4.6969, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.7', 'IM', 3.14, 21, 0.4536, 2.1937, 4.0862, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.7', 'LV', 2.92, 20, 0.7675, 1.3154, 4.5280, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.8', 'IM', 3.40, 20, 0.5019, 2.3460, 4.4471, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.a.8', 'LV', 3.30, 20, 0.7715, 1.6875, 4.9169, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.b.1', 'IM', 3.11, 21, 0.4802, 2.1089, 4.1122, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.b.1', 'LV', 3.69, 21, 0.6784, 2.2791, 5.1093, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.b.2', 'IM', 3.38, 21, 0.5022, 2.3347, 4.4300, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.b.2', 'LV', 3.18, 21, 0.5256, 2.0861, 4.2787, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.b.3', 'IM', 3.14, 20, 0.3051, 2.5033, 3.7807, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.b.3', 'LV', 3.30, 21, 0.3473, 2.5722, 4.0212, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.b.4', 'IM', 2.67, 21, 0.5368, 1.5463, 3.7859, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.b.4', 'LV', 2.88, 21, 0.8721, 1.0639, 4.7023, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.b.5', 'IM', 2.92, 21, 0.4951, 1.8904, 3.9558, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.b.5', 'LV', 3.13, 21, 0.6558, 1.7628, 4.4989, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.b.6', 'IM', 2.74, 21, 0.4538, 1.7894, 3.6825, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.b.6', 'LV', 3.05, 21, 0.7007, 1.5864, 4.5097, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.c.1', 'IM', 3.51, 21, 0.3478, 2.7862, 4.2372, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.c.1', 'LV', 3.88, 21, 0.4104, 3.0268, 4.7389, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.c.2', 'IM', 2.25, 21, 0.6044, 1.0000, 3.5089, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.c.2', 'LV', 1.99, 21, 0.8583, 0.1947, 3.7756, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.c.3', 'IM', 2.61, 21, 0.4514, 1.6654, 3.5484, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2033.00', '4.A.4.c.3', 'LV', 2.59, 21, 0.5806, 1.3832, 3.8054, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.1.a.1', 'IM', 4.62, 44, 0.0864, 4.4496, 4.7983, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.1.a.1', 'LV', 5.03, 43, 0.2633, 4.4975, 5.5600, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.1.a.2', 'IM', 3.81, 44, 0.1664, 3.4704, 4.1416, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.1.a.2', 'LV', 4.31, 44, 0.1980, 3.9084, 4.7071, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.1.b.1', 'IM', 3.89, 43, 0.1707, 3.5492, 4.2380, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.1.b.1', 'LV', 4.38, 43, 0.3429, 3.6911, 5.0750, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.1.b.2', 'IM', 3.15, 44, 0.2612, 2.6247, 3.6782, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.1.b.2', 'LV', 2.80, 44, 0.3753, 2.0383, 3.5519, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.1.b.3', 'IM', 3.08, 44, 0.1743, 2.7314, 3.4343, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.1.b.3', 'LV', 3.25, 44, 0.2537, 2.7374, 3.7605, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.a.1', 'IM', 3.44, 44, 0.2098, 3.0206, 3.8666, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.a.1', 'LV', 3.94, 44, 0.3520, 3.2262, 4.6459, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.a.2', 'IM', 3.77, 44, 0.2857, 3.1930, 4.3452, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.a.2', 'LV', 4.34, 44, 0.4420, 3.4514, 5.2340, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.a.3', 'IM', 3.71, 44, 0.2223, 3.2610, 4.1576, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.a.3', 'LV', 3.87, 44, 0.3442, 3.1793, 4.5674, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.a.4', 'IM', 3.50, 44, 0.2492, 2.9959, 4.0009, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.a.4', 'LV', 3.74, 44, 0.3960, 2.9448, 4.5418, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.b.1', 'IM', 4.22, 43, 0.1788, 3.8602, 4.5817, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.b.1', 'LV', 4.67, 44, 0.3119, 4.0457, 5.3037, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.b.2', 'IM', 3.46, 43, 0.1125, 3.2351, 3.6894, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.b.2', 'LV', 4.25, 44, 0.2187, 3.8136, 4.6956, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.b.3', 'IM', 3.87, 44, 0.2130, 3.4415, 4.3006, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.b.3', 'LV', 4.99, 44, 0.2179, 4.5464, 5.4252, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.b.4', 'IM', 2.96, 44, 0.1643, 2.6314, 3.2939, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.b.4', 'LV', 3.34, 44, 0.2658, 2.8020, 3.8742, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.b.5', 'IM', 4.19, 44, 0.1715, 3.8422, 4.5338, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.b.5', 'LV', 5.09, 44, 0.2730, 4.5437, 5.6449, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.b.6', 'IM', 4.39, 43, 0.1162, 4.1523, 4.6212, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.2.b.6', 'LV', 5.45, 44, 0.3140, 4.8190, 6.0856, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.a.1', 'IM', 3.17, 44, 0.2096, 2.7479, 3.5931, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.a.1', 'LV', 3.53, 44, 0.3212, 2.8869, 4.1824, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.a.2', 'IM', 3.11, 44, 0.2590, 2.5875, 3.6320, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.a.2', 'LV', 4.25, 44, 0.3500, 3.5438, 4.9557, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.a.3', 'IM', 2.92, 44, 0.3191, 2.2814, 3.5683, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.a.3', 'LV', 2.78, 44, 0.4862, 1.7971, 3.7582, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.a.4', 'IM', 2.56, 43, 0.2542, 2.0503, 3.0763, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.a.4', 'LV', 1.94, 43, 0.3010, 1.3296, 2.5446, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.b.1', 'IM', 4.15, 44, 0.1882, 3.7677, 4.5267, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.b.1', 'LV', 3.72, 43, 0.3513, 3.0094, 4.4275, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.b.2', 'IM', 2.04, 44, 0.2201, 1.5986, 2.4866, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.b.2', 'LV', 1.98, 44, 0.4106, 1.1529, 2.8090, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.b.4', 'IM', 2.49, 43, 0.2809, 1.9256, 3.0595, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.b.4', 'LV', 2.51, 43, 0.4092, 1.6797, 3.3314, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.b.5', 'IM', 2.38, 44, 0.2830, 1.8094, 2.9509, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.b.5', 'LV', 2.45, 44, 0.4399, 1.5597, 3.3340, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.b.6', 'IM', 3.95, 44, 0.2463, 3.4561, 4.4497, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.3.b.6', 'LV', 3.95, 44, 0.4716, 2.9960, 4.8981, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.1', 'IM', 3.27, 43, 0.1230, 3.0216, 3.5180, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.1', 'LV', 2.75, 43, 0.1415, 2.4618, 3.0331, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.2', 'IM', 4.44, 44, 0.1234, 4.1862, 4.6841, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.2', 'LV', 5.10, 44, 0.2027, 4.6878, 5.5053, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.3', 'IM', 3.84, 43, 0.2027, 3.4314, 4.2494, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.3', 'LV', 3.90, 44, 0.2453, 3.4047, 4.3939, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.4', 'IM', 4.16, 44, 0.1439, 3.8654, 4.4459, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.4', 'LV', 5.24, 44, 0.1456, 4.9487, 5.5358, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.5', 'IM', 3.23, 44, 0.2479, 2.7294, 3.7294, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.5', 'LV', 3.48, 44, 0.2853, 2.9081, 4.0590, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.6', 'IM', 2.49, 44, 0.1993, 2.0831, 2.8871, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.6', 'LV', 2.25, 43, 0.2800, 1.6875, 2.8176, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.7', 'IM', 3.60, 44, 0.1704, 3.2547, 3.9418, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.7', 'LV', 4.78, 44, 0.2615, 4.2530, 5.3078, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.8', 'IM', 3.06, 43, 0.2618, 2.5313, 3.5878, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.a.8', 'LV', 3.09, 44, 0.3858, 2.3153, 3.8714, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.b.1', 'IM', 3.94, 44, 0.1796, 3.5777, 4.3021, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.b.1', 'LV', 4.71, 44, 0.2730, 4.1564, 5.2575, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.b.2', 'IM', 3.71, 43, 0.2017, 3.2994, 4.1134, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.b.2', 'LV', 3.53, 44, 0.2582, 3.0119, 4.0532, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.b.3', 'IM', 3.34, 44, 0.2850, 2.7674, 3.9170, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.b.3', 'LV', 3.68, 44, 0.5002, 2.6688, 4.6861, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.b.4', 'IM', 3.90, 43, 0.1911, 3.5110, 4.2825, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.b.4', 'LV', 4.77, 44, 0.3067, 4.1521, 5.3892, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.b.5', 'IM', 3.64, 42, 0.2439, 3.1518, 4.1369, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.b.5', 'LV', 4.37, 44, 0.2956, 3.7749, 4.9672, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.b.6', 'IM', 3.22, 44, 0.2248, 2.7657, 3.6723, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.b.6', 'LV', 3.99, 44, 0.4646, 3.0491, 4.9231, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.c.1', 'IM', 4.03, 43, 0.2083, 3.6059, 4.4468, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.c.1', 'LV', 4.22, 44, 0.2034, 3.8085, 4.6287, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.c.2', 'IM', 3.26, 44, 0.2922, 2.6688, 3.8472, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.c.2', 'LV', 3.75, 43, 0.4202, 2.9054, 4.6012, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.c.3', 'IM', 3.77, 44, 0.3057, 3.1545, 4.3875, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.A.4.c.3', 'LV', 4.23, 44, 0.4106, 3.3996, 5.0556, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.1.a.1', 'IM', 4.42, 29, 0.1292, 4.1531, 4.6824, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.1.a.1', 'LV', 4.76, 29, 0.2631, 4.2224, 5.3004, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.1.a.2', 'IM', 4.19, 28, 0.1601, 3.8591, 4.5160, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.1.a.2', 'LV', 4.76, 26, 0.2990, 4.1477, 5.3793, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.1.b.1', 'IM', 4.42, 29, 0.1432, 4.1314, 4.7181, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.1.b.1', 'LV', 4.47, 27, 0.1744, 4.1154, 4.8324, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.1.b.2', 'IM', 4.07, 29, 0.2000, 3.6637, 4.4829, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.1.b.2', 'LV', 3.68, 29, 0.2952, 3.0719, 4.2815, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.1.b.3', 'IM', 3.75, 29, 0.1931, 3.3553, 4.1464, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.1.b.3', 'LV', 3.61, 28, 0.3762, 2.8429, 4.3867, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.a.1', 'IM', 4.00, 29, 0.1693, 3.6557, 4.3493, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.a.1', 'LV', 4.57, 28, 0.3562, 3.8355, 5.2971, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.a.2', 'IM', 3.61, 29, 0.1850, 3.2268, 3.9846, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.a.2', 'LV', 4.16, 28, 0.3904, 3.3551, 4.9571, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.a.3', 'IM', 4.14, 29, 0.2159, 3.6936, 4.5781, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.a.3', 'LV', 3.76, 28, 0.4124, 2.9133, 4.6057, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.a.4', 'IM', 3.86, 29, 0.1679, 3.5209, 4.2088, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.a.4', 'LV', 3.92, 28, 0.3147, 3.2764, 4.5678, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.b.1', 'IM', 4.49, 29, 0.1698, 4.1379, 4.8338, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.b.1', 'LV', 5.25, 28, 0.2224, 4.7895, 5.7020, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.b.2', 'IM', 4.23, 28, 0.1856, 3.8496, 4.6114, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.b.2', 'LV', 4.73, 26, 0.2653, 4.1879, 5.2809, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.b.3', 'IM', 4.09, 29, 0.1966, 3.6898, 4.4954, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.b.3', 'LV', 4.76, 28, 0.3222, 4.0955, 5.4178, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.b.4', 'IM', 3.74, 29, 0.2645, 3.1935, 4.2772, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.b.4', 'LV', 3.66, 29, 0.2938, 3.0536, 4.2572, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.b.5', 'IM', 4.07, 29, 0.2693, 3.5172, 4.6206, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.b.5', 'LV', 4.58, 28, 0.3417, 3.8746, 5.2770, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.b.6', 'IM', 4.33, 29, 0.1903, 3.9401, 4.7199, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.2.b.6', 'LV', 5.75, 29, 0.2550, 5.2326, 6.2774, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.a.1', 'IM', 3.50, 28, 0.3323, 2.8149, 4.1784, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.a.1', 'LV', 3.85, 28, 0.3180, 3.1980, 4.5031, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.a.2', 'IM', 3.18, 29, 0.2703, 2.6215, 3.7291, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.a.2', 'LV', 4.58, 29, 0.3524, 3.8591, 5.3030, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.a.3', 'IM', 3.41, 29, 0.3076, 2.7833, 4.0436, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.a.3', 'LV', 4.16, 28, 0.3670, 3.4040, 4.9099, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.a.4', 'IM', 3.21, 29, 0.2734, 2.6497, 3.7699, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.a.4', 'LV', 3.02, 29, 0.2401, 2.5303, 3.5140, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.b.1', 'IM', 3.74, 29, 0.1843, 3.3656, 4.1207, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.b.1', 'LV', 3.84, 28, 0.2586, 3.3105, 4.3717, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.b.2', 'IM', 3.69, 29, 0.2802, 3.1128, 4.2607, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.b.2', 'LV', 3.98, 29, 0.3437, 3.2725, 4.6805, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.b.4', 'IM', 3.33, 29, 0.3717, 2.5712, 4.0941, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.b.4', 'LV', 3.50, 28, 0.5652, 2.3386, 4.6582, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.b.5', 'IM', 3.02, 29, 0.3816, 2.2415, 3.8051, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.b.5', 'LV', 3.20, 28, 0.6200, 1.9243, 4.4685, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.b.6', 'IM', 3.89, 29, 0.1935, 3.4927, 4.2855, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.3.b.6', 'LV', 3.38, 28, 0.3279, 2.7113, 4.0570, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.1', 'IM', 3.76, 29, 0.1862, 3.3812, 4.1440, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.1', 'LV', 3.71, 27, 0.3967, 2.8993, 4.5300, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.2', 'IM', 4.44, 29, 0.1578, 4.1189, 4.7653, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.2', 'LV', 5.01, 28, 0.3202, 4.3510, 5.6649, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.3', 'IM', 4.04, 29, 0.1496, 3.7345, 4.3472, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.3', 'LV', 4.83, 27, 0.2475, 4.3217, 5.3392, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.4', 'IM', 3.74, 28, 0.1942, 3.3460, 4.1431, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.4', 'LV', 4.81, 29, 0.1964, 4.4116, 5.2162, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.5', 'IM', 2.94, 29, 0.3176, 2.2917, 3.5929, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.5', 'LV', 3.12, 28, 0.2568, 2.5972, 3.6512, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.6', 'IM', 2.66, 29, 0.2584, 2.1325, 3.1913, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.6', 'LV', 2.72, 29, 0.3506, 1.9972, 3.4335, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.7', 'IM', 3.97, 29, 0.2515, 3.4546, 4.4851, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.7', 'LV', 4.78, 28, 0.3279, 4.1044, 5.4500, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.8', 'IM', 2.91, 29, 0.2497, 2.3987, 3.4216, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.a.8', 'LV', 3.15, 28, 0.3583, 2.4128, 3.8832, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.b.1', 'IM', 4.02, 29, 0.2172, 3.5717, 4.4617, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.b.1', 'LV', 5.01, 28, 0.3226, 4.3488, 5.6728, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.b.2', 'IM', 3.90, 29, 0.2137, 3.4581, 4.3335, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.b.2', 'LV', 4.07, 28, 0.3560, 3.3420, 4.8029, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.b.3', 'IM', 3.71, 29, 0.1529, 3.3978, 4.0242, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.b.3', 'LV', 3.70, 28, 0.2305, 3.2280, 4.1740, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.b.4', 'IM', 3.74, 28, 0.1903, 3.3468, 4.1278, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.b.4', 'LV', 4.64, 28, 0.2027, 4.2290, 5.0610, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.b.5', 'IM', 3.63, 28, 0.1719, 3.2729, 3.9782, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.b.5', 'LV', 4.06, 28, 0.2880, 3.4732, 4.6550, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.b.6', 'IM', 3.20, 29, 0.2276, 2.7298, 3.6622, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.b.6', 'LV', 4.36, 28, 0.3240, 3.6930, 5.0228, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.c.1', 'IM', 3.64, 29, 0.2557, 3.1184, 4.1662, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.c.1', 'LV', 4.16, 28, 0.3614, 3.4202, 4.9034, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.c.2', 'IM', 3.26, 29, 0.2327, 2.7821, 3.7352, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.c.2', 'LV', 3.94, 28, 0.3705, 3.1797, 4.7003, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.c.3', 'IM', 3.84, 29, 0.1817, 3.4663, 4.2105, 'N', NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '4.A.4.c.3', 'LV', 4.48, 28, 0.2832, 3.8945, 5.0567, 'N', 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.1.a.1', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.1.a.1', 'LV', 5.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.1.a.2', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.1.a.2', 'LV', 4.95, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.1.b.1', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.1.b.1', 'LV', 4.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.1.b.2', 'IM', 3.58, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.1.b.2', 'LV', 4.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.1.b.3', 'IM', 3.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.1.b.3', 'LV', 3.89, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.a.1', 'IM', 3.84, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.a.1', 'LV', 4.53, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.a.2', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.a.2', 'LV', 4.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.a.3', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.a.3', 'LV', 4.90, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.a.4', 'IM', 4.11, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.a.4', 'LV', 5.15, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.b.1', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.b.1', 'LV', 5.60, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.b.2', 'IM', 3.79, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.b.2', 'LV', 4.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.b.3', 'IM', 4.16, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.b.3', 'LV', 5.42, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.b.4', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.b.4', 'LV', 4.95, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.b.5', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.b.5', 'LV', 5.15, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.b.6', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.2.b.6', 'LV', 5.35, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.a.1', 'IM', 3.11, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.a.1', 'LV', 3.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.a.2', 'IM', 2.65, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.a.2', 'LV', 3.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.a.3', 'IM', 2.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.a.3', 'LV', 2.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.a.4', 'IM', 2.50, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.a.4', 'LV', 2.25, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.b.1', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.b.1', 'LV', 4.60, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.b.2', 'IM', 2.75, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.b.2', 'LV', 3.30, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.b.4', 'IM', 2.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.b.4', 'LV', 2.45, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.b.5', 'IM', 2.53, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.b.5', 'LV', 2.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.b.6', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.3.b.6', 'LV', 4.63, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.1', 'IM', 3.68, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.1', 'LV', 4.00, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.2', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.2', 'LV', 5.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.3', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.3', 'LV', 4.85, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.4', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.4', 'LV', 5.55, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.5', 'IM', 3.74, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.5', 'LV', 4.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.6', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.6', 'LV', 4.45, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.7', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.7', 'LV', 5.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.8', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.a.8', 'LV', 4.15, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.b.1', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.b.1', 'LV', 4.95, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.b.2', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.b.2', 'LV', 4.90, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.b.3', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.b.3', 'LV', 4.95, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.b.4', 'IM', 4.21, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.b.4', 'LV', 5.15, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.b.5', 'IM', 4.32, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.b.5', 'LV', 5.45, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.b.6', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.b.6', 'LV', 5.40, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.c.1', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.c.1', 'LV', 4.10, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.c.2', 'IM', 3.89, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.c.2', 'LV', 5.10, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.c.3', 'IM', 3.74, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.01', '4.A.4.c.3', 'LV', 4.79, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.a.1', 'IM', 4.43, 29, 0.1432, 4.1338, 4.7204, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.a.1', 'LV', 5.09, 29, 0.2816, 4.5157, 5.6692, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.a.2', 'IM', 3.79, 29, 0.2239, 3.3352, 4.2527, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.a.2', 'LV', 5.33, 29, 0.2218, 4.8783, 5.7868, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.b.1', 'IM', 4.31, 29, 0.1317, 4.0412, 4.5806, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.b.1', 'LV', 5.14, 29, 0.3096, 4.5059, 5.7744, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.b.2', 'IM', 2.96, 29, 0.2966, 2.3539, 3.5690, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.b.2', 'LV', 3.35, 29, 0.5594, 2.2036, 4.4954, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.b.3', 'IM', 3.64, 29, 0.2322, 3.1622, 4.1134, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.b.3', 'LV', 4.11, 29, 0.3896, 3.3092, 4.9052, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.1', 'IM', 3.86, 29, 0.1745, 3.5068, 4.2215, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.1', 'LV', 4.79, 29, 0.3078, 4.1633, 5.4241, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.2', 'IM', 3.94, 29, 0.2487, 3.4345, 4.4532, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.2', 'LV', 5.21, 29, 0.2547, 4.6856, 5.7291, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.3', 'IM', 3.72, 29, 0.2562, 3.1966, 4.2462, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.3', 'LV', 4.59, 29, 0.3843, 3.8016, 5.3758, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.4', 'IM', 4.25, 29, 0.2015, 3.8341, 4.6596, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.4', 'LV', 4.94, 29, 0.3252, 4.2718, 5.6040, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.1', 'IM', 4.51, 28, 0.1739, 4.1524, 4.8660, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.1', 'LV', 5.16, 29, 0.2899, 4.5677, 5.7552, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.2', 'IM', 3.58, 29, 0.3440, 2.8776, 4.2868, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.2', 'LV', 5.20, 29, 0.5317, 4.1114, 6.2896, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.3', 'IM', 3.89, 29, 0.3582, 3.1588, 4.6263, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.3', 'LV', 5.35, 29, 0.6302, 4.0593, 6.6411, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.4', 'IM', 3.99, 29, 0.1137, 3.7599, 4.2256, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.4', 'LV', 4.63, 29, 0.2870, 4.0446, 5.2206, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.5', 'IM', 3.72, 29, 0.2507, 3.2110, 4.2380, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.5', 'LV', 4.53, 29, 0.2800, 3.9529, 5.0999, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.6', 'IM', 4.31, 29, 0.1490, 4.0088, 4.6193, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.6', 'LV', 6.00, 29, 0.0988, 5.7988, 6.2034, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.1', 'IM', 2.01, 29, 0.2757, 1.4477, 2.5773, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.1', 'LV', 1.89, 29, 0.5915, 0.6797, 3.1030, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.2', 'IM', 1.65, 28, 0.1556, 1.3302, 1.9687, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.2', 'LV', 2.36, 29, 0.5862, 1.1619, 3.5636, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.3', 'IM', 1.98, 29, 0.4085, 1.1395, 2.8131, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.3', 'LV', 1.54, 29, 0.6176, 0.2703, 2.8004, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.4', 'IM', 1.63, 29, 0.3046, 1.0080, 2.2558, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.4', 'LV', 1.06, 29, 0.5077, 0.0202, 2.1000, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.1', 'IM', 4.90, 28, 0.0718, 4.7549, 5.0000, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.1', 'LV', 6.10, 29, 0.3404, 5.4035, 6.7981, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.2', 'IM', 1.98, 29, 0.3355, 1.2894, 2.6639, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.2', 'LV', 1.91, 29, 0.6199, 0.6425, 3.1820, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.4', 'IM', 1.48, 29, 0.2696, 1.0000, 2.0372, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.4', 'LV', 0.99, 29, 0.5604, 0.0000, 2.1395, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.5', 'IM', 1.99, 29, 0.3445, 1.2819, 2.6934, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.5', 'LV', 1.78, 29, 0.6362, 0.4719, 3.0783, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.6', 'IM', 3.36, 29, 0.2527, 2.8421, 3.8774, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.6', 'LV', 4.11, 29, 0.3271, 3.4364, 4.7762, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.1', 'IM', 3.56, 29, 0.1842, 3.1870, 3.9415, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.1', 'LV', 4.25, 29, 0.2017, 3.8347, 4.6610, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.2', 'IM', 4.36, 28, 0.1501, 4.0546, 4.6707, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.2', 'LV', 5.25, 29, 0.2958, 4.6445, 5.8565, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.3', 'IM', 3.13, 28, 0.4774, 2.1489, 4.1081, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.3', 'LV', 3.20, 28, 0.7037, 1.7576, 4.6454, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.4', 'IM', 3.90, 29, 0.1741, 3.5391, 4.2523, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.4', 'LV', 5.06, 29, 0.2035, 4.6428, 5.4764, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.5', 'IM', 2.38, 29, 0.2146, 1.9361, 2.8151, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.5', 'LV', 2.34, 29, 0.3413, 1.6386, 3.0369, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.6', 'IM', 3.11, 29, 0.1848, 2.7283, 3.4854, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.6', 'LV', 3.69, 29, 0.3300, 3.0171, 4.3690, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.7', 'IM', 3.50, 29, 0.2109, 3.0669, 3.9308, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.7', 'LV', 4.68, 29, 0.2674, 4.1292, 5.2246, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.8', 'IM', 1.81, 28, 0.3106, 1.1743, 2.4491, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.8', 'LV', 1.52, 29, 0.5458, 0.3974, 2.6336, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.1', 'IM', 3.90, 29, 0.3736, 3.1331, 4.6636, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.1', 'LV', 5.16, 29, 0.2644, 4.6184, 5.7015, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.2', 'IM', 4.12, 29, 0.1757, 3.7613, 4.4810, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.2', 'LV', 4.80, 29, 0.3146, 4.1533, 5.4421, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.3', 'IM', 3.20, 29, 0.2265, 2.7409, 3.6689, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.3', 'LV', 3.82, 29, 0.4054, 2.9900, 4.6507, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.4', 'IM', 3.98, 29, 0.2155, 3.5356, 4.4184, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.4', 'LV', 5.01, 29, 0.2983, 4.4004, 5.6225, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.5', 'IM', 3.76, 28, 0.2519, 3.2456, 4.2794, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.5', 'LV', 5.00, 29, 0.2771, 4.4322, 5.5674, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.6', 'IM', 3.45, 29, 0.3395, 2.7574, 4.1484, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.6', 'LV', 5.28, 29, 0.3991, 4.4588, 6.0940, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.c.1', 'IM', 3.15, 29, 0.2411, 2.6592, 3.6470, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.c.1', 'LV', 4.06, 29, 0.3372, 3.3678, 4.7494, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.c.2', 'IM', 3.58, 29, 0.2801, 3.0048, 4.1521, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.c.2', 'LV', 4.46, 28, 0.4384, 3.5621, 5.3613, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.c.3', 'IM', 3.58, 27, 0.2443, 3.0757, 4.0800, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.c.3', 'LV', 4.48, 29, 0.3400, 3.7793, 5.1724, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.1.a.1', 'IM', 4.23, 22, 0.1139, 3.9913, 4.4651, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.1.a.1', 'LV', 4.95, 22, 0.3594, 4.2072, 5.7019, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.1.a.2', 'IM', 3.11, 22, 0.3108, 2.4591, 3.7517, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.1.a.2', 'LV', 3.65, 22, 0.6077, 2.3859, 4.9136, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.1.b.1', 'IM', 3.32, 21, 0.2897, 2.7188, 3.9273, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.1.b.1', 'LV', 3.87, 22, 0.5199, 2.7886, 4.9509, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.1.b.2', 'IM', 2.15, 22, 0.5281, 1.0514, 3.2480, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.1.b.2', 'LV', 1.34, 22, 0.5748, 0.1465, 2.5372, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.1.b.3', 'IM', 2.66, 22, 0.3666, 1.8995, 3.4243, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.1.b.3', 'LV', 2.11, 22, 0.3553, 1.3687, 2.8466, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.a.1', 'IM', 3.72, 21, 0.1432, 3.4251, 4.0227, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.a.1', 'LV', 4.33, 22, 0.1525, 4.0178, 4.6521, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.a.2', 'IM', 4.27, 22, 0.1070, 4.0506, 4.4956, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.a.2', 'LV', 4.85, 22, 0.1719, 4.4905, 5.2057, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.a.3', 'IM', 4.22, 21, 0.2867, 3.6239, 4.8201, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.a.3', 'LV', 4.40, 21, 0.2583, 3.8578, 4.9355, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.a.4', 'IM', 3.95, 22, 0.1164, 3.7108, 4.1952, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.a.4', 'LV', 4.37, 22, 0.1725, 4.0125, 4.7300, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.b.1', 'IM', 4.22, 22, 0.2901, 3.6196, 4.8263, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.b.1', 'LV', 4.92, 22, 0.4026, 4.0818, 5.7563, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.b.2', 'IM', 3.07, 22, 0.1720, 2.7151, 3.4307, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.b.2', 'LV', 3.49, 21, 0.2058, 3.0601, 3.9185, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.b.3', 'IM', 3.78, 22, 0.1514, 3.4653, 4.0950, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.b.3', 'LV', 4.82, 22, 0.1893, 4.4304, 5.2177, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.b.4', 'IM', 3.60, 22, 0.2226, 3.1399, 4.0660, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.b.4', 'LV', 4.17, 22, 0.3194, 3.5010, 4.8293, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.b.5', 'IM', 3.64, 22, 0.2269, 3.1706, 4.1144, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.b.5', 'LV', 4.19, 22, 0.1397, 3.8979, 4.4790, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.b.6', 'IM', 4.06, 22, 0.3150, 3.4067, 4.7167, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.2.b.6', 'LV', 5.07, 22, 0.2300, 4.5883, 5.5450, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.a.1', 'IM', 1.88, 22, 0.1747, 1.5193, 2.2457, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.a.1', 'LV', 1.30, 22, 0.2151, 0.8480, 1.7428, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.a.2', 'IM', 1.52, 22, 0.1080, 1.2924, 1.7415, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.a.2', 'LV', 1.23, 22, 0.2791, 0.6535, 1.8145, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.a.3', 'IM', 1.78, 22, 0.2766, 1.2079, 2.3583, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.a.3', 'LV', 1.24, 22, 0.4395, 0.3308, 2.1589, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.a.4', 'IM', 1.74, 21, 0.3814, 1.0000, 2.5339, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.a.4', 'LV', 1.07, 22, 0.5204, 0.0000, 2.1475, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.b.1', 'IM', 4.34, 21, 0.2851, 3.7458, 4.9351, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.b.1', 'LV', 3.50, 22, 0.1591, 3.1713, 3.8330, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.b.2', 'IM', 1.28, 21, 0.1135, 1.0399, 1.5133, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.b.2', 'LV', 0.53, 21, 0.2563, 0.0000, 1.0613, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.b.4', 'IM', 1.13, 22, 0.0911, 1.0000, 1.3191, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.b.4', 'LV', 0.47, 21, 0.3592, 0.0000, 1.2223, 'Y', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.b.5', 'IM', 1.36, 22, 0.1954, 1.0000, 1.7669, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.b.5', 'LV', 0.63, 22, 0.3478, 0.0000, 1.3543, 'Y', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.b.6', 'IM', 3.61, 22, 0.1187, 3.3613, 3.8549, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.3.b.6', 'LV', 3.54, 22, 0.1132, 3.3034, 3.7742, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.1', 'IM', 3.27, 22, 0.1664, 2.9267, 3.6188, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.1', 'LV', 3.30, 22, 0.2838, 2.7141, 3.8944, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.2', 'IM', 4.28, 22, 0.1172, 4.0364, 4.5239, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.2', 'LV', 4.86, 22, 0.2262, 4.3901, 5.3312, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.3', 'IM', 3.54, 22, 0.2583, 3.0020, 4.0765, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.3', 'LV', 3.73, 22, 0.3192, 3.0671, 4.3949, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.4', 'IM', 4.31, 22, 0.1321, 4.0338, 4.5833, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.4', 'LV', 4.91, 22, 0.1523, 4.5889, 5.2224, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.5', 'IM', 2.37, 22, 0.3299, 1.6813, 3.0533, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.5', 'LV', 2.71, 21, 0.3463, 1.9869, 3.4316, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.6', 'IM', 2.74, 22, 0.5521, 1.5923, 3.8885, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.6', 'LV', 2.90, 22, 0.9120, 1.0028, 4.7962, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.7', 'IM', 3.12, 22, 0.2621, 2.5743, 3.6644, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.7', 'LV', 3.93, 22, 0.3762, 3.1476, 4.7124, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.8', 'IM', 3.35, 22, 0.4386, 2.4378, 4.2622, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.a.8', 'LV', 3.59, 22, 0.5277, 2.4907, 4.6854, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.b.1', 'IM', 4.01, 22, 0.1228, 3.7559, 4.2667, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.b.1', 'LV', 4.40, 22, 0.1726, 4.0389, 4.7567, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.b.2', 'IM', 3.71, 22, 0.4312, 2.8181, 4.6115, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.b.2', 'LV', 3.28, 22, 0.5378, 2.1649, 4.4017, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.b.3', 'IM', 3.49, 21, 0.2622, 2.9447, 4.0388, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.b.3', 'LV', 3.84, 21, 0.2733, 3.2731, 4.4131, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.b.4', 'IM', 4.09, 22, 0.2159, 3.6363, 4.5344, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.b.4', 'LV', 4.61, 22, 0.2234, 4.1408, 5.0700, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.b.5', 'IM', 4.16, 22, 0.1953, 3.7506, 4.5629, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.b.5', 'LV', 4.73, 22, 0.2934, 4.1223, 5.3428, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.b.6', 'IM', 3.38, 22, 0.1659, 3.0338, 3.7238, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.b.6', 'LV', 4.19, 22, 0.2305, 3.7127, 4.6714, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.c.1', 'IM', 3.36, 21, 0.2000, 2.9449, 3.7791, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.c.1', 'LV', 3.99, 22, 0.3249, 3.3097, 4.6609, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.c.2', 'IM', 2.87, 22, 0.3244, 2.1932, 3.5426, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.c.2', 'LV', 3.18, 22, 0.4321, 2.2852, 4.0822, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.c.3', 'IM', 2.67, 22, 0.2788, 2.0943, 3.2540, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.A.4.c.3', 'LV', 3.12, 22, 0.4332, 2.2141, 4.0159, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.a.1', 'IM', 4.76, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.a.1', 'LV', 5.32, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.a.2', 'IM', 3.04, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.a.2', 'LV', 3.76, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.b.1', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.b.1', 'LV', 4.88, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.b.2', 'IM', 1.56, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.b.2', 'LV', 1.04, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.b.3', 'IM', 3.16, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.b.3', 'LV', 3.54, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.1', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.1', 'LV', 4.58, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.2', 'IM', 4.28, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.2', 'LV', 5.44, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.3', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.3', 'LV', 4.62, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.4', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.4', 'LV', 5.92, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.1', 'IM', 4.75, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.1', 'LV', 5.78, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.2', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.2', 'LV', 4.58, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.3', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.3', 'LV', 5.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.4', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.4', 'LV', 5.29, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.5', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.5', 'LV', 4.71, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.6', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.6', 'LV', 5.61, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.1', 'IM', 1.38, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.1', 'LV', 0.52, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.2', 'IM', 1.32, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.2', 'LV', 0.76, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.3', 'IM', 1.36, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.3', 'LV', 0.68, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.4', 'IM', 1.17, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.4', 'LV', 0.29, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.1', 'IM', 4.44, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.1', 'LV', 4.12, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.2', 'IM', 1.16, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.2', 'LV', 0.32, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.4', 'IM', 1.00, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.4', 'LV', 0.00, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.5', 'IM', 1.12, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.5', 'LV', 0.24, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.6', 'IM', 3.60, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.6', 'LV', 4.21, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.1', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.1', 'LV', 4.75, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.2', 'IM', 4.68, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.2', 'LV', 5.71, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.3', 'IM', 4.44, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.3', 'LV', 5.38, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.4', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.4', 'LV', 5.67, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.5', 'IM', 2.54, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.5', 'LV', 2.56, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.6', 'IM', 3.12, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.6', 'LV', 3.83, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.7', 'IM', 3.50, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.7', 'LV', 4.96, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.8', 'IM', 1.96, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.8', 'LV', 1.70, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.1', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.1', 'LV', 4.54, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.2', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.2', 'LV', 4.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.3', 'IM', 3.24, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.3', 'LV', 4.00, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.4', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.4', 'LV', 5.17, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.5', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.5', 'LV', 5.00, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.6', 'IM', 3.72, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.6', 'LV', 5.17, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.c.1', 'IM', 3.08, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.c.1', 'LV', 4.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.c.2', 'IM', 3.32, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.c.2', 'LV', 4.46, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.c.3', 'IM', 3.68, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.c.3', 'LV', 4.96, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.1.a.1', 'IM', 4.84, 27, 0.0596, 4.7137, 4.9588, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.1.a.1', 'LV', 5.85, 26, 0.1951, 5.4463, 6.2500, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.1.a.2', 'IM', 2.97, 27, 0.2770, 2.4026, 3.5414, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.1.a.2', 'LV', 3.46, 25, 0.4609, 2.5043, 4.4066, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.1.b.1', 'IM', 4.38, 27, 0.1380, 4.0989, 4.6664, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.1.b.1', 'LV', 5.17, 26, 0.2521, 4.6495, 5.6882, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.1.b.2', 'IM', 1.76, 27, 0.2599, 1.2214, 2.2900, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.1.b.2', 'LV', 0.99, 26, 0.4090, 0.1505, 1.8352, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.1.b.3', 'IM', 3.77, 27, 0.2812, 3.1871, 4.3431, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.1.b.3', 'LV', 4.58, 26, 0.2940, 3.9778, 5.1886, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.a.1', 'IM', 3.68, 27, 0.2191, 3.2255, 4.1263, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.a.1', 'LV', 4.85, 26, 0.2705, 4.2952, 5.4096, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.a.2', 'IM', 4.45, 27, 0.1430, 4.1576, 4.7454, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.a.2', 'LV', 5.72, 26, 0.3266, 5.0454, 6.3907, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.a.3', 'IM', 3.48, 27, 0.2147, 3.0421, 3.9246, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.a.3', 'LV', 4.16, 26, 0.4804, 3.1686, 5.1474, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.a.4', 'IM', 4.75, 27, 0.1004, 4.5473, 4.9599, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.a.4', 'LV', 5.94, 26, 0.2234, 5.4776, 6.3977, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.b.1', 'IM', 4.49, 27, 0.1052, 4.2754, 4.7078, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.b.1', 'LV', 5.49, 26, 0.2515, 4.9749, 6.0110, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.b.2', 'IM', 3.73, 27, 0.2871, 3.1369, 4.3174, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.b.2', 'LV', 4.83, 26, 0.5166, 3.7706, 5.8987, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.b.3', 'IM', 3.96, 27, 0.3563, 3.2301, 4.6948, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.b.3', 'LV', 5.20, 26, 0.3769, 4.4264, 5.9788, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.b.4', 'IM', 3.60, 27, 0.2477, 3.0915, 4.1100, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.b.4', 'LV', 4.17, 25, 0.4814, 3.1724, 5.1594, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.b.5', 'IM', 2.76, 27, 0.2011, 2.3477, 3.1745, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.b.5', 'LV', 3.21, 26, 0.3720, 2.4404, 3.9727, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.b.6', 'IM', 4.01, 27, 0.1715, 3.6571, 4.3622, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.2.b.6', 'LV', 4.59, 26, 0.2778, 4.0194, 5.1636, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.a.1', 'IM', 1.20, 27, 0.0971, 1.0041, 1.4034, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.a.1', 'LV', 0.32, 26, 0.1752, 0.0000, 0.6777, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.a.2', 'IM', 1.16, 27, 0.0817, 1.0000, 1.3317, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.a.2', 'LV', 0.40, 27, 0.2069, 0.0000, 0.8295, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.a.3', 'IM', 1.25, 27, 0.1120, 1.0210, 1.4813, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.a.3', 'LV', 0.44, 26, 0.2326, 0.0000, 0.9154, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.a.4', 'IM', 1.14, 27, 0.0813, 1.0000, 1.3030, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.a.4', 'LV', 0.27, 27, 0.1626, 0.0000, 0.6059, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.b.1', 'IM', 4.43, 27, 0.1480, 4.1285, 4.7370, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.b.1', 'LV', 4.11, 26, 0.3739, 3.3442, 4.8843, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.b.2', 'IM', 1.06, 27, 0.0559, 1.0000, 1.1740, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.b.2', 'LV', 0.12, 27, 0.1118, 0.0000, 0.3479, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.b.4', 'IM', 1.00, 27, 0.0000, NULL, NULL, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.b.4', 'LV', 0.00, 27, 0.0000, NULL, NULL, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.b.5', 'IM', 1.06, 27, 0.0578, 1.0000, 1.1779, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.b.5', 'LV', 0.12, 27, 0.1157, 0.0000, 0.3558, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.b.6', 'IM', 3.27, 27, 0.2108, 2.8369, 3.7037, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.3.b.6', 'LV', 4.10, 26, 0.3699, 3.3419, 4.8655, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.1', 'IM', 3.73, 27, 0.2417, 3.2350, 4.2287, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.1', 'LV', 4.61, 25, 0.4366, 3.7123, 5.5146, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.2', 'IM', 4.21, 27, 0.1721, 3.8530, 4.5604, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.2', 'LV', 4.94, 26, 0.2642, 4.3916, 5.4799, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.3', 'IM', 4.04, 27, 0.0965, 3.8455, 4.2424, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.3', 'LV', 5.19, 26, 0.3429, 4.4804, 5.8928, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.4', 'IM', 3.73, 27, 0.2185, 3.2805, 4.1786, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.4', 'LV', 4.89, 26, 0.2901, 4.2950, 5.4899, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.5', 'IM', 1.82, 25, 0.2376, 1.3282, 2.3089, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.5', 'LV', 1.40, 26, 0.3329, 0.7139, 2.0852, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.6', 'IM', 3.11, 27, 0.2396, 2.6187, 3.6038, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.6', 'LV', 4.06, 25, 0.3439, 3.3549, 4.7745, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.7', 'IM', 2.61, 27, 0.3201, 1.9495, 3.2653, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.7', 'LV', 3.26, 26, 0.5857, 2.0497, 4.4623, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.8', 'IM', 2.02, 27, 0.2798, 1.4489, 2.5993, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.a.8', 'LV', 1.73, 27, 0.4344, 0.8350, 2.6210, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.b.1', 'IM', 2.65, 27, 0.2320, 2.1722, 3.1260, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.b.1', 'LV', 3.15, 26, 0.4128, 2.3032, 4.0037, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.b.2', 'IM', 3.13, 27, 0.2738, 2.5672, 3.6928, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.b.2', 'LV', 3.35, 26, 0.4606, 2.3967, 4.2941, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.b.3', 'IM', 3.10, 27, 0.2345, 2.6176, 3.5814, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.b.3', 'LV', 4.07, 26, 0.3222, 3.4032, 4.7305, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.b.4', 'IM', 2.77, 27, 0.2943, 2.1677, 3.3774, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.b.4', 'LV', 3.08, 26, 0.3364, 2.3854, 3.7710, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.b.5', 'IM', 3.08, 26, 0.2388, 2.5917, 3.5754, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.b.5', 'LV', 3.96, 26, 0.3335, 3.2769, 4.6505, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.b.6', 'IM', 2.92, 27, 0.1605, 2.5918, 3.2518, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.b.6', 'LV', 4.04, 26, 0.3149, 3.3922, 4.6893, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.c.1', 'IM', 2.07, 27, 0.1632, 1.7338, 2.4046, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.c.1', 'LV', 2.14, 26, 0.2631, 1.5988, 2.6826, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.c.2', 'IM', 1.99, 27, 0.2485, 1.4742, 2.4958, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.c.2', 'LV', 1.94, 26, 0.4895, 0.9278, 2.9443, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.c.3', 'IM', 2.21, 27, 0.3147, 1.5615, 2.8553, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '4.A.4.c.3', 'LV', 2.52, 26, 0.5714, 1.3401, 3.6936, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.a.1', 'IM', 4.46, 37, 0.1249, 4.2076, 4.7142, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.a.1', 'LV', 4.28, 37, 0.2449, 3.7820, 4.7752, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.a.2', 'IM', 4.19, 37, 0.1608, 3.8678, 4.5200, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.a.2', 'LV', 4.82, 37, 0.3186, 4.1736, 5.4659, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.b.1', 'IM', 3.95, 37, 0.1458, 3.6571, 4.2487, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.b.1', 'LV', 3.97, 36, 0.3455, 3.2644, 4.6674, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.b.2', 'IM', 4.02, 36, 0.1567, 3.6987, 4.3347, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.b.2', 'LV', 3.95, 35, 0.2557, 3.4325, 4.4720, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.b.3', 'IM', 3.52, 37, 0.1592, 3.1928, 3.8385, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.b.3', 'LV', 3.27, 37, 0.1966, 2.8679, 3.6655, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.1', 'IM', 3.67, 37, 0.1903, 3.2871, 4.0590, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.1', 'LV', 3.72, 37, 0.2689, 3.1733, 4.2638, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.2', 'IM', 3.77, 37, 0.2273, 3.3042, 4.2262, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.2', 'LV', 4.07, 37, 0.3117, 3.4378, 4.7021, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.3', 'IM', 3.63, 37, 0.2081, 3.2077, 4.0516, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.3', 'LV', 3.63, 37, 0.2926, 3.0388, 4.2257, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.4', 'IM', 3.47, 36, 0.1627, 3.1386, 3.7991, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.4', 'LV', 3.53, 37, 0.2907, 2.9385, 4.1176, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.1', 'IM', 4.43, 36, 0.1958, 4.0358, 4.8309, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.1', 'LV', 4.64, 37, 0.3405, 3.9493, 5.3302, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.2', 'IM', 3.57, 37, 0.1868, 3.1959, 3.9535, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.2', 'LV', 4.49, 37, 0.3568, 3.7618, 5.2089, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.3', 'IM', 3.65, 37, 0.1517, 3.3399, 3.9553, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.3', 'LV', 4.73, 37, 0.3140, 4.0964, 5.3700, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.4', 'IM', 3.54, 37, 0.1904, 3.1505, 3.9228, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.4', 'LV', 3.52, 37, 0.3863, 2.7393, 4.3061, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.5', 'IM', 3.61, 37, 0.2170, 3.1732, 4.0533, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.5', 'LV', 4.21, 37, 0.3043, 3.5943, 4.8285, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.6', 'IM', 3.84, 37, 0.1751, 3.4802, 4.1906, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.6', 'LV', 4.74, 37, 0.3035, 4.1289, 5.3600, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.1', 'IM', 3.06, 37, 0.2229, 2.6087, 3.5127, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.1', 'LV', 3.19, 37, 0.2675, 2.6456, 3.7306, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.2', 'IM', 3.31, 37, 0.2374, 2.8258, 3.7889, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.2', 'LV', 4.91, 37, 0.3846, 4.1296, 5.6897, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.3', 'IM', 3.57, 35, 0.2035, 3.1521, 3.9792, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.3', 'LV', 4.82, 36, 0.4682, 3.8687, 5.7698, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.4', 'IM', 2.79, 37, 0.2575, 2.2727, 3.3171, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.4', 'LV', 2.33, 37, 0.3578, 1.6030, 3.0541, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.1', 'IM', 4.30, 36, 0.2267, 3.8402, 4.7608, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.1', 'LV', 3.97, 36, 0.3583, 3.2402, 4.6950, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.2', 'IM', 2.68, 37, 0.2762, 2.1209, 3.2414, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.2', 'LV', 2.84, 37, 0.3972, 2.0393, 3.6505, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.4', 'IM', 2.83, 36, 0.3075, 2.2078, 3.4564, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.4', 'LV', 3.27, 37, 0.5327, 2.1866, 4.3473, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.5', 'IM', 2.72, 37, 0.3512, 2.0055, 3.4302, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.5', 'LV', 2.88, 37, 0.5418, 1.7823, 3.9797, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.6', 'IM', 3.70, 35, 0.1874, 3.3141, 4.0760, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.6', 'LV', 3.47, 37, 0.2548, 2.9539, 3.9876, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.1', 'IM', 3.39, 36, 0.1834, 3.0180, 3.7628, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.1', 'LV', 2.96, 36, 0.2584, 2.4330, 3.4823, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.2', 'IM', 4.19, 37, 0.1873, 3.8110, 4.5709, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.2', 'LV', 4.68, 37, 0.3580, 3.9581, 5.4104, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.3', 'IM', 3.32, 37, 0.2900, 2.7291, 3.9054, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.3', 'LV', 3.37, 37, 0.3796, 2.5988, 4.1387, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.4', 'IM', 3.86, 37, 0.2235, 3.4073, 4.3140, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.4', 'LV', 4.86, 37, 0.3148, 4.2194, 5.4965, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.5', 'IM', 2.54, 37, 0.2189, 2.0972, 2.9853, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.5', 'LV', 2.58, 37, 0.3860, 1.7981, 3.3637, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.6', 'IM', 2.49, 37, 0.3364, 1.8111, 3.1755, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.6', 'LV', 2.44, 37, 0.5314, 1.3660, 3.5216, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.7', 'IM', 3.64, 37, 0.2994, 3.0298, 4.2443, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.7', 'LV', 4.22, 37, 0.4637, 3.2793, 5.1602, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.8', 'IM', 2.25, 37, 0.3186, 1.6027, 2.8948, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.8', 'LV', 2.16, 37, 0.6203, 0.9034, 3.4196, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.1', 'IM', 3.75, 36, 0.2341, 3.2790, 4.2296, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.1', 'LV', 4.21, 37, 0.4245, 3.3516, 5.0733, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.2', 'IM', 3.74, 37, 0.2529, 3.2243, 4.2502, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.2', 'LV', 3.66, 37, 0.3214, 3.0104, 4.3140, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.3', 'IM', 3.47, 36, 0.2666, 2.9296, 4.0118, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.3', 'LV', 3.69, 37, 0.2935, 3.0907, 4.2810, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.4', 'IM', 3.71, 35, 0.2606, 3.1826, 4.2418, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.4', 'LV', 4.68, 37, 0.4174, 3.8302, 5.5232, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.5', 'IM', 3.78, 36, 0.2005, 3.3736, 4.1878, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.5', 'LV', 4.36, 37, 0.2847, 3.7803, 4.9350, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.6', 'IM', 3.13, 37, 0.2286, 2.6682, 3.5955, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.6', 'LV', 3.47, 37, 0.4743, 2.5040, 4.4280, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.c.1', 'IM', 3.12, 36, 0.2899, 2.5310, 3.7081, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.c.1', 'LV', 3.06, 36, 0.4627, 2.1234, 4.0022, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.c.2', 'IM', 3.01, 37, 0.3039, 2.3947, 3.6275, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.c.2', 'LV', 3.21, 37, 0.4555, 2.2874, 4.1352, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.c.3', 'IM', 3.45, 35, 0.2907, 2.8632, 4.0448, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.c.3', 'LV', 3.80, 37, 0.4266, 2.9350, 4.6652, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.a.1', 'IM', 4.36, 21, 0.1758, 3.9923, 4.7256, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.a.1', 'LV', 5.17, 21, 0.2082, 4.7365, 5.6053, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.a.2', 'IM', 4.21, 21, 0.3046, 3.5784, 4.8493, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.a.2', 'LV', 5.16, 20, 0.3647, 4.3981, 5.9247, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.b.1', 'IM', 4.64, 20, 0.1622, 4.2994, 4.9785, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.b.1', 'LV', 4.90, 21, 0.2219, 4.4382, 5.3639, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.b.2', 'IM', 4.09, 21, 0.2507, 3.5664, 4.6123, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.b.2', 'LV', 4.50, 21, 0.1695, 4.1476, 4.8545, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.b.3', 'IM', 3.96, 21, 0.2087, 3.5275, 4.3981, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.b.3', 'LV', 4.17, 21, 0.2615, 3.6231, 4.7141, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.1', 'IM', 4.15, 21, 0.1333, 3.8727, 4.4289, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.1', 'LV', 4.74, 21, 0.2484, 4.2237, 5.2601, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.2', 'IM', 4.22, 21, 0.2354, 3.7268, 4.7089, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.2', 'LV', 5.23, 21, 0.2604, 4.6886, 5.7749, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.3', 'IM', 4.54, 21, 0.1900, 4.1431, 4.9360, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.3', 'LV', 5.09, 21, 0.2588, 4.5460, 5.6258, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.4', 'IM', 4.63, 21, 0.1553, 4.3082, 4.9560, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.4', 'LV', 5.03, 21, 0.4336, 4.1233, 5.9323, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.1', 'IM', 4.30, 20, 0.1807, 3.9242, 4.6804, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.1', 'LV', 4.93, 21, 0.2525, 4.4003, 5.4536, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.2', 'IM', 3.57, 21, 0.2144, 3.1215, 4.0160, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.2', 'LV', 4.39, 21, 0.2314, 3.9090, 4.8746, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.3', 'IM', 4.16, 21, 0.1958, 3.7485, 4.5653, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.3', 'LV', 4.90, 21, 0.1760, 4.5298, 5.2641, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.4', 'IM', 3.57, 21, 0.2952, 2.9493, 4.1808, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.4', 'LV', 3.91, 21, 0.4120, 3.0462, 4.7652, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.5', 'IM', 3.53, 21, 0.2360, 3.0415, 4.0259, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.5', 'LV', 4.73, 21, 0.3192, 4.0638, 5.3954, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.6', 'IM', 4.27, 21, 0.1812, 3.8931, 4.6492, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.6', 'LV', 5.45, 21, 0.1948, 5.0407, 5.8533, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.1', 'IM', 2.49, 20, 0.2775, 1.9141, 3.0758, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.1', 'LV', 2.70, 21, 0.5181, 1.6180, 3.7796, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.2', 'IM', 2.43, 21, 0.3033, 1.7939, 3.0592, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.2', 'LV', 3.52, 21, 0.4104, 2.6616, 4.3738, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.3', 'IM', 2.96, 20, 0.3545, 2.2132, 3.6972, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.3', 'LV', 3.33, 21, 0.5155, 2.2555, 4.4062, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.4', 'IM', 2.06, 21, 0.3727, 1.2808, 2.8357, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.4', 'LV', 1.55, 21, 0.3515, 0.8123, 2.2789, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.1', 'IM', 4.56, 21, 0.1818, 4.1826, 4.9412, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.1', 'LV', 3.44, 21, 0.2065, 3.0062, 3.8678, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.2', 'IM', 2.51, 21, 0.3065, 1.8680, 3.1466, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.2', 'LV', 2.37, 21, 0.4485, 1.4301, 3.3014, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.4', 'IM', 2.17, 21, 0.2850, 1.5758, 2.7646, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.4', 'LV', 2.43, 21, 0.4715, 1.4460, 3.4132, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.5', 'IM', 2.33, 21, 0.2774, 1.7514, 2.9088, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.5', 'LV', 2.09, 21, 0.5036, 1.0442, 3.1453, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.6', 'IM', 4.78, 21, 0.1010, 4.5642, 4.9858, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.6', 'LV', 4.83, 21, 0.2357, 4.3409, 5.3244, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.1', 'IM', 4.19, 20, 0.2714, 3.6203, 4.7565, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.1', 'LV', 4.51, 21, 0.3865, 3.7071, 5.3197, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.2', 'IM', 4.80, 21, 0.0937, 4.6060, 4.9969, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.2', 'LV', 5.52, 21, 0.2145, 5.0754, 5.9701, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.3', 'IM', 3.73, 21, 0.2865, 3.1362, 4.3314, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.3', 'LV', 4.30, 21, 0.2854, 3.7006, 4.8911, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.4', 'IM', 4.20, 21, 0.1935, 3.7939, 4.6012, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.4', 'LV', 4.91, 21, 0.2674, 4.3494, 5.4649, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.5', 'IM', 2.30, 21, 0.3264, 1.6151, 2.9768, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.5', 'LV', 2.50, 21, 0.5797, 1.2948, 3.7131, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.6', 'IM', 2.45, 21, 0.2320, 1.9689, 2.9370, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.6', 'LV', 2.76, 21, 0.4421, 1.8369, 3.6812, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.7', 'IM', 3.71, 21, 0.3237, 3.0309, 4.3813, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.7', 'LV', 4.45, 21, 0.4532, 3.5026, 5.3934, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.8', 'IM', 1.69, 21, 0.2114, 1.2522, 2.1342, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.8', 'LV', 1.26, 21, 0.4264, 0.3663, 2.1453, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.1', 'IM', 3.70, 20, 0.2417, 3.1927, 4.2046, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.1', 'LV', 4.32, 20, 0.3030, 3.6865, 4.9550, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.2', 'IM', 3.88, 21, 0.1450, 3.5778, 4.1826, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.2', 'LV', 3.99, 21, 0.3311, 3.2949, 4.6763, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.3', 'IM', 3.89, 21, 0.2166, 3.4423, 4.3459, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.3', 'LV', 4.58, 21, 0.3335, 3.8888, 5.2800, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.4', 'IM', 3.79, 21, 0.2792, 3.2119, 4.3767, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.4', 'LV', 4.45, 21, 0.4645, 3.4777, 5.4155, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.5', 'IM', 3.67, 21, 0.1820, 3.2931, 4.0524, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.5', 'LV', 4.72, 21, 0.1760, 4.3518, 5.0860, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.6', 'IM', 3.84, 21, 0.2972, 3.2192, 4.4590, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.6', 'LV', 5.14, 21, 0.3777, 4.3532, 5.9291, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.c.1', 'IM', 3.22, 21, 0.2472, 2.7025, 3.7338, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.c.1', 'LV', 3.49, 21, 0.2723, 2.9178, 4.0539, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.c.2', 'IM', 3.41, 21, 0.2418, 2.9018, 3.9105, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.c.2', 'LV', 4.21, 21, 0.2560, 3.6759, 4.7438, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.c.3', 'IM', 3.18, 21, 0.2390, 2.6842, 3.6813, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.c.3', 'LV', 3.80, 21, 0.3917, 2.9835, 4.6179, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.a.1', 'IM', 4.47, 14, 0.1860, 4.0719, 4.8756, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.a.1', 'LV', 4.65, 14, 0.1142, 4.4014, 4.8949, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.a.2', 'IM', 4.20, 14, 0.1747, 3.8202, 4.5750, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.a.2', 'LV', 5.29, 14, 0.2644, 4.7170, 5.8593, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.b.1', 'IM', 4.21, 14, 0.1873, 3.8022, 4.6116, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.b.1', 'LV', 4.89, 14, 0.1902, 4.4823, 5.3041, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.b.2', 'IM', 3.79, 14, 0.2053, 3.3443, 4.2314, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.b.2', 'LV', 4.61, 14, 0.2066, 4.1648, 5.0577, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.b.3', 'IM', 3.53, 14, 0.1821, 3.1370, 3.9238, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.b.3', 'LV', 3.97, 14, 0.2683, 3.3930, 4.5523, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.1', 'IM', 3.94, 14, 0.1196, 3.6842, 4.2009, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.1', 'LV', 4.92, 14, 0.3255, 4.2159, 5.6222, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.2', 'IM', 3.98, 14, 0.1577, 3.6362, 4.3175, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.2', 'LV', 4.87, 14, 0.2283, 4.3728, 5.3592, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.3', 'IM', 4.12, 14, 0.2210, 3.6468, 4.6018, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.3', 'LV', 4.56, 14, 0.4162, 3.6605, 5.4590, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.4', 'IM', 3.62, 14, 0.2285, 3.1266, 4.1137, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.4', 'LV', 4.70, 14, 0.2170, 4.2337, 5.1715, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.1', 'IM', 4.38, 14, 0.1970, 3.9535, 4.8047, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.1', 'LV', 5.02, 14, 0.3261, 4.3190, 5.7278, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.2', 'IM', 3.69, 14, 0.2145, 3.2296, 4.1565, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.2', 'LV', 4.55, 14, 0.3681, 3.7592, 5.3495, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.3', 'IM', 4.02, 14, 0.1911, 3.6049, 4.4305, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.3', 'LV', 4.85, 14, 0.2010, 4.4164, 5.2848, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.4', 'IM', 3.46, 14, 0.1880, 3.0517, 3.8637, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.4', 'LV', 3.76, 14, 0.3461, 3.0155, 4.5107, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.5', 'IM', 4.45, 14, 0.1689, 4.0846, 4.8142, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.5', 'LV', 5.65, 14, 0.2226, 5.1655, 6.1275, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.6', 'IM', 4.61, 14, 0.1216, 4.3469, 4.8722, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.6', 'LV', 5.59, 14, 0.2932, 4.9540, 6.2209, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.1', 'IM', 2.30, 14, 0.1292, 2.0223, 2.5808, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.1', 'LV', 3.33, 14, 0.2517, 2.7871, 3.8744, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.2', 'IM', 2.18, 14, 0.2472, 1.6494, 2.7176, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.2', 'LV', 2.92, 14, 0.5058, 1.8273, 4.0126, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.3', 'IM', 2.41, 14, 0.3423, 1.6729, 3.1518, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.3', 'LV', 2.38, 14, 0.5152, 1.2668, 3.4930, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.4', 'IM', 2.98, 14, 0.2624, 2.4143, 3.5480, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.4', 'LV', 2.81, 14, 0.1895, 2.4031, 3.2220, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.1', 'IM', 4.43, 14, 0.1494, 4.1074, 4.7528, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.1', 'LV', 3.84, 14, 0.3180, 3.1532, 4.5273, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.2', 'IM', 3.02, 14, 0.2911, 2.3936, 3.6515, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.2', 'LV', 3.67, 14, 0.3786, 2.8552, 4.4911, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.4', 'IM', 3.11, 14, 0.3195, 2.4161, 3.7964, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.4', 'LV', 3.83, 14, 0.5500, 2.6404, 5.0167, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.5', 'IM', 2.79, 14, 0.3792, 1.9692, 3.6078, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.5', 'LV', 2.66, 14, 0.4370, 1.7185, 3.6065, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.6', 'IM', 3.72, 14, 0.4488, 2.7528, 4.6919, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.6', 'LV', 4.00, 14, 0.5294, 2.8607, 5.1481, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.1', 'IM', 3.38, 14, 0.2622, 2.8089, 3.9418, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.1', 'LV', 3.40, 14, 0.2929, 2.7700, 4.0355, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.2', 'IM', 4.67, 14, 0.1387, 4.3660, 4.9652, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.2', 'LV', 5.38, 14, 0.2597, 4.8141, 5.9361, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.3', 'IM', 3.92, 14, 0.2153, 3.4512, 4.3816, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.3', 'LV', 4.33, 14, 0.3093, 3.6645, 5.0007, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.4', 'IM', 4.09, 14, 0.2158, 3.6239, 4.5564, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.4', 'LV', 5.08, 14, 0.2451, 4.5500, 5.6091, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.5', 'IM', 3.15, 14, 0.2733, 2.5548, 3.7358, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.5', 'LV', 3.61, 14, 0.3870, 2.7776, 4.4497, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.6', 'IM', 2.97, 14, 0.2452, 2.4429, 3.5024, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.6', 'LV', 3.28, 14, 0.3252, 2.5768, 3.9820, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.7', 'IM', 3.52, 14, 0.2676, 2.9452, 4.1013, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.7', 'LV', 4.82, 14, 0.3352, 4.1008, 5.5492, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.8', 'IM', 1.88, 14, 0.2105, 1.4277, 2.3372, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.8', 'LV', 1.80, 14, 0.3888, 0.9565, 2.6363, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.1', 'IM', 4.13, 13, 0.1920, 3.7102, 4.5470, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.1', 'LV', 5.48, 13, 0.2799, 4.8722, 6.0921, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.2', 'IM', 4.28, 12, 0.2143, 3.8076, 4.7508, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.2', 'LV', 4.60, 13, 0.2777, 3.9994, 5.2096, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.3', 'IM', 3.76, 13, 0.2866, 3.1388, 4.3877, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.3', 'LV', 4.23, 13, 0.3124, 3.5529, 4.9143, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.4', 'IM', 3.86, 13, 0.2797, 3.2513, 4.4702, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.4', 'LV', 4.63, 13, 0.4496, 3.6521, 5.6112, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.5', 'IM', 3.73, 14, 0.2619, 3.1661, 4.2979, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.5', 'LV', 4.55, 14, 0.3102, 3.8842, 5.2244, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.6', 'IM', 3.57, 13, 0.2991, 2.9158, 4.2190, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.6', 'LV', 4.12, 14, 0.3515, 3.3624, 4.8812, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.c.1', 'IM', 3.73, 14, 0.1763, 3.3463, 4.1080, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.c.1', 'LV', 3.74, 14, 0.2250, 3.2576, 4.2300, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.c.2', 'IM', 3.29, 14, 0.3656, 2.5009, 4.0806, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.c.2', 'LV', 3.96, 14, 0.5222, 2.8303, 5.0867, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.c.3', 'IM', 4.12, 14, 0.1645, 3.7693, 4.4801, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.c.3', 'LV', 4.79, 14, 0.1794, 4.4013, 5.1763, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.1.a.1', 'IM', 4.21, 22, 0.1640, 3.8641, 4.5460, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.1.a.1', 'LV', 4.43, 22, 0.1824, 4.0475, 4.8062, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.1.a.2', 'IM', 4.34, 22, 0.1799, 3.9692, 4.7173, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.1.a.2', 'LV', 4.93, 22, 0.1730, 4.5730, 5.2927, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.1.b.1', 'IM', 4.05, 22, 0.1947, 3.6427, 4.4525, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.1.b.1', 'LV', 4.26, 21, 0.2209, 3.8037, 4.7254, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.1.b.2', 'IM', 3.48, 22, 0.2150, 3.0339, 3.9282, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.1.b.2', 'LV', 4.00, 22, 0.2358, 3.5144, 4.4951, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.1.b.3', 'IM', 3.37, 22, 0.1669, 3.0206, 3.7147, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.1.b.3', 'LV', 3.34, 22, 0.1844, 2.9610, 3.7279, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.a.1', 'IM', 3.34, 22, 0.1651, 2.9975, 3.6842, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.a.1', 'LV', 4.46, 22, 0.2535, 3.9305, 4.9850, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.a.2', 'IM', 3.81, 22, 0.1421, 3.5164, 4.1075, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.a.2', 'LV', 4.90, 22, 0.2790, 4.3211, 5.4816, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.a.3', 'IM', 3.60, 22, 0.1811, 3.2206, 3.9737, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.a.3', 'LV', 3.99, 22, 0.2691, 3.4317, 4.5510, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.a.4', 'IM', 3.86, 22, 0.2056, 3.4362, 4.2914, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.a.4', 'LV', 4.30, 22, 0.2091, 3.8661, 4.7359, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.b.1', 'IM', 4.36, 22, 0.1764, 3.9928, 4.7263, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.b.1', 'LV', 5.00, 22, 0.2955, 4.3833, 5.6125, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.b.2', 'IM', 3.53, 22, 0.1576, 3.2022, 3.8578, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.b.2', 'LV', 4.76, 22, 0.2613, 4.2145, 5.3012, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.b.3', 'IM', 3.45, 22, 0.1606, 3.1149, 3.7829, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.b.3', 'LV', 4.76, 22, 0.2998, 4.1375, 5.3846, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.b.4', 'IM', 3.13, 22, 0.2097, 2.6969, 3.5689, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.b.4', 'LV', 3.26, 22, 0.2751, 2.6832, 3.8274, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.b.5', 'IM', 3.31, 22, 0.2199, 2.8488, 3.7632, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.b.5', 'LV', 4.39, 22, 0.2534, 3.8626, 4.9167, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.b.6', 'IM', 3.51, 22, 0.1428, 3.2133, 3.8072, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.2.b.6', 'LV', 5.02, 22, 0.2403, 4.5157, 5.5151, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.a.1', 'IM', 2.52, 22, 0.1771, 2.1552, 2.8916, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.a.1', 'LV', 3.40, 22, 0.3195, 2.7401, 4.0689, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.a.2', 'IM', 2.09, 22, 0.2022, 1.6709, 2.5120, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.a.2', 'LV', 2.83, 22, 0.5000, 1.7855, 3.8652, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.a.3', 'IM', 3.14, 22, 0.2665, 2.5870, 3.6953, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.a.3', 'LV', 3.71, 22, 0.4171, 2.8405, 4.5755, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.a.4', 'IM', 2.21, 22, 0.1827, 1.8322, 2.5921, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.a.4', 'LV', 2.22, 22, 0.2844, 1.6263, 2.8092, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.b.1', 'IM', 4.05, 22, 0.2167, 3.5995, 4.5008, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.b.1', 'LV', 3.51, 22, 0.2723, 2.9453, 4.0777, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.b.2', 'IM', 2.29, 21, 0.1813, 1.9082, 2.6645, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.b.2', 'LV', 2.63, 21, 0.4631, 1.6683, 3.6003, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.b.4', 'IM', 2.36, 21, 0.2354, 1.8718, 2.8539, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.b.4', 'LV', 2.81, 21, 0.4711, 1.8261, 3.7915, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.b.5', 'IM', 2.31, 21, 0.2065, 1.8840, 2.7455, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.b.5', 'LV', 2.05, 21, 0.3253, 1.3743, 2.7315, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.b.6', 'IM', 3.50, 21, 0.1073, 3.2735, 3.7211, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.3.b.6', 'LV', 3.92, 21, 0.2147, 3.4684, 4.3639, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.1', 'IM', 3.49, 21, 0.1523, 3.1674, 3.8029, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.1', 'LV', 3.84, 21, 0.3360, 3.1375, 4.5391, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.2', 'IM', 4.18, 21, 0.1531, 3.8595, 4.4980, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.2', 'LV', 5.20, 21, 0.2326, 4.7110, 5.6816, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.3', 'IM', 3.25, 21, 0.2508, 2.7291, 3.7753, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.3', 'LV', 3.35, 21, 0.3255, 2.6742, 4.0323, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.4', 'IM', 3.64, 21, 0.1536, 3.3182, 3.9589, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.4', 'LV', 4.81, 21, 0.2080, 4.3730, 5.2409, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.5', 'IM', 2.37, 22, 0.2471, 1.8596, 2.8872, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.5', 'LV', 3.10, 22, 0.4431, 2.1778, 4.0206, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.6', 'IM', 2.57, 22, 0.1960, 2.1591, 2.9743, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.6', 'LV', 2.73, 22, 0.3690, 1.9667, 3.5013, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.7', 'IM', 3.46, 22, 0.1626, 3.1264, 3.8026, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.7', 'LV', 4.68, 22, 0.2616, 4.1327, 5.2206, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.8', 'IM', 1.85, 22, 0.2229, 1.3832, 2.3103, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.a.8', 'LV', 1.82, 22, 0.4171, 0.9544, 2.6891, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.b.1', 'IM', 3.83, 22, 0.1502, 3.5176, 4.1422, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.b.1', 'LV', 4.97, 22, 0.2512, 4.4458, 5.4904, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.b.2', 'IM', 3.84, 22, 0.1719, 3.4798, 4.1948, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.b.2', 'LV', 4.25, 22, 0.2773, 3.6736, 4.8269, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.b.3', 'IM', 3.86, 22, 0.1512, 3.5449, 4.1738, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.b.3', 'LV', 4.13, 22, 0.2647, 3.5766, 4.6775, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.b.4', 'IM', 4.04, 22, 0.1079, 3.8148, 4.2635, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.b.4', 'LV', 5.18, 22, 0.2321, 4.7015, 5.6668, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.b.5', 'IM', 3.68, 22, 0.1413, 3.3899, 3.9777, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.b.5', 'LV', 4.88, 22, 0.1866, 4.4954, 5.2716, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.b.6', 'IM', 3.15, 22, 0.2102, 2.7115, 3.5857, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.b.6', 'LV', 4.57, 22, 0.3886, 3.7583, 5.3747, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.c.1', 'IM', 3.13, 22, 0.1838, 2.7466, 3.5111, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.c.1', 'LV', 3.37, 22, 0.2288, 2.8950, 3.8468, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.c.2', 'IM', 3.46, 22, 0.1859, 3.0744, 3.8475, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.c.2', 'LV', 3.82, 22, 0.3155, 3.1681, 4.4804, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.c.3', 'IM', 3.45, 22, 0.1808, 3.0693, 3.8215, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '4.A.4.c.3', 'LV', 4.33, 22, 0.2417, 3.8284, 4.8335, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.a.1', 'IM', 4.26, 20, 0.0678, 4.1181, 4.4019, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.a.1', 'LV', 4.75, 20, 0.2012, 4.3297, 5.1721, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.a.2', 'IM', 4.34, 20, 0.0822, 4.1663, 4.5105, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.a.2', 'LV', 4.88, 20, 0.1133, 4.6454, 5.1196, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.b.1', 'IM', 4.02, 20, 0.0364, 3.9460, 4.0985, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.b.1', 'LV', 4.60, 19, 0.3305, 3.9037, 5.2925, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.b.2', 'IM', 3.70, 20, 0.2840, 3.1050, 4.2940, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.b.2', 'LV', 4.48, 20, 0.1241, 4.2183, 4.7379, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.b.3', 'IM', 3.38, 19, 0.2501, 2.8544, 3.9054, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.b.3', 'LV', 3.64, 19, 0.3094, 2.9937, 4.2939, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.1', 'IM', 3.81, 20, 0.1813, 3.4355, 4.1944, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.1', 'LV', 4.33, 19, 0.0612, 4.1995, 4.4568, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.2', 'IM', 4.34, 18, 0.1979, 3.9187, 4.7536, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.2', 'LV', 5.29, 19, 0.3161, 4.6254, 5.9534, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.3', 'IM', 3.90, 20, 0.2131, 3.4550, 4.3471, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.3', 'LV', 4.15, 20, 0.1774, 3.7814, 4.5241, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.4', 'IM', 4.01, 20, 0.1422, 3.7129, 4.3081, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.4', 'LV', 4.50, 19, 0.1382, 4.2121, 4.7927, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.1', 'IM', 4.18, 20, 0.1513, 3.8587, 4.4922, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.1', 'LV', 5.09, 19, 0.2258, 4.6167, 5.5657, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.2', 'IM', 3.61, 20, 0.2431, 3.0978, 4.1154, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.2', 'LV', 4.50, 19, 0.1370, 4.2125, 4.7882, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.3', 'IM', 3.39, 20, 0.3185, 2.7225, 4.0556, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.3', 'LV', 4.98, 19, 0.3130, 4.3205, 5.6357, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.4', 'IM', 3.66, 20, 0.0729, 3.5095, 3.8146, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.4', 'LV', 4.15, 19, 0.2085, 3.7087, 4.5849, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.5', 'IM', 4.23, 19, 0.1525, 3.9098, 4.5505, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.5', 'LV', 5.06, 19, 0.2807, 4.4668, 5.6463, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.6', 'IM', 4.42, 19, 0.1106, 4.1856, 4.6502, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.6', 'LV', 5.70, 20, 0.0585, 5.5738, 5.8188, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.1', 'IM', 2.27, 19, 0.2538, 1.7327, 2.7991, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.1', 'LV', 3.70, 18, 0.3143, 3.0401, 4.3663, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.2', 'IM', 2.68, 20, 0.3483, 1.9469, 3.4048, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.2', 'LV', 4.27, 19, 0.3745, 3.4881, 5.0617, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.3', 'IM', 3.76, 20, 0.1628, 3.4183, 4.0999, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.3', 'LV', 4.49, 19, 0.4423, 3.5604, 5.4189, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.4', 'IM', 2.92, 20, 0.0722, 2.7652, 3.0676, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.4', 'LV', 2.67, 19, 0.3013, 2.0364, 3.3026, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.1', 'IM', 4.51, 20, 0.1723, 4.1476, 4.8687, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.1', 'LV', 3.86, 19, 0.1422, 3.5660, 4.1637, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.2', 'IM', 2.73, 19, 0.0727, 2.5775, 2.8829, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.2', 'LV', 3.46, 19, 0.1632, 3.1204, 3.8062, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.4', 'IM', 3.81, 19, 0.1730, 3.4466, 4.1734, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.4', 'LV', 4.27, 19, 0.4711, 3.2769, 5.2565, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.5', 'IM', 3.55, 19, 0.1154, 3.3105, 3.7954, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.5', 'LV', 4.04, 19, 0.2091, 3.5993, 4.4777, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.6', 'IM', 3.84, 20, 0.1883, 3.4441, 4.2323, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.6', 'LV', 4.17, 18, 0.1625, 3.8301, 4.5157, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.1', 'IM', 2.75, 20, 0.1082, 2.5210, 2.9740, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.1', 'LV', 2.91, 19, 0.1239, 2.6491, 3.1699, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.2', 'IM', 4.09, 20, 0.1489, 3.7750, 4.3985, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.2', 'LV', 4.46, 19, 0.4225, 3.5694, 5.3445, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.3', 'IM', 2.65, 19, 0.2217, 2.1833, 3.1147, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.3', 'LV', 3.53, 19, 0.1626, 3.1848, 3.8678, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.4', 'IM', 3.90, 20, 0.1040, 3.6848, 4.1201, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.4', 'LV', 4.65, 20, 0.2423, 4.1438, 5.1581, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.5', 'IM', 2.54, 20, 0.4096, 1.6829, 3.3973, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.5', 'LV', 2.64, 20, 0.7430, 1.0814, 4.1916, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.6', 'IM', 2.34, 20, 0.4986, 1.2916, 3.3790, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.6', 'LV', 2.40, 19, 0.8000, 0.7197, 4.0813, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.7', 'IM', 3.23, 20, 0.4256, 2.3360, 4.1175, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.7', 'LV', 4.72, 19, 0.3007, 4.0883, 5.3518, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.8', 'IM', 1.67, 20, 0.5009, 1.0000, 2.7134, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.8', 'LV', 1.29, 19, 1.0065, 0.0000, 3.4087, 'Y', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.1', 'IM', 4.26, 20, 0.1083, 4.0297, 4.4832, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.1', 'LV', 4.40, 19, 0.5885, 3.1669, 5.6395, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.2', 'IM', 4.12, 20, 0.1321, 3.8470, 4.4001, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.2', 'LV', 4.71, 19, 0.0598, 4.5815, 4.8327, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.3', 'IM', 3.59, 19, 0.2398, 3.0876, 4.0954, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.3', 'LV', 3.99, 19, 0.5617, 2.8056, 5.1658, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.4', 'IM', 4.35, 20, 0.0825, 4.1785, 4.5237, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.4', 'LV', 4.82, 20, 0.4079, 3.9689, 5.6765, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.5', 'IM', 4.30, 20, 0.0939, 4.1008, 4.4939, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.5', 'LV', 4.74, 20, 0.3718, 3.9602, 5.5166, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.6', 'IM', 2.92, 20, 0.4626, 1.9549, 3.8912, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.6', 'LV', 3.60, 19, 0.7452, 2.0378, 5.1689, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.c.1', 'IM', 2.77, 20, 0.3852, 1.9651, 3.5777, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.c.1', 'LV', 3.16, 19, 0.2627, 2.6095, 3.7134, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.c.2', 'IM', 2.90, 20, 0.4433, 1.9716, 3.8274, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.c.2', 'LV', 4.14, 19, 0.3886, 3.3272, 4.9601, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.c.3', 'IM', 3.48, 20, 0.1266, 3.2147, 3.7449, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.c.3', 'LV', 4.89, 18, 0.1232, 4.6299, 5.1497, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.1.a.1', 'IM', 4.12, 29, 0.1651, 3.7817, 4.4580, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.1.a.1', 'LV', 4.45, 29, 0.1252, 4.1906, 4.7037, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.1.a.2', 'IM', 4.09, 29, 0.1520, 3.7782, 4.4007, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.1.a.2', 'LV', 4.97, 28, 0.1200, 4.7202, 5.2125, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.1.b.1', 'IM', 4.05, 29, 0.1151, 3.8129, 4.2843, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.1.b.1', 'LV', 4.52, 28, 0.1910, 4.1252, 4.9092, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.1.b.2', 'IM', 4.25, 29, 0.1638, 3.9156, 4.5867, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.1.b.2', 'LV', 4.78, 29, 0.1845, 4.4033, 5.1591, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.1.b.3', 'IM', 3.52, 29, 0.1594, 3.1906, 3.8439, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.1.b.3', 'LV', 3.64, 29, 0.1842, 3.2635, 4.0181, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.a.1', 'IM', 3.48, 29, 0.1514, 3.1716, 3.7919, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.a.1', 'LV', 4.33, 29, 0.1634, 3.9999, 4.6693, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.a.2', 'IM', 3.74, 29, 0.1387, 3.4572, 4.0254, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.a.2', 'LV', 4.44, 29, 0.1593, 4.1121, 4.7647, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.a.3', 'IM', 3.93, 29, 0.1629, 3.5981, 4.2656, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.a.3', 'LV', 4.28, 29, 0.2489, 3.7750, 4.7947, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.a.4', 'IM', 3.70, 29, 0.1600, 3.3747, 4.0303, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.a.4', 'LV', 4.24, 29, 0.2133, 3.8004, 4.6740, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.b.1', 'IM', 4.26, 29, 0.1223, 4.0096, 4.5107, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.b.1', 'LV', 5.10, 29, 0.1145, 4.8689, 5.3380, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.b.2', 'IM', 3.45, 29, 0.1594, 3.1271, 3.7803, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.b.2', 'LV', 4.23, 29, 0.2118, 3.7945, 4.6622, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.b.3', 'IM', 3.65, 29, 0.1022, 3.4363, 3.8550, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.b.3', 'LV', 4.81, 29, 0.1884, 4.4200, 5.1918, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.b.4', 'IM', 3.64, 29, 0.1340, 3.3679, 3.9170, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.b.4', 'LV', 4.12, 28, 0.2344, 3.6349, 4.5968, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.b.5', 'IM', 4.03, 29, 0.1412, 3.7441, 4.3226, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.b.5', 'LV', 4.84, 28, 0.1979, 4.4353, 5.2476, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.b.6', 'IM', 4.15, 29, 0.1443, 3.8555, 4.4465, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.2.b.6', 'LV', 5.31, 29, 0.2310, 4.8403, 5.7866, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.a.1', 'IM', 2.42, 29, 0.1799, 2.0529, 2.7901, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.a.1', 'LV', 2.99, 29, 0.3850, 2.2021, 3.7792, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.a.2', 'IM', 2.18, 29, 0.1828, 1.8054, 2.5545, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.a.2', 'LV', 3.07, 29, 0.4421, 2.1641, 3.9753, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.a.3', 'IM', 3.09, 29, 0.2483, 2.5847, 3.6021, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.a.3', 'LV', 3.88, 28, 0.4490, 2.9547, 4.7971, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.a.4', 'IM', 2.66, 29, 0.2189, 2.2126, 3.1093, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.a.4', 'LV', 2.78, 29, 0.3128, 2.1421, 3.4235, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.b.1', 'IM', 3.96, 29, 0.1554, 3.6437, 4.2803, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.b.1', 'LV', 3.20, 29, 0.1598, 2.8767, 3.5314, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.b.2', 'IM', 3.10, 29, 0.1977, 2.6918, 3.5016, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.b.2', 'LV', 3.89, 28, 0.2492, 3.3789, 4.4013, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.b.4', 'IM', 3.42, 29, 0.2592, 2.8852, 3.9471, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.b.4', 'LV', 4.88, 29, 0.3612, 4.1417, 5.6216, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.b.5', 'IM', 3.06, 29, 0.2619, 2.5218, 3.5946, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.b.5', 'LV', 3.51, 29, 0.4023, 2.6822, 4.3302, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.b.6', 'IM', 4.15, 29, 0.1284, 3.8888, 4.4150, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.3.b.6', 'LV', 4.63, 29, 0.1949, 4.2293, 5.0279, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.1', 'IM', 3.72, 28, 0.1651, 3.3775, 4.0549, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.1', 'LV', 3.84, 27, 0.1838, 3.4574, 4.2131, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.2', 'IM', 4.38, 28, 0.1255, 4.1180, 4.6329, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.2', 'LV', 5.22, 27, 0.1689, 4.8724, 5.5669, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.3', 'IM', 3.27, 27, 0.1746, 2.9151, 3.6327, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.3', 'LV', 3.93, 28, 0.2779, 3.3633, 4.5037, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.4', 'IM', 3.68, 28, 0.1508, 3.3734, 3.9924, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.4', 'LV', 4.75, 28, 0.2245, 4.2921, 5.2134, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.5', 'IM', 2.87, 29, 0.1876, 2.4865, 3.2550, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.5', 'LV', 3.08, 29, 0.3252, 2.4121, 3.7445, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.6', 'IM', 2.42, 29, 0.2000, 2.0103, 2.8295, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.6', 'LV', 2.40, 29, 0.3193, 1.7433, 3.0514, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.7', 'IM', 3.85, 29, 0.1646, 3.5172, 4.1914, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.7', 'LV', 5.29, 29, 0.1841, 4.9160, 5.6701, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.8', 'IM', 2.71, 29, 0.2325, 2.2291, 3.1815, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.a.8', 'LV', 3.26, 29, 0.3966, 2.4469, 4.0718, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.b.1', 'IM', 4.10, 29, 0.1388, 3.8138, 4.3824, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.b.1', 'LV', 5.24, 29, 0.1939, 4.8398, 5.6341, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.b.2', 'IM', 3.82, 29, 0.1530, 3.5100, 4.1370, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.b.2', 'LV', 4.24, 29, 0.2067, 3.8210, 4.6678, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.b.3', 'IM', 3.61, 29, 0.1834, 3.2375, 3.9890, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.b.3', 'LV', 4.12, 29, 0.2783, 3.5499, 4.6899, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.b.4', 'IM', 3.95, 28, 0.1528, 3.6383, 4.2651, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.b.4', 'LV', 4.80, 29, 0.1843, 4.4179, 5.1727, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.b.5', 'IM', 3.72, 29, 0.1250, 3.4604, 3.9724, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.b.5', 'LV', 4.62, 29, 0.1379, 4.3414, 4.9062, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.b.6', 'IM', 3.46, 29, 0.1408, 3.1710, 3.7478, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.b.6', 'LV', 4.50, 28, 0.2335, 4.0258, 4.9840, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.c.1', 'IM', 3.49, 29, 0.1932, 3.0900, 3.8815, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.c.1', 'LV', 3.87, 29, 0.2465, 3.3678, 4.3775, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.c.2', 'IM', 3.30, 29, 0.1774, 2.9380, 3.6648, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.c.2', 'LV', 4.15, 29, 0.2649, 3.6121, 4.6975, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.c.3', 'IM', 3.80, 29, 0.1354, 3.5217, 4.0766, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '4.A.4.c.3', 'LV', 4.84, 29, 0.1858, 4.4608, 5.2222, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.a.1', 'IM', 4.42, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.a.1', 'LV', 4.79, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.a.2', 'IM', 3.28, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.a.2', 'LV', 3.89, 18, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.b.1', 'IM', 3.37, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.b.1', 'LV', 3.84, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.b.2', 'IM', 2.82, 17, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.b.2', 'LV', 3.00, 18, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.b.3', 'IM', 3.26, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.b.3', 'LV', 3.37, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.1', 'IM', 3.16, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.1', 'LV', 3.63, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.2', 'IM', 4.05, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.2', 'LV', 4.37, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.3', 'IM', 4.00, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.3', 'LV', 4.11, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.4', 'IM', 4.05, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.4', 'LV', 4.32, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.1', 'IM', 4.63, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.1', 'LV', 4.89, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.2', 'IM', 3.78, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.2', 'LV', 4.16, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.3', 'IM', 4.26, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.3', 'LV', 4.89, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.4', 'IM', 3.95, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.4', 'LV', 4.32, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.5', 'IM', 3.56, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.5', 'LV', 3.84, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.6', 'IM', 4.33, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.6', 'LV', 5.68, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.1', 'IM', 1.89, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.1', 'LV', 1.42, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.2', 'IM', 1.74, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.2', 'LV', 1.68, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.3', 'IM', 1.72, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.3', 'LV', 1.53, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.4', 'IM', 1.63, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.4', 'LV', 1.00, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.1', 'IM', 4.37, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.1', 'LV', 3.21, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.2', 'IM', 2.42, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.2', 'LV', 2.37, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.4', 'IM', 1.28, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.4', 'LV', 0.83, 18, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.5', 'IM', 1.33, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.5', 'LV', 0.61, 18, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.6', 'IM', 4.00, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.6', 'LV', 3.89, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.1', 'IM', 3.53, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.1', 'LV', 3.21, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.2', 'IM', 4.53, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.2', 'LV', 5.47, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.3', 'IM', 4.44, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.3', 'LV', 4.89, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.4', 'IM', 4.33, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.4', 'LV', 5.32, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.5', 'IM', 2.59, 17, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.5', 'LV', 3.21, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.6', 'IM', 2.53, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.6', 'LV', 2.74, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.7', 'IM', 4.05, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.7', 'LV', 5.32, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.8', 'IM', 3.11, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.8', 'LV', 3.37, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.1', 'IM', 4.05, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.1', 'LV', 4.68, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.2', 'IM', 4.00, 17, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.2', 'LV', 4.11, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.3', 'IM', 4.11, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.3', 'LV', 4.11, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.4', 'IM', 4.11, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.4', 'LV', 5.05, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.5', 'IM', 4.17, 18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.5', 'LV', 4.84, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.6', 'IM', 3.63, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.6', 'LV', 4.84, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.c.1', 'IM', 3.47, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.c.1', 'LV', 4.37, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.c.2', 'IM', 3.32, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.c.2', 'LV', 4.32, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.c.3', 'IM', 3.53, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.c.3', 'LV', 4.44, 18, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.1.a.1', 'IM', 4.27, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.1.a.1', 'LV', 4.81, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.1.a.2', 'IM', 3.83, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.1.a.2', 'LV', 4.23, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.1.b.1', 'IM', 3.74, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.1.b.1', 'LV', 4.02, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.1.b.2', 'IM', 3.28, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.1.b.2', 'LV', 3.17, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.1.b.3', 'IM', 3.42, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.1.b.3', 'LV', 3.34, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.a.1', 'IM', 3.60, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.a.1', 'LV', 4.19, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.a.2', 'IM', 3.76, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.a.2', 'LV', 4.39, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.a.3', 'IM', 3.90, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.a.3', 'LV', 4.33, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.a.4', 'IM', 3.75, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.a.4', 'LV', 4.29, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.b.1', 'IM', 4.37, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.b.1', 'LV', 4.87, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.b.2', 'IM', 3.67, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.b.2', 'LV', 4.46, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.b.3', 'IM', 3.76, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.b.3', 'LV', 4.60, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.b.4', 'IM', 3.59, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.b.4', 'LV', 4.06, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.b.5', 'IM', 3.83, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.b.5', 'LV', 4.64, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.b.6', 'IM', 4.06, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.2.b.6', 'LV', 5.33, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.a.1', 'IM', 2.32, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.a.1', 'LV', 2.62, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.a.2', 'IM', 2.46, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.a.2', 'LV', 3.31, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.a.3', 'IM', 2.22, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.a.3', 'LV', 2.19, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.a.4', 'IM', 2.67, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.a.4', 'LV', 2.72, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.b.1', 'IM', 4.05, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.b.1', 'LV', 3.65, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.b.2', 'IM', 2.06, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.b.2', 'LV', 2.07, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.b.4', 'IM', 2.06, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.b.4', 'LV', 2.17, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.b.5', 'IM', 1.88, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.b.5', 'LV', 1.58, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.b.6', 'IM', 3.54, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.3.b.6', 'LV', 3.65, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.1', 'IM', 3.32, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.1', 'LV', 3.48, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.2', 'IM', 4.35, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.2', 'LV', 5.15, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.3', 'IM', 3.93, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.3', 'LV', 4.76, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.4', 'IM', 3.91, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.4', 'LV', 4.79, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.5', 'IM', 2.72, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.5', 'LV', 3.25, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.6', 'IM', 3.16, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.6', 'LV', 3.66, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.7', 'IM', 3.78, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.7', 'LV', 5.12, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.8', 'IM', 2.73, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.a.8', 'LV', 3.02, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.b.1', 'IM', 3.90, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.b.1', 'LV', 4.78, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.b.2', 'IM', 4.00, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.b.2', 'LV', 4.40, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.b.3', 'IM', 3.61, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.b.3', 'LV', 4.14, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.b.4', 'IM', 3.97, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.b.4', 'LV', 5.01, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.b.5', 'IM', 3.74, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.b.5', 'LV', 4.60, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.b.6', 'IM', 3.27, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.b.6', 'LV', 4.34, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.c.1', 'IM', 3.24, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.c.1', 'LV', 3.67, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.c.2', 'IM', 3.30, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.c.2', 'LV', 4.21, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.c.3', 'IM', 3.74, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '4.A.4.c.3', 'LV', 4.49, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.1.a.1', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.1.a.1', 'LV', 4.57, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.1.a.2', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.1.a.2', 'LV', 4.00, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.1.b.1', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.1.b.1', 'LV', 4.05, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.1.b.2', 'IM', 2.67, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.1.b.2', 'LV', 3.10, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.1.b.3', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.1.b.3', 'LV', 3.90, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.a.1', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.a.1', 'LV', 4.05, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.a.2', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.a.2', 'LV', 4.19, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.a.3', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.a.3', 'LV', 4.00, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.a.4', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.a.4', 'LV', 4.90, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.b.1', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.b.1', 'LV', 5.19, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.b.2', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.b.2', 'LV', 4.62, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.b.3', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.b.3', 'LV', 5.00, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.b.4', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.b.4', 'LV', 4.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.b.5', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.b.5', 'LV', 4.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.b.6', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.2.b.6', 'LV', 5.48, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.a.1', 'IM', 1.85, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.a.1', 'LV', 1.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.a.2', 'IM', 2.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.a.2', 'LV', 2.48, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.a.3', 'IM', 2.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.a.3', 'LV', 1.90, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.a.4', 'IM', 2.10, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.a.4', 'LV', 1.52, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.b.1', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.b.1', 'LV', 4.05, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.b.2', 'IM', 2.29, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.b.2', 'LV', 2.71, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.b.4', 'IM', 1.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.b.4', 'LV', 1.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.b.5', 'IM', 1.57, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.b.5', 'LV', 1.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.b.6', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.3.b.6', 'LV', 3.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.1', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.1', 'LV', 4.00, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.2', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.2', 'LV', 5.43, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.3', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.3', 'LV', 4.76, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.4', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.4', 'LV', 5.48, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.5', 'IM', 2.24, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.5', 'LV', 2.43, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.6', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.6', 'LV', 4.24, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.7', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.7', 'LV', 5.62, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.8', 'IM', 2.29, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.a.8', 'LV', 2.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.b.1', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.b.1', 'LV', 5.05, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.b.2', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.b.2', 'LV', 5.05, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.b.3', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.b.3', 'LV', 4.38, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.b.4', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.b.4', 'LV', 5.62, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.b.5', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.b.5', 'LV', 5.19, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.b.6', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.b.6', 'LV', 5.19, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.c.1', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.c.1', 'LV', 3.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.c.2', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.c.2', 'LV', 4.67, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.c.3', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '4.A.4.c.3', 'LV', 5.19, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.a.1', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.a.1', 'LV', 5.33, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.a.2', 'IM', 2.81, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.a.2', 'LV', 3.38, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.b.1', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.b.1', 'LV', 3.57, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.b.2', 'IM', 1.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.b.2', 'LV', 0.76, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.b.3', 'IM', 2.24, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.b.3', 'LV', 1.86, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.1', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.1', 'LV', 3.48, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.2', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.2', 'LV', 4.67, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.3', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.3', 'LV', 4.70, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.4', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.4', 'LV', 4.67, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.1', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.1', 'LV', 4.95, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.2', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.2', 'LV', 4.30, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.3', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.3', 'LV', 5.38, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.4', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.4', 'LV', 4.48, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.5', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.5', 'LV', 4.40, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.6', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.6', 'LV', 5.67, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.1', 'IM', 1.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.1', 'LV', 0.71, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.2', 'IM', 1.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.2', 'LV', 1.00, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.3', 'IM', 1.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.3', 'LV', 0.90, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.4', 'IM', 1.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.4', 'LV', 0.05, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.1', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.1', 'LV', 3.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.2', 'IM', 1.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.2', 'LV', 0.00, 20, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.4', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.4', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.5', 'IM', 1.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.5', 'LV', 0.10, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.6', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.6', 'LV', 3.95, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.1', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.1', 'LV', 3.86, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.2', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.2', 'LV', 5.71, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.3', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.3', 'LV', 4.86, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.4', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.4', 'LV', 5.43, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.5', 'IM', 2.71, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.5', 'LV', 3.00, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.6', 'IM', 2.76, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.6', 'LV', 3.43, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.7', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.7', 'LV', 5.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.8', 'IM', 1.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.8', 'LV', 1.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.1', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.1', 'LV', 4.33, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.2', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.2', 'LV', 4.05, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.3', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.3', 'LV', 3.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.4', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.4', 'LV', 4.67, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.5', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.5', 'LV', 4.71, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.6', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.6', 'LV', 5.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.c.1', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.c.1', 'LV', 4.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.c.2', 'IM', 2.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.c.2', 'LV', 3.29, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.c.3', 'IM', 3.58, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.c.3', 'LV', 4.25, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.a.1', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.a.1', 'LV', 5.09, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.a.2', 'IM', 3.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.a.2', 'LV', 4.50, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.b.1', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.b.1', 'LV', 4.27, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.b.2', 'IM', 2.00, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.b.2', 'LV', 1.91, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.b.3', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.b.3', 'LV', 2.95, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.1', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.1', 'LV', 4.59, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.2', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.2', 'LV', 4.91, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.3', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.3', 'LV', 5.18, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.4', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.4', 'LV', 4.68, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.1', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.1', 'LV', 5.41, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.2', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.2', 'LV', 4.68, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.3', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.3', 'LV', 5.23, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.4', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.4', 'LV', 4.64, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.5', 'IM', 3.55, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.5', 'LV', 4.91, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.6', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.6', 'LV', 5.73, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.1', 'IM', 2.09, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.1', 'LV', 1.59, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.2', 'IM', 1.68, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.2', 'LV', 1.91, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.3', 'IM', 1.55, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.3', 'LV', 1.00, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.4', 'IM', 1.73, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.4', 'LV', 1.09, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.1', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.1', 'LV', 3.50, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.2', 'IM', 1.14, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.2', 'LV', 0.36, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.4', 'IM', 1.18, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.4', 'LV', 0.23, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.5', 'IM', 1.50, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.5', 'LV', 0.68, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.6', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.6', 'LV', 4.32, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.1', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.1', 'LV', 4.14, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.2', 'IM', 4.73, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.2', 'LV', 6.14, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.3', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.3', 'LV', 4.95, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.4', 'IM', 4.73, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.4', 'LV', 6.23, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.5', 'IM', 3.41, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.5', 'LV', 3.82, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.6', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.6', 'LV', 4.09, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.7', 'IM', 4.73, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.7', 'LV', 6.32, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.8', 'IM', 3.05, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.8', 'LV', 3.36, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.1', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.1', 'LV', 5.05, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.2', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.2', 'LV', 5.14, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.3', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.3', 'LV', 5.36, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.4', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.4', 'LV', 5.68, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.5', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.5', 'LV', 5.55, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.6', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.6', 'LV', 6.05, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.c.1', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.c.1', 'LV', 5.09, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.c.2', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.c.2', 'LV', 5.95, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.c.3', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.c.3', 'LV', 4.68, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.a.1', 'IM', 4.71, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.a.1', 'LV', 4.89, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.a.2', 'IM', 3.54, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.a.2', 'LV', 4.50, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.b.1', 'IM', 3.68, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.b.1', 'LV', 4.36, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.b.2', 'IM', 1.93, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.b.2', 'LV', 1.71, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.b.3', 'IM', 3.38, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.b.3', 'LV', 3.70, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.1', 'IM', 3.57, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.1', 'LV', 3.75, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.2', 'IM', 4.00, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.2', 'LV', 4.86, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.3', 'IM', 3.64, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.3', 'LV', 4.36, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.4', 'IM', 3.89, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.4', 'LV', 4.50, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.1', 'IM', 4.46, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.1', 'LV', 4.93, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.2', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.2', 'LV', 5.11, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.3', 'IM', 4.32, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.3', 'LV', 5.46, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.4', 'IM', 4.25, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.4', 'LV', 4.50, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.5', 'IM', 3.96, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.5', 'LV', 5.32, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.6', 'IM', 4.32, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.6', 'LV', 5.96, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.1', 'IM', 1.82, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.1', 'LV', 1.39, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.2', 'IM', 1.61, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.2', 'LV', 1.50, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.3', 'IM', 1.32, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.3', 'LV', 0.57, 28, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.4', 'IM', 1.21, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.4', 'LV', 0.36, 28, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.1', 'IM', 4.71, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.1', 'LV', 4.04, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.2', 'IM', 1.68, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.2', 'LV', 1.04, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.4', 'IM', 1.07, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.4', 'LV', 0.15, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.5', 'IM', 1.21, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.5', 'LV', 0.39, 28, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.6', 'IM', 4.04, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.6', 'LV', 4.21, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.1', 'IM', 4.14, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.1', 'LV', 4.68, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.2', 'IM', 4.79, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.2', 'LV', 6.50, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.3', 'IM', 3.25, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.3', 'LV', 3.75, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.4', 'IM', 4.61, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.4', 'LV', 5.89, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.5', 'IM', 2.68, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.5', 'LV', 2.86, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.6', 'IM', 3.52, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.6', 'LV', 3.96, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.7', 'IM', 3.57, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.7', 'LV', 4.93, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.8', 'IM', 1.50, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.8', 'LV', 1.29, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.1', 'IM', 4.07, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.1', 'LV', 5.00, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.2', 'IM', 4.46, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.2', 'LV', 5.11, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.3', 'IM', 4.93, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.3', 'LV', 6.39, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.4', 'IM', 4.29, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.4', 'LV', 5.57, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.5', 'IM', 4.68, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.5', 'LV', 5.54, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.6', 'IM', 4.11, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.6', 'LV', 5.79, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.c.1', 'IM', 3.14, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.c.1', 'LV', 4.04, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.c.2', 'IM', 3.14, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.c.2', 'LV', 4.04, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.c.3', 'IM', 3.21, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.c.3', 'LV', 4.11, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.1.a.1', 'IM', 3.89, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.1.a.1', 'LV', 4.34, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.1.a.2', 'IM', 3.72, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.1.a.2', 'LV', 4.63, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.1.b.1', 'IM', 3.82, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.1.b.1', 'LV', 4.05, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.1.b.2', 'IM', 3.74, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.1.b.2', 'LV', 3.66, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.1.b.3', 'IM', 3.53, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.1.b.3', 'LV', 3.40, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.a.1', 'IM', 3.37, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.a.1', 'LV', 3.59, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.a.2', 'IM', 3.41, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.a.2', 'LV', 4.12, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.a.3', 'IM', 3.54, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.a.3', 'LV', 3.39, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.a.4', 'IM', 3.70, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.a.4', 'LV', 4.07, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.b.1', 'IM', 4.43, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.b.1', 'LV', 4.91, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.b.2', 'IM', 3.90, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.b.2', 'LV', 4.64, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.b.3', 'IM', 3.70, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.b.3', 'LV', 4.70, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.b.4', 'IM', 3.71, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.b.4', 'LV', 4.22, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.b.5', 'IM', 3.93, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.b.5', 'LV', 4.01, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.b.6', 'IM', 4.24, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.2.b.6', 'LV', 5.20, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.a.1', 'IM', 3.35, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.a.1', 'LV', 4.22, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.a.2', 'IM', 3.47, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.a.2', 'LV', 4.79, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.a.3', 'IM', 3.45, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.a.3', 'LV', 4.11, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.a.4', 'IM', 3.68, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.a.4', 'LV', 3.84, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.b.1', 'IM', 3.09, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.b.1', 'LV', 2.87, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.b.2', 'IM', 2.19, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.b.2', 'LV', 2.18, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.b.4', 'IM', 3.20, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.b.4', 'LV', 3.73, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.b.5', 'IM', 2.78, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.b.5', 'LV', 2.68, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.b.6', 'IM', 3.68, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.3.b.6', 'LV', 3.38, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.1', 'IM', 3.36, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.1', 'LV', 2.99, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.2', 'IM', 4.09, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.2', 'LV', 4.32, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.3', 'IM', 3.71, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.3', 'LV', 3.84, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.4', 'IM', 3.78, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.4', 'LV', 4.53, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.5', 'IM', 2.70, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.5', 'LV', 2.87, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.6', 'IM', 3.31, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.6', 'LV', 3.44, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.7', 'IM', 3.48, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.7', 'LV', 4.14, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.8', 'IM', 2.92, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.a.8', 'LV', 3.37, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.b.1', 'IM', 3.85, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.b.1', 'LV', 4.33, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.b.2', 'IM', 3.24, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.b.2', 'LV', 3.14, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.b.3', 'IM', 3.48, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.b.3', 'LV', 3.61, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.b.4', 'IM', 3.58, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.b.4', 'LV', 4.09, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.b.5', 'IM', 3.42, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.b.5', 'LV', 3.78, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.b.6', 'IM', 2.85, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.b.6', 'LV', 3.61, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.c.1', 'IM', 3.30, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.c.1', 'LV', 3.39, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.c.2', 'IM', 3.17, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.c.2', 'LV', 3.51, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.c.3', 'IM', 3.85, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '4.A.4.c.3', 'LV', 4.79, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.a.1', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.a.1', 'LV', 4.50, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.a.2', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.a.2', 'LV', 4.95, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.b.1', 'IM', 3.89, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.b.1', 'LV', 3.95, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.b.2', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.b.2', 'LV', 4.55, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.b.3', 'IM', 3.74, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.b.3', 'LV', 3.45, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.1', 'IM', 3.68, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.1', 'LV', 4.53, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.2', 'IM', 4.00, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.2', 'LV', 4.55, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.3', 'IM', 4.26, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.3', 'LV', 4.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.4', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.4', 'LV', 4.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.1', 'IM', 4.21, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.1', 'LV', 5.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.2', 'IM', 3.53, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.2', 'LV', 3.79, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.3', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.3', 'LV', 4.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.4', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.4', 'LV', 3.84, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.5', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.5', 'LV', 5.00, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.6', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.6', 'LV', 5.60, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.1', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.1', 'LV', 4.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.2', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.2', 'LV', 4.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.3', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.3', 'LV', 3.45, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.4', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.4', 'LV', 3.10, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.1', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.1', 'LV', 3.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.2', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.2', 'LV', 4.00, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.4', 'IM', 2.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.4', 'LV', 2.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.5', 'IM', 2.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.5', 'LV', 2.40, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.6', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.6', 'LV', 4.10, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.1', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.1', 'LV', 3.35, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.2', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.2', 'LV', 5.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.3', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.3', 'LV', 4.70, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.4', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.4', 'LV', 5.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.5', 'IM', 3.21, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.5', 'LV', 3.85, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.6', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.6', 'LV', 4.00, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.7', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.7', 'LV', 5.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.8', 'IM', 2.80, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.8', 'LV', 3.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.1', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.1', 'LV', 5.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.2', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.2', 'LV', 4.74, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.3', 'IM', 4.00, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.3', 'LV', 4.79, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.4', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.4', 'LV', 5.30, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.5', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.5', 'LV', 4.85, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.6', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.6', 'LV', 4.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.c.1', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.c.1', 'LV', 3.90, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.c.2', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.c.2', 'LV', 4.60, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.c.3', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.c.3', 'LV', 4.85, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.a.1', 'IM', 3.95, 30, 0.2728, 3.3919, 4.5076, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.a.1', 'LV', 3.91, 30, 0.4147, 3.0594, 4.7556, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.a.2', 'IM', 3.34, 31, 0.2936, 2.7361, 3.9353, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.a.2', 'LV', 3.61, 31, 0.3944, 2.8069, 4.4179, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.b.1', 'IM', 3.50, 31, 0.3011, 2.8880, 4.1177, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.b.1', 'LV', 3.14, 31, 0.4396, 2.2375, 4.0330, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.b.2', 'IM', 3.38, 30, 0.2816, 2.7999, 3.9517, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.b.2', 'LV', 2.44, 31, 0.4282, 1.5642, 3.3132, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.b.3', 'IM', 3.07, 30, 0.2437, 2.5705, 3.5675, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.b.3', 'LV', 2.77, 30, 0.4807, 1.7904, 3.7567, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.1', 'IM', 3.80, 31, 0.2557, 3.2780, 4.3225, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.1', 'LV', 3.74, 31, 0.5742, 2.5651, 4.9106, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.2', 'IM', 3.09, 31, 0.3522, 2.3743, 3.8127, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.2', 'LV', 3.19, 31, 0.5937, 1.9734, 4.3984, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.3', 'IM', 4.23, 31, 0.2309, 3.7542, 4.6974, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.3', 'LV', 4.13, 31, 0.5104, 3.0868, 5.1716, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.4', 'IM', 2.63, 31, 0.2936, 2.0327, 3.2321, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.4', 'LV', 2.80, 31, 0.4822, 1.8199, 3.7894, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.1', 'IM', 4.08, 31, 0.2372, 3.5976, 4.5665, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.1', 'LV', 4.49, 31, 0.5371, 3.3896, 5.5833, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.2', 'IM', 3.76, 31, 0.2827, 3.1794, 4.3343, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.2', 'LV', 4.54, 31, 0.4657, 3.5895, 5.4918, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.3', 'IM', 3.73, 31, 0.2205, 3.2798, 4.1804, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.3', 'LV', 4.23, 30, 0.3695, 3.4789, 4.9903, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.4', 'IM', 3.55, 28, 0.2254, 3.0847, 4.0097, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.4', 'LV', 3.56, 30, 0.3776, 2.7887, 4.3333, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.5', 'IM', 3.78, 31, 0.2513, 3.2633, 4.2896, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.5', 'LV', 4.32, 31, 0.3763, 3.5535, 5.0905, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.6', 'IM', 3.84, 31, 0.2673, 3.2960, 4.3877, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.6', 'LV', 4.84, 31, 0.4455, 3.9292, 5.7490, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.1', 'IM', 2.84, 31, 0.2333, 2.3655, 3.3186, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.1', 'LV', 3.11, 31, 0.3675, 2.3609, 3.8619, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.2', 'IM', 2.65, 31, 0.2896, 2.0544, 3.2372, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.2', 'LV', 3.00, 31, 0.4605, 2.0594, 3.9405, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.3', 'IM', 1.56, 31, 0.2117, 1.1315, 1.9963, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.3', 'LV', 1.12, 31, 0.4062, 0.2944, 1.9535, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.4', 'IM', 1.77, 31, 0.3465, 1.0576, 2.4727, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.4', 'LV', 0.85, 31, 0.3569, 0.1217, 1.5796, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.1', 'IM', 3.57, 31, 0.2232, 3.1157, 4.0272, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.1', 'LV', 3.34, 31, 0.3540, 2.6215, 4.0674, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.2', 'IM', 1.42, 31, 0.2073, 1.0000, 1.8419, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.2', 'LV', 0.92, 31, 0.4587, 0.0000, 1.8536, 'Y', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.4', 'IM', 1.21, 31, 0.1587, 1.0000, 1.5312, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.4', 'LV', 0.53, 31, 0.4002, 0.0000, 1.3436, 'Y', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.5', 'IM', 1.45, 31, 0.1760, 1.0863, 1.8052, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.5', 'LV', 1.06, 31, 0.4558, 0.1331, 1.9947, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.6', 'IM', 3.84, 31, 0.1983, 3.4401, 4.2499, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.6', 'LV', 3.43, 31, 0.3589, 2.6926, 4.1586, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.1', 'IM', 3.13, 31, 0.3132, 2.4890, 3.7683, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.1', 'LV', 2.96, 31, 0.4237, 2.0977, 3.8281, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.2', 'IM', 4.30, 31, 0.1591, 3.9792, 4.6292, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.2', 'LV', 5.05, 31, 0.2187, 4.6008, 5.4942, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.3', 'IM', 4.15, 31, 0.2228, 3.6996, 4.6098, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.3', 'LV', 4.90, 31, 0.3609, 4.1600, 5.6342, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.4', 'IM', 4.33, 31, 0.1879, 3.9438, 4.7111, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.4', 'LV', 5.26, 31, 0.1916, 4.8710, 5.6536, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.5', 'IM', 4.28, 30, 0.1810, 3.9110, 4.6514, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.5', 'LV', 4.33, 31, 0.2993, 3.7193, 4.9418, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.6', 'IM', 3.14, 30, 0.3601, 2.4004, 3.8734, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.6', 'LV', 3.31, 30, 0.4898, 2.3091, 4.3126, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.7', 'IM', 4.03, 31, 0.1882, 3.6448, 4.4134, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.7', 'LV', 4.88, 31, 0.2520, 4.3612, 5.3905, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.8', 'IM', 4.10, 31, 0.2635, 3.5587, 4.6351, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.8', 'LV', 4.63, 30, 0.4021, 3.8034, 5.4483, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.1', 'IM', 3.91, 31, 0.1763, 3.5464, 4.2667, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.1', 'LV', 4.52, 31, 0.3598, 3.7901, 5.2597, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.2', 'IM', 3.95, 30, 0.2058, 3.5322, 4.3741, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.2', 'LV', 3.80, 31, 0.3940, 2.9935, 4.6029, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.3', 'IM', 4.36, 30, 0.1874, 3.9802, 4.7465, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.3', 'LV', 4.53, 30, 0.2364, 4.0506, 5.0176, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.4', 'IM', 4.08, 31, 0.1736, 3.7235, 4.4326, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.4', 'LV', 4.46, 31, 0.3330, 3.7800, 5.1402, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.5', 'IM', 3.98, 31, 0.1876, 3.6013, 4.3677, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.5', 'LV', 4.74, 31, 0.3069, 4.1164, 5.3700, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.6', 'IM', 3.48, 31, 0.2973, 2.8716, 4.0861, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.6', 'LV', 4.15, 31, 0.5034, 3.1184, 5.1747, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.c.1', 'IM', 3.88, 31, 0.2388, 3.3903, 4.3659, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.c.1', 'LV', 4.38, 31, 0.3831, 3.5967, 5.1617, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.c.2', 'IM', 3.57, 31, 0.3809, 2.7935, 4.3494, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.c.2', 'LV', 3.99, 31, 0.5189, 2.9308, 5.0503, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.c.3', 'IM', 3.72, 30, 0.2414, 3.2227, 4.2101, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.c.3', 'LV', 4.37, 30, 0.3691, 3.6112, 5.1210, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.a.1', 'IM', 4.61, 21, 0.1169, 4.3653, 4.8529, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.a.1', 'LV', 4.73, 22, 0.3006, 4.1007, 5.3511, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.a.2', 'IM', 3.93, 22, 0.2759, 3.3597, 4.5071, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.a.2', 'LV', 4.95, 22, 0.3605, 4.2020, 5.7013, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.b.1', 'IM', 3.75, 22, 0.3004, 3.1251, 4.3747, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.b.1', 'LV', 4.14, 22, 0.3887, 3.3338, 4.9506, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.b.2', 'IM', 2.98, 22, 0.4364, 2.0681, 3.8832, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.b.2', 'LV', 2.86, 22, 0.5903, 1.6352, 4.0903, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.b.3', 'IM', 3.20, 22, 0.3991, 2.3744, 4.0345, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.b.3', 'LV', 3.50, 22, 0.4119, 2.6450, 4.3581, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.1', 'IM', 3.81, 21, 0.4431, 2.8872, 4.7358, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.1', 'LV', 3.99, 22, 0.5994, 2.7448, 5.2377, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.2', 'IM', 4.10, 21, 0.2447, 3.5922, 4.6129, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.2', 'LV', 4.47, 22, 0.3880, 3.6625, 5.2764, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.3', 'IM', 3.47, 22, 0.4056, 2.6295, 4.3165, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.3', 'LV', 3.82, 22, 0.4414, 2.9008, 4.7368, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.4', 'IM', 4.03, 22, 0.3764, 3.2451, 4.8105, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.4', 'LV', 5.03, 22, 0.3375, 4.3236, 5.7275, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.1', 'IM', 4.69, 22, 0.0847, 4.5131, 4.8655, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.1', 'LV', 5.75, 22, 0.2798, 5.1635, 6.3271, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.2', 'IM', 4.14, 21, 0.2100, 3.6974, 4.5737, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.2', 'LV', 5.01, 22, 0.4284, 4.1225, 5.9042, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.3', 'IM', 3.94, 22, 0.1809, 3.5612, 4.3135, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.3', 'LV', 4.80, 22, 0.2791, 4.2231, 5.3840, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.4', 'IM', 3.96, 22, 0.3317, 3.2751, 4.6548, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.4', 'LV', 4.78, 22, 0.2426, 4.2742, 5.2832, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.5', 'IM', 3.48, 21, 0.4149, 2.6152, 4.3459, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.5', 'LV', 4.24, 22, 0.5592, 3.0812, 5.4070, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.6', 'IM', 4.48, 22, 0.1561, 4.1550, 4.8040, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.6', 'LV', 5.54, 22, 0.4111, 4.6875, 6.3975, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.1', 'IM', 2.30, 22, 0.3369, 1.5954, 2.9965, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.1', 'LV', 2.14, 22, 0.5511, 0.9905, 3.2828, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.2', 'IM', 2.05, 22, 0.3747, 1.2692, 2.8277, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.2', 'LV', 2.24, 22, 0.7064, 0.7704, 3.7083, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.3', 'IM', 2.12, 21, 0.3405, 1.4140, 2.8347, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.3', 'LV', 1.65, 22, 0.3727, 0.8710, 2.4214, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.4', 'IM', 2.01, 22, 0.3818, 1.2204, 2.8084, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.4', 'LV', 1.26, 22, 0.3833, 0.4661, 2.0605, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.1', 'IM', 4.12, 21, 0.2038, 3.6975, 4.5479, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.1', 'LV', 3.45, 22, 0.3209, 2.7860, 4.1206, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.2', 'IM', 1.86, 22, 0.4076, 1.0164, 2.7116, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.2', 'LV', 1.74, 22, 0.8138, 0.0449, 3.4299, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.4', 'IM', 1.74, 22, 0.3881, 1.0000, 2.5515, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.4', 'LV', 1.41, 22, 0.6750, 0.0086, 2.8159, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.5', 'IM', 1.70, 22, 0.3938, 1.0000, 2.5192, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.5', 'LV', 1.40, 22, 0.7880, 0.0000, 3.0345, 'Y', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.6', 'IM', 3.98, 22, 0.4620, 3.0156, 4.9373, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.6', 'LV', 4.18, 22, 0.4192, 3.3043, 5.0479, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.1', 'IM', 3.69, 22, 0.1181, 3.4468, 3.9381, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.1', 'LV', 3.60, 22, 0.3707, 2.8291, 4.3711, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.2', 'IM', 4.65, 22, 0.1081, 4.4259, 4.8755, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.2', 'LV', 6.14, 22, 0.2705, 5.5760, 6.7012, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.3', 'IM', 4.53, 22, 0.1263, 4.2697, 4.7952, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.3', 'LV', 6.02, 22, 0.1410, 5.7229, 6.3092, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.4', 'IM', 4.86, 22, 0.1038, 4.6469, 5.0000, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.4', 'LV', 6.65, 22, 0.2040, 6.2213, 7.0000, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.5', 'IM', 3.74, 22, 0.3275, 3.0589, 4.4211, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.5', 'LV', 4.52, 22, 0.3976, 3.6886, 5.3424, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.6', 'IM', 3.30, 22, 0.6338, 1.9805, 4.6165, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.6', 'LV', 4.06, 22, 0.9946, 1.9880, 6.1248, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.7', 'IM', 4.44, 22, 0.3783, 3.6525, 5.0000, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.7', 'LV', 5.50, 22, 0.3840, 4.7033, 6.3005, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.8', 'IM', 4.06, 21, 0.1743, 3.6917, 4.4190, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.8', 'LV', 4.85, 22, 0.1198, 4.6035, 5.1019, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.1', 'IM', 4.38, 22, 0.2334, 3.8985, 4.8693, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.1', 'LV', 5.70, 22, 0.3901, 4.8863, 6.5087, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.2', 'IM', 4.64, 22, 0.1798, 4.2648, 5.0000, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.2', 'LV', 4.99, 22, 0.3141, 4.3399, 5.6464, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.3', 'IM', 4.77, 22, 0.0577, 4.6486, 4.8887, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.3', 'LV', 5.78, 22, 0.1914, 5.3857, 6.1815, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.4', 'IM', 3.96, 22, 0.3459, 3.2405, 4.6792, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.4', 'LV', 4.88, 22, 0.5735, 3.6871, 6.0726, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.5', 'IM', 4.60, 22, 0.2328, 4.1141, 5.0000, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.5', 'LV', 5.92, 22, 0.2393, 5.4233, 6.4186, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.6', 'IM', 4.20, 21, 0.2213, 3.7404, 4.6636, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.6', 'LV', 5.64, 21, 0.2250, 5.1714, 6.1101, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.c.1', 'IM', 4.15, 21, 0.4787, 3.1545, 5.0000, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.c.1', 'LV', 5.17, 22, 0.6117, 3.8948, 6.4390, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.c.2', 'IM', 4.06, 21, 0.2623, 3.5093, 4.6036, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.c.2', 'LV', 5.07, 22, 0.3962, 4.2454, 5.8931, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.c.3', 'IM', 3.71, 21, 0.4366, 2.8032, 4.6247, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.c.3', 'LV', 4.28, 22, 0.6567, 2.9166, 5.6480, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.a.1', 'IM', 4.39, 32, 0.1340, 4.1186, 4.6653, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.a.1', 'LV', 4.89, 32, 0.1969, 4.4865, 5.2897, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.a.2', 'IM', 3.55, 32, 0.2237, 3.0939, 4.0063, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.a.2', 'LV', 4.53, 30, 0.4743, 3.5553, 5.4953, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.b.1', 'IM', 4.11, 32, 0.1307, 3.8402, 4.3731, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.b.1', 'LV', 5.17, 29, 0.2037, 4.7552, 5.5898, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.b.2', 'IM', 1.83, 28, 0.2868, 1.2445, 2.4213, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.b.2', 'LV', 1.62, 30, 0.5083, 0.5780, 2.6572, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.b.3', 'IM', 3.13, 30, 0.2223, 2.6787, 3.5880, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.b.3', 'LV', 3.44, 30, 0.2570, 2.9095, 3.9607, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.1', 'IM', 3.83, 32, 0.2271, 3.3712, 4.2975, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.1', 'LV', 4.86, 30, 0.4469, 3.9439, 5.7718, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.2', 'IM', 3.89, 32, 0.1455, 3.5908, 4.1844, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.2', 'LV', 4.76, 30, 0.2437, 4.2624, 5.2594, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.3', 'IM', 4.17, 32, 0.1854, 3.7936, 4.5499, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.3', 'LV', 4.88, 30, 0.2752, 4.3185, 5.4443, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.4', 'IM', 4.05, 32, 0.1922, 3.6568, 4.4409, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.4', 'LV', 4.87, 30, 0.3820, 4.0845, 5.6469, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.1', 'IM', 4.66, 31, 0.0890, 4.4745, 4.8380, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.1', 'LV', 5.53, 31, 0.3015, 4.9151, 6.1465, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.2', 'IM', 4.11, 32, 0.1549, 3.7909, 4.4228, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.2', 'LV', 4.71, 30, 0.4032, 3.8891, 5.5386, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.3', 'IM', 4.00, 32, 0.1926, 3.6097, 4.3954, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.3', 'LV', 5.34, 31, 0.2716, 4.7829, 5.8924, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.4', 'IM', 4.10, 32, 0.1413, 3.8163, 4.3926, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.4', 'LV', 4.71, 31, 0.4390, 3.8168, 5.6101, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.5', 'IM', 3.62, 32, 0.2404, 3.1254, 4.1061, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.5', 'LV', 4.44, 30, 0.4335, 3.5571, 5.3305, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.6', 'IM', 4.33, 32, 0.1667, 3.9900, 4.6699, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.6', 'LV', 5.95, 31, 0.1572, 5.6244, 6.2663, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.1', 'IM', 1.76, 30, 0.1943, 1.3618, 2.1565, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.1', 'LV', 1.23, 31, 0.3191, 0.5778, 1.8810, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.2', 'IM', 1.28, 31, 0.0955, 1.0824, 1.4724, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.2', 'LV', 0.95, 31, 0.3577, 0.2216, 1.6825, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.3', 'IM', 1.24, 31, 0.0924, 1.0478, 1.4254, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.3', 'LV', 0.47, 31, 0.1847, 0.0909, 0.8453, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.4', 'IM', 1.23, 31, 0.1143, 1.0011, 1.4681, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.4', 'LV', 0.48, 31, 0.2290, 0.0119, 0.9471, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.1', 'IM', 4.04, 32, 0.1877, 3.6594, 4.4250, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.1', 'LV', 2.90, 32, 0.1199, 2.6561, 3.1454, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.2', 'IM', 1.08, 30, 0.0550, 1.0000, 1.1962, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.2', 'LV', 0.19, 31, 0.1119, 0.0000, 0.4209, 'Y', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.4', 'IM', 1.17, 31, 0.0760, 1.0115, 1.3219, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.4', 'LV', 0.28, 31, 0.1152, 0.0404, 0.5110, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.5', 'IM', 1.23, 31, 0.1130, 1.0038, 1.4654, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.5', 'LV', 0.48, 31, 0.2262, 0.0227, 0.9466, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.6', 'IM', 3.28, 32, 0.2060, 2.8597, 3.6999, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.6', 'LV', 3.71, 30, 0.4004, 2.8926, 4.5305, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.1', 'IM', 3.91, 31, 0.1995, 3.4989, 4.3137, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.1', 'LV', 4.39, 29, 0.4843, 3.3956, 5.3795, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.2', 'IM', 4.37, 31, 0.1198, 4.1209, 4.6104, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.2', 'LV', 5.70, 30, 0.1465, 5.4026, 6.0019, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.3', 'IM', 3.73, 31, 0.1713, 3.3830, 4.0828, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.3', 'LV', 4.85, 31, 0.3663, 4.0993, 5.5955, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.4', 'IM', 4.41, 30, 0.1014, 4.2021, 4.6171, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.4', 'LV', 5.61, 31, 0.2585, 5.0869, 6.1429, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.5', 'IM', 2.78, 31, 0.3454, 2.0771, 3.4879, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.5', 'LV', 2.86, 31, 0.5497, 1.7391, 3.9844, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.6', 'IM', 3.15, 31, 0.3189, 2.4977, 3.8002, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.6', 'LV', 3.69, 31, 0.5088, 2.6537, 4.7320, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.7', 'IM', 3.84, 32, 0.2431, 3.3412, 4.3327, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.7', 'LV', 4.94, 32, 0.3635, 4.1975, 5.6803, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.8', 'IM', 2.67, 32, 0.2067, 2.2458, 3.0890, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.8', 'LV', 3.55, 30, 0.4438, 2.6472, 4.4625, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.1', 'IM', 3.79, 31, 0.2333, 3.3156, 4.2683, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.1', 'LV', 4.92, 30, 0.2030, 4.5021, 5.3325, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.2', 'IM', 3.96, 32, 0.1752, 3.5986, 4.3132, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.2', 'LV', 4.48, 31, 0.4191, 3.6287, 5.3404, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.3', 'IM', 3.38, 32, 0.2226, 2.9279, 3.8358, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.3', 'LV', 4.33, 32, 0.4683, 3.3731, 5.2832, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.4', 'IM', 3.93, 32, 0.1855, 3.5557, 4.3126, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.4', 'LV', 4.92, 30, 0.2843, 4.3365, 5.4994, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.5', 'IM', 3.80, 31, 0.1857, 3.4163, 4.1750, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.5', 'LV', 5.08, 31, 0.1674, 4.7345, 5.4183, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.6', 'IM', 3.53, 31, 0.2463, 3.0305, 4.0364, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.6', 'LV', 4.46, 31, 0.4097, 3.6224, 5.2959, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.c.1', 'IM', 3.73, 32, 0.1968, 3.3260, 4.1289, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.c.1', 'LV', 4.65, 32, 0.3909, 3.8510, 5.4454, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.c.2', 'IM', 3.38, 32, 0.3533, 2.6599, 4.1010, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.c.2', 'LV', 3.84, 31, 0.5378, 2.7449, 4.9415, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.c.3', 'IM', 3.17, 32, 0.3559, 2.4465, 3.8983, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.c.3', 'LV', 3.77, 32, 0.5194, 2.7102, 4.8287, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.a.1', 'IM', 4.73, 17, 0.1547, 4.4053, 5.0000, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.a.1', 'LV', 5.31, 17, 0.3260, 4.6207, 6.0029, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.a.2', 'IM', 3.76, 17, 0.2088, 3.3219, 4.2069, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.a.2', 'LV', 4.76, 17, 0.2480, 4.2349, 5.2865, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.b.1', 'IM', 4.19, 17, 0.1826, 3.8054, 4.5796, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.b.1', 'LV', 5.11, 17, 0.4217, 4.2204, 6.0084, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.b.2', 'IM', 3.61, 16, 0.4443, 2.6673, 4.5615, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.b.2', 'LV', 3.75, 17, 0.5702, 2.5375, 4.9549, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.b.3', 'IM', 4.06, 17, 0.1590, 3.7219, 4.3959, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.b.3', 'LV', 4.07, 17, 0.1953, 3.6512, 4.4791, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.1', 'IM', 3.64, 17, 0.2811, 3.0392, 4.2309, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.1', 'LV', 4.08, 17, 0.2667, 3.5099, 4.6404, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.2', 'IM', 4.05, 17, 0.1280, 3.7797, 4.3223, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.2', 'LV', 5.32, 17, 0.1845, 4.9253, 5.7076, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.3', 'IM', 4.47, 17, 0.2494, 3.9410, 4.9983, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.3', 'LV', 5.48, 17, 0.6005, 4.2086, 6.7545, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.4', 'IM', 3.78, 17, 0.1723, 3.4159, 4.1464, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.4', 'LV', 4.39, 17, 0.1764, 4.0205, 4.7686, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.1', 'IM', 4.43, 17, 0.2513, 3.8967, 4.9623, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.1', 'LV', 5.78, 17, 0.4909, 4.7375, 6.8189, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.2', 'IM', 4.22, 17, 0.1558, 3.8911, 4.5516, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.2', 'LV', 5.18, 17, 0.1927, 4.7704, 5.5874, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.3', 'IM', 4.29, 17, 0.1392, 3.9949, 4.5852, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.3', 'LV', 5.12, 17, 0.2525, 4.5820, 5.6527, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.4', 'IM', 2.95, 15, 0.4416, 2.0044, 3.8989, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.4', 'LV', 3.37, 15, 0.4627, 2.3784, 4.3632, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.5', 'IM', 3.49, 15, 0.2215, 3.0125, 3.9627, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.5', 'LV', 5.29, 16, 0.1557, 4.9589, 5.6225, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.6', 'IM', 4.16, 17, 0.1189, 3.9117, 4.4157, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.6', 'LV', 5.57, 17, 0.1326, 5.2887, 5.8510, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.1', 'IM', 1.94, 17, 0.1227, 1.6806, 2.2010, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.1', 'LV', 2.12, 17, 0.3573, 1.3617, 2.8766, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.2', 'IM', 1.76, 17, 0.1822, 1.3731, 2.1456, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.2', 'LV', 2.32, 17, 0.4037, 1.4633, 3.1751, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.3', 'IM', 2.19, 17, 0.3355, 1.4780, 2.9005, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.3', 'LV', 2.56, 17, 0.5220, 1.4563, 3.6694, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.4', 'IM', 1.92, 17, 0.1553, 1.5951, 2.2534, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.4', 'LV', 1.70, 17, 0.2562, 1.1551, 2.2413, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.1', 'IM', 4.55, 17, 0.2081, 4.1124, 4.9945, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.1', 'LV', 4.16, 17, 0.1724, 3.7937, 4.5247, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.2', 'IM', 4.32, 17, 0.2919, 3.7047, 4.9424, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.2', 'LV', 5.41, 17, 0.2638, 4.8486, 5.9670, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.4', 'IM', 1.79, 17, 0.3658, 1.0120, 2.5628, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.4', 'LV', 1.46, 17, 0.6989, 0.0000, 2.9379, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.5', 'IM', 1.90, 17, 0.2591, 1.3502, 2.4490, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.5', 'LV', 1.55, 17, 0.4275, 0.6447, 2.4573, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.6', 'IM', 3.77, 17, 0.3224, 3.0872, 4.4542, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.6', 'LV', 4.14, 17, 0.3153, 3.4735, 4.8101, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.1', 'IM', 3.50, 17, 0.2076, 3.0556, 3.9356, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.1', 'LV', 4.54, 17, 0.2953, 3.9144, 5.1666, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.2', 'IM', 4.65, 17, 0.1773, 4.2780, 5.0000, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.2', 'LV', 5.04, 17, 0.1072, 4.8098, 5.2643, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.3', 'IM', 4.43, 16, 0.2669, 3.8641, 5.0000, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.3', 'LV', 5.58, 16, 0.6143, 4.2725, 6.8913, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.4', 'IM', 3.81, 16, 0.1916, 3.4006, 4.2174, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.4', 'LV', 4.86, 17, 0.1311, 4.5819, 5.1376, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.5', 'IM', 2.33, 17, 0.2010, 1.9015, 2.7537, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.5', 'LV', 2.37, 17, 0.2964, 1.7407, 2.9973, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.6', 'IM', 2.80, 17, 0.1575, 2.4701, 3.1378, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.6', 'LV', 3.87, 17, 0.4509, 2.9118, 4.8234, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.7', 'IM', 3.40, 17, 0.3649, 2.6236, 4.1707, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.7', 'LV', 4.87, 17, 0.0877, 4.6810, 5.0530, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.8', 'IM', 2.44, 17, 0.2790, 1.8475, 3.0305, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.8', 'LV', 2.63, 17, 0.4436, 1.6859, 3.5665, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.1', 'IM', 4.55, 17, 0.2210, 4.0837, 5.0000, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.1', 'LV', 5.77, 17, 0.3245, 5.0824, 6.4581, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.2', 'IM', 3.54, 17, 0.2502, 3.0064, 4.0670, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.2', 'LV', 4.32, 17, 0.2182, 3.8549, 4.7798, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.3', 'IM', 3.86, 17, 0.1374, 3.5647, 4.1474, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.3', 'LV', 4.77, 17, 0.3014, 4.1346, 5.4124, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.4', 'IM', 4.26, 17, 0.1700, 3.9020, 4.6229, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.4', 'LV', 4.57, 17, 0.1959, 4.1530, 4.9834, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.5', 'IM', 3.88, 17, 0.1575, 3.5484, 4.2163, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.5', 'LV', 5.08, 17, 0.3822, 4.2657, 5.8861, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.6', 'IM', 2.98, 17, 0.2165, 2.5233, 3.4411, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.6', 'LV', 3.74, 17, 0.3654, 2.9656, 4.5147, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.c.1', 'IM', 2.63, 17, 0.4722, 1.6307, 3.6325, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.c.1', 'LV', 2.87, 17, 0.5725, 1.6529, 4.0802, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.c.2', 'IM', 2.95, 17, 0.4586, 1.9761, 3.9204, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.c.2', 'LV', 3.19, 17, 0.4847, 2.1641, 4.2191, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.c.3', 'IM', 2.77, 17, 0.3494, 2.0274, 3.5086, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.c.3', 'LV', 4.05, 17, 0.1547, 3.7250, 4.3810, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.a.1', 'IM', 4.49, 31, 0.1331, 4.2138, 4.7575, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.a.1', 'LV', 5.19, 31, 0.3633, 4.4504, 5.9343, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.a.2', 'IM', 4.08, 31, 0.1678, 3.7369, 4.4224, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.a.2', 'LV', 5.13, 31, 0.1548, 4.8143, 5.4466, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.b.1', 'IM', 4.05, 31, 0.1158, 3.8086, 4.2818, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.b.1', 'LV', 5.46, 31, 0.1584, 5.1383, 5.7855, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.b.2', 'IM', 3.29, 31, 0.1018, 3.0813, 3.4971, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.b.2', 'LV', 4.12, 31, 0.1832, 3.7489, 4.4972, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.b.3', 'IM', 3.97, 31, 0.1773, 3.6030, 4.3274, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.b.3', 'LV', 4.43, 31, 0.1546, 4.1094, 4.7411, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.1', 'IM', 3.86, 31, 0.2425, 3.3694, 4.3597, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.1', 'LV', 4.62, 31, 0.2342, 4.1467, 5.1032, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.2', 'IM', 4.32, 31, 0.1876, 3.9377, 4.7038, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.2', 'LV', 5.87, 31, 0.1713, 5.5235, 6.2234, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.3', 'IM', 3.72, 31, 0.2635, 3.1869, 4.2631, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.3', 'LV', 4.29, 31, 0.2593, 3.7589, 4.8180, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.4', 'IM', 4.52, 31, 0.1285, 4.2535, 4.7783, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.4', 'LV', 5.74, 31, 0.1886, 5.3512, 6.1213, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.1', 'IM', 4.56, 31, 0.1269, 4.3025, 4.8208, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.1', 'LV', 5.28, 31, 0.1853, 4.9002, 5.6569, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.2', 'IM', 4.05, 31, 0.1194, 3.8020, 4.2896, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.2', 'LV', 5.53, 31, 0.2707, 4.9767, 6.0824, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.3', 'IM', 4.09, 31, 0.1586, 3.7682, 4.4158, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.3', 'LV', 5.56, 31, 0.1857, 5.1822, 5.9408, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.4', 'IM', 4.03, 31, 0.1762, 3.6662, 4.3857, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.4', 'LV', 4.57, 31, 0.2055, 4.1478, 4.9873, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.5', 'IM', 3.46, 30, 0.2950, 2.8560, 4.0627, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.5', 'LV', 4.52, 31, 0.2278, 4.0499, 4.9803, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.6', 'IM', 3.85, 31, 0.1375, 3.5666, 4.1283, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.6', 'LV', 5.29, 31, 0.2057, 4.8724, 5.7125, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.1', 'IM', 2.74, 30, 0.2077, 2.3182, 3.1679, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.1', 'LV', 3.17, 30, 0.4216, 2.3099, 4.0343, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.2', 'IM', 2.35, 31, 0.1426, 2.0558, 2.6381, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.2', 'LV', 3.41, 31, 0.4295, 2.5304, 4.2849, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.3', 'IM', 3.28, 31, 0.3460, 2.5757, 3.9889, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.3', 'LV', 3.91, 31, 0.4384, 3.0146, 4.8052, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.4', 'IM', 1.81, 31, 0.2167, 1.3664, 2.2515, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.4', 'LV', 1.78, 31, 0.5056, 0.7463, 2.8116, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.1', 'IM', 4.59, 31, 0.1515, 4.2836, 4.9024, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.1', 'LV', 4.26, 31, 0.2462, 3.7552, 4.7610, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.2', 'IM', 2.80, 31, 0.4355, 1.9076, 3.6864, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.2', 'LV', 3.33, 31, 0.5766, 2.1493, 4.5044, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.4', 'IM', 2.40, 31, 0.4460, 1.4929, 3.3146, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.4', 'LV', 3.06, 31, 0.7838, 1.4554, 4.6570, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.5', 'IM', 2.81, 31, 0.3679, 2.0570, 3.5596, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.5', 'LV', 3.41, 31, 0.7200, 1.9414, 4.8824, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.6', 'IM', 4.01, 31, 0.1100, 3.7871, 4.2363, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.6', 'LV', 4.54, 31, 0.3310, 3.8628, 5.2149, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.1', 'IM', 3.90, 31, 0.0698, 3.7598, 4.0447, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.1', 'LV', 5.27, 31, 0.2575, 4.7421, 5.7940, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.2', 'IM', 4.28, 31, 0.1456, 3.9804, 4.5750, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.2', 'LV', 5.39, 31, 0.3296, 4.7167, 6.0631, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.3', 'IM', 3.67, 31, 0.2727, 3.1109, 4.2247, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.3', 'LV', 4.46, 31, 0.3879, 3.6695, 5.2539, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.4', 'IM', 3.65, 31, 0.1536, 3.3404, 3.9676, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.4', 'LV', 4.87, 31, 0.2156, 4.4281, 5.3086, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.5', 'IM', 2.57, 31, 0.2012, 2.1622, 2.9840, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.5', 'LV', 2.58, 31, 0.4067, 1.7452, 3.4063, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.6', 'IM', 2.87, 31, 0.2547, 2.3458, 3.3863, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.6', 'LV', 3.57, 31, 0.4220, 2.7089, 4.4326, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.7', 'IM', 2.85, 31, 0.1489, 2.5501, 3.1584, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.7', 'LV', 3.90, 31, 0.2732, 3.3413, 4.4572, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.8', 'IM', 2.04, 31, 0.2045, 1.6196, 2.4547, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.8', 'LV', 2.25, 31, 0.3817, 1.4674, 3.0264, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.1', 'IM', 3.84, 31, 0.1785, 3.4773, 4.2063, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.1', 'LV', 4.16, 31, 0.3370, 3.4703, 4.8467, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.2', 'IM', 4.08, 30, 0.1399, 3.7924, 4.3645, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.2', 'LV', 4.24, 30, 0.3990, 3.4214, 5.0535, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.3', 'IM', 3.24, 31, 0.1153, 3.0022, 3.4730, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.3', 'LV', 3.79, 31, 0.2175, 3.3495, 4.2380, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.4', 'IM', 3.40, 31, 0.2584, 2.8743, 3.9296, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.4', 'LV', 4.11, 31, 0.3682, 3.3537, 4.8578, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.5', 'IM', 2.93, 31, 0.1472, 2.6288, 3.2300, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.5', 'LV', 3.91, 31, 0.1256, 3.6563, 4.1693, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.6', 'IM', 3.46, 31, 0.1540, 3.1474, 3.7763, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.6', 'LV', 5.30, 31, 0.4214, 4.4364, 6.1575, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.c.1', 'IM', 2.49, 31, 0.2012, 2.0808, 2.9025, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.c.1', 'LV', 3.07, 31, 0.4941, 2.0575, 4.0758, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.c.2', 'IM', 2.58, 30, 0.2601, 2.0450, 3.1087, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.c.2', 'LV', 3.13, 30, 0.3357, 2.4391, 3.8121, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.c.3', 'IM', 3.42, 31, 0.2299, 2.9514, 3.8904, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.c.3', 'LV', 4.31, 31, 0.3452, 3.6003, 5.0102, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.a.1', 'IM', 4.28, 38, 0.1132, 4.0556, 4.5141, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.a.1', 'LV', 4.16, 37, 0.2786, 3.5905, 4.7207, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.a.2', 'IM', 3.97, 38, 0.1725, 3.6208, 4.3200, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.a.2', 'LV', 3.10, 38, 0.3092, 2.4714, 3.7245, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.b.1', 'IM', 4.36, 38, 0.1389, 4.0776, 4.6403, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.b.1', 'LV', 4.59, 38, 0.1963, 4.1892, 4.9847, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.b.2', 'IM', 3.99, 38, 0.2545, 3.4736, 4.5050, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.b.2', 'LV', 2.67, 38, 0.3777, 1.9072, 3.4376, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.b.3', 'IM', 3.80, 37, 0.2653, 3.2623, 4.3384, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.b.3', 'LV', 2.64, 36, 0.3648, 1.8982, 3.3794, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.1', 'IM', 3.67, 38, 0.2895, 3.0839, 4.2570, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.1', 'LV', 3.10, 36, 0.4795, 2.1272, 4.0740, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.2', 'IM', 3.44, 38, 0.3296, 2.7738, 4.1093, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.2', 'LV', 2.94, 38, 0.3854, 2.1555, 3.7171, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.3', 'IM', 4.01, 38, 0.2911, 3.4189, 4.5985, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.3', 'LV', 3.03, 38, 0.3258, 2.3680, 3.6881, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.4', 'IM', 3.29, 38, 0.3087, 2.6667, 3.9178, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.4', 'LV', 2.71, 38, 0.4588, 1.7786, 3.6376, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.1', 'IM', 4.24, 38, 0.1978, 3.8373, 4.6387, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.1', 'LV', 3.56, 38, 0.4722, 2.6058, 4.5193, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.2', 'IM', 3.52, 38, 0.3345, 2.8442, 4.1996, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.2', 'LV', 3.15, 37, 0.4214, 2.2948, 4.0041, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.3', 'IM', 3.64, 38, 0.3392, 2.9558, 4.3305, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.3', 'LV', 3.32, 38, 0.4207, 2.4692, 4.1741, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.4', 'IM', 3.46, 38, 0.3313, 2.7930, 4.1355, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.4', 'LV', 3.23, 37, 0.5543, 2.1027, 4.3509, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.5', 'IM', 3.68, 38, 0.3292, 3.0158, 4.3498, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.5', 'LV', 3.63, 37, 0.5220, 2.5674, 4.6848, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.6', 'IM', 3.65, 37, 0.3565, 2.9298, 4.3759, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.6', 'LV', 3.73, 37, 0.5247, 2.6661, 4.7942, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.1', 'IM', 3.85, 38, 0.3031, 3.2325, 4.4609, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.1', 'LV', 3.19, 37, 0.3766, 2.4311, 3.9588, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.2', 'IM', 3.63, 37, 0.2730, 3.0782, 4.1856, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.2', 'LV', 4.71, 38, 0.3917, 3.9139, 5.5011, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.3', 'IM', 2.96, 38, 0.3126, 2.3260, 3.5929, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.3', 'LV', 2.66, 37, 0.3235, 2.0069, 3.3191, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.4', 'IM', 1.93, 37, 0.3871, 1.1487, 2.7189, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.4', 'LV', 1.18, 38, 0.5101, 0.1512, 2.2183, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.1', 'IM', 3.26, 36, 0.2983, 2.6568, 3.8679, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.1', 'LV', 2.43, 37, 0.2199, 1.9821, 2.8740, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.2', 'IM', 2.21, 37, 0.3541, 1.4950, 2.9312, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.2', 'LV', 1.68, 38, 0.4931, 0.6837, 2.6818, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.4', 'IM', 2.50, 37, 0.3771, 1.7361, 3.2658, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.4', 'LV', 2.06, 38, 0.5970, 0.8460, 3.2653, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.5', 'IM', 2.36, 35, 0.4087, 1.5267, 3.1877, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.5', 'LV', 1.82, 37, 0.4758, 0.8548, 2.7850, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.6', 'IM', 3.07, 38, 0.3121, 2.4387, 3.7035, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.6', 'LV', 2.35, 38, 0.3621, 1.6146, 3.0819, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.1', 'IM', 3.21, 37, 0.3232, 2.5502, 3.8612, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.1', 'LV', 2.29, 37, 0.3869, 1.5011, 3.0704, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.2', 'IM', 3.96, 37, 0.4378, 3.0742, 4.8499, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.2', 'LV', 3.75, 37, 0.5981, 2.5402, 4.9664, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.3', 'IM', 3.34, 37, 0.4220, 2.4804, 4.1922, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.3', 'LV', 2.88, 37, 0.4847, 1.8983, 3.8644, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.4', 'IM', 4.03, 36, 0.2560, 3.5127, 4.5523, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.4', 'LV', 3.90, 37, 0.3130, 3.2677, 4.5373, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.5', 'IM', 3.00, 38, 0.3116, 2.3656, 3.6282, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.5', 'LV', 3.23, 38, 0.4799, 2.2613, 4.2061, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.6', 'IM', 3.37, 38, 0.4028, 2.5545, 4.1866, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.6', 'LV', 2.80, 38, 0.4978, 1.7880, 3.8052, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.7', 'IM', 3.70, 37, 0.1888, 3.3131, 4.0790, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.7', 'LV', 3.81, 36, 0.3324, 3.1380, 4.4877, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.8', 'IM', 3.63, 38, 0.3228, 2.9750, 4.2833, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.8', 'LV', 3.49, 37, 0.2756, 2.9271, 4.0452, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.1', 'IM', 4.05, 38, 0.2673, 3.5044, 4.5877, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.1', 'LV', 3.67, 38, 0.4754, 2.7024, 4.6290, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.2', 'IM', 3.63, 37, 0.3208, 2.9838, 4.2850, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.2', 'LV', 3.58, 37, 0.5909, 2.3865, 4.7833, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.3', 'IM', 4.15, 37, 0.3238, 3.4961, 4.8095, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.3', 'LV', 3.24, 38, 0.3090, 2.6177, 3.8700, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.4', 'IM', 3.93, 37, 0.4272, 3.0678, 4.8005, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.4', 'LV', 4.13, 38, 0.6058, 2.9010, 5.3558, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.5', 'IM', 4.16, 38, 0.2902, 3.5717, 4.7479, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.5', 'LV', 4.46, 38, 0.4736, 3.5013, 5.4204, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.6', 'IM', 3.34, 38, 0.3551, 2.6229, 4.0618, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.6', 'LV', 3.06, 38, 0.5651, 1.9165, 4.2063, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.c.1', 'IM', 3.41, 38, 0.3130, 2.7744, 4.0428, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.c.1', 'LV', 2.87, 38, 0.4521, 1.9553, 3.7874, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.c.2', 'IM', 3.90, 36, 0.3107, 3.2725, 4.5342, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.c.2', 'LV', 4.42, 36, 0.3914, 3.6276, 5.2168, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.c.3', 'IM', 3.65, 37, 0.4789, 2.6771, 4.6198, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.c.3', 'LV', 3.75, 37, 0.6082, 2.5138, 4.9807, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.a.1', 'IM', 4.19, 19, 0.1357, 3.9006, 4.4706, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.a.1', 'LV', 4.42, 20, 0.2183, 3.9659, 4.8796, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.a.2', 'IM', 3.65, 21, 0.1767, 3.2808, 4.0180, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.a.2', 'LV', 4.05, 21, 0.1447, 3.7507, 4.3542, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.b.1', 'IM', 3.66, 21, 0.1653, 3.3168, 4.0063, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.b.1', 'LV', 4.31, 21, 0.3214, 3.6440, 4.9849, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.b.2', 'IM', 2.82, 21, 0.3065, 2.1769, 3.4555, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.b.2', 'LV', 2.67, 21, 0.2585, 2.1293, 3.2075, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.b.3', 'IM', 2.83, 21, 0.2751, 2.2523, 3.3999, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.b.3', 'LV', 2.92, 21, 0.3760, 2.1323, 3.7010, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.1', 'IM', 3.39, 21, 0.2634, 2.8405, 3.9396, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.1', 'LV', 3.35, 21, 0.2929, 2.7374, 3.9592, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.2', 'IM', 3.65, 21, 0.2718, 3.0783, 4.2120, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.2', 'LV', 3.98, 21, 0.2813, 3.3962, 4.5697, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.3', 'IM', 4.16, 20, 0.1495, 3.8464, 4.4720, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.3', 'LV', 4.17, 21, 0.3655, 3.4104, 4.9350, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.4', 'IM', 3.71, 21, 0.2680, 3.1472, 4.2654, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.4', 'LV', 3.68, 21, 0.3551, 2.9405, 4.4218, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.1', 'IM', 4.21, 21, 0.1662, 3.8599, 4.5531, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.1', 'LV', 3.85, 21, 0.3014, 3.2227, 4.4803, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.2', 'IM', 3.29, 20, 0.2539, 2.7606, 3.8236, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.2', 'LV', 3.44, 20, 0.2894, 2.8378, 4.0491, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.3', 'IM', 3.40, 21, 0.4077, 2.5452, 4.2459, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.3', 'LV', 4.03, 21, 0.4050, 3.1819, 4.8717, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.4', 'IM', 3.29, 21, 0.2513, 2.7638, 3.8122, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.4', 'LV', 3.64, 21, 0.3661, 2.8768, 4.4040, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.5', 'IM', 3.66, 21, 0.3951, 2.8390, 4.4874, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.5', 'LV', 4.13, 21, 0.1802, 3.7538, 4.5056, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.6', 'IM', 3.62, 21, 0.1872, 3.2308, 4.0119, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.6', 'LV', 4.45, 21, 0.3214, 3.7825, 5.1234, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.1', 'IM', 2.17, 21, 0.3268, 1.4925, 2.8560, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.1', 'LV', 2.07, 21, 0.4501, 1.1265, 3.0044, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.2', 'IM', 2.30, 21, 0.3460, 1.5772, 3.0208, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.2', 'LV', 2.93, 21, 0.7131, 1.4394, 4.4143, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.3', 'IM', 2.79, 21, 0.3853, 1.9861, 3.5937, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.3', 'LV', 2.39, 21, 0.2827, 1.7983, 2.9776, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.4', 'IM', 1.53, 20, 0.2489, 1.0061, 2.0480, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.4', 'LV', 0.96, 21, 0.3831, 0.1634, 1.7618, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.1', 'IM', 4.05, 20, 0.3208, 3.3756, 4.7184, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.1', 'LV', 3.10, 21, 0.1436, 2.8004, 3.3994, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.2', 'IM', 1.79, 21, 0.3036, 1.1551, 2.4218, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.2', 'LV', 1.22, 21, 0.4879, 0.2018, 2.2371, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.4', 'IM', 1.93, 20, 0.4320, 1.0247, 2.8332, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.4', 'LV', 1.37, 20, 0.5951, 0.1233, 2.6145, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.5', 'IM', 2.05, 21, 0.4032, 1.2099, 2.8922, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.5', 'LV', 1.54, 21, 0.5161, 0.4602, 2.6131, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.6', 'IM', 3.89, 21, 0.2205, 3.4273, 4.3472, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.6', 'LV', 3.07, 21, 0.1830, 2.6893, 3.4529, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.1', 'IM', 3.33, 21, 0.2451, 2.8215, 3.8439, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.1', 'LV', 2.43, 21, 0.3495, 1.6977, 3.1558, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.2', 'IM', 4.35, 21, 0.1398, 4.0578, 4.6410, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.2', 'LV', 4.68, 21, 0.2876, 4.0773, 5.2772, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.3', 'IM', 3.05, 21, 0.3491, 2.3219, 3.7782, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.3', 'LV', 2.67, 21, 0.4154, 1.8042, 3.5373, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.4', 'IM', 3.88, 21, 0.2645, 3.3236, 4.4272, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.4', 'LV', 4.79, 21, 0.2195, 4.3294, 5.2450, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.5', 'IM', 2.50, 21, 0.3805, 1.7093, 3.2969, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.5', 'LV', 2.59, 21, 0.6552, 1.2277, 3.9610, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.6', 'IM', 2.56, 21, 0.1940, 2.1548, 2.9644, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.6', 'LV', 2.92, 21, 0.3400, 2.2149, 3.6334, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.7', 'IM', 4.06, 20, 0.2832, 3.4683, 4.6536, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.7', 'LV', 4.90, 21, 0.2249, 4.4314, 5.3698, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.8', 'IM', 4.32, 21, 0.3313, 3.6337, 5.0000, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.8', 'LV', 4.68, 21, 0.1603, 4.3434, 5.0123, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.1', 'IM', 3.46, 21, 0.3567, 2.7143, 4.2025, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.1', 'LV', 4.30, 21, 0.2254, 3.8340, 4.7742, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.2', 'IM', 3.51, 21, 0.1864, 3.1191, 3.8966, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.2', 'LV', 3.46, 21, 0.2871, 2.8647, 4.0625, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.3', 'IM', 3.64, 21, 0.3082, 2.9940, 4.2798, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.3', 'LV', 3.85, 21, 0.2445, 3.3359, 4.3561, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.4', 'IM', 3.68, 21, 0.3679, 2.9092, 4.4441, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.4', 'LV', 4.25, 21, 0.5482, 3.1063, 5.3934, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.5', 'IM', 3.84, 21, 0.2236, 3.3717, 4.3046, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.5', 'LV', 4.32, 21, 0.1775, 3.9483, 4.6887, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.6', 'IM', 3.30, 21, 0.1881, 2.9090, 3.6939, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.6', 'LV', 3.57, 21, 0.4062, 2.7193, 4.4139, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.c.1', 'IM', 3.20, 21, 0.3310, 2.5055, 3.8863, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.c.1', 'LV', 3.28, 21, 0.1948, 2.8693, 3.6818, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.c.2', 'IM', 3.73, 21, 0.1747, 3.3704, 4.0993, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.c.2', 'LV', 4.02, 21, 0.2203, 3.5645, 4.4838, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.c.3', 'IM', 3.32, 20, 0.2514, 2.7922, 3.8444, 'N', NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.c.3', 'LV', 3.88, 21, 0.2749, 3.3064, 4.4533, 'N', 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.1.a.1', 'IM', 4.42, 16, 0.1801, 4.0331, 4.8007, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.1.a.1', 'LV', 5.04, 17, 0.3797, 4.2382, 5.8479, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.1.a.2', 'IM', 3.61, 17, 0.2838, 3.0059, 4.2092, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.1.a.2', 'LV', 3.86, 16, 0.3258, 3.1663, 4.5552, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.1.b.1', 'IM', 3.96, 17, 0.2728, 3.3782, 4.5348, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.1.b.1', 'LV', 4.55, 16, 0.2860, 3.9406, 5.1597, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.1.b.2', 'IM', 2.88, 17, 0.4446, 1.9381, 3.8231, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.1.b.2', 'LV', 2.51, 17, 0.4611, 1.5359, 3.4908, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.1.b.3', 'IM', 3.33, 17, 0.1781, 2.9483, 3.7034, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.1.b.3', 'LV', 2.80, 17, 0.3752, 2.0090, 3.5998, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.a.1', 'IM', 3.44, 16, 0.3986, 2.5926, 4.2919, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.a.1', 'LV', 2.90, 17, 0.4239, 1.9968, 3.7940, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.a.2', 'IM', 3.38, 17, 0.4751, 2.3771, 4.3914, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.a.2', 'LV', 2.87, 17, 0.5161, 1.7764, 3.9647, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.a.3', 'IM', 2.85, 17, 0.4262, 1.9496, 3.7564, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.a.3', 'LV', 2.14, 17, 0.4422, 1.2031, 3.0777, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.a.4', 'IM', 3.16, 17, 0.4563, 2.1900, 4.1244, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.a.4', 'LV', 3.21, 17, 0.5807, 1.9811, 4.4430, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.b.1', 'IM', 4.58, 17, 0.2539, 4.0413, 5.0000, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.b.1', 'LV', 4.42, 17, 0.3376, 3.7087, 5.1402, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.b.2', 'IM', 4.60, 17, 0.1665, 4.2487, 4.9547, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.b.2', 'LV', 4.39, 17, 0.3354, 3.6743, 5.0965, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.b.3', 'IM', 4.09, 17, 0.2793, 3.4958, 4.6799, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.b.3', 'LV', 4.30, 17, 0.2115, 3.8525, 4.7491, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.b.4', 'IM', 3.89, 17, 0.1721, 3.5234, 4.2532, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.b.4', 'LV', 3.91, 17, 0.4710, 2.9132, 4.9100, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.b.5', 'IM', 4.19, 17, 0.2879, 3.5845, 4.8050, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.b.5', 'LV', 4.54, 17, 0.3637, 3.7722, 5.3143, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.b.6', 'IM', 4.37, 17, 0.1617, 4.0239, 4.7093, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.2.b.6', 'LV', 5.55, 17, 0.3493, 4.8137, 6.2946, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.a.1', 'IM', 3.62, 17, 0.3770, 2.8199, 4.4185, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.a.1', 'LV', 3.60, 17, 0.3087, 2.9434, 4.2522, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.a.2', 'IM', 3.39, 17, 0.3625, 2.6224, 4.1593, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.a.2', 'LV', 4.76, 17, 0.3883, 3.9339, 5.5805, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.a.3', 'IM', 1.95, 17, 0.2600, 1.3958, 2.4982, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.a.3', 'LV', 1.75, 17, 0.4875, 0.7130, 2.7800, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.a.4', 'IM', 2.44, 17, 0.3992, 1.5963, 3.2891, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.a.4', 'LV', 1.76, 17, 0.4972, 0.7065, 2.8145, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.b.1', 'IM', 4.34, 17, 0.1671, 3.9868, 4.6954, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.b.1', 'LV', 3.09, 17, 0.1208, 2.8373, 3.3496, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.b.2', 'IM', 1.67, 17, 0.2693, 1.0953, 2.2371, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.b.2', 'LV', 1.13, 17, 0.4680, 0.1338, 2.1178, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.b.4', 'IM', 1.78, 16, 0.3131, 1.1157, 2.4506, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.b.4', 'LV', 1.40, 17, 0.5167, 0.3025, 2.4933, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.b.5', 'IM', 1.94, 17, 0.2708, 1.3610, 2.5090, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.b.5', 'LV', 1.48, 17, 0.3933, 0.6490, 2.3166, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.b.6', 'IM', 3.74, 16, 0.3647, 2.9612, 4.5157, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.3.b.6', 'LV', 2.71, 17, 0.2141, 2.2566, 3.1645, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.1', 'IM', 4.31, 16, 0.2617, 3.7562, 4.8720, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.1', 'LV', 3.86, 17, 0.5029, 2.7979, 4.9303, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.2', 'IM', 4.67, 17, 0.1567, 4.3341, 4.9984, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.2', 'LV', 4.86, 17, 0.4149, 3.9758, 5.7347, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.3', 'IM', 4.39, 16, 0.3087, 3.7317, 5.0000, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.3', 'LV', 4.73, 17, 0.6035, 3.4469, 6.0058, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.4', 'IM', 4.63, 16, 0.1658, 4.2719, 4.9788, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.4', 'LV', 5.22, 16, 0.2913, 4.6021, 5.8440, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.5', 'IM', 3.51, 17, 0.4825, 2.4871, 4.5327, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.5', 'LV', 3.80, 17, 0.4238, 2.9063, 4.7030, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.6', 'IM', 2.94, 17, 0.3034, 2.2937, 3.5802, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.6', 'LV', 3.70, 17, 0.3347, 2.9888, 4.4078, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.7', 'IM', 4.25, 17, 0.3033, 3.6024, 4.8883, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.7', 'LV', 4.43, 17, 0.2988, 3.7927, 5.0597, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.8', 'IM', 4.25, 17, 0.3092, 3.5898, 4.9010, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.a.8', 'LV', 4.41, 17, 0.2992, 3.7768, 5.0453, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.b.1', 'IM', 3.66, 17, 0.3829, 2.8461, 4.4696, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.b.1', 'LV', 4.36, 17, 0.2925, 3.7401, 4.9804, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.b.2', 'IM', 4.13, 17, 0.2496, 3.5994, 4.6576, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.b.2', 'LV', 3.72, 17, 0.2055, 3.2877, 4.1590, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.b.3', 'IM', 4.32, 17, 0.3091, 3.6660, 4.9767, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.b.3', 'LV', 4.36, 17, 0.2662, 3.7914, 4.9201, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.b.4', 'IM', 4.31, 17, 0.2526, 3.7702, 4.8411, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.b.4', 'LV', 4.48, 17, 0.3394, 3.7610, 5.1999, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.b.5', 'IM', 3.94, 17, 0.3214, 3.2546, 4.6174, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.b.5', 'LV', 4.51, 17, 0.1789, 4.1314, 4.8898, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.b.6', 'IM', 3.50, 17, 0.3327, 2.7971, 4.2078, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.b.6', 'LV', 4.42, 17, 0.3799, 3.6098, 5.2204, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.c.1', 'IM', 3.37, 16, 0.1617, 3.0230, 3.7123, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.c.1', 'LV', 3.86, 17, 0.3139, 3.1921, 4.5228, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.c.2', 'IM', 3.90, 17, 0.3107, 3.2396, 4.5569, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.c.2', 'LV', 4.82, 17, 0.3152, 4.1553, 5.4916, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.c.3', 'IM', 3.46, 16, 0.1880, 3.0617, 3.8630, 'N', NULL, TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9072.00', '4.A.4.c.3', 'LV', 4.20, 16, 0.2277, 3.7151, 4.6858, 'N', 'N', TO_DATE('2025-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.a.1', 'IM', 4.28, 19, 0.2002, 3.8604, 4.7017, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.a.1', 'LV', 4.46, 19, 0.3047, 3.8247, 5.1050, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.a.2', 'IM', 3.34, 19, 0.4452, 2.4010, 4.2718, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.a.2', 'LV', 3.76, 19, 0.7087, 2.2754, 5.2531, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.b.1', 'IM', 4.27, 18, 0.2763, 3.6881, 4.8541, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.b.1', 'LV', 4.72, 18, 0.4581, 3.7534, 5.6866, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.b.2', 'IM', 3.12, 19, 0.5178, 2.0370, 4.2127, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.b.2', 'LV', 2.31, 19, 0.6563, 0.9362, 3.6937, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.b.3', 'IM', 2.28, 19, 0.4395, 1.3583, 3.2050, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.b.3', 'LV', 1.88, 19, 0.6883, 0.4304, 3.3224, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.1', 'IM', 3.19, 18, 0.4595, 2.2222, 4.1613, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.1', 'LV', 3.22, 18, 0.7558, 1.6266, 4.8156, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.2', 'IM', 3.56, 19, 0.4225, 2.6678, 4.4430, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.2', 'LV', 3.71, 19, 0.6893, 2.2580, 5.1544, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.3', 'IM', 3.50, 19, 0.3696, 2.7255, 4.2787, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.3', 'LV', 3.32, 19, 0.7129, 1.8241, 4.8194, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.4', 'IM', 3.48, 19, 0.3806, 2.6809, 4.2801, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.4', 'LV', 3.70, 18, 0.7567, 2.1004, 5.2935, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.1', 'IM', 4.38, 19, 0.2363, 3.8789, 4.8720, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.1', 'LV', 5.05, 18, 0.4738, 4.0532, 6.0524, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.2', 'IM', 3.98, 19, 0.2123, 3.5390, 4.4308, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.2', 'LV', 4.14, 19, 0.4776, 3.1330, 5.1397, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.3', 'IM', 3.59, 19, 0.3620, 2.8323, 4.3533, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.3', 'LV', 3.60, 18, 0.6425, 2.2413, 4.9523, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.4', 'IM', 3.86, 19, 0.3170, 3.1943, 4.5261, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.4', 'LV', 4.07, 18, 0.5522, 2.9048, 5.2347, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.5', 'IM', 3.96, 18, 0.2207, 3.4980, 4.4292, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.5', 'LV', 4.54, 17, 0.4987, 3.4835, 5.5977, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.6', 'IM', 3.95, 19, 0.1686, 3.5984, 4.3069, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.6', 'LV', 4.83, 19, 0.4509, 3.8845, 5.7790, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.1', 'IM', 2.61, 19, 0.4528, 1.6637, 3.5661, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.1', 'LV', 2.53, 19, 0.7446, 0.9695, 4.0983, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.2', 'IM', 2.66, 19, 0.4228, 1.7674, 3.5440, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.2', 'LV', 3.34, 19, 0.8284, 1.5988, 5.0794, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.3', 'IM', 2.53, 19, 0.4338, 1.6228, 3.4456, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.3', 'LV', 2.48, 19, 0.6917, 1.0298, 3.9363, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.4', 'IM', 2.53, 19, 0.4551, 1.5783, 3.4905, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.4', 'LV', 1.90, 19, 0.6657, 0.5051, 3.3023, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.1', 'IM', 4.27, 19, 0.3339, 3.5719, 4.9748, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.1', 'LV', 4.12, 19, 0.5788, 2.9079, 5.3401, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.2', 'IM', 1.62, 18, 0.4359, 1.0000, 2.5386, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.2', 'LV', 1.12, 18, 0.7661, 0.0000, 2.7381, 'Y', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.4', 'IM', 2.09, 19, 0.5151, 1.0104, 3.1746, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.4', 'LV', 1.74, 19, 0.8096, 0.0439, 3.4458, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.5', 'IM', 1.88, 19, 0.4250, 1.0000, 2.7714, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.5', 'LV', 1.37, 19, 0.7351, 0.0000, 2.9187, 'Y', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.6', 'IM', 3.38, 19, 0.4889, 2.3483, 4.4025, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.6', 'LV', 3.43, 19, 0.7679, 1.8151, 5.0419, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.1', 'IM', 3.07, 19, 0.4661, 2.0868, 4.0453, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.1', 'LV', 2.81, 19, 0.7905, 1.1534, 4.4748, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.2', 'IM', 4.47, 19, 0.2562, 3.9321, 5.0000, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.2', 'LV', 4.87, 19, 0.4860, 3.8539, 5.8958, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.3', 'IM', 4.16, 19, 0.3188, 3.4858, 4.8255, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.3', 'LV', 4.70, 19, 0.6072, 3.4272, 5.9784, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.4', 'IM', 4.14, 19, 0.3374, 3.4286, 4.8464, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.4', 'LV', 5.12, 19, 0.4817, 4.1115, 6.1355, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.5', 'IM', 3.72, 19, 0.4094, 2.8561, 4.5763, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.5', 'LV', 4.25, 19, 0.5496, 3.0941, 5.4035, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.6', 'IM', 3.58, 19, 0.4065, 2.7280, 4.4361, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.6', 'LV', 4.33, 19, 0.6675, 2.9282, 5.7328, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.7', 'IM', 4.11, 19, 0.2615, 3.5559, 4.6548, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.7', 'LV', 5.03, 19, 0.4859, 4.0094, 6.0513, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.8', 'IM', 4.16, 19, 0.3379, 3.4452, 4.8651, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.8', 'LV', 4.96, 19, 0.4459, 4.0277, 5.9013, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.1', 'IM', 4.19, 19, 0.3820, 3.3894, 4.9944, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.1', 'LV', 4.20, 19, 0.6815, 2.7633, 5.6268, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.2', 'IM', 3.73, 19, 0.4224, 2.8421, 4.6168, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.2', 'LV', 3.77, 19, 0.7178, 2.2647, 5.2806, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.3', 'IM', 4.29, 19, 0.2516, 3.7638, 4.8210, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.3', 'LV', 4.43, 19, 0.5602, 3.2512, 5.6053, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.4', 'IM', 3.85, 19, 0.3548, 3.1032, 4.5940, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.4', 'LV', 5.41, 19, 0.4172, 4.5350, 6.2882, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.5', 'IM', 4.02, 19, 0.3313, 3.3283, 4.7203, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.5', 'LV', 4.49, 19, 0.4280, 3.5947, 5.3932, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.6', 'IM', 3.47, 17, 0.4133, 2.5901, 4.3424, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.6', 'LV', 4.31, 19, 0.5713, 3.1084, 5.5089, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.c.1', 'IM', 4.07, 19, 0.3030, 3.4307, 4.7038, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.c.1', 'LV', 4.04, 19, 0.5610, 2.8603, 5.2175, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.c.2', 'IM', 3.92, 19, 0.3318, 3.2217, 4.6160, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.c.2', 'LV', 4.98, 19, 0.3307, 4.2853, 5.6747, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.c.3', 'IM', 3.16, 19, 0.3679, 2.3912, 3.9368, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.c.3', 'LV', 3.73, 19, 0.6344, 2.3987, 5.0644, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.1.a.1', 'IM', 4.48, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recomm