/*! START TRANSACTION */;
CREATE TABLE knowledge (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(7,4),
  lower_ci_bound DECIMAL(7,4),
  upper_ci_bound DECIMAL(7,4),
  recommend_suppress CHARACTER(1),
  not_relevant CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));
/*! COMMIT */;
/*! START TRANSACTION */;

INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.a', 'IM', 4.78, 28, 0.1102, 4.5564, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.a', 'LV', 6.50, 28, 0.2130, 6.0666, 6.9409, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.b', 'IM', 2.42, 28, 0.4651, 1.4662, 3.3749, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.b', 'LV', 2.69, 28, 0.8678, 0.9078, 4.4690, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.c', 'IM', 4.04, 28, 0.3480, 3.3246, 4.7526, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.c', 'LV', 4.98, 28, 0.6849, 3.5754, 6.3861, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.d', 'IM', 3.81, 28, 0.4018, 2.9881, 4.6368, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.d', 'LV', 5.04, 28, 0.6803, 3.6445, 6.4364, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.e', 'IM', 4.39, 28, 0.3139, 3.7507, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.e', 'LV', 5.94, 28, 0.5822, 4.7494, 7.0000, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.f', 'IM', 4.48, 28, 0.2271, 4.0162, 4.9480, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.f', 'LV', 5.78, 28, 0.4268, 4.9001, 6.6516, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.2.a', 'IM', 2.71, 28, 0.5408, 1.6020, 3.8214, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.2.a', 'LV', 2.92, 28, 0.9249, 1.0269, 4.8225, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.2.b', 'IM', 1.14, 27, 0.1180, 1.0000, 1.3843, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.2.b', 'LV', 0.40, 28, 0.2518, 0.0000, 0.9133, 'Y', 'Y', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.a', 'IM', 3.82, 28, 0.3764, 3.0447, 4.5893, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.a', 'LV', 5.19, 28, 0.6031, 3.9537, 6.4287, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.b', 'IM', 3.05, 28, 0.6046, 1.8138, 4.2948, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.b', 'LV', 3.51, 28, 1.0864, 1.2858, 5.7438, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.c', 'IM', 1.91, 28, 0.3703, 1.1511, 2.6707, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.c', 'LV', 1.75, 27, 0.7432, 0.2257, 3.2812, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.d', 'IM', 1.83, 27, 0.3102, 1.1952, 2.4705, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.d', 'LV', 1.55, 28, 0.5674, 0.3838, 2.7124, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.e', 'IM', 2.10, 28, 0.2060, 1.6747, 2.5202, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.e', 'LV', 1.92, 28, 0.3556, 1.1876, 2.6469, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.a', 'IM', 3.60, 28, 0.2062, 3.1738, 4.0201, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.a', 'LV', 4.63, 28, 0.2595, 4.1003, 5.1654, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.b', 'IM', 2.01, 28, 0.2230, 1.5519, 2.4669, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.b', 'LV', 1.28, 28, 0.2863, 0.6917, 1.8667, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.c', 'IM', 1.69, 28, 0.1903, 1.3039, 2.0847, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.c', 'LV', 1.38, 28, 0.2950, 0.7710, 1.9815, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.d', 'IM', 1.74, 28, 0.1867, 1.3539, 2.1199, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.d', 'LV', 1.26, 28, 0.3057, 0.6324, 1.8867, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.e', 'IM', 3.09, 27, 0.2774, 2.5178, 3.6583, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.e', 'LV', 3.48, 28, 0.4551, 2.5420, 4.4097, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.f', 'IM', 2.88, 28, 0.2602, 2.3450, 3.4129, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.f', 'LV', 2.53, 28, 0.3735, 1.7670, 3.2997, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.g', 'IM', 2.69, 27, 0.2707, 2.1349, 3.2479, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.g', 'LV', 2.66, 28, 0.4014, 1.8403, 3.4875, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.5.a', 'IM', 1.51, 28, 0.2429, 1.0086, 2.0054, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.5.a', 'LV', 0.65, 28, 0.2689, 0.0977, 1.2011, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.5.b', 'IM', 1.87, 28, 0.3173, 1.2151, 2.5171, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.5.b', 'LV', 1.53, 28, 0.5590, 0.3864, 2.6803, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.6', 'IM', 3.52, 28, 0.2650, 2.9752, 4.0628, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.6', 'LV', 4.60, 28, 0.5608, 3.4457, 5.7469, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.a', 'IM', 4.41, 27, 0.3320, 3.7241, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.a', 'LV', 3.91, 28, 0.4932, 2.8943, 4.9182, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.b', 'IM', 2.26, 28, 0.2475, 1.7485, 2.7640, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.b', 'LV', 1.97, 28, 0.3681, 1.2133, 2.7240, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.c', 'IM', 1.70, 28, 0.2083, 1.2697, 2.1245, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.c', 'LV', 0.74, 28, 0.2356, 0.2548, 1.2216, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.d', 'IM', 2.16, 28, 0.2757, 1.5976, 2.7289, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.d', 'LV', 1.85, 28, 0.2692, 1.2980, 2.4028, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.e', 'IM', 2.35, 27, 0.3093, 1.7105, 2.9821, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.e', 'LV', 2.74, 28, 0.4991, 1.7201, 3.7682, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.8.a', 'IM', 3.88, 27, 0.3801, 3.1005, 4.6631, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.8.a', 'LV', 3.35, 27, 0.2817, 2.7659, 3.9241, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.8.b', 'IM', 3.48, 28, 0.1987, 3.0739, 3.8891, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.8.b', 'LV', 3.58, 28, 0.2370, 3.0965, 4.0692, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.9.a', 'IM', 2.59, 28, 0.2120, 2.1568, 3.0266, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.9.a', 'LV', 2.51, 28, 0.7581, 0.9531, 4.0642, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.9.b', 'IM', 3.02, 27, 0.1363, 2.7442, 3.3047, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.9.b', 'LV', 3.25, 28, 0.2469, 2.7455, 3.7585, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.10', 'IM', 2.26, 28, 0.2505, 1.7457, 2.7735, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.10', 'LV', 2.32, 28, 0.2929, 1.7148, 2.9167, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.a', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.a', 'LV', 5.00, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.b', 'IM', 2.62, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.b', 'LV', 4.42, 26, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.c', 'IM', 3.19, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.c', 'LV', 3.85, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.d', 'IM', 3.15, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.d', 'LV', 4.33, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.e', 'IM', 3.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.e', 'LV', 4.44, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.f', 'IM', 3.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.f', 'LV', 3.78, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.2.a', 'IM', 2.19, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.2.a', 'LV', 2.41, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.2.b', 'IM', 2.07, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.2.b', 'LV', 2.19, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.a', 'IM', 2.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.a', 'LV', 3.59, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.b', 'IM', 2.96, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.b', 'LV', 3.37, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.c', 'IM', 2.85, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.c', 'LV', 3.19, 26, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.d', 'IM', 3.48, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.d', 'LV', 3.67, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.e', 'IM', 2.44, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.e', 'LV', 2.41, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.a', 'IM', 3.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.a', 'LV', 3.89, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.b', 'IM', 2.30, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.b', 'LV', 2.30, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.c', 'IM', 2.37, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.c', 'LV', 2.70, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.d', 'IM', 2.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.d', 'LV', 3.56, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.e', 'IM', 2.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.e', 'LV', 3.30, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.f', 'IM', 3.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.f', 'LV', 4.00, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.g', 'IM', 3.07, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.g', 'LV', 4.15, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.5.a', 'IM', 1.31, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.5.a', 'LV', 0.70, 27, NULL, NULL, NULL, NULL, 'Y', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.5.b', 'IM', 1.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.5.b', 'LV', 1.78, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.6', 'IM', 3.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.6', 'LV', 4.85, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.a', 'IM', 4.30, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.a', 'LV', 4.89, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.b', 'IM', 1.85, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.b', 'LV', 1.81, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.c', 'IM', 1.63, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.c', 'LV', 1.04, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.d', 'IM', 2.31, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.d', 'LV', 2.26, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.e', 'IM', 2.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.e', 'LV', 2.70, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.8.a', 'IM', 2.56, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.8.a', 'LV', 2.70, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.8.b', 'IM', 3.69, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.8.b', 'LV', 3.89, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.9.a', 'IM', 1.89, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.9.a', 'LV', 1.30, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.9.b', 'IM', 3.56, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.9.b', 'LV', 3.74, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.10', 'IM', 3.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.10', 'LV', 3.37, 27, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.a', 'IM', 4.25, 28, 0.1985, 3.8427, 4.6572, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.a', 'LV', 4.38, 28, 0.2137, 3.9458, 4.8227, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.b', 'IM', 3.21, 28, 0.2585, 2.6845, 3.7451, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.b', 'LV', 3.95, 27, 0.4819, 2.9558, 4.9368, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.c', 'IM', 3.20, 28, 0.3690, 2.4382, 3.9525, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.c', 'LV', 3.58, 28, 0.5789, 2.3873, 4.7628, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.d', 'IM', 2.99, 28, 0.3824, 2.2029, 3.7721, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.d', 'LV', 3.35, 28, 0.6629, 1.9942, 4.7147, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.e', 'IM', 4.15, 28, 0.2509, 3.6386, 4.6682, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.e', 'LV', 4.64, 28, 0.4967, 3.6251, 5.6632, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.f', 'IM', 3.44, 27, 0.2209, 2.9832, 3.8914, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.f', 'LV', 3.95, 27, 0.2047, 3.5314, 4.3728, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.2.a', 'IM', 3.57, 28, 0.3152, 2.9198, 4.2134, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.2.a', 'LV', 4.23, 26, 0.4949, 3.2155, 5.2540, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.2.b', 'IM', 1.32, 28, 0.1595, 1.0000, 1.6521, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.2.b', 'LV', 0.65, 28, 0.3159, 0.0015, 1.2977, 'N', 'Y', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.a', 'IM', 2.67, 28, 0.3454, 1.9597, 3.3769, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.a', 'LV', 3.00, 28, 0.5418, 1.8869, 4.1104, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.b', 'IM', 2.90, 28, 0.3619, 2.1550, 3.6402, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.b', 'LV', 3.27, 28, 0.5808, 2.0825, 4.4661, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.c', 'IM', 2.32, 28, 0.2974, 1.7091, 2.9294, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.c', 'LV', 2.59, 28, 0.5304, 1.5017, 3.6781, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.d', 'IM', 2.20, 28, 0.3370, 1.5082, 2.8912, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.d', 'LV', 2.26, 28, 0.5957, 1.0386, 3.4833, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.e', 'IM', 2.85, 28, 0.3331, 2.1709, 3.5379, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.e', 'LV', 3.44, 28, 0.5510, 2.3051, 4.5662, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.a', 'IM', 3.53, 28, 0.2090, 3.0983, 3.9561, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.a', 'LV', 4.07, 28, 0.1755, 3.7101, 4.4302, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.b', 'IM', 1.98, 28, 0.2604, 1.4506, 2.5192, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.b', 'LV', 1.85, 28, 0.4783, 0.8693, 2.8321, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.c', 'IM', 1.91, 28, 0.2782, 1.3390, 2.4806, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.c', 'LV', 1.97, 28, 0.5346, 0.8710, 3.0650, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.d', 'IM', 1.21, 28, 0.1030, 1.0012, 1.4238, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.d', 'LV', 0.39, 28, 0.1865, 0.0077, 0.7729, 'N', 'Y', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.e', 'IM', 2.53, 28, 0.2772, 1.9618, 3.0995, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.e', 'LV', 2.67, 28, 0.4421, 1.7585, 3.5726, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.f', 'IM', 1.93, 28, 0.2226, 1.4775, 2.3908, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.f', 'LV', 1.55, 28, 0.4028, 0.7230, 2.3760, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.g', 'IM', 1.46, 28, 0.2037, 1.0421, 1.8779, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.g', 'LV', 0.65, 27, 0.2879, 0.0562, 1.2398, 'N', 'Y', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.5.a', 'IM', 1.20, 28, 0.0995, 1.0000, 1.4072, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.5.a', 'LV', 0.30, 28, 0.1504, 0.0000, 0.6108, 'N', 'Y', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.5.b', 'IM', 1.60, 27, 0.1876, 1.2099, 1.9813, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.5.b', 'LV', 1.43, 27, 0.4755, 0.4533, 2.4081, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.6', 'IM', 2.79, 28, 0.2259, 2.3216, 3.2484, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.6', 'LV', 3.65, 28, 0.4114, 2.8044, 4.4929, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.a', 'IM', 3.70, 28, 0.2707, 3.1420, 4.2530, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.a', 'LV', 3.64, 28, 0.4002, 2.8185, 4.4608, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.b', 'IM', 1.40, 28, 0.1536, 1.0804, 1.7105, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.b', 'LV', 0.63, 28, 0.2613, 0.0987, 1.1711, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.c', 'IM', 1.28, 28, 0.1542, 1.0000, 1.5921, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.c', 'LV', 0.45, 28, 0.2357, 0.0000, 0.9354, 'Y', 'Y', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.d', 'IM', 1.35, 28, 0.1322, 1.0756, 1.6179, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.d', 'LV', 0.67, 28, 0.2407, 0.1744, 1.1621, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.e', 'IM', 1.23, 28, 0.0958, 1.0353, 1.4283, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.e', 'LV', 0.52, 28, 0.2064, 0.0981, 0.9452, 'N', 'Y', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.8.a', 'IM', 2.74, 28, 0.2734, 2.1749, 3.2968, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.8.a', 'LV', 2.40, 28, 0.3866, 1.6115, 3.1978, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.8.b', 'IM', 2.56, 28, 0.2075, 2.1348, 2.9862, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.8.b', 'LV', 2.96, 28, 0.3898, 2.1555, 3.7552, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.9.a', 'IM', 1.85, 28, 0.2013, 1.4350, 2.2612, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.9.a', 'LV', 1.43, 28, 0.3917, 0.6215, 2.2291, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.9.b', 'IM', 2.39, 28, 0.3150, 1.7401, 3.0328, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.9.b', 'LV', 2.31, 28, 0.5118, 1.2573, 3.3578, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.10', 'IM', 2.21, 28, 0.3067, 1.5806, 2.8390, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.10', 'LV', 1.66, 28, 0.4052, 0.8263, 2.4892, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.a', 'IM', 4.12, 27, 0.1626, 3.7873, 4.4558, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.a', 'LV', 4.41, 27, 0.1447, 4.1085, 4.7032, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.b', 'IM', 3.25, 27, 0.2232, 2.7920, 3.7098, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.b', 'LV', 4.34, 27, 0.2866, 3.7558, 4.9339, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.c', 'IM', 3.04, 27, 0.1926, 2.6403, 3.4321, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.c', 'LV', 2.94, 27, 0.2805, 2.3603, 3.5137, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.d', 'IM', 4.68, 27, 0.1257, 4.4181, 4.9347, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.d', 'LV', 5.58, 27, 0.2502, 5.0679, 6.0965, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.e', 'IM', 4.16, 27, 0.1820, 3.7845, 4.5327, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.e', 'LV', 5.39, 27, 0.2921, 4.7926, 5.9934, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.f', 'IM', 2.60, 26, 0.2206, 2.1502, 3.0587, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.f', 'LV', 3.08, 27, 0.3434, 2.3742, 3.7859, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.2.a', 'IM', 2.58, 27, 0.2124, 2.1441, 3.0174, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.2.a', 'LV', 2.68, 27, 0.3500, 1.9591, 3.3978, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.2.b', 'IM', 1.04, 26, 0.0415, 1.0000, 1.1279, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.2.b', 'LV', 0.08, 26, 0.0830, 0.0000, 0.2559, 'Y', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.a', 'IM', 3.31, 27, 0.2479, 2.8006, 3.8197, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.a', 'LV', 4.17, 27, 0.3668, 3.4168, 4.9246, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.b', 'IM', 1.91, 27, 0.2307, 1.4383, 2.3866, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.b', 'LV', 1.57, 27, 0.3625, 0.8229, 2.3131, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.c', 'IM', 2.79, 27, 0.3048, 2.1596, 3.4128, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.c', 'LV', 2.92, 27, 0.4477, 2.0004, 3.8407, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.d', 'IM', 1.44, 27, 0.1907, 1.0487, 1.8328, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.d', 'LV', 0.64, 27, 0.2870, 0.0491, 1.2291, 'N', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.e', 'IM', 1.41, 27, 0.1826, 1.0299, 1.7806, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.e', 'LV', 0.67, 27, 0.2906, 0.0713, 1.2661, 'N', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.a', 'IM', 3.16, 26, 0.2209, 2.7044, 3.6143, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.a', 'LV', 3.55, 27, 0.2598, 3.0185, 4.0865, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.b', 'IM', 1.34, 27, 0.1812, 1.0000, 1.7167, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.b', 'LV', 0.49, 27, 0.2749, 0.0000, 1.0593, 'Y', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.c', 'IM', 1.22, 27, 0.1454, 1.0000, 1.5177, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.c', 'LV', 0.37, 27, 0.2428, 0.0000, 0.8678, 'Y', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.d', 'IM', 1.23, 27, 0.1323, 1.0000, 1.5018, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.d', 'LV', 0.45, 27, 0.2516, 0.0000, 0.9717, 'Y', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.e', 'IM', 2.87, 27, 0.3119, 2.2251, 3.5074, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.e', 'LV', 2.74, 27, 0.4152, 1.8860, 3.5931, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.f', 'IM', 2.50, 27, 0.2559, 1.9771, 3.0291, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.f', 'LV', 2.77, 27, 0.3831, 1.9847, 3.5599, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.g', 'IM', 1.99, 26, 0.2098, 1.5557, 2.4200, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.g', 'LV', 2.07, 26, 0.3988, 1.2436, 2.8864, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.5.a', 'IM', 1.42, 27, 0.1652, 1.0830, 1.7620, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.5.a', 'LV', 0.48, 27, 0.1750, 0.1213, 0.8407, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.5.b', 'IM', 1.75, 27, 0.2316, 1.2764, 2.2286, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.5.b', 'LV', 1.42, 27, 0.4005, 0.5994, 2.2459, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.6', 'IM', 2.94, 27, 0.2579, 2.4101, 3.4704, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.6', 'LV', 3.85, 27, 0.4472, 2.9297, 4.7683, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.a', 'IM', 4.41, 27, 0.1476, 4.1019, 4.7087, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.a', 'LV', 4.85, 27, 0.2229, 4.3908, 5.3073, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.b', 'IM', 1.58, 27, 0.1868, 1.1917, 1.9595, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.b', 'LV', 1.04, 27, 0.3424, 0.3312, 1.7389, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.c', 'IM', 2.35, 27, 0.2759, 1.7877, 2.9218, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.c', 'LV', 2.30, 27, 0.4745, 1.3231, 3.2739, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.d', 'IM', 1.67, 27, 0.2082, 1.2437, 2.0997, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.d', 'LV', 1.13, 27, 0.3377, 0.4319, 1.8201, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.e', 'IM', 1.89, 27, 0.2085, 1.4614, 2.3185, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.e', 'LV', 2.11, 27, 0.4384, 1.2081, 3.0102, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.8.a', 'IM', 2.47, 27, 0.2151, 2.0266, 2.9111, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.8.a', 'LV', 2.19, 27, 0.3113, 1.5495, 2.8295, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.8.b', 'IM', 2.23, 27, 0.2313, 1.7508, 2.7015, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.8.b', 'LV', 2.09, 27, 0.3283, 1.4111, 2.7607, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.9.a', 'IM', 2.40, 27, 0.2528, 1.8814, 2.9206, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.9.a', 'LV', 1.91, 27, 0.3894, 1.1132, 2.7140, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.9.b', 'IM', 4.35, 27, 0.1772, 3.9894, 4.7181, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.9.b', 'LV', 5.21, 27, 0.3111, 4.5674, 5.8465, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.10', 'IM', 1.95, 27, 0.2412, 1.4562, 2.4479, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.10', 'LV', 1.59, 27, 0.3572, 0.8543, 2.3228, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.a', 'IM', 4.04, 37, 0.1244, 3.7871, 4.2915, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.a', 'LV', 4.61, 37, 0.1614, 4.2803, 4.9348, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.b', 'IM', 3.01, 37, 0.1628, 2.6824, 3.3428, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.b', 'LV', 4.10, 37, 0.3702, 3.3490, 4.8507, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.c', 'IM', 3.10, 37, 0.2874, 2.5135, 3.6791, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.c', 'LV', 3.55, 37, 0.5155, 2.5045, 4.5953, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.d', 'IM', 4.85, 37, 0.1056, 4.6322, 5.0000, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.d', 'LV', 6.05, 37, 0.2353, 5.5756, 6.5300, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.e', 'IM', 3.85, 37, 0.2813, 3.2823, 4.4234, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.e', 'LV', 4.85, 36, 0.3988, 4.0437, 5.6628, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.f', 'IM', 2.71, 37, 0.2531, 2.1964, 3.2229, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.f', 'LV', 3.55, 37, 0.3359, 2.8723, 4.2346, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.2.a', 'IM', 2.46, 37, 0.2350, 1.9883, 2.9414, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.2.a', 'LV', 2.92, 37, 0.5182, 1.8732, 3.9750, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.2.b', 'IM', 1.12, 36, 0.0612, 1.0000, 1.2474, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.2.b', 'LV', 0.28, 37, 0.1442, 0.0000, 0.5760, 'Y', 'Y', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.a', 'IM', 3.51, 37, 0.3106, 2.8814, 4.1412, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.a', 'LV', 4.05, 37, 0.4714, 3.0937, 5.0059, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.b', 'IM', 2.77, 37, 0.4271, 1.9059, 3.6384, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.b', 'LV', 2.47, 37, 0.5531, 1.3462, 3.5898, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.c', 'IM', 3.15, 37, 0.3999, 2.3421, 3.9639, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.c', 'LV', 3.55, 37, 0.5817, 2.3704, 4.7299, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.d', 'IM', 1.19, 36, 0.0950, 1.0000, 1.3845, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.d', 'LV', 0.42, 37, 0.2069, 0.0020, 0.8414, 'N', 'Y', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.e', 'IM', 1.33, 37, 0.1311, 1.0631, 1.5951, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.e', 'LV', 0.54, 37, 0.2119, 0.1085, 0.9678, 'N', 'Y', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.a', 'IM', 3.51, 37, 0.1318, 3.2471, 3.7818, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.a', 'LV', 4.40, 37, 0.1100, 4.1720, 4.6182, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.b', 'IM', 1.18, 37, 0.0809, 1.0158, 1.3441, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.b', 'LV', 0.37, 37, 0.1629, 0.0399, 0.7005, 'N', 'Y', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.c', 'IM', 1.21, 37, 0.0841, 1.0394, 1.3806, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.c', 'LV', 0.43, 37, 0.1709, 0.0824, 0.7757, 'N', 'Y', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.d', 'IM', 1.10, 37, 0.0540, 1.0000, 1.2061, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.d', 'LV', 0.20, 37, 0.1049, 0.0000, 0.4141, 'Y', 'Y', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.e', 'IM', 2.45, 37, 0.2177, 2.0093, 2.8925, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.e', 'LV', 2.86, 37, 0.4711, 1.9032, 3.8140, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.f', 'IM', 2.03, 35, 0.1803, 1.6607, 2.3936, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.f', 'LV', 2.44, 37, 0.5425, 1.3379, 3.5385, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.g', 'IM', 2.20, 37, 0.1927, 1.8101, 2.5917, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.g', 'LV', 2.55, 37, 0.3631, 1.8097, 3.2827, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.5.a', 'IM', 1.26, 37, 0.0956, 1.0675, 1.4551, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.5.a', 'LV', 0.44, 37, 0.1566, 0.1175, 0.7528, 'N', 'Y', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.5.b', 'IM', 1.63, 37, 0.1488, 1.3243, 1.9277, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.5.b', 'LV', 1.10, 37, 0.2303, 0.6379, 1.5721, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.6', 'IM', 3.03, 37, 0.2275, 2.5650, 3.4879, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.6', 'LV', 4.15, 37, 0.5470, 3.0423, 5.2612, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.a', 'IM', 4.48, 37, 0.1007, 4.2762, 4.6848, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.a', 'LV', 5.04, 37, 0.2356, 4.5647, 5.5204, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.b', 'IM', 1.64, 37, 0.1990, 1.2370, 2.0444, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.b', 'LV', 1.36, 37, 0.4455, 0.4591, 2.2663, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.c', 'IM', 1.70, 37, 0.2397, 1.2156, 2.1880, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.c', 'LV', 1.32, 37, 0.5074, 0.2870, 2.3449, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.d', 'IM', 1.68, 37, 0.3043, 1.0666, 2.3011, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.d', 'LV', 1.09, 37, 0.2827, 0.5169, 1.6635, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.e', 'IM', 1.64, 37, 0.2355, 1.1576, 2.1129, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.e', 'LV', 1.12, 36, 0.4085, 0.2935, 1.9521, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.8.a', 'IM', 2.50, 37, 0.4195, 1.6450, 3.3464, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.8.a', 'LV', 2.26, 37, 0.5807, 1.0856, 3.4412, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.8.b', 'IM', 2.86, 37, 0.3262, 2.1993, 3.5223, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.8.b', 'LV', 2.93, 37, 0.4499, 2.0151, 3.8399, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.9.a', 'IM', 2.86, 37, 0.3746, 2.0962, 3.6156, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.9.a', 'LV', 2.56, 37, 0.4549, 1.6338, 3.4790, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.9.b', 'IM', 3.80, 37, 0.2088, 3.3799, 4.2268, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.9.b', 'LV', 4.21, 37, 0.3890, 3.4172, 4.9950, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.10', 'IM', 1.68, 37, 0.1190, 1.4402, 1.9228, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.10', 'LV', 1.53, 37, 0.2713, 0.9809, 2.0815, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.a', 'LV', 5.26, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.b', 'IM', 2.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.b', 'LV', 4.30, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.c', 'IM', 2.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.c', 'LV', 3.70, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.d', 'IM', 4.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.d', 'LV', 6.13, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.e', 'IM', 4.48, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.e', 'LV', 5.39, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.f', 'IM', 3.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.f', 'LV', 3.91, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.2.a', 'IM', 2.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.2.a', 'LV', 3.09, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.2.b', 'IM', 1.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.2.b', 'LV', 0.09, 23, NULL, NULL, NULL, NULL, 'Y', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.a', 'IM', 3.17, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.a', 'LV', 3.96, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.b', 'IM', 2.13, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.b', 'LV', 2.00, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.c', 'IM', 1.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.c', 'LV', 1.43, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.d', 'IM', 1.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.d', 'LV', 1.13, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.e', 'IM', 1.87, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.e', 'LV', 1.39, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.a', 'IM', 3.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.a', 'LV', 4.22, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.b', 'IM', 1.52, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.b', 'LV', 0.91, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.c', 'IM', 1.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.c', 'LV', 0.96, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.d', 'IM', 1.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.d', 'LV', 0.61, 23, NULL, NULL, NULL, NULL, 'Y', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.e', 'IM', 2.68, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.e', 'LV', 2.95, 22, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.f', 'IM', 1.86, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.f', 'LV', 1.68, 22, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.g', 'IM', 2.26, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.g', 'LV', 2.39, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.5.a', 'IM', 1.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.5.a', 'LV', 0.09, 23, NULL, NULL, NULL, NULL, 'Y', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.5.b', 'IM', 1.57, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.5.b', 'LV', 1.04, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.6', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.6', 'LV', 4.65, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.a', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.a', 'LV', 4.68, 22, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.b', 'IM', 1.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.b', 'LV', 1.35, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.c', 'IM', 1.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.c', 'LV', 0.61, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.d', 'IM', 1.22, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.d', 'LV', 0.52, 23, NULL, NULL, NULL, NULL, 'Y', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.e', 'IM', 1.57, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.e', 'LV', 1.22, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.8.a', 'IM', 1.87, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.8.a', 'LV', 1.48, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.8.b', 'IM', 2.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.8.b', 'LV', 2.13, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.9.a', 'IM', 2.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.9.a', 'LV', 1.96, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.9.b', 'IM', 3.17, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.9.b', 'LV', 3.04, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.10', 'IM', 2.22, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.10', 'LV', 2.13, 23, NULL, NULL, NULL, NULL, 'N', '2016-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.1.a', 'IM', 4.24, 43, 0.1939, 3.8454, 4.6280, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.1.a', 'LV', 4.56, 43, 0.1430, 4.2710, 4.8482, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.1.b', 'IM', 3.90, 43, 0.2669, 3.3645, 4.4417, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.1.b', 'LV', 5.18, 43, 0.2632, 4.6496, 5.7119, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.1.c', 'IM', 2.92, 42, 0.1795, 2.5583, 3.2835, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.1.c', 'LV', 3.14, 42, 0.3313, 2.4737, 3.8118, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.1.d', 'IM', 1.95, 41, 0.2235, 1.4972, 2.4007, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.1.d', 'LV', 2.00, 41, 0.4442, 1.1045, 2.8999, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.1.e', 'IM', 4.44, 44, 0.1752, 4.0827, 4.7894, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.1.e', 'LV', 5.17, 44, 0.1599, 4.8486, 5.4935, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.1.f', 'IM', 3.35, 44, 0.1370, 3.0697, 3.6223, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.1.f', 'LV', 4.12, 44, 0.2010, 3.7188, 4.5295, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.2.a', 'IM', 2.89, 44, 0.4526, 1.9806, 3.8061, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.2.a', 'LV', 3.02, 44, 0.5310, 1.9444, 4.0859, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.2.b', 'IM', 1.27, 43, 0.1183, 1.0357, 1.5131, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.2.b', 'LV', 0.61, 43, 0.2154, 0.1725, 1.0420, 'N', 'Y', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.3.a', 'IM', 3.35, 45, 0.1972, 2.9528, 3.7476, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.3.a', 'LV', 4.15, 45, 0.2618, 3.6200, 4.6751, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.3.b', 'IM', 2.06, 43, 0.2747, 1.5094, 2.6182, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.3.b', 'LV', 1.62, 43, 0.3986, 0.8117, 2.4206, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.3.c', 'IM', 2.10, 43, 0.2068, 1.6781, 2.5126, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.3.c', 'LV', 2.01, 43, 0.3476, 1.3040, 2.7069, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.3.d', 'IM', 2.29, 43, 0.2015, 1.8785, 2.6918, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.3.d', 'LV', 2.17, 43, 0.3225, 1.5198, 2.8214, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.3.e', 'IM', 2.33, 43, 0.1878, 1.9533, 2.7114, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.3.e', 'LV', 2.25, 43, 0.3644, 1.5144, 2.9853, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.a', 'IM', 3.26, 45, 0.1322, 2.9895, 3.5225, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.a', 'LV', 3.54, 45, 0.1638, 3.2107, 3.8709, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.b', 'IM', 1.60, 45, 0.1620, 1.2741, 1.9271, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.b', 'LV', 1.14, 45, 0.3176, 0.5013, 1.7815, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.c', 'IM', 1.52, 44, 0.1676, 1.1802, 1.8562, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.c', 'LV', 1.33, 44, 0.4264, 0.4702, 2.1901, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.d', 'IM', 1.37, 44, 0.2062, 1.0000, 1.7902, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.d', 'LV', 0.74, 44, 0.4100, 0.0000, 1.5684, 'Y', 'Y', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.e', 'IM', 2.07, 44, 0.2862, 1.4880, 2.6423, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.e', 'LV', 1.99, 45, 0.4988, 0.9866, 2.9972, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.f', 'IM', 1.76, 44, 0.2402, 1.2790, 2.2479, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.f', 'LV', 1.45, 44, 0.4613, 0.5229, 2.3836, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.g', 'IM', 1.51, 44, 0.1636, 1.1753, 1.8354, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.4.g', 'LV', 1.10, 44, 0.3315, 0.4348, 1.7720, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.5.a', 'IM', 1.78, 44, 0.2887, 1.2002, 2.3646, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.5.a', 'LV', 1.08, 44, 0.4163, 0.2428, 1.9217, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.5.b', 'IM', 1.74, 44, 0.2290, 1.2771, 2.2009, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.5.b', 'LV', 1.39, 44, 0.4141, 0.5530, 2.2233, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.6', 'IM', 2.84, 44, 0.4087, 2.0128, 3.6614, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.6', 'LV', 3.05, 44, 0.6690, 1.7009, 4.3991, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.7.a', 'IM', 4.03, 45, 0.0633, 3.9002, 4.1553, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.7.a', 'LV', 3.86, 44, 0.2155, 3.4268, 4.2961, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.7.b', 'IM', 1.37, 44, 0.1082, 1.1514, 1.5880, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.7.b', 'LV', 0.75, 44, 0.2244, 0.2985, 1.2037, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.7.c', 'IM', 1.13, 44, 0.0611, 1.0053, 1.2517, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.7.c', 'LV', 0.21, 44, 0.1013, 0.0077, 0.4162, 'N', 'Y', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.7.d', 'IM', 1.42, 44, 0.1201, 1.1732, 1.6577, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.7.d', 'LV', 0.77, 44, 0.2191, 0.3314, 1.2149, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.7.e', 'IM', 1.49, 44, 0.1596, 1.1648, 1.8087, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.7.e', 'LV', 1.31, 44, 0.3769, 0.5506, 2.0709, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.8.a', 'IM', 3.29, 45, 0.1667, 2.9583, 3.6302, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.8.a', 'LV', 3.29, 45, 0.2210, 2.8438, 3.7346, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.8.b', 'IM', 2.88, 45, 0.4158, 2.0465, 3.7226, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.8.b', 'LV', 2.66, 45, 0.5692, 1.5121, 3.8066, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.9.a', 'IM', 2.63, 44, 0.1615, 2.3061, 2.9576, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.9.a', 'LV', 2.19, 44, 0.4234, 1.3344, 3.0420, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.9.b', 'IM', 2.40, 44, 0.3086, 1.7747, 3.0193, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.9.b', 'LV', 2.20, 44, 0.5071, 1.1725, 3.2178, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.10', 'IM', 1.94, 44, 0.2480, 1.4441, 2.4445, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.C.10', 'LV', 1.41, 44, 0.3502, 0.7064, 2.1191, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.1.a', 'IM', 4.21, 33, 0.2117, 3.7741, 4.6364, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.1.a', 'LV', 4.57, 33, 0.3127, 3.9287, 5.2025, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.1.b', 'IM', 3.31, 33, 0.2509, 2.7959, 3.8181, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.1.b', 'LV', 3.99, 33, 0.4868, 3.0030, 4.9860, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.1.c', 'IM', 2.90, 33, 0.1951, 2.5016, 3.2964, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.1.c', 'LV', 2.65, 33, 0.3867, 1.8606, 3.4360, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.1.d', 'IM', 2.22, 33, 0.3227, 1.5595, 2.8742, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.1.d', 'LV', 2.02, 33, 0.5435, 0.9171, 3.1313, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.1.e', 'IM', 4.37, 33, 0.2186, 3.9237, 4.8142, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.1.e', 'LV', 5.05, 33, 0.3537, 4.3323, 5.7733, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.1.f', 'IM', 3.41, 33, 0.1939, 3.0111, 3.8009, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.1.f', 'LV', 3.98, 33, 0.3770, 3.2117, 4.7477, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.2.a', 'IM', 2.64, 33, 0.4259, 1.7743, 3.5094, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.2.a', 'LV', 2.86, 33, 0.6295, 1.5729, 4.1376, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.2.b', 'IM', 1.52, 33, 0.1934, 1.1230, 1.9108, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.2.b', 'LV', 1.26, 33, 0.4539, 0.3378, 2.1870, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.3.a', 'IM', 3.25, 33, 0.3278, 2.5845, 3.9198, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.3.a', 'LV', 4.06, 33, 0.4445, 3.1564, 4.9672, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.3.b', 'IM', 3.05, 33, 0.2255, 2.5857, 3.5044, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.3.b', 'LV', 3.49, 33, 0.3565, 2.7596, 4.2118, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.3.c', 'IM', 2.39, 33, 0.4082, 1.5627, 3.2259, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.3.c', 'LV', 2.50, 33, 0.6898, 1.0970, 3.9070, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.3.d', 'IM', 3.32, 33, 0.4351, 2.4345, 4.2071, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.3.d', 'LV', 3.45, 33, 0.5831, 2.2614, 4.6369, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.3.e', 'IM', 3.36, 33, 0.4328, 2.4813, 4.2443, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.3.e', 'LV', 3.97, 33, 0.5963, 2.7557, 5.1851, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.a', 'IM', 3.11, 33, 0.2345, 2.6346, 3.5900, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.a', 'LV', 3.30, 33, 0.3331, 2.6227, 3.9795, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.b', 'IM', 2.47, 33, 0.3443, 1.7677, 3.1702, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.b', 'LV', 2.48, 33, 0.4911, 1.4811, 3.4816, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.c', 'IM', 2.77, 33, 0.1986, 2.3643, 3.1733, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.c', 'LV', 3.35, 33, 0.3462, 2.6425, 4.0530, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.d', 'IM', 2.11, 32, 0.3306, 1.4335, 2.7820, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.d', 'LV', 2.01, 32, 0.5304, 0.9253, 3.0887, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.e', 'IM', 3.29, 32, 0.3348, 2.6082, 3.9738, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.e', 'LV', 4.13, 32, 0.6838, 2.7390, 5.5283, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.f', 'IM', 2.46, 33, 0.2596, 1.9348, 2.9923, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.f', 'LV', 2.32, 33, 0.4556, 1.3962, 3.2520, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.g', 'IM', 2.28, 32, 0.3362, 1.5971, 2.9685, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.4.g', 'LV', 2.38, 32, 0.5011, 1.3617, 3.4059, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.5.a', 'IM', 1.98, 32, 0.4676, 1.0247, 2.9320, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.5.a', 'LV', 1.29, 32, 0.4889, 0.2899, 2.2840, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.5.b', 'IM', 2.67, 32, 0.4506, 1.7511, 3.5890, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.5.b', 'LV', 2.96, 32, 0.7039, 1.5241, 4.3953, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.6', 'IM', 3.27, 32, 0.2156, 2.8330, 3.7124, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.6', 'LV', 4.41, 32, 0.4485, 3.4953, 5.3246, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.7.a', 'IM', 3.77, 31, 0.2675, 3.2285, 4.3213, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.7.a', 'LV', 3.70, 32, 0.3093, 3.0717, 4.3332, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.7.b', 'IM', 1.74, 33, 0.2725, 1.1801, 2.2904, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.7.b', 'LV', 1.18, 33, 0.3907, 0.3828, 1.9743, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.7.c', 'IM', 1.26, 33, 0.1373, 1.0000, 1.5363, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.7.c', 'LV', 0.48, 33, 0.2909, 0.0000, 1.0739, 'Y', 'Y', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.7.d', 'IM', 1.44, 33, 0.2066, 1.0157, 1.8574, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.7.d', 'LV', 0.90, 33, 0.4121, 0.0591, 1.7379, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.7.e', 'IM', 1.68, 33, 0.2447, 1.1863, 2.1833, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.7.e', 'LV', 1.74, 33, 0.5824, 0.5510, 2.9238, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.8.a', 'IM', 3.47, 33, 0.2695, 2.9212, 4.0191, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.8.a', 'LV', 4.11, 33, 0.2929, 3.5098, 4.7031, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.8.b', 'IM', 2.75, 32, 0.2114, 2.3197, 3.1819, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.8.b', 'LV', 3.06, 33, 0.3531, 2.3457, 3.7841, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.9.a', 'IM', 2.75, 32, 0.3765, 1.9814, 3.5170, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.9.a', 'LV', 2.47, 33, 0.4848, 1.4820, 3.4572, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.9.b', 'IM', 2.63, 32, 0.2937, 2.0287, 3.2265, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.9.b', 'LV', 2.28, 32, 0.3529, 1.5600, 2.9994, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.10', 'IM', 2.99, 33, 0.3770, 2.2224, 3.7582, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3013.00', '2.C.10', 'LV', 2.35, 33, 0.3626, 1.6142, 3.0916, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.a', 'IM', 3.70, 26, 0.2466, 3.1876, 4.2032, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.a', 'LV', 4.31, 26, 0.2460, 3.8080, 4.8212, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.b', 'IM', 2.48, 26, 0.1582, 2.1556, 2.8074, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.b', 'LV', 3.69, 26, 0.2636, 3.1502, 4.2359, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.c', 'IM', 2.15, 26, 0.1842, 1.7661, 2.5246, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.c', 'LV', 2.16, 26, 0.3660, 1.4016, 2.9093, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.d', 'IM', 1.92, 26, 0.3073, 1.2830, 2.5486, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.d', 'LV', 1.77, 26, 0.6777, 0.3766, 3.1681, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.e', 'IM', 4.05, 25, 0.1640, 3.7116, 4.3884, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.e', 'LV', 4.72, 26, 0.3090, 4.0885, 5.3612, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.f', 'IM', 3.42, 26, 0.1634, 3.0823, 3.7553, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.f', 'LV', 4.09, 26, 0.2370, 3.6023, 4.5783, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.2.a', 'IM', 1.78, 26, 0.3053, 1.1487, 2.4064, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.2.a', 'LV', 1.42, 26, 0.5877, 0.2105, 2.6311, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.2.b', 'IM', 1.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.2.b', 'LV', 0.00, 26, 0.0000, NULL, NULL, 'N', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.a', 'IM', 4.77, 26, 0.1402, 4.4773, 5.0000, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.a', 'LV', 6.13, 26, 0.1845, 5.7529, 6.5130, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.b', 'IM', 3.50, 26, 0.4949, 2.4758, 4.5144, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.b', 'LV', 3.99, 26, 0.9192, 2.0984, 5.8847, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.c', 'IM', 2.61, 26, 0.4264, 1.7357, 3.4921, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.c', 'LV', 3.00, 26, 0.8047, 1.3458, 4.6604, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.d', 'IM', 1.24, 25, 0.1311, 1.0000, 1.5142, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.d', 'LV', 0.65, 26, 0.3495, 0.0000, 1.3656, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.e', 'IM', 1.38, 24, 0.2307, 1.0000, 1.8564, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.e', 'LV', 0.62, 25, 0.3570, 0.0000, 1.3613, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.a', 'IM', 3.16, 24, 0.2856, 2.5648, 3.7464, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.a', 'LV', 4.67, 24, 0.3565, 3.9328, 5.4077, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.b', 'IM', 1.61, 25, 0.3491, 1.0000, 2.3280, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.b', 'LV', 1.20, 25, 0.6226, 0.0000, 2.4832, 'Y', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.c', 'IM', 1.23, 25, 0.1180, 1.0000, 1.4770, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.c', 'LV', 0.58, 25, 0.2932, 0.0000, 1.1841, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.d', 'IM', 1.01, 26, 0.0077, 1.0000, 1.0233, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.d', 'LV', 0.01, 26, 0.0154, 0.0000, 0.0466, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.e', 'IM', 2.22, 26, 0.3975, 1.4034, 3.0406, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.e', 'LV', 2.27, 26, 0.5701, 1.0952, 3.4435, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.f', 'IM', 1.90, 26, 0.2890, 1.3027, 2.4929, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.f', 'LV', 1.69, 26, 0.5662, 0.5227, 2.8552, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.g', 'IM', 2.24, 26, 0.5051, 1.1984, 3.2788, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.g', 'LV', 2.49, 26, 0.9322, 0.5676, 4.4073, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.5.a', 'IM', 1.02, 26, 0.0172, 1.0000, 1.0517, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.5.a', 'LV', 0.02, 26, 0.0172, 0.0000, 0.0517, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.5.b', 'IM', 1.44, 26, 0.3017, 1.0000, 2.0592, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.5.b', 'LV', 0.78, 26, 0.4595, 0.0000, 1.7233, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.6', 'IM', 3.05, 24, 0.2991, 2.4360, 3.6734, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.6', 'LV', 3.95, 26, 0.3373, 3.2556, 4.6451, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.a', 'IM', 3.48, 26, 0.4469, 2.5611, 4.4021, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.a', 'LV', 3.63, 26, 0.5890, 2.4185, 4.8445, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.b', 'IM', 1.28, 25, 0.1206, 1.0300, 1.5279, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.b', 'LV', 0.74, 26, 0.3519, 0.0144, 1.4639, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.c', 'IM', 1.42, 26, 0.3047, 1.0000, 2.0495, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.c', 'LV', 0.74, 26, 0.5170, 0.0000, 1.8030, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.d', 'IM', 1.03, 26, 0.0288, 1.0000, 1.0873, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.d', 'LV', 0.06, 26, 0.0576, 0.0000, 0.1746, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.e', 'IM', 1.23, 26, 0.1484, 1.0000, 1.5357, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.e', 'LV', 0.69, 26, 0.4491, 0.0000, 1.6114, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.8.a', 'IM', 1.94, 26, 0.2926, 1.3396, 2.5447, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.8.a', 'LV', 1.52, 26, 0.4991, 0.4908, 2.5466, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.8.b', 'IM', 2.12, 26, 0.3671, 1.3657, 2.8778, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.8.b', 'LV', 2.03, 26, 0.6209, 0.7506, 3.3083, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.9.a', 'IM', 2.63, 26, 0.4088, 1.7926, 3.4763, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.9.a', 'LV', 2.81, 26, 0.6071, 1.5560, 4.0569, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.9.b', 'IM', 2.16, 26, 0.2614, 1.6229, 2.6998, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.9.b', 'LV', 2.50, 26, 0.5646, 1.3406, 3.6663, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.10', 'IM', 1.18, 26, 0.0891, 1.0000, 1.3613, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.10', 'LV', 0.41, 26, 0.2229, 0.0000, 0.8723, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.1.a', 'IM', 4.33, 17, 0.1470, 4.0134, 4.6368, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.1.a', 'LV', 5.44, 17, 0.4851, 4.4149, 6.4718, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.1.b', 'IM', 3.70, 17, 0.3988, 2.8539, 4.5448, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.1.b', 'LV', 4.97, 17, 0.7797, 3.3198, 6.6257, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.1.c', 'IM', 4.07, 17, 0.2015, 3.6469, 4.5012, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.1.c', 'LV', 5.83, 17, 0.5341, 4.6928, 6.9574, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.1.d', 'IM', 3.35, 16, 0.4420, 2.4120, 4.2962, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.1.d', 'LV', 4.36, 16, 0.2646, 3.7967, 4.9246, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.1.e', 'IM', 4.66, 16, 0.1214, 4.4007, 4.9184, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.1.e', 'LV', 5.36, 17, 0.2071, 4.9183, 5.7964, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.1.f', 'IM', 3.50, 17, 0.2413, 2.9874, 4.0105, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.1.f', 'LV', 4.30, 17, 0.1720, 3.9323, 4.6617, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.2.a', 'IM', 1.89, 17, 0.4714, 1.0000, 2.8908, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.2.a', 'LV', 1.85, 17, 0.9801, 0.0000, 3.9237, 'Y', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.2.b', 'IM', 1.08, 17, 0.0836, 1.0000, 1.2542, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.2.b', 'LV', 0.15, 17, 0.1671, 0.0000, 0.5084, 'Y', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.3.a', 'IM', 3.25, 17, 0.2219, 2.7756, 3.7164, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.3.a', 'LV', 3.97, 17, 0.3191, 3.2964, 4.6493, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.3.b', 'IM', 1.29, 17, 0.2730, 1.0000, 1.8715, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.3.b', 'LV', 0.49, 17, 0.4550, 0.0000, 1.4525, 'Y', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.3.c', 'IM', 1.33, 17, 0.2102, 1.0000, 1.7760, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.3.c', 'LV', 0.69, 17, 0.4268, 0.0000, 1.5913, 'Y', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.3.d', 'IM', 1.29, 17, 0.1983, 1.0000, 1.7133, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.3.d', 'LV', 0.57, 17, 0.3916, 0.0000, 1.4016, 'Y', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.3.e', 'IM', 1.36, 17, 0.2794, 1.0000, 1.9493, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.3.e', 'LV', 0.63, 17, 0.4707, 0.0000, 1.6231, 'Y', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.a', 'IM', 3.73, 17, 0.1808, 3.3424, 4.1091, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.a', 'LV', 4.48, 17, 0.2448, 3.9587, 4.9968, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.b', 'IM', 1.00, 17, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.b', 'LV', 0.00, 17, 0.0000, NULL, NULL, 'N', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.c', 'IM', 1.00, 17, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.c', 'LV', 0.00, 17, 0.0000, NULL, NULL, 'N', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.d', 'IM', 1.00, 17, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.d', 'LV', 0.00, 17, 0.0000, NULL, NULL, 'N', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.e', 'IM', 2.25, 16, 0.2052, 1.8109, 2.6856, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.e', 'LV', 2.66, 17, 0.2905, 2.0491, 3.2807, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.f', 'IM', 1.64, 17, 0.3228, 1.0000, 2.3213, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.f', 'LV', 1.27, 17, 0.6399, 0.0000, 2.6272, 'Y', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.g', 'IM', 1.56, 17, 0.1181, 1.3077, 1.8083, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.4.g', 'LV', 1.66, 17, 0.2642, 1.1028, 2.2231, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.5.a', 'IM', 1.01, 17, 0.0096, 1.0000, 1.0290, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.5.a', 'LV', 0.02, 17, 0.0192, 0.0000, 0.0580, 'Y', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.5.b', 'IM', 1.34, 17, 0.2174, 1.0000, 1.8029, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.5.b', 'LV', 0.65, 17, 0.4135, 0.0000, 1.5217, 'Y', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.6', 'IM', 3.29, 16, 0.2136, 2.8373, 3.7480, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.6', 'LV', 4.72, 17, 0.4428, 3.7799, 5.6575, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.7.a', 'IM', 3.32, 16, 0.1914, 2.9097, 3.7258, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.7.a', 'LV', 3.75, 16, 0.2313, 3.2533, 4.2393, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.7.b', 'IM', 1.69, 17, 0.2055, 1.2545, 2.1260, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.7.b', 'LV', 1.15, 17, 0.2217, 0.6774, 1.6173, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.7.c', 'IM', 1.02, 17, 0.0200, 1.0000, 1.0659, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.7.c', 'LV', 0.03, 17, 0.0269, 0.0000, 0.0892, 'Y', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.7.d', 'IM', 1.20, 17, 0.1826, 1.0000, 1.5911, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.7.d', 'LV', 0.42, 17, 0.3663, 0.0000, 1.1929, 'Y', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.7.e', 'IM', 1.59, 17, 0.1323, 1.3122, 1.8731, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.7.e', 'LV', 1.32, 17, 0.3096, 0.6686, 1.9814, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.8.a', 'IM', 2.19, 17, 0.5723, 1.0000, 3.3990, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.8.a', 'LV', 1.99, 17, 0.9504, 0.0000, 4.0063, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.8.b', 'IM', 3.60, 16, 0.2346, 3.1008, 4.1007, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.8.b', 'LV', 3.89, 17, 0.2746, 3.3044, 4.4685, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.9.a', 'IM', 1.73, 17, 0.1971, 1.3090, 2.1445, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.9.a', 'LV', 1.27, 17, 0.3900, 0.4450, 2.0987, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.9.b', 'IM', 2.74, 17, 0.2013, 2.3119, 3.1652, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.9.b', 'LV', 2.63, 17, 0.4051, 1.7710, 3.4886, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.10', 'IM', 1.35, 17, 0.2372, 1.0000, 1.8520, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.C.10', 'LV', 0.50, 17, 0.2888, 0.0000, 1.1090, 'Y', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.a', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.a', 'LV', 5.83, 24, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.b', 'IM', 2.48, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.b', 'LV', 3.48, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.c', 'IM', 4.60, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.c', 'LV', 6.00, 24, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.d', 'IM', 1.96, 24, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.d', 'LV', 2.44, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.e', 'IM', 2.84, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.e', 'LV', 3.42, 24, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.f', 'IM', 3.12, 24, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.f', 'LV', 4.12, 24, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.2.a', 'IM', 1.76, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.2.a', 'LV', 1.58, 24, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.2.b', 'IM', 1.08, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.2.b', 'LV', 0.16, 25, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.a', 'IM', 2.80, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.a', 'LV', 3.76, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.b', 'IM', 1.44, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.b', 'LV', 0.96, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.c', 'IM', 1.24, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.c', 'LV', 0.60, 25, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.d', 'IM', 1.04, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.d', 'LV', 0.04, 25, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.e', 'IM', 1.08, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.e', 'LV', 0.12, 25, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.a', 'IM', 3.92, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.a', 'LV', 5.13, 23, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.b', 'IM', 1.04, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.b', 'LV', 0.08, 25, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.c', 'IM', 1.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.c', 'LV', 0.00, 25, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.d', 'IM', 1.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.d', 'LV', 0.00, 25, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.e', 'IM', 1.92, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.e', 'LV', 2.17, 24, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.f', 'IM', 1.58, 24, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.f', 'LV', 1.28, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.g', 'IM', 1.44, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.g', 'LV', 1.00, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.5.a', 'IM', 1.12, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.5.a', 'LV', 0.21, 24, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.5.b', 'IM', 1.20, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.5.b', 'LV', 0.48, 25, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.6', 'IM', 2.56, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.6', 'LV', 3.70, 23, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.a', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.a', 'LV', 4.83, 24, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.b', 'IM', 1.40, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.b', 'LV', 0.88, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.c', 'IM', 1.04, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.c', 'LV', 0.04, 25, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.d', 'IM', 1.20, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.d', 'LV', 0.48, 25, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.e', 'IM', 1.40, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.e', 'LV', 1.00, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.8.a', 'IM', 1.80, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.8.a', 'LV', 1.32, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.8.b', 'IM', 2.84, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.8.b', 'LV', 3.04, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.9.a', 'IM', 1.44, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.9.a', 'LV', 0.60, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.9.b', 'IM', 2.00, 23, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.9.b', 'LV', 2.24, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.10', 'IM', 1.28, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.10', 'LV', 0.80, 25, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.1.a', 'IM', 3.19, 24, 0.2209, 2.7290, 3.6430, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.1.a', 'LV', 4.67, 24, 0.4867, 3.6668, 5.6803, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.1.b', 'IM', 1.74, 24, 0.1987, 1.3337, 2.1557, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.1.b', 'LV', 1.96, 24, 0.4144, 1.1067, 2.8212, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.1.c', 'IM', 4.67, 24, 0.1109, 4.4355, 4.8945, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.1.c', 'LV', 5.48, 24, 0.3763, 4.6966, 6.2535, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.1.d', 'IM', 3.01, 24, 0.1440, 2.7077, 3.3035, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.1.d', 'LV', 4.07, 24, 0.4016, 3.2385, 4.9000, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.1.e', 'IM', 3.67, 24, 0.3606, 2.9242, 4.4159, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.1.e', 'LV', 4.55, 24, 0.4856, 3.5420, 5.5512, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.1.f', 'IM', 2.38, 24, 0.2862, 1.7896, 2.9736, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.1.f', 'LV', 3.08, 24, 0.3761, 2.2977, 3.8537, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.2.a', 'IM', 1.63, 24, 0.2256, 1.1634, 2.0966, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.2.a', 'LV', 1.39, 24, 0.4741, 0.4104, 2.3717, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.2.b', 'IM', 1.03, 24, 0.0261, 1.0000, 1.0791, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.2.b', 'LV', 0.05, 24, 0.0521, 0.0000, 0.1581, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.3.a', 'IM', 3.10, 25, 0.2540, 2.5707, 3.6193, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.3.a', 'LV', 3.50, 25, 0.4075, 2.6566, 4.3384, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.3.b', 'IM', 1.52, 25, 0.1957, 1.1185, 1.9261, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.3.b', 'LV', 1.18, 25, 0.4363, 0.2837, 2.0847, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.3.c', 'IM', 1.18, 25, 0.1332, 1.0000, 1.4556, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.3.c', 'LV', 0.30, 25, 0.2588, 0.0000, 0.8353, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.3.d', 'IM', 1.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.3.d', 'LV', 0.00, 25, 0.0000, NULL, NULL, 'N', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.3.e', 'IM', 1.09, 25, 0.0511, 1.0000, 1.1908, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.3.e', 'LV', 0.24, 25, 0.1662, 0.0000, 0.5841, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.a', 'IM', 4.34, 25, 0.2068, 3.9144, 4.7682, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.a', 'LV', 5.46, 25, 0.3014, 4.8392, 6.0833, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.b', 'IM', 1.27, 25, 0.1415, 1.0000, 1.5578, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.b', 'LV', 0.57, 25, 0.2927, 0.0000, 1.1745, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.c', 'IM', 1.10, 25, 0.0957, 1.0000, 1.2984, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.c', 'LV', 0.30, 25, 0.2872, 0.0000, 0.8953, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.d', 'IM', 1.18, 24, 0.1102, 1.0000, 1.4107, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.d', 'LV', 0.62, 24, 0.3660, 0.0000, 1.3800, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.e', 'IM', 2.31, 24, 0.2678, 1.7524, 2.8604, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.e', 'LV', 2.69, 24, 0.6350, 1.3734, 4.0008, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.f', 'IM', 1.89, 24, 0.2181, 1.4400, 2.3424, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.f', 'LV', 2.16, 24, 0.4319, 1.2705, 3.0573, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.g', 'IM', 1.95, 24, 0.2341, 1.4662, 2.4347, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.4.g', 'LV', 2.21, 24, 0.4175, 1.3473, 3.0748, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.5.a', 'IM', 1.35, 25, 0.1339, 1.0751, 1.6279, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.5.a', 'LV', 0.82, 25, 0.3019, 0.1967, 1.4428, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.5.b', 'IM', 1.27, 25, 0.1933, 1.0000, 1.6709, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.5.b', 'LV', 0.61, 25, 0.4042, 0.0000, 1.4486, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.6', 'IM', 2.56, 25, 0.3604, 1.8141, 3.3016, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.6', 'LV', 3.10, 25, 0.6582, 1.7447, 4.4615, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.7.a', 'IM', 4.36, 25, 0.2032, 3.9452, 4.7841, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.7.a', 'LV', 4.90, 24, 0.3370, 4.2036, 5.5980, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.7.b', 'IM', 1.23, 25, 0.1141, 1.0000, 1.4645, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.7.b', 'LV', 0.56, 25, 0.3060, 0.0000, 1.1906, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.7.c', 'IM', 1.13, 25, 0.0854, 1.0000, 1.3028, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.7.c', 'LV', 0.39, 25, 0.2801, 0.0000, 0.9716, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.7.d', 'IM', 2.09, 25, 0.2167, 1.6474, 2.5420, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.7.d', 'LV', 2.42, 25, 0.5679, 1.2509, 3.5949, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.7.e', 'IM', 1.23, 24, 0.0762, 1.0706, 1.3858, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.7.e', 'LV', 0.87, 25, 0.2843, 0.2793, 1.4530, 'N', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.8.a', 'IM', 1.41, 25, 0.1518, 1.1004, 1.7268, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.8.a', 'LV', 0.64, 25, 0.2301, 0.1644, 1.1142, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.8.b', 'IM', 3.14, 25, 0.2684, 2.5836, 3.6915, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.8.b', 'LV', 3.64, 25, 0.4425, 2.7309, 4.5576, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.9.a', 'IM', 1.89, 25, 0.2063, 1.4624, 2.3141, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.9.a', 'LV', 1.67, 25, 0.3376, 0.9748, 2.3683, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.9.b', 'IM', 2.54, 25, 0.1370, 2.2582, 2.8236, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.9.b', 'LV', 2.92, 25, 0.3542, 2.1868, 3.6490, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.10', 'IM', 1.62, 25, 0.1877, 1.2366, 2.0114, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.C.10', 'LV', 1.22, 25, 0.3135, 0.5773, 1.8712, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.a', 'IM', 4.07, 34, 0.1434, 3.7760, 4.3595, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.a', 'LV', 4.72, 34, 0.2246, 4.2674, 5.1811, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.b', 'IM', 2.94, 33, 0.2339, 2.4653, 3.4181, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.b', 'LV', 3.79, 34, 0.3716, 3.0333, 4.5454, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.c', 'IM', 2.51, 30, 0.1986, 2.1014, 2.9137, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.c', 'LV', 2.30, 31, 0.2376, 1.8105, 2.7811, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.d', 'IM', 2.12, 34, 0.2399, 1.6302, 2.6062, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.d', 'LV', 2.27, 34, 0.4421, 1.3687, 3.1676, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.e', 'IM', 3.57, 34, 0.2683, 3.0208, 4.1126, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.e', 'LV', 3.85, 34, 0.3754, 3.0880, 4.6153, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.f', 'IM', 3.38, 34, 0.1993, 2.9706, 3.7817, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.f', 'LV', 3.95, 34, 0.1580, 3.6275, 4.2704, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.2.a', 'IM', 4.41, 34, 0.1424, 4.1245, 4.7041, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.2.a', 'LV', 5.36, 34, 0.2501, 4.8536, 5.8712, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.2.b', 'IM', 1.33, 34, 0.2169, 1.0000, 1.7677, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.2.b', 'LV', 0.44, 34, 0.2823, 0.0000, 1.0133, 'Y', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.a', 'IM', 2.96, 34, 0.2355, 2.4786, 3.4370, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.a', 'LV', 3.65, 34, 0.4324, 2.7654, 4.5248, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.b', 'IM', 3.21, 34, 0.2012, 2.8003, 3.6192, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.b', 'LV', 3.91, 34, 0.2599, 3.3800, 4.4374, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.c', 'IM', 2.61, 34, 0.2774, 2.0473, 3.1762, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.c', 'LV', 3.08, 34, 0.4381, 2.1913, 3.9741, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.d', 'IM', 1.92, 34, 0.2659, 1.3774, 2.4595, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.d', 'LV', 1.56, 34, 0.4526, 0.6396, 2.4813, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.e', 'IM', 3.27, 34, 0.2481, 2.7647, 3.7744, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.e', 'LV', 3.78, 34, 0.3696, 3.0238, 4.5277, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.a', 'IM', 3.40, 34, 0.2203, 2.9566, 3.8531, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.a', 'LV', 3.74, 34, 0.3129, 3.1036, 4.3770, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.b', 'IM', 1.96, 34, 0.1807, 1.5970, 2.3323, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.b', 'LV', 1.97, 34, 0.3762, 1.2078, 2.7387, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.c', 'IM', 2.07, 33, 0.2092, 1.6459, 2.4982, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.c', 'LV', 2.26, 34, 0.4347, 1.3766, 3.1453, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.d', 'IM', 1.47, 32, 0.1694, 1.1236, 1.8144, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.d', 'LV', 0.86, 32, 0.2895, 0.2740, 1.4549, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.e', 'IM', 2.75, 33, 0.2195, 2.2981, 3.1921, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.e', 'LV', 3.02, 33, 0.3397, 2.3252, 3.7093, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.f', 'IM', 1.91, 33, 0.1652, 1.5752, 2.2483, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.f', 'LV', 1.49, 33, 0.2909, 0.8943, 2.0793, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.g', 'IM', 1.82, 33, 0.2058, 1.4027, 2.2410, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.g', 'LV', 1.63, 33, 0.4002, 0.8188, 2.4492, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.5.a', 'IM', 1.39, 34, 0.1376, 1.1126, 1.6727, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.5.a', 'LV', 0.74, 34, 0.2752, 0.1781, 1.2980, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.5.b', 'IM', 1.72, 34, 0.1974, 1.3157, 2.1189, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.5.b', 'LV', 1.25, 34, 0.3013, 0.6329, 1.8590, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.6', 'IM', 3.41, 34, 0.1696, 3.0666, 3.7569, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.6', 'LV', 4.59, 33, 0.2584, 4.0684, 5.1210, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.a', 'IM', 3.28, 34, 0.2260, 2.8177, 3.7374, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.a', 'LV', 3.43, 34, 0.3050, 2.8132, 4.0542, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.b', 'IM', 1.70, 34, 0.1862, 1.3199, 2.0776, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.b', 'LV', 1.46, 33, 0.4749, 0.4960, 2.4306, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.c', 'IM', 1.00, 34, 0.0023, 1.0000, 1.0069, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.c', 'LV', 0.01, 34, 0.0069, 0.0000, 0.0208, 'Y', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.d', 'IM', 1.14, 34, 0.0724, 1.0000, 1.2908, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.d', 'LV', 0.31, 34, 0.1492, 0.0043, 0.6112, 'N', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.e', 'IM', 1.57, 34, 0.1664, 1.2293, 1.9064, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.e', 'LV', 1.28, 34, 0.3501, 0.5664, 1.9908, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.8.a', 'IM', 2.90, 34, 0.2452, 2.4036, 3.4013, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.8.a', 'LV', 3.02, 34, 0.3231, 2.3625, 3.6772, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.8.b', 'IM', 2.45, 33, 0.2016, 2.0414, 2.8626, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.8.b', 'LV', 2.36, 34, 0.2600, 1.8354, 2.8933, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.9.a', 'IM', 2.16, 34, 0.2234, 1.7054, 2.6146, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.9.a', 'LV', 1.38, 34, 0.2155, 0.9453, 1.8223, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.9.b', 'IM', 2.31, 34, 0.2236, 1.8578, 2.7679, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.9.b', 'LV', 2.13, 34, 0.3780, 1.3590, 2.8971, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.10', 'IM', 2.49, 34, 0.2660, 1.9486, 3.0310, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.10', 'LV', 2.32, 34, 0.3595, 1.5859, 3.0488, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.a', 'IM', 3.72, 16, 0.3161, 3.0504, 4.3979, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.a', 'LV', 4.19, 17, 0.2261, 3.7075, 4.6662, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.b', 'IM', 2.96, 16, 0.3501, 2.2173, 3.7098, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.b', 'LV', 3.72, 17, 0.5385, 2.5761, 4.8593, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.c', 'IM', 1.95, 15, 0.2919, 1.3219, 2.5741, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.c', 'LV', 1.61, 16, 0.4082, 0.7418, 2.4821, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.d', 'IM', 1.63, 16, 0.2512, 1.0925, 2.1635, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.d', 'LV', 1.56, 17, 0.6383, 0.2061, 2.9123, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.e', 'IM', 3.77, 16, 0.1429, 3.4666, 4.0757, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.e', 'LV', 4.59, 17, 0.3539, 3.8394, 5.3397, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.f', 'IM', 3.20, 15, 0.2702, 2.6207, 3.7797, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.f', 'LV', 3.75, 17, 0.2915, 3.1341, 4.3701, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.2.a', 'IM', 4.12, 16, 0.2238, 3.6429, 4.5970, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.2.a', 'LV', 4.60, 17, 0.3407, 3.8768, 5.3214, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.2.b', 'IM', 2.24, 16, 0.6185, 1.0000, 3.5568, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.2.b', 'LV', 1.63, 17, 0.7689, 0.0021, 3.2621, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.a', 'IM', 3.32, 16, 0.3975, 2.4770, 4.1715, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.a', 'LV', 3.97, 17, 0.5563, 2.7936, 5.1524, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.b', 'IM', 3.52, 15, 0.2885, 2.9040, 4.1415, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.b', 'LV', 4.05, 17, 0.4018, 3.1990, 4.9026, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.c', 'IM', 2.47, 16, 0.2334, 1.9743, 2.9694, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.c', 'LV', 2.86, 17, 0.4169, 1.9743, 3.7420, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.d', 'IM', 1.79, 16, 0.3986, 1.0000, 2.6432, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.d', 'LV', 1.44, 17, 0.6673, 0.0298, 2.8590, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.e', 'IM', 2.26, 16, 0.2251, 1.7840, 2.7434, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.e', 'LV', 2.75, 17, 0.4479, 1.8022, 3.7010, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.a', 'IM', 3.59, 16, 0.1682, 3.2359, 3.9531, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.a', 'LV', 4.20, 17, 0.3216, 3.5165, 4.8801, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.b', 'IM', 2.79, 16, 0.2627, 2.2280, 3.3478, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.b', 'LV', 2.99, 17, 0.2701, 2.4163, 3.5614, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.c', 'IM', 3.89, 16, 0.2757, 3.3048, 4.4801, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.c', 'LV', 4.80, 17, 0.4221, 3.9041, 5.6937, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.d', 'IM', 2.87, 16, 0.3926, 2.0291, 3.7026, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.d', 'LV', 2.74, 17, 0.5182, 1.6461, 3.8431, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.e', 'IM', 2.33, 16, 0.3399, 1.6008, 3.0499, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.e', 'LV', 2.36, 17, 0.4467, 1.4161, 3.3100, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.f', 'IM', 1.76, 16, 0.2183, 1.2949, 2.2253, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.f', 'LV', 1.50, 17, 0.5152, 0.4125, 2.5970, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.g', 'IM', 1.56, 15, 0.2750, 1.0000, 2.1485, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.g', 'LV', 1.51, 17, 0.4110, 0.6384, 2.3809, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.5.a', 'IM', 1.93, 16, 0.3318, 1.2215, 2.6359, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.5.a', 'LV', 1.38, 17, 0.4890, 0.3419, 2.4153, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.5.b', 'IM', 1.96, 16, 0.2181, 1.4931, 2.4230, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.5.b', 'LV', 2.28, 17, 0.5016, 1.2139, 3.3407, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.6', 'IM', 4.07, 16, 0.4406, 3.1342, 5.0000, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.6', 'LV', 5.03, 17, 0.4596, 4.0582, 6.0068, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.a', 'IM', 4.06, 16, 0.0651, 3.9246, 4.2023, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.a', 'LV', 4.50, 17, 0.1889, 4.0984, 4.8993, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.b', 'IM', 1.41, 16, 0.1386, 1.1149, 1.7058, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.b', 'LV', 1.09, 17, 0.3667, 0.3129, 1.8677, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.c', 'IM', 1.00, 16, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.c', 'LV', 0.04, 17, 0.0461, 0.0000, 0.1420, 'Y', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.d', 'IM', 1.13, 16, 0.0798, 1.0000, 1.3024, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.d', 'LV', 0.44, 17, 0.2343, 0.0000, 0.9372, 'Y', 'Y', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.e', 'IM', 1.50, 16, 0.1839, 1.1045, 1.8887, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.e', 'LV', 1.04, 17, 0.3504, 0.3017, 1.7874, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.8.a', 'IM', 3.47, 15, 0.2386, 2.9614, 3.9850, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.8.a', 'LV', 3.56, 16, 0.2526, 3.0217, 4.0984, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.8.b', 'IM', 2.87, 15, 0.3927, 2.0305, 3.7151, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.8.b', 'LV', 2.88, 16, 0.6012, 1.6019, 4.1647, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.9.a', 'IM', 1.57, 15, 0.2377, 1.0638, 2.0835, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.9.a', 'LV', 0.99, 16, 0.4196, 0.0989, 1.8877, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.9.b', 'IM', 2.22, 15, 0.2462, 1.6915, 2.7473, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.9.b', 'LV', 2.15, 16, 0.5370, 1.0059, 3.2949, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.10', 'IM', 2.10, 16, 0.2074, 1.6602, 2.5442, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.10', 'LV', 2.41, 17, 0.4680, 1.4199, 3.4041, 'N', 'N', '2022-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.a', 'IM', 4.21, 21, 0.1186, 3.9596, 4.4543, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.a', 'LV', 4.63, 21, 0.1497, 4.3168, 4.9415, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.b', 'IM', 3.45, 21, 0.1346, 3.1731, 3.7348, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.b', 'LV', 4.59, 21, 0.1752, 4.2202, 4.9510, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.c', 'IM', 3.07, 21, 0.1612, 2.7300, 3.4025, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.c', 'LV', 3.04, 21, 0.3407, 2.3275, 3.7489, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.d', 'IM', 1.79, 21, 0.1818, 1.4064, 2.1648, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.d', 'LV', 1.35, 21, 0.3153, 0.6924, 2.0077, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.e', 'IM', 2.93, 20, 0.3426, 2.2104, 3.6443, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.e', 'LV', 3.10, 20, 0.5721, 1.9067, 4.3014, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.f', 'IM', 3.69, 19, 0.1627, 3.3463, 4.0299, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.f', 'LV', 4.36, 20, 0.1726, 3.9937, 4.7164, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.2.a', 'IM', 4.00, 20, 0.2936, 3.3810, 4.6100, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.2.a', 'LV', 4.64, 20, 0.4139, 3.7709, 5.5037, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.2.b', 'IM', 1.14, 20, 0.1087, 1.0000, 1.3660, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.2.b', 'LV', 0.17, 20, 0.1347, 0.0000, 0.4484, 'Y', 'Y', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.a', 'IM', 3.36, 21, 0.1235, 3.1055, 3.6208, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.a', 'LV', 4.20, 21, 0.2339, 3.7168, 4.6926, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.b', 'IM', 3.81, 21, 0.1940, 3.4021, 4.2113, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.b', 'LV', 4.83, 21, 0.3644, 4.0673, 5.5874, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.c', 'IM', 3.50, 21, 0.2480, 2.9874, 4.0223, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.c', 'LV', 3.95, 21, 0.4444, 3.0250, 4.8790, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.d', 'IM', 3.25, 21, 0.1939, 2.8415, 3.6502, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.d', 'LV', 4.53, 21, 0.3923, 3.7091, 5.3458, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.e', 'IM', 4.40, 21, 0.1040, 4.1855, 4.6194, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.e', 'LV', 5.89, 21, 0.2333, 5.4011, 6.3746, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.a', 'IM', 3.89, 21, 0.1756, 3.5246, 4.2571, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.a', 'LV', 4.63, 21, 0.1976, 4.2221, 5.0466, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.b', 'IM', 3.54, 21, 0.0915, 3.3486, 3.7303, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.b', 'LV', 4.68, 21, 0.1642, 4.3380, 5.0230, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.c', 'IM', 3.46, 21, 0.1449, 3.1585, 3.7632, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.c', 'LV', 4.56, 21, 0.1303, 4.2915, 4.8350, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.d', 'IM', 2.21, 21, 0.1604, 1.8730, 2.5420, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.d', 'LV', 2.81, 21, 0.2749, 2.2369, 3.3837, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.e', 'IM', 2.94, 21, 0.1977, 2.5275, 3.3523, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.e', 'LV', 3.56, 21, 0.3778, 2.7769, 4.3530, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.f', 'IM', 2.12, 21, 0.1765, 1.7471, 2.4834, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.f', 'LV', 2.21, 21, 0.2919, 1.5963, 2.8140, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.g', 'IM', 2.01, 21, 0.1964, 1.6048, 2.4240, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.g', 'LV', 2.45, 21, 0.4915, 1.4249, 3.4754, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.5.a', 'IM', 1.86, 19, 0.1691, 1.5051, 2.2157, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.5.a', 'LV', 1.65, 20, 0.3061, 1.0071, 2.2886, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.5.b', 'IM', 2.27, 20, 0.2251, 1.7997, 2.7418, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.5.b', 'LV', 2.76, 20, 0.2937, 2.1419, 3.3712, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.6', 'IM', 3.55, 20, 0.1969, 3.1371, 3.9614, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.6', 'LV', 5.36, 20, 0.2361, 4.8614, 5.8498, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.a', 'IM', 3.75, 20, 0.2802, 3.1589, 4.3318, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.a', 'LV', 3.84, 20, 0.2471, 3.3187, 4.3531, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.b', 'IM', 1.77, 21, 0.1592, 1.4428, 2.1071, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.b', 'LV', 1.34, 21, 0.2106, 0.9028, 1.7813, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.c', 'IM', 1.15, 21, 0.0813, 1.0000, 1.3153, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.c', 'LV', 0.24, 21, 0.1343, 0.0000, 0.5193, 'Y', 'Y', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.d', 'IM', 1.64, 21, 0.1470, 1.3321, 1.9452, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.d', 'LV', 0.73, 21, 0.1460, 0.4216, 1.0307, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.e', 'IM', 2.02, 21, 0.1202, 1.7675, 2.2688, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.e', 'LV', 2.79, 21, 0.4468, 1.8571, 3.7212, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.8.a', 'IM', 3.90, 21, 0.1356, 3.6137, 4.1793, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.8.a', 'LV', 4.64, 21, 0.1282, 4.3732, 4.9081, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.8.b', 'IM', 3.36, 21, 0.2418, 2.8561, 3.8647, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.8.b', 'LV', 3.54, 21, 0.2901, 2.9397, 4.1502, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.9.a', 'IM', 2.80, 21, 0.2694, 2.2372, 3.3611, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.9.a', 'LV', 2.92, 21, 0.2644, 2.3699, 3.4728, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.9.b', 'IM', 2.41, 21, 0.1436, 2.1064, 2.7053, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.9.b', 'LV', 2.52, 21, 0.3071, 1.8828, 3.1641, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.10', 'IM', 2.63, 20, 0.1574, 2.3035, 2.9623, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.10', 'LV', 2.31, 20, 0.2699, 1.7480, 2.8779, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.a', 'IM', 4.08, 23, 0.1456, 3.7766, 4.3804, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.a', 'LV', 4.96, 22, 0.2547, 4.4316, 5.4908, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.b', 'IM', 3.26, 23, 0.1580, 2.9350, 3.5905, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.b', 'LV', 4.28, 23, 0.2223, 3.8159, 4.7381, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.c', 'IM', 3.01, 23, 0.2150, 2.5630, 3.4548, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.c', 'LV', 2.98, 23, 0.2624, 2.4401, 3.5284, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.d', 'IM', 2.44, 23, 0.2339, 1.9586, 2.9287, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.d', 'LV', 2.81, 23, 0.3729, 2.0354, 3.5821, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.e', 'IM', 3.04, 23, 0.1998, 2.6292, 3.4581, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.e', 'LV', 4.03, 23, 0.3046, 3.4023, 4.6658, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.f', 'IM', 3.32, 23, 0.2646, 2.7725, 3.8700, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.f', 'LV', 3.99, 23, 0.3750, 3.2084, 4.7639, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.2.a', 'IM', 4.73, 23, 0.1110, 4.4966, 4.9571, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.2.a', 'LV', 5.60, 23, 0.2074, 5.1688, 6.0290, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.2.b', 'IM', 2.71, 23, 0.2948, 2.0940, 3.3165, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.2.b', 'LV', 3.30, 23, 0.4983, 2.2663, 4.3331, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.a', 'IM', 3.33, 23, 0.2191, 2.8731, 3.7817, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.a', 'LV', 3.96, 23, 0.2964, 3.3483, 4.5775, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.b', 'IM', 3.68, 23, 0.1716, 3.3241, 4.0358, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.b', 'LV', 4.79, 23, 0.2697, 4.2267, 5.3454, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.c', 'IM', 3.19, 23, 0.2279, 2.7207, 3.6662, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.c', 'LV', 4.04, 23, 0.2784, 3.4612, 4.6158, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.d', 'IM', 2.82, 23, 0.2193, 2.3652, 3.2747, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.d', 'LV', 3.91, 23, 0.4651, 2.9475, 4.8764, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.e', 'IM', 4.04, 22, 0.1441, 3.7373, 4.3367, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.e', 'LV', 5.41, 22, 0.2102, 4.9726, 5.8470, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.a', 'IM', 3.49, 23, 0.1826, 3.1100, 3.8674, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.a', 'LV', 4.46, 23, 0.1612, 4.1268, 4.7952, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.b', 'IM', 3.28, 23, 0.2489, 2.7647, 3.7970, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.b', 'LV', 3.63, 23, 0.3829, 2.8407, 4.4287, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.c', 'IM', 3.68, 23, 0.1608, 3.3471, 4.0142, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.c', 'LV', 4.68, 23, 0.1227, 4.4295, 4.9383, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.d', 'IM', 2.98, 23, 0.3318, 2.2900, 3.6662, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.d', 'LV', 3.27, 23, 0.4613, 2.3090, 4.2224, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.e', 'IM', 2.65, 23, 0.2265, 2.1845, 3.1239, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.e', 'LV', 3.19, 23, 0.3475, 2.4679, 3.9092, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.f', 'IM', 1.80, 23, 0.1847, 1.4163, 2.1824, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.f', 'LV', 1.67, 23, 0.3352, 0.9788, 2.3690, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.g', 'IM', 2.09, 23, 0.1977, 1.6779, 2.4978, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.g', 'LV', 2.18, 23, 0.3657, 1.4186, 2.9354, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.5.a', 'IM', 1.35, 23, 0.1152, 1.1153, 1.5930, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.5.a', 'LV', 0.64, 23, 0.2142, 0.1985, 1.0871, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.5.b', 'IM', 1.40, 23, 0.1306, 1.1325, 1.6741, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.5.b', 'LV', 1.08, 23, 0.3495, 0.3533, 1.8031, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.6', 'IM', 3.23, 23, 0.1941, 2.8236, 3.6285, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.6', 'LV', 4.47, 23, 0.3295, 3.7816, 5.1485, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.a', 'IM', 3.23, 23, 0.1825, 2.8490, 3.6062, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.a', 'LV', 3.56, 23, 0.1965, 3.1509, 3.9658, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.b', 'IM', 1.26, 23, 0.1104, 1.0329, 1.4907, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.b', 'LV', 0.46, 23, 0.2107, 0.0226, 0.8966, 'N', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.c', 'IM', 1.03, 23, 0.0296, 1.0000, 1.0901, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.c', 'LV', 0.03, 23, 0.0296, 0.0000, 0.0901, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.d', 'IM', 1.25, 23, 0.0919, 1.0609, 1.4422, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.d', 'LV', 0.44, 23, 0.1602, 0.1061, 0.7707, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.e', 'IM', 1.33, 23, 0.1268, 1.0715, 1.5975, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.e', 'LV', 0.75, 23, 0.2711, 0.1881, 1.3126, 'N', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.8.a', 'IM', 3.13, 23, 0.2820, 2.5494, 3.7190, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.8.a', 'LV', 3.65, 23, 0.4486, 2.7198, 4.5803, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.8.b', 'IM', 2.50, 23, 0.2460, 1.9898, 3.0101, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.8.b', 'LV', 2.77, 23, 0.4090, 1.9174, 3.6137, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.9.a', 'IM', 1.81, 23, 0.2208, 1.3518, 2.2677, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.9.a', 'LV', 1.44, 23, 0.3891, 0.6330, 2.2466, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.9.b', 'IM', 1.98, 23, 0.1826, 1.5965, 2.3539, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.9.b', 'LV', 1.89, 23, 0.3104, 1.2459, 2.5333, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.10', 'IM', 2.66, 23, 0.2077, 2.2263, 3.0879, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.10', 'LV', 3.26, 23, 0.3167, 2.6023, 3.9158, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.a', 'IM', 4.05, 21, 0.2185, 3.5946, 4.5063, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.a', 'LV', 4.97, 20, 0.2351, 4.4805, 5.4647, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.b', 'IM', 3.61, 21, 0.1903, 3.2170, 4.0111, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.b', 'LV', 4.24, 20, 0.4238, 3.3566, 5.1306, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.c', 'IM', 3.14, 21, 0.2725, 2.5681, 3.7050, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.c', 'LV', 3.78, 19, 0.5190, 2.6930, 4.8739, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.d', 'IM', 1.49, 21, 0.2916, 1.0000, 2.0974, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.d', 'LV', 1.04, 21, 0.5616, 0.0000, 2.2156, 'Y', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.e', 'IM', 2.87, 20, 0.4369, 1.9533, 3.7822, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.e', 'LV', 3.35, 20, 0.6904, 1.9074, 4.7973, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.f', 'IM', 3.87, 20, 0.2370, 3.3706, 4.3625, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.f', 'LV', 4.45, 20, 0.1791, 4.0707, 4.8203, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.2.a', 'IM', 4.06, 20, 0.2661, 3.5052, 4.6190, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.2.a', 'LV', 4.98, 20, 0.3730, 4.1947, 5.7563, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.2.b', 'IM', 1.04, 19, 0.0334, 1.0000, 1.1093, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.2.b', 'LV', 0.07, 19, 0.0550, 0.0000, 0.1854, 'Y', 'Y', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.a', 'IM', 3.47, 21, 0.3744, 2.6913, 4.2532, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.a', 'LV', 4.07, 21, 0.2180, 3.6159, 4.5253, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.b', 'IM', 4.08, 21, 0.2071, 3.6449, 4.5089, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.b', 'LV', 4.80, 21, 0.1204, 4.5484, 5.0507, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.c', 'IM', 3.21, 21, 0.3602, 2.4555, 3.9583, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.c', 'LV', 3.39, 21, 0.5205, 2.3046, 4.4763, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.d', 'IM', 3.09, 21, 0.2151, 2.6406, 3.5381, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.d', 'LV', 4.13, 21, 0.4092, 3.2793, 4.9866, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.e', 'IM', 4.30, 21, 0.1556, 3.9764, 4.6254, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.e', 'LV', 5.52, 21, 0.3796, 4.7281, 6.3118, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.a', 'IM', 3.53, 21, 0.2753, 2.9558, 4.1043, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.a', 'LV', 4.39, 21, 0.2871, 3.7867, 4.9846, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.b', 'IM', 3.20, 21, 0.2969, 2.5847, 3.8235, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.b', 'LV', 3.99, 21, 0.4828, 2.9799, 4.9939, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.c', 'IM', 3.35, 21, 0.2197, 2.8958, 3.8121, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.c', 'LV', 4.57, 21, 0.1720, 4.2138, 4.9313, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.d', 'IM', 1.69, 20, 0.2821, 1.1038, 2.2847, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.d', 'LV', 1.63, 20, 0.6233, 0.3205, 2.9299, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.e', 'IM', 2.85, 20, 0.1377, 2.5659, 3.1425, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.e', 'LV', 3.91, 20, 0.2880, 3.3035, 4.5090, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.f', 'IM', 1.72, 20, 0.2736, 1.1434, 2.2889, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.f', 'LV', 1.41, 20, 0.4804, 0.4022, 2.4130, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.g', 'IM', 1.63, 20, 0.2508, 1.1030, 2.1528, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.g', 'LV', 1.37, 20, 0.5263, 0.2685, 2.4718, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.5.a', 'IM', 1.63, 21, 0.3036, 1.0000, 2.2644, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.5.a', 'LV', 0.98, 21, 0.4574, 0.0262, 1.9343, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.5.b', 'IM', 2.28, 21, 0.2072, 1.8473, 2.7117, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.5.b', 'LV', 2.85, 21, 0.3721, 2.0699, 3.6225, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.6', 'IM', 3.58, 21, 0.2540, 3.0518, 4.1114, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.6', 'LV', 5.08, 21, 0.3595, 4.3323, 5.8320, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.a', 'IM', 3.34, 21, 0.3113, 2.6919, 3.9908, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.a', 'LV', 3.93, 21, 0.4328, 3.0245, 4.8300, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.b', 'IM', 1.26, 20, 0.1438, 1.0000, 1.5620, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.b', 'LV', 0.61, 20, 0.4079, 0.0000, 1.4666, 'Y', 'Y', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.c', 'IM', 1.03, 20, 0.0251, 1.0000, 1.0829, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.c', 'LV', 0.05, 20, 0.0403, 0.0000, 0.1345, 'Y', 'Y', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.d', 'IM', 1.35, 20, 0.1668, 1.0000, 1.6966, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.d', 'LV', 0.97, 20, 0.4928, 0.0000, 2.0060, 'Y', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.e', 'IM', 1.74, 20, 0.3071, 1.0997, 2.3853, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.e', 'LV', 1.53, 20, 0.6157, 0.2437, 2.8213, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.8.a', 'IM', 3.70, 21, 0.3242, 3.0281, 4.3805, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.8.a', 'LV', 4.25, 21, 0.3627, 3.4981, 5.0112, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.8.b', 'IM', 2.65, 21, 0.3656, 1.8828, 3.4082, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.8.b', 'LV', 2.75, 21, 0.5143, 1.6756, 3.8210, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.9.a', 'IM', 2.38, 21, 0.2847, 1.7849, 2.9727, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.9.a', 'LV', 2.14, 21, 0.4644, 1.1699, 3.1074, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.9.b', 'IM', 2.63, 21, 0.3351, 1.9357, 3.3339, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.9.b', 'LV', 2.45, 21, 0.3867, 1.6454, 3.2588, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.10', 'IM', 2.81, 20, 0.2341, 2.3230, 3.3030, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.10', 'LV', 2.96, 20, 0.2762, 2.3859, 3.5421, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.a', 'IM', 3.92, 29, 0.1492, 3.6175, 4.2290, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.a', 'LV', 4.30, 29, 0.2990, 3.6888, 4.9138, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.b', 'IM', 3.20, 29, 0.1868, 2.8185, 3.5837, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.b', 'LV', 3.77, 29, 0.3228, 3.1066, 4.4292, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.c', 'IM', 2.76, 29, 0.1654, 2.4181, 3.0958, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.c', 'LV', 2.68, 29, 0.3050, 2.0505, 3.3000, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.d', 'IM', 1.63, 29, 0.1645, 1.2955, 1.9695, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.d', 'LV', 1.24, 29, 0.2986, 0.6258, 1.8491, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.e', 'IM', 2.73, 29, 0.2628, 2.1910, 3.2678, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.e', 'LV', 3.04, 29, 0.4869, 2.0469, 4.0419, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.f', 'IM', 3.58, 29, 0.1730, 3.2306, 3.9394, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.f', 'LV', 4.12, 29, 0.2439, 3.6224, 4.6214, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.2.a', 'IM', 3.11, 29, 0.2123, 2.6765, 3.5463, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.2.a', 'LV', 4.32, 28, 0.4341, 3.4274, 5.2089, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.2.b', 'IM', 1.03, 29, 0.0279, 1.0000, 1.0849, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.2.b', 'LV', 0.03, 29, 0.0279, 0.0000, 0.0849, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.a', 'IM', 3.60, 29, 0.1893, 3.2122, 3.9876, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.a', 'LV', 4.35, 28, 0.1817, 3.9804, 4.7260, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.b', 'IM', 3.62, 29, 0.1581, 3.2998, 3.9475, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.b', 'LV', 4.55, 28, 0.2205, 4.1007, 5.0055, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.c', 'IM', 3.20, 29, 0.2185, 2.7518, 3.6468, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.c', 'LV', 3.87, 29, 0.3120, 3.2266, 4.5046, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.d', 'IM', 2.98, 29, 0.1801, 2.6146, 3.3523, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.d', 'LV', 4.22, 29, 0.2510, 3.7028, 4.7310, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.e', 'IM', 4.07, 28, 0.1645, 3.7307, 4.4060, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.e', 'LV', 5.48, 28, 0.2072, 5.0552, 5.9055, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.a', 'IM', 3.41, 28, 0.1556, 3.0911, 3.7298, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.a', 'LV', 4.20, 28, 0.1878, 3.8168, 4.5876, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.b', 'IM', 3.13, 29, 0.1515, 2.8181, 3.4386, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.b', 'LV', 4.11, 29, 0.1983, 3.7078, 4.5202, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.c', 'IM', 2.50, 29, 0.1523, 2.1914, 2.8153, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.c', 'LV', 3.36, 29, 0.2635, 2.8197, 3.8993, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.d', 'IM', 1.72, 28, 0.1918, 1.3238, 2.1110, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.d', 'LV', 1.18, 28, 0.3342, 0.4937, 1.8652, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.e', 'IM', 3.02, 28, 0.2551, 2.4946, 3.5414, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.e', 'LV', 3.63, 28, 0.3093, 2.9931, 4.2623, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.f', 'IM', 2.16, 28, 0.2463, 1.6591, 2.6697, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.f', 'LV', 1.84, 28, 0.3669, 1.0827, 2.5882, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.g', 'IM', 2.62, 28, 0.2017, 2.2077, 3.0355, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.g', 'LV', 3.14, 28, 0.3564, 2.4097, 3.8724, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.5.a', 'IM', 1.80, 28, 0.1959, 1.4012, 2.2051, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.5.a', 'LV', 1.21, 28, 0.2805, 0.6361, 1.7872, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.5.b', 'IM', 1.86, 28, 0.1759, 1.4957, 2.2175, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.5.b', 'LV', 1.80, 29, 0.3392, 1.1092, 2.4991, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.6', 'IM', 3.52, 28, 0.2176, 3.0730, 3.9661, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.6', 'LV', 4.59, 29, 0.2193, 4.1418, 5.0401, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.a', 'IM', 3.82, 29, 0.1726, 3.4704, 4.1775, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.a', 'LV', 3.96, 29, 0.1682, 3.6198, 4.3088, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.b', 'IM', 1.15, 29, 0.0686, 1.0130, 1.2942, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.b', 'LV', 0.20, 29, 0.0917, 0.0156, 0.3911, 'N', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.c', 'IM', 1.03, 29, 0.0279, 1.0000, 1.0849, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.c', 'LV', 0.03, 29, 0.0279, 0.0000, 0.0849, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.d', 'IM', 1.57, 29, 0.1534, 1.2531, 1.8814, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.d', 'LV', 1.06, 29, 0.2723, 0.5056, 1.6209, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.e', 'IM', 1.49, 29, 0.1461, 1.1877, 1.7862, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.e', 'LV', 1.30, 29, 0.3721, 0.5408, 2.0651, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.8.a', 'IM', 4.06, 29, 0.1902, 3.6686, 4.4477, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.8.a', 'LV', 4.55, 29, 0.2617, 4.0160, 5.0880, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.8.b', 'IM', 3.27, 28, 0.2228, 2.8090, 3.7234, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.8.b', 'LV', 3.72, 29, 0.2970, 3.1131, 4.3298, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.9.a', 'IM', 2.71, 29, 0.2414, 2.2136, 3.2026, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.9.a', 'LV', 2.75, 29, 0.3239, 2.0836, 3.4105, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.9.b', 'IM', 2.39, 28, 0.1712, 2.0366, 2.7390, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.9.b', 'LV', 2.56, 29, 0.2070, 2.1365, 2.9846, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.10', 'IM', 1.79, 28, 0.2039, 1.3766, 2.2133, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.10', 'LV', 1.61, 28, 0.3699, 0.8516, 2.3696, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.a', 'IM', 4.26, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.a', 'LV', 4.89, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.b', 'IM', 3.39, 18, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.b', 'LV', 5.37, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.c', 'IM', 3.74, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.c', 'LV', 3.74, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.d', 'IM', 2.83, 18, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.d', 'LV', 3.61, 18, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.e', 'IM', 4.00, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.e', 'LV', 5.05, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.f', 'IM', 3.37, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.f', 'LV', 4.11, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.2.a', 'IM', 2.78, 18, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.2.a', 'LV', 2.95, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.2.b', 'IM', 1.58, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.2.b', 'LV', 1.05, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.a', 'IM', 3.50, 18, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.a', 'LV', 4.21, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.b', 'IM', 2.37, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.b', 'LV', 1.89, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.c', 'IM', 2.17, 18, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.c', 'LV', 1.95, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.d', 'IM', 2.53, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.d', 'LV', 2.32, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.e', 'IM', 1.89, 18, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.e', 'LV', 1.58, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.a', 'IM', 3.47, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.a', 'LV', 4.05, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.b', 'IM', 1.42, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.b', 'LV', 0.84, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.c', 'IM', 1.67, 18, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.c', 'LV', 1.37, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.d', 'IM', 1.37, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.d', 'LV', 0.68, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.e', 'IM', 2.00, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.e', 'LV', 1.79, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.f', 'IM', 1.78, 18, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.f', 'LV', 1.79, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.g', 'IM', 1.89, 18, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.g', 'LV', 2.05, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.5.a', 'IM', 1.53, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.5.a', 'LV', 0.95, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.5.b', 'IM', 1.37, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.5.b', 'LV', 0.89, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.6', 'IM', 3.00, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.6', 'LV', 3.79, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.a', 'IM', 3.94, 18, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.a', 'LV', 4.05, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.b', 'IM', 1.42, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.b', 'LV', 0.68, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.c', 'IM', 1.26, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.c', 'LV', 0.42, 19, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.d', 'IM', 1.47, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.d', 'LV', 0.89, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.e', 'IM', 1.63, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.e', 'LV', 1.53, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.8.a', 'IM', 2.68, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.8.a', 'LV', 2.79, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.8.b', 'IM', 3.84, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.8.b', 'LV', 3.95, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.9.a', 'IM', 2.58, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.9.a', 'LV', 1.44, 18, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.9.b', 'IM', 2.84, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.9.b', 'LV', 2.95, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.10', 'IM', 2.47, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.10', 'LV', 2.58, 19, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.1.a', 'IM', 4.14, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.1.a', 'LV', 4.91, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.1.b', 'IM', 3.11, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.1.b', 'LV', 4.22, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.1.c', 'IM', 3.24, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.1.c', 'LV', 3.60, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.1.d', 'IM', 2.79, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.1.d', 'LV', 3.46, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.1.e', 'IM', 3.98, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.1.e', 'LV', 5.22, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.1.f', 'IM', 3.55, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.1.f', 'LV', 4.46, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.2.a', 'IM', 3.19, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.2.a', 'LV', 4.19, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.2.b', 'IM', 2.03, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.2.b', 'LV', 1.98, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.3.a', 'IM', 3.19, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.3.a', 'LV', 3.93, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.3.b', 'IM', 2.46, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.3.b', 'LV', 2.97, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.3.c', 'IM', 2.03, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.3.c', 'LV', 2.29, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.3.d', 'IM', 2.04, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.3.d', 'LV', 2.11, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.3.e', 'IM', 2.33, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.3.e', 'LV', 2.57, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.a', 'IM', 3.59, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.a', 'LV', 4.35, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.b', 'IM', 1.59, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.b', 'LV', 1.19, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.c', 'IM', 1.84, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.c', 'LV', 1.65, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.d', 'IM', 1.49, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.d', 'LV', 0.96, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.e', 'IM', 2.70, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.e', 'LV', 3.41, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.f', 'IM', 2.12, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.f', 'LV', 2.15, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.g', 'IM', 2.93, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.4.g', 'LV', 3.17, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.5.a', 'IM', 1.45, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.5.a', 'LV', 0.93, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.5.b', 'IM', 2.02, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.5.b', 'LV', 2.21, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.6', 'IM', 3.10, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.6', 'LV', 4.16, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.7.a', 'IM', 3.80, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.7.a', 'LV', 4.00, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.7.b', 'IM', 1.87, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.7.b', 'LV', 1.74, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.7.c', 'IM', 1.19, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.7.c', 'LV', 0.43, NULL, NULL, NULL, NULL, 'Y', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.7.d', 'IM', 1.55, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.7.d', 'LV', 1.18, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.7.e', 'IM', 1.72, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.7.e', 'LV', 1.60, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.8.a', 'IM', 3.49, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.8.a', 'LV', 3.98, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.8.b', 'IM', 3.11, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.8.b', 'LV', 3.44, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.9.a', 'IM', 2.60, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.9.a', 'LV', 2.34, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.9.b', 'IM', 2.57, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.9.b', 'LV', 2.56, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.10', 'IM', 4.46, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.C.10', 'LV', 4.69, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.1.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.1.a', 'LV', 5.38, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.1.b', 'IM', 2.24, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.1.b', 'LV', 2.38, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.1.c', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.1.c', 'LV', 4.19, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.1.d', 'IM', 3.05, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.1.d', 'LV', 3.67, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.1.e', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.1.e', 'LV', 5.05, 20, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.1.f', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.1.f', 'LV', 4.48, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.2.a', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.2.a', 'LV', 5.00, 20, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.2.b', 'IM', 2.19, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.2.b', 'LV', 2.19, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.3.a', 'IM', 3.14, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.3.a', 'LV', 4.29, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.3.b', 'IM', 2.57, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.3.b', 'LV', 2.81, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.3.c', 'IM', 2.19, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.3.c', 'LV', 2.48, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.3.d', 'IM', 1.67, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.3.d', 'LV', 1.67, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.3.e', 'IM', 2.19, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.3.e', 'LV', 2.52, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.a', 'IM', 3.48, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.a', 'LV', 4.38, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.b', 'IM', 1.43, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.b', 'LV', 0.81, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.c', 'IM', 1.33, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.c', 'LV', 0.90, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.d', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.d', 'LV', 0.52, 21, NULL, NULL, NULL, NULL, 'Y', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.e', 'IM', 2.52, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.e', 'LV', 2.86, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.f', 'IM', 1.43, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.f', 'LV', 0.95, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.g', 'IM', 2.71, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.4.g', 'LV', 3.71, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.5.a', 'IM', 1.14, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.5.a', 'LV', 0.29, 21, NULL, NULL, NULL, NULL, 'Y', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.5.b', 'IM', 1.67, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.5.b', 'LV', 1.81, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.6', 'IM', 2.80, 20, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.6', 'LV', 3.95, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.7.a', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.7.a', 'LV', 4.81, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.7.b', 'IM', 2.29, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.7.b', 'LV', 2.57, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.7.c', 'IM', 1.10, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.7.c', 'LV', 0.24, 21, NULL, NULL, NULL, NULL, 'Y', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.7.d', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.7.d', 'LV', 0.45, 20, NULL, NULL, NULL, NULL, 'Y', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.7.e', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.7.e', 'LV', 0.67, 21, NULL, NULL, NULL, NULL, 'Y', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.8.a', 'IM', 2.81, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.8.a', 'LV', 3.29, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.8.b', 'IM', 2.90, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.8.b', 'LV', 3.19, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.9.a', 'IM', 2.33, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.9.a', 'LV', 2.43, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.9.b', 'IM', 2.43, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.9.b', 'LV', 2.57, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.10', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.C.10', 'LV', 5.14, 21, NULL, NULL, NULL, NULL, 'N', '2017-07-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.a', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.a', 'LV', 4.90, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.b', 'IM', 3.05, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.b', 'LV', 4.67, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.c', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.c', 'LV', 3.76, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.d', 'IM', 1.95, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.d', 'LV', 2.81, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.e', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.e', 'LV', 5.14, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.f', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.f', 'LV', 5.33, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.2.a', 'IM', 1.40, 20, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.2.a', 'LV', 0.90, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.2.b', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.2.b', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.a', 'IM', 2.81, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.a', 'LV', 3.62, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.b', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.b', 'LV', 0.33, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.c', 'IM', 1.43, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.c', 'LV', 0.90, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.d', 'IM', 1.05, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.d', 'LV', 0.14, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.e', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.e', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.a', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.a', 'LV', 4.33, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.b', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.b', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.c', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.c', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.d', 'IM', 1.10, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.d', 'LV', 0.14, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.e', 'IM', 1.95, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.e', 'LV', 2.33, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.f', 'IM', 2.00, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.f', 'LV', 2.19, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.g', 'IM', 1.10, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.g', 'LV', 0.38, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.5.a', 'IM', 1.35, 20, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.5.a', 'LV', 0.90, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.5.b', 'IM', 1.80, 20, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.5.b', 'LV', 1.86, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.6', 'IM', 2.76, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.6', 'LV', 4.19, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.a', 'LV', 4.52, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.b', 'IM', 1.43, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.b', 'LV', 0.71, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.c', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.c', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.d', 'IM', 1.19, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.d', 'LV', 0.33, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.e', 'IM', 1.57, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.e', 'LV', 1.52, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.8.a', 'IM', 1.80, 20, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.8.a', 'LV', 1.71, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.8.b', 'IM', 3.05, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.8.b', 'LV', 3.33, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.9.a', 'IM', 1.86, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.9.a', 'LV', 1.00, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.9.b', 'IM', 2.86, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.9.b', 'LV', 3.24, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.10', 'IM', 1.05, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.10', 'LV', 0.14, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.a', 'IM', 4.58, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.a', 'LV', 5.00, 23, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.b', 'IM', 2.96, 23, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.b', 'LV', 4.62, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.c', 'IM', 2.58, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.c', 'LV', 2.65, 23, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.d', 'IM', 2.38, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.d', 'LV', 2.67, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.e', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.e', 'LV', 5.26, 23, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.f', 'IM', 4.92, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.f', 'LV', 6.17, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.2.a', 'IM', 2.33, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.2.a', 'LV', 2.33, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.2.b', 'IM', 1.29, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.2.b', 'LV', 0.67, 24, NULL, NULL, NULL, NULL, 'Y', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.a', 'IM', 2.70, 23, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.a', 'LV', 3.13, 23, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.b', 'IM', 1.39, 23, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.b', 'LV', 0.83, 23, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.c', 'IM', 1.35, 23, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.c', 'LV', 0.78, 23, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.d', 'IM', 1.18, 22, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.d', 'LV', 0.32, 22, NULL, NULL, NULL, NULL, 'Y', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.e', 'IM', 1.17, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.e', 'LV', 0.38, 24, NULL, NULL, NULL, NULL, 'Y', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.a', 'IM', 2.96, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.a', 'LV', 3.71, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.b', 'IM', 1.08, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.b', 'LV', 0.17, 24, NULL, NULL, NULL, NULL, 'Y', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.c', 'IM', 1.21, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.c', 'LV', 0.42, 24, NULL, NULL, NULL, NULL, 'Y', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.d', 'IM', 1.23, 22, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.d', 'LV', 0.57, 23, NULL, NULL, NULL, NULL, 'Y', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.e', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.e', 'LV', 4.04, 23, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.f', 'IM', 2.78, 23, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.f', 'LV', 3.78, 23, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.g', 'IM', 1.48, 23, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.g', 'LV', 1.30, 23, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.5.a', 'IM', 1.54, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.5.a', 'LV', 0.88, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.5.b', 'IM', 2.65, 23, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.5.b', 'LV', 3.71, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.6', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.6', 'LV', 5.96, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.a', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.a', 'LV', 4.58, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.b', 'IM', 1.67, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.b', 'LV', 1.08, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.c', 'IM', 1.21, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.c', 'LV', 0.29, 24, NULL, NULL, NULL, NULL, 'Y', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.d', 'IM', 1.71, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.d', 'LV', 1.46, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.e', 'IM', 2.12, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.e', 'LV', 2.67, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.8.a', 'IM', 2.62, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.8.a', 'LV', 3.00, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.8.b', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.8.b', 'LV', 4.21, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.9.a', 'IM', 1.79, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.9.a', 'LV', 1.04, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.9.b', 'IM', 2.83, 23, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.9.b', 'LV', 3.04, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.10', 'IM', 1.46, 24, NULL, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.10', 'LV', 0.88, 24, NULL, NULL, NULL, NULL, 'N', '2018-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.a', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.a', 'LV', 4.54, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.b', 'IM', 2.96, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.b', 'LV', 3.82, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.c', 'IM', 2.14, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.c', 'LV', 2.07, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.d', 'IM', 2.32, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.d', 'LV', 2.96, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.e', 'IM', 3.86, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.e', 'LV', 4.57, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.f', 'IM', 3.96, 27, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.f', 'LV', 5.21, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.2.a', 'IM', 1.96, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.2.a', 'LV', 1.64, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.2.b', 'IM', 1.00, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.2.b', 'LV', 0.00, 28, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.a', 'IM', 3.21, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.a', 'LV', 3.75, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.b', 'IM', 1.43, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.b', 'LV', 0.79, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.c', 'IM', 2.39, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.c', 'LV', 2.29, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.d', 'IM', 1.07, 27, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.d', 'LV', 0.11, 27, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.e', 'IM', 1.11, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.e', 'LV', 0.21, 28, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.a', 'IM', 2.21, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.a', 'LV', 2.71, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.b', 'IM', 1.04, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.b', 'LV', 0.04, 28, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.c', 'IM', 1.00, 27, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.c', 'LV', 0.00, 27, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.d', 'IM', 1.00, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.d', 'LV', 0.00, 28, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.e', 'IM', 3.26, 27, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.e', 'LV', 3.61, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.f', 'IM', 2.22, 27, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.f', 'LV', 2.93, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.g', 'IM', 1.18, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.g', 'LV', 0.43, 28, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.5.a', 'IM', 1.11, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.5.a', 'LV', 0.18, 28, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.5.b', 'IM', 1.86, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.5.b', 'LV', 1.75, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.6', 'IM', 4.93, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.6', 'LV', 6.75, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.a', 'IM', 4.36, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.a', 'LV', 5.36, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.b', 'IM', 1.29, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.b', 'LV', 0.54, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.c', 'IM', 1.29, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.c', 'LV', 0.82, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.d', 'IM', 1.11, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.d', 'LV', 0.25, 28, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.e', 'IM', 1.39, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.e', 'LV', 1.18, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.8.a', 'IM', 1.50, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.8.a', 'LV', 0.79, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.8.b', 'IM', 1.86, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.8.b', 'LV', 1.46, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.9.a', 'IM', 1.82, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.9.a', 'LV', 0.93, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.9.b', 'IM', 3.30, 27, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.9.b', 'LV', 3.64, 28, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.10', 'IM', 1.11, 28, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.10', 'LV', 0.21, 28, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.1.a', 'IM', 4.13, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.1.a', 'LV', 4.57, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.1.b', 'IM', 2.71, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.1.b', 'LV', 3.59, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.1.c', 'IM', 3.29, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.1.c', 'LV', 3.65, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.1.d', 'IM', 3.29, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.1.d', 'LV', 3.76, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.1.e', 'IM', 3.22, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.1.e', 'LV', 3.96, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.1.f', 'IM', 3.39, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.1.f', 'LV', 3.73, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.2.a', 'IM', 3.90, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.2.a', 'LV', 4.68, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.2.b', 'IM', 3.37, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.2.b', 'LV', 3.78, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.3.a', 'IM', 2.56, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.3.a', 'LV', 3.37, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.3.b', 'IM', 2.90, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.3.b', 'LV', 3.44, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.3.c', 'IM', 2.67, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.3.c', 'LV', 3.33, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.3.d', 'IM', 2.79, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.3.d', 'LV', 3.39, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.3.e', 'IM', 3.25, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.3.e', 'LV', 4.00, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.a', 'IM', 3.63, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.a', 'LV', 4.35, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.b', 'IM', 2.19, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.b', 'LV', 2.96, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.c', 'IM', 3.10, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.c', 'LV', 3.99, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.d', 'IM', 3.82, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.d', 'LV', 4.49, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.e', 'IM', 2.48, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.e', 'LV', 3.04, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.f', 'IM', 1.83, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.f', 'LV', 1.48, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.g', 'IM', 2.37, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.4.g', 'LV', 2.88, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.5.a', 'IM', 1.63, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.5.a', 'LV', 1.30, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.5.b', 'IM', 1.58, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.5.b', 'LV', 1.23, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.6', 'IM', 3.22, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.6', 'LV', 4.20, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.7.a', 'IM', 3.39, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.7.a', 'LV', 3.58, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.7.b', 'IM', 1.70, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.7.b', 'LV', 1.20, NULL, NULL, NULL, NULL, 'Y', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.7.c', 'IM', 1.11, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.7.c', 'LV', 0.22, NULL, NULL, NULL, NULL, 'Y', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.7.d', 'IM', 1.46, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.7.d', 'LV', 1.10, NULL, NULL, NULL, NULL, 'Y', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.7.e', 'IM', 1.77, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.7.e', 'LV', 1.31, NULL, NULL, NULL, NULL, 'Y', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.8.a', 'IM', 2.86, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.8.a', 'LV', 3.05, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.8.b', 'IM', 2.87, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.8.b', 'LV', 3.37, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.9.a', 'IM', 1.87, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.9.a', 'LV', 1.23, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.9.b', 'IM', 2.16, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.9.b', 'LV', 2.54, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.10', 'IM', 2.97, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.C.10', 'LV', 3.31, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.a', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.a', 'LV', 4.90, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.b', 'IM', 2.75, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.b', 'LV', 3.75, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.c', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.c', 'LV', 3.45, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.d', 'IM', 2.80, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.d', 'LV', 3.60, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.e', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.e', 'LV', 4.70, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.f', 'IM', 3.20, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.f', 'LV', 4.25, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.2.a', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.2.a', 'LV', 4.00, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.2.b', 'IM', 1.10, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.2.b', 'LV', 0.30, 20, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.a', 'IM', 3.21, 19, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.a', 'LV', 3.95, 19, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.b', 'IM', 4.21, 19, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.b', 'LV', 4.89, 19, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.c', 'IM', 3.58, 19, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.c', 'LV', 4.53, 19, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.d', 'IM', 4.89, 19, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.d', 'LV', 6.00, 19, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.e', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.e', 'LV', 4.20, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.a', 'LV', 4.05, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.b', 'IM', 2.60, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.b', 'LV', 2.90, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.c', 'IM', 2.15, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.c', 'LV', 2.65, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.d', 'IM', 1.60, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.d', 'LV', 1.25, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.e', 'IM', 2.65, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.e', 'LV', 3.25, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.f', 'IM', 1.70, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.f', 'LV', 1.50, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.g', 'IM', 2.00, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.g', 'LV', 1.95, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.5.a', 'IM', 1.45, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.5.a', 'LV', 0.85, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.5.b', 'IM', 1.45, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.5.b', 'LV', 1.20, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.6', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.6', 'LV', 3.80, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.a', 'LV', 4.05, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.b', 'IM', 1.75, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.b', 'LV', 1.30, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.c', 'IM', 1.10, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.c', 'LV', 0.20, 20, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.d', 'IM', 1.40, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.d', 'LV', 0.75, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.e', 'IM', 1.30, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.e', 'LV', 0.75, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.8.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.8.a', 'LV', 4.25, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.8.b', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.8.b', 'LV', 3.60, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.9.a', 'IM', 2.35, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.9.a', 'LV', 1.90, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.9.b', 'IM', 2.40, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.9.b', 'LV', 2.70, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.10', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.10', 'LV', 3.25, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.a', 'IM', 4.09, 26, 0.1867, 3.7008, 4.4699, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.a', 'LV', 4.25, 26, 0.3121, 3.6094, 4.8950, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.b', 'IM', 3.48, 26, 0.2198, 3.0228, 3.9282, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.b', 'LV', 4.58, 26, 0.3705, 3.8204, 5.3465, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.c', 'IM', 3.14, 26, 0.2498, 2.6238, 3.6528, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.c', 'LV', 3.42, 26, 0.4892, 2.4150, 4.4301, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.d', 'IM', 3.50, 26, 0.2754, 2.9376, 4.0721, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.d', 'LV', 3.42, 26, 0.4385, 2.5132, 4.3194, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.e', 'IM', 4.48, 26, 0.2109, 4.0484, 4.9169, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.e', 'LV', 5.88, 26, 0.3352, 5.1870, 6.5677, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.f', 'IM', 3.53, 26, 0.2605, 2.9958, 4.0688, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.f', 'LV', 4.09, 26, 0.4103, 3.2443, 4.9345, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.2.a', 'IM', 2.70, 26, 0.2576, 2.1668, 3.2278, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.2.a', 'LV', 2.67, 25, 0.4352, 1.7692, 3.5654, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.2.b', 'IM', 2.86, 25, 0.2396, 2.3652, 3.3543, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.2.b', 'LV', 2.97, 25, 0.4229, 2.1009, 3.8467, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.a', 'IM', 3.01, 27, 0.2198, 2.5555, 3.4590, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.a', 'LV', 3.70, 27, 0.2961, 3.0962, 4.3133, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.b', 'IM', 2.35, 27, 0.2557, 1.8283, 2.8794, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.b', 'LV', 2.06, 27, 0.3710, 1.2956, 2.8210, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.c', 'IM', 2.19, 27, 0.2608, 1.6512, 2.7235, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.c', 'LV', 2.04, 26, 0.3861, 1.2462, 2.8367, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.d', 'IM', 1.90, 27, 0.3111, 1.2598, 2.5387, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.d', 'LV', 1.66, 27, 0.4373, 0.7616, 2.5594, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.e', 'IM', 1.81, 24, 0.3677, 1.0484, 2.5696, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.e', 'LV', 1.45, 26, 0.4994, 0.4228, 2.4800, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.a', 'IM', 3.25, 27, 0.2261, 2.7848, 3.7145, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.a', 'LV', 3.34, 27, 0.2798, 2.7610, 3.9113, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.b', 'IM', 1.72, 27, 0.2037, 1.3061, 2.1437, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.b', 'LV', 1.12, 27, 0.3193, 0.4673, 1.7800, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.c', 'IM', 1.71, 27, 0.1366, 1.4251, 1.9868, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.c', 'LV', 1.62, 26, 0.3197, 0.9597, 2.2767, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.d', 'IM', 1.99, 25, 0.1946, 1.5882, 2.3916, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.d', 'LV', 1.54, 26, 0.3727, 0.7772, 2.3123, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.e', 'IM', 3.55, 26, 0.2122, 3.1086, 3.9827, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.e', 'LV', 3.44, 26, 0.2068, 3.0164, 3.8682, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.f', 'IM', 2.76, 27, 0.2041, 2.3417, 3.1808, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.f', 'LV', 2.79, 27, 0.3038, 2.1616, 3.4107, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.g', 'IM', 2.57, 25, 0.1957, 2.1622, 2.9701, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.g', 'LV', 2.87, 26, 0.2435, 2.3645, 3.3676, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.5.a', 'IM', 2.49, 27, 0.2645, 1.9478, 3.0352, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.5.a', 'LV', 2.65, 27, 0.2345, 2.1717, 3.1359, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.5.b', 'IM', 2.35, 27, 0.2236, 1.8937, 2.8129, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.5.b', 'LV', 2.83, 27, 0.3084, 2.1929, 3.4609, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.6', 'IM', 4.28, 26, 0.1848, 3.8961, 4.6573, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.6', 'LV', 4.24, 26, 0.4085, 3.4030, 5.0858, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.a', 'IM', 3.89, 27, 0.2889, 3.2982, 4.4857, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.a', 'LV', 3.84, 27, 0.3191, 3.1847, 4.4966, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.b', 'IM', 2.06, 27, 0.2747, 1.4968, 2.6262, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.b', 'LV', 1.81, 27, 0.6111, 0.5548, 3.0669, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.c', 'IM', 2.18, 27, 0.1756, 1.8224, 2.5443, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.c', 'LV', 2.26, 27, 0.2970, 1.6516, 2.8726, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.d', 'IM', 1.97, 27, 0.1610, 1.6409, 2.3027, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.d', 'LV', 2.08, 27, 0.2983, 1.4662, 2.6924, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.e', 'IM', 2.20, 27, 0.1815, 1.8304, 2.5765, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.e', 'LV', 2.88, 27, 0.3110, 2.2418, 3.5203, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.8.a', 'IM', 3.55, 27, 0.3034, 2.9215, 4.1690, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.8.a', 'LV', 3.42, 27, 0.3465, 2.7104, 4.1349, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.8.b', 'IM', 2.33, 27, 0.1884, 1.9473, 2.7217, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.8.b', 'LV', 2.34, 27, 0.3146, 1.6966, 2.9900, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.9.a', 'IM', 1.84, 27, 0.2172, 1.3961, 2.2892, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.9.a', 'LV', 0.81, 27, 0.2440, 0.3079, 1.3108, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.9.b', 'IM', 2.77, 26, 0.2418, 2.2687, 3.2648, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.9.b', 'LV', 2.53, 26, 0.3467, 1.8149, 3.2429, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.10', 'IM', 2.38, 27, 0.2644, 1.8359, 2.9228, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.10', 'LV', 2.06, 27, 0.4322, 1.1727, 2.9495, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.a', 'IM', 4.52, 26, 0.1894, 4.1310, 4.9113, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.a', 'LV', 4.81, 26, 0.2093, 4.3788, 5.2410, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.b', 'IM', 2.80, 26, 0.2880, 2.2034, 3.3896, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.b', 'LV', 3.61, 26, 0.5755, 2.4286, 4.7992, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.c', 'IM', 2.74, 26, 0.3573, 2.0040, 3.4760, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.c', 'LV', 2.23, 26, 0.4992, 1.1976, 3.2537, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.d', 'IM', 2.46, 26, 0.3958, 1.6411, 3.2713, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.d', 'LV', 2.50, 26, 0.5733, 1.3179, 3.6792, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.e', 'IM', 4.19, 25, 0.2889, 3.5928, 4.7854, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.e', 'LV', 5.59, 26, 0.1859, 5.2117, 5.9774, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.f', 'IM', 4.22, 25, 0.1539, 3.9014, 4.5366, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.f', 'LV', 4.91, 26, 0.1196, 4.6679, 5.1607, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.2.a', 'IM', 1.72, 26, 0.2171, 1.2731, 2.1674, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.2.a', 'LV', 1.73, 26, 0.4881, 0.7282, 2.7388, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.2.b', 'IM', 1.18, 25, 0.1478, 1.0000, 1.4800, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.2.b', 'LV', 0.43, 26, 0.2823, 0.0000, 1.0106, 'Y', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.a', 'IM', 2.95, 26, 0.2853, 2.3624, 3.5374, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.a', 'LV', 3.42, 26, 0.4818, 2.4317, 4.4163, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.b', 'IM', 1.78, 26, 0.1970, 1.3719, 2.1834, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.b', 'LV', 1.86, 26, 0.4710, 0.8929, 2.8331, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.c', 'IM', 2.14, 26, 0.3004, 1.5235, 2.7607, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.c', 'LV', 2.27, 26, 0.5350, 1.1669, 3.3707, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.d', 'IM', 2.18, 26, 0.3054, 1.5558, 2.8137, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.d', 'LV', 1.87, 26, 0.4719, 0.8978, 2.8416, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.e', 'IM', 1.79, 26, 0.2324, 1.3153, 2.2726, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.e', 'LV', 1.26, 26, 0.3924, 0.4544, 2.0710, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.a', 'IM', 3.44, 26, 0.2276, 2.9701, 3.9074, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.a', 'LV', 3.95, 26, 0.2801, 3.3739, 4.5277, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.b', 'IM', 1.41, 25, 0.1923, 1.0168, 1.8106, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.b', 'LV', 0.83, 25, 0.3836, 0.0379, 1.6214, 'N', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.c', 'IM', 1.47, 26, 0.1849, 1.0856, 1.8475, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.c', 'LV', 0.92, 26, 0.3746, 0.1471, 1.6900, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.d', 'IM', 1.59, 25, 0.2296, 1.1180, 2.0655, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.d', 'LV', 1.10, 26, 0.3943, 0.2893, 1.9133, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.e', 'IM', 3.53, 26, 0.2656, 2.9845, 4.0787, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.e', 'LV', 4.71, 26, 0.3083, 4.0741, 5.3440, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.f', 'IM', 2.80, 26, 0.2234, 2.3377, 3.2580, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.f', 'LV', 3.57, 26, 0.2403, 3.0738, 4.0635, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.g', 'IM', 2.13, 26, 0.2407, 1.6334, 2.6249, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.g', 'LV', 2.71, 26, 0.5550, 1.5674, 3.8533, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.5.a', 'IM', 1.90, 25, 0.2126, 1.4604, 2.3377, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.5.a', 'LV', 1.65, 25, 0.3569, 0.9166, 2.3896, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.5.b', 'IM', 2.82, 25, 0.3636, 2.0710, 3.5717, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.5.b', 'LV', 3.68, 25, 0.6458, 2.3437, 5.0094, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.6', 'IM', 4.29, 25, 0.2659, 3.7378, 4.8354, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.6', 'LV', 5.85, 25, 0.3932, 5.0428, 6.6658, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.a', 'IM', 4.50, 25, 0.1973, 4.0908, 4.9052, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.a', 'LV', 5.02, 25, 0.3759, 4.2418, 5.7934, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.b', 'IM', 1.99, 26, 0.3634, 1.2459, 2.7427, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.b', 'LV', 1.40, 26, 0.4224, 0.5312, 2.2713, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.c', 'IM', 2.20, 26, 0.3628, 1.4492, 2.9437, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.c', 'LV', 1.96, 26, 0.5453, 0.8368, 3.0829, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.d', 'IM', 2.38, 26, 0.2185, 1.9330, 2.8332, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.d', 'LV', 3.24, 26, 0.4176, 2.3842, 4.1045, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.e', 'IM', 2.94, 26, 0.3831, 2.1503, 3.7284, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.e', 'LV', 3.67, 26, 0.5659, 2.5016, 4.8324, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.8.a', 'IM', 3.45, 25, 0.4252, 2.5752, 4.3305, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.8.a', 'LV', 3.10, 26, 0.5014, 2.0710, 4.1362, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.8.b', 'IM', 3.87, 25, 0.2040, 3.4501, 4.2921, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.8.b', 'LV', 3.41, 26, 0.2092, 2.9758, 3.8375, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.9.a', 'IM', 2.18, 26, 0.3192, 1.5208, 2.8356, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.9.a', 'LV', 1.66, 26, 0.4138, 0.8124, 2.5167, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.9.b', 'IM', 2.78, 26, 0.3170, 2.1311, 3.4368, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.9.b', 'LV', 2.58, 26, 0.3760, 1.8013, 3.3501, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.10', 'IM', 2.21, 26, 0.3233, 1.5401, 2.8718, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.10', 'LV', 1.95, 26, 0.4395, 1.0440, 2.8544, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.a', 'IM', 4.16, 40, 0.2355, 3.6850, 4.6375, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.a', 'LV', 4.31, 40, 0.4465, 3.4071, 5.2133, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.b', 'IM', 3.27, 39, 0.1943, 2.8761, 3.6629, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.b', 'LV', 4.41, 40, 0.3042, 3.7924, 5.0230, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.c', 'IM', 2.68, 40, 0.1700, 2.3402, 3.0278, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.c', 'LV', 2.79, 40, 0.2820, 2.2157, 3.3565, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.d', 'IM', 2.85, 38, 0.2223, 2.4005, 3.3014, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.d', 'LV', 3.26, 39, 0.3671, 2.5207, 4.0070, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.e', 'IM', 4.06, 38, 0.2178, 3.6152, 4.4980, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.e', 'LV', 5.16, 40, 0.2793, 4.5923, 5.7220, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.f', 'IM', 3.39, 40, 0.1949, 2.9931, 3.7815, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.f', 'LV', 4.35, 40, 0.2919, 3.7628, 4.9435, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.2.a', 'IM', 1.88, 40, 0.2962, 1.2771, 2.4755, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.2.a', 'LV', 1.60, 39, 0.4026, 0.7805, 2.4108, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.2.b', 'IM', 1.19, 40, 0.1493, 1.0000, 1.4910, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.2.b', 'LV', 0.28, 40, 0.2094, 0.0000, 0.7059, 'Y', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.a', 'IM', 3.22, 40, 0.2421, 2.7297, 3.7091, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.a', 'LV', 4.13, 40, 0.3241, 3.4778, 4.7891, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.b', 'IM', 1.87, 40, 0.2777, 1.3081, 2.4316, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.b', 'LV', 1.34, 40, 0.4055, 0.5249, 2.1651, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.c', 'IM', 1.86, 39, 0.2255, 1.4073, 2.3205, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.c', 'LV', 1.44, 39, 0.3762, 0.6809, 2.2039, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.d', 'IM', 1.21, 40, 0.0745, 1.0559, 1.3571, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.d', 'LV', 0.47, 39, 0.2005, 0.0677, 0.8793, 'N', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.e', 'IM', 1.18, 40, 0.1428, 1.0000, 1.4721, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.e', 'LV', 0.32, 40, 0.2396, 0.0000, 0.8087, 'Y', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.a', 'IM', 3.08, 39, 0.2070, 2.6625, 3.5007, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.a', 'LV', 3.97, 39, 0.3001, 3.3657, 4.5805, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.b', 'IM', 1.42, 40, 0.1632, 1.0888, 1.7489, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.b', 'LV', 0.82, 40, 0.3259, 0.1616, 1.4800, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.c', 'IM', 1.18, 40, 0.0820, 1.0183, 1.3501, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.c', 'LV', 0.50, 40, 0.2517, 0.0000, 1.0127, 'N', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.d', 'IM', 1.50, 40, 0.2123, 1.0739, 1.9327, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.d', 'LV', 0.80, 40, 0.3282, 0.1329, 1.4606, 'N', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.e', 'IM', 3.06, 40, 0.2339, 2.5913, 3.5375, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.e', 'LV', 3.70, 40, 0.3391, 3.0110, 4.3827, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.f', 'IM', 2.43, 40, 0.2416, 1.9444, 2.9216, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.f', 'LV', 2.77, 40, 0.4279, 1.8998, 3.6308, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.g', 'IM', 1.63, 40, 0.1423, 1.3447, 1.9205, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.g', 'LV', 1.76, 40, 0.3880, 0.9717, 2.5414, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.5.a', 'IM', 1.40, 37, 0.1295, 1.1379, 1.6633, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.5.a', 'LV', 0.77, 38, 0.2750, 0.2107, 1.3252, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.5.b', 'IM', 2.87, 36, 0.2881, 2.2832, 3.4531, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.5.b', 'LV', 3.46, 37, 0.3940, 2.6586, 4.2567, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.6', 'IM', 4.13, 38, 0.2078, 3.7101, 4.5524, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.6', 'LV', 5.53, 38, 0.3300, 4.8564, 6.1936, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.a', 'IM', 4.33, 38, 0.1515, 4.0263, 4.6404, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.a', 'LV', 5.22, 38, 0.2321, 4.7470, 5.6875, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.b', 'IM', 1.61, 40, 0.1519, 1.2985, 1.9129, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.b', 'LV', 1.07, 40, 0.2453, 0.5771, 1.5694, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.c', 'IM', 1.58, 40, 0.1630, 1.2511, 1.9105, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.c', 'LV', 0.96, 40, 0.2056, 0.5398, 1.3714, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.d', 'IM', 1.63, 40, 0.2009, 1.2215, 2.0342, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.d', 'LV', 1.29, 40, 0.3692, 0.5388, 2.0323, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.e', 'IM', 2.44, 40, 0.2633, 1.9074, 2.9726, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.e', 'LV', 3.08, 40, 0.5052, 2.0567, 4.1005, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.8.a', 'IM', 2.47, 39, 0.1525, 2.1628, 2.7801, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.8.a', 'LV', 2.48, 39, 0.2293, 2.0194, 2.9478, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.8.b', 'IM', 2.83, 39, 0.2406, 2.3426, 3.3169, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.8.b', 'LV', 2.89, 39, 0.2496, 2.3811, 3.3915, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.9.a', 'IM', 1.96, 37, 0.2130, 1.5304, 2.3945, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.9.a', 'LV', 1.59, 39, 0.3504, 0.8776, 2.2961, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.9.b', 'IM', 3.20, 38, 0.1777, 2.8403, 3.5605, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.9.b', 'LV', 3.26, 39, 0.3071, 2.6388, 3.8823, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.10', 'IM', 1.74, 40, 0.1912, 1.3518, 2.1252, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.10', 'LV', 1.62, 40, 0.3616, 0.8893, 2.3522, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.a', 'IM', 3.89, 23, 0.1370, 3.6052, 4.1734, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.a', 'LV', 4.46, 23, 0.1595, 4.1334, 4.7948, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.b', 'IM', 3.16, 23, 0.1971, 2.7538, 3.5714, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.b', 'LV', 4.22, 23, 0.1947, 3.8146, 4.6221, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.c', 'IM', 2.85, 23, 0.1874, 2.4647, 3.2420, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.c', 'LV', 2.92, 23, 0.1886, 2.5338, 3.3160, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.d', 'IM', 2.82, 22, 0.4488, 1.8834, 3.7500, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.d', 'LV', 3.08, 23, 0.6965, 1.6309, 4.5200, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.e', 'IM', 3.82, 22, 0.3618, 3.0662, 4.5709, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.e', 'LV', 5.21, 22, 0.3396, 4.5072, 5.9199, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.f', 'IM', 2.77, 23, 0.1649, 2.4315, 3.1153, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.f', 'LV', 3.78, 23, 0.2307, 3.3034, 4.2604, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.2.a', 'IM', 3.21, 22, 0.2881, 2.6063, 3.8047, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.2.a', 'LV', 4.13, 23, 0.3979, 3.3042, 4.9548, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.2.b', 'IM', 1.03, 22, 0.0295, 1.0000, 1.0963, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.2.b', 'LV', 0.08, 23, 0.0602, 0.0000, 0.2084, 'Y', 'Y', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.a', 'IM', 3.38, 23, 0.2374, 2.8882, 3.8728, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.a', 'LV', 4.48, 23, 0.3474, 3.7584, 5.1995, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.b', 'IM', 4.29, 23, 0.3935, 3.4780, 5.0000, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.b', 'LV', 5.35, 23, 0.6917, 3.9181, 6.7872, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.c', 'IM', 4.32, 23, 0.3392, 3.6184, 5.0000, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.c', 'LV', 5.45, 23, 0.5571, 4.2939, 6.6048, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.d', 'IM', 3.02, 23, 0.7519, 1.4580, 4.5769, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.d', 'LV', 3.59, 23, 1.2021, 1.0939, 6.0801, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.e', 'IM', 3.66, 23, 0.4094, 2.8100, 4.5081, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.e', 'LV', 3.93, 23, 0.6055, 2.6785, 5.1901, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.a', 'IM', 3.92, 23, 0.1370, 3.6368, 4.2051, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.a', 'LV', 4.91, 23, 0.2104, 4.4783, 5.3511, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.b', 'IM', 3.18, 23, 0.2614, 2.6379, 3.7219, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.b', 'LV', 3.89, 23, 0.4555, 2.9410, 4.8303, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.c', 'IM', 2.39, 23, 0.2364, 1.9036, 2.8841, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.c', 'LV', 2.92, 23, 0.2785, 2.3432, 3.4982, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.d', 'IM', 1.58, 23, 0.1386, 1.2955, 1.8702, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.d', 'LV', 1.46, 23, 0.3317, 0.7706, 2.1464, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.e', 'IM', 1.86, 23, 0.1752, 1.4961, 2.2228, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.e', 'LV', 1.93, 23, 0.3916, 1.1212, 2.7454, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.f', 'IM', 1.66, 23, 0.1477, 1.3527, 1.9655, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.f', 'LV', 1.45, 23, 0.3338, 0.7602, 2.1447, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.g', 'IM', 2.27, 23, 0.2986, 1.6496, 2.8880, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.g', 'LV', 3.08, 23, 0.7295, 1.5639, 4.5896, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.5.a', 'IM', 1.52, 22, 0.2059, 1.0939, 1.9502, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.5.a', 'LV', 1.06, 22, 0.4080, 0.2143, 1.9114, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.5.b', 'IM', 1.30, 23, 0.1675, 1.0000, 1.6518, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.5.b', 'LV', 0.56, 23, 0.3070, 0.0000, 1.1934, 'Y', 'Y', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.6', 'IM', 2.40, 23, 0.1191, 2.1550, 2.6491, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.6', 'LV', 3.54, 23, 0.2306, 3.0602, 4.0166, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.a', 'IM', 3.87, 23, 0.1445, 3.5747, 4.1741, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.a', 'LV', 4.33, 23, 0.1835, 3.9521, 4.7133, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.b', 'IM', 1.68, 23, 0.1231, 1.4256, 1.9360, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.b', 'LV', 1.17, 23, 0.2845, 0.5847, 1.7647, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.c', 'IM', 1.85, 23, 0.5647, 1.0000, 3.0215, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.c', 'LV', 1.82, 23, 1.2100, 0.0000, 4.3317, 'Y', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.d', 'IM', 1.57, 23, 0.1315, 1.2962, 1.8415, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.d', 'LV', 1.13, 23, 0.2328, 0.6485, 1.6139, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.e', 'IM', 1.61, 23, 0.1125, 1.3743, 1.8411, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.e', 'LV', 1.39, 23, 0.2618, 0.8435, 1.9295, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.8.a', 'IM', 3.06, 23, 0.2066, 2.6282, 3.4851, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.8.a', 'LV', 3.43, 23, 0.3068, 2.7919, 4.0644, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.8.b', 'IM', 2.94, 22, 0.1588, 2.6134, 3.2739, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.8.b', 'LV', 3.36, 23, 0.2297, 2.8873, 3.8399, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.9.a', 'IM', 2.39, 23, 0.2385, 1.8942, 2.8834, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.9.a', 'LV', 2.28, 23, 0.3451, 1.5651, 2.9966, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.9.b', 'IM', 2.36, 22, 0.1331, 2.0828, 2.6366, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.9.b', 'LV', 2.45, 23, 0.2021, 2.0336, 2.8718, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.10', 'IM', 2.53, 22, 0.1905, 2.1378, 2.9299, 'N', NULL, '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.10', 'LV', 2.59, 22, 0.2558, 2.0552, 3.1192, 'N', 'N', '2020-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.a', 'IM', 3.07, 32, 0.3712, 2.3130, 3.8273, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.a', 'LV', 3.61, 33, 0.5821, 2.4210, 4.7924, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.b', 'IM', 2.47, 33, 0.1315, 2.2029, 2.7385, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.b', 'LV', 3.82, 33, 0.2673, 3.2731, 4.3619, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.c', 'IM', 2.30, 33, 0.2956, 1.7016, 2.9058, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.c', 'LV', 2.09, 33, 0.3423, 1.3893, 2.7837, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.d', 'IM', 2.29, 33, 0.5536, 1.1616, 3.4170, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.d', 'LV', 1.93, 33, 0.7572, 0.3887, 3.4736, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.e', 'IM', 2.94, 33, 0.3387, 2.2482, 3.6281, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.e', 'LV', 3.11, 33, 0.5949, 1.9006, 4.3241, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.f', 'IM', 2.27, 33, 0.1735, 1.9190, 2.6257, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.f', 'LV', 2.46, 33, 0.4068, 1.6291, 3.2861, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.2.a', 'IM', 3.39, 32, 0.4293, 2.5136, 4.2646, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.2.a', 'LV', 3.90, 31, 0.7215, 2.4235, 5.3704, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.2.b', 'IM', 1.39, 32, 0.1551, 1.0688, 1.7014, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.2.b', 'LV', 0.90, 32, 0.3374, 0.2084, 1.5846, 'N', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.a', 'IM', 3.25, 33, 0.2129, 2.8157, 3.6829, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.a', 'LV', 4.42, 33, 0.0891, 4.2412, 4.6044, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.b', 'IM', 3.94, 32, 0.2764, 3.3724, 4.4997, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.b', 'LV', 4.72, 32, 0.2778, 4.1515, 5.2845, 'N', 'N', '2014-07-01', 'Incumbent');
/*! COMMIT */;
/*! START TRANSACTION */;
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.c', 'IM', 2.56, 33, 0.3068, 1.9368, 3.1867, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.c', 'LV', 2.51, 33, 0.4596, 1.5688, 3.4413, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.d', 'IM', 2.62, 33, 0.4623, 1.6740, 3.5576, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.d', 'LV', 3.05, 33, 0.7205, 1.5831, 4.5182, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.e', 'IM', 3.21, 33, 0.5170, 2.1592, 4.2655, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.e', 'LV', 3.86, 33, 0.7357, 2.3596, 5.3568, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.a', 'IM', 3.57, 32, 0.2025, 3.1569, 3.9828, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.a', 'LV', 4.91, 33, 0.1251, 4.6518, 5.1614, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.b', 'IM', 2.85, 32, 0.1854, 2.4705, 3.2269, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.b', 'LV', 3.71, 33, 0.2731, 3.1555, 4.2682, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.c', 'IM', 4.03, 32, 0.1864, 3.6497, 4.4100, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.c', 'LV', 4.89, 33, 0.1677, 4.5490, 5.2323, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.d', 'IM', 2.68, 33, 0.5948, 1.4700, 3.8930, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.d', 'LV', 2.70, 33, 0.8846, 0.9007, 4.5043, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.e', 'IM', 1.63, 33, 0.2077, 1.2079, 2.0541, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.e', 'LV', 1.29, 33, 0.4554, 0.3581, 2.2135, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.f', 'IM', 1.26, 33, 0.1143, 1.0262, 1.4918, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.f', 'LV', 0.48, 33, 0.2169, 0.0377, 0.9215, 'N', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.g', 'IM', 1.99, 32, 0.3992, 1.1786, 2.8069, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.g', 'LV', 2.06, 33, 0.6922, 0.6461, 3.4660, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.5.a', 'IM', 1.21, 33, 0.0989, 1.0118, 1.4148, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.5.a', 'LV', 0.51, 33, 0.2252, 0.0508, 0.9682, 'N', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.5.b', 'IM', 1.22, 33, 0.1004, 1.0170, 1.4261, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.5.b', 'LV', 0.55, 33, 0.2471, 0.0456, 1.0522, 'N', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.6', 'IM', 2.52, 33, 0.1438, 2.2277, 2.8136, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.6', 'LV', 3.21, 33, 0.2554, 2.6857, 3.7262, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.a', 'IM', 4.07, 33, 0.3382, 3.3769, 4.7547, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.a', 'LV', 3.98, 33, 0.2301, 3.5135, 4.4510, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.b', 'IM', 1.15, 32, 0.0743, 1.0000, 1.2991, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.b', 'LV', 0.31, 32, 0.1658, 0.0000, 0.6432, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.c', 'IM', 1.02, 32, 0.0195, 1.0000, 1.0588, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.c', 'LV', 0.04, 32, 0.0391, 0.0000, 0.1177, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.d', 'IM', 1.05, 32, 0.0295, 1.0000, 1.1080, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.d', 'LV', 0.09, 32, 0.0563, 0.0000, 0.2040, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.e', 'IM', 1.12, 32, 0.0648, 1.0000, 1.2487, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.e', 'LV', 0.22, 32, 0.1253, 0.0000, 0.4797, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.8.a', 'IM', 2.77, 32, 0.3384, 2.0757, 3.4563, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.8.a', 'LV', 2.86, 32, 0.4803, 1.8794, 3.8386, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.8.b', 'IM', 2.20, 33, 0.3571, 1.4731, 2.9278, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.8.b', 'LV', 2.13, 33, 0.5958, 0.9209, 3.3480, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.9.a', 'IM', 1.68, 33, 0.1409, 1.3966, 1.9705, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.9.a', 'LV', 1.29, 33, 0.2300, 0.8190, 1.7560, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.9.b', 'IM', 2.28, 33, 0.2518, 1.7644, 2.7902, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.9.b', 'LV', 2.25, 33, 0.2606, 1.7201, 2.7818, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.10', 'IM', 2.14, 33, 0.2194, 1.6900, 2.5839, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.10', 'LV', 2.31, 33, 0.2802, 1.7417, 2.8833, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.a', 'IM', 4.38, 30, 0.2114, 3.9515, 4.8164, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.a', 'LV', 3.96, 29, 0.3823, 3.1755, 4.7417, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.b', 'IM', 3.27, 30, 0.2941, 2.6665, 3.8694, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.b', 'LV', 3.52, 29, 0.6481, 2.1884, 4.8436, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.c', 'IM', 3.08, 30, 0.4177, 2.2217, 3.9304, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.c', 'LV', 3.07, 30, 0.7567, 1.5197, 4.6147, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.d', 'IM', 3.33, 30, 0.3320, 2.6521, 4.0100, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.d', 'LV', 3.63, 30, 0.5022, 2.6073, 4.6616, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.e', 'IM', 4.62, 30, 0.1750, 4.2654, 4.9811, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.e', 'LV', 4.79, 30, 0.1838, 4.4140, 5.1657, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.f', 'IM', 3.84, 30, 0.2920, 3.2431, 4.4377, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.f', 'LV', 3.52, 30, 0.4727, 2.5580, 4.4915, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.2.a', 'IM', 3.70, 29, 0.3579, 2.9665, 4.4328, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.2.a', 'LV', 3.86, 30, 0.3271, 3.1894, 4.5275, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.2.b', 'IM', 3.70, 30, 0.3075, 3.0718, 4.3295, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.2.b', 'LV', 3.82, 30, 0.4407, 2.9162, 4.7187, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.a', 'IM', 2.58, 30, 0.2552, 2.0627, 3.1068, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.a', 'LV', 3.10, 30, 0.3702, 2.3460, 3.8603, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.b', 'IM', 1.67, 29, 0.2957, 1.0691, 2.2803, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.b', 'LV', 1.27, 29, 0.4317, 0.3850, 2.1535, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.c', 'IM', 1.59, 30, 0.1700, 1.2473, 1.9426, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.c', 'LV', 1.36, 30, 0.4585, 0.4219, 2.2975, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.d', 'IM', 1.76, 30, 0.2960, 1.1551, 2.3660, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.d', 'LV', 1.53, 30, 0.5415, 0.4240, 2.6389, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.e', 'IM', 2.20, 30, 0.4314, 1.3171, 3.0817, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.e', 'LV', 2.07, 30, 0.6068, 0.8316, 3.3137, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.a', 'IM', 3.57, 30, 0.2237, 3.1086, 4.0234, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.a', 'LV', 3.39, 30, 0.2655, 2.8461, 3.9319, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.b', 'IM', 1.35, 30, 0.1721, 1.0000, 1.7028, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.b', 'LV', 0.87, 30, 0.4880, 0.0000, 1.8644, 'Y', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.c', 'IM', 2.15, 29, 0.3307, 1.4709, 2.8257, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.c', 'LV', 1.95, 30, 0.4876, 0.9527, 2.9471, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.d', 'IM', 1.58, 28, 0.1977, 1.1750, 1.9861, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.d', 'LV', 1.29, 27, 0.4678, 0.3236, 2.2466, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.e', 'IM', 2.93, 28, 0.5290, 1.8473, 4.0183, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.e', 'LV', 2.85, 28, 0.7324, 1.3461, 4.3516, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.f', 'IM', 1.94, 28, 0.3497, 1.2241, 2.6593, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.f', 'LV', 1.51, 28, 0.5514, 0.3781, 2.6409, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.g', 'IM', 1.93, 28, 0.2876, 1.3440, 2.5240, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.g', 'LV', 1.21, 28, 0.3524, 0.4880, 1.9341, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.5.a', 'IM', 1.57, 30, 0.1533, 1.2547, 1.8817, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.5.a', 'LV', 1.29, 30, 0.4241, 0.4251, 2.1598, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.5.b', 'IM', 2.37, 30, 0.5264, 1.2960, 3.4493, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.5.b', 'LV', 2.27, 30, 0.6636, 0.9170, 3.6313, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.6', 'IM', 3.70, 30, 0.3510, 2.9851, 4.4209, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.6', 'LV', 4.36, 30, 0.3859, 3.5702, 5.1488, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.a', 'IM', 3.97, 30, 0.3188, 3.3146, 4.6184, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.a', 'LV', 3.39, 30, 0.2696, 2.8417, 3.9443, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.b', 'IM', 2.31, 29, 0.2303, 1.8417, 2.7851, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.b', 'LV', 1.68, 29, 0.4196, 0.8177, 2.5368, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.c', 'IM', 1.34, 29, 0.2340, 1.0000, 1.8221, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.c', 'LV', 0.43, 29, 0.2617, 0.0000, 0.9709, 'Y', 'Y', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.d', 'IM', 1.64, 29, 0.2443, 1.1443, 2.1453, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.d', 'LV', 1.06, 29, 0.4678, 0.1011, 2.0176, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.e', 'IM', 1.73, 29, 0.2755, 1.1646, 2.2935, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.e', 'LV', 1.54, 29, 0.5005, 0.5142, 2.5648, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.8.a', 'IM', 3.36, 29, 0.3522, 2.6435, 4.0864, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.8.a', 'LV', 3.26, 30, 0.3985, 2.4400, 4.0702, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.8.b', 'IM', 2.56, 30, 0.2298, 2.0934, 3.0333, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.8.b', 'LV', 2.41, 30, 0.3108, 1.7793, 3.0506, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.9.a', 'IM', 2.26, 30, 0.2698, 1.7080, 2.8116, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.9.a', 'LV', 1.26, 30, 0.3849, 0.4688, 2.0431, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.9.b', 'IM', 2.70, 30, 0.3585, 1.9710, 3.4373, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.9.b', 'LV', 2.11, 30, 0.3222, 1.4465, 2.7644, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.10', 'IM', 2.65, 29, 0.4122, 1.8059, 3.4947, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.10', 'LV', 1.69, 28, 0.3827, 0.9017, 2.4722, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.a', 'IM', 4.15, 27, 0.1449, 3.8506, 4.4461, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.a', 'LV', 5.00, 27, 0.2579, 4.4683, 5.5286, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.b', 'IM', 3.76, 27, 0.1964, 3.3526, 4.1602, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.b', 'LV', 5.03, 27, 0.3661, 4.2816, 5.7867, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.c', 'IM', 3.51, 26, 0.1661, 3.1669, 3.8510, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.c', 'LV', 4.06, 27, 0.3857, 3.2711, 4.8568, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.d', 'IM', 2.98, 25, 0.2817, 2.3977, 3.5605, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.d', 'LV', 3.29, 25, 0.5008, 2.2588, 4.3260, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.e', 'IM', 4.29, 25, 0.3327, 3.6020, 4.9753, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.e', 'LV', 4.83, 26, 0.4963, 3.8061, 5.8503, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.f', 'IM', 4.01, 26, 0.1540, 3.6885, 4.3230, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.f', 'LV', 4.55, 26, 0.2960, 3.9363, 5.1554, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.2.a', 'IM', 2.12, 26, 0.1917, 1.7258, 2.5154, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.2.a', 'LV', 2.35, 27, 0.4653, 1.3947, 3.3074, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.2.b', 'IM', 1.57, 25, 0.2531, 1.0515, 2.0963, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.2.b', 'LV', 0.94, 26, 0.4005, 0.1169, 1.7667, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.a', 'IM', 3.53, 26, 0.1511, 3.2182, 3.8404, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.a', 'LV', 4.16, 26, 0.2202, 3.7076, 4.6147, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.b', 'IM', 2.18, 26, 0.4478, 1.2625, 3.1071, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.b', 'LV', 2.01, 26, 0.5911, 0.7884, 3.2233, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.c', 'IM', 1.60, 26, 0.1746, 1.2398, 1.9589, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.c', 'LV', 1.51, 27, 0.4221, 0.6397, 2.3750, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.d', 'IM', 1.47, 26, 0.1301, 1.1985, 1.7344, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.d', 'LV', 1.07, 27, 0.2820, 0.4918, 1.6512, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.e', 'IM', 2.15, 25, 0.2687, 1.5981, 2.7074, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.e', 'LV', 2.14, 27, 0.3325, 1.4614, 2.8283, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.a', 'IM', 4.15, 26, 0.1443, 3.8568, 4.4510, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.a', 'LV', 4.32, 27, 0.2270, 3.8534, 4.7867, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.b', 'IM', 1.36, 27, 0.1096, 1.1387, 1.5892, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.b', 'LV', 0.74, 27, 0.2045, 0.3189, 1.1594, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.c', 'IM', 1.44, 27, 0.1567, 1.1147, 1.7587, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.c', 'LV', 1.05, 27, 0.3535, 0.3235, 1.7766, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.d', 'IM', 1.15, 27, 0.0852, 1.0000, 1.3243, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.d', 'LV', 0.30, 27, 0.1703, 0.0000, 0.6486, 'Y', 'Y', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.e', 'IM', 3.00, 27, 0.2483, 2.4892, 3.5100, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.e', 'LV', 3.44, 27, 0.3092, 2.8052, 4.0763, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.f', 'IM', 1.86, 27, 0.2877, 1.2730, 2.4559, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.f', 'LV', 1.22, 27, 0.4487, 0.2989, 2.1434, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.g', 'IM', 1.44, 27, 0.1747, 1.0845, 1.8028, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.g', 'LV', 1.02, 27, 0.4078, 0.1770, 1.8535, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.5.a', 'IM', 1.36, 27, 0.1560, 1.0389, 1.6801, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.5.a', 'LV', 0.60, 27, 0.2696, 0.0434, 1.1519, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.5.b', 'IM', 1.90, 26, 0.1994, 1.4934, 2.3147, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.5.b', 'LV', 1.68, 26, 0.3141, 1.0324, 2.3263, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.6', 'IM', 3.44, 27, 0.2955, 2.8347, 4.0494, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.6', 'LV', 4.26, 27, 0.4942, 3.2478, 5.2797, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.a', 'IM', 4.16, 27, 0.1953, 3.7634, 4.5664, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.a', 'LV', 4.07, 27, 0.1946, 3.6694, 4.4695, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.b', 'IM', 1.84, 26, 0.2350, 1.3602, 2.3283, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.b', 'LV', 1.52, 27, 0.6320, 0.2237, 2.8217, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.c', 'IM', 1.16, 27, 0.1137, 1.0000, 1.3905, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.c', 'LV', 0.26, 27, 0.1773, 0.0000, 0.6216, 'Y', 'Y', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.d', 'IM', 1.20, 27, 0.0899, 1.0186, 1.3882, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.d', 'LV', 0.41, 27, 0.1891, 0.0211, 0.7987, 'N', 'Y', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.e', 'IM', 1.56, 27, 0.2281, 1.0882, 2.0261, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.e', 'LV', 1.35, 27, 0.6123, 0.0877, 2.6047, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.8.a', 'IM', 3.36, 27, 0.2234, 2.9057, 3.8242, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.8.a', 'LV', 3.64, 27, 0.2227, 3.1834, 4.0991, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.8.b', 'IM', 3.01, 27, 0.3002, 2.3896, 3.6239, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.8.b', 'LV', 2.97, 26, 0.3524, 2.2393, 3.6908, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.9.a', 'IM', 1.86, 26, 0.2491, 1.3520, 2.3780, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.9.a', 'LV', 1.18, 27, 0.2880, 0.5898, 1.7738, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.9.b', 'IM', 2.71, 27, 0.2732, 2.1474, 3.2704, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.9.b', 'LV', 2.66, 27, 0.5245, 1.5863, 3.7426, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.10', 'IM', 1.69, 27, 0.1616, 1.3579, 2.0221, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.10', 'LV', 1.25, 27, 0.2603, 0.7181, 1.7882, 'N', 'N', '2023-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.a', 'IM', 4.70, 15, 0.1743, 4.3225, 5.0000, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.a', 'LV', 4.72, 15, 0.1919, 4.3100, 5.1333, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.b', 'IM', 4.12, 15, 0.1938, 3.7037, 4.5351, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.b', 'LV', 4.95, 15, 0.4660, 3.9508, 5.9497, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.c', 'IM', 3.99, 15, 0.4664, 2.9872, 4.9878, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.c', 'LV', 3.40, 15, 0.5948, 2.1293, 4.6806, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.d', 'IM', 4.25, 15, 0.3571, 3.4889, 5.0000, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.d', 'LV', 4.83, 15, 0.5425, 3.6708, 5.9978, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.e', 'IM', 4.55, 15, 0.1944, 4.1341, 4.9679, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.e', 'LV', 5.00, 15, 0.3861, 4.1751, 5.8315, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.f', 'IM', 4.64, 15, 0.1781, 4.2588, 5.0000, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.f', 'LV', 4.89, 15, 0.2711, 4.3075, 5.4704, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.2.a', 'IM', 2.47, 15, 0.4804, 1.4364, 3.4969, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.2.a', 'LV', 2.25, 15, 0.7825, 0.5674, 3.9241, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.2.b', 'IM', 2.59, 15, 0.6705, 1.1494, 4.0253, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.2.b', 'LV', 2.29, 15, 0.9747, 0.2043, 4.3852, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.a', 'IM', 4.10, 14, 0.2731, 3.5063, 4.6861, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.a', 'LV', 4.79, 15, 0.4729, 3.7708, 5.7994, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.b', 'IM', 2.39, 15, 0.2292, 1.9019, 2.8852, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.b', 'LV', 2.17, 14, 0.2967, 1.5324, 2.8143, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.c', 'IM', 1.84, 15, 0.3782, 1.0338, 2.6562, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.c', 'LV', 1.49, 15, 0.6751, 0.0415, 2.9376, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.d', 'IM', 1.37, 15, 0.3283, 1.0000, 2.0705, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.d', 'LV', 0.18, 15, 0.1641, 0.0000, 0.5352, 'Y', 'Y', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.e', 'IM', 2.35, 15, 0.3354, 1.6279, 3.0667, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.e', 'LV', 1.63, 15, 0.3124, 0.9555, 2.2956, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.a', 'IM', 4.33, 15, 0.3532, 3.5680, 5.0000, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.a', 'LV', 3.91, 15, 0.3371, 3.1865, 4.6326, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.b', 'IM', 1.27, 15, 0.1733, 1.0000, 1.6375, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.b', 'LV', 0.71, 15, 0.4973, 0.0000, 1.7812, 'Y', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.c', 'IM', 1.99, 15, 0.3251, 1.2909, 2.6854, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.c', 'LV', 1.99, 15, 0.6132, 0.6762, 3.3066, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.d', 'IM', 1.55, 15, 0.4924, 1.0000, 2.6057, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.d', 'LV', 0.55, 15, 0.4924, 0.0000, 1.6057, 'Y', 'Y', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.e', 'IM', 3.35, 15, 0.6537, 1.9519, 4.7562, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.e', 'LV', 3.74, 15, 0.9928, 1.6151, 5.8738, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.f', 'IM', 2.89, 14, 0.5797, 1.6340, 4.1388, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.f', 'LV', 2.63, 14, 0.7801, 0.9413, 4.3119, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.g', 'IM', 2.37, 15, 0.4293, 1.4530, 3.2944, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.g', 'LV', 2.10, 15, 0.7312, 0.5268, 3.6635, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.5.a', 'IM', 1.67, 15, 0.1772, 1.2891, 2.0493, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.5.a', 'LV', 1.25, 15, 0.4434, 0.3001, 2.2020, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.5.b', 'IM', 2.43, 15, 0.6124, 1.1205, 3.7474, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.5.b', 'LV', 2.03, 15, 0.7916, 0.3276, 3.7234, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.6', 'IM', 3.68, 15, 0.3289, 2.9741, 4.3847, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.6', 'LV', 4.64, 15, 0.4476, 3.6791, 5.5992, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.a', 'IM', 4.72, 15, 0.1736, 4.3505, 5.0000, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.a', 'LV', 4.28, 15, 0.6180, 2.9596, 5.6103, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.b', 'IM', 2.45, 15, 0.4942, 1.3903, 3.5103, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.b', 'LV', 1.40, 15, 0.5753, 0.1686, 2.6362, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.c', 'IM', 1.37, 15, 0.2300, 1.0000, 1.8664, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.c', 'LV', 1.02, 15, 0.6265, 0.0000, 2.3685, 'Y', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.d', 'IM', 1.52, 15, 0.3000, 1.0000, 2.1685, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.d', 'LV', 0.37, 15, 0.1917, 0.0000, 0.7830, 'Y', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.e', 'IM', 2.15, 15, 0.4212, 1.2427, 3.0493, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.e', 'LV', 2.55, 15, 0.7641, 0.9131, 4.1909, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.8.a', 'IM', 3.96, 15, 0.2519, 3.4244, 4.5049, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.8.a', 'LV', 3.56, 15, 0.3425, 2.8251, 4.2942, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.8.b', 'IM', 2.86, 15, 0.2922, 2.2291, 3.4824, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.8.b', 'LV', 2.83, 14, 0.5448, 1.6491, 4.0030, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.9.a', 'IM', 2.94, 15, 0.4617, 1.9540, 3.9343, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.9.a', 'LV', 2.52, 14, 0.8677, 0.6435, 4.3928, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.9.b', 'IM', 3.63, 15, 0.3117, 2.9570, 4.2943, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.9.b', 'LV', 3.45, 15, 0.5180, 2.3398, 4.5619, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.10', 'IM', 2.66, 15, 0.5149, 1.5541, 3.7627, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.10', 'LV', 2.00, 14, 0.6076, 0.6855, 3.3106, 'N', 'N', '2017-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.a', 'IM', 4.68, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.a', 'LV', 5.50, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.b', 'IM', 3.68, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.b', 'LV', 5.43, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.c', 'IM', 3.30, 27, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.c', 'LV', 3.86, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.d', 'IM', 2.46, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.d', 'LV', 2.93, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.e', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.e', 'LV', 5.52, 27, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.f', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.f', 'LV', 4.96, 27, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.2.a', 'IM', 2.59, 27, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.2.a', 'LV', 2.85, 27, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.2.b', 'IM', 1.26, 27, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.2.b', 'LV', 0.52, 27, NULL, NULL, NULL, NULL, 'Y', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.a', 'IM', 3.79, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.a', 'LV', 4.89, 27, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.b', 'IM', 2.36, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.b', 'LV', 2.25, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.c', 'IM', 2.00, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.c', 'LV', 2.29, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.d', 'IM', 1.61, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.d', 'LV', 1.14, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.e', 'IM', 1.54, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.e', 'LV', 0.81, 27, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.a', 'IM', 3.39, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.a', 'LV', 4.36, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.b', 'IM', 1.46, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.b', 'LV', 0.75, 28, NULL, NULL, NULL, NULL, 'Y', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.c', 'IM', 1.75, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.c', 'LV', 1.68, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.d', 'IM', 2.52, 27, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.d', 'LV', 2.39, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.e', 'IM', 3.21, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.e', 'LV', 3.79, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.f', 'IM', 2.43, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.f', 'LV', 2.89, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.g', 'IM', 1.64, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.g', 'LV', 1.43, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.5.a', 'IM', 3.41, 27, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.5.a', 'LV', 3.19, 27, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.5.b', 'IM', 2.39, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.5.b', 'LV', 2.54, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.6', 'IM', 3.93, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.6', 'LV', 5.46, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.a', 'IM', 4.37, 27, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.a', 'LV', 4.85, 27, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.b', 'IM', 1.50, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.b', 'LV', 1.00, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.c', 'IM', 1.29, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.c', 'LV', 0.43, 28, NULL, NULL, NULL, NULL, 'Y', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.d', 'IM', 1.39, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.d', 'LV', 1.00, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.e', 'IM', 1.89, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.e', 'LV', 2.00, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.8.a', 'IM', 3.18, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.8.a', 'LV', 3.25, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.8.b', 'IM', 3.32, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.8.b', 'LV', 3.29, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.9.a', 'IM', 2.36, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.9.a', 'LV', 2.07, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.9.b', 'IM', 2.57, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.9.b', 'LV', 2.57, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.10', 'IM', 1.68, 28, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.10', 'LV', 1.36, 28, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.a', 'IM', 3.82, 24, 0.3262, 3.1433, 4.4929, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.a', 'LV', 4.22, 24, 0.1974, 3.8080, 4.6246, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.b', 'IM', 3.57, 25, 0.2504, 3.0530, 4.0866, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.b', 'LV', 4.89, 25, 0.3132, 4.2480, 5.5410, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.c', 'IM', 2.18, 25, 0.1492, 1.8750, 2.4911, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.c', 'LV', 2.10, 25, 0.2719, 1.5385, 2.6607, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.d', 'IM', 2.01, 25, 0.1610, 1.6807, 2.3454, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.d', 'LV', 2.31, 25, 0.3932, 1.5018, 3.1248, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.e', 'IM', 3.14, 25, 0.4975, 2.1172, 4.1709, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.e', 'LV', 4.06, 25, 0.5831, 2.8586, 5.2656, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.f', 'IM', 3.26, 25, 0.3748, 2.4837, 4.0308, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.f', 'LV', 3.80, 25, 0.4825, 2.8041, 4.7959, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.2.a', 'IM', 2.88, 24, 0.3626, 2.1289, 3.6289, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.2.a', 'LV', 3.03, 25, 0.5524, 1.8927, 4.1729, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.2.b', 'IM', 1.46, 25, 0.2367, 1.0000, 1.9478, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.2.b', 'LV', 0.78, 25, 0.3829, 0.0000, 1.5660, 'N', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.a', 'IM', 3.66, 25, 0.1430, 3.3607, 3.9509, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.a', 'LV', 4.61, 25, 0.1678, 4.2639, 4.9567, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.b', 'IM', 2.73, 25, 0.2362, 2.2456, 3.2204, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.b', 'LV', 3.33, 25, 0.4643, 2.3702, 4.2866, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.c', 'IM', 2.02, 25, 0.3111, 1.3743, 2.6586, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.c', 'LV', 2.45, 25, 0.5239, 1.3645, 3.5271, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.d', 'IM', 1.48, 25, 0.1778, 1.1146, 1.8483, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.d', 'LV', 1.51, 25, 0.5423, 0.3877, 2.6260, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.e', 'IM', 2.26, 25, 0.3847, 1.4677, 3.0558, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.e', 'LV', 2.53, 25, 0.6984, 1.0921, 3.9750, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.a', 'IM', 3.48, 25, 0.1613, 3.1469, 3.8125, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.a', 'LV', 4.50, 25, 0.2028, 4.0843, 4.9215, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.b', 'IM', 2.16, 25, 0.3729, 1.3914, 2.9305, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.b', 'LV', 2.29, 25, 0.6822, 0.8789, 3.6951, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.c', 'IM', 3.50, 25, 0.4040, 2.6675, 4.3353, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.c', 'LV', 4.45, 25, 0.3384, 3.7541, 5.1508, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.d', 'IM', 4.03, 25, 0.2207, 3.5701, 4.4809, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.d', 'LV', 5.07, 25, 0.2830, 4.4834, 5.6517, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.e', 'IM', 1.72, 25, 0.0812, 1.5539, 1.8889, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.e', 'LV', 1.79, 25, 0.2928, 1.1863, 2.3951, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.f', 'IM', 1.48, 25, 0.1966, 1.0716, 1.8831, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.f', 'LV', 1.15, 25, 0.4695, 0.1799, 2.1179, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.g', 'IM', 1.91, 25, 0.4058, 1.0732, 2.7481, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.g', 'LV', 2.20, 25, 0.8989, 0.3438, 4.0543, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.5.a', 'IM', 1.77, 25, 0.3458, 1.0517, 2.4789, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.5.a', 'LV', 1.12, 25, 0.4158, 0.2636, 1.9801, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.5.b', 'IM', 1.18, 25, 0.0872, 1.0014, 1.3614, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.5.b', 'LV', 0.40, 25, 0.1928, 0.0038, 0.7998, 'N', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.6', 'IM', 2.87, 25, 0.2726, 2.3074, 3.4325, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.6', 'LV', 3.70, 25, 0.4108, 2.8564, 4.5521, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.a', 'IM', 3.99, 25, 0.1781, 3.6269, 4.3618, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.a', 'LV', 4.68, 25, 0.2643, 4.1354, 5.2264, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.b', 'IM', 1.24, 25, 0.1048, 1.0204, 1.4528, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.b', 'LV', 0.67, 25, 0.3280, 0.0000, 1.3498, 'N', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.c', 'IM', 1.23, 25, 0.1623, 1.0000, 1.5663, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.c', 'LV', 0.43, 25, 0.3105, 0.0000, 1.0678, 'Y', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.d', 'IM', 1.39, 25, 0.2325, 1.0000, 1.8708, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.d', 'LV', 0.71, 25, 0.4050, 0.0000, 1.5503, 'Y', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.e', 'IM', 1.22, 25, 0.1209, 1.0000, 1.4665, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.e', 'LV', 0.61, 25, 0.3213, 0.0000, 1.2692, 'Y', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.8.a', 'IM', 2.29, 25, 0.2778, 1.7153, 2.8622, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.8.a', 'LV', 2.13, 25, 0.4077, 1.2896, 2.9723, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.8.b', 'IM', 1.96, 24, 0.3913, 1.1464, 2.7654, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.8.b', 'LV', 1.37, 25, 0.4852, 0.3674, 2.3702, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.9.a', 'IM', 1.83, 25, 0.1682, 1.4790, 2.1732, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.9.a', 'LV', 1.15, 25, 0.2986, 0.5319, 1.7645, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.9.b', 'IM', 2.48, 25, 0.2860, 1.8905, 3.0710, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.9.b', 'LV', 2.73, 25, 0.3649, 1.9749, 3.4813, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.10', 'IM', 1.62, 25, 0.2339, 1.1398, 2.1052, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.10', 'LV', 1.31, 25, 0.4579, 0.3661, 2.2561, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.a', 'IM', 2.97, 19, 0.3085, 2.3262, 3.6225, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.a', 'LV', 2.84, 19, 0.4431, 1.9049, 3.7667, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.b', 'IM', 3.73, 19, 0.3051, 3.0920, 4.3742, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.b', 'LV', 4.38, 19, 0.4669, 3.4041, 5.3659, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.c', 'IM', 1.63, 19, 0.2145, 1.1768, 2.0781, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.c', 'LV', 1.14, 19, 0.3966, 0.3055, 1.9718, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.d', 'IM', 2.02, 19, 0.2590, 1.4738, 2.5619, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.d', 'LV', 1.87, 19, 0.4755, 0.8669, 2.8651, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.e', 'IM', 4.27, 19, 0.3308, 3.5724, 4.9625, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.e', 'LV', 4.85, 19, 0.5549, 3.6812, 6.0129, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.f', 'IM', 2.58, 19, 0.2790, 1.9942, 3.1667, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.f', 'LV', 2.35, 19, 0.4037, 1.5018, 3.1979, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.2.a', 'IM', 1.77, 18, 0.2894, 1.1622, 2.3833, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.2.a', 'LV', 1.18, 18, 0.4491, 0.2311, 2.1260, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.2.b', 'IM', 1.07, 19, 0.0610, 1.0000, 1.1986, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.2.b', 'LV', 0.07, 19, 0.0610, 0.0000, 0.1986, 'Y', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.a', 'IM', 2.91, 19, 0.2856, 2.3111, 3.5110, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.a', 'LV', 3.47, 19, 0.4916, 2.4408, 4.5065, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.b', 'IM', 1.81, 19, 0.2720, 1.2336, 2.3765, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.b', 'LV', 1.38, 19, 0.4393, 0.4552, 2.3010, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.c', 'IM', 1.50, 19, 0.2229, 1.0337, 1.9704, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.c', 'LV', 0.91, 19, 0.4076, 0.0561, 1.7686, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.d', 'IM', 1.00, 19, 0.0000, NULL, NULL, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.d', 'LV', 0.00, 19, 0.0000, NULL, NULL, 'N', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.e', 'IM', 1.42, 19, 0.1930, 1.0135, 1.8245, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.e', 'LV', 0.79, 19, 0.3582, 0.0396, 1.5446, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.a', 'IM', 2.87, 19, 0.2696, 2.3066, 3.4394, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.a', 'LV', 3.07, 19, 0.4371, 2.1553, 3.9920, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.b', 'IM', 1.69, 19, 0.2109, 1.2491, 2.1352, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.b', 'LV', 1.25, 19, 0.3818, 0.4525, 2.0569, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.c', 'IM', 2.51, 19, 0.2598, 1.9642, 3.0558, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.c', 'LV', 2.51, 19, 0.3352, 1.8045, 3.2129, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.d', 'IM', 2.96, 19, 0.4225, 2.0682, 3.8434, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.d', 'LV', 3.15, 19, 0.5983, 1.8967, 4.4108, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.e', 'IM', 2.58, 19, 0.2778, 2.0013, 3.1686, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.e', 'LV', 2.95, 19, 0.4596, 1.9821, 3.9131, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.f', 'IM', 2.32, 19, 0.2673, 1.7616, 2.8847, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.f', 'LV', 2.26, 19, 0.4979, 1.2127, 3.3049, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.g', 'IM', 1.58, 19, 0.2068, 1.1482, 2.0171, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.g', 'LV', 1.07, 19, 0.3685, 0.2917, 1.8400, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.5.a', 'IM', 3.24, 19, 0.3417, 2.5232, 3.9588, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.5.a', 'LV', 3.07, 19, 0.4990, 2.0257, 4.1225, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.5.b', 'IM', 2.06, 19, 0.2817, 1.4679, 2.6515, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.5.b', 'LV', 1.64, 19, 0.4500, 0.6902, 2.5809, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.6', 'IM', 2.69, 19, 0.2784, 2.1075, 3.2772, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.6', 'LV', 2.95, 19, 0.5431, 1.8100, 4.0919, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.a', 'IM', 3.77, 19, 0.1554, 3.4450, 4.0980, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.a', 'LV', 4.07, 19, 0.2464, 3.5515, 4.5867, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.b', 'IM', 1.33, 19, 0.1281, 1.0631, 1.6014, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.b', 'LV', 0.44, 19, 0.1693, 0.0800, 0.7914, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.c', 'IM', 1.21, 19, 0.1565, 1.0000, 1.5369, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.c', 'LV', 0.37, 19, 0.2736, 0.0000, 0.9448, 'Y', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.d', 'IM', 1.37, 19, 0.1698, 1.0173, 1.7308, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.d', 'LV', 0.56, 19, 0.2736, 0.0000, 1.1364, 'N', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.e', 'IM', 2.14, 19, 0.4409, 1.2110, 3.0637, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.e', 'LV', 1.90, 19, 0.7272, 0.3739, 3.4294, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.8.a', 'IM', 2.66, 19, 0.3956, 1.8248, 3.4871, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.8.a', 'LV', 2.28, 19, 0.4875, 1.2550, 3.3035, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.8.b', 'IM', 2.44, 19, 0.4818, 1.4295, 3.4539, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.8.b', 'LV', 2.14, 19, 0.5486, 0.9905, 3.2955, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.9.a', 'IM', 1.87, 19, 0.2494, 1.3480, 2.3959, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.9.a', 'LV', 0.84, 19, 0.3285, 0.1473, 1.5274, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.9.b', 'IM', 2.16, 19, 0.2154, 1.7072, 2.6123, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.9.b', 'LV', 2.06, 19, 0.3268, 1.3718, 2.7451, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.10', 'IM', 2.00, 18, 0.2283, 1.5223, 2.4858, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.10', 'LV', 1.75, 18, 0.3875, 0.9360, 2.5710, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.a', 'IM', 2.86, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.a', 'LV', 4.05, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.b', 'IM', 1.95, 21, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.b', 'LV', 2.32, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.c', 'IM', 2.73, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.c', 'LV', 3.23, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.d', 'IM', 2.62, 21, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.d', 'LV', 3.77, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.e', 'IM', 2.95, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.e', 'LV', 4.18, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.f', 'IM', 2.45, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.f', 'LV', 3.05, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.2.a', 'IM', 2.00, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.2.a', 'LV', 1.91, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.2.b', 'IM', 1.32, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.2.b', 'LV', 0.77, 22, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.a', 'IM', 3.55, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.a', 'LV', 4.91, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.b', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.b', 'LV', 6.23, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.c', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.c', 'LV', 5.36, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.d', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.d', 'LV', 4.14, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.e', 'IM', 2.10, 21, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.e', 'LV', 2.64, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.a', 'LV', 5.45, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.b', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.b', 'LV', 4.86, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.c', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.c', 'LV', 4.64, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.d', 'IM', 2.95, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.d', 'LV', 4.36, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.e', 'IM', 1.68, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.e', 'LV', 1.45, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.f', 'IM', 1.68, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.f', 'LV', 1.73, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.g', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.g', 'LV', 5.09, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.5.a', 'IM', 1.23, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.5.a', 'LV', 0.50, 22, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.5.b', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.5.b', 'LV', 0.68, 22, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.6', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.6', 'LV', 4.36, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.a', 'IM', 3.41, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.a', 'LV', 4.45, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.b', 'IM', 1.45, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.b', 'LV', 1.09, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.c', 'IM', 1.09, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.c', 'LV', 0.23, 22, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.d', 'IM', 1.82, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.d', 'LV', 2.14, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.e', 'IM', 1.32, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.e', 'LV', 0.86, 22, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.8.a', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.8.a', 'LV', 3.55, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.8.b', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.8.b', 'LV', 3.77, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.9.a', 'IM', 2.09, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.9.a', 'LV', 2.18, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.9.b', 'IM', 2.59, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.9.b', 'LV', 2.55, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.10', 'IM', 2.00, 22, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.10', 'LV', 2.18, 22, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.a', 'IM', 4.42, 29, 0.1903, 4.0290, 4.8086, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.a', 'LV', 4.59, 29, 0.2335, 4.1067, 5.0635, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.b', 'IM', 3.58, 29, 0.1896, 3.1930, 3.9698, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.b', 'LV', 4.53, 29, 0.2455, 4.0289, 5.0346, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.c', 'IM', 3.00, 29, 0.2472, 2.4947, 3.5073, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.c', 'LV', 2.84, 29, 0.4165, 1.9861, 3.6925, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.d', 'IM', 2.72, 29, 0.2951, 2.1199, 3.3287, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.d', 'LV', 3.04, 29, 0.4264, 2.1633, 3.9102, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.e', 'IM', 3.96, 29, 0.2052, 3.5374, 4.3781, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.e', 'LV', 4.79, 29, 0.3707, 4.0293, 5.5480, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.f', 'IM', 3.59, 29, 0.2140, 3.1557, 4.0324, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.f', 'LV', 3.87, 29, 0.3426, 3.1701, 4.5737, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.2.a', 'IM', 4.03, 28, 0.2948, 3.4240, 4.6338, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.2.a', 'LV', 4.59, 29, 0.4311, 3.7021, 5.4683, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.2.b', 'IM', 1.06, 29, 0.0449, 1.0000, 1.1546, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.2.b', 'LV', 0.19, 29, 0.1347, 0.0000, 0.4638, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.a', 'IM', 3.57, 29, 0.1731, 3.2171, 3.9262, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.a', 'LV', 4.45, 29, 0.1650, 4.1138, 4.7900, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.b', 'IM', 2.27, 29, 0.1802, 1.9025, 2.6406, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.b', 'LV', 2.21, 29, 0.3434, 1.5108, 2.9174, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.c', 'IM', 1.79, 29, 0.1764, 1.4319, 2.1546, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.c', 'LV', 1.72, 29, 0.3863, 0.9322, 2.5146, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.d', 'IM', 1.65, 29, 0.2300, 1.1752, 2.1173, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.d', 'LV', 1.18, 29, 0.3983, 0.3643, 1.9960, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.e', 'IM', 2.56, 29, 0.2448, 2.0627, 3.0656, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.e', 'LV', 2.76, 29, 0.3247, 2.0966, 3.4269, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.a', 'IM', 3.59, 29, 0.1600, 3.2629, 3.9184, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.a', 'LV', 4.11, 29, 0.2154, 3.6710, 4.5535, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.b', 'IM', 1.39, 28, 0.1096, 1.1667, 1.6163, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.b', 'LV', 0.76, 29, 0.2278, 0.2887, 1.2220, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.c', 'IM', 1.42, 29, 0.1584, 1.0916, 1.7405, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.c', 'LV', 0.66, 29, 0.2448, 0.1592, 1.1622, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.d', 'IM', 1.25, 29, 0.0959, 1.0556, 1.4484, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.d', 'LV', 0.44, 29, 0.1737, 0.0853, 0.7970, 'N', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.e', 'IM', 3.07, 29, 0.2388, 2.5803, 3.5586, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.e', 'LV', 3.41, 29, 0.2324, 2.9311, 3.8831, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.f', 'IM', 1.90, 29, 0.1363, 1.6167, 2.1752, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.f', 'LV', 1.54, 29, 0.2217, 1.0903, 1.9984, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.g', 'IM', 2.20, 29, 0.1687, 1.8528, 2.5438, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.g', 'LV', 2.41, 29, 0.3698, 1.6564, 3.1714, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.5.a', 'IM', 1.49, 29, 0.1327, 1.2193, 1.7629, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.5.a', 'LV', 0.98, 29, 0.2923, 0.3764, 1.5739, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.5.b', 'IM', 1.98, 29, 0.1535, 1.6672, 2.2962, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.5.b', 'LV', 2.02, 29, 0.3521, 1.2965, 2.7390, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.6', 'IM', 3.68, 29, 0.2387, 3.1898, 4.1679, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.6', 'LV', 4.71, 29, 0.3968, 3.8940, 5.5197, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.a', 'IM', 4.08, 29, 0.1409, 3.7876, 4.3651, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.a', 'LV', 3.97, 29, 0.2533, 3.4526, 4.4901, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.b', 'IM', 1.44, 29, 0.1292, 1.1737, 1.7028, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.b', 'LV', 0.72, 29, 0.2374, 0.2295, 1.2022, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.c', 'IM', 1.10, 29, 0.0750, 1.0000, 1.2576, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.c', 'LV', 0.15, 29, 0.1141, 0.0000, 0.3868, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.d', 'IM', 1.47, 29, 0.1477, 1.1718, 1.7768, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.d', 'LV', 0.82, 29, 0.2702, 0.2619, 1.3691, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.e', 'IM', 1.59, 29, 0.1424, 1.3028, 1.8862, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.e', 'LV', 1.31, 29, 0.2934, 0.7085, 1.9106, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.8.a', 'IM', 4.20, 29, 0.1809, 3.8321, 4.5733, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.8.a', 'LV', 4.33, 28, 0.2005, 3.9162, 4.7392, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.8.b', 'IM', 3.25, 29, 0.1556, 2.9354, 3.5730, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.8.b', 'LV', 3.13, 29, 0.2841, 2.5469, 3.7106, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.9.a', 'IM', 2.34, 29, 0.2630, 1.8061, 2.8835, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.9.a', 'LV', 1.82, 29, 0.3943, 1.0097, 2.6253, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.9.b', 'IM', 2.78, 29, 0.2271, 2.3194, 3.2497, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.9.b', 'LV', 2.86, 29, 0.2432, 2.3588, 3.3550, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.10', 'IM', 3.54, 29, 0.2347, 3.0554, 4.0171, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.10', 'LV', 3.65, 29, 0.1887, 3.2650, 4.0383, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.a', 'LV', 5.05, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.b', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.b', 'LV', 4.80, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.c', 'LV', 4.55, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.d', 'IM', 3.20, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.d', 'LV', 4.05, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.e', 'IM', 4.63, 19, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.e', 'LV', 5.85, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.f', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.f', 'LV', 4.20, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.2.a', 'IM', 1.84, 19, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.2.a', 'LV', 1.42, 19, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.2.b', 'IM', 1.05, 19, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.2.b', 'LV', 0.05, 19, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.a', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.a', 'LV', 4.10, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.b', 'IM', 2.30, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.b', 'LV', 2.30, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.c', 'IM', 1.65, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.c', 'LV', 1.85, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.d', 'IM', 3.05, 19, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.d', 'LV', 3.65, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.e', 'IM', 2.58, 19, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.e', 'LV', 2.55, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.a', 'LV', 4.20, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.b', 'IM', 1.60, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.b', 'LV', 1.30, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.c', 'IM', 1.75, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.c', 'LV', 1.90, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.d', 'IM', 1.40, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.d', 'LV', 1.05, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.e', 'IM', 2.90, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.e', 'LV', 3.25, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.f', 'IM', 1.74, 19, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.f', 'LV', 1.40, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.g', 'IM', 1.95, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.g', 'LV', 1.95, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.5.a', 'IM', 1.25, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.5.a', 'LV', 0.50, 20, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.5.b', 'IM', 1.40, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.5.b', 'LV', 1.15, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.6', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.6', 'LV', 4.05, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.a', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.a', 'LV', 4.10, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.b', 'IM', 1.65, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.b', 'LV', 1.25, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.c', 'IM', 1.15, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.c', 'LV', 0.25, 20, NULL, NULL, NULL, NULL, 'Y', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.d', 'IM', 1.25, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.d', 'LV', 0.65, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.e', 'IM', 1.55, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.e', 'LV', 1.40, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.8.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.8.a', 'LV', 4.35, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.8.b', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.8.b', 'LV', 4.20, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.9.a', 'IM', 2.84, 19, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.9.a', 'LV', 2.55, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.9.b', 'IM', 2.85, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.9.b', 'LV', 2.75, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.10', 'IM', 1.75, 20, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.10', 'LV', 1.35, 20, NULL, NULL, NULL, NULL, 'N', '2020-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.a', 'IM', 4.37, 26, 0.1117, 4.1351, 4.5954, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.a', 'LV', 4.60, 27, 0.2150, 4.1571, 5.0410, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.b', 'IM', 3.46, 25, 0.2028, 3.0459, 3.8829, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.b', 'LV', 4.49, 27, 0.3504, 3.7681, 5.2086, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.c', 'IM', 2.80, 25, 0.2586, 2.2683, 3.3356, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.c', 'LV', 3.04, 27, 0.4464, 2.1198, 3.9550, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.d', 'IM', 2.31, 26, 0.2388, 1.8189, 2.8026, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.d', 'LV', 2.95, 27, 0.4938, 1.9393, 3.9692, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.e', 'IM', 4.61, 26, 0.1137, 4.3774, 4.8457, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.e', 'LV', 5.94, 27, 0.2369, 5.4547, 6.4285, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.f', 'IM', 3.73, 26, 0.1263, 3.4657, 3.9858, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.f', 'LV', 4.36, 27, 0.1550, 4.0445, 4.6816, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.2.a', 'IM', 2.09, 26, 0.2852, 1.5025, 2.6772, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.2.a', 'LV', 1.97, 26, 0.5299, 0.8770, 3.0597, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.2.b', 'IM', 1.26, 26, 0.1429, 1.0000, 1.5589, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.2.b', 'LV', 0.63, 27, 0.2929, 0.0320, 1.2362, 'N', 'Y', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.a', 'IM', 3.29, 26, 0.2355, 2.8087, 3.7786, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.a', 'LV', 3.62, 27, 0.2794, 3.0427, 4.1912, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.b', 'IM', 1.51, 26, 0.1821, 1.1384, 1.8884, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.b', 'LV', 1.14, 27, 0.3793, 0.3589, 1.9182, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.c', 'IM', 1.56, 26, 0.1784, 1.1922, 1.9270, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.c', 'LV', 1.08, 27, 0.3476, 0.3646, 1.7938, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.d', 'IM', 1.67, 25, 0.2608, 1.1355, 2.2119, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.d', 'LV', 1.21, 27, 0.4100, 0.3655, 2.0512, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.e', 'IM', 1.57, 26, 0.1936, 1.1744, 1.9718, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.e', 'LV', 1.27, 27, 0.3900, 0.4711, 2.0745, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.a', 'IM', 3.33, 26, 0.2458, 2.8199, 3.8326, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.a', 'LV', 4.06, 27, 0.2644, 3.5191, 4.6062, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.b', 'IM', 1.42, 25, 0.1543, 1.1028, 1.7396, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.b', 'LV', 0.86, 27, 0.3473, 0.1491, 1.5770, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.c', 'IM', 1.55, 26, 0.1938, 1.1549, 1.9530, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.c', 'LV', 1.31, 26, 0.4660, 0.3494, 2.2689, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.d', 'IM', 1.45, 26, 0.1910, 1.0575, 1.8444, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.d', 'LV', 0.90, 27, 0.3494, 0.1817, 1.6183, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.e', 'IM', 4.06, 26, 0.3593, 3.3241, 4.8042, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.e', 'LV', 4.76, 27, 0.3966, 3.9490, 5.5793, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.f', 'IM', 3.42, 26, 0.3138, 2.7762, 4.0689, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.f', 'LV', 4.16, 27, 0.3785, 3.3777, 4.9339, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.g', 'IM', 1.92, 26, 0.2887, 1.3252, 2.5143, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.g', 'LV', 1.64, 27, 0.4594, 0.6932, 2.5817, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.5.a', 'IM', 1.95, 26, 0.2648, 1.4078, 2.4988, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.5.a', 'LV', 1.50, 27, 0.3531, 0.7707, 2.2225, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.5.b', 'IM', 3.70, 26, 0.4445, 2.7892, 4.6199, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.5.b', 'LV', 4.48, 27, 0.5987, 3.2482, 5.7095, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.6', 'IM', 3.92, 26, 0.1619, 3.5832, 4.2499, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.6', 'LV', 5.25, 27, 0.3199, 4.5953, 5.9105, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.a', 'IM', 4.29, 26, 0.1427, 3.9949, 4.5825, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.a', 'LV', 4.52, 27, 0.2275, 4.0533, 4.9885, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.b', 'IM', 1.87, 26, 0.2815, 1.2914, 2.4511, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.b', 'LV', 1.33, 27, 0.3554, 0.5963, 2.0574, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.c', 'IM', 1.60, 26, 0.2799, 1.0209, 2.1738, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.c', 'LV', 0.79, 27, 0.3243, 0.1254, 1.4587, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.d', 'IM', 1.43, 26, 0.1852, 1.0502, 1.8129, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.d', 'LV', 0.88, 27, 0.3854, 0.0901, 1.6745, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.e', 'IM', 2.36, 27, 0.2332, 1.8851, 2.8438, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.e', 'LV', 3.00, 26, 0.5415, 1.8841, 4.1146, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.8.a', 'IM', 3.47, 27, 0.2802, 2.8944, 4.0464, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.8.a', 'LV', 3.55, 27, 0.4200, 2.6860, 4.4126, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.8.b', 'IM', 3.16, 27, 0.3385, 2.4652, 3.8568, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.8.b', 'LV', 2.92, 27, 0.3974, 2.1032, 3.7370, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.9.a', 'IM', 2.51, 27, 0.2442, 2.0129, 3.0169, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.9.a', 'LV', 1.50, 27, 0.2623, 0.9628, 2.0412, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.9.b', 'IM', 2.98, 27, 0.2078, 2.5525, 3.4067, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.9.b', 'LV', 2.89, 27, 0.1621, 2.5601, 3.2264, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.10', 'IM', 1.98, 27, 0.2583, 1.4523, 2.5143, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.10', 'LV', 1.65, 27, 0.3333, 0.9618, 2.3322, 'N', 'N', '2018-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.a', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.a', 'LV', 4.95, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.b', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.b', 'LV', 4.32, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.c', 'IM', 2.90, 20, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.c', 'LV', 3.32, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.d', 'IM', 2.59, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.d', 'LV', 3.50, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.e', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.e', 'LV', 5.73, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.f', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.f', 'LV', 4.59, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.2.a', 'IM', 2.29, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.2.a', 'LV', 2.73, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.2.b', 'IM', 1.77, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.2.b', 'LV', 2.00, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.a', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.a', 'LV', 4.68, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.b', 'IM', 2.59, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.b', 'LV', 2.73, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.c', 'IM', 2.10, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.c', 'LV', 2.43, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.d', 'IM', 2.64, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.d', 'LV', 2.86, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.e', 'IM', 2.27, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.e', 'LV', 2.41, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.a', 'IM', 2.68, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.a', 'LV', 3.50, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.b', 'IM', 2.18, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.b', 'LV', 2.09, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.c', 'IM', 2.27, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.c', 'LV', 2.82, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.d', 'IM', 2.05, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.d', 'LV', 2.41, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.e', 'IM', 2.90, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.e', 'LV', 3.59, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.f', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.f', 'LV', 3.36, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.g', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.g', 'LV', 4.27, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.5.a', 'IM', 2.05, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.5.a', 'LV', 2.18, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.5.b', 'IM', 2.38, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.5.b', 'LV', 3.09, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.6', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.6', 'LV', 5.68, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.a', 'IM', 3.95, 19, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.a', 'LV', 4.67, 21, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.b', 'IM', 2.27, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.b', 'LV', 1.91, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.c', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.c', 'LV', 0.48, 21, NULL, NULL, NULL, NULL, 'Y', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.d', 'IM', 2.05, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.d', 'LV', 2.32, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.e', 'IM', 1.90, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.e', 'LV', 2.23, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.8.a', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.8.a', 'LV', 5.09, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.8.b', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.8.b', 'LV', 4.36, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.9.a', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.9.a', 'LV', 4.09, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.9.b', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.9.b', 'LV', 4.05, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.10', 'IM', 3.32, 22, NULL, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.10', 'LV', 3.82, 22, NULL, NULL, NULL, NULL, 'N', '2023-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.1.a', 'IM', 4.38, 17, 0.2118, 3.9294, 4.8272, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.1.a', 'LV', 5.02, 17, 0.3048, 4.3722, 5.6645, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.1.b', 'IM', 4.05, 17, 0.1011, 3.8314, 4.2601, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.1.b', 'LV', 5.34, 17, 0.2671, 4.7762, 5.9085, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.1.c', 'IM', 3.74, 17, 0.3451, 3.0114, 4.4744, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.1.c', 'LV', 3.61, 17, 0.3549, 2.8618, 4.3665, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.1.d', 'IM', 3.59, 17, 0.3313, 2.8869, 4.2915, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.1.d', 'LV', 3.83, 17, 0.4192, 2.9370, 4.7145, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.1.e', 'IM', 4.67, 17, 0.1646, 4.3242, 5.0000, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.1.e', 'LV', 5.98, 17, 0.3663, 5.1988, 6.7520, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.1.f', 'IM', 3.55, 17, 0.1986, 3.1296, 3.9716, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.1.f', 'LV', 4.32, 17, 0.2743, 3.7431, 4.9061, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.2.a', 'IM', 2.20, 17, 0.3206, 1.5210, 2.8802, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.2.a', 'LV', 2.24, 17, 0.5569, 1.0615, 3.4227, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.2.b', 'IM', 1.00, 17, 0.0000, NULL, NULL, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.2.b', 'LV', 0.00, 17, 0.0000, NULL, NULL, 'N', 'Y', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.3.a', 'IM', 3.40, 16, 0.2108, 2.9500, 3.8489, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.3.a', 'LV', 4.22, 17, 0.2747, 3.6368, 4.8014, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.3.b', 'IM', 1.47, 17, 0.1990, 1.0464, 1.8901, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.3.b', 'LV', 1.05, 17, 0.4863, 0.0171, 2.0787, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.3.c', 'IM', 1.63, 17, 0.1943, 1.2142, 2.0379, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.3.c', 'LV', 1.45, 17, 0.4351, 0.5264, 2.3712, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.3.d', 'IM', 1.24, 17, 0.1033, 1.0168, 1.4547, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.3.d', 'LV', 0.41, 17, 0.1996, 0.0000, 0.8315, 'N', 'Y', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.3.e', 'IM', 2.22, 17, 0.3081, 1.5662, 2.8725, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.3.e', 'LV', 2.31, 17, 0.4649, 1.3246, 3.2957, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.a', 'IM', 3.12, 17, 0.2422, 2.6109, 3.6377, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.a', 'LV', 3.71, 17, 0.3287, 3.0114, 4.4049, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.b', 'IM', 1.57, 17, 0.1862, 1.1706, 1.9601, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.b', 'LV', 1.13, 17, 0.3743, 0.3372, 1.9243, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.c', 'IM', 2.77, 17, 0.4210, 1.8788, 3.6636, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.c', 'LV', 3.06, 17, 0.5453, 1.9031, 4.2150, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.d', 'IM', 3.17, 17, 0.4033, 2.3143, 4.0242, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.d', 'LV', 3.73, 17, 0.6518, 2.3446, 5.1080, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.e', 'IM', 3.58, 17, 0.3591, 2.8230, 4.3456, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.e', 'LV', 4.32, 17, 0.2864, 3.7117, 4.9262, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.f', 'IM', 2.92, 17, 0.3238, 2.2377, 3.6107, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.f', 'LV', 3.10, 17, 0.3471, 2.3625, 3.8343, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.g', 'IM', 1.80, 17, 0.3329, 1.0944, 2.5058, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.4.g', 'LV', 1.69, 17, 0.5423, 0.5408, 2.8399, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.5.a', 'IM', 2.29, 17, 0.3370, 1.5754, 3.0042, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.5.a', 'LV', 2.30, 17, 0.4032, 1.4427, 3.1522, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.5.b', 'IM', 2.73, 17, 0.2838, 2.1273, 3.3304, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.5.b', 'LV', 3.29, 17, 0.3695, 2.5019, 4.0683, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.6', 'IM', 3.17, 17, 0.4012, 2.3156, 4.0167, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.6', 'LV', 3.65, 17, 0.6233, 2.3320, 4.9748, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.7.a', 'IM', 4.27, 17, 0.2222, 3.7979, 4.7400, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.7.a', 'LV', 4.32, 17, 0.2224, 3.8519, 4.7947, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.7.b', 'IM', 1.62, 17, 0.1214, 1.3616, 1.8762, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.7.b', 'LV', 1.05, 17, 0.3491, 0.3129, 1.7928, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.7.c', 'IM', 1.17, 17, 0.1044, 1.0000, 1.3928, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.7.c', 'LV', 0.48, 17, 0.3092, 0.0000, 1.1329, 'Y', 'Y', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.7.d', 'IM', 1.23, 17, 0.1015, 1.0176, 1.4477, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.7.d', 'LV', 0.90, 17, 0.4167, 0.0197, 1.7863, 'N', 'Y', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.7.e', 'IM', 2.54, 17, 0.2521, 2.0064, 3.0754, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.7.e', 'LV', 3.49, 17, 0.3662, 2.7109, 4.2636, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.8.a', 'IM', 2.68, 17, 0.4185, 1.7879, 3.5623, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.8.a', 'LV', 2.93, 17, 0.6195, 1.6133, 4.2397, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.8.b', 'IM', 3.06, 17, 0.2777, 2.4729, 3.6503, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.8.b', 'LV', 3.45, 17, 0.2789, 2.8568, 4.0395, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.9.a', 'IM', 2.36, 17, 0.2156, 1.9005, 2.8144, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.9.a', 'LV', 2.17, 17, 0.3488, 1.4258, 2.9045, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.9.b', 'IM', 3.00, 17, 0.1865, 2.6038, 3.3945, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.9.b', 'LV', 2.99, 17, 0.1589, 2.6524, 3.3263, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.10', 'IM', 2.58, 17, 0.2734, 2.0014, 3.1606, 'N', NULL, '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.C.10', 'LV', 2.81, 17, 0.4469, 1.8670, 3.7617, 'N', 'N', '2024-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.1.a', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.1.a', 'LV', 4.35, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.1.b', 'IM', 3.38, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.1.b', 'LV', 4.58, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.1.c', 'IM', 2.65, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.1.c', 'LV', 2.50, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.1.d', 'IM', 3.35, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.1.d', 'LV', 3.88, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.1.e', 'IM', 4.27, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.1.e', 'LV', 4.81, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.1.f', 'IM', 3.31, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.1.f', 'LV', 4.00, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.2.a', 'IM', 2.00, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.2.a', 'LV', 1.54, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.2.b', 'IM', 1.35, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.2.b', 'LV', 0.62, 26, NULL, NULL, NULL, NULL, 'Y', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.3.a', 'IM', 2.96, 24, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.3.a', 'LV', 3.58, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.3.b', 'IM', 1.81, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.3.b', 'LV', 1.23, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.3.c', 'IM', 2.54, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.3.c', 'LV', 2.69, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.3.d', 'IM', 1.80, 25, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.3.d', 'LV', 1.15, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.3.e', 'IM', 1.88, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.3.e', 'LV', 1.42, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.a', 'IM', 2.75, 24, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.a', 'LV', 3.36, 25, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.b', 'IM', 1.65, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.b', 'LV', 1.12, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.c', 'IM', 1.62, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.c', 'LV', 1.23, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.d', 'IM', 2.23, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.d', 'LV', 1.96, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.e', 'IM', 3.16, 25, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.e', 'LV', 3.96, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.f', 'IM', 2.62, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.f', 'LV', 2.77, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.g', 'IM', 1.46, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.4.g', 'LV', 0.77, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.5.a', 'IM', 2.38, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.5.a', 'LV', 1.77, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.5.b', 'IM', 2.73, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.5.b', 'LV', 3.23, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.6', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.6', 'LV', 5.73, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.7.a', 'IM', 3.52, 25, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.7.a', 'LV', 4.23, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.7.b', 'IM', 1.72, 25, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.7.b', 'LV', 1.08, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.7.c', 'IM', 1.54, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.7.c', 'LV', 0.69, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.7.d', 'IM', 1.27, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.7.d', 'LV', 0.35, 26, NULL, NULL, NULL, NULL, 'Y', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.7.e', 'IM', 1.88, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.7.e', 'LV', 2.04, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.8.a', 'IM', 2.96, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.8.a', 'LV', 2.69, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.8.b', 'IM', 1.96, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.8.b', 'LV', 1.58, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.9.a', 'IM', 2.24, 25, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.9.a', 'LV', 1.20, 25, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.9.b', 'IM', 3.04, 25, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.9.b', 'LV', 2.73, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.10', 'IM', 1.58, 26, NULL, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.C.10', 'LV', 0.96, 26, NULL, NULL, NULL, NULL, 'N', '2022-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.1.a', 'IM', 4.18, 21, 0.3352, 3.4822, 4.8805, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.1.a', 'LV', 4.18, 20, 0.2978, 3.5596, 4.8063, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.1.b', 'IM', 4.38, 21, 0.3152, 3.7176, 5.0000, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.1.b', 'LV', 4.97, 20, 0.5025, 3.9222, 6.0259, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.1.c', 'IM', 3.22, 21, 0.2350, 2.7329, 3.7133, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.1.c', 'LV', 3.45, 21, 0.6803, 2.0340, 4.8722, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.1.d', 'IM', 3.43, 21, 0.6099, 2.1608, 4.7054, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.1.d', 'LV', 3.90, 21, 0.8223, 2.1886, 5.6193, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.1.e', 'IM', 4.29, 21, 0.3379, 3.5872, 4.9969, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.1.e', 'LV', 5.22, 20, 0.4461, 4.2889, 6.1563, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.1.f', 'IM', 3.56, 21, 0.2260, 3.0889, 4.0317, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.1.f', 'LV', 4.37, 21, 0.1613, 4.0308, 4.7035, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.2.a', 'IM', 1.83, 21, 0.3228, 1.1543, 2.5010, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.2.a', 'LV', 1.38, 21, 0.5337, 0.2679, 2.4943, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.2.b', 'IM', 1.08, 21, 0.0725, 1.0000, 1.2303, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.2.b', 'LV', 0.24, 21, 0.2176, 0.0000, 0.6910, 'Y', 'Y', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.3.a', 'IM', 2.57, 21, 0.4118, 1.7089, 3.4271, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.3.a', 'LV', 3.17, 20, 0.6817, 1.7402, 4.5939, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.3.b', 'IM', 1.37, 21, 0.1933, 1.0000, 1.7773, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.3.b', 'LV', 0.81, 21, 0.4312, 0.0000, 1.7139, 'Y', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.3.c', 'IM', 1.46, 20, 0.1751, 1.0928, 1.8258, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.3.c', 'LV', 0.92, 20, 0.4669, 0.0000, 1.9002, 'Y', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.3.d', 'IM', 1.01, 21, 0.0067, 1.0000, 1.0226, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.3.d', 'LV', 0.01, 21, 0.0111, 0.0000, 0.0365, 'Y', 'Y', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.3.e', 'IM', 1.67, 21, 0.2081, 1.2348, 2.1031, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.3.e', 'LV', 1.39, 20, 0.5135, 0.3169, 2.4665, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.a', 'IM', 3.38, 21, 0.2352, 2.8867, 3.8678, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.a', 'LV', 4.08, 21, 0.2013, 3.6611, 4.5011, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.b', 'IM', 1.04, 21, 0.0263, 1.0000, 1.0935, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.b', 'LV', 0.04, 21, 0.0277, 0.0000, 0.1005, 'Y', 'Y', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.c', 'IM', 1.68, 20, 0.3193, 1.0097, 2.3464, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.c', 'LV', 1.43, 20, 0.6350, 0.0998, 2.7580, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.d', 'IM', 1.57, 21, 0.3162, 1.0000, 2.2343, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.d', 'LV', 1.01, 21, 0.4751, 0.0143, 1.9965, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.e', 'IM', 2.84, 21, 0.4508, 1.8984, 3.7789, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.e', 'LV', 2.91, 20, 0.4898, 1.8874, 3.9376, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.f', 'IM', 1.68, 21, 0.3093, 1.0386, 2.3289, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.f', 'LV', 1.17, 21, 0.4857, 0.1538, 2.1803, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.g', 'IM', 1.45, 21, 0.3314, 1.0000, 2.1426, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.4.g', 'LV', 0.88, 21, 0.6639, 0.0000, 2.2674, 'Y', 'Y', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.5.a', 'IM', 2.20, 20, 0.6720, 1.0000, 3.6054, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.5.a', 'LV', 1.35, 20, 0.6799, 0.0000, 2.7769, 'Y', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.5.b', 'IM', 2.55, 20, 0.1665, 2.2007, 2.8975, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.5.b', 'LV', 2.61, 20, 0.2130, 2.1633, 3.0547, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.6', 'IM', 3.67, 20, 0.2280, 3.1895, 4.1438, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.6', 'LV', 4.73, 18, 0.2562, 4.1849, 5.2660, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.7.a', 'IM', 3.92, 20, 0.3059, 3.2809, 4.5615, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.7.a', 'LV', 3.80, 19, 0.2612, 3.2478, 4.3455, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.7.b', 'IM', 1.35, 21, 0.1629, 1.0073, 1.6869, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.7.b', 'LV', 0.81, 21, 0.4791, 0.0000, 1.8088, 'Y', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.7.c', 'IM', 1.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.7.c', 'LV', 0.00, 21, 0.0000, NULL, NULL, 'N', 'Y', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.7.d', 'IM', 1.00, 21, 0.0041, 1.0000, 1.0124, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.7.d', 'LV', 0.01, 21, 0.0081, 0.0000, 0.0248, 'Y', 'Y', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.7.e', 'IM', 1.28, 21, 0.2928, 1.0000, 1.8906, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.7.e', 'LV', 0.59, 21, 0.5920, 0.0000, 1.8293, 'Y', 'Y', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.8.a', 'IM', 1.85, 21, 0.3775, 1.0639, 2.6390, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.8.a', 'LV', 1.23, 20, 0.5663, 0.0409, 2.4116, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.8.b', 'IM', 1.73, 21, 0.3170, 1.0696, 2.3923, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.8.b', 'LV', 1.19, 21, 0.4753, 0.1977, 2.1808, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.9.a', 'IM', 2.38, 21, 0.1629, 2.0426, 2.7223, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.9.a', 'LV', 1.61, 21, 0.5937, 0.3741, 2.8510, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.9.b', 'IM', 2.80, 21, 0.2852, 2.2075, 3.3974, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.9.b', 'LV', 3.03, 21, 0.2211, 2.5712, 3.4937, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.10', 'IM', 1.36, 21, 0.1604, 1.0275, 1.6968, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.C.10', 'LV', 0.95, 21, 0.4713, 0.0000, 1.9350, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.a', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.a', 'LV', 4.65, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.b', 'IM', 3.04, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.b', 'LV', 3.91, 22, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.c', 'IM', 1.82, 22, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.c', 'LV', 1.36, 22, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.d', 'IM', 2.04, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.d', 'LV', 2.35, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.e', 'IM', 2.26, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.e', 'LV', 2.43, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.f', 'IM', 2.48, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.f', 'LV', 3.30, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.2.a', 'IM', 2.65, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.2.a', 'LV', 2.96, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.2.b', 'IM', 1.39, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.2.b', 'LV', 0.87, 23, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.a', 'IM', 2.91, 22, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.a', 'LV', 3.61, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.b', 'IM', 2.55, 22, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.b', 'LV', 2.91, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.c', 'IM', 2.55, 22, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.c', 'LV', 2.87, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.d', 'IM', 1.57, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.d', 'LV', 1.13, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.e', 'IM', 1.96, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.e', 'LV', 1.91, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.a', 'IM', 2.74, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.a', 'LV', 3.35, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.b', 'IM', 2.09, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.b', 'LV', 2.00, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.c', 'IM', 3.04, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.c', 'LV', 3.74, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.d', 'IM', 3.39, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.d', 'LV', 4.00, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.e', 'IM', 1.91, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.e', 'LV', 2.13, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.f', 'IM', 1.70, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.f', 'LV', 1.83, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.g', 'IM', 1.52, 21, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.g', 'LV', 1.70, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.5.a', 'IM', 2.77, 22, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.5.a', 'LV', 2.65, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.5.b', 'IM', 1.48, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.5.b', 'LV', 1.00, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.6', 'IM', 3.09, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.6', 'LV', 4.57, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.a', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.a', 'LV', 4.83, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.b', 'IM', 1.96, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.b', 'LV', 2.00, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.c', 'IM', 1.09, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.c', 'LV', 0.35, 23, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.d', 'IM', 1.17, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.d', 'LV', 0.48, 23, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.e', 'IM', 1.26, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.7.e', 'LV', 0.65, 23, NULL, NULL, NULL, NULL, 'Y', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.8.a', 'IM', 2.26, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.8.a', 'LV', 1.74, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.8.b', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.8.b', 'LV', 4.09, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.9.a', 'IM', 1.78, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.9.a', 'LV', 1.04, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.9.b', 'IM', 2.09, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.9.b', 'LV', 2.13, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.10', 'IM', 1.43, 23, NULL, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.10', 'LV', 0.91, 23, NULL, NULL, NULL, NULL, 'N', '2024-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.1.a', 'IM', 4.06, 24, 0.2356, 3.5689, 4.5435, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.1.a', 'LV', 4.49, 24, 0.1575, 4.1651, 4.8167, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.1.b', 'IM', 3.36, 24, 0.2780, 2.7881, 3.9384, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.1.b', 'LV', 4.98, 23, 0.4180, 4.1121, 5.8460, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.1.c', 'IM', 2.64, 24, 0.2833, 2.0512, 3.2231, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.1.c', 'LV', 2.97, 23, 0.5855, 1.7595, 4.1879, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.1.d', 'IM', 1.96, 24, 0.3011, 1.3363, 2.5822, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.1.d', 'LV', 1.99, 24, 0.6096, 0.7263, 3.2483, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.1.e', 'IM', 3.72, 24, 0.2480, 3.2110, 4.2370, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.1.e', 'LV', 5.22, 23, 0.4020, 4.3859, 6.0534, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.1.f', 'IM', 3.68, 24, 0.2481, 3.1619, 4.1882, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.1.f', 'LV', 4.35, 23, 0.4337, 3.4551, 5.2541, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.2.a', 'IM', 2.18, 24, 0.2536, 1.6544, 2.7036, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.2.a', 'LV', 2.11, 23, 0.5850, 0.8921, 3.3187, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.2.b', 'IM', 1.25, 24, 0.2112, 1.0000, 1.6879, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.2.b', 'LV', 0.42, 24, 0.3522, 0.0000, 1.1476, 'Y', 'Y', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.3.a', 'IM', 3.60, 24, 0.2209, 3.1429, 4.0568, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.3.a', 'LV', 4.16, 23, 0.2914, 3.5583, 4.7668, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.3.b', 'IM', 1.98, 24, 0.2994, 1.3610, 2.5998, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.3.b', 'LV', 1.80, 24, 0.5347, 0.6940, 2.9062, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.3.c', 'IM', 1.80, 24, 0.2963, 1.1912, 2.4170, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.3.c', 'LV', 1.36, 24, 0.4784, 0.3702, 2.3493, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.3.d', 'IM', 1.67, 24, 0.2687, 1.1113, 2.2231, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.3.d', 'LV', 1.08, 24, 0.4287, 0.1963, 1.9698, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.3.e', 'IM', 1.69, 24, 0.2657, 1.1426, 2.2421, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.3.e', 'LV', 1.30, 24, 0.5228, 0.2211, 2.3840, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.a', 'IM', 2.95, 23, 0.1597, 2.6157, 3.2781, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.a', 'LV', 3.73, 23, 0.3379, 3.0263, 4.4279, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.b', 'IM', 1.61, 24, 0.2359, 1.1266, 2.1026, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.b', 'LV', 0.92, 24, 0.3659, 0.1665, 1.6804, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.c', 'IM', 1.61, 24, 0.2842, 1.0258, 2.2017, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.c', 'LV', 1.03, 24, 0.4691, 0.0574, 1.9982, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.d', 'IM', 1.53, 24, 0.2013, 1.1096, 1.9426, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.d', 'LV', 1.17, 24, 0.4957, 0.1493, 2.2002, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.e', 'IM', 2.49, 24, 0.3302, 1.8052, 3.1715, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.e', 'LV', 2.94, 24, 0.6435, 1.6071, 4.2695, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.f', 'IM', 2.11, 24, 0.3147, 1.4593, 2.7615, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.f', 'LV', 1.94, 23, 0.5928, 0.7136, 3.1726, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.g', 'IM', 2.09, 24, 0.3248, 1.4166, 2.7602, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.4.g', 'LV', 1.98, 23, 0.5126, 0.9164, 3.0425, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.5.a', 'IM', 1.70, 24, 0.2145, 1.2584, 2.1458, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.5.a', 'LV', 1.24, 23, 0.4082, 0.3927, 2.0859, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.5.b', 'IM', 2.45, 23, 0.4038, 1.6166, 3.2913, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.5.b', 'LV', 2.27, 22, 0.6440, 0.9275, 3.6060, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.6', 'IM', 3.44, 24, 0.3880, 2.6376, 4.2430, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.6', 'LV', 4.81, 23, 0.7728, 3.2061, 6.4113, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.7.a', 'IM', 4.53, 24, 0.1731, 4.1693, 4.8856, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.7.a', 'LV', 5.32, 23, 0.2657, 4.7727, 5.8748, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.7.b', 'IM', 1.63, 24, 0.1571, 1.3086, 1.9585, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.7.b', 'LV', 0.76, 24, 0.1836, 0.3838, 1.1434, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.7.c', 'IM', 1.08, 24, 0.0465, 1.0000, 1.1716, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.7.c', 'LV', 0.08, 24, 0.0467, 0.0000, 0.1739, 'Y', 'Y', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.7.d', 'IM', 1.69, 24, 0.3228, 1.0207, 2.3561, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.7.d', 'LV', 1.09, 24, 0.4716, 0.1109, 2.0619, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.7.e', 'IM', 1.97, 24, 0.3225, 1.3011, 2.6353, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.7.e', 'LV', 1.69, 24, 0.4716, 0.7124, 2.6637, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.8.a', 'IM', 3.30, 24, 0.4040, 2.4604, 4.1319, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.8.a', 'LV', 3.64, 23, 0.6637, 2.2597, 5.0123, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.8.b', 'IM', 4.56, 23, 0.1684, 4.2104, 4.9090, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.8.b', 'LV', 4.95, 22, 0.2111, 4.5123, 5.3904, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.9.a', 'IM', 2.53, 24, 0.3203, 1.8703, 3.1956, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.9.a', 'LV', 2.00, 23, 0.5159, 0.9313, 3.0712, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.9.b', 'IM', 2.91, 24, 0.3290, 2.2342, 3.5956, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.9.b', 'LV', 2.81, 23, 0.3458, 2.0886, 3.5227, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.10', 'IM', 2.17, 24, 0.3590, 1.4296, 2.9147, 'N', NULL, '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.C.10', 'LV', 2.21, 23, 0.6352, 0.8977, 3.5322, 'N', 'N', '2019-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.1.a', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.1.a', 'LV', 4.71, 21, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.1.b', 'IM', 3.09, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.1.b', 'LV', 4.00, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.1.c', 'IM', 2.73, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.1.c', 'LV', 2.82, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.1.d', 'IM', 2.00, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.1.d', 'LV', 2.41, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.1.e', 'IM', 3.55, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.1.e', 'LV', 4.52, 21, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.1.f', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.1.f', 'LV', 4.18, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.2.a', 'IM', 2.14, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.2.a', 'LV', 1.95, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.2.b', 'IM', 1.77, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.2.b', 'LV', 1.32, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.3.a', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.3.a', 'LV', 4.00, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.3.b', 'IM', 2.32, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.3.b', 'LV', 2.50, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.3.c', 'IM', 2.27, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.3.c', 'LV', 2.68, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.3.d', 'IM', 2.55, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.3.d', 'LV', 2.77, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.3.e', 'IM', 2.23, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.3.e', 'LV', 2.18, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.a', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.a', 'LV', 4.14, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.b', 'IM', 1.76, 21, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.b', 'LV', 1.48, 21, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.c', 'IM', 1.45, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.c', 'LV', 1.00, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.d', 'IM', 1.32, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.d', 'LV', 0.68, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.e', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.e', 'LV', 4.32, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.f', 'IM', 2.64, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.f', 'LV', 2.82, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.g', 'IM', 2.00, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.4.g', 'LV', 2.00, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.5.a', 'IM', 1.59, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.5.a', 'LV', 1.18, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.5.b', 'IM', 2.18, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.5.b', 'LV', 2.18, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.6', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.6', 'LV', 5.09, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.7.a', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.7.a', 'LV', 4.41, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.7.b', 'IM', 1.76, 21, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.7.b', 'LV', 1.73, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.7.c', 'IM', 1.09, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.7.c', 'LV', 0.18, 22, NULL, NULL, NULL, NULL, 'Y', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.7.d', 'IM', 1.32, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.7.d', 'LV', 0.50, 22, NULL, NULL, NULL, NULL, 'Y', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.7.e', 'IM', 1.45, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.7.e', 'LV', 1.36, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.8.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.8.a', 'LV', 4.64, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.8.b', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.8.b', 'LV', 4.05, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.9.a', 'IM', 2.55, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.9.a', 'LV', 2.50, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.9.b', 'IM', 2.91, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.9.b', 'LV', 2.82, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.10', 'IM', 2.41, 22, NULL, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.C.10', 'LV', 2.18, 22, NULL, NULL, NULL, NULL, 'N', '2019-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.1.a', 'IM', 4.09, 20, 0.0834, 3.9177, 4.2666, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.1.a', 'LV', 5.05, 19, 0.2787, 4.4659, 5.6368, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.1.b', 'IM', 3.32, 20, 0.2459, 2.8023, 3.8319, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.1.b', 'LV', 4.30, 20, 0.2330, 3.8139, 4.7893, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.1.c', 'IM', 2.98, 20, 0.1987, 2.5634, 3.3951, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.1.c', 'LV', 3.37, 19, 0.2008, 2.9510, 3.7948, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.1.d', 'IM', 1.60, 20, 0.1703, 1.2396, 1.9525, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.1.d', 'LV', 1.84, 20, 0.5602, 0.6685, 3.0136, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.1.e', 'IM', 3.22, 20, 0.2856, 2.6218, 3.8173, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.1.e', 'LV', 3.67, 20, 0.3479, 2.9369, 4.3932, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.1.f', 'IM', 3.48, 20, 0.1837, 3.0996, 3.8687, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.1.f', 'LV', 4.09, 20, 0.1648, 3.7471, 4.4372, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.2.a', 'IM', 3.10, 20, 0.3334, 2.3977, 3.7931, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.2.a', 'LV', 3.40, 20, 0.5258, 2.3015, 4.5025, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.2.b', 'IM', 1.00, 20, 0.0000, NULL, NULL, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.2.b', 'LV', 0.00, 20, 0.0000, NULL, NULL, 'N', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.3.a', 'IM', 3.22, 20, 0.4408, 2.2953, 4.1406, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.3.a', 'LV', 3.80, 20, 0.6825, 2.3731, 5.2299, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.3.b', 'IM', 3.63, 20, 0.2588, 3.0930, 4.1765, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.3.b', 'LV', 4.81, 20, 0.3259, 4.1300, 5.4942, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.3.c', 'IM', 2.74, 20, 0.4365, 1.8219, 3.6491, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.3.c', 'LV', 3.48, 20, 0.7999, 1.8107, 5.1590, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.3.d', 'IM', 2.42, 20, 0.3961, 1.5936, 3.2519, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.3.d', 'LV', 3.07, 20, 0.8169, 1.3627, 4.7825, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.3.e', 'IM', 3.92, 20, 0.1656, 3.5700, 4.2634, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.3.e', 'LV', 5.00, 20, 0.4280, 4.1088, 5.9004, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.a', 'IM', 3.18, 20, 0.3232, 2.4987, 3.8514, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.a', 'LV', 4.08, 20, 0.3143, 3.4201, 4.7359, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.b', 'IM', 2.93, 20, 0.3131, 2.2780, 3.5886, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.b', 'LV', 3.90, 20, 0.3105, 3.2510, 4.5508, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.c', 'IM', 1.81, 20, 0.2038, 1.3884, 2.2415, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.c', 'LV', 2.24, 20, 0.5580, 1.0752, 3.4111, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.d', 'IM', 1.63, 20, 0.2834, 1.0354, 2.2219, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.d', 'LV', 1.51, 20, 0.7051, 0.0353, 2.9869, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.e', 'IM', 2.55, 20, 0.4387, 1.6359, 3.4722, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.e', 'LV', 2.72, 20, 0.6067, 1.4537, 3.9933, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.f', 'IM', 1.57, 20, 0.1996, 1.1550, 1.9907, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.f', 'LV', 1.09, 20, 0.3723, 0.3090, 1.8676, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.g', 'IM', 2.01, 20, 0.2861, 1.4131, 2.6107, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.4.g', 'LV', 2.18, 20, 0.5758, 0.9770, 3.3871, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.5.a', 'IM', 2.00, 20, 0.3753, 1.2097, 2.7807, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.5.a', 'LV', 1.60, 20, 0.4958, 0.5597, 2.6352, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.5.b', 'IM', 2.11, 19, 0.3166, 1.4459, 2.7761, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.5.b', 'LV', 2.07, 19, 0.5607, 0.8953, 3.2513, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.6', 'IM', 2.82, 20, 0.3847, 2.0139, 3.6244, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.6', 'LV', 3.77, 20, 0.7673, 2.1684, 5.3802, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.7.a', 'IM', 2.98, 19, 0.4587, 2.0149, 3.9421, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.7.a', 'LV', 3.36, 20, 0.7147, 1.8650, 4.8568, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.7.b', 'IM', 1.38, 20, 0.2245, 1.0000, 1.8470, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.7.b', 'LV', 0.63, 20, 0.3466, 0.0000, 1.3565, 'Y', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.7.c', 'IM', 1.00, 20, 0.0000, NULL, NULL, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.7.c', 'LV', 0.00, 20, 0.0000, NULL, NULL, 'N', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.7.d', 'IM', 1.60, 20, 0.2737, 1.0268, 2.1727, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.7.d', 'LV', 1.15, 20, 0.4346, 0.2411, 2.0605, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.7.e', 'IM', 1.25, 20, 0.1307, 1.0000, 1.5189, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.7.e', 'LV', 0.55, 20, 0.2750, 0.0000, 1.1207, 'Y', 'Y', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.8.a', 'IM', 3.50, 20, 0.3184, 2.8355, 4.1684, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.8.a', 'LV', 4.41, 20, 0.1690, 4.0530, 4.7606, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.8.b', 'IM', 2.73, 20, 0.2410, 2.2216, 3.2304, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.8.b', 'LV', 3.41, 20, 0.3382, 2.7054, 4.1210, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.9.a', 'IM', 3.03, 20, 0.3273, 2.3485, 3.7185, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.9.a', 'LV', 3.76, 20, 0.3474, 3.0348, 4.4891, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.9.b', 'IM', 2.27, 20, 0.2885, 1.6649, 2.8724, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.9.b', 'LV', 2.21, 20, 0.4491, 1.2696, 3.1494, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.10', 'IM', 2.30, 20, 0.1540, 1.9786, 2.6232, 'N', NULL, '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.09', '2.C.10', 'LV', 3.03, 20, 0.2791, 2.4444, 3.6130, 'N', 'N', '2021-08-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.1.a', 'IM', 4.10, 16, 0.2167, 3.6377, 4.5613, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.1.a', 'LV', 4.74, 16, 0.2366, 4.2399, 5.2485, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.1.b', 'IM', 2.96, 16, 0.1826, 2.5737, 3.3522, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.1.b', 'LV', 3.72, 15, 0.3699, 2.9297, 4.5163, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.1.c', 'IM', 3.39, 16, 0.3038, 2.7434, 4.0384, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.1.c', 'LV', 3.85, 16, 0.2793, 3.2573, 4.4479, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.1.d', 'IM', 2.59, 16, 0.3548, 1.8383, 3.3507, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.1.d', 'LV', 2.99, 16, 0.5190, 1.8796, 4.0922, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.1.e', 'IM', 3.34, 15, 0.2927, 2.7148, 3.9705, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.1.e', 'LV', 4.25, 16, 0.4603, 3.2719, 5.2340, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.1.f', 'IM', 2.52, 16, 0.2085, 2.0757, 2.9647, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.1.f', 'LV', 3.01, 15, 0.3490, 2.2579, 3.7550, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.2.a', 'IM', 2.67, 16, 0.3466, 1.9323, 3.4097, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.2.a', 'LV', 2.85, 15, 0.6893, 1.3765, 4.3331, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.2.b', 'IM', 1.22, 15, 0.1393, 1.0000, 1.5192, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.2.b', 'LV', 0.66, 15, 0.4180, 0.0000, 1.5575, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.3.a', 'IM', 3.04, 15, 0.3173, 2.3561, 3.7173, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.3.a', 'LV', 3.70, 15, 0.5737, 2.4668, 4.9278, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.3.b', 'IM', 3.67, 15, 0.3542, 2.9092, 4.4286, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.3.b', 'LV', 4.57, 14, 0.5792, 3.3169, 5.8192, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.3.c', 'IM', 3.33, 15, 0.2700, 2.7461, 3.9041, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.3.c', 'LV', 4.39, 15, 0.4494, 3.4215, 5.3492, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.3.d', 'IM', 3.77, 15, 0.3591, 2.9950, 4.5353, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.3.d', 'LV', 4.60, 15, 0.4883, 3.5545, 5.6490, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.3.e', 'IM', 3.00, 16, 0.3024, 2.3600, 3.6492, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.3.e', 'LV', 3.62, 15, 0.4313, 2.6900, 4.5400, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.a', 'IM', 3.32, 16, 0.1255, 3.0500, 3.5850, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.a', 'LV', 4.10, 16, 0.1936, 3.6922, 4.5174, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.b', 'IM', 2.50, 15, 0.2793, 1.9004, 3.0986, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.b', 'LV', 2.96, 16, 0.4338, 2.0361, 3.8854, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.c', 'IM', 1.71, 16, 0.1958, 1.2963, 2.1309, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.c', 'LV', 1.92, 16, 0.5218, 0.8065, 3.0310, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.d', 'IM', 1.68, 16, 0.2295, 1.1870, 2.1653, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.d', 'LV', 1.40, 16, 0.4378, 0.4718, 2.3382, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.e', 'IM', 2.03, 15, 0.2433, 1.5059, 2.5497, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.e', 'LV', 1.98, 15, 0.3443, 1.2397, 2.7167, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.f', 'IM', 1.96, 16, 0.3023, 1.3121, 2.6008, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.f', 'LV', 1.57, 16, 0.4485, 0.6144, 2.5264, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.g', 'IM', 2.95, 16, 0.2454, 2.4308, 3.4768, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.4.g', 'LV', 3.95, 15, 0.4310, 3.0285, 4.8775, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.5.a', 'IM', 1.30, 16, 0.2667, 1.0000, 1.8676, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.5.a', 'LV', 0.60, 16, 0.5334, 0.0000, 1.7351, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.5.b', 'IM', 1.24, 16, 0.1364, 1.0000, 1.5277, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.5.b', 'LV', 0.74, 16, 0.4087, 0.0000, 1.6083, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.6', 'IM', 2.64, 16, 0.2532, 2.0987, 3.1781, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.6', 'LV', 3.29, 15, 0.4330, 2.3646, 4.2220, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.7.a', 'IM', 3.82, 16, 0.3153, 3.1435, 4.4876, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.7.a', 'LV', 4.22, 15, 0.3304, 3.5108, 4.9279, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.7.b', 'IM', 1.66, 16, 0.1804, 1.2758, 2.0449, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.7.b', 'LV', 1.31, 15, 0.4278, 0.3889, 2.2241, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.7.c', 'IM', 1.21, 16, 0.1404, 1.0000, 1.5102, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.7.c', 'LV', 0.36, 16, 0.2668, 0.0000, 0.9292, 'Y', 'Y', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.7.d', 'IM', 1.80, 16, 0.1656, 1.4432, 2.1493, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.7.d', 'LV', 1.86, 16, 0.3576, 1.1022, 2.6268, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.7.e', 'IM', 1.48, 16, 0.1297, 1.2046, 1.7576, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.7.e', 'LV', 1.31, 16, 0.4584, 0.3379, 2.2920, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.8.a', 'IM', 2.94, 16, 0.2512, 2.4014, 3.4723, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.8.a', 'LV', 3.20, 16, 0.2751, 2.6096, 3.7821, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.8.b', 'IM', 2.85, 16, 0.2183, 2.3880, 3.3187, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.8.b', 'LV', 3.66, 15, 0.3506, 2.9100, 4.4141, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.9.a', 'IM', 2.17, 16, 0.1827, 1.7799, 2.5587, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.9.a', 'LV', 2.60, 16, 0.3865, 1.7805, 3.4281, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.9.b', 'IM', 2.89, 16, 0.2728, 2.3101, 3.4730, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.9.b', 'LV', 3.00, 15, 0.3565, 2.2391, 3.7684, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.10', 'IM', 2.64, 16, 0.2353, 2.1371, 3.1402, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.10', '2.C.10', 'LV', 3.16, 15, 0.3454, 2.4170, 3.8985, 'N', 'N', '2016-07-01', 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.1.a', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.1.a', 'LV', 4.36, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.1.b', 'IM', 2.77, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.1.b', 'LV', 3.95, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.1.c', 'IM', 2.57, 21, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.1.c', 'LV', 2.62, 21, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.1.d', 'IM', 2.45, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.1.d', 'LV', 3.41, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.1.e', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.1.e', 'LV', 5.27, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.1.f', 'IM', 2.14, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.1.f', 'LV', 2.45, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.2.a', 'IM', 1.59, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.2.a', 'LV', 1.23, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.2.b', 'IM', 1.18, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.2.b', 'LV', 0.41, 22, NULL, NULL, NULL, NULL, 'Y', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.3.a', 'IM', 2.86, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.3.a', 'LV', 3.86, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.3.b', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.3.b', 'LV', 4.32, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.3.c', 'IM', 2.64, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.3.c', 'LV', 3.18, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.3.d', 'IM', 2.32, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.3.d', 'LV', 2.71, 21, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.3.e', 'IM', 1.86, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.3.e', 'LV', 2.00, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.a', 'IM', 3.48, 21, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.a', 'LV', 4.33, 21, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.b', 'IM', 2.45, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.b', 'LV', 2.77, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.c', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.c', 'LV', 4.32, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.d', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.d', 'LV', 4.36, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.e', 'IM', 1.73, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.e', 'LV', 1.55, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.f', 'IM', 2.05, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.f', 'LV', 2.45, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.g', 'IM', 2.91, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.4.g', 'LV', 4.05, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.5.a', 'IM', 1.27, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.5.a', 'LV', 0.55, 22, NULL, NULL, NULL, NULL, 'Y', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.5.b', 'IM', 1.14, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.5.b', 'LV', 0.36, 22, NULL, NULL, NULL, NULL, 'Y', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.6', 'IM', 2.14, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.6', 'LV', 2.45, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.7.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.7.a', 'LV', 4.64, 22, NULL, NULL, NULL, NULL, 'N', '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.11', '2.C.7.b', 'IM', 1.27, 22, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-919