CREATE TABLE work_context_categories (
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  category DECIMAL(3,0) NOT NULL,
  category_description CHARACTER VARYING(1000) NOT NULL,
  PRIMARY KEY (element_id, scale_id, category),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));
GO

INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.c', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.c', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.c', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.c', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.c', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.f', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.f', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.f', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.f', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.f', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.h', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.h', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.h', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.h', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.h', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.j', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.j', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.j', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.j', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.j', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.l', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.l', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.l', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.l', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.2.l', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.4', 'CXP', 1, 'No contact with others');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.4', 'CXP', 2, 'Occasional contact with others');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.4', 'CXP', 3, 'Contact with others about half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.4', 'CXP', 4, 'Contact with others most of the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.a.4', 'CXP', 5, 'Constant contact with others');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.e', 'CXP', 1, 'Not important at all');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.e', 'CXP', 2, 'Fairly important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.e', 'CXP', 3, 'Important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.e', 'CXP', 4, 'Very important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.e', 'CXP', 5, 'Extremely important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.f', 'CXP', 1, 'Not important at all');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.f', 'CXP', 2, 'Fairly important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.f', 'CXP', 3, 'Important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.f', 'CXP', 4, 'Very important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.f', 'CXP', 5, 'Extremely important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.g', 'CXP', 1, 'Not important at all');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.g', 'CXP', 2, 'Fairly important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.g', 'CXP', 3, 'Important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.g', 'CXP', 4, 'Very important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.b.1.g', 'CXP', 5, 'Extremely important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.c.1', 'CXP', 1, 'No responsibility');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.c.1', 'CXP', 2, 'Limited responsibility');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.c.1', 'CXP', 3, 'Moderate responsibility');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.c.1', 'CXP', 4, 'High responsibility');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.c.1', 'CXP', 5, 'Very high responsibility');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.c.2', 'CXP', 1, 'No responsibility');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.c.2', 'CXP', 2, 'Limited responsibility');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.c.2', 'CXP', 3, 'Moderate responsibility');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.c.2', 'CXP', 4, 'High responsibility');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.c.2', 'CXP', 5, 'Very high responsibility');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.1', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.1', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.1', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.1', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.1', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.2', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.2', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.2', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.2', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.2', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.3', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.3', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.3', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.3', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.1.d.3', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.a', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.a', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.a', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.a', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.a', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.b', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.b', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.b', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.b', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.b', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.c', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.c', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.c', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.c', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.c', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.d', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.d', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.d', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.d', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.d', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.e', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.e', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.e', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.e', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.e', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.f', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.f', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.f', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.f', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.1.f', 'CXP', 5, 'Every day');
GO
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.3', 'CXP', 1, 'I don''t work near other people (beyond 100 ft.)');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.3', 'CXP', 2, 'I work with others but not closely (e.g., private office)');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.3', 'CXP', 3, 'Slightly close (e.g., shared office)');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.3', 'CXP', 4, 'Moderately close (at arm''s length)');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.a.3', 'CXP', 5, 'Very close (near touching)');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.a', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.a', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.a', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.a', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.a', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.b', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.b', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.b', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.b', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.b', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.c', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.c', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.c', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.c', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.c', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.d', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.d', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.d', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.d', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.d', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.e', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.e', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.e', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.e', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.e', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.f', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.f', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.f', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.f', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.b.1.f', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.a', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.a', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.a', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.a', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.a', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.b', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.b', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.b', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.b', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.b', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.c', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.c', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.c', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.c', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.c', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.d', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.d', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.d', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.d', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.d', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.e', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.e', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.e', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.e', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.e', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.f', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.f', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.f', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.f', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.c.1.f', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.a', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.a', 'CXP', 2, 'Less than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.a', 'CXP', 3, 'About half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.a', 'CXP', 4, 'More than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.a', 'CXP', 5, 'Continually or almost continually');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.b', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.b', 'CXP', 2, 'Less than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.b', 'CXP', 3, 'About half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.b', 'CXP', 4, 'More than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.b', 'CXP', 5, 'Continually or almost continually');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.c', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.c', 'CXP', 2, 'Less than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.c', 'CXP', 3, 'About half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.c', 'CXP', 4, 'More than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.c', 'CXP', 5, 'Continually or almost continually');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.d', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.d', 'CXP', 2, 'Less than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.d', 'CXP', 3, 'About half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.d', 'CXP', 4, 'More than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.d', 'CXP', 5, 'Continually or almost continually');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.e', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.e', 'CXP', 2, 'Less than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.e', 'CXP', 3, 'About half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.e', 'CXP', 4, 'More than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.e', 'CXP', 5, 'Continually or almost continually');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.f', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.f', 'CXP', 2, 'Less than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.f', 'CXP', 3, 'About half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.f', 'CXP', 4, 'More than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.f', 'CXP', 5, 'Continually or almost continually');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.g', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.g', 'CXP', 2, 'Less than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.g', 'CXP', 3, 'About half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.g', 'CXP', 4, 'More than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.g', 'CXP', 5, 'Continually or almost continually');
GO
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.h', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.h', 'CXP', 2, 'Less than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.h', 'CXP', 3, 'About half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.h', 'CXP', 4, 'More than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.h', 'CXP', 5, 'Continually or almost continually');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.i', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.i', 'CXP', 2, 'Less than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.i', 'CXP', 3, 'About half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.i', 'CXP', 4, 'More than half the time');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.d.1.i', 'CXP', 5, 'Continually or almost continually');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.e.1.d', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.e.1.d', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.e.1.d', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.e.1.d', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.e.1.d', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.e.1.e', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.e.1.e', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.e.1.e', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.e.1.e', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.2.e.1.e', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.1', 'CXP', 1, 'Not serious at all');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.1', 'CXP', 2, 'Fairly serious');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.1', 'CXP', 3, 'Serious');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.1', 'CXP', 4, 'Very serious');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.1', 'CXP', 5, 'Extremely serious');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.2.a', 'CXP', 1, 'No results');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.2.a', 'CXP', 2, 'Minor results');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.2.a', 'CXP', 3, 'Moderate results');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.2.a', 'CXP', 4, 'Important results');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.2.a', 'CXP', 5, 'Very important results');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.2.b', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.2.b', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.2.b', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.2.b', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.2.b', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.4', 'CXP', 1, 'No freedom');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.4', 'CXP', 2, 'Very little freedom');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.4', 'CXP', 3, 'Limited freedom');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.4', 'CXP', 4, 'Some freedom');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.a.4', 'CXP', 5, 'A lot of freedom');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.2', 'CXP', 1, 'Not at all automated');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.2', 'CXP', 2, 'Slightly automated');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.2', 'CXP', 3, 'Moderately automated');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.2', 'CXP', 4, 'Highly automated');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.2', 'CXP', 5, 'Completely automated');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.4', 'CXP', 1, 'Not important at all');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.4', 'CXP', 2, 'Fairly important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.4', 'CXP', 3, 'Important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.4', 'CXP', 4, 'Very important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.4', 'CXP', 5, 'Extremely important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.7', 'CXP', 1, 'Not important at all');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.7', 'CXP', 2, 'Fairly important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.7', 'CXP', 3, 'Important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.7', 'CXP', 4, 'Very important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.7', 'CXP', 5, 'Extremely important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.8', 'CXP', 1, 'No freedom');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.8', 'CXP', 2, 'Very little freedom');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.8', 'CXP', 3, 'Limited freedom');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.8', 'CXP', 4, 'Some freedom');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.b.8', 'CXP', 5, 'A lot of freedom');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.c.1', 'CXP', 1, 'Not at all competitive');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.c.1', 'CXP', 2, 'Slightly competitive');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.c.1', 'CXP', 3, 'Moderately competitive');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.c.1', 'CXP', 4, 'Highly competitive');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.c.1', 'CXP', 5, 'Extremely competitive');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.1', 'CXP', 1, 'Never');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.1', 'CXP', 2, 'Once a year or more but not every month');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.1', 'CXP', 3, 'Once a month or more but not every week');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.1', 'CXP', 4, 'Once a week or more but not every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.1', 'CXP', 5, 'Every day');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.3', 'CXP', 1, 'Not important at all');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.3', 'CXP', 2, 'Fairly important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.3', 'CXP', 3, 'Important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.3', 'CXP', 4, 'Very important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.3', 'CXP', 5, 'Extremely important');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.4', 'CTP', 1, 'Regular (established routine, set schedule)');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.4', 'CTP', 2, 'Irregular (changes with weather conditions, production demands, or contract duration)');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.4', 'CTP', 3, 'Seasonal (only during certain times of the year)');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.8', 'CTP', 1, 'Less than 40 hours');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.8', 'CTP', 2, '40 hours');
INSERT INTO work_context_categories (element_id, scale_id, category, category_description) VALUES ('4.C.3.d.8', 'CTP', 3, 'More than 40 hours');
GO

