CREATE TABLE task_ratings (
  onetsoc_code CHARACTER(10) NOT NULL,
  task_id DECIMAL(8,0) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  category DECIMAL(3,0),
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(7,4),
  lower_ci_bound DECIMAL(7,4),
  upper_ci_bound DECIMAL(7,4),
  recommend_suppress CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (task_id) REFERENCES task_statements(task_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id),
  FOREIGN KEY (scale_id, category) REFERENCES task_categories(scale_id, category));

INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 1, 5.92, 76, 4.2651, 1.3474, 22.4442, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 2, 15.98, 76, 5.6031, 7.6477, 30.3982, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 3, 29.68, 76, 9.5346, 14.5180, 51.1837, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 4, 21.18, 76, 8.3862, 8.9874, 42.2265, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 5, 19.71, 76, 7.3666, 8.8518, 38.2911, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 6, 4.91, 76, 2.6748, 1.6252, 13.9155, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 7, 2.63, 76, 2.2224, 0.4773, 13.2071, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'IM', NULL, 4.52, 75, 0.1055, 4.3146, 4.7350, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'RT', NULL, 74.44, 95, 7.3023, 57.6139, 86.1881, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 1, 1.42, 85, 0.9174, 0.3929, 5.0309, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 2, 14.44, 85, 5.2801, 6.7330, 28.3090, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 3, 27.31, 85, 7.2493, 15.3822, 43.7169, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 4, 25.52, 85, 7.6938, 13.2843, 43.3856, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 5, 26.88, 85, 7.3816, 14.8321, 43.6841, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 6, 2.52, 85, 2.0396, 0.4936, 11.8747, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 7, 1.90, 85, 1.3616, 0.4516, 7.6444, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'IM', NULL, 4.32, 83, 0.1071, 4.1057, 4.5318, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'RT', NULL, 81.71, 95, 7.8833, 61.0491, 92.7151, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 1, 15.50, 85, 5.3008, 7.5815, 29.0895, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 2, 38.21, 85, 9.3143, 22.0083, 57.5386, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 3, 32.73, 85, 10.3442, 16.0439, 55.3230, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 4, 5.15, 85, 2.5088, 1.9164, 13.1019, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 5, 5.25, 85, 2.6259, 1.9000, 13.6663, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 6, 0.19, 85, 0.1907, 0.0249, 1.4018, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 7, 2.98, 85, 2.1083, 0.7159, 11.5779, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'IM', NULL, 4.30, 87, 0.1527, 3.9916, 4.5985, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'RT', NULL, 93.41, 95, 2.9498, 84.5520, 97.3448, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 1, 3.03, 91, 1.9033, 0.8544, 10.1668, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 2, 17.33, 91, 6.6618, 7.6851, 34.5574, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 3, 20.30, 91, 7.9195, 8.7894, 40.2499, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 4, 18.10, 91, 7.1621, 7.8023, 36.5921, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 5, 33.16, 91, 8.4471, 18.8723, 51.4012, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 6, 2.01, 91, 1.1744, 0.6216, 6.2858, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 7, 6.07, 91, 2.7269, 2.4391, 14.3197, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'IM', NULL, 4.24, 91, 0.1424, 3.9608, 4.5266, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'RT', NULL, 97.79, 94, 1.5735, 91.2414, 99.4721, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 1, 1.98, 89, 1.4672, 0.4487, 8.3161, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 2, 14.06, 89, 5.0049, 6.7033, 27.1485, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 3, 42.60, 89, 9.0775, 26.1908, 60.8125, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 4, 21.24, 89, 8.6332, 8.8158, 42.9230, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 5, 13.18, 89, 5.7567, 5.2935, 29.2085, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 6, 6.24, 89, 3.4566, 2.0167, 17.7168, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 7, 0.70, 89, 0.5058, 0.1635, 2.9132, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'IM', NULL, 4.17, 88, 0.1950, 3.7827, 4.5578, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'RT', NULL, 92.92, 95, 3.5072, 81.9943, 97.4244, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 1, 9.72, 88, 3.8700, 4.2910, 20.5529, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 2, 29.40, 88, 8.3085, 15.8198, 47.9898, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 3, 26.87, 88, 7.5416, 14.6315, 44.0716, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 4, 18.17, 88, 6.6762, 8.3414, 35.1543, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 5, 12.56, 88, 4.8925, 5.5907, 25.8242, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 6, 0.90, 88, 0.8857, 0.1259, 6.1378, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 7, 2.37, 88, 1.5251, 0.6534, 8.2512, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'IM', NULL, 4.14, 86, 0.1284, 3.8832, 4.3937, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'RT', NULL, 88.43, 94, 7.5883, 63.6669, 97.0898, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 1, 4.08, 92, 2.0556, 1.4774, 10.7739, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 2, 22.03, 92, 5.5948, 12.8909, 35.0512, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 3, 36.36, 92, 8.5971, 21.4571, 54.4473, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 4, 8.29, 92, 5.1545, 2.2986, 25.7904, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 5, 24.71, 92, 7.0826, 13.3473, 41.1434, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 6, 1.97, 92, 1.3961, 0.4733, 7.7959, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 7, 2.56, 92, 1.4414, 0.8243, 7.6469, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'IM', NULL, 4.13, 91, 0.1505, 3.8353, 4.4332, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'RT', NULL, 98.57, 94, 1.2603, 92.1011, 99.7562, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 1, 2.91, 70, 1.7252, 0.8767, 9.2022, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 2, 3.99, 70, 2.4292, 1.1619, 12.8331, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 3, 27.29, 70, 10.9952, 11.0507, 53.1317, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 4, 10.95, 70, 5.3329, 3.9637, 26.7990, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 5, 36.62, 70, 9.4339, 20.4319, 56.5191, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 6, 9.41, 70, 4.1591, 3.7754, 21.5636, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 7, 8.84, 70, 4.0084, 3.4686, 20.7334, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'IM', NULL, 4.13, 73, 0.1786, 3.7774, 4.4893, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'RT', NULL, 70.43, 94, 7.4993, 53.8141, 82.9637, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 1, 15.84, 67, 7.3965, 5.8522, 36.2984, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 2, 35.93, 67, 9.2828, 20.0414, 55.6400, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 3, 32.38, 67, 10.4333, 15.6103, 55.3575, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 4, 8.62, 67, 3.9507, 3.3489, 20.4307, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 5, 7.23, 67, 3.1036, 3.0024, 16.4107, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 6, 0.00, 67, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 7, 0.00, 67, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'IM', NULL, 4.13, 66, 0.1854, 3.7629, 4.5035, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'RT', NULL, 75.74, 94, 6.5363, 60.6384, 86.3541, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 1, 11.90, 84, 3.8413, 6.1159, 21.8688, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 2, 25.73, 84, 6.5019, 14.9705, 40.5308, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 3, 29.22, 84, 9.2367, 14.5169, 50.0892, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 4, 21.82, 84, 8.8405, 9.0569, 43.8961, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 5, 8.46, 84, 3.1611, 3.9455, 17.2306, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 6, 1.69, 84, 1.3337, 0.3483, 7.8164, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 7, 1.18, 84, 1.1744, 0.1592, 8.1567, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'IM', NULL, 4.09, 84, 0.1489, 3.7906, 4.3828, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'RT', NULL, 93.14, 93, 2.2627, 87.0457, 96.4821, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 1, 2.09, 89, 1.6057, 0.4494, 9.2066, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 2, 15.05, 89, 5.8417, 6.6724, 30.5228, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 3, 42.07, 89, 10.1344, 24.1181, 62.3995, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 4, 16.02, 89, 6.6824, 6.6404, 33.8599, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 5, 15.66, 89, 5.1271, 7.9026, 28.6501, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 6, 5.02, 89, 2.7260, 1.6710, 14.1356, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 7, 4.08, 89, 2.0136, 1.5034, 10.5743, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'IM', NULL, 4.09, 88, 0.1555, 3.7763, 4.3945, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'RT', NULL, 96.73, 95, 1.7819, 90.6242, 98.9064, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 1, 1.34, 89, 1.3263, 0.1864, 9.0434, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 2, 5.94, 89, 2.6609, 2.3893, 13.9926, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 3, 27.02, 89, 9.4656, 12.4827, 49.0089, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 4, 24.41, 89, 7.1366, 13.0195, 41.0520, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 5, 25.96, 89, 7.7820, 13.5580, 43.9453, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 6, 12.90, 89, 4.3424, 6.4288, 24.1989, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 7, 2.43, 89, 1.8154, 0.5414, 10.2362, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'IM', NULL, 4.07, 91, 0.1205, 3.8261, 4.3049, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'RT', NULL, 96.42, 95, 2.4751, 86.6452, 99.1118, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 1, 8.90, 81, 3.6332, 3.8540, 19.2476, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 2, 36.89, 81, 8.1789, 22.5140, 54.0477, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 3, 15.43, 81, 5.5527, 7.2549, 29.8495, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 4, 28.50, 81, 8.7673, 14.4803, 48.4115, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 5, 3.84, 81, 2.3313, 1.1221, 12.3036, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 6, 4.62, 81, 2.6814, 1.4196, 13.9867, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 7, 1.82, 81, 1.4144, 0.3827, 8.2189, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'IM', NULL, 4.06, 80, 0.1592, 3.7447, 4.3786, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'RT', NULL, 80.19, 95, 7.5926, 61.0428, 91.2680, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 1, 5.35, 87, 2.6867, 1.9317, 13.9635, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 2, 33.46, 87, 7.7460, 20.1121, 50.1009, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 3, 28.42, 87, 6.8451, 16.8993, 43.6618, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 4, 11.09, 87, 4.1267, 5.1502, 22.2786, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 5, 18.66, 87, 7.3376, 8.0655, 37.4898, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 6, 1.42, 87, 1.3222, 0.2198, 8.6080, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 7, 1.60, 87, 1.2899, 0.3205, 7.6416, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'IM', NULL, 3.98, 86, 0.1294, 3.7208, 4.2352, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'RT', NULL, 87.04, 95, 7.5027, 64.1967, 96.1796, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 1, 7.56, 88, 3.8601, 2.6536, 19.6889, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 2, 22.61, 88, 7.0349, 11.6141, 39.3808, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 3, 34.49, 88, 8.0801, 20.5532, 51.7351, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 4, 22.76, 88, 7.0424, 11.7289, 39.5137, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 5, 7.95, 88, 3.1695, 3.5240, 16.9632, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 6, 4.28, 88, 3.1961, 0.9407, 17.4069, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 7, 0.35, 88, 0.3492, 0.0465, 2.5311, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'IM', NULL, 3.94, 87, 0.1619, 3.6207, 4.2643, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'RT', NULL, 92.70, 95, 5.0596, 74.2136, 98.2448, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 1, 2.43, 72, 2.1665, 0.4006, 13.3502, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 2, 21.28, 72, 7.0845, 10.4171, 38.5808, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 3, 29.93, 72, 8.5557, 15.9225, 49.0714, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 4, 10.37, 72, 5.1102, 3.7237, 25.7221, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 5, 24.30, 72, 8.5049, 11.3206, 44.6583, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 6, 9.04, 72, 4.6731, 3.1043, 23.5854, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 7, 2.65, 72, 1.7829, 0.6809, 9.7474, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'IM', NULL, 3.92, 71, 0.1246, 3.6712, 4.1683, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'RT', NULL, 68.36, 95, 8.5421, 49.6542, 82.5553, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 1, 16.93, 71, 5.4386, 8.6105, 30.5885, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 2, 40.16, 71, 9.3257, 23.6389, 59.2737, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 3, 14.16, 71, 5.2319, 6.5358, 28.0190, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 4, 11.86, 71, 5.0072, 4.9236, 25.9157, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 5, 10.06, 71, 3.7488, 4.6646, 20.3538, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 6, 5.32, 71, 3.1242, 1.6066, 16.2190, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 7, 1.50, 71, 1.4931, 0.2041, 10.2323, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'IM', NULL, 3.80, 71, 0.1685, 3.4607, 4.1326, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'RT', NULL, 72.17, 94, 8.4290, 52.9831, 85.6456, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 1, 24.44, 64, 10.0619, 9.8202, 49.0041, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 2, 28.18, 64, 8.8561, 14.0610, 48.4696, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 3, 39.30, 64, 10.0384, 21.8265, 60.0148, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 4, 3.73, 64, 2.1307, 1.1703, 11.2544, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 5, 3.93, 64, 2.7421, 0.9464, 14.8721, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 6, 0.00, 64, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 7, 0.43, 64, 0.4344, 0.0566, 3.1801, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'IM', NULL, 3.79, 63, 0.1763, 3.4340, 4.1390, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'RT', NULL, 74.11, 94, 6.6140, 59.0773, 85.0206, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 1, 10.03, 62, 5.1771, 3.4166, 25.9851, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 2, 32.74, 62, 7.2168, 20.1727, 48.3807, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 3, 45.75, 62, 10.0526, 27.2789, 65.4600, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 4, 5.66, 62, 4.1162, 1.2671, 21.8935, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 5, 5.83, 62, 3.4044, 1.7627, 17.6218, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 6, 0.00, 62, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 7, 0.00, 62, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'IM', NULL, 3.59, 64, 0.2084, 3.1786, 4.0114, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'RT', NULL, 69.01, 94, 8.3364, 50.6627, 82.8444, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 1, 23.76, 69, 7.4948, 12.0074, 41.5720, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 2, 16.59, 69, 5.2455, 8.5412, 29.7671, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 3, 46.78, 69, 9.2506, 29.5204, 64.8541, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 4, 5.57, 69, 2.5752, 2.1689, 13.5455, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 5, 5.22, 69, 2.4323, 2.0267, 12.8093, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 6, 2.07, 69, 2.0528, 0.2813, 13.7275, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 7, 0.00, 69, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'IM', NULL, 3.55, 71, 0.1332, 3.2887, 3.8199, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'RT', NULL, 82.46, 95, 4.9389, 70.4702, 90.2538, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 1, 23.38, 21, 12.2155, 6.8528, 55.8590, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 2, 65.82, 21, 13.3278, 35.8823, 86.8874, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 3, 1.19, 21, 1.2326, 0.1340, 9.7105, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 5, 5.56, 21, 5.2962, 0.7148, 32.5374, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 6, 0.00, 21, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 7, 4.05, 21, 4.0878, 0.4679, 27.4762, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'IM', NULL, 4.07, 21, 0.3621, 3.3099, 4.8204, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'RT', NULL, 27.05, 94, 7.6681, 14.6296, 44.5094, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 1, 35.69, 52, 11.2933, 17.1288, 59.8453, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 2, 32.00, 52, 11.4859, 14.0230, 57.5897, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 3, 16.99, 52, 7.4245, 6.6398, 37.0630, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 4, 7.80, 52, 4.5540, 2.3205, 23.1725, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 5, 5.61, 52, 3.5860, 1.5043, 18.7949, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 6, 0.00, 52, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 7, 1.90, 52, 1.9107, 0.2476, 13.1545, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'IM', NULL, 3.98, 52, 0.1559, 3.6622, 4.2882, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'RT', NULL, 56.65, 95, 8.5404, 39.5829, 72.2747, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 1, 13.29, 27, 8.6257, 3.1865, 41.6545, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 2, 33.80, 27, 14.1893, 12.1798, 65.2798, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 3, 29.93, 27, 21.4629, 4.9546, 77.7825, 'Y', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 4, 6.36, 27, 5.2389, 1.0990, 29.3017, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 5, 10.56, 27, 6.7170, 2.6644, 33.7454, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 6, 0.00, 27, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 7, 6.06, 27, 5.9079, 0.7570, 35.2701, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'IM', NULL, 3.90, 26, 0.2359, 3.4184, 4.3903, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'RT', NULL, 27.31, 94, 8.1542, 14.2474, 45.9243, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 1, 32.80, 42, 10.8659, 15.2798, 56.9138, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 2, 20.05, 42, 7.0754, 9.3266, 37.9488, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 3, 35.79, 42, 13.2297, 14.8393, 64.0620, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 4, 7.76, 42, 4.4441, 2.3453, 22.7668, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 5, 3.60, 42, 3.0930, 0.6135, 18.4277, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 6, 0.00, 42, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 7, 0.00, 42, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'IM', NULL, 3.88, 44, 0.2471, 3.3790, 4.3755, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'RT', NULL, 52.57, 94, 8.7584, 35.5606, 69.0103, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 1, 29.97, 40, 10.0695, 13.9558, 53.0409, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 2, 34.55, 40, 11.9047, 15.3950, 60.4885, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 3, 31.55, 40, 12.9482, 12.0530, 60.7817, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 4, 1.66, 40, 1.6418, 0.2218, 11.4097, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 5, 2.27, 40, 2.2930, 0.2861, 15.8221, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 6, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 7, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'IM', NULL, 3.81, 39, 0.2610, 3.2854, 4.3422, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'RT', NULL, 47.82, 94, 7.8913, 32.8473, 63.2028, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 1, 12.68, 58, 5.4422, 5.1472, 27.9827, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 2, 36.53, 58, 9.6186, 20.0525, 56.9152, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 3, 32.21, 58, 10.1778, 15.7386, 54.7138, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 4, 8.58, 58, 7.7611, 1.2756, 40.5090, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 5, 9.23, 58, 5.3901, 2.7305, 26.9415, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 6, 0.26, 58, 0.2615, 0.0342, 1.9331, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 7, 0.51, 58, 0.5183, 0.0674, 3.7925, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'IM', NULL, 3.81, 56, 0.1732, 3.4663, 4.1603, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'RT', NULL, 62.05, 94, 9.4394, 42.4518, 78.3781, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 1, 5.21, 57, 2.9192, 1.6563, 15.2258, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 2, 25.53, 57, 7.8610, 13.0278, 43.9763, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 3, 32.46, 57, 12.7204, 13.0665, 60.5772, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 4, 17.43, 57, 9.9957, 4.9894, 45.9059, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 5, 15.93, 57, 6.9539, 6.2786, 34.9056, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 6, 0.92, 57, 0.7781, 0.1658, 4.8968, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 7, 2.51, 57, 2.4232, 0.3542, 15.7516, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'IM', NULL, 3.78, 55, 0.2108, 3.3594, 4.2047, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'RT', NULL, 56.74, 94, 8.1042, 40.5026, 71.6403, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 1, 24.61, 51, 9.9725, 9.9825, 49.0018, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 2, 34.70, 51, 10.6527, 17.1309, 57.7400, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 3, 13.92, 51, 4.8338, 6.7092, 26.6650, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 4, 4.07, 51, 2.4385, 1.1988, 12.9463, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 5, 19.13, 51, 8.8435, 6.9776, 42.7154, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 6, 2.99, 51, 2.8994, 0.4127, 18.6619, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 7, 0.58, 51, 0.5842, 0.0744, 4.3060, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'IM', NULL, 3.70, 52, 0.2178, 3.2618, 4.1362, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'RT', NULL, 57.44, 94, 8.7902, 39.7899, 73.3770, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 1, 25.13, 66, 6.4747, 14.4467, 40.0284, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 2, 24.24, 66, 7.1334, 12.8413, 41.0068, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 3, 19.13, 66, 6.7317, 9.0246, 36.0642, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 4, 15.64, 66, 9.2261, 4.3882, 42.8320, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 5, 13.44, 66, 8.4598, 3.5077, 39.8835, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 6, 0.00, 66, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 7, 2.41, 66, 1.8316, 0.5174, 10.4762, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'IM', NULL, 3.66, 64, 0.1999, 3.2614, 4.0604, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'RT', NULL, 58.30, 94, 9.0597, 40.0097, 74.5535, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 1, 35.97, 58, 11.3418, 17.3252, 60.0956, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 2, 24.05, 58, 7.7772, 11.8917, 42.6189, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 3, 14.99, 58, 5.9067, 6.5177, 30.8506, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 4, 13.15, 58, 5.2594, 5.6791, 27.5759, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 5, 8.79, 58, 4.2493, 3.2273, 21.7855, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 6, 3.05, 58, 2.8189, 0.4636, 17.5120, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 7, 0.00, 58, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'IM', NULL, 3.51, 58, 0.2058, 3.1012, 3.9253, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'RT', NULL, 58.06, 94, 8.7199, 40.4703, 73.8141, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 1, 16.61, 62, 5.9114, 7.8208, 31.8620, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 2, 33.17, 62, 9.7064, 17.1345, 54.3649, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 3, 38.01, 62, 10.7959, 19.7006, 60.5204, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 4, 1.79, 62, 1.2234, 0.4511, 6.8287, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 5, 8.72, 62, 4.2164, 3.2043, 21.6006, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 6, 1.70, 62, 1.7160, 0.2212, 11.8811, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 7, 0.00, 62, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'IM', NULL, 3.42, 60, 0.2433, 2.9353, 3.9089, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'RT', NULL, 63.86, 94, 7.8126, 47.4304, 77.5842, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 1, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 2, 26.92, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 3, 38.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 4, 23.08, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 5, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 6, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 7, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'IM', NULL, 4.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'RT', NULL, 96.30, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 2, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 3, 29.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 4, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 5, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 6, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'IM', NULL, 4.37, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 2, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 3, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 4, 33.33, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 5, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 6, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'IM', NULL, 4.33, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 2, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 3, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 4, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 5, 44.44, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 6, 37.04, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 7, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'IM', NULL, 4.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 2, 37.04, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 3, 48.15, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 4, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 5, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 6, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'IM', NULL, 4.04, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 2, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 3, 51.85, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 4, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 5, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 6, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'IM', NULL, 3.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 1, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 2, 46.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 3, 30.77, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 4, 11.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 5, 7.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 6, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 7, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'IM', NULL, 3.88, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'RT', NULL, 96.30, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 2, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 3, 44.44, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 4, 29.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 5, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 6, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'IM', NULL, 3.85, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 1, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 2, 44.44, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 3, 29.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 4, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 5, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 6, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'IM', NULL, 3.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 1, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 2, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 3, 40.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 4, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 5, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 6, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'IM', NULL, 3.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 1, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 2, 34.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 3, 26.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 4, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 5, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'IM', NULL, 3.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'RT', NULL, 85.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 1, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 2, 32.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 3, 44.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 4, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 5, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 6, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'IM', NULL, 3.52, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'RT', NULL, 92.59, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 1, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 2, 29.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 3, 40.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 4, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 5, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 6, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'IM', NULL, 3.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 1, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 2, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 3, 32.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 4, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 5, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 6, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'IM', NULL, 3.48, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'RT', NULL, 92.59, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 1, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 2, 50.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 3, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 4, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 5, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'IM', NULL, 3.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'RT', NULL, 88.89, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 1, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 2, 51.85, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 3, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 4, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 5, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 6, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'IM', NULL, 3.33, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 1, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 2, 37.04, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 3, 44.44, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 4, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 5, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 6, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'IM', NULL, 3.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 1, 39.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 2, 34.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 3, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 4, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 5, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'IM', NULL, 3.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'RT', NULL, 85.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 1, 0.00, 76, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 2, 3.90, 76, 1.9431, 1.4246, 10.2329, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 3, 21.61, 76, 6.5911, 11.2694, 37.4398, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 4, 33.04, 76, 7.5611, 19.9815, 49.3575, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 5, 39.31, 76, 9.6844, 22.3912, 59.2504, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 6, 0.93, 76, 0.7172, 0.1997, 4.2344, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 7, 1.21, 76, 0.8667, 0.2890, 4.9338, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'IM', NULL, 4.18, 76, 0.1624, 3.8551, 4.5023, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'RT', NULL, 97.14, 82, 2.6360, 83.7197, 99.5562, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 1, 0.00, 66, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 2, 4.72, 66, 3.2340, 1.1622, 17.2419, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 3, 10.37, 66, 5.5200, 3.4152, 27.4745, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 4, 15.08, 66, 6.6147, 5.9508, 33.2521, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 5, 47.49, 66, 11.7342, 26.1142, 69.8352, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 6, 7.08, 66, 3.9463, 2.2484, 20.1576, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 7, 15.26, 66, 6.5989, 6.1008, 33.2864, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'IM', NULL, 4.14, 64, 0.1212, 3.8946, 4.3789, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'RT', NULL, 79.90, 82, 6.7949, 63.1402, 90.2203, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 1, 0.00, 70, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 2, 0.00, 70, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 3, 21.86, 70, 13.7722, 5.3041, 58.2883, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 4, 18.22, 70, 7.0034, 8.0250, 36.2667, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 5, 40.43, 70, 10.1973, 22.5771, 61.2304, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 6, 8.85, 70, 4.6147, 3.0100, 23.3108, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 7, 10.64, 70, 5.6211, 3.5292, 27.9155, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'IM', NULL, 4.01, 67, 0.1078, 3.7969, 4.2272, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'RT', NULL, 85.81, 82, 5.4404, 71.3131, 93.6356, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 1, 0.00, 68, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 2, 0.85, 68, 0.8529, 0.1123, 6.0923, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 3, 19.17, 68, 8.3499, 7.4808, 41.0113, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 4, 17.64, 68, 6.4353, 8.1280, 34.1458, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 5, 45.06, 68, 11.3343, 24.7442, 67.1603, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 6, 5.16, 68, 3.3434, 1.3695, 17.5462, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 7, 12.14, 68, 4.8130, 5.3131, 25.3762, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'IM', NULL, 3.98, 66, 0.1004, 3.7761, 4.1771, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'RT', NULL, 86.29, 82, 5.3105, 72.0379, 93.8903, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 1, 7.61, 63, 4.7794, 2.0737, 24.2732, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 2, 16.34, 63, 5.1893, 8.3763, 29.4339, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 3, 39.87, 63, 10.7601, 21.2783, 61.9212, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 4, 16.13, 63, 5.8220, 7.5242, 31.2533, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 5, 16.90, 63, 6.1366, 7.8293, 32.7580, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 6, 0.88, 63, 0.8067, 0.1394, 5.3405, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 7, 2.27, 63, 1.6203, 0.5367, 9.0914, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'IM', NULL, 3.90, 61, 0.1204, 3.6579, 4.1397, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'RT', NULL, 82.52, 82, 5.7805, 68.0175, 91.2865, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 1, 2.06, 63, 1.5868, 0.4368, 9.1916, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 2, 13.66, 63, 5.8658, 5.5304, 29.9513, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 3, 14.12, 63, 5.6135, 6.1170, 29.3169, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 4, 21.92, 63, 6.7013, 11.3756, 38.0453, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 5, 30.80, 63, 8.6007, 16.5747, 49.9299, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 6, 11.92, 63, 5.4835, 4.5457, 27.7671, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 7, 5.52, 63, 3.5491, 1.4759, 18.5486, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'IM', NULL, 3.83, 63, 0.1701, 3.4875, 4.1677, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'RT', NULL, 71.86, 82, 9.7000, 49.5793, 86.8999, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 1, 5.89, 76, 3.4280, 1.7902, 17.6658, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 2, 31.35, 76, 8.1356, 17.6994, 49.2313, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 3, 19.18, 76, 6.0044, 9.8862, 33.9237, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 4, 25.16, 76, 11.6171, 8.9555, 53.4681, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 5, 16.00, 76, 5.0515, 8.2630, 28.7094, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 6, 1.78, 76, 1.6427, 0.2765, 10.5538, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 7, 0.65, 76, 0.5012, 0.1380, 2.9845, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'IM', NULL, 3.79, 75, 0.1243, 3.5408, 4.0360, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'RT', NULL, 95.77, 82, 2.7311, 85.5512, 98.8567, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 1, 11.44, 70, 5.1588, 4.4660, 26.2923, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 2, 15.01, 70, 4.4413, 8.1027, 26.1279, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 3, 36.66, 70, 10.9553, 18.4184, 59.7303, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 4, 8.23, 70, 4.1419, 2.9171, 21.1244, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 5, 21.37, 70, 6.8188, 10.7894, 37.9126, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 6, 7.30, 70, 3.8767, 2.4483, 19.8029, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 7, 0.00, 70, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'IM', NULL, 3.74, 70, 0.1244, 3.4922, 3.9885, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'RT', NULL, 88.62, 82, 4.6117, 75.8172, 95.0856, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 1, 3.09, 65, 3.0538, 0.4156, 19.6307, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 2, 34.54, 65, 12.6736, 14.6897, 61.7856, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 3, 23.06, 65, 6.5065, 12.5895, 38.4045, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 4, 18.34, 65, 6.8047, 8.3081, 35.7598, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 5, 18.88, 65, 6.9201, 8.6220, 36.4651, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 6, 1.91, 65, 1.3238, 0.4735, 7.3950, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 7, 0.18, 65, 0.1825, 0.0236, 1.3547, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'IM', NULL, 3.44, 66, 0.1555, 3.1315, 3.7527, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'RT', NULL, 75.67, 82, 7.1190, 59.0345, 87.0372, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 1, 0.00, 38, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 2, 2.79, 38, 2.8919, 0.3307, 19.9200, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 3, 15.91, 38, 7.9979, 5.3356, 38.8497, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 4, 12.69, 38, 7.1027, 3.8170, 34.7574, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 5, 53.68, 38, 15.3363, 24.9290, 80.1715, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 6, 8.93, 38, 8.4875, 1.1696, 44.8283, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 7, 5.99, 38, 3.7217, 1.6451, 19.5552, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'IM', NULL, 4.03, 39, 0.1470, 3.7344, 4.3294, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'RT', NULL, 46.73, 82, 8.8747, 30.1443, 64.0671, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 1, 0.00, 34, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 2, 5.57, 34, 4.2739, 1.1189, 23.5474, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 3, 15.40, 34, 7.6446, 5.2304, 37.5251, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 4, 18.22, 34, 8.1511, 6.8196, 40.4056, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 5, 46.19, 34, 17.1504, 17.4145, 77.7505, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 6, 9.43, 34, 7.2038, 1.8362, 36.6773, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 7, 5.19, 34, 3.7333, 1.1542, 20.4024, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'IM', NULL, 4.01, 33, 0.1662, 3.6743, 4.3515, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'RT', NULL, 49.24, 81, 9.7392, 30.8784, 67.8104, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 1, 0.00, 42, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 2, 6.04, 42, 3.3500, 1.9130, 17.4747, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 3, 11.13, 42, 4.9271, 4.3772, 25.5097, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 4, 25.35, 42, 18.7123, 4.4061, 71.4419, 'Y', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 5, 28.06, 42, 10.4648, 12.0407, 52.6327, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 6, 11.90, 42, 7.4691, 3.1057, 36.2819, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 7, 17.53, 42, 9.0058, 5.6942, 42.7876, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'IM', NULL, 3.87, 43, 0.2523, 3.3602, 4.3784, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'RT', NULL, 59.07, 82, 8.1821, 42.4007, 73.8926, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 1, 5.55, 31, 4.1654, 1.1472, 22.9421, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 2, 57.28, 31, 15.2319, 27.3271, 82.6979, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 3, 2.20, 31, 2.1674, 0.2879, 14.9493, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 4, 16.20, 31, 8.3765, 5.1949, 40.5325, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 5, 14.26, 31, 8.4017, 3.9265, 40.3603, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 6, 4.51, 31, 4.5029, 0.5566, 28.5319, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 7, 0.00, 31, 0.0000, NULL, NULL, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'IM', NULL, 3.57, 31, 0.2310, 3.0941, 4.0377, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'RT', NULL, 51.98, 81, 10.2013, 32.4315, 70.9436, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 1, 5.72, 40, 4.2313, 1.2283, 22.8711, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 2, 5.83, 40, 3.0913, 1.9404, 16.2034, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 3, 14.49, 40, 7.4346, 4.7929, 36.3197, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 4, 43.80, 40, 17.2274, 15.9138, 76.2506, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 5, 24.80, 40, 10.5068, 9.5479, 50.7581, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 6, 2.24, 40, 2.2006, 0.2988, 14.8950, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 7, 3.11, 40, 3.0843, 0.4043, 20.2704, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'IM', NULL, 3.53, 41, 0.2438, 3.0371, 4.0227, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'RT', NULL, 51.13, 82, 9.9330, 32.1716, 69.7622, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 1, 18.02, 44, 7.8578, 6.9968, 39.1217, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 2, 21.61, 44, 9.1036, 8.5330, 44.9002, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 3, 41.85, 44, 16.5545, 15.4335, 73.9390, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 4, 5.95, 44, 4.7933, 1.1099, 26.2574, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 5, 7.07, 44, 4.1578, 2.0821, 21.4195, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 6, 5.40, 44, 4.3270, 1.0221, 23.9627, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 7, 0.10, 44, 0.1020, 0.0125, 0.7845, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'IM', NULL, 3.10, 43, 0.2337, 2.6298, 3.5732, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'RT', NULL, 56.52, 82, 8.9538, 38.6345, 72.8527, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 1, 26.18, 34, 10.5108, 10.4996, 51.7477, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 2, 11.42, 34, 6.3771, 3.4551, 31.7352, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 3, 28.49, 34, 20.4506, 4.9153, 75.4354, 'Y', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 4, 21.47, 34, 11.5339, 6.3677, 52.3733, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 5, 10.75, 34, 5.6369, 3.5194, 28.4714, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 6, 1.56, 34, 1.5085, 0.2154, 10.4533, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 7, 0.11, 34, 0.1144, 0.0133, 0.9057, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'IM', NULL, 2.92, 35, 0.1902, 2.5382, 3.3112, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'RT', NULL, 51.62, 82, 9.9083, 32.6373, 70.1441, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 1, 45.96, 36, 15.5349, 19.2808, 75.1707, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 2, 43.59, 36, 17.5715, 15.3378, 76.7285, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 3, 2.41, 36, 2.3008, 0.3368, 15.2612, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 4, 2.35, 36, 2.2838, 0.3198, 15.3396, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 5, 1.31, 36, 1.3577, 0.1587, 10.0358, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 6, 2.19, 36, 2.2641, 0.2600, 16.0888, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 7, 2.19, 36, 2.2641, 0.2600, 16.0888, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'IM', NULL, 2.79, 36, 0.1959, 2.3965, 3.1919, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'RT', NULL, 49.78, 82, 10.0886, 30.7506, 68.8707, 'N', TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 1, 1.02, 69, 1.0204, 0.1364, 7.1961, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 2, 8.65, 69, 3.2308, 4.0214, 17.6370, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 3, 23.65, 69, 5.2068, 14.8385, 35.5138, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 4, 25.65, 69, 5.4702, 16.2938, 37.9466, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 5, 25.51, 69, 4.6763, 17.3298, 35.8844, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 6, 8.50, 69, 3.6665, 3.4996, 19.2234, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 7, 7.01, 69, 3.2810, 2.6892, 17.0694, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'IM', NULL, 4.13, 66, 0.1181, 3.8900, 4.3616, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'RT', NULL, 96.37, 73, 2.2923, 87.7929, 98.9874, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 1, 2.15, 64, 2.0891, 0.3016, 13.7760, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 2, 9.79, 64, 3.4950, 4.6942, 19.3134, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 3, 27.42, 64, 5.5103, 17.8429, 39.6443, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 4, 21.09, 64, 5.5006, 12.1302, 34.0947, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 5, 24.49, 64, 5.1398, 15.6883, 36.1079, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 6, 9.57, 64, 3.4710, 4.5332, 19.0862, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 7, 5.49, 64, 3.1764, 1.6827, 16.4866, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'IM', NULL, 4.07, 60, 0.1350, 3.8005, 4.3407, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'RT', NULL, 87.26, 72, 3.5018, 78.5187, 92.7741, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 1, 0.00, 68, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 2, 17.06, 68, 4.2392, 10.1632, 27.2235, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 3, 11.79, 68, 3.9989, 5.8392, 22.3550, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 4, 21.68, 68, 5.2267, 13.0239, 33.8492, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 5, 24.29, 68, 4.8218, 15.9773, 35.1299, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 6, 20.26, 68, 5.2338, 11.7433, 32.6607, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 7, 4.92, 68, 2.8331, 1.5215, 14.7721, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'IM', NULL, 3.90, 69, 0.1128, 3.6700, 4.1203, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'RT', NULL, 97.19, 72, 1.7359, 90.6903, 99.1901, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 1, 3.55, 57, 3.3989, 0.5028, 21.1754, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 2, 25.30, 57, 5.9105, 15.3261, 38.7880, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 3, 27.69, 57, 5.7389, 17.7440, 40.4788, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 4, 23.90, 57, 5.9250, 14.0581, 37.6264, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 5, 14.70, 57, 4.9902, 7.2073, 27.6675, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 6, 4.85, 57, 2.9101, 1.4188, 15.2757, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 7, 0.00, 57, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'IM', NULL, 3.87, 54, 0.1347, 3.5962, 4.1366, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'RT', NULL, 80.19, 71, 5.9877, 65.6225, 89.5681, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 1, 0.00, 55, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 2, 6.17, 55, 3.2238, 2.1105, 16.7236, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 3, 21.57, 55, 5.9219, 11.9935, 35.6809, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 4, 25.90, 55, 6.2113, 15.4500, 40.0796, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 5, 26.81, 55, 6.0889, 16.4285, 40.5571, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 6, 17.74, 55, 5.2513, 9.4904, 30.7363, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 7, 1.81, 55, 1.8009, 0.2397, 12.3455, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'IM', NULL, 3.84, 53, 0.1367, 3.5663, 4.1148, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'RT', NULL, 78.64, 71, 4.4982, 68.3341, 86.2623, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 1, 1.78, 56, 1.7765, 0.2377, 12.1677, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 2, 18.36, 56, 5.8675, 9.3117, 33.0150, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 3, 20.34, 56, 4.8982, 12.2323, 31.8829, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 4, 18.71, 56, 5.0633, 10.5596, 30.9605, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 5, 28.41, 56, 6.1434, 17.8099, 42.0986, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 6, 7.70, 56, 3.9358, 2.6730, 20.1965, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 7, 4.69, 56, 3.2857, 1.1158, 17.6725, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'IM', NULL, 3.81, 53, 0.1282, 3.5557, 4.0701, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'RT', NULL, 78.17, 71, 4.9068, 66.8661, 86.4025, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 1, 3.64, 58, 2.5787, 0.8585, 14.1389, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 2, 11.74, 58, 4.3479, 5.4290, 23.5587, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 3, 17.45, 58, 4.9467, 9.6073, 29.6009, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 4, 25.23, 58, 5.8629, 15.3322, 38.6022, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 5, 27.78, 58, 5.2382, 18.5679, 39.3494, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 6, 12.14, 58, 4.2600, 5.8464, 23.5144, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 7, 2.02, 58, 2.0086, 0.2709, 13.5729, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'IM', NULL, 3.81, 59, 0.1211, 3.5697, 4.0545, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'RT', NULL, 83.59, 72, 4.0726, 73.8116, 90.2066, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 1, 9.16, 58, 4.0505, 3.6637, 21.0896, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 2, 36.44, 58, 6.0400, 25.3780, 49.1468, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 3, 36.59, 58, 6.9819, 24.0072, 51.3209, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 4, 14.28, 58, 5.1353, 6.7077, 27.8444, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 5, 2.36, 58, 2.3254, 0.3205, 15.4084, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 6, 1.17, 58, 1.1580, 0.1582, 8.0981, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 7, 0.00, 58, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'IM', NULL, 3.67, 55, 0.1218, 3.4240, 3.9124, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'RT', NULL, 81.73, 71, 4.8452, 70.0790, 89.5246, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 1, 0.00, 56, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 2, 17.66, 56, 5.1213, 9.5787, 30.2887, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 3, 22.85, 56, 6.5056, 12.3863, 38.2906, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 4, 22.46, 56, 5.9490, 12.7444, 36.4811, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 5, 27.16, 56, 6.4489, 16.2476, 41.7433, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 6, 8.42, 56, 3.8688, 3.2573, 20.0842, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 7, 1.45, 56, 1.4449, 0.1916, 10.0715, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'IM', NULL, 3.61, 57, 0.1404, 3.3279, 3.8902, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'RT', NULL, 79.02, 74, 4.5046, 68.6646, 86.6159, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 1, 3.19, 56, 2.2515, 0.7614, 12.4310, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 2, 16.15, 56, 4.9204, 8.5064, 28.5161, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 3, 46.17, 56, 7.0642, 32.6695, 60.2543, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 4, 14.89, 56, 4.3774, 8.0531, 25.9051, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 5, 15.39, 56, 4.8201, 7.9735, 27.6391, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 6, 3.01, 56, 2.3725, 0.6063, 13.6528, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 7, 1.19, 56, 1.1954, 0.1573, 8.4484, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'IM', NULL, 3.59, 54, 0.1070, 3.3745, 3.8035, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'RT', NULL, 77.04, 71, 6.3968, 61.9954, 87.3464, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 1, 4.41, 57, 3.0989, 1.0444, 16.7532, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 2, 18.73, 57, 4.7683, 10.9583, 30.1522, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 3, 19.86, 57, 5.2547, 11.3444, 32.4425, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 4, 28.59, 57, 5.5060, 18.9145, 40.7312, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 5, 19.96, 57, 5.2192, 11.4734, 32.4234, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 6, 6.07, 57, 3.1725, 2.0792, 16.4585, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 7, 2.37, 57, 2.2881, 0.3348, 14.9522, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'IM', NULL, 3.55, 56, 0.1297, 3.2881, 3.8079, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'RT', NULL, 78.24, 73, 5.4189, 65.5963, 87.1525, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 1, 2.23, 51, 2.2263, 0.2936, 15.0475, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 2, 34.26, 51, 6.7901, 22.1474, 48.8485, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 3, 26.21, 51, 6.2684, 15.6319, 40.5166, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 4, 14.93, 51, 5.5077, 6.8390, 29.5413, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 5, 20.34, 51, 7.1024, 9.5748, 38.1148, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 6, 2.02, 51, 1.5174, 0.4419, 8.7659, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 7, 0.00, 51, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'IM', NULL, 3.54, 51, 0.1265, 3.2835, 3.7917, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'RT', NULL, 69.28, 72, 6.2706, 55.6216, 80.2312, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 1, 4.04, 63, 2.3925, 1.2142, 12.6284, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 2, 9.46, 63, 3.8696, 4.0590, 20.4930, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 3, 39.21, 63, 6.5902, 27.0724, 52.8560, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 4, 20.90, 63, 5.2614, 12.2685, 33.2962, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 5, 23.71, 63, 5.5321, 14.4308, 36.4183, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 6, 2.68, 63, 1.9081, 0.6317, 10.6292, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 7, 0.00, 63, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'IM', NULL, 3.25, 57, 0.1317, 2.9850, 3.5126, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'RT', NULL, 86.55, 72, 4.4916, 74.8830, 93.2835, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 1, 0.00, 30, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 2, 21.53, 30, 8.1289, 9.2983, 42.3282, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 3, 19.07, 30, 7.2844, 8.2386, 38.2246, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 4, 20.48, 30, 7.0938, 9.5552, 38.5620, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 5, 18.13, 30, 9.1990, 5.8707, 44.0289, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 6, 14.08, 30, 6.6740, 5.0334, 33.6174, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 7, 6.71, 30, 4.6623, 1.5450, 24.8072, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'IM', NULL, 3.89, 27, 0.1991, 3.4764, 4.2950, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'RT', NULL, 41.07, 72, 6.2913, 29.3324, 53.9247, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 1, 5.28, 47, 3.7260, 1.2306, 19.9798, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 2, 36.15, 47, 8.2956, 21.5483, 53.8585, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 3, 23.84, 47, 6.6015, 13.0849, 39.4207, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 4, 13.04, 47, 5.6462, 5.2174, 29.0049, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 5, 14.46, 47, 5.3968, 6.5598, 28.9162, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 6, 5.80, 47, 3.9167, 1.4320, 20.6780, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 7, 1.43, 47, 1.4348, 0.1876, 10.1025, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'IM', NULL, 3.81, 44, 0.1563, 3.4966, 4.1270, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'RT', NULL, 63.17, 72, 6.6404, 49.2582, 75.1853, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 1, 4.34, 38, 3.0134, 1.0325, 16.4880, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 2, 15.25, 38, 5.4666, 7.0951, 29.7733, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 3, 36.91, 38, 9.0142, 21.0738, 56.1738, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 4, 10.45, 38, 4.7331, 4.0185, 24.5378, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 5, 20.62, 38, 6.8006, 10.0645, 37.6079, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 6, 12.43, 38, 5.6402, 4.7354, 28.8570, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 7, 0.00, 38, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'IM', NULL, 3.68, 38, 0.1708, 3.3323, 4.0243, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'RT', NULL, 58.64, 69, 5.6716, 47.0659, 69.3339, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 1, 2.36, 45, 2.3506, 0.3090, 15.8772, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 2, 23.50, 45, 6.1169, 13.4038, 37.8855, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 3, 18.69, 45, 5.7085, 9.7300, 32.8865, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 4, 22.59, 45, 7.4748, 10.9749, 40.8486, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 5, 16.24, 45, 5.0487, 8.4017, 29.0569, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 6, 12.29, 45, 4.7181, 5.4842, 25.2929, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 7, 4.33, 45, 3.1315, 0.9775, 17.1936, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'IM', NULL, 3.62, 45, 0.1596, 3.3006, 3.9439, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'RT', NULL, 61.21, 72, 6.5426, 47.6676, 73.2138, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 1, 5.03, 46, 3.5564, 1.1689, 19.1744, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 2, 26.30, 46, 6.5549, 15.2932, 41.3521, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 3, 17.91, 46, 5.8255, 8.9418, 32.6405, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 4, 27.42, 46, 6.3536, 16.5712, 41.8155, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 5, 19.24, 46, 6.6078, 9.1899, 35.9425, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 6, 4.10, 46, 2.9397, 0.9396, 16.1581, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 7, 0.00, 46, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'IM', NULL, 3.61, 45, 0.1360, 3.3381, 3.8861, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'RT', NULL, 62.26, 72, 5.7167, 50.3859, 72.8229, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 1, 3.68, 46, 2.6823, 0.8277, 14.9167, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 2, 26.13, 46, 6.2013, 15.6293, 40.3232, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 3, 21.52, 46, 6.7950, 10.8666, 38.1400, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 4, 22.45, 46, 5.7684, 12.9300, 36.0683, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 5, 9.94, 46, 4.5217, 3.8376, 23.3876, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 6, 16.28, 46, 6.1077, 7.3072, 32.4085, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 7, 0.00, 46, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'IM', NULL, 3.50, 45, 0.1233, 3.2502, 3.7473, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'RT', NULL, 63.96, 72, 6.3000, 50.7162, 75.3722, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 1, 18.91, 45, 6.0850, 9.4853, 34.1601, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 2, 62.00, 45, 7.0288, 47.2073, 74.8505, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 3, 6.75, 45, 3.9347, 2.0152, 20.3271, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 4, 10.87, 45, 4.5072, 4.5568, 23.7481, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 5, 0.00, 45, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 6, 1.47, 45, 1.4629, 0.1951, 10.2425, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 7, 0.00, 45, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'IM', NULL, 3.43, 47, 0.1588, 3.1098, 3.7492, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'RT', NULL, 65.01, 74, 6.5627, 51.1122, 76.7544, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 1, 13.66, 30, 6.8438, 4.6036, 34.1399, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 2, 23.42, 30, 8.3380, 10.5685, 44.1784, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 3, 32.29, 30, 8.0061, 18.4052, 50.2155, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 4, 14.19, 30, 6.5184, 5.2394, 33.0745, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 5, 14.11, 30, 6.1241, 5.5225, 31.5907, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 6, 0.00, 30, 0.0000, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 7, 2.33, 30, 2.3282, 0.2945, 16.1850, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'IM', NULL, 3.35, 29, 0.1747, 2.9921, 3.7077, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'RT', NULL, 40.08, 71, 6.6997, 27.7210, 53.8523, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 1, 0.64, 112, 0.6435, 0.0851, 4.5923, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 2, 16.09, 112, 6.5952, 6.7857, 33.5442, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 3, 20.94, 112, 5.0062, 12.6955, 32.5301, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 4, 12.55, 112, 3.7847, 6.7584, 22.1334, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 5, 29.28, 112, 4.0632, 21.9150, 37.9193, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 6, 14.28, 112, 3.9042, 8.1349, 23.8637, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 7, 6.23, 112, 3.6827, 1.8693, 18.8118, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'IM', NULL, 4.30, 113, 0.1163, 4.0663, 4.5270, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'RT', NULL, 98.32, 117, 1.1254, 93.8163, 99.5604, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 1, 0.73, 113, 0.5727, 0.1552, 3.3921, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 2, 10.56, 113, 3.9574, 4.8982, 21.3128, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 3, 18.24, 113, 5.3147, 9.9157, 31.1274, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 4, 8.28, 113, 2.9736, 3.9878, 16.3938, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 5, 27.22, 113, 7.5249, 14.9852, 44.2574, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 6, 25.05, 113, 6.0274, 15.0306, 38.6998, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 7, 9.92, 113, 4.0682, 4.2743, 21.3456, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'IM', NULL, 4.24, 114, 0.0637, 4.1123, 4.3645, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'RT', NULL, 98.22, 117, 1.1929, 93.4598, 99.5318, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 1, 1.26, 94, 0.9366, 0.2867, 5.3792, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 2, 31.99, 94, 6.2413, 21.0179, 45.3998, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 3, 21.05, 94, 7.6111, 9.6984, 39.8336, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 4, 19.58, 94, 5.2347, 11.1750, 32.0249, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 5, 16.90, 94, 4.7085, 9.4587, 28.3516, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 6, 8.85, 94, 5.9447, 2.2002, 29.5507, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 7, 0.37, 94, 0.3718, 0.0481, 2.7127, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'IM', NULL, 3.99, 95, 0.1327, 3.7297, 4.2569, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'RT', NULL, 81.95, 116, 4.2214, 72.0658, 88.8785, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 1, 8.02, 92, 4.6443, 2.4360, 23.3429, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 2, 19.12, 92, 6.7063, 9.0820, 35.8745, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 3, 31.31, 92, 6.9851, 19.2999, 46.4953, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 4, 22.41, 92, 6.3439, 12.2716, 37.3474, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 5, 18.04, 92, 7.6148, 7.3295, 37.9724, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 6, 0.69, 92, 0.5042, 0.1622, 2.9054, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 7, 0.41, 92, 0.4177, 0.0551, 3.0247, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'IM', NULL, 3.87, 93, 0.1527, 3.5698, 4.1764, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'RT', NULL, 71.63, 117, 5.0429, 60.6988, 80.4973, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 1, 4.22, 102, 2.0490, 1.5849, 10.7493, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 2, 18.64, 102, 6.5993, 8.8144, 35.2000, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 3, 32.85, 102, 5.9357, 22.2904, 45.4819, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 4, 27.54, 102, 10.9978, 11.3011, 53.1453, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 5, 9.74, 102, 4.1825, 4.0299, 21.7091, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 6, 6.61, 102, 5.4200, 1.2274, 28.7642, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 7, 0.39, 102, 0.3634, 0.0616, 2.4383, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'IM', NULL, 3.70, 103, 0.1629, 3.3784, 4.0247, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'RT', NULL, 84.10, 116, 5.9175, 68.7611, 92.7013, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 1, 22.78, 80, 5.3133, 13.9219, 34.9904, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 2, 19.76, 80, 6.3011, 10.0396, 35.1948, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 3, 11.61, 80, 4.3327, 5.3628, 23.3333, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 4, 10.29, 80, 5.2723, 3.5499, 26.3359, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 5, 22.09, 80, 6.1487, 12.2231, 36.6034, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 6, 6.93, 80, 3.6291, 2.3727, 18.5802, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 7, 6.54, 80, 5.4583, 1.1698, 29.2715, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'IM', NULL, 3.66, 81, 0.1199, 3.4199, 3.8971, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'RT', NULL, 75.29, 117, 5.2447, 63.5451, 84.1884, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 1, 14.04, 87, 6.0643, 5.6722, 30.7221, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 2, 11.23, 87, 4.4000, 4.9985, 23.3258, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 3, 35.29, 87, 7.5458, 22.0401, 51.2614, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 4, 14.44, 87, 5.0181, 6.9982, 27.4508, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 5, 22.44, 87, 5.3920, 13.5116, 34.8754, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 6, 2.15, 87, 1.4130, 0.5767, 7.7048, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 7, 0.42, 87, 0.4243, 0.0555, 3.0819, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'IM', NULL, 3.65, 89, 0.1581, 3.3358, 3.9640, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'RT', NULL, 74.34, 113, 6.9076, 58.5680, 85.5822, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 1, 10.97, 102, 5.4093, 3.9463, 26.9911, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 2, 29.43, 102, 6.6458, 18.1073, 44.0371, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 3, 22.78, 102, 4.7312, 14.7539, 33.4686, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 4, 17.63, 102, 4.7512, 10.0586, 29.0568, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 5, 12.99, 102, 4.5275, 6.3161, 24.8374, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 6, 5.85, 102, 4.8276, 1.0787, 26.1266, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 7, 0.35, 102, 0.3516, 0.0458, 2.5589, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'IM', NULL, 3.56, 104, 0.1142, 3.3317, 3.7846, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'RT', NULL, 87.23, 116, 4.4992, 75.4244, 93.8281, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 1, 10.31, 78, 4.8797, 3.8672, 24.7428, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 2, 50.93, 78, 8.1648, 35.1282, 66.5456, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 3, 24.10, 78, 9.5143, 10.1298, 47.2162, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 4, 11.28, 78, 4.9014, 4.5755, 25.2149, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 5, 3.38, 78, 2.9599, 0.5704, 17.5473, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 6, 0.00, 78, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 7, 0.00, 78, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'IM', NULL, 3.53, 79, 0.1762, 3.1750, 3.8764, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'RT', NULL, 72.90, 115, 4.2544, 63.7148, 80.4749, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 1, 8.37, 113, 3.6196, 3.4598, 18.8764, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 2, 34.79, 113, 10.9854, 16.9729, 58.2059, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 3, 29.25, 113, 6.1350, 18.6815, 42.6539, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 4, 22.58, 113, 6.7638, 11.9298, 38.5640, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 5, 1.45, 113, 0.7648, 0.5038, 4.0759, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 6, 3.26, 113, 1.8575, 1.0405, 9.7668, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 7, 0.31, 113, 0.3125, 0.0406, 2.2767, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'IM', NULL, 3.41, 114, 0.1448, 3.1238, 3.6975, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'RT', NULL, 97.54, 116, 2.0657, 87.8235, 99.5418, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 1, 11.59, 95, 4.1758, 5.5149, 22.7462, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 2, 45.16, 95, 6.6094, 32.6494, 58.3145, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 3, 20.43, 95, 7.5384, 9.2768, 39.2008, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 4, 15.00, 95, 4.4126, 8.1546, 25.9732, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 5, 6.37, 95, 3.6755, 1.9593, 18.7840, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 6, 0.38, 95, 0.3442, 0.0644, 2.2507, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 7, 1.07, 95, 0.8250, 0.2282, 4.8427, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'IM', NULL, 3.40, 96, 0.0991, 3.2063, 3.5998, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'RT', NULL, 88.47, 116, 3.5938, 79.2492, 93.9126, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 1, 39.40, 71, 11.3547, 20.1176, 62.6676, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 2, 33.39, 71, 9.9275, 17.0654, 54.9722, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 3, 17.41, 71, 6.3445, 8.0403, 33.6968, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 4, 9.80, 71, 6.3957, 2.5034, 31.5042, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 5, 0.00, 71, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 6, 0.00, 71, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 7, 0.00, 71, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'IM', NULL, 3.14, 73, 0.1194, 2.8986, 3.3747, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'RT', NULL, 67.35, 115, 5.2430, 56.2636, 76.7913, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 1, 18.07, 70, 7.6476, 7.2939, 38.1979, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 2, 25.68, 70, 6.8309, 14.4710, 41.3706, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 3, 30.98, 70, 6.2258, 20.0713, 44.5182, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 4, 12.27, 70, 5.6886, 4.6495, 28.6428, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 5, 11.02, 70, 5.9344, 3.5694, 29.2897, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 6, 1.50, 70, 1.5316, 0.1934, 10.7294, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 7, 0.48, 70, 0.4884, 0.0616, 3.5972, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'IM', NULL, 3.41, 72, 0.3739, 2.6669, 4.1578, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'RT', NULL, 63.56, 116, 5.4541, 52.2483, 73.5541, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 1, 18.07, 70, 7.6476, 7.2939, 38.1979, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 2, 25.68, 70, 6.8309, 14.4710, 41.3706, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 3, 30.98, 70, 6.2258, 20.0713, 44.5182, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 4, 12.27, 70, 5.6886, 4.6495, 28.6428, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 5, 11.02, 70, 5.9344, 3.5694, 29.2897, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 6, 1.50, 70, 1.5316, 0.1934, 10.7294, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 7, 0.48, 70, 0.4884, 0.0616, 3.5972, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'IM', NULL, 3.41, 72, 0.3739, 2.6669, 4.1578, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'RT', NULL, 63.56, 116, 5.4541, 52.2483, 73.5541, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 1, 25.29, 71, 6.0847, 15.1161, 39.1519, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 2, 43.41, 71, 6.3749, 31.3756, 56.2792, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 3, 18.04, 71, 6.2925, 8.6085, 33.9657, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 4, 10.43, 71, 5.6222, 3.3849, 27.8869, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 5, 1.90, 71, 1.6244, 0.3398, 9.9187, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 6, 0.46, 71, 0.4695, 0.0584, 3.4743, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 7, 0.47, 71, 0.4846, 0.0615, 3.5607, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'IM', NULL, 3.17, 72, 0.1177, 2.9341, 3.4034, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'RT', NULL, 63.31, 116, 4.7901, 53.4173, 72.1884, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 1, 14.48, 68, 5.3763, 6.6410, 28.7091, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 2, 36.20, 68, 10.1182, 19.1375, 57.6344, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 3, 38.96, 68, 10.4085, 21.0371, 60.4571, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 4, 4.73, 68, 2.5224, 1.5994, 13.1754, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 5, 5.19, 68, 2.1435, 2.2432, 11.5512, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 6, 0.44, 68, 0.4517, 0.0581, 3.3127, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 7, 0.00, 68, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'IM', NULL, 3.12, 68, 0.1828, 2.7573, 3.4869, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'RT', NULL, 48.28, 116, 6.0477, 36.6152, 60.1263, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 1, 15.93, 67, 8.2928, 5.2135, 39.4796, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 2, 29.01, 67, 6.1060, 18.4418, 42.4863, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 3, 40.44, 67, 8.7219, 24.7855, 58.3186, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 4, 7.91, 67, 3.7815, 2.9536, 19.4939, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 5, 4.28, 67, 2.1724, 1.5239, 11.4172, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 6, 1.97, 67, 1.5873, 0.3901, 9.3849, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 7, 0.47, 67, 0.4752, 0.0603, 3.4980, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'IM', NULL, 3.06, 67, 0.2223, 2.6178, 3.5056, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'RT', NULL, 66.15, 113, 4.6709, 56.3858, 74.7158, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 1, 31.97, 88, 6.7536, 20.2247, 46.5570, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 2, 34.68, 88, 8.4593, 20.1728, 52.7223, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 3, 21.11, 88, 6.0603, 11.4924, 35.5504, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 4, 11.21, 88, 4.7348, 4.6777, 24.5290, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 5, 0.62, 88, 0.6323, 0.0829, 4.5449, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 6, 0.00, 88, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 7, 0.40, 88, 0.4093, 0.0531, 2.9825, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'IM', NULL, 2.70, 89, 0.1531, 2.4004, 3.0089, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'RT', NULL, 74.62, 115, 4.4063, 64.9645, 82.3355, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 1, 46.04, 48, 10.3159, 27.0087, 66.2966, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 2, 37.45, 48, 8.4974, 22.3975, 55.4000, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 3, 1.98, 48, 1.5178, 0.4184, 8.8712, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 4, 13.92, 48, 6.8232, 4.8939, 33.7081, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 5, 0.00, 48, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 6, 0.61, 48, 0.6075, 0.0797, 4.4388, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 7, 0.00, 48, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'IM', NULL, 2.68, 50, 0.2747, 2.1244, 3.2283, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'RT', NULL, 36.66, 115, 6.8728, 24.3553, 50.9850, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 1, 44.79, 63, 12.4149, 22.9195, 68.8758, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 2, 29.33, 63, 9.0482, 14.7784, 49.8294, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 3, 14.54, 63, 5.3218, 6.7403, 28.5973, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 4, 9.47, 63, 6.6461, 2.1748, 33.0036, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 5, 1.40, 63, 1.0674, 0.3030, 6.2404, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 6, 0.47, 63, 0.4727, 0.0618, 3.4515, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 7, 0.00, 63, 0.0000, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'IM', NULL, 2.59, 65, 0.2483, 2.0925, 3.0847, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'RT', NULL, 46.94, 116, 7.2290, 33.2374, 61.1204, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 2, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 3, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 4, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 5, 34.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 6, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 7, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'IM', NULL, 4.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 2, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 4, 47.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 5, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'IM', NULL, 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 2, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 3, 54.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 4, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 6, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'IM', NULL, 3.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'RT', NULL, 95.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 2, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 3, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 4, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 5, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 6, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'IM', NULL, 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'RT', NULL, 86.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 1, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 2, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 4, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 5, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'IM', NULL, 3.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 1, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 2, 47.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 4, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'IM', NULL, 3.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 2, 36.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 3, 31.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 4, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 7, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'IM', NULL, 3.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'RT', NULL, 95.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 1, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 2, 54.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 3, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 4, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'IM', NULL, 3.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'RT', NULL, 100.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 2, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 3, 42.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 5, 33.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'IM', NULL, 3.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 1, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 2, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 3, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 4, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 5, 38.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'IM', NULL, 3.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 1, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 2, 31.58, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 3, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 4, 26.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 5, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 6, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'IM', NULL, 3.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'RT', NULL, 82.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 1, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 2, 18.75, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 3, 50.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 4, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 5, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 6, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'IM', NULL, 3.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'RT', NULL, 69.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 1, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 2, 47.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 3, 38.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 4, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 5, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'IM', NULL, 3.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'RT', NULL, 95.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 1, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 2, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 3, 40.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 4, 33.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 5, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 6, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 7, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'IM', NULL, 4.07, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'RT', NULL, 65.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 1, 27.27, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 2, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 3, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 4, 9.09, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 5, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 6, 9.09, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 7, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'IM', NULL, 3.55, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'RT', NULL, 50.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 1, 0.00, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 2, 44.44, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 3, 33.33, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 4, 11.11, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 5, 11.11, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 6, 0.00, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 7, 0.00, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'IM', NULL, 3.44, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'RT', NULL, 39.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 1, 12.50, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 2, 50.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 3, 25.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 4, 0.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 5, 12.50, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 6, 0.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 7, 0.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'IM', NULL, 3.14, 7, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'RT', NULL, 36.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 1, 8.10, 105, 3.3980, 3.4459, 17.8952, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 2, 19.64, 105, 4.5457, 12.1345, 30.2034, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 3, 16.00, 105, 5.3293, 7.9873, 29.4889, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 4, 15.94, 105, 4.7768, 8.5549, 27.7759, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 5, 35.45, 105, 8.0502, 21.4665, 52.4544, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 6, 3.54, 105, 1.9920, 1.1443, 10.4493, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 7, 1.31, 105, 1.3176, 0.1756, 9.1050, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'IM', NULL, 3.71, 103, 0.1725, 3.3670, 4.0513, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'RT', NULL, 77.98, 133, 4.3923, 68.1026, 85.4515, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 1, 15.34, 123, 8.1039, 5.0061, 38.3936, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 2, 24.95, 123, 6.3853, 14.4773, 39.5044, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 3, 21.90, 123, 5.0216, 13.5566, 33.3976, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 4, 8.62, 123, 2.6784, 4.5895, 15.6048, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 5, 25.11, 123, 5.0414, 16.4751, 36.3099, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 6, 1.74, 123, 1.0678, 0.5148, 5.7436, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 7, 2.33, 123, 1.6566, 0.5611, 9.1574, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'IM', NULL, 3.70, 122, 0.0807, 3.5447, 3.8643, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'RT', NULL, 92.79, 133, 2.4428, 86.2044, 96.3604, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 1, 6.06, 95, 2.5240, 2.6046, 13.4626, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 2, 10.34, 95, 3.0556, 5.6548, 18.1591, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 3, 22.25, 95, 5.6039, 13.0717, 35.2489, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 4, 26.12, 95, 9.0697, 12.2048, 47.3362, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 5, 32.91, 95, 5.7074, 22.6955, 45.0397, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 6, 0.74, 95, 0.7463, 0.0979, 5.3267, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 7, 1.59, 95, 1.6062, 0.2110, 11.0192, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'IM', NULL, 3.38, 91, 0.1064, 3.1652, 3.5878, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'RT', NULL, 71.93, 133, 5.4793, 59.9727, 81.4277, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 1, 11.83, 126, 3.7371, 6.1928, 21.4236, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 2, 33.82, 126, 7.2077, 21.2715, 49.1508, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 3, 20.77, 126, 6.3060, 10.9327, 35.8797, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 4, 13.24, 126, 3.2132, 8.0641, 20.9760, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 5, 17.17, 126, 3.9580, 10.6774, 26.4505, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 6, 3.15, 126, 1.4285, 1.2690, 7.5918, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 7, 0.03, 126, 0.0262, 0.0034, 0.1923, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'IM', NULL, 3.33, 122, 0.0917, 3.1501, 3.5132, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'RT', NULL, 96.32, 134, 1.3809, 92.3723, 98.2615, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 1, 26.98, 100, 6.2847, 16.4052, 41.0349, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 2, 48.59, 100, 9.2377, 31.2125, 66.3143, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 3, 21.23, 100, 4.9332, 13.0518, 32.6128, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 4, 0.45, 100, 0.4533, 0.0612, 3.2473, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 5, 2.74, 100, 1.6973, 0.7928, 9.0628, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 6, 0.00, 100, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 7, 0.00, 100, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'IM', NULL, 3.19, 96, 0.1078, 2.9783, 3.4064, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'RT', NULL, 74.75, 134, 5.7368, 61.8755, 84.3800, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 1, 5.22, 98, 2.2420, 2.1884, 11.9223, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 2, 21.83, 98, 5.5282, 12.8018, 34.6911, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 3, 16.67, 98, 3.7624, 10.4624, 25.5084, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 4, 12.28, 98, 3.7324, 6.5729, 21.7787, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 5, 35.15, 98, 5.5948, 24.9809, 46.8703, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 6, 2.06, 98, 1.2135, 0.6336, 6.4892, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 7, 6.80, 98, 2.6976, 3.0383, 14.5159, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'IM', NULL, 4.06, 99, 0.1059, 3.8534, 4.2736, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'RT', NULL, 66.15, 133, 6.9502, 51.3971, 78.3098, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 1, 50.82, 77, 7.2156, 36.7653, 64.7415, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 2, 36.24, 77, 7.5531, 22.8681, 52.1547, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 3, 5.24, 77, 2.9643, 1.6570, 15.3677, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 4, 0.85, 77, 0.8455, 0.1161, 5.9479, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 5, 4.80, 77, 2.9837, 1.3566, 15.6170, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 6, 0.00, 77, 0.0000, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 7, 2.04, 77, 2.0624, 0.2675, 13.9663, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'IM', NULL, 3.95, 74, 0.1392, 3.6695, 4.2245, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'RT', NULL, 56.26, 133, 6.8687, 42.5466, 69.0810, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 1, 4.44, 93, 2.4435, 1.4559, 12.7276, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 2, 8.95, 93, 3.5245, 3.9945, 18.8331, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 3, 9.29, 93, 3.5327, 4.2645, 19.0598, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 4, 6.61, 93, 2.6370, 2.9443, 14.1898, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 5, 47.35, 93, 7.4384, 33.2127, 61.9308, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 6, 14.02, 93, 6.0472, 5.6778, 30.6333, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 7, 9.34, 93, 4.5860, 3.3957, 23.1984, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'IM', NULL, 3.92, 94, 0.1186, 3.6832, 4.1541, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'RT', NULL, 63.80, 133, 6.6152, 50.0047, 75.6462, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21276, 'FT', 1, 0.00, 94, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21276, 'FT', 2, 0.92, 94, 0.6466, 0.2267, 3.6586, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21276, 'FT', 3, 0.06, 94, 0.0589, 0.0078, 0.4324, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21276, 'FT', 4, 6.37, 94, 3.2594, 2.2468, 16.7629, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21276, 'FT', 5, 59.01, 94, 7.3842, 43.9844, 72.5254, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21276, 'FT', 6, 24.75, 94, 7.3058, 13.1145, 41.7517, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21276, 'FT', 7, 8.89, 94, 3.6243, 3.8567, 19.1758, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21276, 'IM', NULL, 4.55, 92, 0.0975, 4.3527, 4.7398, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21276, 'RT', NULL, 100.00, 95, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21278, 'FT', 1, 0.00, 84, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21278, 'FT', 2, 8.52, 84, 7.8345, 1.2471, 40.7400, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21278, 'FT', 3, 3.82, 84, 2.1029, 1.2551, 11.0316, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21278, 'FT', 4, 20.99, 84, 6.3255, 11.0634, 36.1941, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21278, 'FT', 5, 38.60, 84, 6.9244, 26.0172, 52.9239, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21278, 'FT', 6, 14.13, 84, 5.2001, 6.5549, 27.8451, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21278, 'FT', 7, 13.94, 84, 4.8488, 6.7576, 26.5713, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21278, 'IM', NULL, 4.50, 84, 0.1000, 4.3054, 4.7030, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21278, 'RT', NULL, 86.32, 95, 6.4633, 68.0345, 94.9248, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21277, 'FT', 1, 20.33, 77, 8.3237, 8.3953, 41.5232, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21277, 'FT', 2, 21.31, 77, 6.2659, 11.3998, 36.3056, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21277, 'FT', 3, 31.47, 77, 7.2381, 19.0526, 47.2592, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21277, 'FT', 4, 9.69, 77, 4.9109, 3.3876, 24.7029, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21277, 'FT', 5, 11.51, 77, 3.9463, 5.6697, 21.9589, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21277, 'FT', 6, 3.54, 77, 2.4083, 0.8932, 13.0066, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21277, 'FT', 7, 2.16, 77, 2.1553, 0.2879, 14.4176, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21277, 'IM', NULL, 4.21, 79, 0.1176, 3.9721, 4.4403, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21277, 'RT', NULL, 81.42, 94, 6.1118, 66.2698, 90.7216, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21280, 'FT', 1, 12.24, 84, 5.6473, 4.6734, 28.4097, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21280, 'FT', 2, 27.55, 84, 7.6256, 15.1003, 44.8428, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21280, 'FT', 3, 21.43, 84, 6.7279, 10.9668, 37.6476, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21280, 'FT', 4, 9.21, 84, 3.8652, 3.8879, 20.2803, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21280, 'FT', 5, 23.09, 84, 7.0206, 12.0335, 39.7278, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21280, 'FT', 6, 3.97, 84, 2.6899, 1.0054, 14.3995, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21280, 'FT', 7, 2.51, 84, 1.9952, 0.5053, 11.5333, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21280, 'IM', NULL, 4.09, 85, 0.1288, 3.8369, 4.3490, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21280, 'RT', NULL, 90.25, 94, 3.4048, 81.1037, 95.2256, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21279, 'FT', 1, 23.01, 75, 9.6349, 9.1812, 46.9006, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21279, 'FT', 2, 22.62, 75, 6.2325, 12.5684, 37.2731, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21279, 'FT', 3, 23.03, 75, 6.6073, 12.4635, 38.6066, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21279, 'FT', 4, 22.04, 75, 6.3556, 11.9195, 37.1403, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21279, 'FT', 5, 4.30, 75, 2.5630, 1.2839, 13.4509, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21279, 'FT', 6, 1.45, 75, 1.3108, 0.2353, 8.3905, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21279, 'FT', 7, 3.55, 75, 2.6623, 0.7764, 14.7674, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21279, 'IM', NULL, 4.04, 73, 0.1426, 3.7597, 4.3282, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21279, 'RT', NULL, 75.48, 94, 6.4330, 60.6852, 85.9906, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21282, 'FT', 1, 2.78, 88, 2.2719, 0.5336, 13.2028, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21282, 'FT', 2, 6.78, 88, 3.6179, 2.2750, 18.4940, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21282, 'FT', 3, 25.46, 88, 8.4159, 12.3916, 45.1927, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21282, 'FT', 4, 26.62, 88, 6.0331, 16.4124, 40.1288, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21282, 'FT', 5, 30.71, 88, 6.6378, 19.2529, 45.1738, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21282, 'FT', 6, 5.04, 88, 2.7441, 1.6710, 14.2285, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21282, 'FT', 7, 2.62, 88, 1.6893, 0.7144, 9.1195, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21282, 'IM', NULL, 3.98, 88, 0.1170, 3.7492, 4.2142, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21282, 'RT', NULL, 94.63, 95, 3.4172, 82.2566, 98.5307, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21273, 'FT', 1, 13.17, 80, 4.7490, 6.2207, 25.7403, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21273, 'FT', 2, 39.31, 80, 6.7189, 26.9956, 53.1529, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21273, 'FT', 3, 36.01, 80, 7.4746, 22.7808, 51.7650, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21273, 'FT', 4, 8.36, 80, 4.8887, 2.4969, 24.5224, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21273, 'FT', 5, 2.01, 80, 1.4961, 0.4511, 8.5088, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21273, 'FT', 6, 0.00, 80, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21273, 'FT', 7, 1.14, 80, 1.1419, 0.1552, 7.9432, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21273, 'IM', NULL, 3.92, 81, 0.1695, 3.5853, 4.2601, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21273, 'RT', NULL, 83.54, 95, 7.0517, 64.7045, 93.3523, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21281, 'FT', 1, 10.16, 84, 7.4702, 2.1711, 36.5465, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21281, 'FT', 2, 13.02, 84, 5.2619, 5.6071, 27.3870, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21281, 'FT', 3, 17.52, 84, 5.6326, 8.9081, 31.5597, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21281, 'FT', 4, 15.79, 84, 5.7928, 7.3067, 30.8435, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21281, 'FT', 5, 40.15, 84, 9.7555, 23.0280, 60.0660, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21281, 'FT', 6, 1.30, 84, 0.6785, 0.4566, 3.6338, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21281, 'FT', 7, 2.07, 84, 1.4974, 0.4844, 8.4122, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21281, 'IM', NULL, 3.72, 84, 0.1321, 3.4550, 3.9804, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21281, 'RT', NULL, 89.37, 94, 4.8548, 75.2926, 95.8663, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21272, 'FT', 1, 1.19, 80, 1.2205, 0.1519, 8.6886, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21272, 'FT', 2, 10.68, 80, 4.1091, 4.8275, 21.9858, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21272, 'FT', 3, 34.94, 80, 8.3809, 20.4964, 52.8008, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21272, 'FT', 4, 27.21, 80, 7.1431, 15.4231, 43.3861, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21272, 'FT', 5, 21.73, 80, 6.3250, 11.6988, 36.7933, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21272, 'FT', 6, 3.47, 80, 2.5233, 0.7981, 13.8635, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21272, 'FT', 7, 0.77, 80, 0.7889, 0.1006, 5.6888, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21272, 'IM', NULL, 3.47, 79, 0.1170, 3.2348, 3.7005, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21272, 'RT', NULL, 85.68, 96, 5.6573, 70.5505, 93.7304, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21274, 'FT', 1, 15.31, 65, 8.6077, 4.5774, 40.5092, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21274, 'FT', 2, 37.42, 65, 8.7363, 22.1030, 55.7482, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21274, 'FT', 3, 31.99, 65, 10.0561, 15.7405, 54.2178, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21274, 'FT', 4, 12.85, 65, 5.1577, 5.5532, 27.0105, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21274, 'FT', 5, 2.43, 65, 1.2177, 0.8865, 6.4971, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21274, 'FT', 6, 0.00, 65, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21274, 'FT', 7, 0.00, 65, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21274, 'IM', NULL, 3.04, 65, 0.1636, 2.7106, 3.3644, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21274, 'RT', NULL, 74.13, 96, 5.4410, 62.0006, 83.4261, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21275, 'FT', 1, 44.59, 39, 13.1790, 21.4622, 70.3162, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21275, 'FT', 2, 36.87, 39, 15.0672, 13.6081, 68.4095, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21275, 'FT', 3, 7.98, 39, 4.3645, 2.5402, 22.4111, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21275, 'FT', 4, 0.64, 39, 0.4830, 0.1385, 2.9087, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21275, 'FT', 5, 5.93, 39, 3.7940, 1.5678, 19.9845, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21275, 'FT', 6, 0.00, 39, 0.0000, NULL, NULL, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21275, 'FT', 7, 3.99, 39, 3.8282, 0.5454, 23.9224, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21275, 'IM', NULL, 3.62, 41, 0.3713, 2.8707, 4.3715, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', 21275, 'RT', NULL, 41.44, 95, 7.4912, 27.7152, 56.6406, 'N', TO_DATE('2024-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 1, 0.00, 75, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 2, 4.62, 75, 2.9057, 1.2824, 15.2722, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 3, 28.19, 75, 8.2538, 14.8332, 46.9349, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 4, 9.83, 75, 4.0166, 4.2296, 21.1913, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 5, 44.98, 75, 8.8229, 28.6643, 62.4565, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 6, 9.35, 75, 4.2139, 3.6858, 21.7364, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 7, 3.04, 75, 2.0593, 0.7754, 11.1976, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'IM', NULL, 4.11, 74, 0.1316, 3.8482, 4.3730, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'RT', NULL, 99.97, 76, 0.0270, 99.7973, 99.9966, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 1, 0.00, 74, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 2, 5.66, 74, 3.3879, 1.6679, 17.5225, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 3, 30.46, 74, 8.3867, 16.5937, 49.0891, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 4, 36.39, 74, 8.5392, 21.5223, 54.4065, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 5, 25.21, 74, 5.8171, 15.4203, 38.4052, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 6, 2.27, 74, 1.6954, 0.5064, 9.6190, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 7, 0.00, 74, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'IM', NULL, 4.10, 73, 0.1067, 3.8874, 4.3127, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'RT', NULL, 94.97, 76, 4.6512, 73.0819, 99.2436, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 1, 0.00, 74, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 2, 6.14, 74, 4.2889, 1.4647, 22.3748, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 3, 33.54, 74, 7.8623, 19.9937, 50.4796, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 4, 26.09, 74, 7.5037, 13.9786, 43.3925, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 5, 32.93, 74, 7.6130, 19.8124, 49.3948, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 6, 1.29, 74, 0.7995, 0.3742, 4.3660, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 7, 0.00, 74, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'IM', NULL, 4.08, 74, 0.1390, 3.8032, 4.3574, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'RT', NULL, 99.97, 75, 0.0289, 99.7820, 99.9964, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 1, 0.00, 69, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 2, 0.48, 69, 0.3645, 0.1042, 2.1669, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 3, 10.22, 69, 5.5613, 3.2845, 27.6168, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 4, 32.97, 69, 10.9832, 15.4294, 57.0069, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 5, 42.13, 69, 13.5747, 19.3317, 68.8586, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 6, 12.84, 69, 6.0440, 4.7718, 30.2045, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 7, 1.37, 69, 1.3856, 0.1791, 9.7066, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'IM', NULL, 4.04, 69, 0.1152, 3.8065, 4.2661, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'RT', NULL, 92.97, 76, 4.4365, 77.3769, 98.0847, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 1, 0.00, 70, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 2, 7.60, 70, 4.3143, 2.3573, 21.8855, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 3, 7.26, 70, 4.8194, 1.8403, 24.6137, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 4, 22.95, 70, 7.8867, 10.9021, 42.0351, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 5, 37.16, 70, 9.8818, 20.2654, 57.9013, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 6, 13.37, 70, 6.9527, 4.4503, 33.8241, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 7, 11.67, 70, 7.6619, 2.9119, 36.7897, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'IM', NULL, 3.99, 70, 0.1114, 3.7639, 4.2083, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'RT', NULL, 91.34, 76, 5.1425, 74.2844, 97.4666, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 1, 10.05, 68, 7.5434, 2.0698, 37.1408, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 2, 20.15, 68, 6.9155, 9.6642, 37.3056, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 3, 29.74, 68, 9.5296, 14.5519, 51.2627, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 4, 17.57, 68, 6.6433, 7.8581, 34.7439, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 5, 17.82, 68, 8.9012, 6.0576, 42.1815, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 6, 4.67, 68, 3.5690, 0.9815, 19.5217, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 7, 0.00, 68, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'IM', NULL, 3.94, 68, 0.1853, 3.5749, 4.3145, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'RT', NULL, 81.61, 76, 11.3218, 49.6838, 95.2281, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 1, 26.07, 73, 9.9964, 11.1405, 49.7880, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 2, 32.64, 73, 8.0109, 18.9850, 50.0437, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 3, 6.07, 73, 3.1656, 2.0929, 16.3503, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 4, 17.23, 73, 7.6462, 6.6706, 37.7386, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 5, 15.84, 73, 7.1273, 6.0861, 35.3327, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 6, 0.86, 73, 0.7273, 0.1576, 4.5394, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 7, 1.30, 73, 1.3116, 0.1711, 9.1824, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'IM', NULL, 3.88, 73, 0.1489, 3.5861, 4.1798, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'RT', NULL, 98.01, 76, 1.6055, 90.5370, 99.6054, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 1, 0.00, 76, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 2, 12.03, 76, 5.7837, 4.4019, 28.8875, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 3, 24.84, 76, 7.6925, 12.6994, 42.8913, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 4, 34.60, 76, 8.1344, 20.5385, 51.9823, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 5, 23.49, 76, 6.2626, 13.2946, 38.0660, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 6, 4.73, 76, 3.8103, 0.9106, 21.1175, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 7, 0.32, 76, 0.3209, 0.0418, 2.3512, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'IM', NULL, 3.88, 76, 0.2144, 3.4552, 4.3093, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'RT', NULL, 100.00, 76, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 1, 0.33, 72, 0.3313, 0.0428, 2.4372, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 2, 5.64, 72, 3.6297, 1.5095, 18.8896, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 3, 49.62, 72, 8.5367, 33.2669, 66.0534, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 4, 26.17, 72, 7.5427, 13.9989, 43.5689, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 5, 13.71, 72, 4.2822, 7.1636, 24.6381, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 6, 4.18, 72, 2.4877, 1.2482, 13.0823, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 7, 0.36, 72, 0.3634, 0.0476, 2.6572, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'IM', NULL, 3.85, 72, 0.1389, 3.5694, 4.1233, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'RT', NULL, 85.98, 76, 6.7670, 66.7134, 94.9369, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 1, 0.65, 72, 0.4489, 0.1634, 2.5499, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 2, 17.79, 72, 8.5817, 6.2962, 41.0821, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 3, 38.33, 72, 8.0907, 23.9059, 55.1577, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 4, 30.41, 72, 8.5266, 16.3641, 49.3865, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 5, 11.16, 72, 3.9514, 5.3671, 21.7558, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 6, 0.00, 72, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 7, 1.66, 72, 1.4123, 0.2988, 8.6616, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'IM', NULL, 3.70, 72, 0.1662, 3.3703, 4.0331, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'RT', NULL, 93.86, 76, 3.6842, 81.0522, 98.2040, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 1, 7.33, 75, 4.0045, 2.3881, 20.3851, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 2, 29.73, 75, 7.7042, 16.8660, 46.8671, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 3, 27.04, 75, 8.1346, 14.0159, 45.7376, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 4, 13.87, 75, 6.1202, 5.4837, 30.8886, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 5, 12.71, 75, 6.1248, 4.6241, 30.4318, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 6, 9.31, 75, 6.8039, 2.0215, 33.8310, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 7, 0.00, 75, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'IM', NULL, 3.70, 75, 0.2499, 3.1996, 4.1956, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'RT', NULL, 97.24, 76, 2.8112, 81.4086, 99.6474, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 1, 3.15, 66, 2.8076, 0.5129, 16.9841, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 2, 8.11, 66, 3.5968, 3.2597, 18.7934, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 3, 48.13, 66, 8.1904, 32.5147, 64.1116, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 4, 31.09, 66, 9.9313, 15.1613, 53.2387, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 5, 6.51, 66, 3.4147, 2.2240, 17.5954, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 6, 3.01, 66, 2.0382, 0.7663, 11.1177, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 7, 0.00, 66, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'IM', NULL, 3.68, 66, 0.1534, 3.3744, 3.9871, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'RT', NULL, 87.19, 76, 6.3259, 68.7754, 95.4647, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 1, 1.77, 74, 1.6255, 0.2800, 10.3937, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 2, 10.01, 74, 6.9304, 2.3433, 34.0125, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 3, 24.34, 74, 8.4975, 11.3677, 44.6584, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 4, 26.60, 74, 7.0109, 15.0494, 42.5706, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 5, 35.79, 74, 8.8538, 20.5521, 54.5739, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 6, 0.63, 74, 0.6023, 0.0929, 4.1376, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 7, 0.86, 74, 0.6473, 0.1887, 3.7971, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'IM', NULL, 3.63, 74, 0.2070, 3.2173, 4.0423, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'RT', NULL, 95.71, 76, 3.6280, 79.3161, 99.2373, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 1, 0.82, 58, 0.8226, 0.1109, 5.8651, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 2, 20.07, 58, 7.0120, 9.4728, 37.5981, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 3, 61.75, 58, 9.1024, 42.7317, 77.7402, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 4, 9.28, 58, 3.4441, 4.3167, 18.8377, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 5, 7.62, 58, 3.8650, 2.6731, 19.8501, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 6, 0.00, 58, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 7, 0.45, 58, 0.4556, 0.0609, 3.3131, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'IM', NULL, 3.59, 60, 0.1565, 3.2813, 3.9076, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'RT', NULL, 70.83, 76, 10.3651, 47.1949, 86.8335, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 1, 16.44, 68, 8.9857, 5.0647, 42.0629, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 2, 15.54, 68, 5.3026, 7.5926, 29.1854, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 3, 32.15, 68, 9.5264, 16.5427, 53.1184, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 4, 17.90, 68, 6.8962, 7.8700, 35.7419, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 5, 17.96, 68, 7.6851, 7.1781, 38.2748, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 6, 0.00, 68, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 7, 0.00, 68, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'IM', NULL, 3.53, 68, 0.2315, 3.0709, 3.9951, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'RT', NULL, 84.33, 76, 11.0669, 50.3665, 96.6140, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 1, 14.32, 67, 7.6512, 4.5928, 36.7287, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 2, 31.00, 67, 10.6364, 14.2741, 54.8049, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 3, 28.72, 67, 8.3942, 15.0877, 47.7424, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 4, 21.33, 67, 9.0649, 8.4458, 44.3622, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 5, 4.59, 67, 3.1175, 1.1483, 16.6166, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 6, 0.03, 67, 0.0302, 0.0039, 0.2267, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 7, 0.00, 67, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'IM', NULL, 3.39, 67, 0.2196, 2.9466, 3.8235, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'RT', NULL, 88.84, 76, 7.0968, 65.6683, 97.0710, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 1, 0.00, 60, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 2, 10.59, 60, 7.0689, 2.5906, 34.5370, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 3, 4.90, 60, 2.5265, 1.7082, 13.2295, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 4, 15.14, 60, 7.0031, 5.6579, 34.6854, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 5, 46.91, 60, 10.2376, 27.9610, 66.7906, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 6, 9.81, 60, 7.0360, 2.1653, 34.8160, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 7, 12.66, 60, 5.7544, 4.8642, 29.1090, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'IM', NULL, 4.19, 60, 0.2026, 3.7807, 4.5916, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'RT', NULL, 65.58, 76, 13.9777, 35.6902, 86.7433, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 1, 0.00, 53, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 2, 4.46, 53, 3.6292, 0.8375, 20.5028, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 3, 8.14, 53, 4.1253, 2.8443, 21.1415, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 4, 19.13, 53, 4.1410, 12.1445, 28.8123, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 5, 23.53, 53, 3.7464, 16.8524, 31.8512, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 6, 22.21, 53, 7.6381, 10.5248, 40.9454, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 7, 22.53, 53, 8.7816, 9.5775, 44.3847, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'IM', NULL, 4.30, 52, 0.1851, 3.9246, 4.6678, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'RT', NULL, 83.85, 61, 9.1351, 57.3893, 95.2433, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 2, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 3, 22.29, 37, 6.2333, 12.1497, 37.3113, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 4, 21.96, 37, 8.3841, 9.4482, 43.1489, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 5, 38.99, 37, 14.9587, 15.1498, 69.5871, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 6, 10.40, 37, 5.9160, 3.1052, 29.6095, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 7, 6.35, 37, 4.2767, 1.5519, 22.5739, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'IM', NULL, 4.20, 38, 0.1488, 3.9024, 4.5055, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'RT', NULL, 72.26, 60, 5.2255, 60.7283, 81.4464, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 1, 0.00, 56, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 2, 6.51, 56, 4.0403, 1.8069, 20.8482, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 3, 10.01, 56, 3.2359, 5.1327, 18.5966, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 4, 9.22, 56, 6.5007, 2.0955, 32.5088, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 5, 59.89, 56, 7.1536, 45.1153, 73.0576, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 6, 7.52, 56, 3.7549, 2.6790, 19.3496, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 7, 6.87, 56, 4.7353, 1.6435, 24.5383, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'IM', NULL, 4.13, 55, 0.1043, 3.9195, 4.3376, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'RT', NULL, 79.80, 61, 10.4050, 52.0667, 93.4950, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 1, 45.92, 54, 8.1876, 30.4767, 62.1959, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 2, 44.88, 54, 6.7790, 31.9690, 58.5184, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 3, 8.07, 54, 5.0828, 2.1729, 25.7562, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 4, 0.00, 54, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 5, 0.00, 54, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 6, 1.13, 54, 1.2427, 0.1217, 9.6409, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 7, 0.00, 54, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'IM', NULL, 3.78, 50, 0.2148, 3.3434, 4.2068, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'RT', NULL, 91.26, 60, 4.9634, 75.0377, 97.3150, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 1, 14.75, 39, 3.8605, 8.5045, 24.3650, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 2, 29.85, 39, 7.0637, 17.6912, 45.7209, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 3, 30.36, 39, 15.6264, 8.8934, 66.0590, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 4, 17.12, 39, 4.5474, 9.7421, 28.3234, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 5, 0.58, 39, 0.6168, 0.0679, 4.8136, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 6, 0.00, 39, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 7, 7.34, 39, 4.9524, 1.7835, 25.6995, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'IM', NULL, 3.61, 37, 0.1500, 3.3060, 3.9143, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'RT', NULL, 70.10, 59, 9.1655, 49.4224, 84.9119, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 1, 19.85, 46, 7.5071, 8.7375, 39.0470, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 2, 39.45, 46, 10.0906, 21.7642, 60.4020, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 3, 25.41, 46, 6.5252, 14.5489, 40.5276, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 4, 5.35, 46, 4.1110, 1.0919, 22.4727, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 5, 9.94, 46, 5.3667, 3.1961, 26.9640, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 6, 0.00, 46, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 7, 0.00, 46, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'IM', NULL, 3.47, 43, 0.3517, 2.7607, 4.1804, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'RT', NULL, 79.15, 61, 5.4432, 66.2483, 88.0180, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 1, 9.75, 31, 5.4390, 2.9692, 27.6286, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 2, 27.72, 31, 10.4094, 11.7159, 52.5620, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 3, 30.47, 31, 16.2176, 8.4093, 67.6651, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 4, 4.88, 31, 4.1928, 0.8045, 24.5029, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 5, 22.95, 31, 9.4726, 9.0721, 47.0773, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 6, 0.39, 31, 0.4272, 0.0406, 3.5932, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 7, 3.83, 31, 3.6812, 0.5157, 23.4549, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'IM', NULL, 4.38, 29, 0.1880, 3.9913, 4.7613, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'RT', NULL, 52.24, 61, 9.2381, 34.2759, 69.6413, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 1, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 2, 41.15, 15, 21.1687, 9.6844, 82.0092, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 3, 32.87, 15, 12.3135, 12.8873, 61.8408, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 4, 1.78, 15, 1.5044, 0.2833, 10.3128, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 5, 24.21, 15, 10.8831, 8.2151, 53.2677, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 6, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 7, 0.00, 15, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'IM', NULL, 4.24, 13, 0.3222, 3.5351, 4.9393, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'RT', NULL, 34.46, 61, 9.0280, 19.1134, 53.9071, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 1, 5.88, 27, 5.3377, 0.8516, 31.2163, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 2, 1.37, 27, 1.2615, 0.2044, 8.6354, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 3, 11.00, 27, 7.1712, 2.6700, 35.7762, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 4, 31.50, 27, 11.2396, 13.6149, 57.2931, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 5, 33.11, 27, 5.6103, 22.7265, 45.4515, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 6, 5.88, 27, 5.3377, 0.8516, 31.2163, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 7, 11.26, 27, 7.0419, 2.8956, 35.0726, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'IM', NULL, 4.14, 25, 0.2261, 3.6773, 4.6106, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'RT', NULL, 43.38, 61, 9.7610, 25.7058, 62.9144, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 1, 24.88, 39, 17.4712, 4.7544, 68.7266, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 2, 1.41, 39, 1.4858, 0.1635, 11.0812, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 3, 11.85, 39, 5.7424, 4.2297, 29.0314, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 4, 10.18, 39, 5.6958, 3.1107, 28.5704, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 5, 34.36, 39, 10.5121, 16.9252, 57.3512, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 6, 17.33, 39, 5.8247, 8.4253, 32.3112, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 7, 0.00, 39, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'IM', NULL, 4.09, 38, 0.2825, 3.5212, 4.6660, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'RT', NULL, 47.62, 61, 9.6700, 29.5119, 66.3801, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 1, 4.90, 25, 4.4159, 0.7251, 26.6885, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 2, 32.46, 25, 16.0973, 9.5515, 68.6266, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 3, 38.29, 25, 10.5799, 19.7588, 60.9885, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 4, 9.81, 25, 5.4213, 2.9778, 27.8107, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 5, 5.14, 25, 4.3064, 0.8686, 25.1108, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 6, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 7, 9.40, 25, 7.4511, 1.6755, 38.7012, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'IM', NULL, 4.04, 25, 0.2498, 3.5282, 4.5592, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'RT', NULL, 51.99, 61, 8.4779, 35.4367, 68.1119, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 1, 0.00, 39, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 2, 6.16, 39, 4.9461, 1.1489, 27.0609, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 3, 9.62, 39, 6.8995, 2.0928, 34.6629, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 4, 26.55, 39, 10.0211, 11.3239, 50.5661, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 5, 44.46, 39, 13.6302, 20.7494, 70.9882, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 6, 6.62, 39, 5.4703, 1.1701, 29.8272, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 7, 6.59, 39, 5.4428, 1.1622, 29.7106, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'IM', NULL, 3.98, 38, 0.2037, 3.5689, 4.3945, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'RT', NULL, 44.60, 61, 11.9131, 23.4813, 67.8645, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 1, 7.66, 30, 5.3058, 1.7574, 27.7821, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 2, 36.83, 30, 12.7910, 15.9228, 64.2194, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 3, 18.32, 30, 6.0050, 8.9864, 33.7608, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 4, 16.53, 30, 5.9211, 7.6035, 32.2623, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 5, 12.85, 30, 4.6194, 5.9605, 25.5254, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 6, 0.00, 30, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 7, 7.82, 30, 4.9957, 2.0122, 25.9314, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'IM', NULL, 3.82, 29, 0.2360, 3.3394, 4.3063, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'RT', NULL, 64.14, 60, 8.3809, 46.3149, 78.7608, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 1, 0.00, 42, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 2, 19.97, 42, 10.2031, 6.4299, 47.5295, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 3, 24.97, 42, 6.9040, 13.6518, 41.1919, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 4, 20.89, 42, 6.9106, 10.1907, 38.0574, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 5, 18.23, 42, 5.0047, 10.1700, 30.5202, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 6, 15.25, 42, 7.0170, 5.6687, 35.0079, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 7, 0.69, 42, 0.7064, 0.0877, 5.2559, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'IM', NULL, 3.76, 41, 0.1706, 3.4135, 4.1032, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'RT', NULL, 49.85, 61, 17.8158, 19.2879, 80.5271, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 1, 5.88, 33, 5.3749, 0.8555, 31.1230, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 2, 24.13, 33, 8.3611, 11.1484, 44.6401, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 3, 33.41, 33, 5.7840, 22.8110, 46.0096, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 4, 22.95, 33, 12.2433, 6.7790, 54.9643, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 5, 13.62, 33, 7.2687, 4.2891, 35.6929, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 6, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 7, 0.00, 33, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'IM', NULL, 3.65, 32, 0.1127, 3.4195, 3.8793, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'RT', NULL, 43.32, 61, 7.9198, 28.6209, 59.3029, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 1, 5.92, 31, 4.7428, 1.0934, 26.3725, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 2, 17.27, 31, 11.6733, 3.7840, 52.5482, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 3, 18.47, 31, 4.9155, 10.4161, 30.6122, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 4, 18.66, 31, 6.3379, 8.9052, 34.9888, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 5, 27.01, 31, 10.3553, 11.2343, 51.9626, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 6, 12.68, 31, 5.6544, 4.8700, 29.1824, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 7, 0.00, 31, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'IM', NULL, 3.61, 31, 0.2277, 3.1497, 4.0797, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'RT', NULL, 45.61, 61, 12.0125, 24.1464, 68.8380, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 1, 24.18, 17, 14.9956, 5.3314, 64.3626, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 2, 1.04, 17, 1.0718, 0.1147, 8.7428, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 3, 41.56, 17, 19.1665, 11.7786, 79.1199, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 4, 30.60, 17, 16.5100, 7.8223, 69.6199, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 5, 2.61, 17, 2.6714, 0.2896, 19.8852, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 6, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 7, 0.00, 17, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'IM', NULL, 3.18, 16, 0.3475, 2.4410, 3.9223, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'RT', NULL, 25.66, 61, 5.2817, 16.5504, 37.5187, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 2, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 3, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 4, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 5, 41.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'IM', NULL, 4.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'RT', NULL, 96.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 1, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 2, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 3, 16.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 4, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 5, 48.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 6, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 7, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'IM', NULL, 4.48, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'RT', NULL, 100.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 1, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 2, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 3, 28.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 4, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 5, 28.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 6, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'IM', NULL, 4.44, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'RT', NULL, 100.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 1, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 2, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 3, 20.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 4, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 5, 40.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 6, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 7, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'IM', NULL, 4.40, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'RT', NULL, 100.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 2, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 3, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 4, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 5, 50.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 6, 25.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 7, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'IM', NULL, 4.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'RT', NULL, 96.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 1, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 2, 70.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 3, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 4, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 5, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'IM', NULL, 4.25, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'RT', NULL, 96.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 1, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 2, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 3, 39.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 4, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'IM', NULL, 4.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'RT', NULL, 92.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 1, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 3, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 4, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 5, 55.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'IM', NULL, 4.20, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'RT', NULL, 80.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 2, 59.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 3, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 4, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 5, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'IM', NULL, 4.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'RT', NULL, 88.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 1, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 2, 41.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 3, 25.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 4, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 5, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'IM', NULL, 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'RT', NULL, 96.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 2, 37.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 3, 41.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 4, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 5, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'IM', NULL, 4.08, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'RT', NULL, 96.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 1, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 2, 52.63, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 3, 26.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 4, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 5, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'IM', NULL, 4.06, 18, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'RT', NULL, 76.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 1, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 2, 32.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 3, 44.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 4, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 5, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 6, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'IM', NULL, 4.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'RT', NULL, 100.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 1, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 2, 50.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 3, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 4, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 5, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 7, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'IM', NULL, 4.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 2, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 3, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 4, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 5, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'IM', NULL, 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'RT', NULL, 80.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 2, 65.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 3, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 4, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 5, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'IM', NULL, 3.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'RT', NULL, 87.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 1, 36.36, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 2, 45.45, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 3, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 4, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 5, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 6, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 7, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'IM', NULL, 4.45, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'RT', NULL, 45.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 1, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 2, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 3, 13.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 4, 13.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 5, 60.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 6, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 7, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'IM', NULL, 4.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'RT', NULL, 62.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 1, 14.29, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 2, 71.43, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 3, 14.29, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 4, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 5, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 6, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 7, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'IM', NULL, 4.14, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'RT', NULL, 28.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 1, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 2, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 3, 57.14, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 4, 14.29, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 5, 28.57, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 6, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 7, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'IM', NULL, 4.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'RT', NULL, 28.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 1, 16.67, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 2, 33.33, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 3, 33.33, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 4, 16.67, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 5, 0.00, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 6, 0.00, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 7, 0.00, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'IM', NULL, 3.75, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'RT', NULL, 48.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 1, 45.45, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 2, 36.36, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 3, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 4, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 5, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 6, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 7, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'IM', NULL, 3.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'RT', NULL, 44.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 1, 0.00, 75, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 2, 1.62, 75, 1.5387, 0.2385, 10.1483, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 3, 3.38, 75, 1.9367, 1.0616, 10.2364, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 4, 8.10, 75, 3.6318, 3.2286, 18.8983, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 5, 29.18, 75, 5.5059, 19.5073, 41.2006, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 6, 8.46, 75, 3.5677, 3.5580, 18.7928, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 7, 49.26, 75, 7.1502, 35.4429, 63.1904, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'IM', NULL, 4.81, 73, 0.0689, 4.6748, 4.9494, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'RT', NULL, 91.17, 81, 5.1945, 74.0870, 97.3859, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 1, 3.42, 73, 2.1944, 0.9341, 11.7481, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 2, 10.52, 73, 4.9434, 3.9647, 25.0894, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 3, 7.01, 73, 3.1936, 2.7589, 16.6790, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 4, 8.35, 73, 5.2219, 2.2835, 26.2029, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 5, 35.78, 73, 6.6710, 23.7981, 49.8436, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 6, 11.35, 73, 3.8962, 5.5842, 21.6931, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 7, 23.57, 73, 7.6096, 11.7315, 41.7220, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'IM', NULL, 4.61, 72, 0.1241, 4.3607, 4.8557, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'RT', NULL, 86.10, 81, 5.5899, 70.9760, 94.0118, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 1, 2.47, 78, 2.2480, 0.3914, 13.9880, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 2, 4.38, 78, 2.5803, 1.3223, 13.5123, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 3, 11.04, 78, 3.1624, 6.1347, 19.0696, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 4, 5.79, 78, 3.5157, 1.6758, 18.1528, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 5, 44.13, 78, 5.0320, 34.4707, 54.2505, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 6, 17.04, 78, 4.7913, 9.4660, 28.7404, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 7, 15.16, 78, 5.3287, 7.2645, 28.9661, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'IM', NULL, 4.56, 79, 0.0688, 4.4219, 4.6957, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'RT', NULL, 98.06, 81, 1.5184, 91.1663, 99.5982, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 1, 1.90, 64, 1.9522, 0.2372, 13.5909, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 2, 5.60, 64, 3.3111, 1.6670, 17.1776, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 3, 12.14, 64, 3.8246, 6.3255, 22.0538, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 4, 9.63, 64, 4.3546, 3.7726, 22.4593, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 5, 27.40, 64, 6.7598, 16.0601, 42.6661, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 6, 18.91, 64, 5.8963, 9.7574, 33.4583, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 7, 24.43, 64, 9.1302, 10.7385, 46.4797, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'IM', NULL, 4.48, 64, 0.1742, 4.1324, 4.8288, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'RT', NULL, 74.46, 81, 8.5481, 54.3769, 87.7034, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 1, 4.58, 72, 2.4039, 1.5770, 12.5670, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 2, 17.73, 72, 5.6221, 9.0832, 31.7280, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 3, 18.29, 72, 4.4684, 10.9776, 28.8917, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 4, 13.59, 72, 5.0219, 6.2842, 26.9528, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 5, 20.87, 72, 4.1946, 13.7145, 30.4426, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 6, 6.00, 72, 3.2854, 1.9555, 16.9383, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 7, 18.95, 72, 5.6810, 10.0549, 32.8303, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'IM', NULL, 4.47, 73, 0.1141, 4.2473, 4.7020, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'RT', NULL, 91.91, 81, 4.1052, 79.1083, 97.1497, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 1, 1.64, 74, 1.5637, 0.2429, 10.2989, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 2, 5.26, 74, 3.2087, 1.5153, 16.6904, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 3, 7.69, 74, 3.3673, 3.1348, 17.6556, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 4, 13.75, 74, 3.7159, 7.8703, 22.9430, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 5, 35.65, 74, 6.1416, 24.5276, 48.5779, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 6, 15.71, 74, 4.6437, 8.4766, 27.2653, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 7, 20.29, 74, 7.3942, 9.2853, 38.7686, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'IM', NULL, 4.38, 74, 0.1153, 4.1544, 4.6139, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'RT', NULL, 89.62, 81, 4.0577, 78.3768, 95.3661, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 1, 1.18, 76, 0.9229, 0.2484, 5.4525, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 2, 11.21, 76, 4.6963, 4.6982, 24.4234, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 3, 39.32, 76, 6.7646, 26.9182, 53.2664, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 4, 24.12, 76, 6.0002, 14.1993, 37.9223, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 5, 6.71, 76, 3.5609, 2.2638, 18.2588, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 6, 10.29, 76, 4.7818, 3.9299, 24.3533, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 7, 7.16, 76, 3.3441, 2.7537, 17.3623, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'IM', NULL, 4.23, 76, 0.1035, 4.0195, 4.4319, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'RT', NULL, 92.21, 81, 3.2878, 82.6423, 96.7168, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 1, 9.80, 68, 3.7623, 4.4378, 20.2587, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 2, 19.65, 68, 4.9929, 11.5151, 31.4975, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 3, 14.80, 68, 5.1713, 7.1143, 28.2545, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 4, 9.19, 68, 3.3780, 4.3200, 18.5042, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 5, 21.15, 68, 4.7896, 13.1355, 32.2441, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 6, 15.17, 68, 3.9744, 8.8071, 24.8852, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 7, 10.23, 68, 3.6712, 4.8821, 20.1985, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'IM', NULL, 4.22, 69, 0.1230, 3.9757, 4.4665, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'RT', NULL, 88.32, 80, 3.2064, 80.2853, 93.3471, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 1, 14.31, 63, 4.2038, 7.7593, 24.8874, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 2, 31.40, 63, 6.8638, 19.4870, 46.3900, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 3, 19.66, 63, 5.5437, 10.8216, 33.0482, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 4, 19.64, 63, 5.6493, 10.6728, 33.3258, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 5, 4.24, 63, 3.0996, 0.9507, 16.9272, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 6, 4.82, 63, 3.2190, 1.2324, 17.0711, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 7, 5.94, 63, 3.4689, 1.7915, 17.9300, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'IM', NULL, 4.22, 64, 0.1942, 3.8291, 4.6054, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'RT', NULL, 79.83, 81, 6.8336, 62.9715, 90.2025, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 1, 1.18, 76, 0.9184, 0.2498, 5.4154, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 2, 20.97, 76, 5.3584, 12.2334, 33.5709, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 3, 12.74, 76, 5.2850, 5.3613, 27.3479, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 4, 14.83, 76, 4.5806, 7.7995, 26.3980, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 5, 27.70, 76, 5.8936, 17.5721, 40.7782, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 6, 12.66, 76, 4.3353, 6.2232, 24.0425, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 7, 9.91, 76, 3.7971, 4.4999, 20.4223, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'IM', NULL, 4.05, 76, 0.1055, 3.8412, 4.2614, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'RT', NULL, 93.22, 80, 3.1244, 83.7116, 97.3496, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 1, 32.47, 69, 7.3853, 19.7116, 48.4957, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 2, 43.69, 69, 6.8752, 30.7584, 57.5389, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 3, 15.56, 69, 4.9995, 7.9373, 28.2494, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 4, 3.07, 69, 2.2610, 0.6899, 12.6094, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 5, 5.22, 69, 2.8811, 1.6906, 14.9697, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 6, 0.00, 69, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 7, 0.00, 69, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'IM', NULL, 3.99, 69, 0.1415, 3.7054, 4.2701, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'RT', NULL, 86.46, 81, 3.6872, 77.3371, 92.2827, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 1, 9.30, 65, 4.9662, 3.0662, 24.9482, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 2, 26.51, 65, 6.1556, 16.0975, 40.4077, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 3, 15.03, 65, 6.2004, 6.2813, 31.8116, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 4, 13.04, 65, 6.0863, 4.8790, 30.4649, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 5, 23.59, 65, 5.7802, 13.9912, 36.9416, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 6, 4.43, 65, 2.8853, 1.1717, 15.3190, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 7, 8.11, 65, 3.4341, 3.3997, 18.1417, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'IM', NULL, 3.79, 65, 0.1302, 3.5325, 4.0528, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'RT', NULL, 85.23, 81, 3.9650, 75.5060, 91.5223, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 1, 51.89, 61, 9.4526, 33.5824, 69.6954, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 2, 29.66, 61, 6.2294, 18.8370, 43.3847, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 3, 9.95, 61, 3.5739, 4.7365, 19.7011, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 4, 8.51, 61, 3.5329, 3.6139, 18.7329, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 5, 0.00, 61, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 6, 0.00, 61, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 7, 0.00, 61, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'IM', NULL, 3.76, 60, 0.1138, 3.5284, 3.9836, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'RT', NULL, 77.60, 81, 6.4117, 62.4466, 87.8341, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 1, 16.89, 54, 5.6275, 8.3355, 31.2304, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 2, 24.08, 54, 7.3672, 12.3849, 41.5820, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 3, 39.54, 54, 5.0726, 29.9420, 50.0275, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 4, 4.81, 54, 4.9101, 0.5838, 30.2846, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 5, 13.31, 54, 3.8655, 7.2689, 23.1122, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 6, 0.00, 54, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 7, 1.37, 54, 0.9721, 0.3267, 5.5546, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'IM', NULL, 3.72, 54, 0.1274, 3.4646, 3.9756, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'RT', NULL, 70.97, 81, 6.5774, 56.4297, 82.1905, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 1, 14.83, 53, 6.4142, 5.9163, 32.5440, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 2, 40.56, 53, 9.0404, 24.3271, 59.1489, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 3, 28.46, 53, 4.7579, 19.9342, 38.8729, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 4, 8.94, 53, 4.2075, 3.3628, 21.6894, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 5, 0.65, 53, 0.6299, 0.0929, 4.4191, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 6, 3.28, 53, 2.9644, 0.5161, 18.1197, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 7, 3.28, 53, 2.9728, 0.5133, 18.1994, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'IM', NULL, 3.57, 54, 0.2100, 3.1530, 3.9953, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'RT', NULL, 72.35, 81, 6.4276, 57.9956, 83.2232, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 1, 14.11, 40, 5.0733, 6.5806, 27.6988, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 2, 27.00, 40, 5.3511, 17.5984, 39.0431, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 3, 17.16, 40, 6.2022, 7.8939, 33.3629, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 4, 8.65, 40, 4.7815, 2.7095, 24.3576, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 5, 22.51, 40, 5.9814, 12.6735, 36.7551, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 6, 3.38, 40, 2.8908, 0.5797, 17.3342, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 7, 7.20, 40, 4.8309, 1.7633, 25.0909, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'IM', NULL, 3.79, 41, 0.1794, 3.4268, 4.1521, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'RT', NULL, 55.15, 79, 7.5202, 40.1651, 69.2530, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 1, 6.25, 45, 4.3073, 1.4931, 22.6781, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 2, 53.43, 45, 11.8773, 30.4776, 75.0140, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 3, 12.63, 45, 4.5954, 5.8809, 25.0742, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 4, 13.55, 45, 6.3635, 4.9855, 31.9017, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 5, 6.94, 45, 4.2432, 1.9459, 21.8941, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 6, 3.91, 45, 3.7233, 0.5491, 23.0680, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 7, 3.28, 45, 2.5110, 0.6851, 14.3156, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'IM', NULL, 3.70, 45, 0.1867, 3.3219, 4.0744, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'RT', NULL, 61.18, 79, 5.1354, 50.6085, 70.7913, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 1, 17.94, 45, 6.9282, 7.8093, 36.0804, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 2, 39.44, 45, 7.6133, 25.5167, 55.3187, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 3, 20.09, 45, 5.7735, 10.8560, 34.1656, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 4, 5.33, 45, 4.2132, 1.0351, 23.2511, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 5, 12.48, 45, 5.8328, 4.6385, 29.4956, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 6, 0.61, 45, 0.6209, 0.0798, 4.5750, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 7, 4.10, 45, 3.7369, 0.6255, 22.4995, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'IM', NULL, 3.58, 46, 0.1702, 3.2365, 3.9222, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'RT', NULL, 58.50, 80, 5.7100, 46.8820, 69.2407, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 1, 19.13, 44, 9.1166, 6.7240, 43.7050, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 2, 25.72, 44, 8.1563, 12.7698, 45.0275, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 3, 17.55, 44, 6.4279, 7.9980, 34.2724, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 4, 13.60, 44, 7.9412, 3.8713, 38.0837, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 5, 11.29, 44, 4.7337, 4.6762, 24.8190, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 6, 0.00, 44, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 7, 12.71, 44, 6.3029, 4.4230, 31.4064, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'IM', NULL, 3.54, 43, 0.1967, 3.1451, 3.9391, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'RT', NULL, 55.71, 81, 5.1935, 45.2754, 65.6604, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 1, 11.03, 41, 4.7789, 4.4277, 24.9089, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 2, 28.15, 41, 9.7431, 12.8905, 50.9131, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 3, 19.42, 41, 3.8479, 12.7904, 28.3774, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 4, 6.13, 41, 4.4061, 1.3703, 23.4845, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 5, 31.97, 41, 10.6378, 14.8855, 55.8092, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 6, 3.30, 41, 3.2263, 0.4390, 20.8593, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 7, 0.00, 41, 0.0000, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'IM', NULL, 3.47, 41, 0.2352, 2.9954, 3.9463, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'RT', NULL, 60.96, 81, 7.2979, 45.8913, 74.1880, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 1, 3.55, 100, 1.6412, 1.4042, 8.6997, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 2, 6.85, 100, 3.0027, 2.8126, 15.7613, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 3, 11.62, 100, 5.5023, 4.3424, 27.5709, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 4, 15.75, 100, 3.9269, 9.4150, 25.1681, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 5, 38.96, 100, 4.9046, 29.7666, 49.0011, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 6, 15.59, 100, 5.5993, 7.3548, 30.0522, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 7, 7.68, 100, 2.5224, 3.9437, 14.4203, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'IM', NULL, 4.01, 101, 0.1057, 3.7976, 4.2172, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'RT', NULL, 88.43, 115, 3.5689, 79.2973, 93.8505, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 1, 1.97, 106, 1.9859, 0.2617, 13.3625, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 2, 2.06, 106, 2.0041, 0.2917, 13.1112, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 3, 11.22, 106, 4.0925, 5.2999, 22.2042, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 4, 4.14, 106, 3.2094, 0.8596, 17.6783, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 5, 38.34, 106, 6.9967, 25.6923, 52.7888, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 6, 29.06, 106, 7.2107, 16.9902, 45.0391, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 7, 13.22, 106, 3.4609, 7.7274, 21.6946, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'IM', NULL, 4.00, 108, 0.0976, 3.8111, 4.1979, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'RT', NULL, 94.20, 115, 2.5594, 86.5246, 97.6232, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 1, 0.00, 108, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 2, 6.83, 108, 3.4709, 2.4283, 17.7730, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 3, 12.84, 108, 4.0464, 6.7143, 23.1783, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 4, 15.40, 108, 3.9036, 9.1358, 24.7974, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 5, 42.72, 108, 5.1706, 32.9089, 53.1330, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 6, 14.98, 108, 5.0520, 7.4273, 27.8903, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 7, 7.23, 108, 2.9758, 3.1293, 15.8088, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'IM', NULL, 3.99, 109, 0.1114, 3.7673, 4.2087, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'RT', NULL, 96.31, 115, 2.0196, 89.4373, 98.7694, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 1, 0.00, 111, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 2, 8.39, 111, 3.7507, 3.3672, 19.4139, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 3, 10.04, 111, 4.1745, 4.2779, 21.8109, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 4, 21.02, 111, 5.3928, 12.2694, 33.6298, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 5, 38.65, 111, 6.7777, 26.3329, 52.6037, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 6, 19.35, 111, 5.9204, 10.1634, 33.7247, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 7, 2.54, 111, 1.4846, 0.7901, 7.8788, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'IM', NULL, 3.85, 111, 0.0692, 3.7149, 3.9894, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'RT', NULL, 97.39, 115, 1.8348, 89.9273, 99.3638, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 1, 7.94, 102, 3.8157, 2.9694, 19.5444, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 2, 25.94, 102, 8.3242, 12.9155, 45.2776, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 3, 17.63, 102, 5.0111, 9.7408, 29.7932, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 4, 16.31, 102, 7.2607, 6.3553, 35.8913, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 5, 23.20, 102, 6.2736, 13.0607, 37.7866, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 6, 5.94, 102, 2.5452, 2.4944, 13.4875, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 7, 3.04, 102, 2.2203, 0.6987, 12.2586, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'IM', NULL, 3.85, 104, 0.1022, 3.6488, 4.0542, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'RT', NULL, 90.21, 115, 3.5914, 80.4610, 95.3783, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 1, 0.09, 104, 0.0879, 0.0115, 0.6474, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 2, 13.27, 104, 4.5017, 6.5788, 24.9436, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 3, 18.66, 104, 6.3173, 9.1304, 34.3704, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 4, 9.88, 104, 3.2980, 4.9939, 18.6007, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 5, 47.58, 104, 6.8093, 34.5614, 60.9340, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 6, 6.87, 104, 3.3664, 2.5315, 17.3169, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 7, 3.66, 104, 2.2076, 1.0865, 11.6213, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'IM', NULL, 3.80, 103, 0.1077, 3.5867, 4.0138, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'RT', NULL, 89.85, 115, 3.6042, 80.1833, 95.0907, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 1, 2.05, 104, 2.0811, 0.2660, 14.0690, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 2, 5.70, 104, 2.8637, 2.0600, 14.8131, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 3, 13.92, 104, 4.6765, 6.9404, 25.9632, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 4, 16.84, 104, 4.5907, 9.5569, 27.9489, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 5, 47.99, 104, 7.3274, 34.0156, 62.2893, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 6, 6.84, 104, 3.4383, 2.4597, 17.6341, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 7, 6.66, 104, 4.2151, 1.8231, 21.4965, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'IM', NULL, 3.72, 107, 0.1303, 3.4624, 3.9793, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'RT', NULL, 90.11, 115, 3.1740, 81.8153, 94.8573, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 1, 7.88, 86, 2.8070, 3.8111, 15.5766, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 2, 21.29, 86, 6.1311, 11.5559, 35.8899, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 3, 25.37, 86, 5.2006, 16.4540, 36.9892, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 4, 16.10, 86, 5.1873, 8.2125, 29.1706, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 5, 22.44, 86, 5.9443, 12.7966, 36.3307, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 6, 6.91, 86, 3.9154, 2.1678, 19.9346, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 7, 0.00, 86, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'IM', NULL, 3.57, 89, 0.1227, 3.3308, 3.8184, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'RT', NULL, 78.31, 114, 3.8192, 69.8092, 84.9295, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 1, 7.72, 93, 2.9971, 3.4985, 16.1707, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 2, 18.76, 93, 3.8153, 12.3161, 27.5187, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 3, 11.85, 93, 4.6018, 5.3047, 24.3821, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 4, 11.05, 93, 4.9589, 4.3635, 25.2828, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 5, 45.15, 93, 6.0846, 33.5725, 57.2860, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 6, 5.47, 93, 2.5810, 2.1009, 13.4897, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 7, 0.00, 93, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'IM', NULL, 3.56, 95, 0.1257, 3.3062, 3.8053, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'RT', NULL, 84.43, 115, 3.5941, 75.9332, 90.3115, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 1, 4.42, 89, 2.3826, 1.4842, 12.4221, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 2, 24.87, 89, 4.7386, 16.6669, 35.4003, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 3, 22.51, 89, 6.2450, 12.4770, 37.1721, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 4, 15.67, 89, 4.8278, 8.2512, 27.7510, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 5, 20.11, 89, 4.4015, 12.7389, 30.2554, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 6, 8.41, 89, 3.2797, 3.7881, 17.6266, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 7, 4.02, 89, 2.5906, 1.0898, 13.7235, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'IM', NULL, 3.47, 89, 0.1123, 3.2480, 3.6945, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'RT', NULL, 78.12, 114, 4.6362, 67.5975, 85.9376, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 1, 11.51, 100, 5.0536, 4.6345, 25.8235, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 2, 25.49, 100, 5.8414, 15.6736, 38.6446, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 3, 21.79, 100, 4.9364, 13.5582, 33.1129, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 4, 19.10, 100, 4.9456, 11.1187, 30.8214, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 5, 18.84, 100, 4.8446, 11.0175, 30.3288, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 6, 1.21, 100, 1.1649, 0.1785, 7.7871, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 7, 2.05, 100, 1.9897, 0.2919, 13.0085, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'IM', NULL, 3.44, 98, 0.1090, 3.2251, 3.6576, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'RT', NULL, 87.56, 114, 3.6506, 78.3718, 93.1856, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 1, 2.43, 94, 1.5932, 0.6517, 8.6406, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 2, 16.89, 94, 4.7895, 9.3536, 28.5779, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 3, 32.08, 94, 5.2158, 22.7014, 43.1782, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 4, 12.51, 94, 4.1763, 6.2813, 23.3746, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 5, 29.00, 94, 4.9801, 20.1736, 39.7729, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 6, 1.04, 94, 1.0572, 0.1361, 7.4841, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 7, 6.05, 94, 3.2284, 2.0387, 16.5923, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'IM', NULL, 3.28, 96, 0.1195, 3.0469, 3.5215, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'RT', NULL, 81.42, 115, 3.7660, 72.7972, 87.7680, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 1, 11.88, 44, 5.5969, 4.3883, 28.3820, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 2, 16.49, 44, 5.5074, 8.1000, 30.6677, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 3, 47.54, 44, 9.2755, 29.9770, 65.7393, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 4, 19.26, 44, 7.7412, 8.0348, 39.4273, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 5, 0.00, 44, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 6, 0.00, 44, 0.0000, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 7, 4.83, 44, 4.4899, 0.7022, 26.6842, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'IM', NULL, 3.53, 44, 0.1512, 3.2201, 3.8300, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'RT', NULL, 37.41, 114, 4.8898, 28.3271, 47.4812, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 1, 12.55, 48, 5.3320, 5.1219, 27.6073, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 2, 28.04, 48, 7.7602, 15.2321, 45.7867, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 3, 10.92, 48, 5.4929, 3.7867, 27.6283, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 4, 8.38, 48, 5.4788, 2.1303, 27.7634, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 5, 25.40, 48, 7.4453, 13.3775, 42.8743, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 6, 5.38, 48, 4.1580, 1.0892, 22.7184, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 7, 9.34, 48, 5.9068, 2.4673, 29.5376, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'IM', NULL, 4.61, 47, 0.1506, 4.3085, 4.9148, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'RT', NULL, 72.97, 59, 7.1391, 56.6769, 84.7849, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 1, 3.91, 58, 3.5304, 0.6161, 21.0799, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 2, 20.03, 58, 6.3968, 10.1185, 35.7841, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 3, 44.50, 58, 7.0801, 31.1115, 58.7392, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 4, 15.93, 58, 4.7057, 8.5713, 27.6906, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 5, 13.00, 58, 5.8992, 4.9974, 29.8083, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 6, 2.63, 58, 1.9530, 0.5816, 11.0670, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 7, 0.00, 58, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'IM', NULL, 4.35, 57, 0.0928, 4.1595, 4.5314, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'RT', NULL, 98.75, 59, 1.2803, 90.8579, 99.8400, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 1, 0.00, 56, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 2, 6.16, 56, 4.3301, 1.4413, 22.7539, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 3, 15.33, 56, 5.2879, 7.4135, 29.0621, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 4, 13.02, 56, 5.2241, 5.6083, 27.3954, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 5, 41.56, 56, 8.6287, 25.8657, 59.1708, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 6, 11.23, 56, 5.7758, 3.8133, 28.7756, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 7, 12.69, 56, 4.1887, 6.3804, 23.6687, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'IM', NULL, 4.33, 56, 0.1093, 4.1083, 4.5465, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'RT', NULL, 93.61, 59, 3.7942, 80.4506, 98.1190, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 1, 6.99, 58, 4.0342, 2.1242, 20.6575, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 2, 13.87, 58, 4.8661, 6.6500, 26.6893, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 3, 16.67, 58, 8.0970, 5.8633, 39.1283, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 4, 18.08, 58, 4.4583, 10.7807, 28.7408, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 5, 22.99, 58, 4.9759, 14.5352, 34.3889, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 6, 19.62, 58, 5.6988, 10.5876, 33.4810, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 7, 1.77, 58, 1.7897, 0.2275, 12.4209, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'IM', NULL, 4.24, 57, 0.1070, 4.0268, 4.4556, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'RT', NULL, 98.78, 59, 1.2499, 91.0635, 99.8438, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 1, 0.00, 54, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 2, 7.39, 54, 4.7542, 1.9399, 24.3270, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 3, 23.84, 54, 7.0490, 12.5606, 40.5435, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 4, 22.44, 54, 6.8115, 11.6624, 38.8157, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 5, 17.98, 54, 6.3196, 8.4933, 34.1154, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 6, 15.53, 54, 6.6001, 6.2828, 33.5272, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 7, 12.82, 54, 4.2637, 6.4029, 24.0155, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'IM', NULL, 4.23, 54, 0.0828, 4.0603, 4.3923, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'RT', NULL, 90.71, 59, 4.1187, 78.5911, 96.2947, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 1, 0.00, 55, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 2, 3.10, 55, 2.1064, 0.7811, 11.5380, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 3, 25.52, 55, 8.6202, 12.1312, 45.9659, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 4, 20.94, 55, 5.7552, 11.6534, 34.7140, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 5, 26.55, 55, 7.5261, 14.2910, 43.9345, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 6, 16.44, 55, 5.1140, 8.5300, 29.3269, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 7, 7.45, 55, 4.9805, 1.8538, 25.5180, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'IM', NULL, 4.22, 55, 0.1079, 3.9994, 4.4321, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'RT', NULL, 89.94, 59, 6.7736, 66.6421, 97.5609, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 1, 0.00, 51, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 2, 0.30, 51, 0.3146, 0.0376, 2.4005, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 3, 11.76, 51, 7.9891, 2.7599, 38.4860, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 4, 9.29, 51, 3.6846, 4.0788, 19.7715, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 5, 38.35, 51, 7.9118, 24.1062, 54.9195, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 6, 19.10, 51, 8.0946, 7.6190, 40.3420, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 7, 21.20, 51, 4.7963, 13.1272, 32.3808, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'IM', NULL, 4.20, 51, 0.1160, 3.9641, 4.4300, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'RT', NULL, 83.25, 59, 8.6231, 59.0387, 94.4843, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 1, 6.52, 50, 3.4908, 2.1619, 18.0657, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 2, 15.91, 50, 6.9573, 6.2369, 34.9793, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 3, 4.52, 50, 3.3860, 0.9672, 18.6426, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 4, 17.81, 50, 4.6494, 10.2727, 29.0929, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 5, 30.57, 50, 8.4861, 16.4692, 49.5799, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 6, 18.41, 50, 6.5959, 8.5391, 35.2888, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 7, 6.26, 50, 3.2446, 2.1492, 16.8650, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'IM', NULL, 4.17, 49, 0.1337, 3.9048, 4.4425, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'RT', NULL, 84.07, 59, 7.4245, 63.4991, 94.1190, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 1, 0.00, 54, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 2, 18.34, 54, 7.2901, 7.8037, 37.3551, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 3, 23.78, 54, 7.1993, 12.3329, 40.9018, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 4, 16.12, 54, 5.4691, 7.8651, 30.1931, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 5, 32.09, 54, 6.8006, 20.1703, 46.9089, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 6, 0.30, 54, 0.3085, 0.0379, 2.3290, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 7, 9.37, 54, 3.3739, 4.4504, 18.6565, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'IM', NULL, 4.11, 54, 0.1300, 3.8481, 4.3697, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'RT', NULL, 91.04, 59, 4.4677, 77.2451, 96.8172, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 1, 0.00, 57, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 2, 8.70, 57, 4.4509, 3.0109, 22.6483, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 3, 18.99, 57, 7.8490, 7.7770, 39.4449, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 4, 32.43, 57, 7.8901, 18.9159, 49.6790, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 5, 25.48, 57, 5.5464, 16.0004, 38.0378, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 6, 5.39, 57, 3.0429, 1.6922, 15.8448, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 7, 9.01, 57, 4.9793, 2.8510, 25.0546, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'IM', NULL, 4.10, 57, 0.1031, 3.8969, 4.3099, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'RT', NULL, 97.22, 59, 2.0770, 88.2498, 99.3894, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 1, 15.91, 53, 5.6554, 7.4935, 30.6461, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 2, 22.30, 53, 7.8646, 10.3465, 41.6406, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 3, 32.25, 53, 8.0219, 18.5586, 49.8621, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 4, 28.04, 53, 8.0977, 14.8336, 46.5773, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 5, 1.50, 53, 1.0217, 0.3790, 5.7484, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 6, 0.00, 53, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 7, 0.00, 53, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'IM', NULL, 4.08, 52, 0.1408, 3.7955, 4.3608, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'RT', NULL, 89.51, 59, 6.4700, 68.2350, 97.1367, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 1, 0.00, 59, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 2, 15.06, 59, 5.9570, 6.5277, 31.0529, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 3, 21.78, 59, 7.0745, 10.8173, 39.0022, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 4, 29.06, 59, 7.9744, 15.8865, 47.0503, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 5, 21.97, 59, 8.0215, 9.9428, 41.8082, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 6, 7.19, 59, 4.5158, 1.9571, 23.0914, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 7, 4.93, 59, 3.0200, 1.4091, 15.8483, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'IM', NULL, 4.04, 59, 0.1152, 3.8056, 4.2667, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'RT', NULL, 100.00, 59, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 1, 16.12, 47, 11.3092, 3.4461, 50.8558, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 2, 7.59, 47, 5.6758, 1.5836, 29.5185, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 3, 13.93, 47, 6.9436, 4.8046, 34.1790, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 4, 20.40, 47, 7.0207, 9.6914, 37.9593, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 5, 23.33, 47, 5.7899, 13.6881, 36.8591, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 6, 13.38, 47, 7.4310, 4.0736, 35.9583, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 7, 5.26, 47, 3.2104, 1.4940, 16.8799, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'IM', NULL, 4.02, 47, 0.1336, 3.7544, 4.2923, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'RT', NULL, 73.90, 59, 7.9712, 55.3144, 86.6193, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 1, 3.77, 55, 3.0313, 0.7300, 17.2935, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 2, 2.06, 55, 0.9734, 0.7909, 5.2427, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 3, 37.45, 55, 8.7882, 22.0108, 55.9528, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 4, 32.61, 55, 6.4321, 21.2026, 46.5276, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 5, 18.25, 55, 5.4521, 9.6878, 31.7144, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 6, 5.86, 55, 3.1941, 1.9138, 16.5781, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 7, 0.00, 55, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'IM', NULL, 3.93, 55, 0.0968, 3.7404, 4.1286, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'RT', NULL, 95.63, 59, 2.9081, 84.4553, 98.8804, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 1, 0.26, 57, 0.2685, 0.0330, 2.0272, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 2, 14.99, 57, 7.3948, 5.2266, 36.0573, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 3, 31.64, 57, 6.2969, 20.5254, 45.3314, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 4, 28.47, 57, 10.9096, 11.9756, 53.7873, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 5, 19.07, 57, 7.9768, 7.7242, 39.8917, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 6, 3.09, 57, 2.1260, 0.7611, 11.6808, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 7, 2.49, 57, 1.7498, 0.5967, 9.7673, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'IM', NULL, 3.92, 57, 0.1194, 3.6810, 4.1593, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'RT', NULL, 96.91, 59, 2.0743, 88.6816, 99.2119, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 1, 9.74, 43, 5.5478, 2.9343, 27.8295, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 2, 26.62, 43, 6.3865, 15.7905, 41.2357, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 3, 33.04, 43, 9.7659, 16.8340, 54.5953, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 4, 24.57, 43, 8.2877, 11.6673, 44.5394, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 5, 2.46, 43, 2.4601, 0.3195, 16.6168, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 6, 0.00, 43, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 7, 3.57, 43, 2.7149, 0.7472, 15.3883, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'IM', NULL, 3.85, 42, 0.2128, 3.4182, 4.2775, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'RT', NULL, 74.32, 59, 7.4333, 57.0279, 86.3204, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 1, 6.92, 49, 3.4042, 2.5042, 17.7058, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 2, 27.42, 49, 6.8595, 15.8928, 43.0382, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 3, 38.11, 49, 7.4157, 24.6551, 53.6744, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 4, 11.40, 49, 5.1159, 4.4441, 26.2692, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 5, 10.36, 49, 3.8982, 4.7332, 21.1833, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 6, 2.00, 49, 1.7597, 0.3332, 11.0502, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 7, 3.79, 49, 2.7877, 0.8387, 15.4887, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'IM', NULL, 3.84, 49, 0.1791, 3.4843, 4.2045, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'RT', NULL, 81.51, 59, 7.5819, 61.6933, 92.3495, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 1, 5.04, 54, 3.4827, 1.2161, 18.5991, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 2, 24.38, 54, 5.9313, 14.4681, 38.0714, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 3, 35.66, 54, 7.8156, 21.8691, 52.3271, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 4, 17.42, 54, 8.6913, 5.9106, 41.4771, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 5, 8.49, 54, 4.8287, 2.5949, 24.3991, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 6, 7.51, 54, 3.4368, 2.9216, 17.9689, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 7, 1.50, 54, 1.5275, 0.1905, 10.8131, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'IM', NULL, 3.78, 54, 0.1675, 3.4453, 4.1174, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'RT', NULL, 89.61, 59, 7.4134, 63.6661, 97.6963, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 1, 1.86, 50, 1.9121, 0.2316, 13.4402, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 2, 18.81, 50, 4.6776, 11.1306, 30.0127, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 3, 34.20, 50, 9.4618, 18.2488, 54.7458, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 4, 19.21, 50, 9.3413, 6.6259, 44.3539, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 5, 13.34, 50, 4.7801, 6.2827, 26.1079, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 6, 0.00, 50, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 7, 12.58, 50, 7.9572, 3.2499, 38.1178, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'IM', NULL, 3.78, 50, 0.1726, 3.4291, 4.1230, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'RT', NULL, 81.94, 59, 8.5032, 58.9565, 93.4807, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 1, 8.28, 52, 4.6597, 2.5650, 23.6295, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 2, 31.41, 52, 7.8951, 17.9968, 48.8695, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 3, 23.81, 52, 7.8024, 11.6427, 42.5631, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 4, 25.02, 52, 6.9521, 13.6858, 41.2503, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 5, 9.25, 52, 3.3948, 4.3268, 18.6677, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 6, 0.30, 52, 0.3114, 0.0381, 2.3561, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 7, 1.93, 52, 1.9614, 0.2467, 13.5893, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'IM', NULL, 3.63, 53, 0.1199, 3.3884, 3.8697, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'RT', NULL, 90.49, 59, 4.4995, 76.9628, 96.4386, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 1, 12.59, 50, 4.0806, 6.3990, 23.2800, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 2, 47.05, 50, 8.0694, 31.6678, 63.0122, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 3, 19.34, 50, 5.2659, 10.8477, 32.0890, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 4, 15.63, 50, 6.0942, 6.8201, 31.9232, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 5, 1.86, 50, 1.6448, 0.3094, 10.3826, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 6, 0.00, 50, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 7, 3.53, 50, 2.6042, 0.7805, 14.5412, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'IM', NULL, 3.61, 50, 0.1227, 3.3639, 3.8571, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'RT', NULL, 87.49, 59, 7.4500, 64.1638, 96.4678, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 1, 32.70, 45, 9.4444, 16.9810, 53.5680, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 2, 28.56, 45, 7.9355, 15.4342, 46.6768, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 3, 19.19, 45, 5.4719, 10.4446, 32.5951, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 4, 11.94, 45, 6.2018, 3.9633, 30.8017, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 5, 3.48, 45, 2.3927, 0.8485, 13.1620, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 6, 2.34, 45, 2.3576, 0.2998, 16.0654, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 7, 1.80, 45, 1.8529, 0.2222, 13.1442, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'IM', NULL, 3.56, 45, 0.1557, 3.2506, 3.8782, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'RT', NULL, 74.48, 59, 7.8683, 56.0317, 86.9864, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 1, 32.98, 41, 11.3131, 14.8846, 58.0614, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 2, 45.84, 41, 7.6916, 31.1554, 61.2877, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 3, 14.83, 41, 7.3847, 5.0742, 36.2095, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 4, 4.05, 41, 2.4110, 1.1901, 12.8850, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 5, 0.00, 41, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 6, 0.00, 41, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 7, 2.30, 41, 2.3232, 0.2889, 16.0077, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'IM', NULL, 3.52, 40, 0.0966, 3.3241, 3.7147, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'RT', NULL, 76.00, 59, 5.3202, 63.8535, 85.0292, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 1, 19.51, 44, 11.8489, 5.0237, 52.6085, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 2, 38.71, 44, 9.7125, 21.6665, 59.0488, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 3, 15.46, 44, 7.4997, 5.4354, 36.7773, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 4, 20.64, 44, 6.6979, 10.2323, 37.2335, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 5, 5.69, 44, 4.8137, 0.9793, 26.9138, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 6, 0.00, 44, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 7, 0.00, 44, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'IM', NULL, 3.27, 44, 0.3203, 2.6259, 3.9180, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'RT', NULL, 82.95, 59, 5.5680, 68.8674, 91.4500, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 1, 11.66, 49, 6.2286, 3.7664, 30.8059, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 2, 37.86, 49, 7.4785, 24.3303, 53.5845, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 3, 34.46, 49, 8.2344, 20.1679, 52.2550, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 4, 7.91, 49, 3.6780, 3.0188, 19.1634, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 5, 6.14, 49, 3.2904, 2.0322, 17.0936, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 6, 0.00, 49, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 7, 1.97, 49, 1.9984, 0.2498, 13.8713, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'IM', NULL, 3.27, 49, 0.1269, 3.0117, 3.5222, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'RT', NULL, 88.63, 59, 4.2931, 76.8660, 94.8164, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 1, 13.53, 39, 7.5282, 4.0814, 36.5344, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 2, 60.47, 39, 8.2353, 43.2342, 75.4471, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 3, 17.73, 39, 9.5483, 5.4202, 44.7808, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 4, 8.26, 39, 4.5698, 2.5879, 23.3846, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 5, 0.00, 39, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 6, 0.00, 39, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 7, 0.00, 39, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'IM', NULL, 3.24, 39, 0.1813, 2.8770, 3.6109, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'RT', NULL, 70.72, 59, 7.8699, 53.0264, 83.7929, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 1, 38.09, 38, 10.0247, 20.6331, 59.2800, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 2, 49.61, 38, 10.0837, 30.3038, 69.0350, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 3, 5.39, 38, 5.4635, 0.6455, 33.3086, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 4, 4.91, 38, 3.2811, 1.2258, 17.6618, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 5, 0.00, 38, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 6, 0.00, 38, 0.0000, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 7, 2.01, 38, 2.0355, 0.2503, 14.3029, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'IM', NULL, 3.36, 38, 0.1522, 3.0500, 3.6667, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'RT', NULL, 66.96, 59, 8.9389, 47.4407, 81.9810, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 1, 0.00, 46, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 2, 0.00, 46, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 3, 1.38, 46, 1.4175, 0.1728, 10.2110, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 4, 3.61, 46, 3.5610, 0.4741, 22.7360, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 5, 46.31, 46, 7.1591, 32.5665, 60.6349, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 6, 25.10, 46, 6.0140, 14.9637, 38.9619, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 7, 23.60, 46, 5.5328, 14.2707, 36.4289, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'IM', NULL, 4.36, 47, 0.0866, 4.1845, 4.5333, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'RT', NULL, 90.22, 51, 5.9855, 70.2528, 97.3017, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 1, 0.00, 47, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 2, 3.46, 47, 3.1635, 0.5287, 19.4388, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 3, 8.48, 47, 4.4681, 2.8280, 22.7942, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 4, 10.87, 47, 4.3860, 4.6739, 23.2750, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 5, 44.01, 47, 5.6911, 33.0558, 55.5801, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 6, 23.48, 47, 5.4882, 14.2266, 36.1997, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 7, 9.70, 47, 6.2841, 2.4743, 31.2820, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'IM', NULL, 4.34, 49, 0.0778, 4.1883, 4.5014, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'RT', NULL, 98.67, 50, 1.3622, 90.2045, 99.8331, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 1, 0.00, 47, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 2, 0.00, 47, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 3, 10.52, 47, 3.4987, 5.2748, 19.9029, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 4, 14.68, 47, 6.0873, 6.0766, 31.3977, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 5, 54.06, 47, 6.4410, 41.1163, 66.4842, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 6, 19.34, 47, 4.5445, 11.7687, 30.1178, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 7, 1.39, 47, 1.4269, 0.1735, 10.2735, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'IM', NULL, 4.09, 48, 0.1213, 3.8430, 4.3310, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'RT', NULL, 94.36, 51, 3.2561, 83.0387, 98.2793, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 1, 2.25, 49, 2.2328, 0.2986, 15.0480, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 2, 6.59, 49, 3.6046, 2.1274, 18.6324, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 3, 19.99, 49, 7.7913, 8.5805, 39.9547, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 4, 23.35, 49, 5.5376, 14.0550, 36.2035, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 5, 35.25, 49, 8.3530, 20.6884, 53.1909, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 6, 7.92, 49, 6.1173, 1.5672, 31.7204, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 7, 4.64, 49, 3.0631, 1.1972, 16.3659, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'IM', NULL, 4.01, 50, 0.1733, 3.6667, 4.3632, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'RT', NULL, 98.70, 51, 1.3313, 90.3991, 99.8380, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 1, 0.00, 45, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 2, 13.16, 45, 5.3792, 5.5440, 28.1255, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 3, 2.84, 45, 2.0820, 0.6368, 11.7901, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 4, 35.30, 45, 7.0395, 22.6735, 50.3863, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 5, 34.40, 45, 7.4748, 21.1985, 50.5522, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 6, 14.29, 45, 4.5673, 7.2903, 26.1177, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 7, 0.00, 45, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'IM', NULL, 4.00, 46, 0.0791, 3.8416, 4.1603, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'RT', NULL, 90.70, 51, 4.3674, 77.5145, 96.5034, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 1, 3.60, 45, 3.2825, 0.5504, 20.0925, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 2, 6.59, 45, 3.9965, 1.8711, 20.7018, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 3, 9.93, 45, 5.4732, 3.1117, 27.4533, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 4, 33.40, 45, 4.9498, 24.2604, 43.9899, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 5, 30.35, 45, 7.3080, 17.8370, 46.6565, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 6, 12.53, 45, 4.8596, 5.5403, 25.9335, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 7, 3.60, 45, 3.1319, 0.6005, 18.7236, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'IM', NULL, 3.95, 46, 0.1119, 3.7216, 4.1723, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'RT', NULL, 90.54, 51, 4.7539, 75.8393, 96.6857, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 1, 8.26, 45, 4.3204, 2.7770, 22.1241, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 2, 18.27, 45, 6.2027, 8.8227, 34.0508, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 3, 4.07, 45, 2.9199, 0.9300, 16.0765, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 4, 26.57, 45, 6.5280, 15.5625, 41.5233, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 5, 35.52, 45, 8.1681, 21.1678, 53.0610, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 6, 1.93, 45, 1.8888, 0.2610, 12.8422, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 7, 5.38, 45, 3.7792, 1.2603, 20.2408, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'IM', NULL, 3.93, 46, 0.1519, 3.6284, 4.2404, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'RT', NULL, 83.92, 52, 6.6460, 66.0045, 93.3437, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 1, 28.13, 40, 8.1274, 14.7915, 46.8831, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 2, 14.27, 40, 5.9705, 5.8392, 30.8759, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 3, 24.27, 40, 5.0825, 15.4782, 35.9213, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 4, 15.89, 40, 5.3063, 7.8019, 29.6631, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 5, 17.45, 40, 10.9234, 4.3581, 49.4938, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 6, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 7, 0.00, 40, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'IM', NULL, 3.91, 40, 0.1643, 3.5756, 4.2404, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'RT', NULL, 80.04, 51, 5.1743, 67.6626, 88.4874, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 1, 6.39, 44, 3.5782, 2.0001, 18.5731, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 2, 7.68, 44, 4.3393, 2.3647, 22.2284, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 3, 14.74, 44, 5.9874, 6.2024, 31.1227, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 4, 26.59, 44, 7.8105, 13.9115, 44.8024, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 5, 30.98, 44, 6.5436, 19.4920, 45.4137, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 6, 9.83, 44, 3.7286, 4.4625, 20.2981, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 7, 3.79, 44, 3.2589, 0.6475, 19.2693, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'IM', NULL, 3.89, 45, 0.0998, 3.6858, 4.0881, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'RT', NULL, 84.50, 52, 5.4875, 70.1590, 92.6722, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 1, 3.75, 44, 3.6991, 0.4922, 23.5180, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 2, 0.00, 44, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 3, 4.22, 44, 3.1867, 0.8889, 17.7716, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 4, 16.77, 44, 7.1102, 6.7246, 36.0135, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 5, 57.70, 44, 8.2246, 40.8782, 72.9123, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 6, 10.76, 44, 4.6491, 4.3418, 24.2475, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 7, 6.80, 44, 3.4569, 2.3734, 17.9790, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'IM', NULL, 3.85, 45, 0.1354, 3.5746, 4.1205, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'RT', NULL, 86.79, 51, 6.1098, 69.2577, 95.0425, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 2, 12.64, 37, 5.2599, 5.2214, 27.5473, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 3, 13.62, 37, 6.6836, 4.7465, 33.2910, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 4, 4.79, 37, 3.5290, 1.0384, 19.4579, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 5, 34.28, 37, 7.7699, 20.5787, 51.2121, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 6, 16.48, 37, 6.4527, 7.0856, 33.8021, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 7, 18.19, 37, 8.5229, 6.5031, 41.5307, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'IM', NULL, 3.77, 38, 0.2057, 3.3579, 4.1915, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'RT', NULL, 71.19, 51, 5.7047, 58.5644, 81.2044, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 1, 0.00, 43, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 2, 21.47, 43, 5.9337, 11.8507, 35.7455, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 3, 25.63, 43, 7.5531, 13.4154, 43.4014, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 4, 33.03, 43, 6.6411, 21.2019, 47.4771, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 5, 10.77, 43, 4.1210, 4.8355, 22.2872, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 6, 9.09, 43, 6.4563, 2.0255, 32.6060, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 7, 0.00, 43, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'IM', NULL, 3.77, 43, 0.1541, 3.4635, 4.0853, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'RT', NULL, 86.33, 51, 5.5749, 70.9766, 94.2264, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 1, 0.00, 46, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 2, 26.16, 46, 5.1646, 17.1293, 37.7692, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 3, 24.22, 46, 6.0659, 14.1111, 38.3457, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 4, 18.88, 46, 5.3897, 10.2812, 32.1052, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 5, 25.79, 46, 5.2883, 16.6120, 37.7457, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 6, 0.00, 46, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 7, 4.95, 46, 3.3477, 1.2263, 17.9190, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'IM', NULL, 3.67, 47, 0.1437, 3.3820, 3.9604, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'RT', NULL, 92.69, 51, 3.6686, 81.0388, 97.4121, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 1, 9.74, 30, 5.3574, 3.0089, 27.2874, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 2, 46.57, 30, 8.7003, 29.8933, 64.0577, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 3, 28.62, 30, 7.7075, 15.6387, 46.4512, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 4, 9.93, 30, 6.0937, 2.6619, 30.7562, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 5, 5.14, 30, 3.4377, 1.2634, 18.6459, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 6, 0.00, 30, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 7, 0.00, 30, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'IM', NULL, 4.29, 31, 0.1043, 4.0803, 4.5063, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'RT', NULL, 55.79, 52, 6.7011, 42.2426, 68.5258, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 1, 43.71, 16, 12.8335, 20.3458, 70.2392, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 2, 32.01, 16, 9.3973, 15.7906, 54.1630, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 3, 9.41, 16, 6.7193, 1.8980, 35.7918, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 4, 14.88, 16, 9.3035, 3.5234, 45.5515, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 5, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 6, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 7, 0.00, 16, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'IM', NULL, 4.16, 17, 0.2324, 3.6714, 4.6567, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'RT', NULL, 31.92, 50, 5.9939, 21.2205, 44.9391, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 1, 33.28, 25, 10.3163, 16.0521, 56.5470, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 2, 33.93, 25, 7.9981, 19.7346, 51.7446, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 3, 30.33, 25, 9.7327, 14.4001, 52.9687, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 5, 2.47, 25, 2.5071, 0.2930, 17.8586, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 6, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 7, 0.00, 25, 0.0000, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'IM', NULL, 3.92, 26, 0.2106, 3.4904, 4.3577, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'RT', NULL, 50.34, 52, 6.7412, 37.1041, 63.5288, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 1, 13.35, 33, 7.7688, 3.7736, 37.6980, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 2, 20.56, 33, 5.6447, 11.3465, 34.3495, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 3, 26.92, 33, 9.7962, 11.7820, 50.3875, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 4, 9.64, 33, 4.9543, 3.2376, 25.3620, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 5, 17.42, 33, 8.2683, 6.1434, 40.4845, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 6, 7.13, 33, 5.5127, 1.3872, 29.5075, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 7, 4.99, 33, 4.1922, 0.8604, 24.1295, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'IM', NULL, 3.46, 34, 0.2152, 3.0232, 3.8987, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'RT', NULL, 65.57, 51, 7.3991, 49.6449, 78.6229, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 1, 0.00, 61, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 2, 2.44, 61, 2.3083, 0.3575, 14.8274, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 3, 1.09, 61, 1.0831, 0.1458, 7.6224, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 4, 1.27, 61, 1.2706, 0.1695, 8.8913, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 5, 53.16, 61, 6.8186, 39.6276, 66.2516, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 6, 23.76, 61, 5.9744, 13.8799, 37.6126, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 7, 18.28, 61, 5.3031, 9.9038, 31.2698, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'IM', NULL, 4.41, 61, 0.0861, 4.2336, 4.5780, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'RT', NULL, 97.80, 63, 1.5418, 91.3935, 99.4636, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 1, 0.00, 61, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 2, 2.74, 61, 1.8409, 0.7006, 10.0901, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 3, 3.71, 61, 2.5969, 0.8932, 14.1559, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 4, 0.00, 61, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 5, 32.90, 61, 6.3188, 21.6618, 46.4979, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 6, 33.57, 61, 7.6238, 20.3201, 50.0319, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 7, 27.09, 61, 6.0153, 16.8054, 40.5888, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'IM', NULL, 4.32, 60, 0.1325, 4.0593, 4.5897, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'RT', NULL, 94.47, 65, 3.2699, 83.0295, 98.3500, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 1, 0.00, 63, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 2, 2.39, 63, 2.2626, 0.3498, 14.5557, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 3, 9.97, 63, 4.6477, 3.7861, 23.7675, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 4, 16.90, 63, 5.6156, 8.3789, 31.1440, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 5, 53.32, 63, 7.7675, 37.9733, 68.0701, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 6, 11.60, 63, 4.3843, 5.2910, 23.5765, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 7, 5.81, 63, 3.1582, 1.9099, 16.3543, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'IM', NULL, 4.30, 63, 0.1025, 4.0960, 4.5058, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'RT', NULL, 98.84, 64, 1.1272, 92.2512, 99.8375, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 1, 0.00, 59, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 2, 1.29, 59, 1.3310, 0.1626, 9.5474, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 3, 9.39, 59, 4.0163, 3.8707, 21.0473, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 4, 13.81, 59, 4.0046, 7.5571, 23.9119, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 5, 65.65, 59, 6.9525, 50.7672, 77.9886, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 6, 7.39, 59, 3.9361, 2.4625, 20.1489, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 7, 2.46, 59, 2.3263, 0.3608, 14.9395, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'IM', NULL, 4.29, 58, 0.0884, 4.1146, 4.4688, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'RT', NULL, 96.17, 62, 2.7104, 85.2125, 99.0965, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 1, 0.00, 63, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 2, 0.00, 63, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 3, 6.76, 63, 3.6695, 2.2165, 18.8406, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 4, 6.76, 63, 3.0967, 2.6401, 16.2170, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 5, 55.14, 63, 6.9505, 41.2097, 68.3104, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 6, 29.55, 63, 6.2270, 18.7435, 43.2687, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 7, 1.79, 63, 1.5289, 0.3194, 9.3944, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'IM', NULL, 4.25, 63, 0.1115, 4.0267, 4.4724, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'RT', NULL, 100.00, 63, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 1, 0.00, 63, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 2, 2.39, 63, 2.2625, 0.3530, 14.5221, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 3, 4.38, 63, 3.1268, 1.0168, 16.9305, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 4, 9.12, 63, 5.0647, 2.8708, 25.3968, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 5, 20.44, 63, 5.5953, 11.4381, 33.8228, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 6, 35.10, 63, 7.2296, 22.2850, 50.4927, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 7, 28.57, 63, 7.3001, 16.3676, 44.9883, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'IM', NULL, 4.22, 62, 0.1216, 3.9740, 4.4604, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'RT', NULL, 94.54, 65, 3.6071, 81.0834, 98.5920, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 1, 0.00, 58, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 2, 3.13, 58, 2.2756, 0.7141, 12.6804, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 3, 16.66, 58, 4.9558, 8.9100, 29.0043, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 4, 15.76, 58, 4.8998, 8.2057, 28.1509, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 5, 29.89, 58, 6.4647, 18.6908, 44.1578, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 6, 15.27, 58, 4.9122, 7.7752, 27.8255, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 7, 19.28, 58, 6.5601, 9.3123, 35.7127, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'IM', NULL, 4.22, 58, 0.1208, 3.9738, 4.4575, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'RT', NULL, 89.02, 63, 5.2507, 73.4764, 95.9548, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 1, 0.00, 64, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 2, 10.93, 64, 3.7585, 5.3701, 20.9763, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 3, 37.19, 64, 8.0651, 22.8989, 54.1376, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 4, 19.96, 64, 5.2957, 11.3888, 32.5948, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 5, 22.41, 64, 6.6792, 11.8229, 38.3620, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 6, 7.36, 64, 4.4098, 2.1339, 22.4402, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 7, 2.15, 64, 1.4824, 0.5358, 8.2398, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'IM', NULL, 4.04, 63, 0.1331, 3.7778, 4.3100, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'RT', NULL, 100.00, 64, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 1, 7.65, 62, 3.6676, 2.8534, 18.9585, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 2, 38.95, 62, 6.2697, 27.3543, 51.9431, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 3, 32.89, 62, 6.6016, 21.2275, 47.1249, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 4, 10.23, 62, 3.9790, 4.5716, 21.3228, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 5, 9.20, 62, 4.2369, 3.5435, 21.8356, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 6, 1.08, 62, 1.0506, 0.1525, 7.2372, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 7, 0.00, 62, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'IM', NULL, 4.00, 61, 0.1473, 3.7090, 4.2984, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'RT', NULL, 95.82, 64, 2.6268, 86.0748, 98.8382, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 1, 3.87, 56, 2.9172, 0.8316, 16.2268, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 2, 4.63, 56, 2.4563, 1.5668, 12.8934, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 3, 29.24, 56, 8.7446, 15.0454, 49.0778, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 4, 11.15, 56, 4.6981, 4.6233, 24.5036, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 5, 42.27, 56, 8.4624, 26.7642, 59.4673, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 6, 8.84, 56, 3.9395, 3.5162, 20.5296, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 7, 0.00, 56, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'IM', NULL, 3.98, 56, 0.1422, 3.6969, 4.2669, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'RT', NULL, 88.99, 63, 4.2646, 77.2028, 95.0759, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 1, 5.56, 53, 3.7193, 1.4025, 19.6054, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 2, 8.55, 53, 3.9826, 3.2567, 20.6240, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 3, 19.35, 53, 6.4115, 9.5158, 35.3628, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 4, 8.12, 53, 4.4348, 2.6098, 22.5594, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 5, 21.06, 53, 6.0701, 11.3652, 35.6948, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 6, 20.86, 53, 5.8690, 11.4397, 34.9797, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 7, 16.50, 53, 4.9091, 8.8138, 28.7709, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'IM', NULL, 3.93, 52, 0.1808, 3.5664, 4.2923, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'RT', NULL, 82.35, 64, 6.2311, 66.4524, 91.6588, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 1, 5.69, 49, 2.9240, 1.9777, 15.2866, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 2, 21.65, 49, 6.2520, 11.6393, 36.7016, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 3, 32.50, 49, 6.2291, 21.3852, 46.0083, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 4, 16.88, 49, 5.8813, 8.0396, 32.0528, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 5, 17.53, 49, 5.6152, 8.8737, 31.7027, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 6, 4.41, 49, 3.0590, 1.0609, 16.5596, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 7, 1.34, 49, 1.3406, 0.1747, 9.4765, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'IM', NULL, 3.72, 49, 0.1251, 3.4725, 3.9754, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'RT', NULL, 77.55, 63, 7.8043, 58.5053, 89.4320, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 1, 18.87, 50, 5.2182, 10.4971, 31.5744, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 2, 15.12, 50, 5.9079, 6.5935, 30.9970, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 3, 24.16, 50, 6.7949, 13.1359, 40.1643, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 4, 26.46, 50, 7.8533, 13.7877, 44.7428, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 5, 11.95, 50, 6.3891, 3.8489, 31.4975, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 6, 0.00, 50, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 7, 3.44, 50, 2.5139, 0.7728, 14.0172, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'IM', NULL, 3.56, 50, 0.0993, 3.3641, 3.7633, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'RT', NULL, 78.88, 65, 7.0086, 61.7105, 89.6433, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 1, 4.43, 50, 3.3252, 0.9466, 18.3470, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 2, 22.48, 50, 4.5725, 14.6161, 32.9482, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 3, 41.66, 50, 7.0098, 28.5727, 56.0436, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 4, 14.18, 50, 5.1131, 6.6332, 27.7683, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 5, 10.55, 50, 5.0551, 3.8626, 25.7096, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 6, 5.36, 50, 3.5594, 1.3609, 18.8347, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 7, 1.34, 50, 1.3458, 0.1758, 9.4984, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'IM', NULL, 3.56, 50, 0.1174, 3.3211, 3.7930, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'RT', NULL, 78.28, 63, 7.8206, 58.9671, 90.0393, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 1, 0.29, 59, 0.3128, 0.0316, 2.5220, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 2, 6.35, 59, 3.6052, 1.9780, 18.5788, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 3, 28.29, 59, 7.0230, 16.4813, 44.1020, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 4, 12.82, 59, 4.1136, 6.5785, 23.5035, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 5, 34.41, 59, 7.0765, 21.8791, 49.5631, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 6, 7.20, 59, 5.6157, 1.4212, 29.4449, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 7, 10.64, 59, 3.3787, 5.5197, 19.5145, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'IM', NULL, 4.63, 60, 0.0677, 4.4961, 4.7670, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'RT', NULL, 99.72, 61, 0.3094, 97.5043, 99.9689, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 1, 6.01, 61, 3.7014, 1.6920, 19.1709, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 2, 5.86, 61, 4.6173, 1.1543, 24.9258, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 3, 20.20, 61, 7.3202, 9.2581, 38.5667, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 4, 4.25, 61, 3.5609, 0.7663, 20.3460, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 5, 43.04, 61, 9.2708, 26.1757, 61.6815, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 6, 14.07, 61, 5.7906, 5.9106, 29.9129, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 7, 6.58, 61, 3.5136, 2.1945, 18.0981, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'IM', NULL, 4.52, 61, 0.1139, 4.2961, 4.7516, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'RT', NULL, 100.00, 61, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 1, 3.78, 59, 3.7289, 0.5040, 23.3996, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 2, 0.00, 59, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 3, 8.68, 59, 7.1390, 1.5428, 36.5738, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 4, 15.64, 59, 5.1058, 7.8753, 28.6898, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 5, 57.74, 59, 7.7885, 41.8974, 72.1282, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 6, 13.82, 59, 8.0763, 3.9634, 38.3922, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 7, 0.33, 59, 0.3622, 0.0381, 2.8702, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'IM', NULL, 4.14, 58, 0.1302, 3.8772, 4.3987, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'RT', NULL, 93.71, 61, 3.6070, 81.4153, 98.0625, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 1, 0.00, 61, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 2, 3.38, 61, 3.6170, 0.3807, 24.2701, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 3, 8.13, 61, 6.8512, 1.3951, 35.6570, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 4, 10.69, 61, 4.5607, 4.3986, 23.7336, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 5, 48.15, 61, 10.1418, 29.1822, 67.6690, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 6, 19.92, 61, 9.2162, 7.2629, 44.1360, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 7, 9.73, 61, 3.5395, 4.5897, 19.4400, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'IM', NULL, 4.13, 61, 0.1454, 3.8405, 4.4223, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'RT', NULL, 100.00, 61, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 1, 6.71, 59, 3.5219, 2.2792, 18.1546, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 2, 3.44, 59, 3.6846, 0.3844, 24.7217, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 3, 4.37, 59, 4.4030, 0.5521, 27.3479, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 4, 7.61, 59, 6.1072, 1.4292, 31.9054, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 5, 29.27, 59, 5.9230, 18.9257, 42.3230, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 6, 29.76, 59, 6.6866, 18.2561, 44.5602, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 7, 18.83, 59, 5.7584, 9.8424, 33.0306, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'IM', NULL, 4.12, 59, 0.1141, 3.8930, 4.3498, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'RT', NULL, 96.25, 62, 3.5182, 78.5304, 99.4468, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 1, 0.00, 58, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 2, 12.57, 58, 7.3375, 3.6388, 35.3758, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 3, 19.97, 58, 7.0329, 9.3702, 37.5908, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 4, 26.40, 58, 6.1497, 15.9872, 40.3339, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 5, 30.33, 58, 10.0273, 14.4056, 52.9599, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 6, 10.41, 58, 3.1984, 5.5271, 18.7616, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 7, 0.32, 58, 0.3498, 0.0354, 2.8128, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'IM', NULL, 3.87, 58, 0.1315, 3.6097, 4.1363, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'RT', NULL, 95.93, 62, 3.5851, 78.9761, 99.3291, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 1, 0.00, 57, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 2, 13.56, 57, 5.1279, 6.1291, 27.3691, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 3, 5.72, 57, 4.6695, 1.0595, 25.5827, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 4, 23.54, 57, 7.4466, 11.8470, 41.3546, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 5, 40.17, 57, 8.4679, 24.8929, 57.6231, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 6, 13.27, 57, 8.1427, 3.5738, 38.6988, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 7, 3.75, 57, 3.6762, 0.5033, 23.0674, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'IM', NULL, 3.82, 57, 0.1316, 3.5582, 4.0856, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'RT', NULL, 92.99, 62, 3.3124, 82.7645, 97.3419, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 1, 11.71, 56, 4.1711, 5.5763, 22.9382, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 2, 33.25, 56, 9.3006, 17.7053, 53.5699, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 3, 22.44, 56, 6.2734, 12.3225, 37.3388, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 4, 11.43, 56, 3.7156, 5.8210, 21.2120, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 5, 20.81, 56, 11.4433, 6.1351, 51.3799, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 6, 0.36, 56, 0.3922, 0.0395, 3.1558, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 7, 0.00, 56, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'IM', NULL, 3.79, 57, 0.2112, 3.3711, 4.2172, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'RT', NULL, 91.38, 61, 6.8733, 64.9221, 98.3791, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 1, 4.27, 58, 3.8717, 0.6669, 22.8983, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 2, 16.01, 58, 9.7515, 4.2719, 44.8852, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 3, 21.27, 58, 8.1902, 9.2140, 41.8421, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 4, 17.33, 58, 4.6482, 9.8697, 28.6468, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 5, 36.62, 58, 7.1109, 23.8272, 51.6212, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 6, 3.79, 58, 2.8233, 0.8293, 15.6594, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 7, 0.70, 58, 0.5512, 0.1432, 3.3379, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'IM', NULL, 3.60, 58, 0.1587, 3.2860, 3.9216, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'RT', NULL, 87.68, 62, 7.1473, 65.4622, 96.3938, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 1, 0.38, 41, 0.4181, 0.0419, 3.4043, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 2, 19.50, 41, 6.7542, 9.2139, 36.6253, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 3, 24.52, 41, 8.4520, 11.4348, 44.9843, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 4, 21.31, 41, 8.4874, 8.8689, 42.9595, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 5, 29.74, 41, 8.5522, 15.6196, 49.1886, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 6, 4.13, 41, 3.3939, 0.7579, 19.5787, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 7, 0.42, 41, 0.4551, 0.0456, 3.6971, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'IM', NULL, 3.58, 40, 0.1572, 3.2584, 3.8943, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'RT', NULL, 75.19, 61, 4.9959, 63.9447, 83.8119, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 1, 3.57, 59, 3.5735, 0.4604, 22.8341, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 2, 12.65, 59, 7.2176, 3.7718, 34.8702, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 3, 40.56, 59, 6.4798, 28.4895, 53.8854, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 4, 14.15, 59, 8.9339, 3.6427, 41.8060, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 5, 28.76, 59, 5.6020, 18.9314, 41.1004, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 6, 0.00, 59, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 7, 0.32, 59, 0.3447, 0.0352, 2.7641, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'IM', NULL, 3.54, 59, 0.2054, 3.1301, 3.9524, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'RT', NULL, 99.70, 60, 0.3275, 97.3578, 99.9671, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 1, 5.40, 53, 5.0963, 0.7632, 29.7211, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 2, 15.29, 53, 5.5500, 7.0996, 29.8995, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 3, 28.84, 53, 7.5983, 16.1664, 46.0056, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 4, 12.57, 53, 6.5815, 4.1435, 32.3480, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 5, 31.03, 53, 6.3726, 19.8388, 44.9841, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 6, 6.53, 53, 4.2346, 1.7073, 21.9413, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 7, 0.34, 53, 0.3690, 0.0386, 2.9366, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'IM', NULL, 3.40, 52, 0.1772, 3.0428, 3.7544, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'RT', NULL, 91.95, 61, 3.0702, 83.2846, 96.3225, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 1, 15.97, 48, 6.0375, 7.1382, 31.9645, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 2, 26.86, 48, 9.0962, 12.6398, 48.2442, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 3, 0.35, 48, 0.3760, 0.0398, 2.9892, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 4, 1.48, 48, 1.0896, 0.3321, 6.3306, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 5, 39.50, 48, 8.3415, 24.4402, 56.8505, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 6, 6.73, 48, 4.3679, 1.7501, 22.6331, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 7, 9.11, 48, 5.4703, 2.5870, 27.4635, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'IM', NULL, 3.29, 47, 0.2476, 2.7903, 3.7872, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'RT', NULL, 80.67, 61, 6.1640, 65.4273, 90.1945, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 1, 11.27, 44, 5.0429, 4.3900, 25.9898, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 2, 60.63, 44, 8.5359, 42.8178, 76.0072, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 3, 19.69, 44, 6.4993, 9.6672, 35.9636, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 4, 5.61, 44, 4.3253, 1.1341, 23.5767, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 5, 2.80, 44, 1.5705, 0.8892, 8.4456, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 6, 0.00, 44, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 7, 0.00, 44, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'IM', NULL, 4.11, 44, 0.2306, 3.6462, 4.5761, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'RT', NULL, 64.05, 61, 7.7591, 47.5869, 77.7549, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 1, 5.97, 50, 5.9756, 0.7431, 35.0210, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 2, 3.74, 50, 3.4195, 0.5709, 20.7783, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 3, 14.39, 50, 9.1354, 3.6482, 42.7257, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 4, 9.00, 50, 4.8894, 2.8908, 24.7138, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 5, 48.26, 50, 10.2268, 29.0591, 67.9960, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 6, 14.00, 50, 6.0111, 5.6360, 30.7489, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 7, 4.64, 50, 3.5507, 0.9601, 19.6206, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'IM', NULL, 3.93, 49, 0.2134, 3.5043, 4.3626, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'RT', NULL, 65.80, 62, 11.7440, 40.3918, 84.5263, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 1, 0.84, 50, 0.7125, 0.1540, 4.4953, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 2, 0.42, 50, 0.4687, 0.0452, 3.8285, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 3, 0.47, 50, 0.5193, 0.0507, 4.2092, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 4, 16.25, 50, 4.4143, 9.1798, 27.1298, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 5, 44.08, 50, 12.4135, 22.2686, 68.4384, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 6, 20.05, 50, 5.5886, 11.0688, 33.5692, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 7, 17.89, 50, 9.0057, 5.9747, 42.7557, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'IM', NULL, 3.79, 50, 0.1520, 3.4870, 4.0977, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'RT', NULL, 66.66, 61, 7.5274, 50.3848, 79.7449, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 1, 22.80, 40, 7.4986, 11.0898, 41.1435, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 2, 23.19, 40, 15.1274, 5.1419, 62.7198, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 3, 16.19, 40, 4.7944, 8.6401, 28.3065, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 4, 0.48, 40, 0.5564, 0.0468, 4.7966, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 5, 4.86, 40, 3.3577, 1.1616, 18.1619, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 6, 19.45, 40, 8.5959, 7.3749, 42.2824, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 7, 13.02, 40, 3.5758, 7.3239, 22.0878, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'IM', NULL, 3.76, 40, 0.1319, 3.4955, 4.0290, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'RT', NULL, 66.87, 60, 11.0192, 42.7286, 84.5227, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 1, 13.12, 36, 9.1596, 2.8690, 43.5604, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 2, 15.26, 36, 5.8947, 6.6608, 31.2387, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 3, 17.20, 36, 11.8289, 3.7044, 52.8638, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 4, 44.25, 36, 14.6863, 19.1599, 72.6613, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 5, 10.18, 36, 7.1068, 2.2840, 35.4481, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 6, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 7, 0.00, 36, 0.0000, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'IM', NULL, 3.70, 35, 0.1873, 3.3156, 4.0771, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'RT', NULL, 51.09, 61, 7.5419, 36.3503, 65.6395, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 1, 5.18, 40, 4.4942, 0.8519, 25.7952, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 2, 34.02, 40, 9.4436, 18.0452, 54.7021, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 3, 23.14, 40, 11.9127, 7.2090, 53.8527, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 4, 2.77, 40, 1.5844, 0.8601, 8.5614, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 5, 8.94, 40, 5.4712, 2.4575, 27.6571, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 6, 4.66, 40, 4.3560, 0.6666, 26.2194, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 7, 21.29, 40, 14.1871, 4.6530, 59.9869, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'IM', NULL, 3.56, 41, 0.3416, 2.8739, 4.2545, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'RT', NULL, 55.20, 62, 9.0844, 37.1485, 71.9757, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 1, 0.00, 84, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 2, 3.36, 84, 2.0548, 0.9757, 10.9072, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 3, 8.26, 84, 3.3713, 3.5816, 17.9059, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 4, 7.07, 84, 2.7728, 3.1790, 14.9727, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 5, 62.05, 84, 5.9286, 49.7685, 72.9521, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 6, 10.60, 84, 3.9565, 4.9129, 21.3843, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 7, 8.68, 84, 2.9583, 4.3247, 16.6412, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'IM', NULL, 4.48, 82, 0.0607, 4.3614, 4.6030, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'RT', NULL, 97.71, 86, 1.6117, 91.0634, 99.4431, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 1, 29.75, 68, 5.9180, 19.4010, 42.7060, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 2, 25.06, 68, 5.4058, 15.8385, 37.2607, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 3, 14.31, 68, 4.7273, 7.1834, 26.4995, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 4, 6.53, 68, 3.0304, 2.5264, 15.8390, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 5, 21.15, 68, 5.1775, 12.6108, 33.2626, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 6, 0.00, 68, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 7, 3.20, 68, 2.1870, 0.8021, 11.9162, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'IM', NULL, 4.23, 68, 0.1223, 3.9849, 4.4729, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'RT', NULL, 77.46, 86, 4.6617, 66.9002, 85.3896, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 1, 2.43, 85, 1.7681, 0.5600, 9.8937, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 2, 4.49, 85, 2.4803, 1.4677, 12.9293, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 3, 10.60, 85, 3.7183, 5.1548, 20.5554, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 4, 12.28, 85, 3.5660, 6.7590, 21.2855, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 5, 56.41, 85, 5.3430, 45.6491, 66.5905, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 6, 5.91, 85, 2.4220, 2.5776, 12.9967, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 7, 7.88, 85, 3.5938, 3.0964, 18.6295, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'IM', NULL, 4.16, 85, 0.0757, 4.0115, 4.3125, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'RT', NULL, 98.54, 86, 1.4423, 90.2149, 99.7969, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 1, 28.81, 78, 5.3342, 19.4297, 40.4532, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 2, 25.15, 78, 5.1781, 16.2671, 36.7496, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 3, 12.89, 78, 4.1705, 6.6011, 23.6689, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 4, 15.70, 78, 4.5645, 8.5713, 27.0150, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 5, 13.61, 78, 3.7822, 7.6630, 23.0113, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 6, 2.15, 78, 1.5086, 0.5217, 8.3990, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 7, 1.69, 78, 1.6061, 0.2494, 10.5502, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'IM', NULL, 4.14, 77, 0.1188, 3.9051, 4.3784, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'RT', NULL, 89.23, 86, 3.5345, 79.9499, 94.5094, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 1, 2.19, 86, 1.6574, 0.4758, 9.4523, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 2, 15.30, 86, 4.4349, 8.3815, 26.2927, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 3, 11.90, 86, 3.3866, 6.6379, 20.4322, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 4, 18.65, 86, 3.9109, 12.0740, 27.6799, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 5, 40.10, 86, 5.0211, 30.6432, 50.3596, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 6, 8.85, 86, 2.9303, 4.4997, 16.6582, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 7, 3.01, 86, 2.8859, 0.4341, 18.1226, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'IM', NULL, 4.14, 86, 0.0962, 3.9504, 4.3328, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'RT', NULL, 100.00, 86, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 1, 0.00, 83, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 2, 9.89, 83, 3.6911, 4.5919, 20.0101, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 3, 20.61, 83, 4.7532, 12.7130, 31.6319, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 4, 14.91, 83, 3.8519, 8.7433, 24.2765, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 5, 43.43, 83, 5.2911, 33.3455, 54.0965, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 6, 6.90, 83, 2.9065, 2.9270, 15.4204, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 7, 4.25, 83, 3.0974, 0.9697, 16.7826, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'IM', NULL, 4.13, 81, 0.0963, 3.9425, 4.3258, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'RT', NULL, 96.79, 85, 2.2574, 87.6684, 99.2243, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 1, 0.89, 81, 0.8834, 0.1240, 6.1540, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 2, 10.40, 81, 3.7618, 4.9439, 20.5866, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 3, 12.20, 81, 3.2689, 7.0362, 20.3204, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 4, 13.16, 81, 3.8161, 7.2292, 22.7485, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 5, 57.08, 81, 5.5169, 45.9375, 67.5562, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 6, 3.07, 81, 1.7710, 0.9608, 9.3810, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 7, 3.19, 81, 3.0469, 0.4613, 19.0022, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'IM', NULL, 4.13, 81, 0.0918, 3.9452, 4.3107, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'RT', NULL, 94.39, 86, 3.2137, 83.4269, 98.2529, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 1, 0.88, 68, 0.8750, 0.1177, 6.2010, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 2, 13.43, 68, 4.4748, 6.7118, 25.0628, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 3, 11.97, 68, 4.2831, 5.6938, 23.4321, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 4, 13.54, 68, 4.1792, 7.1347, 24.2073, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 5, 54.94, 68, 6.2186, 42.4828, 66.8146, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 6, 2.00, 68, 1.9198, 0.2886, 12.5942, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 7, 3.24, 68, 2.1803, 0.8293, 11.8300, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'IM', NULL, 4.09, 68, 0.0891, 3.9131, 4.2688, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'RT', NULL, 80.30, 85, 4.4145, 70.0578, 87.6509, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 1, 1.87, 73, 1.8571, 0.2511, 12.5566, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 2, 13.98, 73, 4.2350, 7.4535, 24.6953, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 3, 9.22, 73, 3.6019, 4.1321, 19.3243, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 4, 14.24, 73, 4.0383, 7.9134, 24.3034, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 5, 46.63, 73, 5.5074, 35.9776, 57.5906, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 6, 8.66, 73, 2.9156, 4.3518, 16.5073, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 7, 5.40, 73, 3.7008, 1.3278, 19.4820, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'IM', NULL, 4.07, 73, 0.1128, 3.8426, 4.2924, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'RT', NULL, 86.02, 85, 5.1148, 72.5342, 93.4786, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 1, 6.20, 82, 2.7400, 2.5205, 14.4392, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 2, 30.70, 82, 5.3325, 21.2041, 42.1814, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 3, 16.82, 82, 4.0109, 10.2609, 26.3490, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 4, 18.00, 82, 5.0140, 10.0466, 30.1455, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 5, 25.84, 82, 4.2767, 18.2662, 35.1992, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 6, 2.44, 82, 1.7548, 0.5713, 9.7876, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 7, 0.00, 82, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'IM', NULL, 3.88, 81, 0.0934, 3.6988, 4.0706, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'RT', NULL, 94.36, 86, 2.5644, 86.5209, 97.7602, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 1, 18.22, 82, 4.3887, 11.0343, 28.5908, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 2, 27.99, 82, 5.0532, 19.0957, 39.0282, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 3, 15.14, 82, 4.8983, 7.7117, 27.5865, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 4, 14.17, 82, 4.2593, 7.6004, 24.8919, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 5, 19.47, 82, 4.6860, 11.7726, 30.4709, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 6, 1.77, 82, 1.2531, 0.4295, 7.0241, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 7, 3.23, 82, 2.1285, 0.8531, 11.4575, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'IM', NULL, 3.81, 81, 0.0924, 3.6292, 3.9971, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'RT', NULL, 95.22, 86, 2.2385, 88.2259, 98.1493, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 1, 7.52, 82, 3.1847, 3.1687, 16.8236, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 2, 23.32, 82, 4.8367, 15.0822, 34.2544, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 3, 23.36, 82, 5.6200, 14.0275, 36.2700, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 4, 18.98, 82, 4.4083, 11.6924, 29.2966, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 5, 21.48, 82, 4.4786, 13.8886, 31.6934, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 6, 2.63, 82, 1.8499, 0.6403, 10.2031, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 7, 2.70, 82, 1.8575, 0.6773, 10.1727, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'IM', NULL, 3.81, 82, 0.1116, 3.5834, 4.0274, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'RT', NULL, 95.53, 86, 2.1048, 88.9135, 98.2724, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 1, 30.97, 79, 5.7359, 20.8189, 43.3516, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 2, 29.62, 79, 5.0280, 20.6586, 40.4854, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 3, 21.20, 79, 4.5887, 13.4749, 31.7349, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 4, 8.11, 79, 3.0899, 3.7190, 16.7676, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 5, 8.45, 79, 2.9565, 4.1305, 16.4917, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 6, 0.00, 79, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 7, 1.66, 79, 1.6634, 0.2217, 11.3725, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'IM', NULL, 3.79, 78, 0.1252, 3.5433, 4.0421, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'RT', NULL, 91.62, 85, 4.5822, 76.9409, 97.2866, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 1, 16.99, 60, 5.7337, 8.3217, 31.5892, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 2, 28.61, 60, 6.2061, 17.9097, 42.3987, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 3, 21.20, 60, 5.4418, 12.2951, 34.0491, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 4, 16.82, 60, 5.6603, 8.2551, 31.2394, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 5, 14.88, 60, 4.4182, 8.0051, 26.0011, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 6, 1.50, 60, 1.4838, 0.2022, 10.2243, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 7, 0.00, 60, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'IM', NULL, 3.62, 60, 0.1482, 3.3220, 3.9149, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'RT', NULL, 68.82, 86, 5.4888, 57.0290, 78.5863, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 1, 13.61, 72, 4.5711, 6.7649, 25.4851, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 2, 28.19, 72, 5.2177, 19.0130, 39.6222, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 3, 25.46, 72, 5.2657, 16.4197, 37.2643, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 4, 18.16, 72, 4.6868, 10.5777, 29.3827, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 5, 14.58, 72, 4.6337, 7.5213, 26.3879, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 6, 0.00, 72, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 7, 0.00, 72, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'IM', NULL, 3.61, 72, 0.1159, 3.3811, 3.8431, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'RT', NULL, 81.54, 86, 5.7144, 67.4937, 90.3794, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 1, 15.53, 79, 4.4884, 8.5109, 26.6493, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 2, 29.37, 79, 5.5616, 19.6074, 41.4941, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 3, 24.13, 79, 4.8397, 15.8206, 34.9978, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 4, 10.66, 79, 3.3965, 5.5403, 19.5294, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 5, 14.05, 79, 3.9419, 7.8622, 23.8419, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 6, 2.79, 79, 1.9159, 0.6958, 10.4897, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 7, 3.47, 79, 2.2695, 0.9247, 12.1657, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'IM', NULL, 3.60, 78, 0.1024, 3.3984, 3.8063, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'RT', NULL, 91.04, 86, 3.9088, 79.6688, 96.3414, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 1, 8.34, 44, 4.2031, 2.9158, 21.6163, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 2, 30.61, 44, 7.0238, 18.4627, 46.2191, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 3, 5.09, 44, 2.9769, 1.5244, 15.6708, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 4, 9.66, 44, 4.8555, 3.3653, 24.7218, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 5, 43.42, 44, 7.0864, 30.0180, 57.8590, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 6, 0.00, 44, 0.0000, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 7, 2.88, 44, 2.6012, 0.4510, 16.2226, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'IM', NULL, 4.06, 44, 0.1568, 3.7473, 4.3799, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'RT', NULL, 52.37, 86, 6.2507, 40.0490, 64.4065, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 1, 14.01, 35, 6.5151, 5.1512, 32.8411, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 2, 25.46, 35, 8.8379, 11.7089, 46.8120, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 3, 11.44, 35, 5.5554, 4.0696, 28.2492, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 4, 2.12, 35, 2.1158, 0.2732, 14.6582, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 5, 34.87, 35, 7.9204, 20.8622, 52.1026, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 6, 2.12, 35, 2.1321, 0.2689, 14.8588, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 7, 9.96, 35, 6.9023, 2.2609, 34.5822, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'IM', NULL, 3.67, 35, 0.1853, 3.2953, 4.0484, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'RT', NULL, 40.10, 85, 5.6574, 29.5348, 51.6791, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 1, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 2, 36.84, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 3, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 4, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 5, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 6, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 7, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'IM', NULL, 4.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'RT', NULL, 100.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 1, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 2, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 3, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 4, 26.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 5, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 6, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'IM', NULL, 4.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'RT', NULL, 100.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 1, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 2, 27.78, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 3, 44.44, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 4, 22.22, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'IM', NULL, 4.22, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'RT', NULL, 94.74, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 1, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 2, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 3, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 4, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 5, 36.84, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 6, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 7, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'IM', NULL, 4.21, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'RT', NULL, 100.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 1, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 2, 17.65, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 3, 23.53, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 4, 17.65, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 5, 23.53, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 6, 11.76, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'IM', NULL, 4.18, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'RT', NULL, 89.47, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 1, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 2, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 3, 25.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 4, 43.75, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 5, 18.75, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 6, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'IM', NULL, 4.18, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'RT', NULL, 89.47, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 1, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 2, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 3, 26.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 4, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 5, 26.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 6, 26.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 7, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'IM', NULL, 4.13, 15, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'RT', NULL, 78.95, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 1, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 2, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 3, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 4, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 5, 50.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 6, 18.75, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 7, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'IM', NULL, 4.12, 16, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'RT', NULL, 84.21, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 1, 33.33, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 2, 38.89, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 3, 22.22, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 4, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'IM', NULL, 4.11, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'RT', NULL, 94.74, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 1, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 2, 36.84, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 3, 31.58, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 4, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 5, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 6, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 7, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'IM', NULL, 4.11, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'RT', NULL, 100.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 1, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 2, 26.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 3, 26.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 4, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 5, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 6, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'IM', NULL, 4.11, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'RT', NULL, 100.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 1, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 2, 27.78, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 3, 50.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 4, 22.22, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'IM', NULL, 4.06, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'RT', NULL, 94.74, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 1, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 2, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 3, 31.58, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 4, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 5, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 6, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'IM', NULL, 4.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'RT', NULL, 100.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 1, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 2, 23.53, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 3, 41.18, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 4, 23.53, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 5, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 6, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'IM', NULL, 4.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'RT', NULL, 89.47, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 1, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 2, 11.11, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 3, 27.78, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 4, 16.67, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 5, 27.78, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 6, 11.11, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 7, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'IM', NULL, 4.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'RT', NULL, 94.74, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 1, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 2, 22.22, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 3, 38.89, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 4, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 5, 16.67, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 6, 16.67, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'IM', NULL, 4.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'RT', NULL, 94.74, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 1, 17.65, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 2, 41.18, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 3, 23.53, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 4, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 5, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 6, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'IM', NULL, 3.24, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'RT', NULL, 89.47, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 1, 17.65, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 2, 52.94, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 3, 11.76, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 4, 11.76, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 5, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 6, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'IM', NULL, 3.12, 17, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'RT', NULL, 89.47, 19, NULL, NULL, NULL, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 2, 4.35, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 3, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 4, 4.35, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 5, 47.83, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 6, 21.74, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 7, 21.74, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'IM', NULL, 4.55, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 1, 18.18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 2, 9.09, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 3, 22.73, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 4, 22.73, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 5, 27.27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 6, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'IM', NULL, 4.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'RT', NULL, 95.83, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 2, 4.55, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 3, 27.27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 4, 4.55, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 5, 45.45, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 6, 13.64, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 7, 4.55, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'IM', NULL, 4.30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 2, 0.00, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 3, 3.10, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 4, 7.15, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 5, 54.25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 6, 18.99, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 7, 16.50, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'IM', NULL, 4.29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'RT', NULL, 97.17, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 1, 3.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 2, 6.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 3, 33.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 4, 10.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 5, 30.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 6, 16.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'IM', NULL, 4.13, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 1, 10.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 2, 13.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 3, 20.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 4, 26.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 5, 30.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 6, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'IM', NULL, 4.07, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 2, 6.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 3, 6.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 4, 30.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 5, 46.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 6, 6.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 7, 3.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'IM', NULL, 4.07, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 1, 23.81, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 2, 23.81, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 3, 28.57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 4, 9.52, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 5, 9.52, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 6, 4.76, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'IM', NULL, 4.05, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'RT', NULL, 91.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 2, 3.40, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 3, 9.41, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 4, 4.13, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 5, 51.87, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 6, 22.26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 7, 8.93, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'IM', NULL, 4.05, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'RT', NULL, 90.75, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 1, 3.45, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 2, 27.59, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 3, 34.48, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 4, 31.03, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 5, 3.45, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 6, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'IM', NULL, 4.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'RT', NULL, 96.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 2, 9.52, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 3, 38.10, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 4, 14.29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 5, 28.57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 6, 9.52, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'IM', NULL, 4.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'RT', NULL, 91.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'FT', 1, 6.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'FT', 2, 16.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'FT', 3, 23.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'FT', 4, 20.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'FT', 5, 30.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071