CREATE TABLE work_styles (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(7,4),
  lower_ci_bound DECIMAL(7,4),
  upper_ci_bound DECIMAL(7,4),
  recommend_suppress CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));
GO

INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.1.a', 'IM', 4.69, 28, 0.1218, 4.4426, 4.9426, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.1.b', 'IM', 4.76, 28, 0.1104, 4.5318, 4.9847, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.1.c', 'IM', 4.85, 28, 0.0770, 4.6927, 5.0000, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.2.b', 'IM', 4.97, 28, 0.0194, 4.9274, 5.0000, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.3.a', 'IM', 4.63, 27, 0.1880, 4.2387, 5.0000, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.3.b', 'IM', 4.50, 28, 0.1692, 4.1545, 4.8486, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.3.c', 'IM', 3.95, 28, 0.2019, 3.5339, 4.3626, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.4.a', 'IM', 4.21, 28, 0.2064, 3.7899, 4.6368, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.4.b', 'IM', 4.43, 28, 0.1500, 4.1179, 4.7336, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.4.c', 'IM', 4.35, 28, 0.1650, 4.0130, 4.6902, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.5.a', 'IM', 4.57, 28, 0.1784, 4.2069, 4.9390, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.5.b', 'IM', 4.44, 28, 0.1623, 4.1103, 4.7762, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.5.c', 'IM', 4.69, 28, 0.2015, 4.2758, 5.0000, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.6', 'IM', 4.13, 28, 0.1393, 3.8392, 4.4110, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.7.a', 'IM', 4.05, 27, 0.1373, 3.7667, 4.3314, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.7.b', 'IM', 4.70, 27, 0.1191, 4.4589, 4.9487, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.1.a', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.1.b', 'IM', 4.63, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.1.c', 'IM', 4.74, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.2.b', 'IM', 4.81, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.3.a', 'IM', 4.67, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.3.b', 'IM', 4.00, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.3.c', 'IM', 3.78, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.4.a', 'IM', 4.15, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.4.b', 'IM', 3.96, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.4.c', 'IM', 4.48, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.5.a', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.5.b', 'IM', 3.89, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.5.c', 'IM', 4.56, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.6', 'IM', 4.26, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.7.a', 'IM', 4.48, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.7.b', 'IM', 4.52, 27, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.1.a', 'IM', 4.29, 28, 0.1485, 3.9821, 4.5913, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.1.b', 'IM', 4.17, 28, 0.1696, 3.8250, 4.5211, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.1.c', 'IM', 4.47, 28, 0.1354, 4.1953, 4.7511, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.2.b', 'IM', 4.60, 28, 0.1631, 4.2655, 4.9348, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.3.a', 'IM', 4.41, 28, 0.1432, 4.1176, 4.7051, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.3.b', 'IM', 4.28, 28, 0.1718, 3.9249, 4.6298, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.3.c', 'IM', 3.89, 28, 0.2503, 3.3722, 4.3994, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.4.a', 'IM', 4.35, 28, 0.1868, 3.9701, 4.7367, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.4.b', 'IM', 4.44, 28, 0.1710, 4.0904, 4.7923, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.4.c', 'IM', 4.35, 28, 0.1689, 4.0016, 4.6949, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.5.a', 'IM', 4.83, 28, 0.0985, 4.6240, 5.0000, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.5.b', 'IM', 4.74, 27, 0.1256, 4.4782, 4.9945, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.5.c', 'IM', 4.84, 28, 0.0964, 4.6427, 5.0000, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.6', 'IM', 4.14, 28, 0.1986, 3.7285, 4.5436, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.7.a', 'IM', 4.13, 28, 0.1940, 3.7287, 4.5246, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.7.b', 'IM', 4.17, 28, 0.2347, 3.6836, 4.6466, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.1.a', 'IM', 4.10, 27, 0.1589, 3.7743, 4.4275, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.1.b', 'IM', 4.32, 27, 0.1581, 3.9955, 4.6454, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.1.c', 'IM', 4.56, 27, 0.1085, 4.3377, 4.7838, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.2.b', 'IM', 4.03, 27, 0.1870, 3.6423, 4.4111, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.3.a', 'IM', 4.51, 27, 0.1552, 4.1862, 4.8243, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.3.b', 'IM', 3.81, 27, 0.2067, 3.3881, 4.2377, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.3.c', 'IM', 3.70, 27, 0.2395, 3.2118, 4.1964, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.4.a', 'IM', 4.18, 26, 0.2012, 3.7698, 4.5987, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.4.b', 'IM', 4.35, 27, 0.1511, 4.0392, 4.6605, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.4.c', 'IM', 4.42, 27, 0.1435, 4.1289, 4.7188, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.5.a', 'IM', 4.51, 27, 0.1396, 4.2244, 4.7984, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.5.b', 'IM', 4.48, 27, 0.1359, 4.2005, 4.7594, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.5.c', 'IM', 4.17, 27, 0.1647, 3.8307, 4.5079, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.6', 'IM', 4.04, 27, 0.1474, 3.7394, 4.3453, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.7.a', 'IM', 3.99, 27, 0.1836, 3.6148, 4.3696, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.7.b', 'IM', 3.88, 27, 0.1539, 3.5601, 4.1926, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.1.a', 'IM', 4.32, 37, 0.1110, 4.0954, 4.5455, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.1.b', 'IM', 4.23, 37, 0.1742, 3.8792, 4.5857, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.1.c', 'IM', 4.53, 37, 0.2573, 4.0110, 5.0000, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.2.b', 'IM', 4.37, 37, 0.1896, 3.9820, 4.7512, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.3.a', 'IM', 4.08, 37, 0.1956, 3.6839, 4.4772, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.3.b', 'IM', 3.37, 36, 0.2350, 2.8896, 3.8436, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.3.c', 'IM', 3.80, 37, 0.2114, 3.3678, 4.2252, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.4.a', 'IM', 3.87, 37, 0.1925, 3.4751, 4.2558, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.4.b', 'IM', 4.01, 37, 0.2194, 3.5676, 4.4576, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.4.c', 'IM', 4.31, 37, 0.1372, 4.0359, 4.5923, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.5.a', 'IM', 4.35, 37, 0.1710, 4.0036, 4.6972, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.5.b', 'IM', 4.32, 37, 0.1587, 3.9944, 4.6380, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.5.c', 'IM', 4.17, 37, 0.1727, 3.8156, 4.5162, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.6', 'IM', 3.88, 37, 0.1674, 3.5450, 4.2241, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.7.a', 'IM', 4.15, 37, 0.1419, 3.8644, 4.4400, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.7.b', 'IM', 4.00, 37, 0.1499, 3.6931, 4.3011, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.1.a', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.1.b', 'IM', 4.48, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.1.c', 'IM', 4.78, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.2.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.3.a', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.3.b', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.3.c', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.4.a', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.4.b', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.4.c', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.5.a', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.5.b', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.5.c', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.6', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.7.a', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.7.b', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.1.a', 'IM', 3.97, 45, 0.0854, 3.7992, 4.1433, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.1.b', 'IM', 3.98, 45, 0.1339, 3.7073, 4.2470, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.1.c', 'IM', 4.24, 44, 0.0857, 4.0681, 4.4137, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.2.b', 'IM', 3.95, 45, 0.2324, 3.4813, 4.4179, 'N', '2017-07-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.3.a', 'IM', 4.30, 45, 0.0913, 4.1128, 4.4810, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.3.b', 'IM', 4.03, 45, 0.2286, 3.5739, 4.4952, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.3.c', 'IM', 3.65, 45, 0.1721, 3.3076, 4.0015, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.4.a', 'IM', 4.53, 44, 0.1256, 4.2754, 4.7818, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.4.b', 'IM', 4.44, 45, 0.1437, 4.1465, 4.7257, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.4.c', 'IM', 4.19, 45, 0.0858, 4.0192, 4.3650, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.5.a', 'IM', 4.69, 45, 0.0921, 4.5050, 4.8762, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.5.b', 'IM', 4.34, 45, 0.1155, 4.1068, 4.5721, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.5.c', 'IM', 4.73, 45, 0.0944, 4.5389, 4.9192, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.6', 'IM', 4.11, 45, 0.1124, 3.8862, 4.3392, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.7.a', 'IM', 3.85, 45, 0.0923, 3.6635, 4.0354, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.7.b', 'IM', 4.04, 45, 0.1173, 3.8049, 4.2778, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.1.a', 'IM', 4.02, 33, 0.1941, 3.6285, 4.4194, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.1.b', 'IM', 4.34, 33, 0.1524, 4.0321, 4.6531, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.1.c', 'IM', 4.40, 33, 0.1426, 4.1105, 4.6915, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.2.b', 'IM', 4.38, 32, 0.1471, 4.0798, 4.6799, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.3.a', 'IM', 4.51, 33, 0.1434, 4.2145, 4.7987, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.3.b', 'IM', 4.51, 33, 0.1671, 4.1698, 4.8507, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.3.c', 'IM', 4.16, 33, 0.1874, 3.7798, 4.5434, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.4.a', 'IM', 4.63, 33, 0.1391, 4.3488, 4.9154, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.4.b', 'IM', 4.52, 33, 0.1451, 4.2283, 4.8194, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.4.c', 'IM', 4.39, 32, 0.1491, 4.0868, 4.6949, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.5.a', 'IM', 4.68, 32, 0.1335, 4.4079, 4.9526, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.5.b', 'IM', 4.25, 33, 0.1329, 3.9777, 4.5191, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.5.c', 'IM', 4.78, 33, 0.1146, 4.5498, 5.0000, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.6', 'IM', 4.36, 33, 0.1485, 4.0572, 4.6622, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.7.a', 'IM', 4.04, 33, 0.2644, 3.5039, 4.5811, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3013.00', '1.C.7.b', 'IM', 4.11, 33, 0.2831, 3.5311, 4.6846, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.1.a', 'IM', 3.91, 26, 0.2246, 3.4473, 4.3724, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.1.b', 'IM', 4.03, 26, 0.1715, 3.6727, 4.3793, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.1.c', 'IM', 4.36, 26, 0.1508, 4.0503, 4.6713, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.2.b', 'IM', 4.15, 26, 0.2855, 3.5654, 4.7415, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.3.a', 'IM', 4.33, 26, 0.1834, 3.9535, 4.7089, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.3.b', 'IM', 3.71, 26, 0.3561, 2.9770, 4.4439, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.3.c', 'IM', 3.69, 26, 0.3958, 2.8785, 4.5088, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.4.a', 'IM', 4.10, 26, 0.1719, 3.7494, 4.4576, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.4.b', 'IM', 4.16, 26, 0.2250, 3.7009, 4.6276, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.4.c', 'IM', 4.19, 26, 0.1197, 3.9461, 4.4392, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.5.a', 'IM', 4.54, 26, 0.1258, 4.2767, 4.7948, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.5.b', 'IM', 4.67, 25, 0.1296, 4.3980, 4.9330, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.5.c', 'IM', 4.67, 26, 0.1339, 4.3909, 4.9425, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.6', 'IM', 3.80, 26, 0.1804, 3.4280, 4.1713, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.7.a', 'IM', 3.70, 26, 0.2013, 3.2902, 4.1195, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.7.b', 'IM', 4.25, 26, 0.1675, 3.9055, 4.5952, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.1.a', 'IM', 4.06, 17, 0.1210, 3.7995, 4.3124, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.1.b', 'IM', 3.92, 17, 0.0690, 3.7763, 4.0689, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.1.c', 'IM', 4.07, 17, 0.0745, 3.9151, 4.2308, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.2.b', 'IM', 4.47, 17, 0.0954, 4.2708, 4.6754, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.3.a', 'IM', 4.47, 17, 0.0890, 4.2784, 4.6559, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.3.b', 'IM', 4.31, 17, 0.2206, 3.8397, 4.7750, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.3.c', 'IM', 3.99, 17, 0.2686, 3.4222, 4.5609, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.4.a', 'IM', 4.09, 17, 0.2840, 3.4893, 4.6934, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.4.b', 'IM', 4.20, 16, 0.1303, 3.9185, 4.4741, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.4.c', 'IM', 4.16, 17, 0.1099, 3.9277, 4.3935, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.5.a', 'IM', 4.33, 17, 0.1708, 3.9658, 4.6898, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.5.b', 'IM', 4.68, 17, 0.1110, 4.4414, 4.9121, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.5.c', 'IM', 4.55, 17, 0.2535, 4.0127, 5.0000, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.6', 'IM', 4.06, 17, 0.2757, 3.4782, 4.6470, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.7.a', 'IM', 3.73, 17, 0.1551, 3.3990, 4.0568, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.7.b', 'IM', 4.19, 17, 0.1184, 3.9437, 4.4456, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.1.a', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.1.b', 'IM', 4.52, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.1.c', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.2.b', 'IM', 4.36, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.3.a', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.3.b', 'IM', 3.64, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.3.c', 'IM', 3.52, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.4.a', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.4.b', 'IM', 4.52, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.4.c', 'IM', 4.40, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.5.a', 'IM', 4.76, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.5.b', 'IM', 4.83, 24, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.5.c', 'IM', 5.00, 24, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.6', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.7.a', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.7.b', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.1.a', 'IM', 4.56, 24, 0.1726, 4.2003, 4.9143, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.1.b', 'IM', 4.52, 24, 0.1691, 4.1729, 4.8726, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.1.c', 'IM', 4.49, 24, 0.2079, 4.0559, 4.9160, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.2.b', 'IM', 3.99, 24, 0.2300, 3.5107, 4.4623, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.3.a', 'IM', 4.15, 25, 0.1516, 3.8330, 4.4586, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.3.b', 'IM', 3.04, 25, 0.1367, 2.7620, 3.3262, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.3.c', 'IM', 3.08, 25, 0.1980, 2.6760, 3.4931, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.4.a', 'IM', 4.06, 25, 0.1440, 3.7670, 4.3614, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.4.b', 'IM', 4.61, 25, 0.1281, 4.3496, 4.8785, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.4.c', 'IM', 3.75, 25, 0.1827, 3.3756, 4.1300, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.5.a', 'IM', 4.50, 25, 0.1562, 4.1779, 4.8227, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.5.b', 'IM', 4.39, 25, 0.1249, 4.1303, 4.6459, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.5.c', 'IM', 4.92, 25, 0.0484, 4.8220, 5.0000, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.6', 'IM', 3.70, 25, 0.2228, 3.2416, 4.1611, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.7.a', 'IM', 3.35, 25, 0.1319, 3.0746, 3.6189, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.7.b', 'IM', 4.79, 25, 0.0914, 4.5999, 4.9771, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.1.a', 'IM', 4.12, 34, 0.0801, 3.9527, 4.2787, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.1.b', 'IM', 4.19, 34, 0.1026, 3.9841, 4.4018, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.1.c', 'IM', 4.31, 34, 0.1297, 4.0416, 4.5695, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.2.b', 'IM', 4.49, 34, 0.1491, 4.1903, 4.7969, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.3.a', 'IM', 4.29, 34, 0.1277, 4.0313, 4.5511, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.3.b', 'IM', 4.10, 34, 0.1464, 3.8027, 4.3986, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.3.c', 'IM', 3.61, 33, 0.1435, 3.3212, 3.9058, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.4.a', 'IM', 4.28, 34, 0.2006, 3.8740, 4.6901, 'N', '2021-08-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.4.b', 'IM', 4.25, 34, 0.1346, 3.9801, 4.5278, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.4.c', 'IM', 4.34, 33, 0.1683, 4.0021, 4.6876, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.5.a', 'IM', 4.43, 34, 0.1249, 4.1793, 4.6875, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.5.b', 'IM', 4.72, 34, 0.0850, 4.5463, 4.8920, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.5.c', 'IM', 4.48, 33, 0.1058, 4.2687, 4.6996, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.6', 'IM', 4.04, 33, 0.1503, 3.7375, 4.3496, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.7.a', 'IM', 3.75, 33, 0.1872, 3.3674, 4.1301, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.7.b', 'IM', 4.09, 33, 0.2040, 3.6766, 4.5075, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.1.a', 'IM', 3.94, 17, 0.1819, 3.5552, 4.3264, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.1.b', 'IM', 3.92, 17, 0.2118, 3.4665, 4.3645, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.1.c', 'IM', 4.74, 17, 0.1403, 4.4411, 5.0000, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.2.b', 'IM', 4.63, 17, 0.1699, 4.2667, 4.9872, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.3.a', 'IM', 4.59, 17, 0.1739, 4.2245, 4.9618, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.3.b', 'IM', 3.97, 17, 0.3166, 3.2996, 4.6417, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.3.c', 'IM', 3.73, 17, 0.3302, 3.0288, 4.4289, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.4.a', 'IM', 4.24, 17, 0.2142, 3.7819, 4.6900, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.4.b', 'IM', 4.20, 16, 0.1861, 3.7998, 4.5930, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.4.c', 'IM', 4.14, 17, 0.2098, 3.6978, 4.5874, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.5.a', 'IM', 4.47, 16, 0.2295, 3.9820, 4.9604, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.5.b', 'IM', 4.75, 17, 0.1553, 4.4191, 5.0000, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.5.c', 'IM', 4.83, 17, 0.1282, 4.5535, 5.0000, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.6', 'IM', 4.06, 17, 0.1432, 3.7610, 4.3681, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.7.a', 'IM', 3.57, 17, 0.2448, 3.0492, 4.0873, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.7.b', 'IM', 4.47, 17, 0.1937, 4.0634, 4.8847, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.1.a', 'IM', 4.14, 21, 0.1050, 3.9168, 4.3548, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.1.b', 'IM', 3.95, 21, 0.1161, 3.7100, 4.1942, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.1.c', 'IM', 4.21, 21, 0.1556, 3.8842, 4.5334, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.2.b', 'IM', 4.48, 21, 0.1136, 4.2408, 4.7147, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.3.a', 'IM', 4.29, 21, 0.1169, 4.0511, 4.5388, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.3.b', 'IM', 4.06, 21, 0.1468, 3.7539, 4.3663, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.3.c', 'IM', 3.81, 21, 0.1861, 3.4219, 4.1984, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.4.a', 'IM', 4.15, 20, 0.1194, 3.8955, 4.3953, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.4.b', 'IM', 4.38, 21, 0.1103, 4.1521, 4.6123, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.4.c', 'IM', 4.13, 21, 0.1178, 3.8871, 4.3783, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.5.a', 'IM', 4.46, 21, 0.1143, 4.2169, 4.6935, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.5.b', 'IM', 4.41, 21, 0.1628, 4.0735, 4.7527, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.5.c', 'IM', 4.57, 21, 0.0806, 4.3986, 4.7347, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.6', 'IM', 3.80, 21, 0.2393, 3.3042, 4.3024, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.7.a', 'IM', 4.35, 21, 0.1585, 4.0180, 4.6790, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.7.b', 'IM', 4.41, 21, 0.1535, 4.0922, 4.7325, 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.1.a', 'IM', 3.82, 23, 0.1731, 3.4641, 4.1821, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.1.b', 'IM', 4.00, 23, 0.1908, 3.5995, 4.3908, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.1.c', 'IM', 4.37, 23, 0.1641, 4.0315, 4.7122, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.2.b', 'IM', 4.46, 23, 0.1466, 4.1572, 4.7652, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.3.a', 'IM', 4.15, 23, 0.1347, 3.8732, 4.4320, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.3.b', 'IM', 3.66, 23, 0.2003, 3.2432, 4.0740, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.3.c', 'IM', 3.28, 23, 0.2354, 2.7925, 3.7689, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.4.a', 'IM', 4.06, 23, 0.1342, 3.7790, 4.3356, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.4.b', 'IM', 4.09, 23, 0.2143, 3.6410, 4.5298, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.4.c', 'IM', 4.16, 23, 0.1618, 3.8258, 4.4970, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.5.a', 'IM', 4.67, 23, 0.0985, 4.4669, 4.8753, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.5.b', 'IM', 4.52, 23, 0.1509, 4.2105, 4.8363, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.5.c', 'IM', 4.32, 23, 0.1699, 3.9714, 4.6763, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.6', 'IM', 3.83, 23, 0.2139, 3.3841, 4.2712, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.7.a', 'IM', 4.06, 23, 0.1969, 3.6536, 4.4702, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.7.b', 'IM', 4.29, 23, 0.1896, 3.8982, 4.6848, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.1.a', 'IM', 4.16, 21, 0.1742, 3.8002, 4.5271, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.1.b', 'IM', 3.98, 21, 0.2037, 3.5558, 4.4057, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.1.c', 'IM', 4.33, 21, 0.1553, 4.0043, 4.6521, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.2.b', 'IM', 4.20, 21, 0.2959, 3.5781, 4.8124, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.3.a', 'IM', 4.31, 21, 0.1953, 3.9050, 4.7198, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.3.b', 'IM', 4.13, 21, 0.1941, 3.7237, 4.5336, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.3.c', 'IM', 3.00, 21, 0.4061, 2.1555, 3.8495, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.4.a', 'IM', 4.03, 21, 0.0254, 3.9744, 4.0802, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.4.b', 'IM', 4.62, 21, 0.1597, 4.2875, 4.9538, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.4.c', 'IM', 4.02, 21, 0.1271, 3.7541, 4.2842, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.5.a', 'IM', 4.36, 21, 0.1558, 4.0305, 4.6806, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.5.b', 'IM', 4.07, 20, 0.2389, 3.5747, 4.5748, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.5.c', 'IM', 4.48, 21, 0.1687, 4.1304, 4.8343, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.6', 'IM', 3.92, 21, 0.1592, 3.5899, 4.2542, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.7.a', 'IM', 3.51, 21, 0.2707, 2.9472, 4.0766, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.7.b', 'IM', 4.08, 21, 0.2159, 3.6259, 4.5267, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.1.a', 'IM', 3.81, 29, 0.1552, 3.4917, 4.1277, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.1.b', 'IM', 3.89, 29, 0.1790, 3.5236, 4.2568, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.1.c', 'IM', 4.13, 29, 0.1317, 3.8558, 4.3954, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.2.b', 'IM', 4.53, 29, 0.1183, 4.2917, 4.7762, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.3.a', 'IM', 4.20, 27, 0.0996, 3.9999, 4.4096, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.3.b', 'IM', 3.58, 27, 0.1748, 3.2217, 3.9404, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.3.c', 'IM', 3.12, 27, 0.1752, 2.7619, 3.4820, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.4.a', 'IM', 4.02, 27, 0.1460, 3.7207, 4.3211, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.4.b', 'IM', 4.12, 27, 0.1538, 3.8018, 4.4341, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.4.c', 'IM', 3.79, 26, 0.1535, 3.4761, 4.1082, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.5.a', 'IM', 4.53, 27, 0.0879, 4.3507, 4.7120, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.5.b', 'IM', 4.47, 27, 0.0880, 4.2900, 4.6516, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.5.c', 'IM', 4.34, 29, 0.1229, 4.0893, 4.5928, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.6', 'IM', 4.19, 29, 0.1095, 3.9685, 4.4170, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.7.a', 'IM', 3.68, 29, 0.1648, 3.3392, 4.0143, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.7.b', 'IM', 4.19, 29, 0.1087, 3.9693, 4.4145, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.1.a', 'IM', 4.05, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.1.b', 'IM', 4.00, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.1.c', 'IM', 4.26, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.2.b', 'IM', 4.26, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.3.a', 'IM', 4.53, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.3.b', 'IM', 3.89, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.3.c', 'IM', 3.53, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.4.a', 'IM', 4.32, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.4.b', 'IM', 4.53, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.4.c', 'IM', 4.47, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.5.a', 'IM', 4.53, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.5.b', 'IM', 4.74, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.5.c', 'IM', 4.84, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.6', 'IM', 4.05, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.7.a', 'IM', 3.68, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.7.b', 'IM', 4.32, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.1.a', 'IM', 3.90, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.1.b', 'IM', 4.07, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.1.c', 'IM', 4.21, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.2.b', 'IM', 4.41, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.3.a', 'IM', 4.25, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.3.b', 'IM', 3.71, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.3.c', 'IM', 3.53, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.4.a', 'IM', 4.25, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.4.b', 'IM', 4.40, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.4.c', 'IM', 4.21, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.5.a', 'IM', 4.54, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.5.b', 'IM', 4.28, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.5.c', 'IM', 4.50, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.6', 'IM', 3.80, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.7.a', 'IM', 3.74, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.7.b', 'IM', 4.07, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.1.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.1.b', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.1.c', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.2.b', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.3.a', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.3.b', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.3.c', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.4.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.4.b', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.4.c', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.5.a', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.5.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.5.c', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.6', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.7.a', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.7.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.1.a', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.1.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.1.c', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.2.b', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.3.a', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.3.b', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.3.c', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.4.a', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.4.b', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.4.c', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.5.a', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.5.b', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.5.c', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.6', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.7.a', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.7.b', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.1.a', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.1.b', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.1.c', 'IM', 4.54, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.2.b', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.3.a', 'IM', 4.54, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.3.b', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.3.c', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.4.a', 'IM', 4.71, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.4.b', 'IM', 4.50, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.4.c', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.5.a', 'IM', 4.58, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.5.b', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.5.c', 'IM', 4.88, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.6', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.7.a', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.7.b', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.1.a', 'IM', 4.04, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.1.b', 'IM', 4.07, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.1.c', 'IM', 4.46, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.2.b', 'IM', 4.57, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.3.a', 'IM', 4.38, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.3.b', 'IM', 4.21, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.3.c', 'IM', 3.96, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.4.a', 'IM', 3.93, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.4.b', 'IM', 3.86, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.4.c', 'IM', 4.54, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.5.a', 'IM', 4.50, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.5.b', 'IM', 4.29, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.5.c', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.6', 'IM', 3.68, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.7.a', 'IM', 4.00, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.7.b', 'IM', 4.11, 28, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.1.a', 'IM', 3.97, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.1.b', 'IM', 4.08, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.1.c', 'IM', 4.21, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.2.b', 'IM', 4.18, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.3.a', 'IM', 4.01, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.3.b', 'IM', 3.69, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.3.c', 'IM', 3.20, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.4.a', 'IM', 3.94, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.4.b', 'IM', 3.75, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.4.c', 'IM', 3.98, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.5.a', 'IM', 4.53, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.5.b', 'IM', 4.18, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.5.c', 'IM', 4.39, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.6', 'IM', 3.94, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.7.a', 'IM', 3.98, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.7.b', 'IM', 3.98, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.1.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.1.b', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.1.c', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.2.b', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.3.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.3.b', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.3.c', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.4.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.4.b', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.4.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.5.a', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.5.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.5.c', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.6', 'IM', 3.68, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.7.a', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.7.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.1.a', 'IM', 3.60, 27, 0.2068, 3.1706, 4.0206, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.1.b', 'IM', 3.61, 27, 0.2594, 3.0802, 4.1464, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.1.c', 'IM', 3.98, 27, 0.2813, 3.3999, 4.5563, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.2.b', 'IM', 4.35, 27, 0.1500, 4.0372, 4.6540, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.3.a', 'IM', 4.33, 26, 0.1224, 4.0786, 4.5830, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.3.b', 'IM', 4.37, 27, 0.1293, 4.1006, 4.6322, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.3.c', 'IM', 3.84, 27, 0.2809, 3.2621, 4.4170, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.4.a', 'IM', 4.50, 27, 0.1568, 4.1756, 4.8201, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.4.b', 'IM', 4.71, 27, 0.1164, 4.4701, 4.9487, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.4.c', 'IM', 4.48, 27, 0.1625, 4.1476, 4.8155, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.5.a', 'IM', 4.91, 27, 0.0670, 4.7722, 5.0000, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.5.b', 'IM', 4.39, 27, 0.2574, 3.8566, 4.9146, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.5.c', 'IM', 4.69, 27, 0.1788, 4.3179, 5.0000, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.6', 'IM', 4.44, 27, 0.2189, 3.9928, 4.8927, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.7.a', 'IM', 3.97, 27, 0.1666, 3.6270, 4.3120, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.7.b', 'IM', 3.56, 27, 0.2442, 3.0583, 4.0621, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.1.a', 'IM', 4.14, 26, 0.1804, 3.7733, 4.5165, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.1.b', 'IM', 4.29, 26, 0.1712, 3.9333, 4.6386, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.1.c', 'IM', 4.54, 26, 0.1897, 4.1527, 4.9342, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.2.b', 'IM', 4.75, 26, 0.1224, 4.4999, 5.0000, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.3.a', 'IM', 4.37, 26, 0.1590, 4.0406, 4.6957, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.3.b', 'IM', 4.43, 26, 0.1855, 4.0451, 4.8091, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.3.c', 'IM', 3.97, 26, 0.3359, 3.2749, 4.6583, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.4.a', 'IM', 4.55, 26, 0.1361, 4.2718, 4.8322, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.4.b', 'IM', 4.20, 26, 0.1910, 3.8068, 4.5933, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.4.c', 'IM', 4.32, 26, 0.1791, 3.9526, 4.6903, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.5.a', 'IM', 4.75, 26, 0.1122, 4.5185, 4.9806, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.5.b', 'IM', 4.12, 26, 0.2150, 3.6818, 4.5672, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.5.c', 'IM', 4.87, 26, 0.0909, 4.6828, 5.0000, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.6', 'IM', 4.33, 26, 0.2472, 3.8163, 4.8347, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.7.a', 'IM', 4.17, 26, 0.1968, 3.7653, 4.5761, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.7.b', 'IM', 4.38, 26, 0.2082, 3.9492, 4.8067, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.1.a', 'IM', 4.41, 40, 0.0971, 4.2166, 4.6095, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.1.b', 'IM', 4.41, 40, 0.1099, 4.1856, 4.6302, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.1.c', 'IM', 4.63, 40, 0.0993, 4.4252, 4.8271, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.2.b', 'IM', 4.58, 40, 0.1333, 4.3082, 4.8475, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.3.a', 'IM', 4.51, 40, 0.0998, 4.3068, 4.7107, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.3.b', 'IM', 4.28, 40, 0.1431, 3.9925, 4.5715, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.3.c', 'IM', 3.99, 40, 0.2051, 3.5724, 4.4020, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.4.a', 'IM', 4.36, 40, 0.1319, 4.0981, 4.6315, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.4.b', 'IM', 4.26, 40, 0.1520, 3.9555, 4.5706, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.4.c', 'IM', 4.34, 40, 0.1657, 4.0060, 4.6763, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.5.a', 'IM', 4.57, 40, 0.1367, 4.2942, 4.8472, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.5.b', 'IM', 4.35, 40, 0.1317, 4.0786, 4.6115, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.5.c', 'IM', 4.61, 40, 0.1109, 4.3849, 4.8336, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.6', 'IM', 4.26, 39, 0.1711, 3.9127, 4.6053, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.7.a', 'IM', 3.97, 40, 0.1628, 3.6425, 4.3012, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.7.b', 'IM', 4.18, 40, 0.1821, 3.8089, 4.5456, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.1.a', 'IM', 3.97, 23, 0.1868, 3.5872, 4.3618, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.1.b', 'IM', 3.93, 23, 0.2910, 3.3310, 4.5378, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.1.c', 'IM', 3.94, 23, 0.1732, 3.5812, 4.2996, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.2.b', 'IM', 4.08, 23, 0.1215, 3.8304, 4.3345, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.3.a', 'IM', 4.23, 23, 0.2601, 3.6953, 4.7740, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.3.b', 'IM', 3.27, 22, 0.2064, 2.8446, 3.7032, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.3.c', 'IM', 3.34, 23, 0.1424, 3.0462, 3.6368, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.4.a', 'IM', 4.04, 23, 0.1800, 3.6655, 4.4121, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.4.b', 'IM', 4.35, 23, 0.1748, 3.9872, 4.7122, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.4.c', 'IM', 3.94, 23, 0.1602, 3.6040, 4.2686, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.5.a', 'IM', 4.65, 23, 0.1014, 4.4404, 4.8610, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.5.b', 'IM', 4.54, 23, 0.1254, 4.2787, 4.7987, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.5.c', 'IM', 4.71, 23, 0.1544, 4.3866, 5.0000, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.6', 'IM', 3.98, 23, 0.1460, 3.6733, 4.2789, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.7.a', 'IM', 4.09, 23, 0.1638, 3.7541, 4.4335, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.7.b', 'IM', 4.76, 23, 0.1379, 4.4758, 5.0000, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.1.a', 'IM', 3.86, 33, 0.1802, 3.4951, 4.2293, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.1.b', 'IM', 3.87, 33, 0.1295, 3.6068, 4.1345, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.1.c', 'IM', 3.96, 33, 0.0914, 3.7751, 4.1474, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.2.b', 'IM', 3.75, 32, 0.2045, 3.3314, 4.1656, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.3.a', 'IM', 3.92, 33, 0.1191, 3.6747, 4.1598, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.3.b', 'IM', 3.47, 33, 0.2173, 3.0224, 3.9077, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.3.c', 'IM', 3.18, 33, 0.2836, 2.6041, 3.7594, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.4.a', 'IM', 3.81, 33, 0.2393, 3.3232, 4.2983, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.4.b', 'IM', 3.99, 33, 0.1216, 3.7443, 4.2396, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.4.c', 'IM', 4.53, 33, 0.1878, 4.1480, 4.9131, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.5.a', 'IM', 4.37, 33, 0.1555, 4.0563, 4.6898, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.5.b', 'IM', 4.08, 32, 0.1757, 3.7178, 4.4347, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.5.c', 'IM', 4.26, 33, 0.1843, 3.8825, 4.6333, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.6', 'IM', 3.81, 33, 0.1450, 3.5105, 4.1013, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.7.a', 'IM', 3.70, 33, 0.2074, 3.2774, 4.1224, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.7.b', 'IM', 4.42, 33, 0.1706, 4.0703, 4.7654, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.1.a', 'IM', 4.16, 30, 0.3014, 3.5397, 4.7724, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.1.b', 'IM', 4.19, 29, 0.2397, 3.6971, 4.6791, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.1.c', 'IM', 4.19, 30, 0.2982, 3.5804, 4.8003, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.2.b', 'IM', 4.65, 30, 0.1651, 4.3107, 4.9860, 'N', '2017-07-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.3.a', 'IM', 4.46, 30, 0.2677, 3.9149, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.3.b', 'IM', 4.35, 30, 0.2639, 3.8118, 4.8913, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.3.c', 'IM', 4.03, 30, 0.2753, 3.4682, 4.5944, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.4.a', 'IM', 4.54, 30, 0.1763, 4.1748, 4.8961, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.4.b', 'IM', 4.44, 30, 0.2573, 3.9097, 4.9621, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.4.c', 'IM', 4.05, 30, 0.3610, 3.3101, 4.7868, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.5.a', 'IM', 4.67, 30, 0.1613, 4.3423, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.5.b', 'IM', 4.35, 30, 0.2682, 3.8030, 4.9003, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.5.c', 'IM', 4.27, 30, 0.3119, 3.6320, 4.9077, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.6', 'IM', 3.90, 30, 0.2711, 3.3457, 4.4547, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.7.a', 'IM', 3.59, 30, 0.3035, 2.9695, 4.2109, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.7.b', 'IM', 3.64, 30, 0.3281, 2.9731, 4.3152, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.1.a', 'IM', 3.80, 27, 0.2682, 3.2481, 4.3507, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.1.b', 'IM', 4.07, 27, 0.1830, 3.6960, 4.4482, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.1.c', 'IM', 4.25, 27, 0.1299, 3.9843, 4.5182, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.2.b', 'IM', 4.50, 27, 0.1210, 4.2525, 4.7500, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.3.a', 'IM', 4.43, 27, 0.1168, 4.1929, 4.6732, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.3.b', 'IM', 4.21, 27, 0.1399, 3.9209, 4.4960, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.3.c', 'IM', 3.78, 27, 0.1673, 3.4319, 4.1198, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.4.a', 'IM', 4.49, 27, 0.1558, 4.1726, 4.8130, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.4.b', 'IM', 4.43, 27, 0.0775, 4.2741, 4.5927, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.4.c', 'IM', 4.30, 27, 0.1466, 4.0012, 4.6038, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.5.a', 'IM', 4.63, 27, 0.1007, 4.4270, 4.8408, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.5.b', 'IM', 4.51, 27, 0.1120, 4.2798, 4.7401, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.5.c', 'IM', 4.83, 27, 0.0736, 4.6817, 4.9844, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.6', 'IM', 4.39, 27, 0.1446, 4.0937, 4.6881, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.7.a', 'IM', 3.44, 27, 0.1722, 3.0892, 3.7969, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.7.b', 'IM', 4.16, 27, 0.1327, 3.8823, 4.4278, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.1.a', 'IM', 4.53, 15, 0.1931, 4.1140, 4.9424, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.1.b', 'IM', 4.90, 15, 0.0851, 4.7160, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.1.c', 'IM', 4.86, 14, 0.1013, 4.6408, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.2.b', 'IM', 4.53, 15, 0.3269, 3.8252, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.3.a', 'IM', 4.70, 15, 0.1743, 4.3300, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.3.b', 'IM', 4.34, 15, 0.1709, 3.9708, 4.7038, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.3.c', 'IM', 4.49, 15, 0.3285, 3.7855, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.4.a', 'IM', 4.81, 15, 0.1640, 4.4536, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.4.b', 'IM', 4.73, 15, 0.1733, 4.3567, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.4.c', 'IM', 4.80, 15, 0.1639, 4.4522, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.5.a', 'IM', 4.92, 15, 0.0830, 4.7394, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.5.b', 'IM', 4.81, 15, 0.1640, 4.4593, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.5.c', 'IM', 4.72, 15, 0.1735, 4.3507, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.6', 'IM', 4.53, 15, 0.1939, 4.1180, 4.9496, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.7.a', 'IM', 4.09, 15, 0.2717, 3.5104, 4.6760, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.7.b', 'IM', 4.52, 15, 0.1936, 4.1054, 4.9359, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.1.a', 'IM', 4.21, 28, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.1.b', 'IM', 4.32, 28, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.1.c', 'IM', 4.50, 28, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.2.b', 'IM', 4.75, 28, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.3.a', 'IM', 4.75, 28, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.3.b', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.3.c', 'IM', 3.86, 28, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.4.a', 'IM', 4.57, 28, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.4.b', 'IM', 4.46, 28, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.4.c', 'IM', 4.54, 28, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.5.a', 'IM', 4.68, 28, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.5.b', 'IM', 4.46, 28, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.5.c', 'IM', 4.81, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.6', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.7.a', 'IM', 3.88, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.7.b', 'IM', 4.41, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.1.a', 'IM', 4.16, 25, 0.1602, 3.8257, 4.4870, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.1.b', 'IM', 4.40, 25, 0.0830, 4.2325, 4.5752, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.1.c', 'IM', 4.34, 25, 0.1274, 4.0731, 4.5992, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.2.b', 'IM', 4.32, 25, 0.2494, 3.8003, 4.8298, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.3.a', 'IM', 4.36, 25, 0.1178, 4.1173, 4.6034, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.3.b', 'IM', 3.77, 25, 0.2847, 3.1797, 4.3550, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.3.c', 'IM', 2.97, 25, 0.1797, 2.6015, 3.3432, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.4.a', 'IM', 4.27, 25, 0.1653, 3.9266, 4.6088, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.4.b', 'IM', 4.12, 24, 0.1640, 3.7801, 4.4586, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.4.c', 'IM', 4.31, 25, 0.0964, 4.1065, 4.5043, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.5.a', 'IM', 4.38, 25, 0.2055, 3.9588, 4.8071, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.5.b', 'IM', 4.47, 25, 0.1742, 4.1145, 4.8336, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.5.c', 'IM', 4.65, 25, 0.1268, 4.3912, 4.9148, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.6', 'IM', 4.13, 25, 0.1429, 3.8332, 4.4231, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.7.a', 'IM', 3.67, 25, 0.2720, 3.1089, 4.2317, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.7.b', 'IM', 4.32, 25, 0.1846, 3.9350, 4.6968, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.1.a', 'IM', 4.24, 19, 0.1652, 3.8961, 4.5901, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.1.b', 'IM', 4.16, 19, 0.1671, 3.8075, 4.5095, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.1.c', 'IM', 4.55, 19, 0.1985, 4.1373, 4.9713, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.2.b', 'IM', 4.06, 19, 0.2270, 3.5850, 4.5388, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.3.a', 'IM', 4.75, 19, 0.1728, 4.3912, 5.0000, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.3.b', 'IM', 4.44, 19, 0.2080, 4.0005, 4.8744, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.3.c', 'IM', 4.04, 19, 0.2329, 3.5537, 4.5323, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.4.a', 'IM', 4.58, 19, 0.1491, 4.2680, 4.8943, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.4.b', 'IM', 4.33, 19, 0.1912, 3.9290, 4.7322, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.4.c', 'IM', 4.39, 19, 0.2023, 3.9673, 4.8174, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.5.a', 'IM', 4.61, 19, 0.1559, 4.2859, 4.9412, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.5.b', 'IM', 4.54, 19, 0.2100, 4.1020, 4.9844, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.5.c', 'IM', 4.66, 19, 0.1661, 4.3104, 5.0000, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.6', 'IM', 4.24, 19, 0.1884, 3.8445, 4.6363, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.7.a', 'IM', 3.69, 19, 0.1838, 3.3037, 4.0758, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.7.b', 'IM', 3.95, 19, 0.1919, 3.5450, 4.3512, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.1.a', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.1.b', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.1.c', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.2.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.3.a', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.3.b', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.3.c', 'IM', 2.50, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.4.a', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.4.b', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.4.c', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.5.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.5.b', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.5.c', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.6', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.7.a', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.7.b', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.1.a', 'IM', 4.16, 29, 0.2181, 3.7111, 4.6044, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.1.b', 'IM', 4.31, 29, 0.2101, 3.8842, 4.7449, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.1.c', 'IM', 4.44, 29, 0.1435, 4.1464, 4.7344, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.2.b', 'IM', 4.66, 29, 0.1510, 4.3458, 4.9647, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.3.a', 'IM', 4.50, 28, 0.1382, 4.2205, 4.7875, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.3.b', 'IM', 4.21, 28, 0.1487, 3.9035, 4.5135, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.3.c', 'IM', 3.56, 28, 0.2877, 2.9704, 4.1510, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.4.a', 'IM', 4.59, 28, 0.1100, 4.3609, 4.8125, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.4.b', 'IM', 4.41, 28, 0.1229, 4.1534, 4.6576, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.4.c', 'IM', 4.71, 28, 0.0941, 4.5203, 4.9067, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.5.a', 'IM', 4.80, 28, 0.0977, 4.5959, 4.9969, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.5.b', 'IM', 4.47, 28, 0.1687, 4.1277, 4.8198, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.5.c', 'IM', 4.66, 29, 0.1537, 4.3437, 4.9735, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.6', 'IM', 4.08, 29, 0.1613, 3.7468, 4.4078, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.7.a', 'IM', 3.77, 29, 0.2111, 3.3388, 4.2037, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.7.b', 'IM', 4.06, 29, 0.2980, 3.4463, 4.6670, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.1.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.1.b', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.1.c', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.2.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.3.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.3.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.3.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.4.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.4.b', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.4.c', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.5.a', 'IM', 4.80, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.5.b', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.5.c', 'IM', 4.85, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.6', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.7.a', 'IM', 3.15, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.7.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.1.a', 'IM', 4.43, 27, 0.1368, 4.1524, 4.7149, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.1.b', 'IM', 4.49, 27, 0.1224, 4.2411, 4.7443, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.1.c', 'IM', 4.71, 27, 0.0950, 4.5125, 4.9030, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.2.b', 'IM', 4.85, 27, 0.0644, 4.7178, 4.9826, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.3.a', 'IM', 4.52, 27, 0.1133, 4.2850, 4.7508, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.3.b', 'IM', 4.47, 27, 0.1301, 4.2074, 4.7421, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.3.c', 'IM', 4.25, 27, 0.1388, 3.9644, 4.5352, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.4.a', 'IM', 4.67, 26, 0.0922, 4.4836, 4.8635, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.4.b', 'IM', 4.59, 27, 0.1239, 4.3399, 4.8494, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.4.c', 'IM', 4.72, 26, 0.1089, 4.4989, 4.9475, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.5.a', 'IM', 4.75, 27, 0.1178, 4.5046, 4.9889, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.5.b', 'IM', 4.34, 27, 0.1458, 4.0444, 4.6438, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.5.c', 'IM', 4.85, 27, 0.0797, 4.6854, 5.0000, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.6', 'IM', 4.08, 27, 0.2258, 3.6141, 4.5426, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.7.a', 'IM', 3.89, 27, 0.1535, 3.5719, 4.2031, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.7.b', 'IM', 4.17, 27, 0.1299, 3.8980, 4.4321, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.1.a', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.1.b', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.1.c', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.2.b', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.3.a', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.3.b', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.3.c', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.4.a', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.4.b', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.4.c', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.5.a', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.5.b', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.5.c', 'IM', 4.68, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.6', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.7.a', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.7.b', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.1.a', 'IM', 3.67, 17, 0.2513, 3.1388, 4.2043, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.1.b', 'IM', 3.59, 17, 0.1570, 3.2533, 3.9191, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.1.c', 'IM', 3.87, 17, 0.3655, 3.0983, 4.6482, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.2.b', 'IM', 3.93, 17, 0.2127, 3.4767, 4.3785, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.3.a', 'IM', 4.10, 17, 0.1963, 3.6810, 4.5133, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.3.b', 'IM', 4.59, 17, 0.2705, 4.0152, 5.0000, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.3.c', 'IM', 3.85, 17, 0.2106, 3.4014, 4.2943, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.4.a', 'IM', 4.56, 17, 0.1788, 4.1788, 4.9369, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.4.b', 'IM', 4.25, 17, 0.2181, 3.7895, 4.7140, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.4.c', 'IM', 4.62, 17, 0.1837, 4.2292, 5.0000, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.5.a', 'IM', 4.75, 17, 0.1537, 4.4196, 5.0000, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.5.b', 'IM', 4.72, 17, 0.1571, 4.3879, 5.0000, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.5.c', 'IM', 4.89, 17, 0.0811, 4.7221, 5.0000, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.6', 'IM', 3.51, 17, 0.1864, 3.1109, 3.9012, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.7.a', 'IM', 3.21, 17, 0.1971, 2.7961, 3.6317, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.7.b', 'IM', 3.66, 17, 0.1638, 3.3171, 4.0116, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.1.a', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.1.b', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.1.c', 'IM', 4.58, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.2.b', 'IM', 4.50, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.3.a', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.3.b', 'IM', 4.38, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.3.c', 'IM', 4.27, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.4.a', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.4.b', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.4.c', 'IM', 4.46, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.5.a', 'IM', 4.50, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.5.b', 'IM', 4.12, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.5.c', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.6', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.7.a', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.7.b', 'IM', 3.73, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.1.a', 'IM', 4.04, 21, 0.2960, 3.4269, 4.6619, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.1.b', 'IM', 4.23, 21, 0.3225, 3.5526, 4.8979, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.1.c', 'IM', 4.52, 21, 0.1509, 4.2100, 4.8393, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.2.b', 'IM', 4.40, 21, 0.1582, 4.0714, 4.7315, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.3.a', 'IM', 4.69, 21, 0.2070, 4.2576, 5.0000, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.3.b', 'IM', 4.53, 21, 0.1495, 4.2181, 4.8419, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.3.c', 'IM', 3.87, 21, 0.3600, 3.1179, 4.6199, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.4.a', 'IM', 4.43, 21, 0.4069, 3.5835, 5.0000, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.4.b', 'IM', 4.49, 21, 0.1756, 4.1278, 4.8605, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.4.c', 'IM', 4.16, 21, 0.3382, 3.4522, 4.8631, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.5.a', 'IM', 4.73, 21, 0.2028, 4.3099, 5.0000, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.5.b', 'IM', 4.41, 21, 0.2897, 3.8089, 5.0000, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.5.c', 'IM', 4.74, 21, 0.2025, 4.3162, 5.0000, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.6', 'IM', 4.01, 21, 0.3047, 3.3788, 4.6499, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.7.a', 'IM', 4.03, 21, 0.2996, 3.4082, 4.6583, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.7.b', 'IM', 3.88, 21, 0.4629, 2.9145, 4.8457, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.1.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.1.b', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.1.c', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.2.b', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.3.a', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.3.b', 'IM', 2.78, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.3.c', 'IM', 2.43, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.4.a', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.4.b', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.4.c', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.5.a', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.5.b', 'IM', 4.78, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.5.c', 'IM', 4.74, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.6', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.7.a', 'IM', 3.04, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.7.b', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.1.a', 'IM', 4.21, 23, 0.1362, 3.9315, 4.4966, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.1.b', 'IM', 4.39, 24, 0.1629, 4.0558, 4.7297, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.1.c', 'IM', 4.23, 24, 0.1550, 3.9113, 4.5526, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.2.b', 'IM', 4.31, 24, 0.1319, 4.0355, 4.5812, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.3.a', 'IM', 4.19, 23, 0.2376, 3.7013, 4.6869, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.3.b', 'IM', 3.96, 24, 0.2102, 3.5251, 4.3948, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.3.c', 'IM', 3.45, 24, 0.3082, 2.8164, 4.0916, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.4.a', 'IM', 4.38, 23, 0.2016, 3.9652, 4.8014, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.4.b', 'IM', 4.59, 24, 0.1514, 4.2754, 4.9018, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.4.c', 'IM', 3.91, 24, 0.2296, 3.4393, 4.3893, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.5.a', 'IM', 4.56, 24, 0.1809, 4.1872, 4.9355, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.5.b', 'IM', 4.62, 24, 0.1474, 4.3146, 4.9246, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.5.c', 'IM', 4.80, 24, 0.1048, 4.5811, 5.0000, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.6', 'IM', 4.07, 24, 0.2127, 3.6268, 4.5068, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.7.a', 'IM', 3.67, 24, 0.1956, 3.2671, 4.0764, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.7.b', 'IM', 4.06, 24, 0.1739, 3.6958, 4.4153, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.1.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.1.b', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.1.c', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.2.b', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.3.a', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.3.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.3.c', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.4.a', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.4.b', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.4.c', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.5.a', 'IM', 4.68, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.5.b', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.5.c', 'IM', 4.95, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.6', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.7.a', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.7.b', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.1.a', 'IM', 3.85, 20, 0.0726, 3.7029, 4.0068, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.1.b', 'IM', 4.04, 20, 0.0516, 3.9314, 4.1476, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.1.c', 'IM', 4.12, 20, 0.0882, 3.9331, 4.3023, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.2.b', 'IM', 4.50, 20, 0.1674, 4.1526, 4.8534, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.3.a', 'IM', 4.17, 20, 0.1408, 3.8797, 4.4690, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.3.b', 'IM', 3.91, 20, 0.1436, 3.6119, 4.2129, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.3.c', 'IM', 3.34, 20, 0.1777, 2.9719, 3.7157, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.4.a', 'IM', 3.86, 20, 0.1809, 3.4786, 4.2356, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.4.b', 'IM', 4.00, 20, 0.0562, 3.8806, 4.1160, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.4.c', 'IM', 3.93, 20, 0.1450, 3.6219, 4.2290, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.5.a', 'IM', 4.39, 20, 0.1571, 4.0616, 4.7191, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.5.b', 'IM', 4.14, 20, 0.0892, 3.9488, 4.3221, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.5.c', 'IM', 4.20, 20, 0.2083, 3.7629, 4.6348, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.6', 'IM', 3.55, 20, 0.1673, 3.1983, 3.8986, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.7.a', 'IM', 3.49, 20, 0.3213, 2.8193, 4.1642, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.7.b', 'IM', 4.04, 20, 0.0517, 3.9345, 4.1509, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.1.a', 'IM', 3.97, 16, 0.2112, 3.5188, 4.4191, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.1.b', 'IM', 4.28, 16, 0.1367, 3.9931, 4.5759, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.1.c', 'IM', 4.13, 16, 0.2164, 3.6688, 4.5911, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.2.b', 'IM', 4.09, 16, 0.2628, 3.5308, 4.6510, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.3.a', 'IM', 4.07, 15, 0.1775, 3.6915, 4.4529, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.3.b', 'IM', 3.30, 16, 0.1849, 2.9024, 3.6908, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.3.c', 'IM', 3.39, 16, 0.2469, 2.8672, 3.9195, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.4.a', 'IM', 3.77, 16, 0.2348, 3.2691, 4.2700, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.4.b', 'IM', 4.08, 16, 0.2288, 3.5938, 4.5690, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.4.c', 'IM', 4.08, 16, 0.2378, 3.5775, 4.5912, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.5.a', 'IM', 4.07, 16, 0.2305, 3.5743, 4.5570, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.5.b', 'IM', 4.25, 16, 0.1624, 3.9002, 4.5925, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.5.c', 'IM', 4.15, 16, 0.2649, 3.5812, 4.7104, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.6', 'IM', 3.60, 16, 0.2046, 3.1654, 4.0376, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.7.a', 'IM', 3.47, 16, 0.1874, 3.0705, 3.8696, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.7.b', 'IM', 3.79, 16, 0.2337, 3.2933, 4.2894, 'N', '2016-07-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.1.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.1.b', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.1.c', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.2.b', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.3.a', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.3.b', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.3.c', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.4.a', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.4.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.4.c', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.5.a', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.5.b', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.5.c', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.6', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.7.a', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.7.b', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.1.a', 'IM', 4.00, 21, 0.2055, 3.5738, 4.4313, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.1.b', 'IM', 4.58, 22, 0.1578, 4.2566, 4.9131, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.1.c', 'IM', 4.41, 22, 0.1518, 4.0941, 4.7255, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.2.b', 'IM', 3.64, 22, 0.2869, 3.0397, 4.2331, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.3.a', 'IM', 4.22, 22, 0.1791, 3.8491, 4.5939, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.3.b', 'IM', 3.71, 22, 0.2141, 3.2673, 4.1578, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.3.c', 'IM', 3.78, 22, 0.2196, 3.3260, 4.2394, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.4.a', 'IM', 3.76, 22, 0.2769, 3.1869, 4.3385, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.4.b', 'IM', 3.67, 22, 0.2113, 3.2269, 4.1056, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.4.c', 'IM', 3.90, 22, 0.1615, 3.5599, 4.2314, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.5.a', 'IM', 4.34, 22, 0.2346, 3.8506, 4.8264, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.5.b', 'IM', 4.32, 22, 0.1351, 4.0440, 4.6058, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.5.c', 'IM', 4.37, 22, 0.2612, 3.8233, 4.9097, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.6', 'IM', 3.74, 22, 0.1879, 3.3534, 4.1348, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.7.a', 'IM', 3.65, 22, 0.2095, 3.2132, 4.0846, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.7.b', 'IM', 3.41, 22, 0.1933, 3.0035, 3.8073, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.1.a', 'IM', 4.05, 20, 0.1517, 3.7352, 4.3702, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.1.b', 'IM', 3.78, 20, 0.1893, 3.3804, 4.1729, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.1.c', 'IM', 4.26, 19, 0.1286, 3.9919, 4.5322, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.2.b', 'IM', 3.93, 19, 0.1741, 3.5603, 4.2917, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.3.a', 'IM', 4.02, 20, 0.1718, 3.6639, 4.3830, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.3.b', 'IM', 3.56, 20, 0.1516, 3.2409, 3.8755, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.3.c', 'IM', 3.59, 20, 0.3602, 2.8331, 4.3407, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.4.a', 'IM', 3.85, 20, 0.2007, 3.4312, 4.2714, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.4.b', 'IM', 4.69, 20, 0.1060, 4.4640, 4.9077, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.4.c', 'IM', 3.86, 20, 0.2733, 3.2914, 4.4355, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.5.a', 'IM', 4.61, 20, 0.1171, 4.3691, 4.8592, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.5.b', 'IM', 4.60, 20, 0.1480, 4.2938, 4.9135, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.5.c', 'IM', 4.59, 20, 0.1783, 4.2153, 4.9616, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.6', 'IM', 3.70, 20, 0.3064, 3.0544, 4.3368, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.7.a', 'IM', 3.08, 20, 0.2158, 2.6244, 3.5277, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.7.b', 'IM', 4.27, 20, 0.1993, 3.8510, 4.6854, 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.1.a', 'IM', 3.81, 29, 0.1899, 3.4260, 4.2038, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.1.b', 'IM', 3.93, 29, 0.0959, 3.7371, 4.1302, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.1.c', 'IM', 4.03, 29, 0.1402, 3.7394, 4.3138, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.2.b', 'IM', 3.68, 29, 0.1937, 3.2840, 4.0776, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.3.a', 'IM', 4.47, 29, 0.1738, 4.1115, 4.8236, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.3.b', 'IM', 3.73, 29, 0.2250, 3.2643, 4.1860, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.3.c', 'IM', 3.72, 28, 0.3063, 3.0946, 4.3515, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.4.a', 'IM', 3.79, 29, 0.1866, 3.4117, 4.1760, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.4.b', 'IM', 4.09, 29, 0.1161, 3.8546, 4.3303, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.4.c', 'IM', 4.37, 29, 0.1826, 3.9946, 4.7428, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.5.a', 'IM', 4.35, 29, 0.1883, 3.9644, 4.7357, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.5.b', 'IM', 4.17, 29, 0.0871, 3.9941, 4.3511, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.5.c', 'IM', 4.17, 29, 0.2880, 3.5778, 4.7577, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.6', 'IM', 3.85, 29, 0.2284, 3.3804, 4.3160, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.7.a', 'IM', 3.58, 29, 0.2761, 3.0133, 4.1445, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.7.b', 'IM', 3.83, 29, 0.1709, 3.4766, 4.1766, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.1.a', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.1.b', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.1.c', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.2.b', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.3.a', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.3.b', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.3.c', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.4.a', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.4.b', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.4.c', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.5.a', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.5.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.5.c', 'IM', 4.91, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.6', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.7.a', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.7.b', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.1.a', 'IM', 4.43, 40, 0.1118, 4.2023, 4.6546, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.1.b', 'IM', 4.40, 40, 0.1741, 4.0432, 4.7476, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.1.c', 'IM', 4.53, 40, 0.1419, 4.2447, 4.8186, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.2.b', 'IM', 3.93, 40, 0.1675, 3.5870, 4.2646, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.3.a', 'IM', 4.41, 40, 0.1679, 4.0671, 4.7466, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.3.b', 'IM', 4.25, 40, 0.2272, 3.7896, 4.7085, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.3.c', 'IM', 3.78, 40, 0.2528, 3.2717, 4.2943, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.4.a', 'IM', 4.38, 40, 0.1875, 3.9990, 4.7575, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.4.b', 'IM', 4.65, 40, 0.1047, 4.4428, 4.8662, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.4.c', 'IM', 4.40, 40, 0.1422, 4.1146, 4.6900, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.5.a', 'IM', 4.61, 40, 0.1224, 4.3656, 4.8607, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.5.b', 'IM', 4.57, 40, 0.1225, 4.3225, 4.8181, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.5.c', 'IM', 4.63, 40, 0.1060, 4.4188, 4.8477, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.6', 'IM', 4.44, 40, 0.1321, 4.1772, 4.7118, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.7.a', 'IM', 3.75, 40, 0.1909, 3.3615, 4.1339, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.7.b', 'IM', 4.21, 40, 0.1386, 3.9277, 4.4886, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.1.a', 'IM', 3.70, 16, 0.1189, 3.4508, 3.9576, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.1.b', 'IM', 3.66, 16, 0.1905, 3.2574, 4.0695, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.1.c', 'IM', 4.03, 16, 0.2149, 3.5713, 4.4876, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.2.b', 'IM', 3.13, 16, 0.2181, 2.6661, 3.5957, 'N', '2016-07-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.3.a', 'IM', 3.62, 16, 0.5095, 2.5344, 4.7064, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.3.b', 'IM', 3.95, 16, 0.1807, 3.5698, 4.3400, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.3.c', 'IM', 3.13, 16, 0.2338, 2.6288, 3.6256, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.4.a', 'IM', 3.98, 16, 0.2715, 3.4002, 4.5575, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.4.b', 'IM', 3.85, 16, 0.2205, 3.3770, 4.3169, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.4.c', 'IM', 3.59, 16, 0.2111, 3.1361, 4.0361, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.5.a', 'IM', 3.89, 16, 0.1537, 3.5646, 4.2196, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.5.b', 'IM', 4.19, 16, 0.1451, 3.8796, 4.4981, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.5.c', 'IM', 4.56, 16, 0.2451, 4.0397, 5.0000, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.6', 'IM', 3.88, 16, 0.1252, 3.6180, 4.1515, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.7.a', 'IM', 2.99, 16, 0.3723, 2.2010, 3.7880, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.7.b', 'IM', 3.12, 16, 0.3900, 2.2840, 3.9464, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.1.a', 'IM', 3.94, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.1.b', 'IM', 3.79, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.1.c', 'IM', 4.16, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.2.b', 'IM', 3.67, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.3.a', 'IM', 4.17, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.3.b', 'IM', 4.04, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.3.c', 'IM', 3.64, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.4.a', 'IM', 4.09, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.4.b', 'IM', 3.91, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.4.c', 'IM', 3.91, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.5.a', 'IM', 4.35, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.5.b', 'IM', 4.29, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.5.c', 'IM', 4.46, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.6', 'IM', 4.37, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.7.a', 'IM', 3.34, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.7.b', 'IM', 4.23, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.1.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.1.b', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.1.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.2.b', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.3.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.3.b', 'IM', 3.20, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.3.c', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.4.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.4.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.4.c', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.5.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.5.b', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.5.c', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.6', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.7.a', 'IM', 2.60, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.7.b', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.1.a', 'IM', 3.85, 33, 0.1313, 3.5867, 4.1214, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.1.b', 'IM', 4.04, 33, 0.1305, 3.7740, 4.3058, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.1.c', 'IM', 4.15, 33, 0.1517, 3.8436, 4.4615, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.2.b', 'IM', 3.74, 33, 0.2281, 3.2752, 4.2045, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.3.a', 'IM', 4.19, 33, 0.1168, 3.9481, 4.4240, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.3.b', 'IM', 4.11, 33, 0.2031, 3.6944, 4.5219, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.3.c', 'IM', 3.25, 33, 0.1474, 2.9518, 3.5524, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.4.a', 'IM', 4.40, 33, 0.1140, 4.1635, 4.6281, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.4.b', 'IM', 4.38, 32, 0.1586, 4.0521, 4.6992, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.4.c', 'IM', 3.89, 33, 0.2480, 3.3885, 4.3988, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.5.a', 'IM', 4.47, 33, 0.0943, 4.2729, 4.6572, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.5.b', 'IM', 4.56, 33, 0.0992, 4.3606, 4.7649, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.5.c', 'IM', 4.72, 33, 0.1009, 4.5134, 4.9244, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.6', 'IM', 4.03, 33, 0.2056, 3.6100, 4.4475, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.7.a', 'IM', 3.13, 33, 0.2727, 2.5789, 3.6900, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.7.b', 'IM', 4.48, 33, 0.1229, 4.2335, 4.7343, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.1.a', 'IM', 3.65, 16, 0.0963, 3.4434, 3.8539, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.1.b', 'IM', 3.91, 17, 0.0862, 3.7260, 4.0914, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.1.c', 'IM', 3.76, 17, 0.2001, 3.3405, 4.1887, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.2.b', 'IM', 3.64, 17, 0.3806, 2.8298, 4.4433, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.3.a', 'IM', 4.51, 17, 0.3030, 3.8684, 5.0000, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.3.b', 'IM', 4.04, 17, 0.1879, 3.6393, 4.4361, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.3.c', 'IM', 3.18, 17, 0.1277, 2.9136, 3.4549, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.4.a', 'IM', 4.37, 17, 0.2132, 3.9204, 4.8241, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.4.b', 'IM', 4.25, 17, 0.2858, 3.6488, 4.8606, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.4.c', 'IM', 4.37, 17, 0.2126, 3.9156, 4.8171, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.5.a', 'IM', 4.52, 17, 0.1449, 4.2087, 4.8229, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.5.b', 'IM', 4.33, 17, 0.1335, 4.0496, 4.6156, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.5.c', 'IM', 4.65, 17, 0.2288, 4.1685, 5.0000, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.6', 'IM', 4.18, 17, 0.3704, 3.3945, 4.9648, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.7.a', 'IM', 3.43, 17, 0.3965, 2.5865, 4.2678, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.7.b', 'IM', 3.81, 17, 0.2647, 3.2456, 4.3680, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.1.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.1.b', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.1.c', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.2.b', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.3.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.3.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.3.c', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.4.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.4.b', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.4.c', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.5.a', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.5.b', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.5.c', 'IM', 4.85, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.6', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.7.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.7.b', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.1.a', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.1.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.1.c', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.2.b', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.3.a', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.3.b', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.3.c', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.4.a', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.4.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.4.c', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.5.a', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.5.b', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.5.c', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.6', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.7.a', 'IM', 3.25, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.7.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.1.a', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.1.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.1.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.2.b', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.3.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.3.b', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.3.c', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.4.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.4.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.4.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.5.a', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.5.b', 'IM', 4.80, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.5.c', 'IM', 4.61, 18, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.6', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.7.a', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.7.b', 'IM', 3.68, 19, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.1.a', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.1.b', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.1.c', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.2.b', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.3.a', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.3.b', 'IM', 2.68, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.3.c', 'IM', 2.86, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.4.a', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.4.b', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.4.c', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.5.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.5.b', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.5.c', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.6', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.7.a', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.7.b', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.1.a', 'IM', 3.72, 40, 0.1685, 3.3789, 4.0605, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.1.b', 'IM', 3.85, 41, 0.1316, 3.5890, 4.1208, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.1.c', 'IM', 3.94, 41, 0.1004, 3.7417, 4.1474, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.2.b', 'IM', 4.04, 41, 0.3066, 3.4243, 4.6635, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.3.a', 'IM', 4.59, 41, 0.1652, 4.2544, 4.9220, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.3.b', 'IM', 4.37, 41, 0.2085, 3.9529, 4.7955, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.3.c', 'IM', 4.13, 41, 0.2704, 3.5838, 4.6768, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.4.a', 'IM', 4.51, 41, 0.1702, 4.1699, 4.8578, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.4.b', 'IM', 4.45, 41, 0.1933, 4.0598, 4.8412, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.4.c', 'IM', 4.43, 41, 0.1834, 4.0551, 4.7965, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.5.a', 'IM', 4.49, 41, 0.1748, 4.1412, 4.8477, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.5.b', 'IM', 4.57, 41, 0.1719, 4.2253, 4.9199, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.5.c', 'IM', 4.63, 41, 0.1523, 4.3200, 4.9355, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.6', 'IM', 4.22, 41, 0.2208, 3.7759, 4.6685, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.7.a', 'IM', 3.75, 41, 0.3579, 3.0220, 4.4687, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.7.b', 'IM', 4.03, 41, 0.3058, 3.4085, 4.6446, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.1.a', 'IM', 4.03, 13, 0.2614, 3.4636, 4.6029, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.1.b', 'IM', 3.88, 13, 0.3160, 3.1950, 4.5718, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.1.c', 'IM', 3.89, 13, 0.3163, 3.1970, 4.5754, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.2.b', 'IM', 3.80, 13, 0.2130, 3.3332, 4.2612, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.3.a', 'IM', 3.98, 13, 0.3044, 3.3159, 4.6423, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.3.b', 'IM', 3.88, 13, 0.3164, 3.1917, 4.5703, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.3.c', 'IM', 3.40, 13, 0.6833, 1.9099, 4.8873, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.4.a', 'IM', 3.65, 13, 0.4918, 2.5738, 4.7167, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.4.b', 'IM', 3.40, 13, 0.4789, 2.3541, 4.4411, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.4.c', 'IM', 3.40, 13, 0.4794, 2.3555, 4.4445, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.5.a', 'IM', 4.16, 13, 0.3615, 3.3771, 4.9523, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.5.b', 'IM', 3.75, 13, 0.3496, 2.9834, 4.5068, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.5.c', 'IM', 4.16, 13, 0.3611, 3.3740, 4.9475, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.6', 'IM', 3.40, 13, 0.4790, 2.3537, 4.4410, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.7.a', 'IM', 2.97, 13, 0.4359, 2.0233, 3.9229, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.7.b', 'IM', 3.31, 13, 0.4931, 2.2358, 4.3845, 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.1.a', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.1.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.1.c', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.2.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.3.a', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.3.b', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.3.c', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.4.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.4.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.4.c', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.5.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.5.b', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.5.c', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.6', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.7.a', 'IM', 3.14, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.7.b', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.1.a', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.1.b', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.1.c', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.2.b', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.3.a', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.3.b', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.3.c', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.4.a', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.4.b', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.4.c', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.5.a', 'IM', 4.67, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.5.b', 'IM', 4.46, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.5.c', 'IM', 4.71, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.6', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.7.a', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.7.b', 'IM', 4.25, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.1.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.1.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.1.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.2.b', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.3.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.3.b', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.3.c', 'IM', 2.70, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.4.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.4.b', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.4.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.5.a', 'IM', 4.26, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.5.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.5.c', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.6', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.7.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.7.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.1.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.1.b', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.1.c', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.2.b', 'IM', 3.55, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.3.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.3.b', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.3.c', 'IM', 2.95, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.4.a', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.4.b', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.4.c', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.5.a', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.5.b', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.5.c', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.6', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.7.a', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.7.b', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.1.a', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.1.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.1.c', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.2.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.3.a', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.3.b', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.3.c', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.4.a', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.4.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.4.c', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.5.a', 'IM', 4.81, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.5.b', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.5.c', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.6', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.7.a', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.7.b', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.1.a', 'IM', 4.02, 24, 0.3323, 3.3367, 4.7113, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.1.b', 'IM', 4.19, 24, 0.1090, 3.9688, 4.4199, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.1.c', 'IM', 4.33, 24, 0.2601, 3.7951, 4.8710, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.2.b', 'IM', 4.01, 24, 0.1631, 3.6762, 4.3510, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.3.a', 'IM', 4.73, 24, 0.1250, 4.4762, 4.9935, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.3.b', 'IM', 4.24, 24, 0.2741, 3.6774, 4.8113, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.3.c', 'IM', 4.37, 24, 0.2078, 3.9397, 4.7994, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.4.a', 'IM', 4.63, 24, 0.1434, 4.3357, 4.9288, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.4.b', 'IM', 4.79, 24, 0.1032, 4.5813, 5.0000, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.4.c', 'IM', 4.71, 24, 0.1276, 4.4438, 4.9719, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.5.a', 'IM', 4.87, 24, 0.0694, 4.7299, 5.0000, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.5.b', 'IM', 4.90, 24, 0.0610, 4.7699, 5.0000, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.5.c', 'IM', 4.45, 24, 0.1883, 4.0556, 4.8348, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.6', 'IM', 4.01, 24, 0.1086, 3.7834, 4.2325, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.7.a', 'IM', 4.07, 24, 0.3087, 3.4353, 4.7126, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.7.b', 'IM', 3.81, 24, 0.1262, 3.5519, 4.0740, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.1.a', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.1.b', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.1.c', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.2.b', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.3.a', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.3.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.3.c', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.4.a', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.4.b', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.4.c', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.5.a', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.5.b', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.5.c', 'IM', 4.81, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.6', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.7.a', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.7.b', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.1.a', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.1.b', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.1.c', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.2.b', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.3.a', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.3.b', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.3.c', 'IM', 3.24, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.4.a', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.4.b', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.4.c', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.5.a', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.5.b', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.5.c', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.6', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.7.a', 'IM', 3.00, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.7.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.1.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.1.b', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.1.c', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.2.b', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.3.a', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.3.b', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.3.c', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.4.a', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.4.b', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.4.c', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.5.a', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.5.b', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.5.c', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.6', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.7.a', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.7.b', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.1.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.1.b', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.1.c', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.2.b', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.3.a', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.3.b', 'IM', 3.22, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.3.c', 'IM', 2.83, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.4.a', 'IM', 3.39, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.4.b', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.4.c', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.5.a', 'IM', 4.65, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.5.b', 'IM', 4.78, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.5.c', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.6', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.7.a', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.7.b', 'IM', 4.96, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.1.a', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.1.b', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.1.c', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.2.b', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.3.a', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.3.b', 'IM', 2.57, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.3.c', 'IM', 2.35, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.4.a', 'IM', 3.09, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.4.b', 'IM', 3.30, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.4.c', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.5.a', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.5.b', 'IM', 4.65, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.5.c', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.6', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.7.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.7.b', 'IM', 4.74, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.1.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.1.b', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.1.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.2.b', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.3.a', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.3.b', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.3.c', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.4.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.4.b', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.4.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.5.a', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.5.b', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.5.c', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.6', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.7.a', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.7.b', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.1.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.1.b', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.1.c', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.2.b', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.3.a', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.3.b', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.3.c', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.4.a', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.4.b', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.4.c', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.5.a', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.5.b', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.5.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.6', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.7.a', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.7.b', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.1.a', 'IM', 3.77, 22, 0.1911, 3.3744, 4.1694, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.1.b', 'IM', 4.14, 22, 0.1896, 3.7478, 4.5364, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.1.c', 'IM', 4.31, 22, 0.1445, 4.0084, 4.6093, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.2.b', 'IM', 3.70, 22, 0.2234, 3.2349, 4.1640, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.3.a', 'IM', 3.90, 22, 0.2127, 3.4556, 4.3403, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.3.b', 'IM', 3.53, 22, 0.2674, 2.9771, 4.0891, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.3.c', 'IM', 3.20, 22, 0.2798, 2.6195, 3.7833, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.4.a', 'IM', 3.64, 22, 0.2188, 3.1865, 4.0966, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.4.b', 'IM', 3.60, 22, 0.2396, 3.1014, 4.0980, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.4.c', 'IM', 3.99, 22, 0.1645, 3.6503, 4.3345, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.5.a', 'IM', 4.38, 22, 0.1676, 4.0337, 4.7307, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.5.b', 'IM', 4.45, 22, 0.1560, 4.1235, 4.7723, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.5.c', 'IM', 4.12, 22, 0.1457, 3.8124, 4.4184, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.6', 'IM', 3.98, 22, 0.2259, 3.5103, 4.4500, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.7.a', 'IM', 3.82, 22, 0.2145, 3.3691, 4.2611, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.7.b', 'IM', 3.92, 22, 0.1919, 3.5235, 4.3214, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.1.a', 'IM', 3.88, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.1.b', 'IM', 4.06, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.1.c', 'IM', 4.08, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.2.b', 'IM', 3.50, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.3.a', 'IM', 4.17, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.3.b', 'IM', 3.26, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.3.c', 'IM', 3.38, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.4.a', 'IM', 3.90, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.4.b', 'IM', 4.10, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.4.c', 'IM', 3.82, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.5.a', 'IM', 4.67, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.5.b', 'IM', 4.88, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.5.c', 'IM', 4.89, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.6', 'IM', 3.67, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.7.a', 'IM', 3.07, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.7.b', 'IM', 4.44, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.1.a', 'IM', 3.62, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.1.b', 'IM', 3.67, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.1.c', 'IM', 3.79, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.2.b', 'IM', 3.04, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.3.a', 'IM', 3.72, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.3.b', 'IM', 3.19, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.3.c', 'IM', 2.79, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.4.a', 'IM', 3.66, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.4.b', 'IM', 3.83, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.4.c', 'IM', 3.46, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.5.a', 'IM', 4.05, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.5.b', 'IM', 4.43, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.5.c', 'IM', 4.55, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.6', 'IM', 4.05, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.7.a', 'IM', 2.80, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.7.b', 'IM', 3.97, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.1.a', 'IM', 4.22, 17, 0.1736, 3.8490, 4.5850, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.1.b', 'IM', 4.24, 17, 0.2425, 3.7261, 4.7545, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.1.c', 'IM', 4.21, 17, 0.2494, 3.6802, 4.7375, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.2.b', 'IM', 4.05, 17, 0.2187, 3.5902, 4.5174, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.3.a', 'IM', 4.23, 17, 0.1990, 3.8117, 4.6554, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.3.b', 'IM', 3.61, 17, 0.2878, 2.9954, 4.2156, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.3.c', 'IM', 2.40, 17, 0.3733, 1.6079, 3.1908, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.4.a', 'IM', 3.89, 17, 0.2929, 3.2733, 4.5152, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.4.b', 'IM', 4.21, 17, 0.2830, 3.6132, 4.8132, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.4.c', 'IM', 4.24, 17, 0.2349, 3.7398, 4.7356, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.5.a', 'IM', 4.12, 17, 0.3068, 3.4670, 4.7679, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.5.b', 'IM', 4.89, 17, 0.0886, 4.7002, 5.0000, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.5.c', 'IM', 4.78, 17, 0.1203, 4.5299, 5.0000, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.6', 'IM', 3.89, 17, 0.3288, 3.1970, 4.5911, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.7.a', 'IM', 3.00, 17, 0.3332, 2.2911, 3.7037, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.7.b', 'IM', 4.70, 17, 0.1494, 4.3830, 5.0000, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.1.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.1.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.1.c', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.2.b', 'IM', 3.25, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.3.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.3.b', 'IM', 2.55, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.3.c', 'IM', 2.50, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.4.a', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.4.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.4.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.5.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.5.b', 'IM', 4.80, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.5.c', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.6', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.7.a', 'IM', 2.65, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.7.b', 'IM', 4.89, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.1.a', 'IM', 4.08, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.1.b', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.1.c', 'IM', 4.38, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.2.b', 'IM', 3.46, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.3.a', 'IM', 3.96, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.3.b', 'IM', 4.50, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.3.c', 'IM', 3.50, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.4.a', 'IM', 4.12, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.4.b', 'IM', 3.77, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.4.c', 'IM', 3.72, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.5.a', 'IM', 4.54, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.5.b', 'IM', 4.69, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.5.c', 'IM', 4.92, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.6', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.7.a', 'IM', 3.04, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.7.b', 'IM', 4.58, 26, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.1.a', 'IM', 4.07, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.1.b', 'IM', 3.73, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.1.c', 'IM', 3.90, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.2.b', 'IM', 2.82, 28, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.3.a', 'IM', 4.03, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.3.b', 'IM', 2.93, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.3.c', 'IM', 2.80, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.4.a', 'IM', 4.00, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.4.b', 'IM', 4.03, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.4.c', 'IM', 3.80, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.5.a', 'IM', 4.33, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.5.b', 'IM', 4.67, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.5.c', 'IM', 4.80, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.6', 'IM', 3.67, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.7.a', 'IM', 2.70, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.7.b', 'IM', 4.57, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.1.a', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.1.b', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.1.c', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.2.b', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.3.a', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.3.b', 'IM', 3.04, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.3.c', 'IM', 3.39, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.4.a', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.4.b', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.4.c', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.5.a', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.5.b', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.5.c', 'IM', 4.68, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.6', 'IM', 3.22, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.7.a', 'IM', 2.64, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.7.b', 'IM', 4.70, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.1.a', 'IM', 4.24, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.1.b', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.1.c', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.2.b', 'IM', 3.68, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.3.a', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.3.b', 'IM', 4.68, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.3.c', 'IM', 3.64, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.4.a', 'IM', 4.60, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.4.b', 'IM', 4.40, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.4.c', 'IM', 4.40, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.5.a', 'IM', 4.76, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.5.b', 'IM', 4.64, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.5.c', 'IM', 4.96, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.6', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.7.a', 'IM', 3.48, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.7.b', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.1.a', 'IM', 3.75, 22, 0.2183, 3.2941, 4.2022, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.1.b', 'IM', 3.85, 22, 0.1350, 3.5655, 4.1272, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.1.c', 'IM', 3.98, 22, 0.1131, 3.7496, 4.2199, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.2.b', 'IM', 3.63, 22, 0.1537, 3.3069, 3.9461, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.3.a', 'IM', 4.15, 22, 0.2049, 3.7198, 4.5719, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.3.b', 'IM', 3.67, 22, 0.2137, 3.2261, 4.1149, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.3.c', 'IM', 3.53, 22, 0.1396, 3.2427, 3.8232, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.4.a', 'IM', 3.87, 22, 0.2041, 3.4477, 4.2966, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.4.b', 'IM', 3.98, 22, 0.2066, 3.5529, 4.4123, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.4.c', 'IM', 3.99, 21, 0.1894, 3.5941, 4.3843, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.5.a', 'IM', 4.36, 22, 0.1931, 3.9543, 4.7575, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.5.b', 'IM', 4.09, 22, 0.1778, 3.7203, 4.4600, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.5.c', 'IM', 4.66, 22, 0.1980, 4.2471, 5.0000, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.6', 'IM', 3.81, 22, 0.2609, 3.2647, 4.3498, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.7.a', 'IM', 3.01, 22, 0.1336, 2.7345, 3.2901, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.7.b', 'IM', 3.92, 22, 0.1695, 3.5711, 4.2758, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.1.a', 'IM', 3.64, 23, 0.2860, 3.0432, 4.2296, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.1.b', 'IM', 3.68, 23, 0.2466, 3.1657, 4.1887, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.1.c', 'IM', 4.03, 23, 0.2184, 3.5733, 4.4789, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.2.b', 'IM', 3.57, 23, 0.1182, 3.3265, 3.8169, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.3.a', 'IM', 4.28, 23, 0.2763, 3.7065, 4.8526, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.3.b', 'IM', 3.88, 23, 0.3688, 3.1164, 4.6461, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.3.c', 'IM', 3.38, 23, 0.3019, 2.7554, 4.0078, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.4.a', 'IM', 4.42, 23, 0.2151, 3.9732, 4.8654, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.4.b', 'IM', 4.32, 23, 0.2141, 3.8736, 4.7617, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.4.c', 'IM', 3.86, 23, 0.2140, 3.4188, 4.3062, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.5.a', 'IM', 4.54, 23, 0.1600, 4.2068, 4.8704, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.5.b', 'IM', 4.64, 23, 0.1841, 4.2627, 5.0000, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.5.c', 'IM', 4.66, 23, 0.1123, 4.4288, 4.8944, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.6', 'IM', 4.38, 23, 0.2446, 3.8757, 4.8900, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.7.a', 'IM', 3.38, 23, 0.2119, 2.9390, 3.8178, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.7.b', 'IM', 4.28, 23, 0.1431, 3.9794, 4.5729, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.1.a', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.1.b', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.1.c', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.2.b', 'IM', 2.86, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.3.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.3.b', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.3.c', 'IM', 3.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.4.a', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.4.b', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.4.c', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.5.a', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.5.b', 'IM', 4.91, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.5.c', 'IM', 4.82, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.6', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.7.a', 'IM', 2.73, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.7.b', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.1.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.1.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.1.c', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.2.b', 'IM', 2.85, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.3.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.3.b', 'IM', 2.25, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.3.c', 'IM', 2.00, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.4.a', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.4.b', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.4.c', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.5.a', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.5.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.5.c', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.6', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.7.a', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.7.b', 'IM', 4.80, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.1.a', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.1.b', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.1.c', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.2.b', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.3.a', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.3.b', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.3.c', 'IM', 3.13, 23, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.4.a', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.4.b', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.4.c', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.5.a', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.5.b', 'IM', 4.75, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.5.c', 'IM', 5.00, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.6', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.7.a', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.7.b', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.1.a', 'IM', 3.12, 20, 0.3636, 2.3570, 3.8789, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.1.b', 'IM', 3.54, 20, 0.2122, 3.0931, 3.9812, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.1.c', 'IM', 3.57, 20, 0.4956, 2.5320, 4.6065, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.2.b', 'IM', 3.00, 20, 0.3442, 2.2784, 3.7192, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.3.a', 'IM', 3.64, 20, 0.2009, 3.2154, 4.0563, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.3.b', 'IM', 3.10, 20, 0.4286, 2.1994, 3.9933, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.3.c', 'IM', 2.77, 20, 0.2678, 2.2125, 3.3334, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.4.a', 'IM', 3.08, 20, 0.3456, 2.3569, 3.8034, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.4.b', 'IM', 3.39, 20, 0.1715, 3.0328, 3.7508, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.4.c', 'IM', 3.27, 20, 0.3950, 2.4401, 4.0935, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.5.a', 'IM', 3.86, 20, 0.3099, 3.2127, 4.5098, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.5.b', 'IM', 4.15, 20, 0.1615, 3.8126, 4.4886, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.5.c', 'IM', 3.65, 20, 0.5269, 2.5479, 4.7536, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.6', 'IM', 3.23, 20, 0.4312, 2.3323, 4.1375, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.7.a', 'IM', 3.45, 20, 0.2778, 2.8724, 4.0354, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.7.b', 'IM', 4.46, 19, 0.1835, 4.0757, 4.8466, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.1.a', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.1.b', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.1.c', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.2.b', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.3.a', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.3.b', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.3.c', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.4.a', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.4.b', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.4.c', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.5.a', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.5.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.5.c', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.6', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.7.a', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.7.b', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.1.a', 'IM', 3.98, 26, 0.1356, 3.7055, 4.2642, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.1.b', 'IM', 4.04, 26, 0.1804, 3.6717, 4.4149, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.1.c', 'IM', 4.20, 26, 0.1646, 3.8573, 4.5354, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.2.b', 'IM', 3.90, 26, 0.2102, 3.4674, 4.3333, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.3.a', 'IM', 4.28, 26, 0.1683, 3.9338, 4.6270, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.3.b', 'IM', 3.66, 26, 0.2078, 3.2363, 4.0920, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.3.c', 'IM', 3.37, 26, 0.1991, 2.9625, 3.7828, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.4.a', 'IM', 4.04, 25, 0.2022, 3.6263, 4.4608, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.4.b', 'IM', 3.92, 26, 0.2192, 3.4691, 4.3721, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.4.c', 'IM', 4.22, 25, 0.1718, 3.8671, 4.5762, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.5.a', 'IM', 4.53, 26, 0.1157, 4.2939, 4.7705, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.5.b', 'IM', 4.55, 25, 0.1207, 4.3016, 4.7999, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.5.c', 'IM', 4.53, 26, 0.1226, 4.2765, 4.7816, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.6', 'IM', 3.88, 26, 0.1626, 3.5488, 4.2187, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.7.a', 'IM', 3.70, 26, 0.1567, 3.3789, 4.0242, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.7.b', 'IM', 4.44, 26, 0.1136, 4.2059, 4.6738, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.1.a', 'IM', 3.97, 16, 0.2348, 3.4682, 4.4691, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.1.b', 'IM', 3.71, 16, 0.2347, 3.2084, 4.2090, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.1.c', 'IM', 3.95, 16, 0.2378, 3.4387, 4.4522, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.2.b', 'IM', 3.60, 16, 0.4007, 2.7426, 4.4507, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.3.a', 'IM', 4.17, 16, 0.1595, 3.8314, 4.5113, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.3.b', 'IM', 3.23, 16, 0.2302, 2.7403, 3.7214, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.3.c', 'IM', 3.06, 16, 0.2238, 2.5878, 3.5419, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.4.a', 'IM', 3.01, 16, 0.1787, 2.6309, 3.3925, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.4.b', 'IM', 3.62, 16, 0.2566, 3.0724, 4.1660, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.4.c', 'IM', 3.88, 16, 0.2467, 3.3545, 4.4061, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.5.a', 'IM', 3.72, 16, 0.3102, 3.0613, 4.3837, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.5.b', 'IM', 4.05, 16, 0.1940, 3.6328, 4.4597, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.5.c', 'IM', 3.90, 16, 0.2330, 3.4069, 4.4000, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.6', 'IM', 4.01, 16, 0.1848, 3.6207, 4.4086, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.7.a', 'IM', 3.92, 16, 0.1806, 3.5359, 4.3058, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.7.b', 'IM', 4.61, 16, 0.1466, 4.2991, 4.9240, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.1.a', 'IM', 3.80, 37, 0.2258, 3.3459, 4.2617, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.1.b', 'IM', 4.15, 37, 0.1512, 3.8395, 4.4529, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.1.c', 'IM', 4.23, 37, 0.1881, 3.8521, 4.6150, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.2.b', 'IM', 3.85, 37, 0.2380, 3.3713, 4.3366, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.3.a', 'IM', 4.54, 38, 0.1416, 4.2492, 4.8230, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.3.b', 'IM', 3.64, 38, 0.2090, 3.2181, 4.0650, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.3.c', 'IM', 3.59, 38, 0.1407, 3.3028, 3.8731, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.4.a', 'IM', 4.23, 38, 0.1532, 3.9203, 4.5413, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.4.b', 'IM', 4.25, 38, 0.2139, 3.8208, 4.6874, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.4.c', 'IM', 4.31, 38, 0.1644, 3.9752, 4.6415, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.5.a', 'IM', 4.45, 38, 0.2187, 4.0040, 4.8901, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.5.b', 'IM', 4.48, 38, 0.1947, 4.0856, 4.8747, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.5.c', 'IM', 4.36, 38, 0.2851, 3.7782, 4.9335, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.6', 'IM', 3.98, 38, 0.2444, 3.4878, 4.4781, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.7.a', 'IM', 3.88, 37, 0.1733, 3.5241, 4.2271, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.7.b', 'IM', 4.51, 38, 0.1565, 4.1910, 4.8253, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.1.a', 'IM', 4.09, 21, 0.0697, 3.9406, 4.2312, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.1.b', 'IM', 4.21, 21, 0.2647, 3.6601, 4.7645, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.1.c', 'IM', 4.40, 21, 0.2138, 3.9541, 4.8461, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.2.b', 'IM', 3.83, 21, 0.2409, 3.3306, 4.3354, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.3.a', 'IM', 4.49, 21, 0.2170, 4.0421, 4.9474, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.3.b', 'IM', 4.22, 21, 0.1336, 3.9401, 4.4976, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.3.c', 'IM', 3.52, 21, 0.2484, 3.0023, 4.0388, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.4.a', 'IM', 4.19, 21, 0.0929, 3.9970, 4.3845, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.4.b', 'IM', 4.35, 21, 0.2287, 3.8690, 4.8229, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.4.c', 'IM', 4.35, 20, 0.2344, 3.8577, 4.8391, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.5.a', 'IM', 4.57, 21, 0.2173, 4.1199, 5.0000, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.5.b', 'IM', 4.61, 21, 0.2083, 4.1726, 5.0000, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.5.c', 'IM', 4.59, 21, 0.2096, 4.1508, 5.0000, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.6', 'IM', 4.24, 21, 0.2693, 3.6763, 4.8000, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.7.a', 'IM', 4.07, 21, 0.2872, 3.4709, 4.6689, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.7.b', 'IM', 4.12, 21, 0.4052, 3.2749, 4.9653, 'N', '2023-08-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.1.a', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.1.b', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.1.c', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.2.b', 'IM', 3.20, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.3.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.3.b', 'IM', 2.90, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.3.c', 'IM', 2.70, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.4.a', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.4.b', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.4.c', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.5.a', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.5.b', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.5.c', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.6', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.7.a', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.7.b', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.1.a', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.1.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.1.c', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.2.b', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.3.a', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.3.b', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.3.c', 'IM', 3.00, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.4.a', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.4.b', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.4.c', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.5.a', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.5.b', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.5.c', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.6', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.7.a', 'IM', 3.48, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.7.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.1.a', 'IM', 3.70, 26, 0.2199, 3.2517, 4.1576, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.1.b', 'IM', 4.02, 26, 0.0710, 3.8776, 4.1700, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.1.c', 'IM', 3.88, 26, 0.1000, 3.6749, 4.0869, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.2.b', 'IM', 3.14, 26, 0.4088, 2.2952, 3.9792, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.3.a', 'IM', 4.00, 25, 0.1120, 3.7684, 4.2305, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.3.b', 'IM', 3.25, 26, 0.1649, 2.9073, 3.5867, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.3.c', 'IM', 3.23, 26, 0.2398, 2.7387, 3.7265, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.4.a', 'IM', 3.66, 26, 0.1960, 3.2593, 4.0665, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.4.b', 'IM', 3.70, 26, 0.2425, 3.2035, 4.2024, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.4.c', 'IM', 3.84, 26, 0.0785, 3.6758, 3.9990, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.5.a', 'IM', 3.99, 26, 0.0704, 3.8494, 4.1394, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.5.b', 'IM', 4.14, 26, 0.0617, 4.0122, 4.2663, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.5.c', 'IM', 4.14, 26, 0.1387, 3.8531, 4.4245, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.6', 'IM', 3.51, 26, 0.2200, 3.0559, 3.9623, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.7.a', 'IM', 3.36, 26, 0.2352, 2.8725, 3.8415, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.7.b', 'IM', 3.86, 26, 0.2326, 3.3797, 4.3377, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.1.a', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.1.b', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.1.c', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.2.b', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.3.a', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.3.b', 'IM', 3.14, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.3.c', 'IM', 2.71, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.4.a', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.4.b', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.4.c', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.5.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.5.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.5.c', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.6', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.7.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.7.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.1.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.1.b', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.1.c', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.2.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.3.a', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.3.b', 'IM', 2.74, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.3.c', 'IM', 2.39, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.4.a', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.4.b', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.4.c', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.5.a', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.5.b', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.5.c', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.6', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.7.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.7.b', 'IM', 4.91, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.1.a', 'IM', 3.94, 40, 0.1742, 3.5835, 4.2881, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.1.b', 'IM', 4.12, 40, 0.1299, 3.8543, 4.3800, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.1.c', 'IM', 4.20, 40, 0.1419, 3.9100, 4.4840, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.2.b', 'IM', 3.45, 40, 0.2159, 3.0156, 3.8889, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.3.a', 'IM', 4.30, 40, 0.1303, 4.0329, 4.5599, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.3.b', 'IM', 3.66, 40, 0.1698, 3.3176, 4.0045, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.3.c', 'IM', 3.20, 40, 0.2144, 2.7681, 3.6356, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.4.a', 'IM', 3.70, 40, 0.2322, 3.2282, 4.1675, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.4.b', 'IM', 4.18, 40, 0.1560, 3.8677, 4.4987, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.4.c', 'IM', 4.12, 40, 0.1704, 3.7752, 4.4644, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.5.a', 'IM', 4.45, 40, 0.1167, 4.2090, 4.6813, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.5.b', 'IM', 4.54, 40, 0.1389, 4.2605, 4.8223, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.5.c', 'IM', 4.44, 40, 0.1226, 4.1945, 4.6906, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.6', 'IM', 4.21, 40, 0.2281, 3.7523, 4.6749, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.7.a', 'IM', 3.95, 40, 0.2120, 3.5177, 4.3751, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.7.b', 'IM', 4.50, 40, 0.1362, 4.2221, 4.7732, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.1.a', 'IM', 4.43, 22, 0.2145, 3.9821, 4.8743, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.1.b', 'IM', 4.40, 22, 0.2127, 3.9539, 4.8387, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.1.c', 'IM', 4.44, 22, 0.2048, 4.0186, 4.8705, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.2.b', 'IM', 3.48, 22, 0.5891, 2.2523, 4.7023, 'N', '2018-08-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.3.a', 'IM', 4.56, 22, 0.2301, 4.0836, 5.0000, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.3.b', 'IM', 3.71, 22, 0.4693, 2.7378, 4.6898, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.3.c', 'IM', 3.21, 22, 0.3126, 2.5634, 3.8635, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.4.a', 'IM', 4.12, 22, 0.3521, 3.3836, 4.8480, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.4.b', 'IM', 3.90, 22, 0.4306, 3.0092, 4.8002, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.4.c', 'IM', 4.05, 22, 0.1237, 3.7888, 4.3033, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.5.a', 'IM', 4.29, 22, 0.1506, 3.9813, 4.6075, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.5.b', 'IM', 4.97, 21, 0.0288, 4.9051, 5.0000, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.5.c', 'IM', 4.64, 22, 0.2018, 4.2224, 5.0000, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.6', 'IM', 4.54, 22, 0.1936, 4.1368, 4.9419, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.7.a', 'IM', 4.00, 22, 0.3685, 3.2338, 4.7665, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.7.b', 'IM', 4.74, 22, 0.1383, 4.4534, 5.0000, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.1.a', 'IM', 3.85, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.1.b', 'IM', 4.24, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.1.c', 'IM', 4.03, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.2.b', 'IM', 3.38, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.3.a', 'IM', 4.50, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.3.b', 'IM', 3.35, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.3.c', 'IM', 2.88, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.4.a', 'IM', 3.94, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.4.b', 'IM', 3.91, 33, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.4.c', 'IM', 4.35, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.5.a', 'IM', 4.35, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.5.b', 'IM', 4.91, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.5.c', 'IM', 4.42, 33, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.6', 'IM', 3.62, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.7.a', 'IM', 3.59, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.7.b', 'IM', 4.56, 34, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.1.a', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.1.b', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.1.c', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.2.b', 'IM', 2.83, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.3.a', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.3.b', 'IM', 2.75, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.3.c', 'IM', 2.50, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.4.a', 'IM', 3.29, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.4.b', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.4.c', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.5.a', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.5.b', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.5.c', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.6', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.7.a', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.7.b', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.1.a', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.1.b', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.1.c', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.2.b', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.3.a', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.3.b', 'IM', 3.15, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.3.c', 'IM', 3.25, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.4.a', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.4.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.4.c', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.5.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.5.b', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.5.c', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.6', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.7.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.7.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.1.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.1.b', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.1.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.2.b', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.3.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.3.b', 'IM', 2.90, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.3.c', 'IM', 2.35, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.4.a', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.4.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.4.c', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.5.a', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.5.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.5.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.6', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.7.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.7.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.1.a', 'IM', 3.85, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.1.b', 'IM', 4.09, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.1.c', 'IM', 4.17, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.2.b', 'IM', 3.38, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.3.a', 'IM', 4.00, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.3.b', 'IM', 3.21, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.3.c', 'IM', 2.75, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.4.a', 'IM', 3.38, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.4.b', 'IM', 3.48, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.4.c', 'IM', 4.10, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.5.a', 'IM', 4.23, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.5.b', 'IM', 4.66, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.5.c', 'IM', 4.33, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.6', 'IM', 4.35, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.7.a', 'IM', 4.17, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.7.b', 'IM', 4.55, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.1.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.1.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.1.c', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.2.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.3.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.3.b', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.3.c', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.4.a', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.4.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.4.c', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.5.a', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.5.b', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.5.c', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.6', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.7.a', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.7.b', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.1.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.1.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.1.c', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.2.b', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.3.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.3.b', 'IM', 3.09, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.3.c', 'IM', 2.68, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.4.a', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.4.b', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.4.c', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.5.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.5.b', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.5.c', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.6', 'IM', 3.55, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.7.a', 'IM', 3.41, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.7.b', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.1.a', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.1.b', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.1.c', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.2.b', 'IM', 4.76, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.3.a', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.3.b', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.3.c', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.4.a', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.4.b', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.4.c', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.5.a', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.5.b', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.5.c', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.6', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.7.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.7.b', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.1.a', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.1.b', 'IM', 3.96, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.1.c', 'IM', 4.14, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.2.b', 'IM', 3.43, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.3.a', 'IM', 3.68, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.3.b', 'IM', 2.61, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.3.c', 'IM', 2.32, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.4.a', 'IM', 3.21, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.4.b', 'IM', 3.29, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.4.c', 'IM', 3.93, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.5.a', 'IM', 4.36, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.5.b', 'IM', 4.71, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.5.c', 'IM', 4.64, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.6', 'IM', 3.57, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.7.a', 'IM', 3.25, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.7.b', 'IM', 4.89, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.1.a', 'IM', 4.42, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.1.b', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.1.c', 'IM', 4.25, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.2.b', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.3.a', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.3.b', 'IM', 2.79, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.3.c', 'IM', 2.08, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.4.a', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.4.b', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.4.c', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.5.a', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.5.b', 'IM', 4.71, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.5.c', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.6', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.7.a', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.7.b', 'IM', 4.96, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.1.a', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.1.b', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.1.c', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.2.b', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.3.a', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.3.b', 'IM', 3.00, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.3.c', 'IM', 2.57, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.4.a', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.4.b', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.4.c', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.5.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.5.b', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.5.c', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.6', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.7.a', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.7.b', 'IM', 4.90, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.1.a', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.1.b', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.1.c', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.2.b', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.3.a', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.3.b', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.3.c', 'IM', 2.86, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.4.a', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.4.b', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.4.c', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.5.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.5.b', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.5.c', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.6', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.7.a', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.7.b', 'IM', 4.90, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.1.a', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.1.b', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.1.c', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.2.b', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.3.a', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.3.b', 'IM', 3.08, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.3.c', 'IM', 2.83, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.4.a', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.4.b', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.4.c', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.5.a', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.5.b', 'IM', 4.42, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.5.c', 'IM', 4.67, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.6', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.7.a', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.7.b', 'IM', 4.74, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.1.a', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.1.b', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.1.c', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.2.b', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.3.a', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.3.b', 'IM', 2.59, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.3.c', 'IM', 2.36, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.4.a', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.4.b', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.4.c', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.5.a', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.5.b', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.5.c', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.6', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.7.a', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.7.b', 'IM', 4.95, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.1.a', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.1.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.1.c', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.2.b', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.3.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.3.b', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.3.c', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.4.a', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.4.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.4.c', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.5.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.5.b', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.5.c', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.6', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.7.a', 'IM', 3.15, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.7.b', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.1.a', 'IM', 4.03, 21, 0.2527, 3.5026, 4.5570, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.1.b', 'IM', 3.74, 21, 0.3661, 2.9811, 4.5086, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.1.c', 'IM', 3.83, 21, 0.2790, 3.2447, 4.4087, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.2.b', 'IM', 3.35, 21, 0.2745, 2.7799, 3.9249, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.3.a', 'IM', 4.23, 21, 0.2464, 3.7195, 4.7475, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.3.b', 'IM', 3.18, 21, 0.3163, 2.5175, 3.8372, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.3.c', 'IM', 2.65, 21, 0.4307, 1.7539, 3.5507, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.4.a', 'IM', 3.15, 21, 0.2735, 2.5796, 3.7207, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.4.b', 'IM', 3.50, 21, 0.3548, 2.7576, 4.2376, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.4.c', 'IM', 3.54, 21, 0.3530, 2.8031, 4.2757, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.5.a', 'IM', 3.85, 21, 0.3476, 3.1297, 4.5797, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.5.b', 'IM', 4.25, 21, 0.2648, 3.6989, 4.8038, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.5.c', 'IM', 3.85, 21, 0.2849, 3.2521, 4.4406, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.6', 'IM', 3.79, 21, 0.2000, 3.3720, 4.2063, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.7.a', 'IM', 3.72, 21, 0.3002, 3.0914, 4.3437, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.7.b', 'IM', 4.16, 21, 0.2525, 3.6331, 4.6865, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.1.a', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.1.b', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.1.c', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.2.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.3.a', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.3.b', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.3.c', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.4.a', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.4.b', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.4.c', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.5.a', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.5.b', 'IM', 4.80, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.5.c', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.6', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.7.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.7.b', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.1.a', 'IM', 3.93, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.1.b', 'IM', 3.89, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.1.c', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.2.b', 'IM', 3.89, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.3.a', 'IM', 4.21, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.3.b', 'IM', 3.39, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.3.c', 'IM', 3.25, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.4.a', 'IM', 3.71, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.4.b', 'IM', 3.96, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.4.c', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.5.a', 'IM', 4.43, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.5.b', 'IM', 4.54, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.5.c', 'IM', 4.32, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.6', 'IM', 3.57, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.7.a', 'IM', 4.21, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.7.b', 'IM', 4.00, 28, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.1.a', 'IM', 3.63, 21, 0.2683, 3.0716, 4.1911, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.1.b', 'IM', 3.76, 21, 0.2904, 3.1532, 4.3648, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.1.c', 'IM', 3.78, 21, 0.1582, 3.4452, 4.1051, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.2.b', 'IM', 3.39, 21, 0.2865, 2.7923, 3.9875, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.3.a', 'IM', 3.94, 21, 0.1117, 3.7059, 4.1719, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.3.b', 'IM', 2.91, 21, 0.2231, 2.4415, 3.3721, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.3.c', 'IM', 2.68, 21, 0.2961, 2.0590, 3.2941, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.4.a', 'IM', 3.28, 21, 0.2659, 2.7203, 3.8298, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.4.b', 'IM', 3.06, 21, 0.2748, 2.4844, 3.6310, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.4.c', 'IM', 3.82, 21, 0.1205, 3.5652, 4.0681, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.5.a', 'IM', 4.15, 21, 0.2053, 3.7182, 4.5749, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.5.b', 'IM', 4.63, 21, 0.1481, 4.3243, 4.9422, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.5.c', 'IM', 3.73, 21, 0.3767, 2.9437, 4.5154, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.6', 'IM', 3.53, 21, 0.5443, 2.3990, 4.6699, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.7.a', 'IM', 3.85, 21, 0.4854, 2.8411, 4.8663, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.7.b', 'IM', 3.59, 21, 0.4299, 2.6971, 4.4908, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.1.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.1.b', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.1.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.2.b', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.3.a', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.3.b', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.3.c', 'IM', 2.65, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.4.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.4.b', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.4.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.5.a', 'IM', 4.70, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.5.b', 'IM', 4.90, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.5.c', 'IM', 4.80, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.6', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.7.a', 'IM', 3.20, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.7.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.1.a', 'IM', 3.44, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.1.b', 'IM', 3.78, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.1.c', 'IM', 3.70, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.2.b', 'IM', 3.22, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.3.a', 'IM', 3.85, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.3.b', 'IM', 3.11, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.3.c', 'IM', 2.52, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.4.a', 'IM', 3.37, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.4.b', 'IM', 3.33, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.4.c', 'IM', 3.74, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.5.a', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.5.b', 'IM', 4.67, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.5.c', 'IM', 4.48, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.6', 'IM', 3.70, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.7.a', 'IM', 3.22, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.7.b', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.1.a', 'IM', 4.08, 23, 0.2451, 3.5742, 4.5907, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.1.b', 'IM', 4.04, 24, 0.1403, 3.7505, 4.3311, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.1.c', 'IM', 4.12, 24, 0.1616, 3.7869, 4.4555, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.2.b', 'IM', 3.38, 24, 0.3991, 2.5556, 4.2068, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.3.a', 'IM', 3.89, 24, 0.1997, 3.4778, 4.3039, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.3.b', 'IM', 2.97, 24, 0.4007, 2.1421, 3.7999, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.3.c', 'IM', 2.77, 24, 0.2531, 2.2457, 3.2927, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.4.a', 'IM', 3.18, 24, 0.1198, 2.9366, 3.4321, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.4.b', 'IM', 4.10, 24, 0.1177, 3.8528, 4.3396, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.4.c', 'IM', 4.12, 24, 0.1496, 3.8068, 4.4257, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.5.a', 'IM', 4.17, 24, 0.2085, 3.7379, 4.6005, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.5.b', 'IM', 4.69, 24, 0.1219, 4.4402, 4.9446, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.5.c', 'IM', 3.88, 24, 0.4438, 2.9656, 4.8018, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.6', 'IM', 3.74, 24, 0.2112, 3.3047, 4.1785, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.7.a', 'IM', 3.97, 24, 0.1445, 3.6667, 4.2645, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.7.b', 'IM', 4.51, 24, 0.1964, 4.1068, 4.9193, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.1.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.1.b', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.1.c', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.2.b', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.3.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.3.b', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.3.c', 'IM', 2.55, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.4.a', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.4.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.4.c', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.5.a', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.5.b', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.5.c', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.6', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.7.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.7.b', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.1.a', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.1.b', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.1.c', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.2.b', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.3.a', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.3.b', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.3.c', 'IM', 2.48, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.4.a', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.4.b', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.4.c', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.5.a', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.5.b', 'IM', 4.48, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.5.c', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.6', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.7.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.7.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.1.a', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.1.b', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.1.c', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.2.b', 'IM', 3.41, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.3.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.3.b', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.3.c', 'IM', 2.41, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.4.a', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.4.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.4.c', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.5.a', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.5.b', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.5.c', 'IM', 4.82, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.6', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.7.a', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.7.b', 'IM', 4.86, 22, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.1.a', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.1.b', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.1.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.2.b', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.3.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.3.b', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.3.c', 'IM', 2.81, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.4.a', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.4.b', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.4.c', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.5.a', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.5.b', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.5.c', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.6', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.7.a', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.7.b', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.1.a', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.1.b', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.1.c', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.2.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.3.a', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.3.b', 'IM', 3.05, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.3.c', 'IM', 2.59, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.4.a', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.4.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.4.c', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.5.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.5.b', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.5.c', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.6', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.7.a', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.7.b', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.1.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.1.b', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.1.c', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.2.b', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.3.a', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.3.b', 'IM', 3.09, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.3.c', 'IM', 2.43, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.4.a', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.4.b', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.4.c', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.5.a', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.5.b', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.5.c', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.6', 'IM', 3.17, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.7.a', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.7.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.1.a', 'IM', 3.93, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.1.b', 'IM', 3.93, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.1.c', 'IM', 4.03, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.2.b', 'IM', 3.10, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.3.a', 'IM', 3.97, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.3.b', 'IM', 2.83, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.3.c', 'IM', 2.45, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.4.a', 'IM', 3.38, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.4.b', 'IM', 3.62, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.4.c', 'IM', 3.55, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.5.a', 'IM', 3.83, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.5.b', 'IM', 4.59, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.5.c', 'IM', 3.90, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.6', 'IM', 3.55, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.7.a', 'IM', 4.10, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.7.b', 'IM', 4.52, 29, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.1.a', 'IM', 3.59, 20, 0.1368, 3.3082, 3.8807, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.1.b', 'IM', 4.32, 20, 0.2683, 3.7540, 4.8773, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.1.c', 'IM', 4.18, 20, 0.1250, 3.9189, 4.4423, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.2.b', 'IM', 3.32, 20, 0.4358, 2.4054, 4.2298, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.3.a', 'IM', 4.14, 20, 0.2446, 3.6273, 4.6514, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.3.b', 'IM', 3.40, 20, 0.1226, 3.1479, 3.6611, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.3.c', 'IM', 3.19, 20, 0.2473, 2.6746, 3.7097, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.4.a', 'IM', 3.74, 20, 0.1730, 3.3785, 4.1026, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.4.b', 'IM', 3.79, 20, 0.2415, 3.2822, 4.2933, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.4.c', 'IM', 4.01, 20, 0.1539, 3.6902, 4.3343, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.5.a', 'IM', 3.92, 20, 0.3660, 3.1536, 4.6857, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.5.b', 'IM', 4.66, 20, 0.1427, 4.3604, 4.9577, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.5.c', 'IM', 3.99, 20, 0.0615, 3.8580, 4.1156, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.6', 'IM', 3.43, 20, 0.3053, 2.7901, 4.0682, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.7.a', 'IM', 3.71, 20, 0.2383, 3.2092, 4.2066, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.7.b', 'IM', 4.27, 20, 0.1394, 3.9747, 4.5581, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.1.a', 'IM', 3.57, 16, 0.1377, 3.2750, 3.8619, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.1.b', 'IM', 3.80, 16, 0.1249, 3.5342, 4.0665, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.1.c', 'IM', 4.17, 16, 0.1300, 3.8908, 4.4449, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.2.b', 'IM', 3.84, 16, 0.2778, 3.2433, 4.4274, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.3.a', 'IM', 4.28, 16, 0.2346, 3.7784, 4.7786, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.3.b', 'IM', 2.84, 16, 0.1049, 2.6126, 3.0599, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.3.c', 'IM', 2.59, 16, 0.2912, 1.9680, 3.2096, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.4.a', 'IM', 3.39, 16, 0.1607, 3.0433, 3.7285, 'N', '2022-08-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.4.b', 'IM', 3.62, 16, 0.1549, 3.2898, 3.9503, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.4.c', 'IM', 4.13, 16, 0.1791, 3.7484, 4.5118, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.5.a', 'IM', 4.58, 16, 0.1211, 4.3218, 4.8382, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.5.b', 'IM', 4.62, 16, 0.1791, 4.2352, 4.9987, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.5.c', 'IM', 4.25, 16, 0.3349, 3.5379, 4.9654, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.6', 'IM', 3.44, 16, 0.1546, 3.1129, 3.7719, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.7.a', 'IM', 3.97, 16, 0.1203, 3.7184, 4.2311, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.7.b', 'IM', 4.54, 16, 0.1286, 4.2618, 4.8100, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.1.a', 'IM', 4.17, 22, 0.1359, 3.8867, 4.4519, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.1.b', 'IM', 4.16, 22, 0.1948, 3.7552, 4.5655, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.1.c', 'IM', 4.13, 22, 0.1746, 3.7685, 4.4947, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.2.b', 'IM', 3.85, 22, 0.1467, 3.5491, 4.1592, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.3.a', 'IM', 4.35, 22, 0.1400, 4.0630, 4.6451, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.3.b', 'IM', 3.64, 22, 0.2015, 3.2233, 4.0613, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.3.c', 'IM', 3.05, 22, 0.2851, 2.4536, 3.6396, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.4.a', 'IM', 3.91, 22, 0.1647, 3.5720, 4.2571, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.4.b', 'IM', 4.16, 22, 0.1485, 3.8496, 4.4672, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.4.c', 'IM', 4.38, 22, 0.2060, 3.9467, 4.8035, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.5.a', 'IM', 4.20, 22, 0.1669, 3.8570, 4.5513, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.5.b', 'IM', 4.54, 22, 0.1086, 4.3138, 4.7653, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.5.c', 'IM', 4.12, 22, 0.2145, 3.6729, 4.5650, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.6', 'IM', 3.69, 22, 0.2076, 3.2543, 4.1177, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.7.a', 'IM', 4.14, 21, 0.2664, 3.5832, 4.6947, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.7.b', 'IM', 4.39, 22, 0.1385, 4.1042, 4.6803, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.1.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.1.b', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.1.c', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.2.b', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.3.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.3.b', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.3.c', 'IM', 2.81, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.4.a', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.4.b', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.4.c', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.5.a', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.5.b', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.5.c', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.6', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.7.a', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.7.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.1.a', 'IM', 3.92, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.1.b', 'IM', 4.18, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.1.c', 'IM', 4.22, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.2.b', 'IM', 4.08, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.3.a', 'IM', 4.23, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.3.b', 'IM', 4.01, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.3.c', 'IM', 3.19, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.4.a', 'IM', 4.24, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.4.b', 'IM', 4.14, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.4.c', 'IM', 4.12, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.5.a', 'IM', 4.50, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.5.b', 'IM', 4.51, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.5.c', 'IM', 4.86, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.6', 'IM', 3.95, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.7.a', 'IM', 3.58, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.7.b', 'IM', 4.17, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.1.a', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.1.b', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.1.c', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.2.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.3.a', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.3.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.3.c', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.4.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.4.b', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.4.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.5.a', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.5.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.5.c', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.6', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.7.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.7.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.1.a', 'IM', 4.20, 30, 0.1452, 3.9043, 4.4981, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.1.b', 'IM', 4.22, 30, 0.0949, 4.0252, 4.4135, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.1.c', 'IM', 4.10, 30, 0.1495, 3.7895, 4.4010, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.2.b', 'IM', 4.01, 30, 0.1685, 3.6612, 4.3504, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.3.a', 'IM', 4.23, 30, 0.1990, 3.8234, 4.6372, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.3.b', 'IM', 3.60, 30, 0.1620, 3.2670, 3.9297, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.3.c', 'IM', 3.09, 30, 0.2879, 2.5022, 3.6798, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.4.a', 'IM', 4.21, 30, 0.1543, 3.8942, 4.5252, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.4.b', 'IM', 4.16, 30, 0.1687, 3.8122, 4.5024, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.4.c', 'IM', 4.26, 30, 0.1507, 3.9521, 4.5684, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.5.a', 'IM', 4.45, 29, 0.1090, 4.2267, 4.6732, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.5.b', 'IM', 4.61, 29, 0.1156, 4.3773, 4.8508, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.5.c', 'IM', 4.33, 30, 0.1418, 4.0432, 4.6233, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.6', 'IM', 4.21, 30, 0.1185, 3.9687, 4.4535, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.7.a', 'IM', 3.97, 30, 0.1730, 3.6144, 4.3222, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.7.b', 'IM', 4.28, 30, 0.1066, 4.0652, 4.5012, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.1.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.1.b', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.1.c', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.2.b', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.3.a', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.3.b', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.3.c', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.4.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.4.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.4.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.5.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.5.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.5.c', 'IM', 4.70, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.6', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.7.a', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.7.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.1.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.1.b', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.1.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.2.b', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.3.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.3.b', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.3.c', 'IM', 2.85, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.4.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.4.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.4.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.5.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.5.b', 'IM', 4.85, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.5.c', 'IM', 4.70, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.6', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.7.a', 'IM', 2.90, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.7.b', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.1.a', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.1.b', 'IM', 4.08, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.1.c', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.2.b', 'IM', 3.62, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.3.a', 'IM', 4.19, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.3.b', 'IM', 3.19, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.3.c', 'IM', 2.92, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.4.a', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.4.b', 'IM', 4.04, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.4.c', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.5.a', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.5.b', 'IM', 4.46, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.5.c', 'IM', 4.46, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.6', 'IM', 3.58, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.7.a', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.7.b', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.1.a', 'IM', 4.03, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.1.b', 'IM', 4.05, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.1.c', 'IM', 4.27, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.2.b', 'IM', 3.81, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.3.a', 'IM', 3.80, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.3.b', 'IM', 2.85, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.3.c', 'IM', 2.60, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.4.a', 'IM', 3.51, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.4.b', 'IM', 3.83, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.4.c', 'IM', 3.56, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.5.a', 'IM', 4.25, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.5.b', 'IM', 4.45, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.5.c', 'IM', 4.42, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.6', 'IM', 3.95, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.7.a', 'IM', 3.81, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.7.b', 'IM', 4.40, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.1.a', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.1.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.1.c', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.2.b', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.3.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.3.b', 'IM', 3.14, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.3.c', 'IM', 2.90, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.4.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.4.b', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.4.c', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.5.a', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.5.b', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.5.c', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.6', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.7.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.7.b', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.1.a', 'IM', 3.85, 24, 0.1882, 3.4631, 4.2420, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.1.b', 'IM', 3.99, 24, 0.2012, 3.5722, 4.4045, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.1.c', 'IM', 4.08, 24, 0.3196, 3.4156, 4.7378, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.2.b', 'IM', 3.93, 24, 0.3663, 3.1755, 4.6909, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.3.a', 'IM', 4.31, 24, 0.0916, 4.1213, 4.5001, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.3.b', 'IM', 3.71, 24, 0.1792, 3.3427, 4.0842, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.3.c', 'IM', 2.89, 24, 0.2698, 2.3271, 3.4433, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.4.a', 'IM', 4.10, 24, 0.2532, 3.5743, 4.6220, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.4.b', 'IM', 4.25, 24, 0.2522, 3.7306, 4.7740, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.4.c', 'IM', 3.91, 24, 0.2045, 3.4830, 4.3292, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.5.a', 'IM', 4.27, 24, 0.2518, 3.7539, 4.7957, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.5.b', 'IM', 4.30, 24, 0.2343, 3.8135, 4.7830, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.5.c', 'IM', 4.46, 24, 0.1402, 4.1672, 4.7474, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.6', 'IM', 3.69, 24, 0.3137, 3.0432, 4.3409, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.7.a', 'IM', 3.87, 24, 0.1932, 3.4703, 4.2697, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.7.b', 'IM', 4.39, 24, 0.1422, 4.0989, 4.6872, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.1.a', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.1.b', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.1.c', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.2.b', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.3.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.3.b', 'IM', 2.86, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.3.c', 'IM', 2.32, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.4.a', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.4.b', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.4.c', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.5.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.5.b', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.5.c', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.6', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.7.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.7.b', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.1.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.1.b', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.1.c', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.2.b', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.3.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.3.b', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.3.c', 'IM', 2.80, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.4.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.4.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.4.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.5.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.5.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.5.c', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.6', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.7.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.7.b', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.1.a', 'IM', 3.83, 20, 0.1801, 3.4489, 4.2026, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.1.b', 'IM', 3.60, 20, 0.2811, 3.0146, 4.1913, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.1.c', 'IM', 3.91, 20, 0.2175, 3.4545, 4.3650, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.2.b', 'IM', 3.86, 20, 0.2488, 3.3412, 4.3827, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.3.a', 'IM', 4.16, 20, 0.2159, 3.7108, 4.6146, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.3.b', 'IM', 3.38, 20, 0.2409, 2.8805, 3.8888, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.3.c', 'IM', 3.15, 20, 0.2302, 2.6729, 3.6367, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.4.a', 'IM', 3.63, 20, 0.2358, 3.1356, 4.1227, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.4.b', 'IM', 3.93, 20, 0.2479, 3.4138, 4.4515, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.4.c', 'IM', 4.03, 20, 0.1312, 3.7580, 4.3074, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.5.a', 'IM', 4.35, 20, 0.1767, 3.9800, 4.7195, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.5.b', 'IM', 4.64, 20, 0.1478, 4.3297, 4.9482, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.5.c', 'IM', 4.14, 20, 0.2098, 3.6958, 4.5742, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.6', 'IM', 4.08, 20, 0.1493, 3.7707, 4.3955, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.7.a', 'IM', 3.57, 20, 0.2071, 3.1346, 4.0016, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.7.b', 'IM', 4.77, 20, 0.1230, 4.5088, 5.0000, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.1.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.1.b', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.1.c', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.2.b', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.3.a', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.3.b', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.3.c', 'IM', 2.67, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.4.a', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.4.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.4.c', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.5.a', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.5.b', 'IM', 4.70, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.5.c', 'IM', 4.76, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.6', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.7.a', 'IM', 3.19, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.7.b', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.1.a', 'IM', 3.91, 20, 0.2081, 3.4778, 4.3490, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.1.b', 'IM', 3.86, 20, 0.1987, 3.4404, 4.2721, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.1.c', 'IM', 4.19, 20, 0.1331, 3.9114, 4.4688, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.2.b', 'IM', 3.60, 20, 0.1541, 3.2753, 3.9202, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.3.a', 'IM', 4.16, 20, 0.0817, 3.9868, 4.3286, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.3.b', 'IM', 3.39, 20, 0.3017, 2.7543, 4.0171, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.3.c', 'IM', 3.20, 20, 0.3518, 2.4606, 3.9333, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.4.a', 'IM', 3.88, 20, 0.2419, 3.3697, 4.3823, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.4.b', 'IM', 3.72, 20, 0.2124, 3.2745, 4.1637, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.4.c', 'IM', 3.70, 19, 0.4001, 2.8640, 4.5453, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.5.a', 'IM', 4.30, 20, 0.0933, 4.1076, 4.4981, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.5.b', 'IM', 4.38, 20, 0.1105, 4.1453, 4.6079, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.5.c', 'IM', 4.34, 20, 0.2110, 3.9015, 4.7848, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.6', 'IM', 3.69, 20, 0.1318, 3.4124, 3.9642, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.7.a', 'IM', 3.77, 20, 0.4751, 2.7770, 4.7660, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.7.b', 'IM', 4.47, 20, 0.1724, 4.1064, 4.8283, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.1.a', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.1.b', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.1.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.2.b', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.3.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.3.b', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.3.c', 'IM', 3.32, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.4.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.4.b', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.4.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.5.a', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.5.b', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.5.c', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.6', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.7.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.7.b', 'IM', 4.73, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.1.a', 'IM', 3.87, 18, 0.0751, 3.7153, 4.0324, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.1.b', 'IM', 3.88, 18, 0.2096, 3.4405, 4.3251, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.1.c', 'IM', 3.92, 18, 0.3255, 3.2326, 4.6060, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.2.b', 'IM', 3.48, 18, 0.2419, 2.9658, 3.9866, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.3.a', 'IM', 3.81, 18, 0.2395, 3.3021, 4.3126, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.3.b', 'IM', 2.78, 18, 0.3559, 2.0243, 3.5261, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.3.c', 'IM', 2.80, 18, 0.1549, 2.4718, 3.1254, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.4.a', 'IM', 3.50, 18, 0.2371, 2.9969, 3.9974, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.4.b', 'IM', 4.00, 18, 0.0374, 3.9161, 4.0740, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.4.c', 'IM', 3.80, 18, 0.1351, 3.5167, 4.0869, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.5.a', 'IM', 4.15, 18, 0.0901, 3.9555, 4.3357, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.5.b', 'IM', 4.38, 18, 0.2228, 3.9124, 4.8526, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.5.c', 'IM', 4.02, 18, 0.0704, 3.8734, 4.1704, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.6', 'IM', 3.51, 18, 0.1594, 3.1769, 3.8493, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.7.a', 'IM', 4.19, 18, 0.3428, 3.4676, 4.9141, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.7.b', 'IM', 4.20, 18, 0.1506, 3.8851, 4.5205, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.1.a', 'IM', 3.90, 18, 0.2109, 3.4525, 4.3424, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.1.b', 'IM', 3.93, 18, 0.2803, 3.3379, 4.5207, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.1.c', 'IM', 4.07, 18, 0.0390, 3.9830, 4.1474, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.2.b', 'IM', 3.56, 18, 0.1442, 3.2560, 3.8645, 'N', '2016-07-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.3.a', 'IM', 4.01, 18, 0.1589, 3.6701, 4.3407, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.3.b', 'IM', 3.05, 18, 0.3631, 2.2803, 3.8125, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.3.c', 'IM', 2.58, 18, 0.2517, 2.0514, 3.1134, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.4.a', 'IM', 3.52, 18, 0.2006, 3.0939, 3.9403, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.4.b', 'IM', 3.76, 18, 0.1445, 3.4596, 4.0695, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.4.c', 'IM', 3.82, 18, 0.1532, 3.4993, 4.1459, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.5.a', 'IM', 4.05, 18, 0.0422, 3.9636, 4.1417, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.5.b', 'IM', 4.59, 18, 0.1420, 4.2921, 4.8915, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.5.c', 'IM', 4.26, 18, 0.2576, 3.7134, 4.8004, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.6', 'IM', 3.23, 18, 0.2925, 2.6118, 3.8459, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.7.a', 'IM', 4.32, 18, 0.1670, 3.9664, 4.6710, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.7.b', 'IM', 4.66, 18, 0.1307, 4.3817, 4.9334, 'N', '2016-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.1.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.1.b', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.1.c', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.2.b', 'IM', 2.87, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.3.a', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.3.b', 'IM', 2.57, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.3.c', 'IM', 1.96, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.4.a', 'IM', 3.04, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.4.b', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.4.c', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.5.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.5.b', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.5.c', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.6', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.7.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.7.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.1.a', 'IM', 4.27, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.1.b', 'IM', 4.30, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.1.c', 'IM', 4.23, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.2.b', 'IM', 3.48, 29, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.3.a', 'IM', 4.13, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.3.b', 'IM', 3.30, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.3.c', 'IM', 2.67, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.4.a', 'IM', 3.70, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.4.b', 'IM', 3.93, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.4.c', 'IM', 4.10, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.5.a', 'IM', 4.20, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.5.b', 'IM', 4.47, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.5.c', 'IM', 4.23, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.6', 'IM', 3.70, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.7.a', 'IM', 4.20, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.7.b', 'IM', 4.50, 30, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.1.a', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.1.b', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.1.c', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.2.b', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.3.a', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.3.b', 'IM', 3.00, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.3.c', 'IM', 2.19, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.4.a', 'IM', 2.95, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.4.b', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.4.c', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.5.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.5.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.5.c', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.6', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.7.a', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.7.b', 'IM', 4.76, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.1.a', 'IM', 4.23, 35, 0.1960, 3.8307, 4.6274, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.1.b', 'IM', 4.28, 35, 0.1864, 3.8964, 4.6541, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.1.c', 'IM', 4.39, 35, 0.1627, 4.0618, 4.7231, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.2.b', 'IM', 4.05, 35, 0.2632, 3.5104, 4.5803, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.3.a', 'IM', 4.22, 35, 0.1884, 3.8324, 4.5980, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.3.b', 'IM', 3.39, 35, 0.1834, 3.0203, 3.7657, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.3.c', 'IM', 3.08, 35, 0.1326, 2.8117, 3.3506, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.4.a', 'IM', 3.91, 35, 0.2941, 3.3135, 4.5087, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.4.b', 'IM', 4.29, 35, 0.1870, 3.9115, 4.6714, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.4.c', 'IM', 4.37, 35, 0.1843, 4.0005, 4.7495, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.5.a', 'IM', 4.37, 35, 0.1083, 4.1546, 4.5948, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.5.b', 'IM', 4.55, 35, 0.1463, 4.2506, 4.8451, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.5.c', 'IM', 4.37, 35, 0.1560, 4.0481, 4.6821, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.6', 'IM', 4.18, 35, 0.2295, 3.7146, 4.6475, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.7.a', 'IM', 4.01, 35, 0.1165, 3.7689, 4.2424, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.7.b', 'IM', 4.63, 35, 0.1241, 4.3790, 4.8835, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.1.a', 'IM', 3.86, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.1.b', 'IM', 3.96, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.1.c', 'IM', 3.75, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.2.b', 'IM', 3.25, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.3.a', 'IM', 4.04, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.3.b', 'IM', 3.39, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.3.c', 'IM', 2.64, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.4.a', 'IM', 3.25, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.4.b', 'IM', 3.75, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.4.c', 'IM', 4.00, 27, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.5.a', 'IM', 4.29, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.5.b', 'IM', 4.61, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.5.c', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.6', 'IM', 3.43, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.7.a', 'IM', 3.11, 27, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.7.b', 'IM', 3.93, 28, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.1.a', 'IM', 3.71, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.1.b', 'IM', 3.67, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.1.c', 'IM', 3.80, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.2.b', 'IM', 3.67, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.3.a', 'IM', 4.33, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.3.b', 'IM', 2.94, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.3.c', 'IM', 3.07, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.4.a', 'IM', 3.82, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.4.b', 'IM', 3.96, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.4.c', 'IM', 4.15, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.5.a', 'IM', 4.58, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.5.b', 'IM', 4.78, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.5.c', 'IM', 3.86, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.6', 'IM', 3.99, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.7.a', 'IM', 3.80, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.7.b', 'IM', 4.29, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.1.a', 'IM', 3.72, 69, 0.2223, 3.2766, 4.1640, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.1.b', 'IM', 3.68, 69, 0.2155, 3.2532, 4.1130, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.1.c', 'IM', 4.07, 70, 0.0709, 3.9271, 4.2100, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.2.b', 'IM', 3.36, 70, 0.4009, 2.5617, 4.1613, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.3.a', 'IM', 3.98, 70, 0.2764, 3.4302, 4.5331, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.3.b', 'IM', 3.37, 70, 0.1246, 3.1205, 3.6176, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.3.c', 'IM', 2.95, 70, 0.3056, 2.3359, 3.5551, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.4.a', 'IM', 3.58, 70, 0.4459, 2.6864, 4.4657, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.4.b', 'IM', 3.57, 70, 0.4730, 2.6239, 4.5112, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.4.c', 'IM', 3.76, 70, 0.2390, 3.2863, 4.2399, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.5.a', 'IM', 4.08, 69, 0.3380, 3.4023, 4.7512, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.5.b', 'IM', 4.55, 70, 0.1606, 4.2325, 4.8734, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.5.c', 'IM', 3.58, 69, 0.4299, 2.7262, 4.4420, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.6', 'IM', 3.70, 69, 0.2246, 3.2495, 4.1459, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.7.a', 'IM', 3.69, 70, 0.1486, 3.3896, 3.9824, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.7.b', 'IM', 3.85, 70, 0.2472, 3.3617, 4.3481, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.1.a', 'IM', 3.74, 29, 0.2150, 3.2984, 4.1793, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.1.b', 'IM', 3.60, 29, 0.1753, 3.2376, 3.9556, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.1.c', 'IM', 4.16, 29, 0.0911, 3.9748, 4.3481, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.2.b', 'IM', 3.61, 29, 0.1563, 3.2923, 3.9325, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.3.a', 'IM', 4.05, 28, 0.1860, 3.6733, 4.4363, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.3.b', 'IM', 3.35, 28, 0.2013, 2.9355, 3.7615, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.3.c', 'IM', 3.27, 28, 0.2130, 2.8326, 3.7066, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.4.a', 'IM', 3.88, 28, 0.1795, 3.5073, 4.2437, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.4.b', 'IM', 3.91, 28, 0.1218, 3.6564, 4.1562, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.4.c', 'IM', 3.84, 28, 0.2476, 3.3336, 4.3498, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.5.a', 'IM', 4.23, 28, 0.1324, 3.9557, 4.4992, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.5.b', 'IM', 4.84, 28, 0.0904, 4.6504, 5.0000, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.5.c', 'IM', 4.20, 29, 0.1238, 3.9475, 4.4545, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.6', 'IM', 3.58, 29, 0.4111, 2.7400, 4.4241, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.7.a', 'IM', 4.02, 29, 0.1247, 3.7668, 4.2779, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.7.b', 'IM', 4.34, 29, 0.1886, 3.9561, 4.7289, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.1.a', 'IM', 3.34, 15, 0.4285, 2.4254, 4.2634, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.1.b', 'IM', 4.22, 15, 0.2820, 3.6169, 4.8267, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.1.c', 'IM', 4.23, 15, 0.2823, 3.6219, 4.8330, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.2.b', 'IM', 3.23, 15, 0.2616, 2.6675, 3.7898, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.3.a', 'IM', 3.81, 15, 0.1867, 3.4122, 4.2132, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.3.b', 'IM', 2.93, 15, 0.2664, 2.3553, 3.4978, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.3.c', 'IM', 2.97, 15, 0.3897, 2.1298, 3.8015, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.4.a', 'IM', 3.72, 15, 0.3598, 2.9491, 4.4924, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.4.b', 'IM', 4.08, 15, 0.3140, 3.4032, 4.7502, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.4.c', 'IM', 4.37, 15, 0.2560, 3.8206, 4.9186, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.5.a', 'IM', 4.61, 15, 0.2389, 4.0991, 5.0000, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.5.b', 'IM', 4.77, 15, 0.1588, 4.4295, 5.0000, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.5.c', 'IM', 4.45, 15, 0.3452, 3.7106, 5.0000, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.6', 'IM', 4.16, 15, 0.2085, 3.7165, 4.6111, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.7.a', 'IM', 3.60, 15, 0.3567, 2.8325, 4.3625, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.7.b', 'IM', 4.47, 15, 0.1875, 4.0686, 4.8728, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.1.a', 'IM', 3.83, 36, 0.1445, 3.5400, 4.1269, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.1.b', 'IM', 4.03, 36, 0.2059, 3.6163, 4.4523, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.1.c', 'IM', 4.23, 36, 0.1754, 3.8717, 4.5838, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.2.b', 'IM', 3.87, 36, 0.1529, 3.5579, 4.1786, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.3.a', 'IM', 4.36, 36, 0.0828, 4.1968, 4.5331, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.3.b', 'IM', 3.74, 36, 0.1233, 3.4926, 3.9933, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.3.c', 'IM', 3.58, 35, 0.1265, 3.3189, 3.8329, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.4.a', 'IM', 4.05, 36, 0.2951, 3.4554, 4.6536, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.4.b', 'IM', 3.94, 36, 0.1687, 3.6012, 4.2861, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.4.c', 'IM', 4.14, 36, 0.1484, 3.8356, 4.4380, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.5.a', 'IM', 4.47, 36, 0.0827, 4.3057, 4.6414, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.5.b', 'IM', 4.51, 36, 0.0886, 4.3323, 4.6921, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.5.c', 'IM', 4.61, 36, 0.1015, 4.4073, 4.8195, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.6', 'IM', 3.49, 36, 0.4031, 2.6723, 4.3091, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.7.a', 'IM', 3.74, 36, 0.1367, 3.4635, 4.0183, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.7.b', 'IM', 4.08, 36, 0.1634, 3.7469, 4.4105, 'N', '2017-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.1.a', 'IM', 3.85, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.1.b', 'IM', 3.93, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.1.c', 'IM', 4.01, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.2.b', 'IM', 3.37, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.3.a', 'IM', 4.06, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.3.b', 'IM', 3.40, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.3.c', 'IM', 3.01, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.4.a', 'IM', 3.84, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.4.b', 'IM', 3.89, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.4.c', 'IM', 4.12, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.5.a', 'IM', 4.39, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.5.b', 'IM', 4.60, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.5.c', 'IM', 4.16, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.6', 'IM', 3.91, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.7.a', 'IM', 3.66, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.7.b', 'IM', 4.31, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.1.a', 'IM', 3.83, 38, 0.3247, 3.1699, 4.4859, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.1.b', 'IM', 4.29, 38, 0.1209, 4.0467, 4.5368, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.1.c', 'IM', 4.33, 38, 0.1319, 4.0578, 4.5924, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.2.b', 'IM', 3.24, 38, 0.4138, 2.3988, 4.0756, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.3.a', 'IM', 4.13, 37, 0.2195, 3.6880, 4.5785, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.3.b', 'IM', 3.69, 38, 0.2170, 3.2540, 4.1333, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.3.c', 'IM', 2.75, 38, 0.3036, 2.1340, 3.3642, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.4.a', 'IM', 3.94, 38, 0.1953, 3.5432, 4.3344, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.4.b', 'IM', 3.79, 38, 0.1875, 3.4108, 4.1706, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.4.c', 'IM', 3.98, 38, 0.1244, 3.7293, 4.2336, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.5.a', 'IM', 4.49, 38, 0.1325, 4.2218, 4.7588, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.5.b', 'IM', 4.73, 38, 0.0931, 4.5384, 4.9155, 'N', '2022-08-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.5.c', 'IM', 4.15, 38, 0.1480, 3.8545, 4.4544, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.6', 'IM', 3.98, 38, 0.1584, 3.6621, 4.3041, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.7.a', 'IM', 3.68, 38, 0.1828, 3.3095, 4.0504, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.7.b', 'IM', 4.27, 38, 0.1119, 4.0466, 4.5000, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.1.a', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.1.b', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.1.c', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.2.b', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.3.a', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.3.b', 'IM', 3.05, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.3.c', 'IM', 2.38, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.4.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.4.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.4.c', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.5.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.5.b', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.5.c', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.6', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.7.a', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.7.b', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.1.a', 'IM', 3.67, 23, 0.2392, 3.1696, 4.1619, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.1.b', 'IM', 3.49, 23, 0.1898, 3.1003, 3.8873, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.1.c', 'IM', 4.11, 23, 0.2262, 3.6367, 4.5748, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.2.b', 'IM', 3.66, 23, 0.1422, 3.3606, 3.9504, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.3.a', 'IM', 4.30, 23, 0.1379, 4.0124, 4.5846, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.3.b', 'IM', 3.27, 23, 0.2382, 2.7721, 3.7603, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.3.c', 'IM', 2.88, 23, 0.3166, 2.2190, 3.5324, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.4.a', 'IM', 3.23, 23, 0.3397, 2.5284, 3.9372, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.4.b', 'IM', 4.06, 23, 0.1404, 3.7733, 4.3554, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.4.c', 'IM', 3.90, 23, 0.2163, 3.4466, 4.3439, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.5.a', 'IM', 4.21, 23, 0.1832, 3.8251, 4.5851, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.5.b', 'IM', 4.26, 23, 0.1757, 3.8928, 4.6216, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.5.c', 'IM', 4.23, 23, 0.1678, 3.8808, 4.5768, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.6', 'IM', 3.62, 23, 0.3519, 2.8889, 4.3485, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.7.a', 'IM', 2.98, 23, 0.2040, 2.5520, 3.3983, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.7.b', 'IM', 3.80, 23, 0.3272, 3.1190, 4.4761, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.1.a', 'IM', 3.88, 28, 0.0494, 3.7805, 3.9831, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.1.b', 'IM', 3.89, 28, 0.0704, 3.7487, 4.0376, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.1.c', 'IM', 4.04, 27, 0.0322, 3.9695, 4.1017, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.2.b', 'IM', 3.34, 28, 0.1078, 3.1177, 3.5601, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.3.a', 'IM', 4.10, 28, 0.0554, 3.9865, 4.2136, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.3.b', 'IM', 3.79, 28, 0.1414, 3.5032, 4.0833, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.3.c', 'IM', 3.12, 28, 0.1084, 2.8956, 3.3403, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.4.a', 'IM', 3.98, 28, 0.1252, 3.7268, 4.2408, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.4.b', 'IM', 4.15, 28, 0.1211, 3.8992, 4.3962, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.4.c', 'IM', 3.81, 28, 0.1134, 3.5757, 4.0410, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.5.a', 'IM', 4.35, 28, 0.0701, 4.2069, 4.4946, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.5.b', 'IM', 4.36, 28, 0.1550, 4.0448, 4.6809, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.5.c', 'IM', 4.09, 28, 0.2664, 3.5400, 4.6333, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.6', 'IM', 3.90, 28, 0.0585, 3.7762, 4.0162, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.7.a', 'IM', 3.75, 28, 0.3270, 3.0804, 4.4224, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.7.b', 'IM', 4.30, 28, 0.1195, 4.0570, 4.5475, 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.1.a', 'IM', 3.91, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.1.b', 'IM', 4.11, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.1.c', 'IM', 4.00, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.2.b', 'IM', 3.05, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.3.a', 'IM', 3.92, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.3.b', 'IM', 3.03, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.3.c', 'IM', 2.04, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.4.a', 'IM', 3.34, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.4.b', 'IM', 3.43, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.4.c', 'IM', 3.78, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.5.a', 'IM', 4.02, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.5.b', 'IM', 4.63, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.5.c', 'IM', 4.05, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.6', 'IM', 3.52, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.7.a', 'IM', 3.73, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.7.b', 'IM', 4.35, NULL, NULL, NULL, NULL, NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.1.a', 'IM', 3.63, 31, 0.1298, 3.3630, 3.8931, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.1.b', 'IM', 3.81, 31, 0.1854, 3.4267, 4.1842, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.1.c', 'IM', 3.92, 31, 0.0913, 3.7373, 4.1102, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.2.b', 'IM', 3.37, 31, 0.1304, 3.1053, 3.6379, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.3.a', 'IM', 3.72, 31, 0.1873, 3.3343, 4.0994, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.3.b', 'IM', 3.03, 31, 0.2928, 2.4310, 3.6269, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.3.c', 'IM', 2.89, 31, 0.1456, 2.5920, 3.1869, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.4.a', 'IM', 3.46, 31, 0.3759, 2.6928, 4.2280, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.4.b', 'IM', 3.57, 31, 0.1609, 3.2424, 3.8996, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.4.c', 'IM', 3.73, 31, 0.1642, 3.3994, 4.0700, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.5.a', 'IM', 4.01, 31, 0.2193, 3.5658, 4.4615, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.5.b', 'IM', 4.40, 31, 0.1215, 4.1562, 4.6524, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.5.c', 'IM', 3.81, 31, 0.4044, 2.9890, 4.6409, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.6', 'IM', 3.63, 31, 0.1347, 3.3550, 3.9053, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.7.a', 'IM', 3.49, 31, 0.1532, 3.1752, 3.8010, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.7.b', 'IM', 4.07, 31, 0.1647, 3.7302, 4.4029, 'N', '2022-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.1.a', 'IM', 3.78, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.1.b', 'IM', 4.00, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.1.c', 'IM', 4.00, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.2.b', 'IM', 3.19, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.3.a', 'IM', 4.04, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.3.b', 'IM', 3.19, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.3.c', 'IM', 3.11, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.4.a', 'IM', 3.67, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.4.b', 'IM', 3.85, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.4.c', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.5.a', 'IM', 4.41, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.5.b', 'IM', 4.52, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.5.c', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.6', 'IM', 3.59, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.7.a', 'IM', 3.89, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.7.b', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.1.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.1.b', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.1.c', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.2.b', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.3.a', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.3.b', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.3.c', 'IM', 2.64, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.4.a', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.4.b', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.4.c', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.5.a', 'IM', 4.68, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.5.b', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.5.c', 'IM', 4.86, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.6', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.7.a', 'IM', 3.09, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.7.b', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.1.a', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.1.b', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.1.c', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.2.b', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.3.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.3.b', 'IM', 2.68, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.3.c', 'IM', 2.05, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.4.a', 'IM', 3.32, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.4.b', 'IM', 3.32, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.4.c', 'IM', 3.41, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.5.a', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.5.b', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.5.c', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.6', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.7.a', 'IM', 3.05, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.7.b', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.1.a', 'IM', 3.70, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.1.b', 'IM', 3.61, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.1.c', 'IM', 3.51, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.2.b', 'IM', 3.25, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.3.a', 'IM', 4.04, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.3.b', 'IM', 3.11, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.3.c', 'IM', 2.79, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.4.a', 'IM', 3.34, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.4.b', 'IM', 3.48, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.4.c', 'IM', 3.59, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.5.a', 'IM', 4.25, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.5.b', 'IM', 4.64, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.5.c', 'IM', 4.01, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.6', 'IM', 3.88, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.7.a', 'IM', 3.04, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.7.b', 'IM', 4.02, NULL, NULL, NULL, NULL, 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.1.a', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.1.b', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.1.c', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.2.b', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.3.a', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.3.b', 'IM', 3.13, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.3.c', 'IM', 2.57, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.4.a', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.4.b', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.4.c', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.5.a', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.5.b', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.5.c', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.6', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.7.a', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.7.b', 'IM', 4.65, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.1.a', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.1.b', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.1.c', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.2.b', 'IM', 3.57, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.3.a', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.3.b', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.3.c', 'IM', 2.70, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.4.a', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.4.b', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.4.c', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.5.a', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.5.b', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.5.c', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.6', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.7.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.7.b', 'IM', 4.61, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.1.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.1.b', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.1.c', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.2.b', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.3.a', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.3.b', 'IM', 3.24, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.3.c', 'IM', 2.86, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.4.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.4.b', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.4.c', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.5.a', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.5.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.5.c', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.6', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.7.a', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.7.b', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.1.a', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.1.b', 'IM', 4.85, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.1.c', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.2.b', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.3.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.3.b', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.3.c', 'IM', 2.65, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.4.a', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.4.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.4.c', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.5.a', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.5.b', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.5.c', 'IM', 4.95, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.6', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.7.a', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.7.b', 'IM', 4.90, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.1.a', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.1.b', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.1.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.2.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.3.a', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.3.b', 'IM', 3.55, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.3.c', 'IM', 2.73, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.4.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.4.b', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.4.c', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.5.a', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.5.b', 'IM', 4.73, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.5.c', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.6', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.7.a', 'IM', 3.41, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.7.b', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.1.a', 'IM', 4.02, 20, 0.1612, 3.6841, 4.3590, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.1.b', 'IM', 4.15, 20, 0.1869, 3.7569, 4.5392, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.1.c', 'IM', 4.36, 20, 0.1570, 4.0314, 4.6887, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.2.b', 'IM', 3.99, 20, 0.2121, 3.5458, 4.4338, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.3.a', 'IM', 4.48, 20, 0.1367, 4.1936, 4.7656, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.3.b', 'IM', 3.56, 20, 0.2265, 3.0820, 4.0300, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.3.c', 'IM', 2.72, 20, 0.2163, 2.2668, 3.1722, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.4.a', 'IM', 3.86, 20, 0.1709, 3.5016, 4.2170, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.4.b', 'IM', 3.85, 20, 0.1714, 3.4935, 4.2111, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.4.c', 'IM', 4.16, 20, 0.1754, 3.7979, 4.5320, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.5.a', 'IM', 4.31, 20, 0.1478, 4.0025, 4.6210, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.5.b', 'IM', 4.29, 20, 0.1564, 3.9641, 4.6186, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.5.c', 'IM', 4.43, 20, 0.1399, 4.1353, 4.7209, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.6', 'IM', 4.01, 20, 0.1823, 3.6248, 4.3881, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.7.a', 'IM', 3.71, 20, 0.2421, 3.1999, 4.2134, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.7.b', 'IM', 4.11, 20, 0.2351, 3.6167, 4.6009, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.1.a', 'IM', 4.41, 30, 0.3380, 3.7212, 5.0000, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.1.b', 'IM', 4.51, 30, 0.2594, 3.9789, 5.0000, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.1.c', 'IM', 4.38, 29, 0.1837, 3.9991, 4.7518, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.2.b', 'IM', 3.67, 29, 0.3228, 3.0077, 4.3301, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.3.a', 'IM', 3.98, 30, 0.0627, 3.8532, 4.1097, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.3.b', 'IM', 2.89, 30, 0.3764, 2.1160, 3.6555, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.3.c', 'IM', 2.85, 29, 0.3717, 2.0854, 3.6081, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.4.a', 'IM', 3.30, 30, 0.2666, 2.7576, 3.8481, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.4.b', 'IM', 3.23, 30, 0.2960, 2.6253, 3.8362, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.4.c', 'IM', 4.31, 30, 0.2420, 3.8186, 4.8083, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.5.a', 'IM', 4.48, 30, 0.1816, 4.1038, 4.8465, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.5.b', 'IM', 4.54, 30, 0.1997, 4.1283, 4.9453, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.5.c', 'IM', 4.49, 30, 0.2567, 3.9687, 5.0000, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.6', 'IM', 4.45, 30, 0.2827, 3.8738, 5.0000, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.7.a', 'IM', 4.23, 30, 0.1532, 3.9202, 4.5470, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.7.b', 'IM', 4.85, 30, 0.1001, 4.6413, 5.0000, 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.1.a', 'IM', 4.35, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.1.b', 'IM', 4.58, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.1.c', 'IM', 4.27, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.2.b', 'IM', 3.62, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.3.a', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.3.b', 'IM', 3.38, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.3.c', 'IM', 2.62, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.4.a', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.4.b', 'IM', 4.19, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.4.c', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.5.a', 'IM', 4.38, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.5.b', 'IM', 4.58, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.5.c', 'IM', 4.54, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.6', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.7.a', 'IM', 3.96, 26, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.7.b', 'IM', 4.52, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.1.a', 'IM', 4.44, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.1.b', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.1.c', 'IM', 4.28, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.2.b', 'IM', 3.48, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.3.a', 'IM', 3.80, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.3.b', 'IM', 3.44, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.3.c', 'IM', 2.48, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.4.a', 'IM', 3.44, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.4.b', 'IM', 3.60, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.4.c', 'IM', 3.68, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.5.a', 'IM', 4.16, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.5.b', 'IM', 4.72, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.5.c', 'IM', 4.80, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.6', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.7.a', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.7.b', 'IM', 4.72, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.1.a', 'IM', 3.48, 16, 0.2017, 3.0499, 3.9095, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.1.b', 'IM', 3.76, 16, 0.1340, 3.4759, 4.0471, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.1.c', 'IM', 4.17, 16, 0.0983, 3.9590, 4.3782, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.2.b', 'IM', 3.80, 16, 0.1921, 3.3935, 4.2126, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.3.a', 'IM', 4.57, 15, 0.1572, 4.2321, 4.9064, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.3.b', 'IM', 3.35, 15, 0.1760, 2.9692, 3.7241, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.3.c', 'IM', 3.19, 15, 0.1845, 2.7912, 3.5826, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.4.a', 'IM', 3.46, 15, 0.2323, 2.9577, 3.9541, 'N', '2018-08-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.4.b', 'IM', 3.98, 15, 0.2598, 3.4180, 4.5325, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.4.c', 'IM', 3.85, 15, 0.1928, 3.4362, 4.2631, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.5.a', 'IM', 4.09, 15, 0.1167, 3.8357, 4.3361, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.5.b', 'IM', 4.60, 15, 0.1890, 4.1900, 5.0000, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.5.c', 'IM', 4.54, 16, 0.1371, 4.2499, 4.8345, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.6', 'IM', 3.59, 16, 0.2591, 3.0360, 4.1404, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.7.a', 'IM', 3.28, 16, 0.2398, 2.7723, 3.7945, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.7.b', 'IM', 4.39, 16, 0.2464, 3.8602, 4.9106, 'N', '2018-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.1.a', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.1.b', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.1.c', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.2.b', 'IM', 3.57, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.3.a', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.3.b', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.3.c', 'IM', 2.78, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.4.a', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.4.b', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.4.c', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.5.a', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.5.b', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.5.c', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.6', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.7.a', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.7.b', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.1.a', 'IM', 3.49, 17, 0.1630, 3.1400, 3.8312, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.1.b', 'IM', 3.85, 17, 0.2076, 3.4053, 4.2856, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.1.c', 'IM', 4.33, 17, 0.1276, 4.0594, 4.6005, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.2.b', 'IM', 4.08, 17, 0.2010, 3.6584, 4.5107, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.3.a', 'IM', 4.24, 17, 0.1716, 3.8792, 4.6067, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.3.b', 'IM', 3.64, 17, 0.1743, 3.2705, 4.0096, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.3.c', 'IM', 2.72, 17, 0.2093, 2.2766, 3.1642, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.4.a', 'IM', 3.92, 17, 0.2358, 3.4196, 4.4191, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.4.b', 'IM', 3.79, 17, 0.1735, 3.4267, 4.1625, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.4.c', 'IM', 4.10, 17, 0.1523, 3.7774, 4.4231, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.5.a', 'IM', 4.38, 17, 0.1280, 4.1056, 4.6481, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.5.b', 'IM', 4.07, 17, 0.2015, 3.6405, 4.4946, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.5.c', 'IM', 4.29, 17, 0.1654, 3.9400, 4.6411, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.6', 'IM', 4.19, 17, 0.2012, 3.7673, 4.6205, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.7.a', 'IM', 3.76, 17, 0.1706, 3.4015, 4.1246, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.7.b', 'IM', 3.93, 17, 0.1586, 3.5938, 4.2661, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.1.a', 'IM', 3.49, 24, 0.2336, 3.0114, 3.9778, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.1.b', 'IM', 3.30, 24, 0.2058, 2.8787, 3.7302, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.1.c', 'IM', 3.41, 24, 0.2090, 2.9758, 3.8406, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.2.b', 'IM', 3.66, 24, 0.1826, 3.2797, 4.0354, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.3.a', 'IM', 4.40, 24, 0.1447, 4.0994, 4.6982, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.3.b', 'IM', 4.31, 24, 0.2193, 3.8592, 4.7666, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.3.c', 'IM', 4.12, 24, 0.2836, 3.5304, 4.7037, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.4.a', 'IM', 4.41, 24, 0.1961, 4.0022, 4.8136, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.4.b', 'IM', 4.06, 24, 0.2349, 3.5720, 4.5438, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.4.c', 'IM', 4.04, 24, 0.1454, 3.7398, 4.3416, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.5.a', 'IM', 4.24, 24, 0.1557, 3.9162, 4.5602, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.5.b', 'IM', 3.74, 24, 0.2197, 3.2877, 4.1966, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.5.c', 'IM', 4.59, 24, 0.0914, 4.4035, 4.7818, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.6', 'IM', 3.56, 24, 0.1568, 3.2390, 3.8877, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.7.a', 'IM', 3.09, 24, 0.1817, 2.7124, 3.4641, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.7.b', 'IM', 3.17, 24, 0.1976, 2.7647, 3.5823, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.1.a', 'IM', 3.66, 25, 0.2335, 3.1820, 4.1460, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.1.b', 'IM', 3.73, 25, 0.3490, 3.0137, 4.4543, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.1.c', 'IM', 3.73, 25, 0.2579, 3.1945, 4.2590, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.2.b', 'IM', 3.62, 25, 0.2416, 3.1182, 4.1153, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.3.a', 'IM', 4.22, 25, 0.2300, 3.7451, 4.6947, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.3.b', 'IM', 3.89, 25, 0.2663, 3.3452, 4.4445, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.3.c', 'IM', 3.07, 25, 0.2313, 2.5904, 3.5452, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.4.a', 'IM', 3.88, 25, 0.0976, 3.6758, 4.0789, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.4.b', 'IM', 3.49, 25, 0.2350, 3.0011, 3.9713, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.4.c', 'IM', 3.95, 25, 0.1533, 3.6384, 4.2713, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.5.a', 'IM', 4.28, 25, 0.2209, 3.8283, 4.7402, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.5.b', 'IM', 3.86, 25, 0.2249, 3.3994, 4.3276, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.5.c', 'IM', 4.47, 25, 0.1374, 4.1855, 4.7528, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.6', 'IM', 3.87, 25, 0.3381, 3.1693, 4.5648, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.7.a', 'IM', 3.18, 25, 0.2780, 2.6015, 3.7491, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.7.b', 'IM', 3.83, 25, 0.1653, 3.4849, 4.1672, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.1.a', 'IM', 4.00, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.1.b', 'IM', 4.28, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.1.c', 'IM', 4.44, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.2.b', 'IM', 4.00, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.3.a', 'IM', 4.28, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.3.b', 'IM', 3.50, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.3.c', 'IM', 3.06, 17, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.4.a', 'IM', 3.22, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.4.b', 'IM', 3.56, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.4.c', 'IM', 3.83, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.5.a', 'IM', 4.39, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.5.b', 'IM', 4.56, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.5.c', 'IM', 4.61, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.6', 'IM', 4.11, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.7.a', 'IM', 4.06, 18, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.7.b', 'IM', 4.82, 17, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.1.a', 'IM', 4.16, 21, 0.2351, 3.6668, 4.6475, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.1.b', 'IM', 4.01, 21, 0.1953, 3.5982, 4.4132, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.1.c', 'IM', 4.14, 21, 0.2331, 3.6584, 4.6308, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.2.b', 'IM', 3.83, 21, 0.3060, 3.1922, 4.4690, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.3.a', 'IM', 4.14, 21, 0.2709, 3.5750, 4.7050, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.3.b', 'IM', 3.53, 21, 0.2145, 3.0849, 3.9796, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.3.c', 'IM', 3.67, 21, 0.2257, 3.1984, 4.1400, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.4.a', 'IM', 3.91, 21, 0.2500, 3.3854, 4.4285, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.4.b', 'IM', 3.83, 21, 0.3180, 3.1671, 4.4939, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.4.c', 'IM', 3.91, 21, 0.3444, 3.1931, 4.6300, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.5.a', 'IM', 4.08, 21, 0.4013, 3.2405, 4.9147, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.5.b', 'IM', 4.28, 21, 0.1279, 4.0150, 4.5484, 'N', '2021-08-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.5.c', 'IM', 4.36, 21, 0.1834, 3.9820, 4.7471, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.6', 'IM', 3.87, 21, 0.1642, 3.5265, 4.2116, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.7.a', 'IM', 4.44, 21, 0.0917, 4.2515, 4.6339, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.7.b', 'IM', 4.53, 21, 0.0661, 4.3907, 4.6667, 'N', '2021-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.1.a', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.1.b', 'IM', 4.61, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.1.c', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.2.b', 'IM', 3.39, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.3.a', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.3.b', 'IM', 3.22, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.3.c', 'IM', 2.48, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.4.a', 'IM', 2.83, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.4.b', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.4.c', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.5.a', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.5.b', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.5.c', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.6', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.7.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.7.b', 'IM', 4.91, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.1.a', 'IM', 4.49, 18, 0.2403, 3.9844, 4.9985, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.1.b', 'IM', 4.09, 18, 0.4109, 3.2201, 4.9538, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.1.c', 'IM', 4.38, 18, 0.1801, 4.0047, 4.7646, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.2.b', 'IM', 3.53, 18, 0.2574, 2.9862, 4.0725, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.3.a', 'IM', 3.59, 18, 0.2620, 3.0367, 4.1421, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.3.b', 'IM', 2.67, 18, 0.2693, 2.1023, 3.2386, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.3.c', 'IM', 2.27, 18, 0.2308, 1.7821, 2.7562, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.4.a', 'IM', 3.07, 18, 0.4686, 2.0787, 4.0562, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.4.b', 'IM', 3.46, 18, 0.5208, 2.3650, 4.5627, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.4.c', 'IM', 3.44, 18, 0.3573, 2.6874, 4.1951, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.5.a', 'IM', 3.79, 18, 0.4441, 2.8581, 4.7318, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.5.b', 'IM', 4.33, 18, 0.2822, 3.7358, 4.9266, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.5.c', 'IM', 4.18, 18, 0.2543, 3.6418, 4.7148, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.6', 'IM', 4.10, 18, 0.1873, 3.7008, 4.4910, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.7.a', 'IM', 4.50, 18, 0.2202, 4.0365, 4.9658, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.7.b', 'IM', 4.47, 18, 0.2276, 3.9938, 4.9542, 'N', '2020-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.1.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.1.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.1.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.2.b', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.3.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.3.b', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.3.c', 'IM', 2.75, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.4.a', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.4.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.4.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.5.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.5.b', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.5.c', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.6', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.7.a', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.7.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.1.a', 'IM', 3.97, 20, 0.1899, 3.5739, 4.3689, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.1.b', 'IM', 4.04, 20, 0.1335, 3.7654, 4.3240, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.1.c', 'IM', 3.94, 20, 0.1841, 3.5539, 4.3244, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.2.b', 'IM', 3.87, 20, 0.1313, 3.5911, 4.1408, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.3.a', 'IM', 4.15, 20, 0.1110, 3.9175, 4.3822, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.3.b', 'IM', 3.37, 20, 0.3002, 2.7372, 3.9938, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.3.c', 'IM', 2.99, 20, 0.3009, 2.3588, 3.6184, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.4.a', 'IM', 3.84, 20, 0.2266, 3.3632, 4.3115, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.4.b', 'IM', 3.98, 20, 0.1657, 3.6286, 4.3220, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.4.c', 'IM', 3.77, 20, 0.2416, 3.2604, 4.2718, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.5.a', 'IM', 4.30, 20, 0.1475, 3.9920, 4.6093, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.5.b', 'IM', 4.41, 20, 0.1185, 4.1647, 4.6606, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.5.c', 'IM', 4.37, 20, 0.1482, 4.0558, 4.6763, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.6', 'IM', 4.35, 20, 0.1981, 3.9347, 4.7638, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.7.a', 'IM', 3.60, 20, 0.3184, 2.9325, 4.2652, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.7.b', 'IM', 4.58, 20, 0.1497, 4.2693, 4.8960, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.1.a', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.1.b', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.1.c', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.2.b', 'IM', 3.24, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.3.a', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.3.b', 'IM', 2.81, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.3.c', 'IM', 2.33, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.4.a', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.4.b', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.4.c', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.5.a', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.5.b', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.5.c', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.6', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.7.a', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.7.b', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.1.a', 'IM', 3.88, 35, 0.0684, 3.7390, 4.0169, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.1.b', 'IM', 3.82, 35, 0.1039, 3.6089, 4.0312, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.1.c', 'IM', 3.99, 35, 0.0659, 3.8549, 4.1226, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.2.b', 'IM', 3.63, 35, 0.1670, 3.2937, 3.9725, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.3.a', 'IM', 4.24, 35, 0.0972, 4.0381, 4.4331, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.3.b', 'IM', 3.63, 35, 0.2287, 3.1660, 4.0953, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.3.c', 'IM', 3.07, 35, 0.2936, 2.4687, 3.6622, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.4.a', 'IM', 3.85, 35, 0.1210, 3.6062, 4.0978, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.4.b', 'IM', 3.85, 35, 0.0819, 3.6817, 4.0147, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.4.c', 'IM', 4.05, 35, 0.0897, 3.8633, 4.2277, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.5.a', 'IM', 4.24, 35, 0.2005, 3.8315, 4.6466, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.5.b', 'IM', 4.30, 35, 0.2110, 3.8709, 4.7287, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.5.c', 'IM', 4.60, 35, 0.1909, 4.2162, 4.9921, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.6', 'IM', 3.85, 35, 0.3294, 3.1765, 4.5155, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.7.a', 'IM', 2.89, 35, 0.2377, 2.4089, 3.3750, 'N', '2023-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.7.b', 'IM', 4.32, 35, 0.2068, 3.9000, 4.7405, 'N', '2023-08-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.1.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.1.b', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.1.c', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.2.b', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.3.a', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.3.b', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.3.c', 'IM', 3.00, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.4.a', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.4.b', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.4.c', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.5.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.5.b', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.5.c', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.6', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.7.a', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.7.b', 'IM', 4.74, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.1.a', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.1.b', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.1.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.2.b', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.3.a', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.3.b', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.3.c', 'IM', 3.05, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.4.a', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.4.b', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.4.c', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.5.a', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.5.b', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.5.c', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.6', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.7.a', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.7.b', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.1.a', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.1.b', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.1.c', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.2.b', 'IM', 3.30, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.3.a', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.3.b', 'IM', 2.78, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.3.c', 'IM', 2.35, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.4.a', 'IM', 3.17, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.4.b', 'IM', 3.13, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.4.c', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.5.a', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.5.b', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.5.c', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.6', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.7.a', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.7.b', 'IM', 4.74, 23, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.1.a', 'IM', 4.00, 32, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.1.b', 'IM', 4.29, 31, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.1.c', 'IM', 4.23, 31, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.2.b', 'IM', 3.45, 31, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.3.a', 'IM', 4.19, 32, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.3.b', 'IM', 3.41, 32, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.3.c', 'IM', 2.50, 32, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.4.a', 'IM', 3.62, 32, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.4.b', 'IM', 3.72, 32, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.4.c', 'IM', 4.13, 30, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.5.a', 'IM', 4.19, 32, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.5.b', 'IM', 4.44, 32, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.5.c', 'IM', 4.56, 32, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.6', 'IM', 4.00, 32, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.7.a', 'IM', 3.62, 32, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.7.b', 'IM', 4.59, 32, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.1.a', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.1.b', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.1.c', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.2.b', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.3.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.3.b', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.3.c', 'IM', 2.52, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.4.a', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.4.b', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.4.c', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.5.a', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.5.b', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.5.c', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.6', 'IM', 3.57, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.7.a', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.7.b', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.1.a', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.1.b', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.1.c', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.2.b', 'IM', 3.08, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.3.a', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.3.b', 'IM', 2.96, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.3.c', 'IM', 2.48, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.4.a', 'IM', 3.48, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.4.b', 'IM', 3.36, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.4.c', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.5.a', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.5.b', 'IM', 4.68, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.5.c', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.6', 'IM', 3.60, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.7.a', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.7.b', 'IM', 4.68, 25, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.1.a', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.1.b', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.1.c', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.2.b', 'IM', 3.12, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.3.a', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.3.b', 'IM', 2.71, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.3.c', 'IM', 2.58, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.4.a', 'IM', 3.33, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.4.b', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.4.c', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.5.a', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.5.b', 'IM', 4.50, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.5.c', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.6', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.7.a', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.7.b', 'IM', 4.79, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.1.a', 'IM', 4.44, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.1.b', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.1.c', 'IM', 4.04, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.2.b', 'IM', 2.62, 26, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.3.a', 'IM', 3.41, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.3.b', 'IM', 2.26, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.3.c', 'IM', 2.22, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.4.a', 'IM', 3.22, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.4.b', 'IM', 3.07, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.4.c', 'IM', 3.22, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.5.a', 'IM', 3.42, 26, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.5.b', 'IM', 4.33, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.5.c', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.6', 'IM', 4.15, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.7.a', 'IM', 4.07, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.7.b', 'IM', 4.89, 27, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.1.a', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.1.b', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.1.c', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.2.b', 'IM', 3.67, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.3.a', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.3.b', 'IM', 3.12, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.3.c', 'IM', 3.33, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.4.a', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.4.b', 'IM', 3.83, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.4.c', 'IM', 3.83, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.5.a', 'IM', 4.42, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.5.b', 'IM', 4.83, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.5.c', 'IM', 4.79, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.6', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.7.a', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3022.00', '1.C.7.b', 'IM', 4.58, 24, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.1.a', 'IM', 4.38, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.1.b', 'IM', 4.35, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.1.c', 'IM', 4.54, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.2.b', 'IM', 4.04, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.3.a', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.3.b', 'IM', 3.77, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.3.c', 'IM', 3.27, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.4.a', 'IM', 4.04, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.4.b', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.4.c', 'IM', 4.31, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.5.a', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.5.b', 'IM', 4.38, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.5.c', 'IM', 4.65, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.6', 'IM', 4.08, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.7.a', 'IM', 3.62, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3032.00', '1.C.7.b', 'IM', 4.69, 26, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.1.a', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.1.b', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.1.c', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.2.b', 'IM', 3.28, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.3.a', 'IM', 4.36, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.3.b', 'IM', 4.92, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.3.c', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.4.a', 'IM', 4.84, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.4.b', 'IM', 4.72, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.4.c', 'IM', 4.36, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.5.a', 'IM', 4.76, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.5.b', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.5.c', 'IM', 4.88, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.6', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.7.a', 'IM', 2.88, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3033.00', '1.C.7.b', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.1.a', 'IM', 4.34, 19, 0.1781, 3.9686, 4.7169, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.1.b', 'IM', 4.72, 19, 0.1465, 4.4166, 5.0000, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.1.c', 'IM', 4.55, 19, 0.1929, 4.1437, 4.9542, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.2.b', 'IM', 4.17, 19, 0.1472, 3.8613, 4.4800, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.3.a', 'IM', 4.72, 19, 0.1725, 4.3578, 5.0000, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.3.b', 'IM', 4.56, 19, 0.1929, 4.1541, 4.9647, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.3.c', 'IM', 4.60, 19, 0.1906, 4.2011, 5.0000, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.4.a', 'IM', 4.72, 19, 0.1718, 4.3605, 5.0000, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.4.b', 'IM', 4.56, 19, 0.1927, 4.1509, 4.9608, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.4.c', 'IM', 4.56, 19, 0.1937, 4.1486, 4.9623, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.5.a', 'IM', 4.83, 19, 0.1469, 4.5254, 5.0000, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.5.b', 'IM', 4.51, 19, 0.1673, 4.1542, 4.8573, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.5.c', 'IM', 4.84, 19, 0.1474, 4.5254, 5.0000, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.6', 'IM', 4.33, 19, 0.3435, 3.6093, 5.0000, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.7.a', 'IM', 3.51, 18, 0.1856, 3.1143, 3.8973, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3034.00', '1.C.7.b', 'IM', 4.34, 19, 0.1489, 4.0251, 4.6508, 'N', '2019-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.1.a', 'IM', 4.44, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.1.b', 'IM', 4.36, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.1.c', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.2.b', 'IM', 3.16, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.3.a', 'IM', 4.28, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.3.b', 'IM', 4.76, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.3.c', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.4.a', 'IM', 4.52, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.4.b', 'IM', 4.28, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.4.c', 'IM', 4.36, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.5.a', 'IM', 4.56, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.5.b', 'IM', 4.68, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.5.c', 'IM', 4.76, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.6', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.7.a', 'IM', 2.88, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.02', '1.C.7.b', 'IM', 4.60, 25, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.1.a', 'IM', 4.58, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.1.b', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.1.c', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.2.b', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.3.a', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.3.b', 'IM', 4.96, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.3.c', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.4.a', 'IM', 4.50, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.4.b', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.4.c', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.5.a', 'IM', 4.58, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.5.b', 'IM', 4.83, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.5.c', 'IM', 4.88, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.6', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.7.a', 'IM', 2.65, 23, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3039.03', '1.C.7.b', 'IM', 4.92, 24, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.1.a', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.1.b', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.1.c', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.2.b', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.3.a', 'IM', 3.74, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.3.b', 'IM', 3.84, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.3.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.4.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.4.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.4.c', 'IM', 3.89, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.5.a', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.5.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.5.c', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.6', 'IM', 4.32, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.7.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3041.00', '1.C.7.b', 'IM', 4.85, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.1.a', 'IM', 4.16, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.1.b', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.1.c', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.2.b', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.3.a', 'IM', 4.56, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.3.b', 'IM', 4.24, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.3.c', 'IM', 3.76, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.4.a', 'IM', 4.36, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.4.b', 'IM', 4.24, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.4.c', 'IM', 4.16, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.5.a', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.5.b', 'IM', 4.28, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.5.c', 'IM', 4.84, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.6', 'IM', 3.40, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.7.a', 'IM', 3.52, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3051.00', '1.C.7.b', 'IM', 4.40, 25, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.1.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.1.b', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.1.c', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.2.b', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.3.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.3.b', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.3.c', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.4.a', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.4.b', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.4.c', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.5.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.5.b', 'IM', 4.70, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.5.c', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.6', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.7.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3091.00', '1.C.7.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, '2024-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.1.a', 'IM', 4.05, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.1.b', 'IM', 4.11, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.1.c', 'IM', 4.16, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.2.b', 'IM', 3.16, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.3.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.3.b', 'IM', 3.25, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.3.c', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.4.a', 'IM', 3.58, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.4.b', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.4.c', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.5.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.5.b', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.5.c', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.6', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.7.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3092.00', '1.C.7.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.1.a', 'IM', 3.26, 17, 0.3176, 2.5880, 3.9346, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.1.b', 'IM', 3.39, 17, 0.2782, 2.8023, 3.9819, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.1.c', 'IM', 3.92, 16, 0.1586, 3.5839, 4.2599, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.2.b', 'IM', 3.54, 17, 0.4161, 2.6541, 4.4181, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.3.a', 'IM', 4.49, 17, 0.1508, 4.1661, 4.8056, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.3.b', 'IM', 4.09, 17, 0.1737, 3.7212, 4.4579, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.3.c', 'IM', 3.91, 17, 0.3585, 3.1511, 4.6711, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.4.a', 'IM', 3.87, 16, 0.2366, 3.3634, 4.3719, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.4.b', 'IM', 3.18, 17, 0.2736, 2.5955, 3.7556, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.4.c', 'IM', 3.93, 17, 0.2289, 3.4429, 4.4135, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.5.a', 'IM', 4.08, 17, 0.1226, 3.8162, 4.3361, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.5.b', 'IM', 4.10, 17, 0.1680, 3.7486, 4.4609, 'N', '2015-07-01', 'Incumbent');
GO
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.5.c', 'IM', 4.53, 17, 0.1215, 4.2690, 4.7839, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.6', 'IM', 3.80, 17, 0.3732, 3.0127, 4.5950, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.7.a', 'IM', 3.49, 17, 0.2673, 2.9225, 4.0560, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3093.00', '1.C.7.b', 'IM', 3.53, 17, 0.3509, 2.7848, 4.2726, 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.1.a', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.1.b', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.1.c', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.2.b', 'IM', 3.15, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.3.a', 'IM', 3.31, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.3.b', 'IM', 2.96, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.3.c', 'IM', 2.69, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.4.a', 'IM', 3.62, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.4.b', 'IM', 3.73, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.4.c', 'IM', 3.54, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.5.a', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.5.b', 'IM', 4.35, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.5.c', 'IM', 4.35, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.6', 'IM', 4.27, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.7.a', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3094.00', '1.C.7.b', 'IM', 4.81, 26, NULL, NULL, NULL, NULL, '2022-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.1.a', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.1.b', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.1.c', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.2.b', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.3.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.3.b', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.3.c', 'IM', 3.20, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.4.a', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.4.b', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.4.c', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.5.a', 'IM', 4.16, 19, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.5.b', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.5.c', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.6', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.7.a', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3099.01', '1.C.7.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, '2023-08-01', 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4012.00', '1.C.1.a', 'IM', 4.02, 18, 0.1955, 3.6126, 4.4374, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4012.00', '1.C.1.b', 'IM', 4.00, 18, 0.1438, 3.6959, 4.3026, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4012.00', '1.C.1.c', 'IM', 3.84, 18, 0.1348, 3.5577, 4.1264, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4012.00', '1.C.2.b', 'IM', 3.60, 18, 0.2691, 3.0274, 4.1628, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4012.00', '1.C.3.a', 'IM', 4.29, 18, 0.1366, 4.0011, 4.5774, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4012.00', '1.C.3.b', 'IM', 3.53, 18, 0.2584, 2.9801, 4.0704, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-4012.00', '1.C.3.c', 'IM', 2.78, 18, 0.2385, 2.2745, 3.2808, 'N', '2024-08-01', 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, 