CREATE TABLE occupation_level_metadata (
  onetsoc_code CHARACTER(10) NOT NULL,
  item CHARACTER VARYING(150) NOT NULL,
  response CHARACTER VARYING(75),
  n DECIMAL(4,0),
  percent DECIMAL(4,1),
  date_updated DATE NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code));

INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Data Collection Mode', 'Paper', 95, 18.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Data Collection Mode', 'Web', 95, 81.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Employee Completeness Rate', NULL, NULL, 89.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Employee Response Rate', NULL, NULL, 56.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Establishment Eligibility Rate', NULL, NULL, 71.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Establishment Response Rate', NULL, NULL, 26.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '1-5 Years', 95, 36.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '10 Years or More', 95, 42.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '6-9 Years', 95, 12.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '<1 Year', 95, 6.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', 'Missing', 95, 2.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 95, 20.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 95, 11.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 95, 2.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 95, 30.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 95, 1.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 95, 29.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 95, 5.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Accommodation and food services', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 95, 3.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 95, 6.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Construction', 95, 20.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Education services', 95, 14.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Finance and insurance', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Health care and social assistance', 95, 4.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Information', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Manufacturing', 95, 11.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Mining', 95, 2.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Other services, except public administration', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 95, 1.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Public administration', 95, 30.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Real estate and rental and leasing', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Retail trade', 95, 1.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Transportation and warehousing', 95, 5.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Unclassified', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Utilities', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Wholesale trade', 95, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'SOC Eligibility Rate', NULL, NULL, 36.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Total Completed Questionnaires', NULL, 95, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'Data Collection Mode', 'Paper', 27, 37.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'Data Collection Mode', 'Web', 27, 63.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 27, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', '10+ Years', 27, 70.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 27, 3.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 27, 25.9, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', '<1 Year', 27, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', 'Missing', 27, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 27, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'OE Response Rate', NULL, NULL, 75.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'Total Completed Questionnaires', NULL, 27, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Data Collection Mode', 'Paper', 82, 36.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Data Collection Mode', 'Web', 82, 63.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Employee Completeness Rate', NULL, NULL, 84.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Employee Response Rate', NULL, NULL, 54.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Establishment Eligibility Rate', NULL, NULL, 71.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Establishment Response Rate', NULL, NULL, 33.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '1-5 Years', 82, 22.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '10 Years or More', 82, 62.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '6-9 Years', 82, 14.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '<1 Year', 82, 1.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', 'Missing', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 82, 40.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 82, 1.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 82, 13.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 82, 8.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 82, 3.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 82, 13.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 82, 18.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 82, 1.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Accommodation and food services', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 82, 6.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 82, 1.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Construction', 82, 41.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Education services', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Finance and insurance', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Health care and social assistance', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Information', 82, 2.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Manufacturing', 82, 11.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Mining', 82, 8.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Other services, except public administration', 82, 11.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Public administration', 82, 3.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Real estate and rental and leasing', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Retail trade', 82, 13.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Transportation and warehousing', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Unclassified', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Utilities', 82, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Wholesale trade', 82, 1.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'SOC Eligibility Rate', NULL, NULL, 40.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Total Completed Questionnaires', NULL, 82, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Data Collection Mode', 'Paper', 74, 55.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Data Collection Mode', 'Web', 74, 44.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Employee Completeness Rate', NULL, NULL, 91.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Employee Response Rate', NULL, NULL, 62.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Establishment Eligibility Rate', NULL, NULL, 86.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Establishment Response Rate', NULL, NULL, 48.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '1-5 Years', 74, 39.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '10 Years or More', 74, 32.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '6-9 Years', 74, 14.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '<1 Year', 74, 13.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', 'Missing', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 74, 2.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 74, 13.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 74, 60.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 74, 21.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 74, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Accommodation and food services', 74, 5.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 74, 2.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 74, 31.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Construction', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Education services', 74, 6.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Finance and insurance', 74, 2.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Health care and social assistance', 74, 8.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Information', 74, 28.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Manufacturing', 74, 8.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Mining', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Other services, except public administration', 74, 4.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 74, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Public administration', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Real estate and rental and leasing', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Retail trade', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Transportation and warehousing', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Unclassified', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Utilities', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Wholesale trade', 74, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'SOC Eligibility Rate', NULL, NULL, 17.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Total Completed Questionnaires', NULL, 74, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Data Collection Mode', 'Paper', 117, 43.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Data Collection Mode', 'Web', 117, 56.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Employee Completeness Rate', NULL, NULL, 86.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Employee Response Rate', NULL, NULL, 64.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Establishment Eligibility Rate', NULL, NULL, 87.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Establishment Response Rate', NULL, NULL, 57.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '1-5 Years', 117, 45.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '10 Years or More', 117, 28.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '6-9 Years', 117, 14.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '<1 Year', 117, 12.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', 'Missing', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 117, 3.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 117, 5.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 117, 40.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 117, 2.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 117, 32.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 117, 5.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 117, 11.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Accommodation and food services', 117, 7.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 117, 1.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 117, 2.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Construction', 117, 3.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Education services', 117, 5.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Finance and insurance', 117, 4.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Health care and social assistance', 117, 10.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Information', 117, 4.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Manufacturing', 117, 39.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Mining', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Other services, except public administration', 117, 0.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 117, 5.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Public administration', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Real estate and rental and leasing', 117, 1.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Retail trade', 117, 1.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Transportation and warehousing', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Unclassified', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Utilities', 117, 0.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Wholesale trade', 117, 11.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'SOC Eligibility Rate', NULL, NULL, 16.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Total Completed Questionnaires', NULL, 117, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Data Collection Mode', 'Paper', 23, 30.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Data Collection Mode', 'Web', 23, 69.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 4.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 87.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 4.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 4.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'OE Completeness Rate', NULL, NULL, 95.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'OE Response Rate', NULL, NULL, 55.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Data Collection Mode', 'Paper', 134, 52.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Data Collection Mode', 'Web', 134, 47.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Employee Completeness Rate', NULL, NULL, 83.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Employee Response Rate', NULL, NULL, 69.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Establishment Eligibility Rate', NULL, NULL, 88.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Establishment Response Rate', NULL, NULL, 51.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'How Long at Current Job', '1-5 Years', 134, 29.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'How Long at Current Job', '10 Years or More', 134, 46.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'How Long at Current Job', '6-9 Years', 134, 17.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'How Long at Current Job', '<1 Year', 134, 6.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'How Long at Current Job', 'Missing', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 134, 4.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 134, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 134, 22.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 134, 62.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 134, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Accommodation and food services', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 134, 0.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 134, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Construction', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Education services', 134, 26.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Finance and insurance', 134, 4.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Health care and social assistance', 134, 15.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Information', 134, 3.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Management of Companies and Enterprises', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Manufacturing', 134, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Mining', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Other services, except public administration', 134, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 134, 6.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Public administration', 134, 22.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Real estate and rental and leasing', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Retail trade', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Transportation and warehousing', 134, 1.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Unclassified', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Utilities', 134, 3.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'NAICS Sector', 'Wholesale trade', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'SOC Eligibility Rate', NULL, NULL, 39.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3012.00', 'Total Completed Questionnaires', NULL, 134, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Data Collection Mode', 'Paper', 76, 23.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Data Collection Mode', 'Web', 76, 76.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Employee Completeness Rate', NULL, NULL, 92.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Employee Response Rate', NULL, NULL, 61.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Establishment Eligibility Rate', NULL, NULL, 83.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Establishment Response Rate', NULL, NULL, 52.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '1-5 Years', 76, 38.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '10 Years or More', 76, 47.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '6-9 Years', 76, 13.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '<1 Year', 76, 1.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', 'Missing', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 76, 1.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 76, 9.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 76, 2.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 76, 15.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 76, 30.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 76, 32.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 76, 5.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 76, 2.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Accommodation and food services', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 76, 1.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Construction', 76, 9.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Education services', 76, 7.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Finance and insurance', 76, 2.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Health care and social assistance', 76, 14.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Information', 76, 6.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Manufacturing', 76, 14.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Mining', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Other services, except public administration', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 76, 10.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Public administration', 76, 30.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Real estate and rental and leasing', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Retail trade', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Transportation and warehousing', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Unclassified', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Utilities', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Wholesale trade', 76, 2.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'SOC Eligibility Rate', NULL, NULL, 12.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Total Completed Questionnaires', NULL, 76, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Data Collection Mode', 'Paper', 61, 41.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Data Collection Mode', 'Web', 61, 59.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Employee Completeness Rate', NULL, NULL, 78.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Employee Response Rate', NULL, NULL, 72.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Establishment Eligibility Rate', NULL, NULL, 75.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Establishment Response Rate', NULL, NULL, 39.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'How Long at Current Job', '1-5 Years', 61, 24.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'How Long at Current Job', '10 Years or More', 61, 50.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'How Long at Current Job', '6-9 Years', 61, 19.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'How Long at Current Job', '<1 Year', 61, 3.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'How Long at Current Job', 'Missing', 61, 1.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 61, 90.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 61, 9.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Accommodation and food services', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Construction', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Education services', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Finance and insurance', 61, 88.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Health care and social assistance', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Information', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 61, 1.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Manufacturing', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Mining', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Other services, except public administration', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 61, 9.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Public administration', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Real estate and rental and leasing', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Retail trade', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Transportation and warehousing', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Unclassified', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Utilities', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'NAICS Sector', 'Wholesale trade', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'SOC Eligibility Rate', NULL, NULL, 28.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.00', 'Total Completed Questionnaires', NULL, 61, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Data Collection Mode', 'Paper', 25, 16.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Data Collection Mode', 'Web', 25, 84.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 25, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 25, 96.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 25, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 25, 4.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 25, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 25, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 25, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'OE Completeness Rate', NULL, NULL, 96.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'OE Response Rate', NULL, NULL, 40.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Total Completed Questionnaires', NULL, 25, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Data Collection Mode', 'Paper', 81, 56.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Data Collection Mode', 'Web', 81, 43.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Employee Completeness Rate', NULL, NULL, 95.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Employee Response Rate', NULL, NULL, 66.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Establishment Eligibility Rate', NULL, NULL, 78.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Establishment Response Rate', NULL, NULL, 46.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'How Long at Current Job', '1-5 Years', 81, 25.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'How Long at Current Job', '10 Years or More', 81, 46.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'How Long at Current Job', '6-9 Years', 81, 22.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'How Long at Current Job', '<1 Year', 81, 3.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'How Long at Current Job', 'Missing', 81, 1.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 81, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Accommodation and food services', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Arts, entertainment, and recreation', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Construction', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Education services', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Finance and insurance', 81, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Health care and social assistance', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Information', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Management of Companies and Enterprises', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Manufacturing', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Mining', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Other services, except public administration', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Professional, Scientific and Technical Services', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Public administration', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Real estate and rental and leasing', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Retail trade', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Transportation and warehousing', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Unclassified', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Utilities', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'NAICS Sector', 'Wholesale trade', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'SOC Eligibility Rate', NULL, NULL, 13.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.03', 'Total Completed Questionnaires', NULL, 81, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Data Collection Mode', 'Paper', 116, 44.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Data Collection Mode', 'Web', 116, 56.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Employee Completeness Rate', NULL, NULL, 85.9, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Employee Response Rate', NULL, NULL, 59.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Establishment Eligibility Rate', NULL, NULL, 81.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Establishment Response Rate', NULL, NULL, 27.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '1-5 Years', 116, 29.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '10 Years or More', 116, 46.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '6-9 Years', 116, 12.9, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '<1 Year', 116, 8.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', 'Missing', 116, 2.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 116, 100.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Accommodation and food services', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Construction', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Education services', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Finance and insurance', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Health care and social assistance', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Information', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Management of Companies and Enterprises', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Manufacturing', 116, 100.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Mining', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Other services, except public administration', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Public administration', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Real estate and rental and leasing', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Retail trade', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Transportation and warehousing', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Unclassified', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Utilities', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Wholesale trade', 116, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'SOC Eligibility Rate', NULL, NULL, 46.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Total Completed Questionnaires', NULL, 116, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Data Collection Mode', 'Paper', 59, 44.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Data Collection Mode', 'Web', 59, 55.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Employee Completeness Rate', NULL, NULL, 95.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Employee Response Rate', NULL, NULL, 70.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Establishment Eligibility Rate', NULL, NULL, 76.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Establishment Response Rate', NULL, NULL, 42.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'How Long at Current Job', '1-5 Years', 59, 42.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'How Long at Current Job', '10 Years or More', 59, 30.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'How Long at Current Job', '6-9 Years', 59, 15.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'How Long at Current Job', '<1 Year', 59, 10.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'How Long at Current Job', 'Missing', 59, 1.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 59, 98.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 59, 1.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Accommodation and food services', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Construction', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Education services', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Finance and insurance', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Health care and social assistance', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Information', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Management of Companies and Enterprises', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Manufacturing', 59, 98.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Mining', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Other services, except public administration', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 59, 1.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Public administration', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Real estate and rental and leasing', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Retail trade', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Transportation and warehousing', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Unclassified', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Utilities', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Wholesale trade', 59, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'SOC Eligibility Rate', NULL, NULL, 41.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Total Completed Questionnaires', NULL, 59, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Data Collection Mode', 'Paper', 52, 50.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Data Collection Mode', 'Web', 52, 50.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Employee Completeness Rate', NULL, NULL, 94.5, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Employee Response Rate', NULL, NULL, 69.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Establishment Eligibility Rate', NULL, NULL, 51.5, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Establishment Response Rate', NULL, NULL, 94.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '1-5 Years', 52, 30.8, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '10 Years or More', 52, 40.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '6-9 Years', 52, 23.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '<1 Year', 52, 3.8, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', 'Missing', 52, 1.9, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 52, 9.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 52, 25.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 52, 65.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Accommodation and food services', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Construction', 52, 9.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Education services', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Finance and insurance', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Health care and social assistance', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Information', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Management of Companies and Enterprises', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Manufacturing', 52, 25.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Mining', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Other services, except public administration', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Public administration', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Real estate and rental and leasing', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Retail trade', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Transportation and warehousing', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Unclassified', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Utilities', 52, 65.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Wholesale trade', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'SOC Eligibility Rate', NULL, NULL, 84.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Total Completed Questionnaires', NULL, 52, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Data Collection Mode', 'Paper', 65, 73.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Data Collection Mode', 'Web', 65, 26.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Employee Completeness Rate', NULL, NULL, 98.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Employee Response Rate', NULL, NULL, 70.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Establishment Eligibility Rate', NULL, NULL, 79.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Establishment Response Rate', NULL, NULL, 77.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'How Long at Current Job', '1-5 Years', 65, 64.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'How Long at Current Job', '10 Years or More', 65, 6.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'How Long at Current Job', '6-9 Years', 65, 16.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'How Long at Current Job', '<1 Year', 65, 10.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'How Long at Current Job', 'Missing', 65, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 65, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Accommodation and food services', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 65, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 65, 3.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Arts, entertainment, and recreation', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Construction', 65, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Education services', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Finance and insurance', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Health care and social assistance', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Information', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Management of Companies and Enterprises', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Manufacturing', 65, 90.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Mining', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Other services, except public administration', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Professional, Scientific and Technical Services', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Public administration', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Real estate and rental and leasing', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Retail trade', 65, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Transportation and warehousing', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Unclassified', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Utilities', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Wholesale trade', 65, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'SOC Eligibility Rate', NULL, NULL, 20.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Total Completed Questionnaires', NULL, 65, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Data Collection Mode', 'Paper', 62, 41.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Data Collection Mode', 'Web', 62, 58.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Employee Completeness Rate', NULL, NULL, 96.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Employee Response Rate', NULL, NULL, 76.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Establishment Eligibility Rate', NULL, NULL, 93.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Establishment Response Rate', NULL, NULL, 93.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'How Long at Current Job', '1-5 Years', 62, 24.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'How Long at Current Job', '10 Years or More', 62, 54.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'How Long at Current Job', '6-9 Years', 62, 16.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'How Long at Current Job', '<1 Year', 62, 4.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'How Long at Current Job', 'Missing', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 62, 3.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 62, 21.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 62, 4.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 62, 1.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 62, 4.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 62, 64.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Accommodation and food services', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Arts, entertainment, and recreation', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Construction', 62, 3.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Education services', 62, 1.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Finance and insurance', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Health care and social assistance', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Information', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Management of Companies and Enterprises', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Manufacturing', 62, 21.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Mining', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Other services, except public administration', 62, 1.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', 62, 1.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Public administration', 62, 4.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Real estate and rental and leasing', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Retail trade', 62, 1.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Transportation and warehousing', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Unclassified', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Utilities', 62, 64.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Wholesale trade', 62, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'SOC Eligibility Rate', NULL, NULL, 76.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Total Completed Questionnaires', NULL, 62, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Data Collection Mode', 'Paper', 86, 64.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Data Collection Mode', 'Web', 86, 36.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Employee Completeness Rate', NULL, NULL, 92.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Employee Response Rate', NULL, NULL, 69.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Establishment Eligibility Rate', NULL, NULL, 85.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Establishment Response Rate', NULL, NULL, 83.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'How Long at Current Job', '1-5 Years', 86, 34.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'How Long at Current Job', '10 Years or More', 86, 39.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'How Long at Current Job', '6-9 Years', 86, 15.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'How Long at Current Job', '<1 Year', 86, 10.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'How Long at Current Job', 'Missing', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 86, 1.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 86, 22.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 86, 8.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 86, 68.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Accommodation and food services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Arts, entertainment, and recreation', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Construction', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Education services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Finance and insurance', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Health care and social assistance', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Information', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Management of Companies and Enterprises', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Manufacturing', 86, 1.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Mining', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Other services, except public administration', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Professional, Scientific and Technical Services', 86, 8.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Public administration', 86, 22.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Real estate and rental and leasing', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Retail trade', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Transportation and warehousing', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Unclassified', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Utilities', 86, 68.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Wholesale trade', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'SOC Eligibility Rate', NULL, NULL, 11.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Total Completed Questionnaires', NULL, 86, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Data Collection Mode', 'Paper', 19, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Data Collection Mode', 'Web', 19, 100.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 19, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 19, 78.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 19, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 19, 21.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 19, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 19, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 19, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'OE Completeness Rate', NULL, NULL, 95.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'OE Response Rate', NULL, NULL, 55.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Total Completed Questionnaires', NULL, 19, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.04', 'Data Collection Mode', 'Paper', 21, 38.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.04', 'Data Collection Mode', 'Web', 21, 61.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.04', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 4.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.04', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 90.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.04', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.04', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 4.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.04', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.04', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.04', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.04', 'OE Completeness Rate', NULL, NULL, 87.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.04', 'OE Response Rate', NULL, NULL, 60.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.04', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Data Collection Mode', 'Paper', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Data Collection Mode', 'Web', 21, 100.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 9.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 76.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 14.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'OE Response Rate', NULL, NULL, 41.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Data Collection Mode', 'Paper', 24, 41.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Data Collection Mode', 'Web', 24, 58.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 95.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 4.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'OE Completeness Rate', NULL, NULL, 88.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'OE Response Rate', NULL, NULL, 79.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Data Collection Mode', 'Paper', 27, 44.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Data Collection Mode', 'Web', 27, 55.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 27, 77.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 27, 18.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 27, 3.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'OE Completeness Rate', NULL, NULL, 84.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'OE Response Rate', NULL, NULL, 84.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Total Completed Questionnaires', NULL, 27, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Data Collection Mode', 'Paper', 20, 20.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Data Collection Mode', 'Web', 20, 80.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 100.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'OE Completeness Rate', NULL, NULL, 87.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'OE Response Rate', NULL, NULL, 74.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Data Collection Mode', 'Paper', 91, 67.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Data Collection Mode', 'Web', 91, 33.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Employee Completeness Rate', NULL, NULL, 93.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Employee Response Rate', NULL, NULL, 75.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Establishment Eligibility Rate', NULL, NULL, 80.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Establishment Response Rate', NULL, NULL, 61.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '1-5 Years', 91, 36.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '10 Years or More', 91, 40.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '6-9 Years', 91, 15.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '<1 Year', 91, 6.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', 'Missing', 91, 1.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 91, 100.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Accommodation and food services', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Construction', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Education services', 91, 2.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Finance and insurance', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Health care and social assistance', 91, 97.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Information', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Manufacturing', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Mining', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Other services, except public administration', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Public administration', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Real estate and rental and leasing', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Retail trade', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Transportation and warehousing', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Unclassified', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Utilities', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Wholesale trade', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'SOC Eligibility Rate', NULL, NULL, 68.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Total Completed Questionnaires', NULL, 91, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Data Collection Mode', 'Paper', 105, 63.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Data Collection Mode', 'Web', 105, 36.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Employee Completeness Rate', NULL, NULL, 94.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Employee Response Rate', NULL, NULL, 73.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Establishment Eligibility Rate', NULL, NULL, 90.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Establishment Response Rate', NULL, NULL, 67.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '1-5 Years', 105, 38.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '10 Years or More', 105, 28.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '6-9 Years', 105, 21.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '<1 Year', 105, 10.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', 'Missing', 105, 1.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 105, 100.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Accommodation and food services', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Construction', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Education services', 105, 100.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Finance and insurance', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Health care and social assistance', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Information', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Management of Companies and Enterprises', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Manufacturing', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Mining', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Other services, except public administration', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Public administration', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Real estate and rental and leasing', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Retail trade', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Transportation and warehousing', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Unclassified', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Utilities', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Wholesale trade', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'SOC Eligibility Rate', NULL, NULL, 58.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Total Completed Questionnaires', NULL, 105, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Data Collection Mode', 'Paper', 114, 49.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Data Collection Mode', 'Web', 114, 50.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Employee Completeness Rate', NULL, NULL, 90.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Employee Response Rate', NULL, NULL, 67.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Establishment Eligibility Rate', NULL, NULL, 82.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Establishment Response Rate', NULL, NULL, 57.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '1-5 Years', 114, 41.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '10 Years or More', 114, 34.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '6-9 Years', 114, 12.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '<1 Year', 114, 10.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', 'Missing', 114, 1.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 114, 100.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Accommodation and food services', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Construction', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Education services', 114, 100.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Finance and insurance', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Health care and social assistance', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Information', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Management of Companies and Enterprises', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Manufacturing', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Mining', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Other services, except public administration', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Public administration', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Real estate and rental and leasing', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Retail trade', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Transportation and warehousing', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Unclassified', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Utilities', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Wholesale trade', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'SOC Eligibility Rate', NULL, NULL, 66.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Total Completed Questionnaires', NULL, 114, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Data Collection Mode', 'Paper', 60, 51.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Data Collection Mode', 'Web', 60, 48.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Employee Completeness Rate', NULL, NULL, 89.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Employee Response Rate', NULL, NULL, 58.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Establishment Eligibility Rate', NULL, NULL, 79.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Establishment Response Rate', NULL, NULL, 43.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '1-5 Years', 60, 21.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '10 Years or More', 60, 53.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '6-9 Years', 60, 20.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '<1 Year', 60, 5.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', 'Missing', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 60, 68.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 60, 8.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 60, 8.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 60, 15.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Accommodation and food services', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Construction', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Education services', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Finance and insurance', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Health care and social assistance', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Information', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Management of Companies and Enterprises', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Manufacturing', 60, 68.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Mining', 60, 8.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Other services, except public administration', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 60, 15.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Public administration', 60, 8.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Real estate and rental and leasing', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Retail trade', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Transportation and warehousing', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Unclassified', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Utilities', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Wholesale trade', 60, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'SOC Eligibility Rate', NULL, NULL, 18.4, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Total Completed Questionnaires', NULL, 60, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Data Collection Mode', 'Paper', 100, 36.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Data Collection Mode', 'Web', 100, 64.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Employee Completeness Rate', NULL, NULL, 93.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Employee Response Rate', NULL, NULL, 80.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Establishment Eligibility Rate', NULL, NULL, 81.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Establishment Response Rate', NULL, NULL, 85.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'How Long at Current Job', '1-5 Years', 100, 52.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'How Long at Current Job', '10 Years or More', 100, 15.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'How Long at Current Job', '6-9 Years', 100, 18.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'How Long at Current Job', '<1 Year', 100, 15.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'How Long at Current Job', 'Missing', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 100, 4.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 100, 78.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 100, 3.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 100, 12.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 100, 3.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Accommodation and food services', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Construction', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Education services', 100, 1.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Finance and insurance', 100, 4.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Health care and social assistance', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Information', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Management of Companies and Enterprises', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Manufacturing', 100, 77.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Mining', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Other services, except public administration', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 100, 11.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Public administration', 100, 3.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Real estate and rental and leasing', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Retail trade', 100, 1.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Transportation and warehousing', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Unclassified', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Utilities', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Wholesale trade', 100, 3.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'SOC Eligibility Rate', NULL, NULL, 11.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Total Completed Questionnaires', NULL, 100, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Data Collection Mode', 'Paper', 91, 79.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Data Collection Mode', 'Web', 91, 20.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Employee Completeness Rate', NULL, NULL, 92.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Employee Response Rate', NULL, NULL, 62.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Establishment Eligibility Rate', NULL, NULL, 95.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Establishment Response Rate', NULL, NULL, 39.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '1-5 Years', 91, 36.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '10 Years or More', 91, 37.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '6-9 Years', 91, 15.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '<1 Year', 91, 11.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', 'Missing', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 91, 1.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 91, 52.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 91, 46.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Accommodation and food services', 91, 49.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 91, 11.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Construction', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Education services', 91, 9.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Finance and insurance', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Health care and social assistance', 91, 25.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Information', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Management of Companies and Enterprises', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Manufacturing', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Mining', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Other services, except public administration', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Public administration', 91, 1.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Real estate and rental and leasing', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Retail trade', 91, 3.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Transportation and warehousing', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Unclassified', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Utilities', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Wholesale trade', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'SOC Eligibility Rate', NULL, NULL, 49.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Total Completed Questionnaires', NULL, 91, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Data Collection Mode', 'Paper', 76, 30.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Data Collection Mode', 'Web', 76, 69.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Employee Completeness Rate', NULL, NULL, 88.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Employee Response Rate', NULL, NULL, 54.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Establishment Eligibility Rate', NULL, NULL, 75.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Establishment Response Rate', NULL, NULL, 38.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '1-5 Years', 76, 28.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '10 Years or More', 76, 51.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '6-9 Years', 76, 9.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '<1 Year', 76, 6.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', 'Missing', 76, 3.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 76, 1.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 76, 98.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Accommodation and food services', 76, 64.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 76, 34.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Construction', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Education services', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Finance and insurance', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Health care and social assistance', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Information', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Management of Companies and Enterprises', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Manufacturing', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Mining', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Other services, except public administration', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Public administration', 76, 1.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Real estate and rental and leasing', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Retail trade', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Transportation and warehousing', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Unclassified', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Utilities', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Wholesale trade', 76, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'SOC Eligibility Rate', NULL, NULL, 35.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Total Completed Questionnaires', NULL, 76, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Data Collection Mode', 'Paper', 49, 53.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Data Collection Mode', 'Web', 49, 46.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Employee Completeness Rate', NULL, NULL, 90.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Employee Response Rate', NULL, NULL, 54.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Establishment Eligibility Rate', NULL, NULL, 94.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Establishment Response Rate', NULL, NULL, 42.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '1-5 Years', 49, 55.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '10 Years or More', 49, 18.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '6-9 Years', 49, 14.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '<1 Year', 49, 10.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', 'Missing', 49, 2.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 49, 100.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Accommodation and food services', 49, 100.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Construction', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Education services', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Finance and insurance', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Health care and social assistance', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Information', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Management of Companies and Enterprises', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Manufacturing', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Mining', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Other services, except public administration', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Public administration', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Real estate and rental and leasing', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Retail trade', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Transportation and warehousing', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Unclassified', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Utilities', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Wholesale trade', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'SOC Eligibility Rate', NULL, NULL, 69.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Total Completed Questionnaires', NULL, 49, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Data Collection Mode', 'Paper', 28, 39.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Data Collection Mode', 'Web', 28, 60.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 28, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 28, 82.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 28, 7.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 28, 10.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 28, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 28, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 28, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'OE Completeness Rate', NULL, NULL, 87.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'OE Response Rate', NULL, NULL, 71.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Total Completed Questionnaires', NULL, 28, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Data Collection Mode', 'Paper', 71, 33.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Data Collection Mode', 'Web', 71, 66.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Employee Completeness Rate', NULL, NULL, 94.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Employee Response Rate', NULL, NULL, 75.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Establishment Eligibility Rate', NULL, NULL, 74.9, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Establishment Response Rate', NULL, NULL, 50.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '1-5 Years', 71, 31.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '10 Years or More', 71, 35.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '6-9 Years', 71, 25.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '<1 Year', 71, 7.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', 'Missing', 71, 1.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 71, 19.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 71, 52.1, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 71, 28.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Accommodation and food services', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Construction', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Education services', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Finance and insurance', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Health care and social assistance', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Information', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Management of Companies and Enterprises', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Manufacturing', 71, 19.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Mining', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Other services, except public administration', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 71, 28.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Public administration', 71, 52.1, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Real estate and rental and leasing', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Retail trade', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Transportation and warehousing', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Unclassified', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Utilities', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Wholesale trade', 71, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'SOC Eligibility Rate', NULL, NULL, 9.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Total Completed Questionnaires', NULL, 71, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Data Collection Mode', 'Paper', 53, 56.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Data Collection Mode', 'Web', 53, 43.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Employee Completeness Rate', NULL, NULL, 91.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Employee Response Rate', NULL, NULL, 76.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Establishment Eligibility Rate', NULL, NULL, 78.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Establishment Response Rate', NULL, NULL, 54.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '1-5 Years', 53, 34.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '10 Years or More', 53, 24.5, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '6-9 Years', 53, 17.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '<1 Year', 53, 24.5, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', 'Missing', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 53, 13.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 53, 86.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Accommodation and food services', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Construction', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Education services', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Finance and insurance', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Health care and social assistance', 53, 17.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Information', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Management of Companies and Enterprises', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Manufacturing', 53, 13.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Mining', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Other services, except public administration', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 53, 69.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Public administration', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Real estate and rental and leasing', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Retail trade', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Transportation and warehousing', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Unclassified', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Utilities', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Wholesale trade', 53, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'SOC Eligibility Rate', NULL, NULL, 5.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Total Completed Questionnaires', NULL, 53, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'Data Collection Mode', 'Paper', 22, 27.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'Data Collection Mode', 'Web', 22, 72.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 95.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 4.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'OE Completeness Rate', NULL, NULL, 95.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'OE Response Rate', NULL, NULL, 65.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Data Collection Mode', 'Paper', 86, 72.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Data Collection Mode', 'Web', 86, 27.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Employee Completeness Rate', NULL, NULL, 86.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Employee Response Rate', NULL, NULL, 47.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Establishment Eligibility Rate', NULL, NULL, 96.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Establishment Response Rate', NULL, NULL, 91.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '1-5 Years', 86, 25.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '10 Years or More', 86, 37.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '6-9 Years', 86, 22.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '<1 Year', 86, 12.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', 'Missing', 86, 2.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 86, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Accommodation and food services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Construction', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Education services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Finance and insurance', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Health care and social assistance', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Information', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Management of Companies and Enterprises', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Manufacturing', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Mining', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Other services, except public administration', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Public administration', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Real estate and rental and leasing', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Retail trade', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Transportation and warehousing', 86, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Unclassified', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Utilities', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Wholesale trade', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'SOC Eligibility Rate', NULL, NULL, 94.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Total Completed Questionnaires', NULL, 86, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Data Collection Mode', 'Paper', 20, 35.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Data Collection Mode', 'Web', 20, 65.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 95.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 5.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'OE Response Rate', NULL, NULL, 52.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Data Collection Mode', 'Paper', 72, 50.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Data Collection Mode', 'Web', 72, 50.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Employee Completeness Rate', NULL, NULL, 90.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Employee Response Rate', NULL, NULL, 69.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Establishment Eligibility Rate', NULL, NULL, 84.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Establishment Response Rate', NULL, NULL, 72.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '1-5 Years', 72, 38.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '10 Years or More', 72, 38.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '6-9 Years', 72, 15.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '<1 Year', 72, 5.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', 'Missing', 72, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 72, 19.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 72, 80.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Accommodation and food services', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Construction', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Education services', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Finance and insurance', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Health care and social assistance', 72, 70.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Information', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Management of Companies and Enterprises', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Manufacturing', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Mining', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Other services, except public administration', 72, 9.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Public administration', 72, 19.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Real estate and rental and leasing', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Retail trade', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Transportation and warehousing', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Unclassified', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Utilities', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Wholesale trade', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'SOC Eligibility Rate', NULL, NULL, 23.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Total Completed Questionnaires', NULL, 72, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Data Collection Mode', 'Paper', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Data Collection Mode', 'Web', 22, 100.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 81.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 18.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'OE Completeness Rate', NULL, NULL, 95.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'OE Response Rate', NULL, NULL, 51.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Data Collection Mode', 'Paper', 56, 67.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Data Collection Mode', 'Web', 56, 32.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Employee Completeness Rate', NULL, NULL, 93.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Employee Response Rate', NULL, NULL, 83.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Establishment Eligibility Rate', NULL, NULL, 87.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Establishment Response Rate', NULL, NULL, 68.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'How Long at Current Job', '1-5 Years', 56, 23.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'How Long at Current Job', '10 Years or More', 56, 69.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'How Long at Current Job', '6-9 Years', 56, 7.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'How Long at Current Job', '<1 Year', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'How Long at Current Job', 'Missing', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 56, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Accommodation and food services', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Construction', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Education services', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Finance and insurance', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Health care and social assistance', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Information', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Management of Companies and Enterprises', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Manufacturing', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Mining', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Other services, except public administration', 56, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Public administration', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Real estate and rental and leasing', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Retail trade', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Transportation and warehousing', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Unclassified', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Utilities', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'NAICS Sector', 'Wholesale trade', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'SOC Eligibility Rate', NULL, NULL, 50.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9171.00', 'Total Completed Questionnaires', NULL, 56, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.01', 'Data Collection Mode', 'Paper', 26, 11.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.01', 'Data Collection Mode', 'Web', 26, 88.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 26, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 26, 46.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 26, 7.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 26, 46.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 26, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 26, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 26, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.01', 'OE Completeness Rate', NULL, NULL, 89.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.01', 'OE Response Rate', NULL, NULL, 82.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.01', 'Total Completed Questionnaires', NULL, 26, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Data Collection Mode', 'Paper', 59, 71.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Data Collection Mode', 'Web', 59, 28.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Employee Completeness Rate', NULL, NULL, 96.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Employee Response Rate', NULL, NULL, 84.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Establishment Eligibility Rate', NULL, NULL, 78.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Establishment Response Rate', NULL, NULL, 69.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'How Long at Current Job', '1-5 Years', 59, 47.5, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'How Long at Current Job', '10 Years or More', 59, 22.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'How Long at Current Job', '6-9 Years', 59, 22.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'How Long at Current Job', '<1 Year', 59, 8.5, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'How Long at Current Job', 'Missing', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 59, 100.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Accommodation and food services', 59, 6.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 59, 5.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 59, 39.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Construction', 59, 1.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Education services', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Finance and insurance', 59, 8.5, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Health care and social assistance', 59, 1.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Information', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Management of Companies and Enterprises', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Manufacturing', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Mining', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Other services, except public administration', 59, 16.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 59, 5.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Public administration', 59, 3.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Real estate and rental and leasing', 59, 3.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Retail trade', 59, 5.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Transportation and warehousing', 59, 3.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Unclassified', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Utilities', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'NAICS Sector', 'Wholesale trade', 59, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'SOC Eligibility Rate', NULL, NULL, 38.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9179.02', 'Total Completed Questionnaires', NULL, 59, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Data Collection Mode', 'Paper', 28, 17.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Data Collection Mode', 'Web', 28, 82.1, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 28, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 28, 82.1, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 28, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 28, 17.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 28, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 28, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 28, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'OE Completeness Rate', NULL, NULL, 96.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'OE Response Rate', NULL, NULL, 61.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Total Completed Questionnaires', NULL, 28, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Data Collection Mode', 'Paper', 77, 42.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Data Collection Mode', 'Web', 77, 57.1, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Employee Completeness Rate', NULL, NULL, 90.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Employee Response Rate', NULL, NULL, 67.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Establishment Eligibility Rate', NULL, NULL, 82.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Establishment Response Rate', NULL, NULL, 46.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'How Long at Current Job', '1-5 Years', 77, 26.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'How Long at Current Job', '10 Years or More', 77, 45.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'How Long at Current Job', '6-9 Years', 77, 22.1, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'How Long at Current Job', '<1 Year', 77, 6.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'How Long at Current Job', 'Missing', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 77, 10.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 77, 18.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 77, 19.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 77, 36.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 77, 9.1, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 77, 2.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Accommodation and food services', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 77, 2.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Construction', 77, 10.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Education services', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Finance and insurance', 77, 18.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Health care and social assistance', 77, 6.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Information', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Management of Companies and Enterprises', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Manufacturing', 77, 18.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Mining', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Other services, except public administration', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Public administration', 77, 36.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Real estate and rental and leasing', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Retail trade', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Transportation and warehousing', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Unclassified', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Utilities', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Wholesale trade', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'SOC Eligibility Rate', NULL, NULL, 14.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Total Completed Questionnaires', NULL, 77, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'Data Collection Mode', 'Paper', 22, 4.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'Data Collection Mode', 'Web', 22, 95.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 100.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'OE Response Rate', NULL, NULL, 44.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Data Collection Mode', 'Paper', 62, 46.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Data Collection Mode', 'Web', 62, 53.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Employee Completeness Rate', NULL, NULL, 100.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Employee Response Rate', NULL, NULL, 66.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Establishment Eligibility Rate', NULL, NULL, 88.9, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Establishment Response Rate', NULL, NULL, 61.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'How Long at Current Job', '1-5 Years', 62, 37.1, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'How Long at Current Job', '10 Years or More', 62, 27.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'How Long at Current Job', '6-9 Years', 62, 32.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'How Long at Current Job', '<1 Year', 62, 1.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'How Long at Current Job', 'Missing', 62, 1.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 62, 6.5, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 62, 3.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 62, 8.1, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 62, 8.1, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 62, 72.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 62, 1.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Accommodation and food services', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 62, 1.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 62, 6.5, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Arts, entertainment, and recreation', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Construction', 62, 3.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Education services', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Finance and insurance', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Health care and social assistance', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Information', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Management of Companies and Enterprises', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Manufacturing', 62, 4.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Mining', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Other services, except public administration', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Professional, Scientific and Technical Services', 62, 6.5, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Public administration', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Real estate and rental and leasing', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Retail trade', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Transportation and warehousing', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Unclassified', 62, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Utilities', 62, 75.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Wholesale trade', 62, 1.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'SOC Eligibility Rate', NULL, NULL, 55.1, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Total Completed Questionnaires', NULL, 62, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Data Collection Mode', 'Paper', 53, 54.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Data Collection Mode', 'Web', 53, 45.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Employee Completeness Rate', NULL, NULL, 98.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Employee Response Rate', NULL, NULL, 62.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Establishment Eligibility Rate', NULL, NULL, 86.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Establishment Response Rate', NULL, NULL, 79.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'How Long at Current Job', '1-5 Years', 53, 64.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'How Long at Current Job', '10 Years or More', 53, 13.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'How Long at Current Job', '6-9 Years', 53, 13.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'How Long at Current Job', '<1 Year', 53, 7.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'How Long at Current Job', 'Missing', 53, 1.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 53, 7.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 53, 1.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 53, 7.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 53, 1.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 53, 81.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Accommodation and food services', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Arts, entertainment, and recreation', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Construction', 53, 7.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Education services', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Finance and insurance', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Health care and social assistance', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Information', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Management of Companies and Enterprises', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Manufacturing', 53, 1.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Mining', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Other services, except public administration', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Professional, Scientific and Technical Services', 53, 1.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Public administration', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Real estate and rental and leasing', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Retail trade', 53, 7.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Transportation and warehousing', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Unclassified', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Utilities', 53, 81.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Wholesale trade', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'SOC Eligibility Rate', NULL, NULL, 3.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Total Completed Questionnaires', NULL, 53, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'Data Collection Mode', 'Paper', 22, 31.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'Data Collection Mode', 'Web', 22, 68.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 86.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 13.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'OE Completeness Rate', NULL, NULL, 91.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'OE Response Rate', NULL, NULL, 72.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Data Collection Mode', 'Paper', 64, 51.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Data Collection Mode', 'Web', 64, 48.4, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Employee Completeness Rate', NULL, NULL, 86.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Employee Response Rate', NULL, NULL, 54.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Establishment Eligibility Rate', NULL, NULL, 57.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Establishment Response Rate', NULL, NULL, 56.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '1-5 Years', 64, 14.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '10 Years or More', 64, 54.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '6-9 Years', 64, 20.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '<1 Year', 64, 9.4, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', 'Missing', 64, 1.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 64, 100.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Accommodation and food services', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 64, 100.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Construction', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Education services', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Finance and insurance', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Health care and social assistance', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Information', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Manufacturing', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Mining', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Other services, except public administration', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Public administration', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Real estate and rental and leasing', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Retail trade', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Transportation and warehousing', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Unclassified', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Utilities', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'NAICS Sector', 'Wholesale trade', 64, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'SOC Eligibility Rate', NULL, NULL, 24.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Total Completed Questionnaires', NULL, 64, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Data Collection Mode', 'Paper', 71, 67.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Data Collection Mode', 'Web', 71, 32.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Employee Completeness Rate', NULL, NULL, 94.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Employee Response Rate', NULL, NULL, 70.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Establishment Eligibility Rate', NULL, NULL, 85.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Establishment Response Rate', NULL, NULL, 85.9, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '1-5 Years', 71, 28.2, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '10 Years or More', 71, 39.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '6-9 Years', 71, 19.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '<1 Year', 71, 12.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', 'Missing', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 71, 22.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 71, 77.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Accommodation and food services', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Construction', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Education services', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Finance and insurance', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Health care and social assistance', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Information', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Manufacturing', 71, 22.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Mining', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Other services, except public administration', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Public administration', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Real estate and rental and leasing', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Retail trade', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Transportation and warehousing', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Unclassified', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Utilities', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Wholesale trade', 71, 77.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'SOC Eligibility Rate', NULL, NULL, 15.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Total Completed Questionnaires', NULL, 71, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Data Collection Mode', 'Paper', 82, 74.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Data Collection Mode', 'Web', 82, 25.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Employee Completeness Rate', NULL, NULL, 92.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Employee Response Rate', NULL, NULL, 66.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Establishment Eligibility Rate', NULL, NULL, 85.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Establishment Response Rate', NULL, NULL, 64.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '1-5 Years', 82, 24.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '10 Years or More', 82, 51.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '6-9 Years', 82, 15.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '<1 Year', 82, 6.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', 'Missing', 82, 2.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 82, 30.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 82, 69.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Accommodation and food services', 82, 3.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Construction', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Education services', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Finance and insurance', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Health care and social assistance', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Information', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Management of Companies and Enterprises', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Manufacturing', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Mining', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Other services, except public administration', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Public administration', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Real estate and rental and leasing', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Retail trade', 82, 26.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Transportation and warehousing', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Unclassified', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Utilities', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Wholesale trade', 82, 69.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'SOC Eligibility Rate', NULL, NULL, 11.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Total Completed Questionnaires', NULL, 82, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Data Collection Mode', 'Paper', 23, 21.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Data Collection Mode', 'Web', 23, 78.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 87.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 13.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'OE Completeness Rate', NULL, NULL, 88.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'OE Response Rate', NULL, NULL, 51.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Data Collection Mode', 'Paper', 125, 72.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Data Collection Mode', 'Web', 125, 27.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Employee Completeness Rate', NULL, NULL, 95.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Employee Response Rate', NULL, NULL, 67.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Establishment Eligibility Rate', NULL, NULL, 73.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Establishment Response Rate', NULL, NULL, 44.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'How Long at Current Job', '1-5 Years', 125, 26.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'How Long at Current Job', '10 Years or More', 125, 59.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'How Long at Current Job', '6-9 Years', 125, 8.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'How Long at Current Job', '<1 Year', 125, 4.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'How Long at Current Job', 'Missing', 125, 1.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 125, 100.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Accommodation and food services', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Construction', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Education services', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Finance and insurance', 125, 100.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Health care and social assistance', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Information', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Manufacturing', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Mining', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Other services, except public administration', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Public administration', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Real estate and rental and leasing', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Retail trade', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Transportation and warehousing', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Unclassified', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Utilities', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'NAICS Sector', 'Wholesale trade', 125, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'SOC Eligibility Rate', NULL, NULL, 12.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.00', 'Total Completed Questionnaires', NULL, 125, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Data Collection Mode', 'Paper', 57, 63.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Data Collection Mode', 'Web', 57, 36.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Employee Completeness Rate', NULL, NULL, 95.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Employee Response Rate', NULL, NULL, 63.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Establishment Eligibility Rate', NULL, NULL, 79.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Establishment Response Rate', NULL, NULL, 71.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '1-5 Years', 57, 21.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '10 Years or More', 57, 66.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '6-9 Years', 57, 8.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '<1 Year', 57, 3.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', 'Missing', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 57, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Accommodation and food services', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Construction', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Education services', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Finance and insurance', 57, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Health care and social assistance', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Information', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Management of Companies and Enterprises', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Manufacturing', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Mining', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Other services, except public administration', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Public administration', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Real estate and rental and leasing', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Retail trade', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Transportation and warehousing', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Unclassified', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Utilities', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Wholesale trade', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'SOC Eligibility Rate', NULL, NULL, 8.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Total Completed Questionnaires', NULL, 57, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Data Collection Mode', 'Paper', 20, 30.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Data Collection Mode', 'Web', 20, 70.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 95.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 5.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'OE Completeness Rate', NULL, NULL, 90.9, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'OE Response Rate', NULL, NULL, 68.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Data Collection Mode', 'Paper', 109, 61.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Data Collection Mode', 'Web', 109, 38.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Employee Completeness Rate', NULL, NULL, 90.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Employee Response Rate', NULL, NULL, 72.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Establishment Eligibility Rate', NULL, NULL, 90.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Establishment Response Rate', NULL, NULL, 87.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '1-5 Years', 109, 38.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '10 Years or More', 109, 43.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '6-9 Years', 109, 10.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '<1 Year', 109, 7.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', 'Missing', 109, 0.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 109, 42.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 109, 57.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Accommodation and food services', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Arts, entertainment, and recreation', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Construction', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Education services', 109, 56.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Finance and insurance', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Health care and social assistance', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Information', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Management of Companies and Enterprises', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Manufacturing', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Mining', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Other services, except public administration', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Professional, Scientific and Technical Services', 109, 0.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Public administration', 109, 42.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Real estate and rental and leasing', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Retail trade', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Transportation and warehousing', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Unclassified', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Utilities', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Wholesale trade', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'SOC Eligibility Rate', NULL, NULL, 33.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Total Completed Questionnaires', NULL, 109, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Data Collection Mode', 'Paper', 52, 53.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Data Collection Mode', 'Web', 52, 46.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Employee Completeness Rate', NULL, NULL, 81.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Employee Response Rate', NULL, NULL, 85.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Establishment Eligibility Rate', NULL, NULL, 93.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Establishment Response Rate', NULL, NULL, 87.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '1-5 Years', 52, 28.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '10 Years or More', 52, 34.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '6-9 Years', 52, 25.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '<1 Year', 52, 11.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', 'Missing', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 52, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Accommodation and food services', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Arts, entertainment, and recreation', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Construction', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Education services', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Finance and insurance', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Health care and social assistance', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Information', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Management of Companies and Enterprises', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Manufacturing', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Mining', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Other services, except public administration', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Public administration', 52, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Real estate and rental and leasing', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Retail trade', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Transportation and warehousing', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Unclassified', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Utilities', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Wholesale trade', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'SOC Eligibility Rate', NULL, NULL, 10.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Total Completed Questionnaires', NULL, 52, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Data Collection Mode', 'Paper', 20, 55.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Data Collection Mode', 'Web', 20, 45.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 70.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 30.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'OE Response Rate', NULL, NULL, 74.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Data Collection Mode', 'Paper', 20, 20.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Data Collection Mode', 'Web', 20, 80.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 50.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 5.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 45.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'OE Completeness Rate', NULL, NULL, 95.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'OE Response Rate', NULL, NULL, 51.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.08', 'Data Collection Mode', 'Paper', 20, 40.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.08', 'Data Collection Mode', 'Web', 20, 60.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.08', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.08', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 95.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.08', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 5.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.08', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.08', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.08', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.08', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.08', 'OE Completeness Rate', NULL, NULL, 95.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.08', 'OE Response Rate', NULL, NULL, 53.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.08', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Data Collection Mode', 'Paper', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Data Collection Mode', 'Web', 22, 100.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 90.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 9.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'OE Completeness Rate', NULL, NULL, 91.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'OE Response Rate', NULL, NULL, 63.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Data Collection Mode', 'Paper', 125, 52.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Data Collection Mode', 'Web', 125, 47.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Employee Completeness Rate', NULL, NULL, 87.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Employee Response Rate', NULL, NULL, 74.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Establishment Eligibility Rate', NULL, NULL, 79.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Establishment Response Rate', NULL, NULL, 46.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'How Long at Current Job', '1-5 Years', 125, 36.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'How Long at Current Job', '10 Years or More', 125, 36.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'How Long at Current Job', '6-9 Years', 125, 18.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'How Long at Current Job', '<1 Year', 125, 8.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'How Long at Current Job', 'Missing', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 125, 8.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 125, 2.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 125, 5.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 125, 1.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 125, 53.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 125, 0.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 125, 22.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 125, 1.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 125, 3.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Accommodation and food services', 125, 4.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 125, 8.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 125, 1.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Construction', 125, 8.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Education services', 125, 5.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Finance and insurance', 125, 0.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Health care and social assistance', 125, 2.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Information', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Management of Companies and Enterprises', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Manufacturing', 125, 5.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Mining', 125, 1.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Other services, except public administration', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Public administration', 125, 53.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Real estate and rental and leasing', 125, 1.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Retail trade', 125, 0.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Transportation and warehousing', 125, 0.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Unclassified', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Utilities', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Wholesale trade', 125, 3.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'SOC Eligibility Rate', NULL, NULL, 20.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Total Completed Questionnaires', NULL, 125, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Data Collection Mode', 'Paper', 57, 87.7, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Data Collection Mode', 'Web', 57, 12.3, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Employee Completeness Rate', NULL, NULL, 75.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Employee Response Rate', NULL, NULL, 59.8, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Establishment Eligibility Rate', NULL, NULL, 72.6, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Establishment Response Rate', NULL, NULL, 73.1, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '1-5 Years', 57, 15.8, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '10 Years or More', 57, 70.2, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '6-9 Years', 57, 10.5, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '<1 Year', 57, 3.5, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', 'Missing', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 57, 98.2, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 57, 1.8, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'SOC Eligibility Rate', NULL, NULL, 12.9, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Total Completed Questionnaires', NULL, 57, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'Data Collection Mode', 'Paper', 21, 14.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'Data Collection Mode', 'Web', 21, 85.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 81.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 19.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'OE Completeness Rate', NULL, NULL, 80.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'OE Response Rate', NULL, NULL, 37.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Data Collection Mode', 'Paper', 24, 41.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Data Collection Mode', 'Web', 24, 58.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 91.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 8.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'OE Completeness Rate', NULL, NULL, 92.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'OE Response Rate', NULL, NULL, 53.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Data Collection Mode', 'Paper', 20, 35.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Data Collection Mode', 'Web', 20, 65.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 90.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 10.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'OE Completeness Rate', NULL, NULL, 83.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'OE Response Rate', NULL, NULL, 80.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Data Collection Mode', 'Paper', 22, 22.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Data Collection Mode', 'Web', 22, 77.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 95.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 4.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'OE Completeness Rate', NULL, NULL, 81.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'OE Response Rate', NULL, NULL, 34.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Data Collection Mode', 'Paper', 21, 19.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Data Collection Mode', 'Web', 21, 81.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 4.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 85.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 4.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 4.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'OE Completeness Rate', NULL, NULL, 91.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'OE Response Rate', NULL, NULL, 57.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Data Collection Mode', 'Paper', 66, 59.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Data Collection Mode', 'Web', 66, 40.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Employee Completeness Rate', NULL, NULL, 86.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Employee Response Rate', NULL, NULL, 62.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Establishment Eligibility Rate', NULL, NULL, 89.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Establishment Response Rate', NULL, NULL, 50.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '1-5 Years', 66, 40.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '10 Years or More', 66, 22.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '6-9 Years', 66, 22.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '<1 Year', 66, 13.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', 'Missing', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 66, 4.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 66, 95.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Accommodation and food services', 66, 51.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 66, 3.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Construction', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Education services', 66, 34.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Finance and insurance', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Health care and social assistance', 66, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Information', 66, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Management of Companies and Enterprises', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Manufacturing', 66, 3.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Mining', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Other services, except public administration', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 66, 4.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Public administration', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Real estate and rental and leasing', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Retail trade', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Transportation and warehousing', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Unclassified', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Utilities', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Wholesale trade', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'SOC Eligibility Rate', NULL, NULL, 29.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Total Completed Questionnaires', NULL, 66, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'Data Collection Mode', 'Paper', 21, 33.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'Data Collection Mode', 'Web', 21, 66.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 81.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 14.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 4.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'OE Completeness Rate', NULL, NULL, 87.5, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'OE Response Rate', NULL, NULL, 49.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Data Collection Mode', 'Paper', 24, 29.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Data Collection Mode', 'Web', 24, 70.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 75.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 25.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'OE Completeness Rate', NULL, NULL, 88.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'OE Response Rate', NULL, NULL, 39.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Data Collection Mode', 'Paper', 23, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Data Collection Mode', 'Web', 23, 100.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 82.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 17.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'OE Response Rate', NULL, NULL, 62.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Data Collection Mode', 'Paper', 23, 34.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Data Collection Mode', 'Web', 23, 65.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 87.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 13.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'OE Completeness Rate', NULL, NULL, 95.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'OE Response Rate', NULL, NULL, 72.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.01', 'Data Collection Mode', 'Paper', 23, 34.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.01', 'Data Collection Mode', 'Web', 23, 65.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 73.9, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 4.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 21.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.01', 'OE Completeness Rate', NULL, NULL, 92.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.01', 'OE Response Rate', NULL, NULL, 58.1, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.01', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Data Collection Mode', 'Paper', 22, 22.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Data Collection Mode', 'Web', 22, 77.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 4.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 95.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'OE Completeness Rate', NULL, NULL, 91.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'OE Response Rate', NULL, NULL, 57.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'Data Collection Mode', 'Paper', 23, 8.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'Data Collection Mode', 'Web', 23, 91.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 60.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 8.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 30.4, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'OE Completeness Rate', NULL, NULL, 92.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'OE Response Rate', NULL, NULL, 75.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Data Collection Mode', 'Paper', 75, 42.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Data Collection Mode', 'Web', 75, 57.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Employee Completeness Rate', NULL, NULL, 84.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Employee Response Rate', NULL, NULL, 65.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Establishment Eligibility Rate', NULL, NULL, 80.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Establishment Response Rate', NULL, NULL, 56.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'How Long at Current Job', '1-5 Years', 75, 44.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'How Long at Current Job', '10 Years or More', 75, 26.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'How Long at Current Job', '6-9 Years', 75, 20.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'How Long at Current Job', '<1 Year', 75, 9.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'How Long at Current Job', 'Missing', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 75, 4.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 75, 84.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 75, 8.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 75, 4.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Accommodation and food services', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 75, 5.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Arts, entertainment, and recreation', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Construction', 75, 4.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Education services', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Finance and insurance', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Health care and social assistance', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Information', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Management of Companies and Enterprises', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Manufacturing', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Mining', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Other services, except public administration', 75, 2.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Professional, Scientific and Technical Services', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Public administration', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Real estate and rental and leasing', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Retail trade', 75, 88.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Transportation and warehousing', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Unclassified', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Utilities', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Wholesale trade', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'SOC Eligibility Rate', NULL, NULL, 36.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Total Completed Questionnaires', NULL, 75, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Data Collection Mode', 'Paper', 113, 49.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Data Collection Mode', 'Web', 113, 50.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Employee Completeness Rate', NULL, NULL, 89.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Employee Response Rate', NULL, NULL, 58.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Establishment Eligibility Rate', NULL, NULL, 90.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Establishment Response Rate', NULL, NULL, 66.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '1-5 Years', 113, 32.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '10 Years or More', 113, 34.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '6-9 Years', 113, 15.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '<1 Year', 113, 15.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', 'Missing', 113, 0.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 113, 1.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 113, 0.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 113, 8.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 113, 55.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 113, 0.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 113, 32.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Accommodation and food services', 113, 0.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 113, 1.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Construction', 113, 1.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Education services', 113, 22.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Finance and insurance', 113, 0.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Health care and social assistance', 113, 4.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Information', 113, 0.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Manufacturing', 113, 7.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Mining', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Other services, except public administration', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 113, 4.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Public administration', 113, 55.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Real estate and rental and leasing', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Retail trade', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Transportation and warehousing', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Unclassified', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Utilities', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Wholesale trade', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'SOC Eligibility Rate', NULL, NULL, 17.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Total Completed Questionnaires', NULL, 113, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Data Collection Mode', 'Paper', 20, 15.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Data Collection Mode', 'Web', 20, 85.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 70.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 30.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'OE Completeness Rate', NULL, NULL, 83.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'OE Response Rate', NULL, NULL, 46.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Data Collection Mode', 'Paper', 23, 30.4, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Data Collection Mode', 'Web', 23, 69.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 4.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 87.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 8.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'OE Completeness Rate', NULL, NULL, 92.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'OE Response Rate', NULL, NULL, 46.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Data Collection Mode', 'Paper', 30, 33.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Data Collection Mode', 'Web', 30, 66.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 30, 93.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 30, 6.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'OE Completeness Rate', NULL, NULL, 90.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'OE Response Rate', NULL, NULL, 50.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Total Completed Questionnaires', NULL, 30, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Data Collection Mode', 'Paper', 23, 13.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Data Collection Mode', 'Web', 23, 87.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 87.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 13.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'OE Response Rate', NULL, NULL, 59.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'Data Collection Mode', 'Paper', 25, 28.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'Data Collection Mode', 'Web', 25, 72.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 25, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 25, 80.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 25, 4.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 25, 16.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 25, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 25, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 25, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'OE Response Rate', NULL, NULL, 89.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'Total Completed Questionnaires', NULL, 25, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Data Collection Mode', 'Paper', 63, 57.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Data Collection Mode', 'Web', 63, 42.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Employee Completeness Rate', NULL, NULL, 92.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Employee Response Rate', NULL, NULL, 57.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Establishment Eligibility Rate', NULL, NULL, 81.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Establishment Response Rate', NULL, NULL, 47.4, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '1-5 Years', 63, 31.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '10 Years or More', 63, 54.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '6-9 Years', 63, 11.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '<1 Year', 63, 3.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', 'Missing', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 63, 100.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Accommodation and food services', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Construction', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Education services', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Finance and insurance', 63, 100.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Health care and social assistance', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Information', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Management of Companies and Enterprises', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Manufacturing', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Mining', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Other services, except public administration', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Public administration', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Real estate and rental and leasing', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Retail trade', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Transportation and warehousing', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Unclassified', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Utilities', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Wholesale trade', 63, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'SOC Eligibility Rate', NULL, NULL, 37.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Total Completed Questionnaires', NULL, 63, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Data Collection Mode', 'Paper', 61, 73.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Data Collection Mode', 'Web', 61, 26.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Employee Completeness Rate', NULL, NULL, 80.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Employee Response Rate', NULL, NULL, 79.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Establishment Eligibility Rate', NULL, NULL, 70.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Establishment Response Rate', NULL, NULL, 57.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '1-5 Years', 61, 39.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '10 Years or More', 61, 45.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '6-9 Years', 61, 8.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '<1 Year', 61, 6.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', 'Missing', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 61, 100.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Accommodation and food services', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Construction', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Education services', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Finance and insurance', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Health care and social assistance', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Information', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Management of Companies and Enterprises', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Manufacturing', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Mining', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Other services, except public administration', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Public administration', 61, 100.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Real estate and rental and leasing', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Retail trade', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Transportation and warehousing', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Unclassified', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Utilities', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Wholesale trade', 61, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'SOC Eligibility Rate', NULL, NULL, 24.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Total Completed Questionnaires', NULL, 61, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Data Collection Mode', 'Paper', 22, 31.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Data Collection Mode', 'Web', 22, 68.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 90.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 9.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'OE Completeness Rate', NULL, NULL, 95.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'OE Response Rate', NULL, NULL, 56.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'Data Collection Mode', 'Paper', 20, 5.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'Data Collection Mode', 'Web', 20, 95.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 90.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 10.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'OE Completeness Rate', NULL, NULL, 95.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'OE Response Rate', NULL, NULL, 31.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Data Collection Mode', 'Paper', 25, 4.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Data Collection Mode', 'Web', 25, 96.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 25, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', '10+ Years', 25, 72.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 25, 4.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 25, 24.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', '<1 Year', 25, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', 'Missing', 25, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 25, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'OE Completeness Rate', NULL, NULL, 89.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'OE Response Rate', NULL, NULL, 84.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Total Completed Questionnaires', NULL, 25, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Data Collection Mode', 'Paper', 65, 10.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Data Collection Mode', 'Web', 65, 89.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Employee Completeness Rate', NULL, NULL, 89.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Employee Response Rate', NULL, NULL, 45.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Establishment Eligibility Rate', NULL, NULL, 72.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Establishment Response Rate', NULL, NULL, 27.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'How Long at Current Job', '1-5 Years', 65, 40.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'How Long at Current Job', '10 Years or More', 65, 29.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'How Long at Current Job', '6-9 Years', 65, 20.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'How Long at Current Job', '<1 Year', 65, 10.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'How Long at Current Job', 'Missing', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 65, 3.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 65, 1.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 65, 4.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 65, 33.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 65, 56.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Accommodation and food services', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 65, 3.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 65, 7.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Construction', 65, 3.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Education services', 65, 15.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Finance and insurance', 65, 1.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Health care and social assistance', 65, 3.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Information', 65, 13.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Management of Companies and Enterprises', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Manufacturing', 65, 4.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Mining', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Other services, except public administration', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 65, 13.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Public administration', 65, 33.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Real estate and rental and leasing', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Retail trade', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Transportation and warehousing', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Unclassified', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Utilities', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'NAICS Sector', 'Wholesale trade', 65, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'SOC Eligibility Rate', NULL, NULL, 13.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.00', 'Total Completed Questionnaires', NULL, 65, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.01', 'Data Collection Mode', 'Paper', 22, 18.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.01', 'Data Collection Mode', 'Web', 22, 81.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 77.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 22.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.01', 'OE Completeness Rate', NULL, NULL, 95.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.01', 'OE Response Rate', NULL, NULL, 46.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1211.01', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Data Collection Mode', 'Paper', 72, 27.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Data Collection Mode', 'Web', 72, 72.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Employee Completeness Rate', NULL, NULL, 85.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Employee Response Rate', NULL, NULL, 46.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Establishment Eligibility Rate', NULL, NULL, 85.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Establishment Response Rate', NULL, NULL, 57.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'How Long at Current Job', '1-5 Years', 72, 47.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'How Long at Current Job', '10 Years or More', 72, 25.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'How Long at Current Job', '6-9 Years', 72, 8.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'How Long at Current Job', '<1 Year', 72, 18.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'How Long at Current Job', 'Missing', 72, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 72, 9.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 72, 15.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 72, 19.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 72, 9.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 72, 20.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 72, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 72, 15.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 72, 8.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Accommodation and food services', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 72, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Construction', 72, 9.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Education services', 72, 11.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Finance and insurance', 72, 15.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Health care and social assistance', 72, 2.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Information', 72, 4.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Management of Companies and Enterprises', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Manufacturing', 72, 19.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Mining', 72, 9.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Other services, except public administration', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 72, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Public administration', 72, 20.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Real estate and rental and leasing', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Retail trade', 72, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Transportation and warehousing', 72, 2.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Unclassified', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Utilities', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'NAICS Sector', 'Wholesale trade', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'SOC Eligibility Rate', NULL, NULL, 6.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1212.00', 'Total Completed Questionnaires', NULL, 72, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Data Collection Mode', 'Paper', 49, 40.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Data Collection Mode', 'Web', 49, 59.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Employee Completeness Rate', NULL, NULL, 94.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Employee Response Rate', NULL, NULL, 48.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Establishment Eligibility Rate', NULL, NULL, 71.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Establishment Response Rate', NULL, NULL, 73.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'How Long at Current Job', '1-5 Years', 49, 28.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'How Long at Current Job', '10 Years or More', 49, 40.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'How Long at Current Job', '6-9 Years', 49, 22.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'How Long at Current Job', '<1 Year', 49, 8.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'How Long at Current Job', 'Missing', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 49, 14.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 49, 2.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 49, 83.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Accommodation and food services', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Construction', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Education services', 49, 36.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Finance and insurance', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Health care and social assistance', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Information', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Management of Companies and Enterprises', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Manufacturing', 49, 14.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Mining', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Other services, except public administration', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 49, 46.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Public administration', 49, 2.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Real estate and rental and leasing', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Retail trade', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Transportation and warehousing', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Unclassified', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Utilities', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'NAICS Sector', 'Wholesale trade', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'SOC Eligibility Rate', NULL, NULL, 4.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1221.00', 'Total Completed Questionnaires', NULL, 49, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Data Collection Mode', 'Paper', 118, 35.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Data Collection Mode', 'Web', 118, 64.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Employee Completeness Rate', NULL, NULL, 86.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Employee Response Rate', NULL, NULL, 63.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Establishment Eligibility Rate', NULL, NULL, 85.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Establishment Response Rate', NULL, NULL, 62.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'How Long at Current Job', '1-5 Years', 118, 28.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'How Long at Current Job', '10 Years or More', 118, 42.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'How Long at Current Job', '6-9 Years', 118, 16.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'How Long at Current Job', '<1 Year', 118, 9.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'How Long at Current Job', 'Missing', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 118, 0.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 118, 9.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 118, 12.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 118, 6.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 118, 54.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 118, 8.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Accommodation and food services', 118, 4.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 118, 4.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 118, 1.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Construction', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Education services', 118, 19.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Finance and insurance', 118, 5.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Health care and social assistance', 118, 1.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Information', 118, 5.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Management of Companies and Enterprises', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Manufacturing', 118, 10.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Mining', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Other services, except public administration', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 118, 23.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Public administration', 118, 6.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Real estate and rental and leasing', 118, 3.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Retail trade', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Transportation and warehousing', 118, 5.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Unclassified', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Utilities', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'NAICS Sector', 'Wholesale trade', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'SOC Eligibility Rate', NULL, NULL, 24.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1231.00', 'Total Completed Questionnaires', NULL, 118, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Data Collection Mode', 'Paper', 73, 19.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Data Collection Mode', 'Web', 73, 80.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Employee Completeness Rate', NULL, NULL, 97.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Employee Response Rate', NULL, NULL, 50.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Establishment Eligibility Rate', NULL, NULL, 72.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Establishment Response Rate', NULL, NULL, 28.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'How Long at Current Job', '1-5 Years', 73, 38.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'How Long at Current Job', '10 Years or More', 73, 35.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'How Long at Current Job', '6-9 Years', 73, 11.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'How Long at Current Job', '<1 Year', 73, 13.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'How Long at Current Job', 'Missing', 73, 1.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 73, 12.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 73, 1.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 73, 9.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 73, 4.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 73, 28.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 73, 42.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 73, 1.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Accommodation and food services', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 73, 6.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Construction', 73, 12.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Education services', 73, 8.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Finance and insurance', 73, 1.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Health care and social assistance', 73, 12.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Information', 73, 2.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Management of Companies and Enterprises', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Manufacturing', 73, 9.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Mining', 73, 4.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Other services, except public administration', 73, 1.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 73, 11.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Public administration', 73, 28.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Real estate and rental and leasing', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Retail trade', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Transportation and warehousing', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Unclassified', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Utilities', 73, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'NAICS Sector', 'Wholesale trade', 73, 1.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'SOC Eligibility Rate', NULL, NULL, 19.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1232.00', 'Total Completed Questionnaires', NULL, 73, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.00', 'Data Collection Mode', 'Paper', 22, 13.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.00', 'Data Collection Mode', 'Web', 22, 86.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 4.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 68.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 9.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 18.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.00', 'OE Completeness Rate', NULL, NULL, 95.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.00', 'OE Response Rate', NULL, NULL, 39.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.00', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.01', 'Data Collection Mode', 'Paper', 21, 28.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.01', 'Data Collection Mode', 'Web', 21, 71.4, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 100.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.01', 'OE Completeness Rate', NULL, NULL, 91.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.01', 'OE Response Rate', NULL, NULL, 71.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1241.01', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Data Collection Mode', 'Paper', 67, 9.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Data Collection Mode', 'Web', 67, 91.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Employee Completeness Rate', NULL, NULL, 70.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Employee Response Rate', NULL, NULL, 44.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Establishment Eligibility Rate', NULL, NULL, 73.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Establishment Response Rate', NULL, NULL, 27.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'How Long at Current Job', '1-5 Years', 67, 38.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'How Long at Current Job', '10 Years or More', 67, 37.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'How Long at Current Job', '6-9 Years', 67, 17.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'How Long at Current Job', '<1 Year', 67, 6.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'How Long at Current Job', 'Missing', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 67, 1.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 67, 1.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 67, 7.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 67, 4.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 67, 34.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 67, 50.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Accommodation and food services', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 67, 4.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 67, 6.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Construction', 67, 1.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Education services', 67, 26.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Finance and insurance', 67, 1.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Health care and social assistance', 67, 3.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Information', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Management of Companies and Enterprises', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Manufacturing', 67, 7.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Mining', 67, 4.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Other services, except public administration', 67, 1.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 67, 9.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Public administration', 67, 34.3, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Real estate and rental and leasing', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Retail trade', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Transportation and warehousing', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Unclassified', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Utilities', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'NAICS Sector', 'Wholesale trade', 67, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'SOC Eligibility Rate', NULL, NULL, 12.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1242.00', 'Total Completed Questionnaires', NULL, 67, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.00', 'Data Collection Mode', 'Paper', 21, 4.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.00', 'Data Collection Mode', 'Web', 21, 95.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 4.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 85.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 9.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.00', 'OE Completeness Rate', NULL, NULL, 87.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.00', 'OE Response Rate', NULL, NULL, 82.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.00', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.01', 'Data Collection Mode', 'Paper', 23, 21.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.01', 'Data Collection Mode', 'Web', 23, 78.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 4.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 82.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 13.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.01', 'OE Completeness Rate', NULL, NULL, 79.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.01', 'OE Response Rate', NULL, NULL, 44.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1243.01', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Data Collection Mode', 'Paper', 123, 19.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Data Collection Mode', 'Web', 123, 80.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Employee Completeness Rate', NULL, NULL, 93.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Employee Response Rate', NULL, NULL, 64.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Establishment Eligibility Rate', NULL, NULL, 84.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Establishment Response Rate', NULL, NULL, 55.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'How Long at Current Job', '1-5 Years', 123, 26.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'How Long at Current Job', '10 Years or More', 123, 48.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'How Long at Current Job', '6-9 Years', 123, 16.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'How Long at Current Job', '<1 Year', 123, 8.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'How Long at Current Job', 'Missing', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 123, 8.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 123, 5.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 123, 20.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 123, 3.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 123, 22.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 123, 31.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 123, 7.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 123, 0.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Accommodation and food services', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Construction', 123, 9.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Education services', 123, 14.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Finance and insurance', 123, 4.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Health care and social assistance', 123, 5.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Information', 123, 9.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Management of Companies and Enterprises', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Manufacturing', 123, 17.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Mining', 123, 1.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Other services, except public administration', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 123, 8.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Public administration', 123, 22.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Real estate and rental and leasing', 123, 0.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Retail trade', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Transportation and warehousing', 123, 2.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Unclassified', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Utilities', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'NAICS Sector', 'Wholesale trade', 123, 0.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'SOC Eligibility Rate', NULL, NULL, 15.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1244.00', 'Total Completed Questionnaires', NULL, 123, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Data Collection Mode', 'Paper', 70, 27.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Data Collection Mode', 'Web', 70, 72.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Employee Completeness Rate', NULL, NULL, 82.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Employee Response Rate', NULL, NULL, 68.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Establishment Eligibility Rate', NULL, NULL, 82.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Establishment Response Rate', NULL, NULL, 52.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'How Long at Current Job', '1-5 Years', 70, 25.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'How Long at Current Job', '10 Years or More', 70, 41.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'How Long at Current Job', '6-9 Years', 70, 20.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'How Long at Current Job', '<1 Year', 70, 12.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'How Long at Current Job', 'Missing', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 70, 11.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 70, 15.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 70, 27.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 70, 44.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 70, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Accommodation and food services', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Construction', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Education services', 70, 27.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Finance and insurance', 70, 5.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Health care and social assistance', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Information', 70, 4.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Management of Companies and Enterprises', 70, 5.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Manufacturing', 70, 15.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Mining', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Other services, except public administration', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 70, 14.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Public administration', 70, 27.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Real estate and rental and leasing', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Retail trade', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Transportation and warehousing', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Unclassified', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Utilities', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'NAICS Sector', 'Wholesale trade', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'SOC Eligibility Rate', NULL, NULL, 12.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1251.00', 'Total Completed Questionnaires', NULL, 70, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1253.00', 'Data Collection Mode', 'Paper', 34, 5.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1253.00', 'Data Collection Mode', 'Web', 34, 94.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1253.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 34, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1253.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 34, 70.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1253.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 34, 2.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1253.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 34, 26.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1253.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 34, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1253.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 34, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1253.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 34, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1253.00', 'OE Completeness Rate', NULL, NULL, 94.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1253.00', 'OE Response Rate', NULL, NULL, 94.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1253.00', 'Total Completed Questionnaires', NULL, 34, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1254.00', 'Data Collection Mode', 'Paper', 24, 33.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1254.00', 'Data Collection Mode', 'Web', 24, 66.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1254.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 4.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1254.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 62.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1254.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 4.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1254.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 29.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1254.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1254.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1254.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1254.00', 'OE Completeness Rate', NULL, NULL, 92.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1254.00', 'OE Response Rate', NULL, NULL, 57.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1254.00', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1255.01', 'Data Collection Mode', 'Paper', 20, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1255.01', 'Data Collection Mode', 'Web', 20, 100.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1255.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1255.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 65.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1255.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1255.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 35.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1255.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1255.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1255.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1255.01', 'OE Completeness Rate', NULL, NULL, 87.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1255.01', 'OE Response Rate', NULL, NULL, 79.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1255.01', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.01', 'Data Collection Mode', 'Paper', 20, 15.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.01', 'Data Collection Mode', 'Web', 20, 85.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 60.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 5.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 35.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.01', 'OE Completeness Rate', NULL, NULL, 74.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.01', 'OE Response Rate', NULL, NULL, 56.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.01', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.03', 'Data Collection Mode', 'Paper', 20, 10.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.03', 'Data Collection Mode', 'Web', 20, 90.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.03', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.03', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 75.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.03', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.03', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 25.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.03', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.03', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.03', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.03', 'OE Completeness Rate', NULL, NULL, 83.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.03', 'OE Response Rate', NULL, NULL, 42.1, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.03', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.08', 'Data Collection Mode', 'Paper', 30, 16.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.08', 'Data Collection Mode', 'Web', 30, 83.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.08', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.08', 'How Much Experience Performing Work in this Occupation', '10+ Years', 30, 90.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.08', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.08', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 30, 6.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.08', 'How Much Experience Performing Work in this Occupation', '<1 Year', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.08', 'How Much Experience Performing Work in this Occupation', 'Missing', 30, 3.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.08', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.08', 'OE Completeness Rate', NULL, NULL, 85.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.08', 'OE Response Rate', NULL, NULL, 55.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.08', 'Total Completed Questionnaires', NULL, 30, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.09', 'Data Collection Mode', 'Paper', 21, 19.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.09', 'Data Collection Mode', 'Web', 21, 81.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.09', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.09', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 81.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.09', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.09', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 19.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.09', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.09', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.09', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.09', 'OE Completeness Rate', NULL, NULL, 87.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.09', 'OE Response Rate', NULL, NULL, 42.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1299.09', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Data Collection Mode', 'Paper', 28, 3.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Data Collection Mode', 'Web', 28, 96.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 28, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 28, 82.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 28, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 28, 17.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 28, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 28, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 28, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'OE Response Rate', NULL, NULL, 84.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Total Completed Questionnaires', NULL, 28, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Data Collection Mode', 'Paper', 24, 12.5, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Data Collection Mode', 'Web', 24, 87.5, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 95.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 4.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'OE Completeness Rate', NULL, NULL, 82.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'OE Response Rate', NULL, NULL, 67.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Data Collection Mode', 'Paper', 20, 45.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Data Collection Mode', 'Web', 20, 55.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 100.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'OE Completeness Rate', NULL, NULL, 90.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'OE Response Rate', NULL, NULL, 73.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Data Collection Mode', 'Paper', 20, 40.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Data Collection Mode', 'Web', 20, 60.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 90.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 10.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'OE Completeness Rate', NULL, NULL, 90.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'OE Response Rate', NULL, NULL, 62.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Data Collection Mode', 'Paper', 24, 12.5, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Data Collection Mode', 'Web', 24, 87.5, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 83.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 16.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'OE Completeness Rate', NULL, NULL, 92.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'OE Response Rate', NULL, NULL, 74.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.01', 'Data Collection Mode', 'Paper', 21, 19.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.01', 'Data Collection Mode', 'Web', 21, 81.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 4.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 57.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 38.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.01', 'OE Completeness Rate', NULL, NULL, 91.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.01', 'OE Response Rate', NULL, NULL, 51.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.01', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.02', 'Data Collection Mode', 'Paper', 20, 20.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.02', 'Data Collection Mode', 'Web', 20, 80.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 75.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 25.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.02', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.02', 'OE Response Rate', NULL, NULL, 62.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2051.02', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Data Collection Mode', 'Paper', 66, 31.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Data Collection Mode', 'Web', 66, 68.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Employee Completeness Rate', NULL, NULL, 90.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Employee Response Rate', NULL, NULL, 52.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Establishment Eligibility Rate', NULL, NULL, 86.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Establishment Response Rate', NULL, NULL, 82.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'How Long at Current Job', '1-5 Years', 66, 51.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'How Long at Current Job', '10 Years or More', 66, 21.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'How Long at Current Job', '6-9 Years', 66, 16.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'How Long at Current Job', '<1 Year', 66, 10.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'How Long at Current Job', 'Missing', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 66, 18.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 66, 81.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Accommodation and food services', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 66, 1.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Construction', 66, 3.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Education services', 66, 24.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Finance and insurance', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Health care and social assistance', 66, 9.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Information', 66, 1.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Management of Companies and Enterprises', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Manufacturing', 66, 13.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Mining', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Other services, except public administration', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 66, 40.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Public administration', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Real estate and rental and leasing', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Retail trade', 66, 6.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Transportation and warehousing', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Unclassified', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Utilities', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'NAICS Sector', 'Wholesale trade', 66, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'SOC Eligibility Rate', NULL, NULL, 3.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2099.01', 'Total Completed Questionnaires', NULL, 66, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Data Collection Mode', 'Paper', 21, 14.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Data Collection Mode', 'Web', 21, 85.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 66.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 33.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'OE Response Rate', NULL, NULL, 53.9, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Data Collection Mode', 'Paper', 28, 46.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Data Collection Mode', 'Web', 28, 53.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 28, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 28, 100.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 28, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 28, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 28, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 28, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 28, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'OE Completeness Rate', NULL, NULL, 96.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'OE Response Rate', NULL, NULL, 54.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Total Completed Questionnaires', NULL, 28, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Data Collection Mode', 'Paper', 60, 51.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Data Collection Mode', 'Web', 60, 48.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Employee Completeness Rate', NULL, NULL, 89.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Employee Response Rate', NULL, NULL, 70.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Establishment Eligibility Rate', NULL, NULL, 84.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Establishment Response Rate', NULL, NULL, 78.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', '1-5 Years', 60, 10.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', '10 Years or More', 60, 66.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', '6-9 Years', 60, 20.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', '<1 Year', 60, 3.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', 'Missing', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 60, 46.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 60, 51.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 60, 1.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Accommodation and food services', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Construction', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Education services', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Finance and insurance', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Health care and social assistance', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Information', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Manufacturing', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Mining', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Other services, except public administration', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 60, 51.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Public administration', 60, 46.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Real estate and rental and leasing', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Retail trade', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Transportation and warehousing', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Unclassified', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Utilities', 60, 1.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Wholesale trade', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'SOC Eligibility Rate', NULL, NULL, 16.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Total Completed Questionnaires', NULL, 60, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Data Collection Mode', 'Paper', 20, 10.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Data Collection Mode', 'Web', 20, 90.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 90.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 10.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'OE Completeness Rate', NULL, NULL, 95.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'OE Response Rate', NULL, NULL, 44.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Data Collection Mode', 'Paper', 27, 14.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Data Collection Mode', 'Web', 27, 85.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 27, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 27, 96.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 27, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 27, 3.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 27, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 27, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 27, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'OE Completeness Rate', NULL, NULL, 93.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'OE Response Rate', NULL, NULL, 63.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Total Completed Questionnaires', NULL, 27, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Data Collection Mode', 'Paper', 72, 36.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Data Collection Mode', 'Web', 72, 63.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Employee Completeness Rate', NULL, NULL, 92.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Employee Response Rate', NULL, NULL, 67.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Establishment Eligibility Rate', NULL, NULL, 81.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Establishment Response Rate', NULL, NULL, 68.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', '1-5 Years', 72, 37.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', '10 Years or More', 72, 40.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', '6-9 Years', 72, 11.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', '<1 Year', 72, 9.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', 'Missing', 72, 1.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 72, 80.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 72, 19.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Accommodation and food services', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Construction', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Education services', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Finance and insurance', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Health care and social assistance', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Information', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Manufacturing', 72, 80.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Mining', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Other services, except public administration', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 72, 19.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Public administration', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Real estate and rental and leasing', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Retail trade', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Transportation and warehousing', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Unclassified', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Utilities', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Wholesale trade', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'SOC Eligibility Rate', NULL, NULL, 11.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Total Completed Questionnaires', NULL, 72, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Data Collection Mode', 'Paper', 26, 65.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Data Collection Mode', 'Web', 26, 34.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 26, 92.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 26, 7.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'OE Completeness Rate', NULL, NULL, 92.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'OE Response Rate', NULL, NULL, 87.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Total Completed Questionnaires', NULL, 26, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Data Collection Mode', 'Paper', 30, 46.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Data Collection Mode', 'Web', 30, 53.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 30, 90.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 30, 10.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'OE Completeness Rate', NULL, NULL, 88.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'OE Response Rate', NULL, NULL, 60.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Total Completed Questionnaires', NULL, 30, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Data Collection Mode', 'Paper', 22, 13.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Data Collection Mode', 'Web', 22, 86.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 4.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 86.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 9.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'OE Completeness Rate', NULL, NULL, 95.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'OE Response Rate', NULL, NULL, 69.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Data Collection Mode', 'Paper', 21, 47.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Data Collection Mode', 'Web', 21, 52.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 100.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'OE Completeness Rate', NULL, NULL, 95.5, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'OE Response Rate', NULL, NULL, 46.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Data Collection Mode', 'Paper', 22, 4.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Data Collection Mode', 'Web', 22, 95.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 95.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 4.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'OE Response Rate', NULL, NULL, 45.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.02', 'Data Collection Mode', 'Paper', 23, 47.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.02', 'Data Collection Mode', 'Web', 23, 52.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 95.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 4.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.02', 'OE Completeness Rate', NULL, NULL, 92.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.02', 'OE Response Rate', NULL, NULL, 58.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.02', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Data Collection Mode', 'Paper', 29, 17.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Data Collection Mode', 'Web', 29, 82.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 29, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 29, 79.3, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 29, 3.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 29, 13.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 29, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 29, 3.4, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 29, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'OE Completeness Rate', NULL, NULL, 90.6, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'OE Response Rate', NULL, NULL, 43.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Total Completed Questionnaires', NULL, 29, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Data Collection Mode', 'Paper', 56, 17.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Data Collection Mode', 'Web', 56, 82.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Employee Completeness Rate', NULL, NULL, 88.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Employee Response Rate', NULL, NULL, 50.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Establishment Eligibility Rate', NULL, NULL, 74.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Establishment Response Rate', NULL, NULL, 30.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', '1-5 Years', 56, 35.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', '10 Years or More', 56, 46.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', '6-9 Years', 56, 8.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', '<1 Year', 56, 8.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', 'Missing', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 56, 53.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 56, 8.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 56, 35.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 56, 1.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Accommodation and food services', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Construction', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Education services', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Finance and insurance', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Health care and social assistance', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Information', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Management of Companies and Enterprises', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Manufacturing', 56, 53.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Mining', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Other services, except public administration', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 56, 8.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Public administration', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Real estate and rental and leasing', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Retail trade', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Transportation and warehousing', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Unclassified', 56, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Utilities', 56, 35.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Wholesale trade', 56, 1.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'SOC Eligibility Rate', NULL, NULL, 17.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Total Completed Questionnaires', NULL, 56, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Data Collection Mode', 'Paper', 50, 44.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Data Collection Mode', 'Web', 50, 56.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Employee Completeness Rate', NULL, NULL, 86.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Employee Response Rate', NULL, NULL, 50.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Establishment Eligibility Rate', NULL, NULL, 69.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Establishment Response Rate', NULL, NULL, 28.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', '1-5 Years', 50, 36.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', '10 Years or More', 50, 48.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', '6-9 Years', 50, 6.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', '<1 Year', 50, 10.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', 'Missing', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 50, 80.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 50, 20.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Accommodation and food services', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Construction', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Education services', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Finance and insurance', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Health care and social assistance', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Information', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Management of Companies and Enterprises', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Manufacturing', 50, 80.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Mining', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Other services, except public administration', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 50, 20.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Public administration', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Real estate and rental and leasing', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Retail trade', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Transportation and warehousing', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Unclassified', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Utilities', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Wholesale trade', 50, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'SOC Eligibility Rate', NULL, NULL, 19.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Total Completed Questionnaires', NULL, 50, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Data Collection Mode', 'Paper', 75, 36.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Data Collection Mode', 'Web', 75, 64.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Employee Completeness Rate', NULL, NULL, 90.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Employee Response Rate', NULL, NULL, 60.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Establishment Eligibility Rate', NULL, NULL, 80.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Establishment Response Rate', NULL, NULL, 79.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'How Long at Current Job', '1-5 Years', 75, 34.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'How Long at Current Job', '10 Years or More', 75, 33.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'How Long at Current Job', '6-9 Years', 75, 24.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'How Long at Current Job', '<1 Year', 75, 6.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'How Long at Current Job', 'Missing', 75, 1.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 75, 29.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 75, 62.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 75, 2.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 75, 5.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Accommodation and food services', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 75, 2.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Construction', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Education services', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Finance and insurance', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Health care and social assistance', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Information', 75, 10.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Management of Companies and Enterprises', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Manufacturing', 75, 29.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Mining', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Other services, except public administration', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 75, 52.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Public administration', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Real estate and rental and leasing', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Retail trade', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Transportation and warehousing', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Unclassified', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Utilities', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Wholesale trade', 75, 5.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'SOC Eligibility Rate', NULL, NULL, 5.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Total Completed Questionnaires', NULL, 75, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Data Collection Mode', 'Paper', 22, 59.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Data Collection Mode', 'Web', 22, 40.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 95.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 4.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'OE Completeness Rate', NULL, NULL, 75.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'OE Response Rate', NULL, NULL, 74.4, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Data Collection Mode', 'Paper', 20, 40.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Data Collection Mode', 'Web', 20, 60.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 100.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'OE Completeness Rate', NULL, NULL, 87.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'OE Response Rate', NULL, NULL, 67.7, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Data Collection Mode', 'Paper', 84, 42.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Data Collection Mode', 'Web', 84, 57.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Employee Completeness Rate', NULL, NULL, 90.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Employee Response Rate', NULL, NULL, 68.4, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Establishment Eligibility Rate', NULL, NULL, 84.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Establishment Response Rate', NULL, NULL, 59.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', '1-5 Years', 84, 40.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', '10 Years or More', 84, 44.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', '6-9 Years', 84, 10.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', '<1 Year', 84, 4.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', 'Missing', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 84, 88.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 84, 11.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Accommodation and food services', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Construction', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Education services', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Finance and insurance', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Health care and social assistance', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Information', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Management of Companies and Enterprises', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Manufacturing', 84, 88.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Mining', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Other services, except public administration', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 84, 11.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Public administration', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Real estate and rental and leasing', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Retail trade', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Transportation and warehousing', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Unclassified', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Utilities', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Wholesale trade', 84, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'SOC Eligibility Rate', NULL, NULL, 14.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Total Completed Questionnaires', NULL, 84, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'Data Collection Mode', 'Paper', 21, 23.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'Data Collection Mode', 'Web', 21, 76.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 85.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 4.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 9.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'OE Completeness Rate', NULL, NULL, 91.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'OE Response Rate', NULL, NULL, 63.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.02', 'Data Collection Mode', 'Paper', 20, 25.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.02', 'Data Collection Mode', 'Web', 20, 75.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 95.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 5.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.02', 'OE Completeness Rate', NULL, NULL, 80.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.02', 'OE Response Rate', NULL, NULL, 73.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.02', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.03', 'Data Collection Mode', 'Paper', 26, 46.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.03', 'Data Collection Mode', 'Web', 26, 53.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.03', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.03', 'How Much Experience Performing Work in this Occupation', '10+ Years', 26, 84.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.03', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 26, 3.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.03', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 26, 11.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.03', 'How Much Experience Performing Work in this Occupation', '<1 Year', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.03', 'How Much Experience Performing Work in this Occupation', 'Missing', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.03', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.03', 'OE Completeness Rate', NULL, NULL, 86.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.03', 'OE Response Rate', NULL, NULL, 88.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.03', 'Total Completed Questionnaires', NULL, 26, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Data Collection Mode', 'Paper', 21, 33.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Data Collection Mode', 'Web', 21, 66.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 81.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 9.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 9.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'OE Completeness Rate', NULL, NULL, 87.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'OE Response Rate', NULL, NULL, 48.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Data Collection Mode', 'Paper', 108, 56.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Data Collection Mode', 'Web', 108, 43.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Employee Completeness Rate', NULL, NULL, 94.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Employee Response Rate', NULL, NULL, 58.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Establishment Eligibility Rate', NULL, NULL, 86.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Establishment Response Rate', NULL, NULL, 60.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', '1-5 Years', 108, 29.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', '10 Years or More', 108, 45.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', '6-9 Years', 108, 19.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', '<1 Year', 108, 3.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', 'Missing', 108, 1.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 108, 89.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 108, 10.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Accommodation and food services', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Construction', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Education services', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Finance and insurance', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Health care and social assistance', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Information', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Management of Companies and Enterprises', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Manufacturing', 108, 89.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Mining', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Other services, except public administration', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 108, 10.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Public administration', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Real estate and rental and leasing', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Retail trade', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Transportation and warehousing', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Unclassified', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Utilities', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Wholesale trade', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'SOC Eligibility Rate', NULL, NULL, 26.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Total Completed Questionnaires', NULL, 108, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'Data Collection Mode', 'Paper', 22, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'Data Collection Mode', 'Web', 22, 100.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 81.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 18.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'OE Completeness Rate', NULL, NULL, 91.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'OE Response Rate', NULL, NULL, 57.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'Data Collection Mode', 'Paper', 21, 9.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'Data Collection Mode', 'Web', 21, 90.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 81.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 9.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 4.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 4.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'OE Completeness Rate', NULL, NULL, 87.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'OE Response Rate', NULL, NULL, 72.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Data Collection Mode', 'Paper', 67, 61.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Data Collection Mode', 'Web', 67, 38.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Employee Completeness Rate', NULL, NULL, 91.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Employee Response Rate', NULL, NULL, 71.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Establishment Eligibility Rate', NULL, NULL, 77.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Establishment Response Rate', NULL, NULL, 62.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', '1-5 Years', 67, 43.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', '10 Years or More', 67, 32.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', '6-9 Years', 67, 20.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', '<1 Year', 67, 3.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', 'Missing', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 67, 74.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 67, 25.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Accommodation and food services', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Construction', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Education services', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Finance and insurance', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Health care and social assistance', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Information', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Management of Companies and Enterprises', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Manufacturing', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Mining', 67, 74.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Other services, except public administration', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 67, 25.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Public administration', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Real estate and rental and leasing', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Retail trade', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Transportation and warehousing', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Unclassified', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Utilities', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Wholesale trade', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'SOC Eligibility Rate', NULL, NULL, 14.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Total Completed Questionnaires', NULL, 67, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Data Collection Mode', 'Paper', 27, 37.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Data Collection Mode', 'Web', 27, 63.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 27, 88.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 27, 11.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'OE Completeness Rate', NULL, NULL, 93.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'OE Response Rate', NULL, NULL, 85.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Total Completed Questionnaires', NULL, 27, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Data Collection Mode', 'Paper', 58, 25.9, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Data Collection Mode', 'Web', 58, 74.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Employee Completeness Rate', NULL, NULL, 85.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Employee Response Rate', NULL, NULL, 57.6, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Establishment Eligibility Rate', NULL, NULL, 71.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Establishment Response Rate', NULL, NULL, 61.4, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', '1-5 Years', 58, 43.1, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', '10 Years or More', 58, 34.5, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', '6-9 Years', 58, 17.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', '<1 Year', 58, 5.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', 'Missing', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 58, 89.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 58, 10.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Accommodation and food services', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Construction', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Education services', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Finance and insurance', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Health care and social assistance', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Information', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Management of Companies and Enterprises', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Manufacturing', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Mining', 58, 89.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Other services, except public administration', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 58, 10.3, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Public administration', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Real estate and rental and leasing', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Retail trade', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Transportation and warehousing', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Unclassified', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Utilities', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Wholesale trade', 58, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'SOC Eligibility Rate', NULL, NULL, 11.7, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Total Completed Questionnaires', NULL, 58, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'Data Collection Mode', 'Paper', 22, 50.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'Data Collection Mode', 'Web', 22, 50.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 86.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 13.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'OE Completeness Rate', NULL, NULL, 84.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'OE Response Rate', NULL, NULL, 76.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.03', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Data Collection Mode', 'Paper', 58, 29.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Data Collection Mode', 'Web', 58, 70.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Employee Completeness Rate', NULL, NULL, 87.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Employee Response Rate', NULL, NULL, 51.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Establishment Eligibility Rate', NULL, NULL, 77.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Establishment Response Rate', NULL, NULL, 34.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'How Long at Current Job', '1-5 Years', 58, 34.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'How Long at Current Job', '10 Years or More', 58, 51.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'How Long at Current Job', '6-9 Years', 58, 6.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'How Long at Current Job', '<1 Year', 58, 5.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'How Long at Current Job', 'Missing', 58, 1.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 58, 93.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 58, 6.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Accommodation and food services', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Arts, entertainment, and recreation', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Construction', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Education services', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Finance and insurance', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Health care and social assistance', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Information', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Management of Companies and Enterprises', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Manufacturing', 58, 93.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Mining', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Other services, except public administration', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Professional, Scientific and Technical Services', 58, 6.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Public administration', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Real estate and rental and leasing', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Retail trade', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Transportation and warehousing', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Unclassified', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Utilities', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'NAICS Sector', 'Wholesale trade', 58, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'SOC Eligibility Rate', NULL, NULL, 8.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.05', 'Total Completed Questionnaires', NULL, 58, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Data Collection Mode', 'Paper', 58, 48.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Data Collection Mode', 'Web', 58, 51.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Employee Completeness Rate', NULL, NULL, 81.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Employee Response Rate', NULL, NULL, 53.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Establishment Eligibility Rate', NULL, NULL, 82.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Establishment Response Rate', NULL, NULL, 78.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'How Long at Current Job', '1-5 Years', 58, 29.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'How Long at Current Job', '10 Years or More', 58, 46.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'How Long at Current Job', '6-9 Years', 58, 19.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'How Long at Current Job', '<1 Year', 58, 5.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'How Long at Current Job', 'Missing', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 58, 74.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 58, 25.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Accommodation and food services', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Arts, entertainment, and recreation', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Construction', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Education services', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Finance and insurance', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Health care and social assistance', 58, 1.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Information', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Management of Companies and Enterprises', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Manufacturing', 58, 67.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Mining', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Other services, except public administration', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Professional, Scientific and Technical Services', 58, 29.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Public administration', 58, 1.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Real estate and rental and leasing', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Retail trade', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Transportation and warehousing', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Unclassified', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Utilities', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'NAICS Sector', 'Wholesale trade', 58, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'SOC Eligibility Rate', NULL, NULL, 2.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.06', 'Total Completed Questionnaires', NULL, 58, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.07', 'Data Collection Mode', 'Paper', 23, 43.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.07', 'Data Collection Mode', 'Web', 23, 56.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.07', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.07', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 87.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.07', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.07', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 13.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.07', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.07', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.07', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.07', 'OE Completeness Rate', NULL, NULL, 88.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.07', 'OE Response Rate', NULL, NULL, 60.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.07', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.08', 'Data Collection Mode', 'Paper', 30, 33.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.08', 'Data Collection Mode', 'Web', 30, 66.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.08', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.08', 'How Much Experience Performing Work in this Occupation', '10+ Years', 30, 66.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.08', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 30, 3.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.08', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 30, 30.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.08', 'How Much Experience Performing Work in this Occupation', '<1 Year', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.08', 'How Much Experience Performing Work in this Occupation', 'Missing', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.08', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.08', 'OE Completeness Rate', NULL, NULL, 81.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.08', 'OE Response Rate', NULL, NULL, 48.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.08', 'Total Completed Questionnaires', NULL, 30, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.09', 'Data Collection Mode', 'Paper', 21, 4.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.09', 'Data Collection Mode', 'Web', 21, 95.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.09', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.09', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 76.2, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.09', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.09', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 23.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.09', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.09', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.09', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.09', 'OE Completeness Rate', NULL, NULL, 87.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.09', 'OE Response Rate', NULL, NULL, 42.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.09', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Data Collection Mode', 'Paper', 116, 50.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Data Collection Mode', 'Web', 116, 50.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Employee Completeness Rate', NULL, NULL, 90.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Employee Response Rate', NULL, NULL, 70.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Establishment Eligibility Rate', NULL, NULL, 84.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Establishment Response Rate', NULL, NULL, 91.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'How Long at Current Job', '1-5 Years', 116, 55.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'How Long at Current Job', '10 Years or More', 116, 21.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'How Long at Current Job', '6-9 Years', 116, 8.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'How Long at Current Job', '<1 Year', 116, 14.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'How Long at Current Job', 'Missing', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 116, 2.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 116, 6.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 116, 89.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 116, 0.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Accommodation and food services', 116, 6.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Arts, entertainment, and recreation', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Construction', 116, 2.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Education services', 116, 3.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Finance and insurance', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Health care and social assistance', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Information', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Management of Companies and Enterprises', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Manufacturing', 116, 0.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Mining', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Other services, except public administration', 116, 0.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Professional, Scientific and Technical Services', 116, 85.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Public administration', 116, 0.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Real estate and rental and leasing', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Retail trade', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Transportation and warehousing', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Unclassified', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Utilities', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'NAICS Sector', 'Wholesale trade', 116, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'SOC Eligibility Rate', NULL, NULL, 10.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.10', 'Total Completed Questionnaires', NULL, 116, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.11', 'Data Collection Mode', 'Paper', 28, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.11', 'Data Collection Mode', 'Web', 28, 100.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.11', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 28, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.11', 'How Much Experience Performing Work in this Occupation', '10+ Years', 28, 60.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.11', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 28, 3.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.11', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 28, 35.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.11', 'How Much Experience Performing Work in this Occupation', '<1 Year', 28, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.11', 'How Much Experience Performing Work in this Occupation', 'Missing', 28, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.11', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 28, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.11', 'OE Completeness Rate', NULL, NULL, 96.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.11', 'OE Response Rate', NULL, NULL, 56.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.11', 'Total Completed Questionnaires', NULL, 28, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Data Collection Mode', 'Paper', 203, 60.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Data Collection Mode', 'Web', 203, 39.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Employee Completeness Rate', NULL, NULL, 89.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Employee Response Rate', NULL, NULL, 72.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Establishment Eligibility Rate', NULL, NULL, 78.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Establishment Response Rate', NULL, NULL, 62.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'How Long at Current Job', '1-5 Years', 203, 30.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'How Long at Current Job', '10 Years or More', 203, 51.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'How Long at Current Job', '6-9 Years', 203, 13.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'How Long at Current Job', '<1 Year', 203, 3.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'How Long at Current Job', 'Missing', 203, 0.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 203, 28.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 203, 15.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 203, 56.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Accommodation and food services', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 203, 3.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Construction', 203, 0.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Education services', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Finance and insurance', 203, 0.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Health care and social assistance', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Information', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Management of Companies and Enterprises', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Manufacturing', 203, 27.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Mining', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Other services, except public administration', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 203, 16.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Public administration', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Real estate and rental and leasing', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Retail trade', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Transportation and warehousing', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Unclassified', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Utilities', 203, 51.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'NAICS Sector', 'Wholesale trade', 203, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'SOC Eligibility Rate', NULL, NULL, 14.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3012.00', 'Total Completed Questionnaires', NULL, 203, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Data Collection Mode', 'Paper', 81, 60.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Data Collection Mode', 'Web', 81, 39.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Employee Completeness Rate', NULL, NULL, 93.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Employee Response Rate', NULL, NULL, 61.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Establishment Eligibility Rate', NULL, NULL, 84.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Establishment Response Rate', NULL, NULL, 55.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'How Long at Current Job', '1-5 Years', 81, 23.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'How Long at Current Job', '10 Years or More', 81, 53.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'How Long at Current Job', '6-9 Years', 81, 14.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'How Long at Current Job', '<1 Year', 81, 8.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'How Long at Current Job', 'Missing', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 81, 71.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 81, 28.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Accommodation and food services', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Construction', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Education services', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Finance and insurance', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Health care and social assistance', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Information', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Management of Companies and Enterprises', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Manufacturing', 81, 71.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Mining', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Other services, except public administration', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 81, 28.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Public administration', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Real estate and rental and leasing', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Retail trade', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Transportation and warehousing', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Unclassified', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Utilities', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'NAICS Sector', 'Wholesale trade', 81, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'SOC Eligibility Rate', NULL, NULL, 15.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3013.00', 'Total Completed Questionnaires', NULL, 81, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Data Collection Mode', 'Paper', 49, 69.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Data Collection Mode', 'Web', 49, 30.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Employee Completeness Rate', NULL, NULL, 87.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Employee Response Rate', NULL, NULL, 72.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Establishment Eligibility Rate', NULL, NULL, 70.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Establishment Response Rate', NULL, NULL, 80.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'How Long at Current Job', '1-5 Years', 49, 20.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'How Long at Current Job', '10 Years or More', 49, 46.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'How Long at Current Job', '6-9 Years', 49, 16.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'How Long at Current Job', '<1 Year', 49, 16.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'How Long at Current Job', 'Missing', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 49, 85.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 49, 14.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Accommodation and food services', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Construction', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Education services', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Finance and insurance', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Health care and social assistance', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Information', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Manufacturing', 49, 85.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Mining', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Other services, except public administration', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 49, 14.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Public administration', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Real estate and rental and leasing', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Retail trade', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Transportation and warehousing', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Unclassified', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Utilities', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'NAICS Sector', 'Wholesale trade', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'SOC Eligibility Rate', NULL, NULL, 3.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3021.00', 'Total Completed Questionnaires', NULL, 49, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Data Collection Mode', 'Paper', 100, 69.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Data Collection Mode', 'Web', 100, 31.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Employee Completeness Rate', NULL, NULL, 91.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Employee Response Rate', NULL, NULL, 69.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Establishment Eligibility Rate', NULL, NULL, 83.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Establishment Response Rate', NULL, NULL, 61.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'How Long at Current Job', '1-5 Years', 100, 20.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'How Long at Current Job', '10 Years or More', 100, 51.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'How Long at Current Job', '6-9 Years', 100, 25.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'How Long at Current Job', '<1 Year', 100, 4.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'How Long at Current Job', 'Missing', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 100, 38.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 100, 48.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 100, 14.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Accommodation and food services', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Construction', 100, 38.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Education services', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Finance and insurance', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Health care and social assistance', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Information', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Management of Companies and Enterprises', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Manufacturing', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Mining', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Other services, except public administration', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 100, 14.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Public administration', 100, 48.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Real estate and rental and leasing', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Retail trade', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Transportation and warehousing', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Unclassified', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Utilities', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'NAICS Sector', 'Wholesale trade', 100, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'SOC Eligibility Rate', NULL, NULL, 21.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3022.00', 'Total Completed Questionnaires', NULL, 100, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Data Collection Mode', 'Paper', 117, 69.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Data Collection Mode', 'Web', 117, 30.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Employee Completeness Rate', NULL, NULL, 88.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Employee Response Rate', NULL, NULL, 55.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Establishment Eligibility Rate', NULL, NULL, 77.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Establishment Response Rate', NULL, NULL, 47.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'How Long at Current Job', '1-5 Years', 117, 23.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'How Long at Current Job', '10 Years or More', 117, 59.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'How Long at Current Job', '6-9 Years', 117, 13.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'How Long at Current Job', '<1 Year', 117, 4.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'How Long at Current Job', 'Missing', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 117, 94.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 117, 3.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 117, 1.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Accommodation and food services', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Construction', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Education services', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Finance and insurance', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Health care and social assistance', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Information', 117, 1.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Management of Companies and Enterprises', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Manufacturing', 117, 94.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Mining', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Other services, except public administration', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 117, 3.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Public administration', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Real estate and rental and leasing', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Retail trade', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Transportation and warehousing', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Unclassified', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Utilities', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'NAICS Sector', 'Wholesale trade', 117, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'SOC Eligibility Rate', NULL, NULL, 9.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.00', 'Total Completed Questionnaires', NULL, 117, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.01', 'Data Collection Mode', 'Paper', 22, 36.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.01', 'Data Collection Mode', 'Web', 22, 63.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 63.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 4.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 31.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.01', 'OE Completeness Rate', NULL, NULL, 84.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.01', 'OE Response Rate', NULL, NULL, 40.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3024.01', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Data Collection Mode', 'Paper', 82, 62.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Data Collection Mode', 'Web', 82, 37.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Employee Completeness Rate', NULL, NULL, 92.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Employee Response Rate', NULL, NULL, 76.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Establishment Eligibility Rate', NULL, NULL, 80.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Establishment Response Rate', NULL, NULL, 80.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'How Long at Current Job', '1-5 Years', 82, 30.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'How Long at Current Job', '10 Years or More', 82, 36.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'How Long at Current Job', '6-9 Years', 82, 26.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'How Long at Current Job', '<1 Year', 82, 4.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'How Long at Current Job', 'Missing', 82, 1.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 82, 11.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 82, 39.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 82, 41.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 82, 8.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Accommodation and food services', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 82, 7.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Construction', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Education services', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Finance and insurance', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Health care and social assistance', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Information', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Management of Companies and Enterprises', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Manufacturing', 82, 11.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Mining', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Other services, except public administration', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 82, 41.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Public administration', 82, 39.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Real estate and rental and leasing', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Retail trade', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Transportation and warehousing', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Unclassified', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Utilities', 82, 1.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'NAICS Sector', 'Wholesale trade', 82, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'SOC Eligibility Rate', NULL, NULL, 6.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3025.00', 'Total Completed Questionnaires', NULL, 82, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Data Collection Mode', 'Paper', 78, 65.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Data Collection Mode', 'Web', 78, 34.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Employee Completeness Rate', NULL, NULL, 88.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Employee Response Rate', NULL, NULL, 67.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Establishment Eligibility Rate', NULL, NULL, 86.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Establishment Response Rate', NULL, NULL, 69.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'How Long at Current Job', '1-5 Years', 78, 34.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'How Long at Current Job', '10 Years or More', 78, 33.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'How Long at Current Job', '6-9 Years', 78, 23.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'How Long at Current Job', '<1 Year', 78, 9.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'How Long at Current Job', 'Missing', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 78, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Accommodation and food services', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Construction', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Education services', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Finance and insurance', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Health care and social assistance', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Information', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Management of Companies and Enterprises', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Manufacturing', 78, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Mining', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Other services, except public administration', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Public administration', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Real estate and rental and leasing', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Retail trade', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Transportation and warehousing', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Unclassified', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Utilities', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'NAICS Sector', 'Wholesale trade', 78, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'SOC Eligibility Rate', NULL, NULL, 10.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3026.00', 'Total Completed Questionnaires', NULL, 78, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Data Collection Mode', 'Paper', 95, 56.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Data Collection Mode', 'Web', 95, 43.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Employee Completeness Rate', NULL, NULL, 87.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Employee Response Rate', NULL, NULL, 52.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Establishment Eligibility Rate', NULL, NULL, 82.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Establishment Response Rate', NULL, NULL, 48.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'How Long at Current Job', '1-5 Years', 95, 40.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'How Long at Current Job', '10 Years or More', 95, 40.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'How Long at Current Job', '6-9 Years', 95, 15.8, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'How Long at Current Job', '<1 Year', 95, 4.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'How Long at Current Job', 'Missing', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 95, 92.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 95, 7.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Accommodation and food services', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Construction', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Education services', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Finance and insurance', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Health care and social assistance', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Information', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Management of Companies and Enterprises', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Manufacturing', 95, 92.6, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Mining', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Other services, except public administration', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 95, 7.4, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Public administration', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Real estate and rental and leasing', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Retail trade', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Transportation and warehousing', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Unclassified', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Utilities', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'NAICS Sector', 'Wholesale trade', 95, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'SOC Eligibility Rate', NULL, NULL, 10.5, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.00', 'Total Completed Questionnaires', NULL, 95, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.01', 'Data Collection Mode', 'Paper', 27, 48.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.01', 'Data Collection Mode', 'Web', 27, 51.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 27, 3.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 27, 74.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 27, 7.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 27, 14.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 27, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 27, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 27, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.01', 'OE Completeness Rate', NULL, NULL, 87.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.01', 'OE Response Rate', NULL, NULL, 67.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3027.01', 'Total Completed Questionnaires', NULL, 27, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.01', 'Data Collection Mode', 'Paper', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.01', 'Data Collection Mode', 'Web', 22, 100.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 81.8, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 9.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 9.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.01', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.01', 'OE Response Rate', NULL, NULL, 75.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.01', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.08', 'Data Collection Mode', 'Paper', 25, 48.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.08', 'Data Collection Mode', 'Web', 25, 52.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.08', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.08', 'How Much Experience Performing Work in this Occupation', '10+ Years', 25, 80.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.08', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.08', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 25, 16.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.08', 'How Much Experience Performing Work in this Occupation', '<1 Year', 25, 4.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.08', 'How Much Experience Performing Work in this Occupation', 'Missing', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.08', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.08', 'OE Completeness Rate', NULL, NULL, 86.2, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.08', 'OE Response Rate', NULL, NULL, 41.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-3029.08', 'Total Completed Questionnaires', NULL, 25, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1011.00', 'Data Collection Mode', 'Paper', 23, 26.1, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1011.00', 'Data Collection Mode', 'Web', 23, 73.9, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1011.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1011.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 95.7, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1011.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1011.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 4.3, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1011.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1011.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1011.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1011.00', 'OE Completeness Rate', NULL, NULL, 85.2, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1011.00', 'OE Response Rate', NULL, NULL, 73.0, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1011.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1012.00', 'Data Collection Mode', 'Paper', 23, 34.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1012.00', 'Data Collection Mode', 'Web', 23, 65.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1012.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1012.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 100.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1012.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1012.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1012.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1012.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1012.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1012.00', 'OE Completeness Rate', NULL, NULL, 85.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1012.00', 'OE Response Rate', NULL, NULL, 62.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1012.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1013.00', 'Data Collection Mode', 'Paper', 21, 19.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1013.00', 'Data Collection Mode', 'Web', 21, 81.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1013.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1013.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 95.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1013.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1013.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 4.8, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1013.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1013.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1013.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1013.00', 'OE Completeness Rate', NULL, NULL, 95.5, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1013.00', 'OE Response Rate', NULL, NULL, 51.2, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1013.00', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1021.00', 'Data Collection Mode', 'Paper', 20, 20.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1021.00', 'Data Collection Mode', 'Web', 20, 80.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1021.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1021.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 95.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1021.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1021.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 5.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1021.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1021.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1021.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1021.00', 'OE Completeness Rate', NULL, NULL, 95.2, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1021.00', 'OE Response Rate', NULL, NULL, 56.8, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1021.00', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1022.00', 'Data Collection Mode', 'Paper', 23, 43.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1022.00', 'Data Collection Mode', 'Web', 23, 56.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1022.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 4.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1022.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 82.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1022.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1022.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 13.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1022.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1022.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1022.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1022.00', 'OE Completeness Rate', NULL, NULL, 92.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1022.00', 'OE Response Rate', NULL, NULL, 73.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1022.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1023.00', 'Data Collection Mode', 'Paper', 61, 11.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1023.00', 'Data Collection Mode', 'Web', 61, 88.5, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1023.00', 'Employee Completeness Rate', NULL, NULL, 92.4, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1023.00', 'Employee Response Rate', NULL, NULL, 55.9, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1023.00', 'Establishment Eligibility Rate', NULL, NULL, 74.1, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1023.00', 'Establishment Response Rate', NULL, NULL, 51.7, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1023.00', 'How Long at Current Job', '1-5 Years', 61, 24.6, TO_DATE('2023-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('19-1023.00', 'How Long at Current Job', 