/*! START TRANSACTION */;
CREATE TABLE work_context (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  category DECIMAL(3,0),
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(7,4),
  lower_ci_bound DECIMAL(7,4),
  upper_ci_bound DECIMAL(7,4),
  recommend_suppress CHARACTER(1),
  not_relevant CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id),
  FOREIGN KEY (element_id, scale_id, category) REFERENCES work_context_categories(element_id, scale_id, category));
/*! COMMIT */;
/*! START TRANSACTION */;

INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CX', NULL, 3.07, 37, 0.2851, 2.4923, 3.6486, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 1, 0.13, 37, 0.1370, 0.0160, 1.0770, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 2, 39.49, 37, 11.0101, 20.4073, 62.4299, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 3, 33.07, 37, 7.1359, 20.4456, 48.7245, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 4, 7.79, 37, 4.3613, 2.4093, 22.4457, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 5, 19.51, 37, 9.2893, 6.8032, 44.5820, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CX', NULL, 4.92, 35, 0.0533, 4.8116, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 35, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 35, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 35, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 4, 8.02, 35, 5.3268, 1.9674, 27.4486, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 5, 91.98, 35, 5.3268, 72.5514, 98.0326, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CX', NULL, 4.97, 37, 0.0348, 4.8954, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 4, 3.41, 37, 3.4751, 0.4149, 23.0604, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 5, 96.59, 37, 3.4751, 76.9396, 99.5851, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CX', NULL, 4.14, 35, 0.1150, 3.9109, 4.3782, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 35, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 2, 2.15, 35, 2.1550, 0.2723, 14.9933, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 3, 6.54, 35, 4.7316, 1.4296, 25.2313, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 4, 66.02, 35, 11.9786, 39.6295, 85.1873, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 5, 25.29, 35, 10.1707, 10.1844, 50.2706, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CX', NULL, 4.90, 34, 0.0549, 4.7838, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 34, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 34, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 3, 0.51, 34, 0.5344, 0.0607, 4.1725, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 4, 9.43, 34, 5.2608, 2.8909, 26.7166, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 5, 90.05, 34, 5.3483, 72.8766, 96.8263, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CX', NULL, 4.58, 37, 0.1598, 4.2514, 4.8994, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 2, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 3, 9.72, 37, 6.0435, 2.5975, 30.3210, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 4, 23.01, 37, 7.5333, 11.2021, 41.4509, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 5, 67.27, 37, 10.9297, 42.8872, 84.9023, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CX', NULL, 4.36, 35, 0.1590, 4.0341, 4.6804, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 35, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 2, 0.00, 35, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 3, 23.54, 35, 8.4634, 10.5841, 44.4592, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 4, 17.20, 35, 9.0754, 5.3833, 43.1316, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 5, 59.26, 35, 9.7980, 38.9377, 76.8460, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CX', NULL, 4.33, 37, 0.3068, 3.7043, 4.9488, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 1, 6.46, 37, 6.4200, 0.7938, 37.3358, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 2, 2.83, 37, 2.1720, 0.5847, 12.6225, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 3, 9.78, 37, 7.0781, 2.0863, 35.5485, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 4, 13.45, 37, 7.5179, 4.0263, 36.5409, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 5, 67.48, 37, 12.0021, 40.6287, 86.2829, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CX', NULL, 4.29, 36, 0.1608, 3.9590, 4.6119, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 36, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 2, 0.76, 36, 0.7880, 0.0919, 5.9998, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 3, 17.61, 36, 9.6768, 5.2301, 45.2887, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 4, 33.95, 36, 11.3271, 15.5669, 58.9051, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 5, 47.68, 36, 9.8498, 29.0166, 67.0087, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CX', NULL, 4.16, 37, 0.2095, 3.7384, 4.5883, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 2, 16.11, 37, 6.3963, 6.8495, 33.3983, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 3, 6.53, 37, 4.9275, 1.3383, 26.4321, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 4, 22.29, 37, 6.6149, 11.6738, 38.3556, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 5, 55.08, 37, 9.8242, 35.4022, 73.2857, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CX', NULL, 4.70, 36, 0.1453, 4.4100, 4.9997, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 1, 0.00, 36, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 2, 3.56, 36, 3.6393, 0.4292, 24.0730, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 3, 0.00, 36, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 4, 18.82, 36, 9.5123, 6.1481, 45.0718, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 5, 77.61, 36, 10.2062, 51.2695, 91.9519, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CX', NULL, 3.86, 37, 0.2012, 3.4477, 4.2640, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 2, 13.21, 37, 6.9968, 4.2293, 34.4161, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 3, 16.03, 37, 7.9696, 5.4339, 38.8127, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 4, 42.72, 37, 16.1017, 16.4116, 73.9075, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 5, 28.04, 37, 11.7094, 10.7220, 55.8344, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CX', NULL, 3.24, 36, 0.1964, 2.8368, 3.6344, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 1, 0.54, 36, 0.5634, 0.0653, 4.3484, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 2, 17.63, 36, 8.2583, 6.3222, 40.4418, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 3, 50.13, 36, 14.9486, 22.9941, 77.1916, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 4, 21.11, 36, 9.0681, 8.1380, 44.6975, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 5, 10.58, 36, 7.4935, 2.3171, 37.1335, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CX', NULL, 1.46, 37, 0.1273, 1.1992, 1.7155, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 1, 63.08, 37, 8.5866, 44.7151, 78.3005, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 2, 28.11, 37, 7.9327, 14.9958, 46.4362, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 3, 8.81, 37, 6.2253, 1.9672, 31.7452, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CX', NULL, 4.82, 37, 0.1048, 4.6119, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 1, 2.15, 37, 2.1730, 0.2700, 15.1421, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 2, 0.48, 37, 0.5003, 0.0588, 3.8506, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 3, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 4, 7.51, 37, 5.0821, 1.8095, 26.3647, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 5, 89.85, 37, 5.6779, 71.4632, 96.9053, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CX', NULL, 2.19, 37, 0.3752, 1.4288, 2.9506, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 1, 51.64, 37, 9.3413, 33.3398, 69.5166, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 2, 18.76, 37, 5.6155, 9.8587, 32.7733, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 3, 0.48, 37, 0.5026, 0.0583, 3.8859, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 4, 17.22, 37, 7.5801, 6.6047, 37.9485, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 5, 11.90, 37, 7.9995, 2.7928, 38.8311, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CX', NULL, 2.12, 37, 0.2652, 1.5819, 2.6578, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 1, 41.08, 37, 9.1211, 24.5109, 59.9562, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 2, 26.58, 37, 10.9021, 10.4409, 52.9197, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 3, 17.05, 37, 9.0371, 5.3253, 42.8942, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 4, 9.85, 37, 6.0162, 2.6914, 30.1544, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 5, 5.44, 37, 4.6917, 0.8964, 26.7835, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CX', NULL, 1.84, 37, 0.2326, 1.3655, 2.3092, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 1, 52.68, 37, 9.4605, 34.0228, 70.6219, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 2, 31.90, 37, 10.6121, 14.8123, 55.7793, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 3, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 4, 9.85, 37, 6.0162, 2.6914, 30.1544, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 5, 5.57, 37, 4.7023, 0.9538, 26.5517, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CX', NULL, 1.26, 37, 0.1595, 1.0000, 1.5786, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 1, 86.88, 37, 6.8056, 66.3639, 95.6979, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 2, 5.20, 37, 3.3433, 1.3665, 17.8350, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 3, 3.43, 37, 3.4845, 0.4199, 23.0585, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 4, 4.48, 37, 4.5319, 0.5459, 28.6452, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CX', NULL, 3.13, 37, 0.2601, 2.6067, 3.6619, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 1, 19.78, 37, 9.2835, 6.9971, 44.6799, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 2, 11.20, 37, 5.8833, 3.6581, 29.5090, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 3, 29.73, 37, 7.9029, 16.4181, 47.6763, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 4, 14.42, 37, 8.4451, 4.0369, 40.3009, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 5, 24.88, 37, 7.1924, 13.1740, 41.9549, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CX', NULL, 2.67, 36, 0.2463, 2.1685, 3.1683, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 1, 4.88, 36, 2.8485, 1.4514, 15.1347, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 2, 55.23, 36, 14.5025, 27.2718, 80.2258, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 3, 8.08, 36, 5.3198, 2.0143, 27.3383, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 4, 31.82, 36, 11.9516, 13.2307, 58.8119, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 5, 0.00, 36, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CX', NULL, 2.08, 37, 0.2817, 1.5103, 2.6530, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 1, 44.72, 37, 10.1224, 26.0700, 64.9878, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 2, 28.85, 37, 7.6436, 16.0037, 46.3190, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 3, 8.94, 37, 5.0557, 2.7094, 25.7030, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 4, 8.52, 37, 4.8372, 2.5798, 24.6931, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 5, 8.97, 37, 5.3430, 2.5453, 27.0874, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CX', NULL, 1.59, 36, 0.2173, 1.1536, 2.0357, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 1, 66.14, 36, 12.3035, 39.0363, 85.6290, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 2, 15.95, 36, 8.6692, 4.8556, 41.3583, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 3, 11.21, 36, 6.9065, 2.9971, 34.0547, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 4, 5.71, 36, 4.3217, 1.1737, 23.6010, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 5, 0.99, 36, 1.0342, 0.1166, 7.8626, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CX', NULL, 1.36, 37, 0.1770, 1.0008, 1.7187, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 1, 77.95, 37, 10.0897, 51.8060, 92.0819, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 2, 14.52, 37, 8.3308, 4.1701, 39.8551, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 3, 2.09, 37, 2.1474, 0.2542, 15.1915, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 4, 4.48, 37, 4.5319, 0.5459, 28.6452, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 5, 0.96, 37, 0.9979, 0.1137, 7.5644, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CX', NULL, 1.41, 37, 0.1521, 1.1006, 1.7174, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 1, 67.76, 37, 11.6731, 41.5583, 86.1338, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 2, 24.53, 37, 10.0114, 9.7946, 49.3254, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 3, 6.75, 37, 4.8583, 1.4906, 25.7235, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 4, 0.96, 37, 0.9979, 0.1137, 7.5644, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CX', NULL, 1.20, 37, 0.1138, 1.0000, 1.4305, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 1, 86.60, 37, 6.9612, 65.6873, 95.6140, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 2, 6.83, 37, 4.3816, 1.7813, 22.8528, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 3, 6.58, 37, 5.0849, 1.2965, 27.3866, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CX', NULL, 1.12, 37, 0.0846, 1.0000, 1.2899, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 1, 91.60, 37, 5.8433, 70.0360, 98.0725, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 2, 4.97, 37, 4.5841, 0.7238, 27.2540, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 3, 3.43, 37, 3.4845, 0.4199, 23.0585, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CX', NULL, 1.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 1, 100.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CX', NULL, 1.37, 37, 0.2229, 1.0000, 1.8239, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 1, 85.07, 37, 7.2014, 64.3392, 94.7323, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 2, 7.52, 37, 5.0401, 1.8343, 26.1238, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 3, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 5, 7.42, 37, 5.5196, 1.5447, 29.0263, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CX', NULL, 1.14, 37, 0.0868, 1.0000, 1.3198, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 1, 85.62, 37, 8.6827, 58.7547, 96.1399, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 2, 14.38, 37, 8.6827, 3.8601, 41.2453, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 3, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CX', NULL, 1.33, 37, 0.1309, 1.0602, 1.5912, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 1, 70.86, 37, 11.5007, 44.0053, 88.2709, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 2, 25.71, 37, 10.8390, 9.8641, 52.2413, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 3, 3.43, 37, 3.4845, 0.4199, 23.0585, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CX', NULL, 1.38, 37, 0.1795, 1.0202, 1.7482, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 1, 79.80, 37, 9.4194, 54.7030, 92.8152, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 2, 8.85, 37, 6.6966, 1.7730, 34.3295, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 3, 4.48, 37, 4.5319, 0.5459, 28.6452, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 4, 6.87, 37, 4.5041, 1.7359, 23.5243, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CX', NULL, 1.23, 37, 0.1148, 1.0000, 1.4605, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 1, 82.68, 37, 7.8790, 60.9996, 93.5790, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 2, 11.88, 37, 6.0255, 4.0255, 30.2266, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 3, 5.44, 37, 4.6917, 0.8964, 26.7835, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CX', NULL, 4.18, 36, 0.1535, 3.8687, 4.4921, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 36, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 2, 2.97, 36, 3.0388, 0.3572, 20.6774, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 3, 14.52, 36, 7.5025, 4.7413, 36.6874, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 4, 44.03, 36, 10.1799, 25.3745, 64.5315, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 5, 38.49, 36, 9.2914, 22.0029, 58.1258, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CX', NULL, 2.13, 37, 0.1836, 1.7555, 2.5003, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 1, 18.94, 37, 7.3009, 8.1815, 38.0044, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 2, 58.45, 37, 8.5299, 40.8306, 74.1482, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 3, 16.41, 37, 7.8596, 5.7855, 38.5564, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 4, 3.26, 37, 3.3336, 0.3943, 22.3172, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 5, 2.93, 37, 3.0021, 0.3546, 20.4132, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CX', NULL, 1.06, 37, 0.0473, 1.0000, 1.1522, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 1, 94.38, 37, 4.7333, 73.3184, 99.0362, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 2, 5.62, 37, 4.7333, 0.9638, 26.6816, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CX', NULL, 1.72, 37, 0.1031, 1.5084, 1.9264, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 1, 32.74, 37, 8.0469, 18.8306, 50.5287, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 2, 62.78, 37, 8.0235, 45.6674, 77.1886, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 3, 4.48, 37, 4.5319, 0.5459, 28.6452, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CX', NULL, 1.13, 37, 0.0715, 1.0000, 1.2780, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 1, 86.70, 37, 7.1458, 64.9732, 95.8155, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 2, 13.30, 37, 7.1458, 4.1845, 35.0268, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CX', NULL, 1.43, 36, 0.2276, 1.0000, 1.8953, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 1, 85.76, 36, 6.5899, 66.8181, 94.7380, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 2, 1.29, 36, 0.8365, 0.3450, 4.7219, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 3, 4.88, 36, 4.8608, 0.6081, 30.0705, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 36, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 5, 8.07, 36, 5.8513, 1.7398, 30.3282, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CX', NULL, 2.17, 35, 0.2852, 1.5889, 2.7482, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 1, 43.83, 35, 8.6492, 27.6476, 61.4415, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 2, 29.46, 35, 11.6180, 11.8239, 56.5384, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 3, 5.88, 35, 4.2309, 1.3019, 22.8092, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 4, 7.69, 35, 6.6459, 1.2254, 35.8428, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 5, 13.15, 35, 6.5593, 4.4982, 32.7256, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CX', NULL, 1.47, 37, 0.1142, 1.2343, 1.6974, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 1, 57.90, 37, 8.7383, 39.9321, 73.9965, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 2, 37.61, 37, 7.9655, 23.2478, 54.5498, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 3, 4.48, 37, 4.5319, 0.5459, 28.6452, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CX', NULL, 2.55, 37, 0.2556, 2.0348, 3.0714, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 1, 24.08, 37, 9.0918, 10.3653, 46.5107, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 2, 32.99, 37, 8.4003, 18.5512, 51.5479, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 3, 10.98, 37, 7.8860, 2.3428, 38.7844, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 4, 27.48, 37, 11.3121, 10.6999, 54.5068, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 5, 4.48, 37, 4.5319, 0.5459, 28.6452, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CX', NULL, 1.77, 37, 0.2903, 1.1832, 2.3608, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 1, 60.68, 37, 13.1253, 33.5868, 82.4856, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 2, 18.90, 37, 8.8065, 6.7752, 42.7687, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 3, 6.39, 37, 4.7973, 1.3243, 25.7717, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 4, 10.60, 37, 7.3941, 2.3763, 36.5931, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 5, 3.43, 37, 3.4845, 0.4199, 23.0585, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CX', NULL, 1.21, 37, 0.1391, 1.0000, 1.4877, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 1, 86.34, 37, 8.2248, 60.5750, 96.2977, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 2, 6.98, 37, 5.0124, 1.5425, 26.4254, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 3, 6.46, 37, 6.4200, 0.7938, 37.3358, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 4, 0.22, 37, 0.2302, 0.0269, 1.8018, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CX', NULL, 3.02, 37, 0.2647, 2.4869, 3.5605, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 1, 14.08, 37, 7.2938, 4.6016, 35.7576, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 2, 32.97, 37, 7.9279, 19.1956, 50.4460, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 3, 8.44, 37, 5.2616, 2.2675, 26.8308, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 4, 25.53, 37, 11.4327, 9.1949, 53.7190, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 5, 18.98, 37, 9.2817, 6.4444, 44.3450, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CX', NULL, 4.75, 37, 0.0688, 4.6117, 4.8907, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 2, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 3, 0.73, 37, 0.7521, 0.0888, 5.7058, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 4, 23.42, 37, 6.8254, 12.3840, 39.8212, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 5, 75.85, 37, 6.8107, 59.6397, 86.9740, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CX', NULL, 4.59, 36, 0.1104, 4.3624, 4.8106, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 36, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 2, 0.00, 36, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 3, 13.70, 36, 6.2608, 5.1408, 31.7482, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 4, 13.95, 36, 6.4561, 5.1571, 32.5710, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 5, 72.35, 36, 6.5227, 57.4446, 83.5338, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CX', NULL, 4.95, 36, 0.0365, 4.8802, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 1, 0.00, 36, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 2, 0.00, 36, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 3, 0.00, 36, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 4, 4.57, 36, 3.6475, 0.8698, 20.7319, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 5, 95.43, 36, 3.6475, 79.2681, 99.1302, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CX', NULL, 2.23, 37, 0.2128, 1.8017, 2.6648, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 1, 38.76, 37, 8.8670, 22.8784, 57.4462, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 2, 18.17, 37, 8.7032, 6.3455, 42.1232, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 3, 24.06, 37, 7.5659, 12.0332, 42.3209, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 4, 19.01, 37, 6.3778, 9.2024, 35.2259, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CX', NULL, 4.47, 37, 0.1451, 4.1757, 4.7640, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 2, 2.05, 37, 2.0524, 0.2625, 14.2645, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 3, 11.57, 37, 5.6148, 4.1197, 28.4784, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 4, 23.73, 37, 6.7060, 12.7987, 39.7466, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 5, 62.65, 37, 8.1049, 45.3839, 77.2026, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CX', NULL, 3.37, 37, 0.2256, 2.9101, 3.8251, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 1, 10.18, 37, 5.9637, 2.9322, 29.8464, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 2, 5.81, 37, 3.4623, 1.6794, 18.2047, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 3, 37.21, 37, 8.9272, 21.4460, 56.2575, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 4, 30.67, 37, 11.2018, 13.1948, 56.2890, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 5, 16.13, 37, 8.8224, 4.8742, 41.9222, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CX', NULL, 4.80, 37, 0.1027, 4.5902, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 2, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 3, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 4, 20.16, 37, 10.2684, 6.4748, 47.9385, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 5, 79.84, 37, 10.2684, 52.0615, 93.5252, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CX', NULL, 3.57, 36, 0.2769, 3.0125, 4.1367, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 1, 17.12, 36, 8.1103, 6.0807, 39.7299, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 2, 3.37, 36, 2.4861, 0.7335, 14.1151, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 3, 17.07, 36, 7.5640, 6.5043, 37.8494, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 4, 29.81, 36, 11.3267, 12.3985, 56.0367, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 5, 32.63, 36, 9.0448, 17.3606, 52.7548, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CX', NULL, 4.16, 37, 0.1408, 3.8724, 4.4434, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 2, 3.41, 37, 3.4751, 0.4149, 23.0604, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 3, 14.38, 37, 7.3766, 4.7459, 36.1471, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 4, 45.21, 37, 10.1764, 26.3967, 65.4966, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 5, 37.00, 37, 7.9971, 22.6524, 54.0794, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CX', NULL, 1.35, 37, 0.1499, 1.0421, 1.6503, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 1, 78.12, 37, 8.0310, 57.9247, 90.2498, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 2, 13.33, 37, 6.6646, 4.5579, 33.1341, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 3, 6.46, 37, 6.4200, 0.7938, 37.3358, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 5, 2.09, 37, 2.1474, 0.2542, 15.1915, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.4', 'CT', NULL, 1.09, 37, 0.0525, 1.0000, 1.1955, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.4', 'CTP', 1, 91.58, 37, 5.1340, 73.8125, 97.6746, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.4', 'CTP', 2, 7.93, 37, 5.0632, 2.0689, 26.0080, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.4', 'CTP', 3, 0.48, 37, 0.5026, 0.0583, 3.8859, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.8', 'CT', NULL, 2.86, 37, 0.0725, 2.7131, 3.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.8', 'CTP', 1, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.8', 'CTP', 2, 13.99, 37, 7.2506, 4.5724, 35.5705, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.8', 'CTP', 3, 86.01, 37, 7.2506, 64.4295, 95.4276, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CX', NULL, 2.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 2, 25.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 3, 55.56, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 4, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CX', NULL, 4.74, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 2, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 3, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 4, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 5, 81.48, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CX', NULL, 5.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 2, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 5, 100.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CX', NULL, 3.44, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 2, 22.22, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 3, 25.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 4, 37.04, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 5, 14.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CX', NULL, 4.67, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 2, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 4, 33.33, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 5, 66.67, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CX', NULL, 4.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 2, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 3, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 4, 37.04, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 5, 51.85, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CX', NULL, 4.78, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 2, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 3, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 4, 14.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 5, 81.48, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CX', NULL, 3.85, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 2, 22.22, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 3, 14.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 4, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 5, 44.44, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CX', NULL, 4.22, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 2, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 3, 14.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 4, 37.04, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 5, 44.44, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CX', NULL, 2.63, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 1, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 2, 40.74, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 3, 29.63, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 4, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 5, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CX', NULL, 3.85, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 2, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 3, 22.22, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 4, 37.04, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 5, 29.63, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CX', NULL, 3.04, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 1, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 2, 25.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 3, 40.74, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 4, 22.22, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 5, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CX', NULL, 2.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 1, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 2, 59.26, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 3, 22.22, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 4, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 5, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CX', NULL, 1.19, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 1, 81.48, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 2, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CX', NULL, 4.74, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 1, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 2, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 4, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 5, 85.19, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CX', NULL, 2.15, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 1, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 2, 55.56, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 3, 22.22, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 5, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CX', NULL, 2.23, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 1, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 2, 61.54, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 3, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CX', NULL, 2.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 1, 25.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 2, 48.15, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 3, 25.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CX', NULL, 1.26, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 1, 81.48, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 2, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 3, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CX', NULL, 2.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 1, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 2, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 3, 37.04, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 4, 33.33, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CX', NULL, 2.78, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 2, 37.04, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 3, 51.85, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 4, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 5, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CX', NULL, 2.15, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 1, 34.62, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 2, 34.62, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 3, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 4, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 5, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CX', NULL, 1.63, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 1, 48.15, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 2, 48.15, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 5, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CX', NULL, 1.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 1, 62.96, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 2, 29.63, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 3, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 5, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CX', NULL, 1.59, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 1, 48.15, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 2, 44.44, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 3, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CX', NULL, 1.37, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 1, 66.67, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 2, 29.63, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 3, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CX', NULL, 1.19, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 1, 92.59, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 2, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 5, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CX', NULL, 1.15, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 1, 96.30, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 2, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 5, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CX', NULL, 1.04, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 1, 96.30, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 2, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CX', NULL, 1.48, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 1, 66.67, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 2, 25.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 3, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 5, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CX', NULL, 1.37, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 1, 74.07, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 2, 14.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 3, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CX', NULL, 1.38, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 1, 73.08, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 2, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 4, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CX', NULL, 1.48, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 1, 66.67, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 2, 22.22, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 3, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 4, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CX', NULL, 3.89, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 2, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 3, 14.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 4, 59.26, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 5, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CX', NULL, 2.31, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 1, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 2, 65.38, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 3, 26.92, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 4, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CX', NULL, 1.38, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 1, 73.08, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 2, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 5, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CX', NULL, 1.89, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 1, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 2, 74.07, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 3, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CX', NULL, 1.30, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 1, 77.78, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 2, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 4, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CX', NULL, 1.22, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 1, 85.19, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 2, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 4, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CX', NULL, 1.73, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 1, 57.69, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 2, 26.92, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 5, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CX', NULL, 1.33, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 1, 74.07, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 2, 22.22, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 4, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CX', NULL, 2.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 1, 44.44, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 2, 25.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 3, 14.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 4, 14.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CX', NULL, 1.89, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 1, 25.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 2, 66.67, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 3, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 5, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CX', NULL, 1.37, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 1, 77.78, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 2, 14.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 3, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 5, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CX', NULL, 2.15, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 1, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 2, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 3, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CX', NULL, 3.96, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 2, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 3, 14.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 4, 62.96, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 5, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CX', NULL, 3.67, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 2, 14.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 3, 29.63, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 4, 29.63, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 5, 25.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CX', NULL, 4.37, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 2, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 3, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 4, 40.74, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 5, 48.15, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CX', NULL, 1.56, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 1, 51.85, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 2, 40.74, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 3, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 5, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CX', NULL, 3.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 1, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 2, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 3, 25.93, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 4, 33.33, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 5, 22.22, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CX', NULL, 1.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 1, 62.96, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 2, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 4, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 5, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CX', NULL, 4.44, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 2, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 3, 7.41, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 4, 40.74, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 5, 51.85, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CX', NULL, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 2, 14.81, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 3, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 4, 48.15, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 5, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CX', NULL, 3.48, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 1, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 2, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 3, 40.74, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 4, 37.04, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 5, 11.11, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CX', NULL, 1.19, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 1, 92.59, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 2, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 3, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 4, 0.00, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 5, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.4', 'CT', NULL, 1.08, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.4', 'CTP', 1, 92.31, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.4', 'CTP', 2, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.4', 'CTP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.8', 'CT', NULL, 2.74, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.8', 'CTP', 1, 3.70, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.8', 'CTP', 2, 18.52, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.8', 'CTP', 3, 77.78, 27, NULL, NULL, NULL, NULL, NULL, '2021-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CX', NULL, 2.46, 22, 0.4040, 1.6242, 3.3044, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 1, 39.37, 22, 14.9196, 15.0371, 70.4329, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 2, 12.05, 22, 10.7006, 1.6492, 52.8029, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 3, 14.64, 22, 10.6563, 2.8278, 50.2570, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 4, 30.68, 22, 14.1391, 9.9953, 63.8175, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 5, 3.27, 22, 3.2765, 0.3899, 22.5776, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CX', NULL, 4.76, 22, 0.2051, 4.3349, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 1, 0.33, 22, 0.3363, 0.0388, 2.7183, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 3, 11.11, 22, 10.2144, 1.4339, 51.7831, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 4, 0.33, 22, 0.3363, 0.0388, 2.7183, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 5, 88.23, 22, 10.2409, 49.0846, 98.3144, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CX', NULL, 4.86, 22, 0.1058, 4.6426, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 1, 0.33, 22, 0.3363, 0.0388, 2.7183, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 2, 0.33, 22, 0.3363, 0.0388, 2.7183, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 3, 0.33, 22, 0.3363, 0.0388, 2.7183, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 4, 10.78, 22, 10.2177, 1.3099, 52.3909, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 5, 88.23, 22, 10.2409, 49.0846, 98.3144, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CX', NULL, 4.01, 22, 0.4491, 3.0767, 4.9444, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 1, 10.49, 22, 9.9826, 1.2681, 51.6747, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 2, 10.78, 22, 10.2177, 1.3099, 52.3909, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 3, 0.21, 22, 0.2192, 0.0247, 1.7969, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 4, 24.21, 22, 11.4838, 8.0002, 54.0024, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 5, 54.30, 22, 14.0522, 26.7921, 79.4143, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CX', NULL, 4.86, 21, 0.1072, 4.6398, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 4, 13.65, 21, 10.7249, 2.3135, 51.3349, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 5, 86.35, 21, 10.7249, 48.6651, 97.6865, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CX', NULL, 4.63, 22, 0.2297, 4.1566, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 3, 12.43, 22, 11.4887, 1.5551, 56.0403, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 4, 11.71, 22, 6.5520, 3.4259, 33.1309, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 5, 75.87, 22, 12.3846, 43.5045, 92.7715, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CX', NULL, 4.62, 21, 0.1743, 4.2595, 4.9868, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 1, 3.42, 21, 3.4832, 0.3921, 24.1961, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 2, 3.42, 21, 3.4832, 0.3921, 24.1961, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 4, 13.72, 21, 10.6382, 2.3826, 50.8946, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 5, 79.43, 21, 11.0560, 48.4888, 94.0627, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CX', NULL, 4.49, 22, 0.1637, 4.1528, 4.8338, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 2, 2.00, 22, 1.7180, 0.3291, 11.2115, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 3, 8.06, 22, 4.9092, 2.1609, 25.7984, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 4, 28.55, 22, 11.5829, 10.9299, 56.5519, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 5, 61.39, 22, 12.4789, 34.7243, 82.6141, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CX', NULL, 4.48, 22, 0.1551, 4.1534, 4.7985, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 2, 2.00, 22, 1.7180, 0.3291, 11.2115, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 3, 5.12, 22, 3.6323, 1.1252, 20.3549, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 4, 36.17, 22, 12.4423, 15.5947, 63.4782, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 5, 56.71, 22, 12.7737, 30.7466, 79.4481, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CX', NULL, 4.54, 22, 0.1470, 4.2380, 4.8494, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 2, 3.12, 22, 3.1608, 0.3632, 22.1040, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 4, 36.28, 22, 12.3371, 15.8020, 63.3346, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 5, 60.60, 22, 12.3907, 34.3311, 81.9053, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CX', NULL, 4.33, 22, 0.2905, 3.7242, 4.9325, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 2, 12.78, 22, 10.1660, 2.1511, 49.4033, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 3, 3.44, 22, 3.1914, 0.4824, 20.7894, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 4, 21.94, 22, 13.6028, 5.1138, 59.4498, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 5, 61.84, 22, 13.9531, 32.1475, 84.7116, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CX', NULL, 3.35, 22, 0.2762, 2.7716, 3.9205, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 2, 20.53, 22, 11.2476, 5.8025, 52.0035, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 3, 35.12, 22, 14.5717, 12.5243, 67.1761, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 4, 33.57, 22, 13.5549, 12.4908, 64.1401, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 5, 10.78, 22, 10.2177, 1.3099, 52.3909, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CX', NULL, 3.24, 22, 0.1702, 2.8851, 3.5932, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 2, 8.60, 22, 4.9576, 2.4703, 25.8875, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 3, 58.89, 22, 15.5298, 27.3972, 84.4682, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 4, 32.51, 22, 15.5212, 9.9621, 67.7157, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CX', NULL, 1.62, 22, 0.2168, 1.1734, 2.0750, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 1, 49.30, 22, 15.5500, 21.0502, 77.9996, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 2, 38.98, 22, 15.6002, 14.0414, 71.4213, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 3, 11.72, 22, 10.7156, 1.5166, 53.3622, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CX', NULL, 4.39, 22, 0.3393, 3.6810, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 1, 3.44, 22, 3.1914, 0.4824, 20.7894, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 2, 14.66, 22, 10.7777, 2.7857, 50.7479, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 3, 1.67, 22, 1.6759, 0.2040, 12.4015, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 4, 0.21, 22, 0.2192, 0.0247, 1.7969, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 5, 80.01, 22, 11.0469, 48.7633, 94.3905, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CX', NULL, 2.12, 22, 0.4459, 1.1891, 3.0437, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 1, 55.11, 22, 13.9799, 27.4850, 79.9021, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 2, 18.36, 22, 12.1585, 3.9961, 54.8532, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 3, 5.48, 22, 4.0190, 1.1423, 22.5440, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 4, 1.89, 22, 1.6975, 0.2841, 11.4705, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 5, 19.17, 22, 11.3211, 4.9318, 52.0088, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CX', NULL, 2.93, 22, 0.4013, 2.1001, 3.7690, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 1, 29.12, 22, 12.0998, 10.8229, 58.1628, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 2, 5.44, 22, 5.3338, 0.6611, 33.2047, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 3, 27.82, 22, 13.6227, 8.5919, 61.2384, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 4, 18.13, 22, 11.7185, 4.1138, 53.3515, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 5, 19.49, 22, 11.3415, 5.1121, 52.1152, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CX', NULL, 1.79, 22, 0.2513, 1.2715, 2.3169, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 1, 53.80, 22, 14.0818, 26.3859, 79.0900, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 2, 19.54, 22, 11.3751, 5.1155, 52.2317, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 3, 23.39, 22, 12.3805, 6.7680, 56.2289, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 5, 3.27, 22, 2.5605, 0.6255, 15.3912, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CX', NULL, 1.93, 22, 0.4093, 1.0758, 2.7784, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 1, 67.05, 22, 13.7333, 35.8434, 88.1157, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 2, 4.27, 22, 3.3224, 0.8139, 19.4808, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 3, 0.21, 22, 0.2192, 0.0247, 1.7969, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 4, 25.85, 22, 13.6078, 7.3778, 60.4110, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 5, 2.62, 22, 2.3532, 0.3922, 15.4950, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CX', NULL, 3.48, 22, 0.4473, 2.5512, 4.4116, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 1, 27.52, 22, 11.3398, 10.4275, 55.3274, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 2, 0.66, 22, 0.6726, 0.0772, 5.3450, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 3, 15.20, 22, 11.2031, 2.8562, 52.2119, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 4, 9.41, 22, 6.4089, 2.1285, 33.1581, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 5, 47.21, 22, 14.0855, 21.6382, 74.3417, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CX', NULL, 3.20, 22, 0.2981, 2.5767, 3.8167, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 1, 3.12, 22, 3.1608, 0.3632, 22.1040, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 2, 33.73, 22, 12.1248, 14.1419, 61.1261, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 3, 14.31, 22, 10.3820, 2.7918, 49.2730, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 4, 38.06, 22, 14.8964, 14.1734, 69.5752, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 5, 10.78, 22, 10.2177, 1.3099, 52.3909, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CX', NULL, 1.80, 22, 0.2285, 1.3202, 2.2704, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 1, 47.36, 22, 14.8859, 20.6278, 75.6940, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 2, 32.79, 22, 14.0973, 11.4253, 64.8527, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 3, 16.09, 22, 10.0748, 3.9013, 47.5101, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 4, 0.49, 22, 0.5084, 0.0576, 4.0942, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 5, 3.27, 22, 2.5605, 0.6255, 15.3912, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CX', NULL, 2.33, 21, 0.3793, 1.5393, 3.1219, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 1, 30.05, 21, 12.4394, 11.1137, 59.6185, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 2, 41.67, 21, 15.6907, 15.6679, 73.3041, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 3, 6.94, 21, 4.3473, 1.7987, 23.2934, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 4, 7.85, 21, 5.7826, 1.5822, 31.1010, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 5, 13.49, 21, 10.7149, 2.2462, 51.4207, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CX', NULL, 1.63, 21, 0.1681, 1.2764, 1.9776, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 1, 48.52, 21, 15.1121, 21.0625, 76.9043, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 2, 42.61, 21, 15.6291, 16.3719, 73.7983, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 3, 6.50, 21, 4.3083, 1.5610, 23.3701, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 4, 2.36, 21, 2.3946, 0.2767, 17.4226, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CX', NULL, 1.64, 22, 0.2120, 1.1967, 2.0784, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 1, 61.89, 22, 14.1112, 31.8776, 84.9272, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 2, 26.03, 22, 14.0757, 7.1452, 61.6776, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 3, 4.46, 22, 3.7133, 0.7584, 22.2223, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 4, 1.67, 22, 1.6759, 0.2040, 12.4015, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 5, 5.95, 22, 4.0195, 1.3977, 21.9872, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CX', NULL, 1.19, 22, 0.0988, 1.0000, 1.3950, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 1, 88.30, 22, 5.8530, 69.9081, 96.0780, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 2, 5.12, 22, 3.6323, 1.1252, 20.3549, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 3, 6.26, 22, 4.3610, 1.4033, 23.8525, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 5, 0.33, 22, 0.3363, 0.0388, 2.7183, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CX', NULL, 1.05, 22, 0.0326, 1.0000, 1.1151, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 1, 97.13, 22, 2.0034, 88.3614, 99.3418, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 2, 1.67, 22, 1.6759, 0.2040, 12.4015, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 3, 0.54, 22, 0.4115, 0.1104, 2.6005, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 4, 0.66, 22, 0.6726, 0.0772, 5.3450, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CX', NULL, 1.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 1, 100.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CX', NULL, 1.21, 22, 0.1293, 1.0000, 1.4812, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 1, 78.77, 22, 12.9276, 42.6403, 94.8750, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 2, 21.23, 22, 12.9276, 5.1250, 57.3597, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CX', NULL, 1.31, 22, 0.1518, 1.0000, 1.6232, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 1, 82.27, 22, 7.8645, 60.1912, 93.4357, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 2, 9.30, 22, 5.2448, 2.7366, 27.2005, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 3, 6.14, 22, 5.3723, 0.9346, 31.2396, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 5, 2.29, 22, 2.3169, 0.2709, 16.8048, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CX', NULL, 1.34, 22, 0.1322, 1.0633, 1.6130, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 1, 69.81, 22, 12.8844, 39.3364, 89.1803, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 2, 27.65, 22, 12.9104, 9.0814, 59.3942, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 3, 2.00, 22, 1.7180, 0.3291, 11.2115, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 5, 0.54, 22, 0.4115, 0.1104, 2.6005, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CX', NULL, 1.36, 22, 0.1691, 1.0093, 1.7127, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 1, 83.38, 22, 7.7409, 61.0918, 94.1293, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 2, 7.32, 22, 5.5720, 1.4131, 30.3483, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 3, 2.38, 22, 1.7906, 0.4878, 10.8037, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 4, 3.64, 22, 3.6382, 0.4359, 24.6064, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 5, 3.27, 22, 2.5605, 0.6255, 15.3912, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CX', NULL, 1.56, 21, 0.1853, 1.1707, 1.9438, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 1, 59.94, 21, 14.1092, 30.5165, 83.5964, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 2, 29.47, 21, 13.6913, 9.5657, 62.2797, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 3, 7.88, 21, 5.1219, 1.9280, 27.1490, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 4, 0.34, 21, 0.3482, 0.0397, 2.8350, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 5, 2.37, 21, 2.3977, 0.2773, 17.4373, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CX', NULL, 3.09, 22, 0.3018, 2.4584, 3.7137, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 1, 10.82, 22, 9.9807, 1.3914, 51.0479, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 2, 22.26, 22, 12.9569, 5.6896, 57.6029, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 3, 24.08, 22, 14.2247, 5.9155, 61.5339, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 4, 33.19, 22, 12.5481, 13.2829, 61.7118, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 5, 9.65, 22, 6.0156, 2.4819, 30.9612, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CX', NULL, 2.90, 22, 0.2636, 2.3556, 3.4520, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 2, 42.85, 22, 13.5428, 19.1821, 70.3073, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 3, 34.74, 22, 14.2486, 12.5956, 66.2989, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 4, 11.59, 22, 8.9916, 2.0703, 44.8435, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 5, 10.82, 22, 9.9807, 1.3914, 51.0479, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CX', NULL, 1.32, 22, 0.1338, 1.0402, 1.5967, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 1, 72.73, 22, 11.9236, 43.3086, 90.3017, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 2, 24.98, 22, 11.8258, 8.2269, 55.2971, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 4, 2.29, 22, 2.3169, 0.2709, 16.8048, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CX', NULL, 2.53, 21, 0.2010, 2.1107, 2.9493, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 1, 3.28, 21, 3.2876, 0.3885, 22.7604, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 2, 53.26, 21, 13.3273, 27.1676, 77.6846, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 3, 30.64, 21, 13.6011, 10.4139, 62.6677, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 4, 12.82, 21, 10.1989, 2.1451, 49.6629, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CX', NULL, 1.78, 22, 0.2857, 1.1850, 2.3732, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 1, 48.63, 22, 14.0626, 22.6985, 75.3231, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 2, 37.93, 22, 14.0994, 14.9598, 67.9833, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 3, 0.33, 22, 0.3363, 0.0388, 2.7183, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 4, 13.11, 22, 10.1670, 2.3022, 49.1234, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CX', NULL, 1.17, 22, 0.1043, 1.0000, 1.3851, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 1, 90.71, 22, 4.8927, 74.4843, 97.0263, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 2, 6.68, 22, 4.1575, 1.7553, 22.2723, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 4, 0.33, 22, 0.3363, 0.0388, 2.7183, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 5, 2.29, 22, 2.3169, 0.2709, 16.8048, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CX', NULL, 2.42, 22, 0.3598, 1.6679, 3.1643, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 1, 31.94, 22, 12.3649, 12.5745, 60.5035, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 2, 30.11, 22, 13.8970, 9.8346, 62.9756, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 3, 3.33, 22, 3.1783, 0.4394, 21.1720, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 4, 33.64, 22, 14.3623, 11.7377, 65.8927, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 5, 0.98, 22, 1.0089, 0.1153, 7.8841, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CX', NULL, 1.96, 22, 0.2619, 1.4170, 2.5061, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 1, 31.94, 22, 12.3649, 12.5745, 60.5035, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 2, 53.06, 22, 14.1017, 25.8308, 78.5860, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 3, 1.89, 22, 1.6975, 0.2841, 11.4705, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 4, 13.11, 22, 10.1670, 2.3022, 49.1234, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CX', NULL, 2.42, 22, 0.2898, 1.8196, 3.0252, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 1, 14.05, 22, 10.5700, 2.5799, 50.2277, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 2, 58.85, 22, 14.9625, 28.3486, 83.7877, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 3, 5.28, 22, 3.6631, 1.2021, 20.3592, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 4, 14.45, 22, 10.2309, 2.9335, 48.5670, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 5, 7.37, 22, 5.0506, 1.6785, 27.0403, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CX', NULL, 3.06, 22, 0.5177, 1.9845, 4.1378, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 1, 40.38, 22, 14.2626, 16.4946, 69.8941, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 2, 5.44, 22, 5.3338, 0.6611, 33.2047, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 4, 16.07, 22, 10.9819, 3.4001, 51.0066, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 5, 38.12, 22, 13.0586, 16.3032, 66.0774, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CX', NULL, 1.18, 22, 0.1063, 1.0000, 1.3981, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 1, 91.02, 22, 4.6252, 75.7550, 97.0484, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 2, 5.49, 22, 3.6834, 1.3126, 20.2661, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 3, 0.87, 22, 0.7189, 0.1540, 4.7381, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 5, 2.62, 22, 2.3532, 0.3922, 15.4950, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CX', NULL, 2.52, 22, 0.3843, 1.7225, 3.3208, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 1, 36.21, 22, 14.2628, 13.5837, 67.2145, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 2, 12.24, 22, 9.4964, 2.1712, 46.7179, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 3, 20.85, 22, 11.5618, 5.7802, 53.0702, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 4, 24.57, 22, 14.1769, 6.2244, 61.5176, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 5, 6.13, 22, 4.1570, 1.4318, 22.6837, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CX', NULL, 4.53, 22, 0.2742, 3.9579, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 2, 8.97, 22, 8.7166, 1.0603, 47.5598, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 3, 0.98, 22, 1.0089, 0.1153, 7.8841, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 4, 18.29, 22, 12.1564, 3.9607, 54.8542, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 5, 71.75, 22, 14.0209, 37.6035, 91.4567, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CX', NULL, 4.92, 22, 0.0586, 4.7988, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 2, 0.33, 22, 0.3363, 0.0388, 2.7183, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 3, 0.66, 22, 0.6726, 0.0772, 5.3450, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 4, 5.65, 22, 5.3413, 0.7403, 32.4797, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 5, 93.36, 22, 5.4442, 69.3503, 98.8701, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CX', NULL, 4.81, 22, 0.1204, 4.5608, 5.0000, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 2, 2.29, 22, 2.3169, 0.2709, 16.8048, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 3, 0.33, 22, 0.3363, 0.0388, 2.7183, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 4, 11.36, 22, 9.9903, 1.6014, 50.2215, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 5, 86.02, 22, 10.2049, 51.3021, 97.2949, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CX', NULL, 2.31, 22, 0.2024, 1.8875, 2.7294, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 1, 15.40, 22, 10.4532, 3.3179, 49.1247, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 2, 38.36, 22, 15.5211, 13.7102, 70.9036, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 3, 46.24, 22, 14.6982, 20.0982, 74.6313, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CX', NULL, 4.24, 22, 0.2589, 3.7002, 4.7770, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 2, 8.97, 22, 8.7166, 1.0603, 47.5598, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 3, 5.65, 22, 5.3413, 0.7403, 32.4797, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 4, 37.92, 22, 14.5435, 14.4568, 68.8213, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 5, 47.46, 22, 14.1520, 21.7196, 74.6207, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CX', NULL, 3.11, 22, 0.3975, 2.2829, 3.9361, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 1, 12.24, 22, 9.2309, 2.2831, 45.4410, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 2, 28.12, 22, 13.7182, 8.7059, 61.6061, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 3, 14.73, 22, 8.1501, 4.2902, 39.9750, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 4, 26.26, 22, 14.2316, 7.1716, 62.1508, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 5, 18.64, 22, 11.3321, 4.6223, 52.0085, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CX', NULL, 4.70, 22, 0.1240, 4.4461, 4.9618, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 3, 2.33, 22, 1.8223, 0.4487, 11.2027, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 4, 24.95, 22, 11.4563, 8.5174, 54.2640, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 5, 72.73, 22, 11.7966, 43.6335, 90.1814, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CX', NULL, 3.37, 22, 0.3142, 2.7178, 4.0248, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 1, 11.88, 22, 6.5124, 3.5675, 32.9567, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 2, 9.04, 22, 6.2283, 2.0127, 32.4451, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 3, 28.21, 22, 14.2145, 8.3681, 62.8471, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 4, 31.80, 22, 14.9191, 10.0349, 66.0983, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 5, 19.06, 22, 11.8555, 4.5490, 53.7935, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CX', NULL, 4.08, 22, 0.2859, 3.4866, 4.6758, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 2, 13.90, 22, 10.5801, 2.5028, 50.3721, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 3, 4.79, 22, 3.6012, 0.9638, 20.6316, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 4, 40.61, 22, 15.5277, 15.1976, 72.2855, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 5, 40.71, 22, 14.5288, 16.4113, 70.5930, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CX', NULL, 1.19, 22, 0.1141, 1.0000, 1.4252, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 1, 92.68, 22, 4.3453, 76.9703, 97.9550, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 2, 2.17, 22, 1.7664, 0.3899, 11.1346, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 3, 2.00, 22, 1.7180, 0.3291, 11.2115, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 5, 3.16, 22, 2.4581, 0.6088, 14.7862, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.4', 'CT', NULL, 1.16, 22, 0.1147, 1.0000, 1.3936, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.4', 'CTP', 1, 84.49, 22, 11.4711, 46.8717, 97.1133, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.4', 'CTP', 2, 15.51, 22, 11.4711, 2.8867, 53.1283, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.4', 'CTP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.8', 'CT', NULL, 2.70, 22, 0.1271, 2.4348, 2.9635, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.8', 'CTP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.8', 'CTP', 2, 30.08, 22, 12.7115, 10.9080, 60.1923, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.8', 'CTP', 3, 69.92, 22, 12.7115, 39.8077, 89.0920, 'N', NULL, '2023-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CX', NULL, 2.55, 25, 0.1891, 2.1588, 2.9392, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 1, 7.78, 25, 5.7757, 1.5774, 30.7620, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 2, 51.40, 25, 9.5893, 32.3862, 70.0249, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 3, 18.95, 25, 7.3438, 8.0132, 38.5440, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 4, 21.87, 25, 8.9607, 8.6605, 45.2401, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CX', NULL, 4.80, 24, 0.0894, 4.6176, 4.9875, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 24, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 24, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 24, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 4, 19.75, 24, 8.9402, 7.1162, 44.1483, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 5, 80.25, 24, 8.9402, 55.8517, 92.8838, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CX', NULL, 3.78, 24, 0.1925, 3.3771, 4.1734, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 24, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 2, 7.95, 24, 5.6859, 1.7009, 30.1158, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 3, 29.83, 24, 10.3597, 13.2462, 54.1998, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 4, 38.97, 24, 10.3938, 20.5432, 61.1930, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 5, 23.25, 24, 8.9312, 9.7154, 46.0390, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CX', NULL, 4.87, 24, 0.0722, 4.7233, 5.0000, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 24, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 24, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 24, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 4, 12.73, 24, 7.2227, 3.6637, 35.8904, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 5, 87.27, 24, 7.2227, 64.1096, 96.3363, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CX', NULL, 4.68, 26, 0.1128, 4.4436, 4.9084, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 1, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 2, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 3, 3.82, 26, 3.7567, 0.4803, 24.6101, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 4, 24.77, 26, 9.1641, 10.6795, 47.5490, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 5, 71.41, 26, 9.5680, 48.7578, 86.7712, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CX', NULL, 4.47, 25, 0.1497, 4.1656, 4.7835, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 2, 4.03, 25, 3.9519, 0.5085, 25.6869, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 3, 4.71, 25, 3.2624, 1.0926, 18.1341, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 4, 31.02, 25, 9.7168, 14.9743, 53.4432, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 5, 60.24, 25, 10.0354, 38.9501, 78.2455, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CX', NULL, 4.19, 26, 0.2415, 3.6923, 4.6872, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 1, 3.73, 26, 3.6786, 0.4675, 24.2177, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 2, 11.28, 26, 6.4428, 3.2681, 32.3758, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 3, 4.46, 26, 3.1075, 1.0294, 17.3290, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 4, 23.34, 26, 8.8135, 9.9406, 45.6420, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 5, 57.19, 26, 10.6577, 35.2744, 76.6034, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CX', NULL, 4.11, 25, 0.1730, 3.7519, 4.4662, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 2, 7.97, 25, 5.4217, 1.8513, 28.4750, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 3, 7.99, 25, 4.5577, 2.3592, 23.7910, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 4, 49.19, 25, 10.1788, 29.4627, 69.1699, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 5, 34.85, 25, 9.9386, 17.8098, 56.8976, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CX', NULL, 2.52, 25, 0.2590, 1.9866, 3.0559, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 1, 29.42, 25, 9.4941, 13.9612, 51.7166, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 2, 21.95, 25, 7.9917, 9.6958, 42.4123, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 3, 15.71, 25, 7.8259, 5.2161, 38.6932, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 4, 32.92, 25, 9.1080, 17.3203, 53.4799, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CX', NULL, 3.80, 25, 0.2510, 3.2862, 4.3223, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 1, 2.36, 25, 2.3601, 0.2898, 16.6964, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 2, 21.31, 25, 8.7074, 8.4876, 44.1617, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 3, 8.46, 25, 4.8380, 2.4800, 25.1234, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 4, 29.30, 25, 9.6656, 13.6573, 52.0506, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 5, 38.58, 25, 10.3873, 20.2647, 60.8177, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CX', NULL, 3.15, 26, 0.2767, 2.5828, 3.7226, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 1, 9.63, 26, 5.5668, 2.7737, 28.4632, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 2, 17.41, 26, 7.6665, 6.5694, 38.7288, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 3, 36.18, 26, 9.9403, 18.9387, 57.9129, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 4, 21.61, 26, 8.9791, 8.4725, 45.0960, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 5, 15.16, 26, 10.1406, 3.4044, 47.5437, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CX', NULL, 2.92, 25, 0.1491, 2.6073, 3.2227, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 1, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 2, 31.84, 25, 9.6582, 15.7157, 53.9276, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 3, 44.82, 25, 10.6276, 25.0678, 66.3474, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 4, 23.34, 25, 8.6206, 10.1247, 45.1462, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CX', NULL, 1.14, 26, 0.1006, 1.0000, 1.3510, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 1, 85.62, 26, 10.0594, 52.5335, 96.9711, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 2, 14.38, 26, 10.0594, 3.0289, 47.4665, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 4, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 5, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CX', NULL, 4.62, 25, 0.1857, 4.2361, 5.0000, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 1, 2.56, 25, 2.5668, 0.3140, 18.0006, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 2, 4.70, 25, 4.5801, 0.5930, 28.9374, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 3, 4.03, 25, 3.9519, 0.5085, 25.6869, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 4, 5.66, 25, 5.4860, 0.7154, 33.3287, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 5, 83.05, 25, 7.9495, 60.4340, 94.0143, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CX', NULL, 1.68, 26, 0.2391, 1.1829, 2.1677, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 1, 56.09, 26, 11.0048, 33.7283, 76.2251, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 2, 34.78, 26, 9.0983, 18.9241, 54.9155, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 4, 3.77, 26, 3.7155, 0.4746, 24.3897, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 5, 5.36, 26, 4.8935, 0.7701, 29.2326, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CX', NULL, 2.46, 25, 0.2372, 1.9670, 2.9460, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 1, 18.46, 25, 7.2626, 7.7199, 37.9985, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 2, 42.38, 25, 10.4488, 23.3240, 64.0165, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 3, 19.85, 25, 8.9791, 7.1750, 44.2552, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 4, 13.64, 25, 7.4070, 4.1338, 36.6389, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 5, 5.66, 25, 5.4634, 0.7217, 33.1348, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CX', NULL, 2.00, 26, 0.3629, 1.2565, 2.7515, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 1, 49.10, 26, 11.0688, 27.9286, 70.6056, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 2, 22.82, 26, 8.6449, 9.7174, 44.8314, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 3, 17.35, 26, 8.4121, 5.9042, 41.2709, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 4, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 5, 10.72, 26, 9.7871, 1.4393, 49.6648, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CX', NULL, 1.13, 25, 0.1267, 1.0000, 1.3946, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 1, 93.35, 25, 6.3367, 63.0707, 99.1402, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 2, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 3, 6.65, 25, 6.3367, 0.8598, 36.9293, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CX', NULL, 2.28, 26, 0.2238, 1.8236, 2.7454, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 1, 28.82, 26, 9.0963, 13.9735, 50.2261, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 2, 33.80, 26, 8.5657, 18.8393, 52.9039, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 3, 24.93, 26, 8.9507, 11.0317, 47.0685, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 4, 5.01, 26, 4.9213, 0.6234, 30.7303, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 5, 7.44, 26, 5.1026, 1.7174, 26.9938, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CX', NULL, 2.82, 25, 0.1693, 2.4734, 3.1721, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 1, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 2, 41.00, 25, 10.2199, 22.5115, 62.4307, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 3, 35.73, 25, 9.9653, 18.5047, 57.6566, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 4, 23.27, 25, 9.4044, 9.2771, 47.3507, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CX', NULL, 2.36, 26, 0.2741, 1.7980, 2.9272, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 1, 34.25, 26, 9.6784, 17.6902, 55.7959, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 2, 26.73, 26, 8.6294, 12.8324, 47.4789, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 3, 17.91, 26, 7.6186, 6.9826, 38.8134, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 4, 10.74, 26, 7.2184, 2.4888, 36.1973, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 5, 10.37, 26, 6.5386, 2.6449, 33.0060, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CX', NULL, 1.47, 25, 0.1741, 1.1142, 1.8330, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 1, 63.96, 25, 10.3305, 41.3078, 81.7377, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 2, 30.38, 25, 9.9001, 14.2389, 53.4117, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 3, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 4, 5.66, 25, 5.4634, 0.7217, 33.1348, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CX', NULL, 1.48, 26, 0.1881, 1.0893, 1.8641, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 1, 63.05, 26, 11.1479, 38.9062, 82.0495, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 2, 31.59, 26, 9.0199, 16.3555, 52.1756, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 4, 5.36, 26, 4.8935, 0.7701, 29.2326, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 5, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CX', NULL, 1.42, 25, 0.1745, 1.0554, 1.7758, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 1, 69.77, 25, 10.1554, 46.0706, 86.1743, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 2, 24.57, 25, 9.5885, 10.0715, 48.6546, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 3, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 4, 5.66, 25, 5.4634, 0.7217, 33.1348, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CX', NULL, 1.38, 25, 0.2584, 1.0000, 1.9099, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 1, 83.91, 25, 10.6619, 50.5415, 96.3801, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 2, 5.48, 25, 4.9960, 0.7861, 29.7937, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 3, 5.13, 25, 5.0333, 0.6339, 31.3888, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 5, 5.48, 25, 4.9960, 0.7861, 29.7937, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CX', NULL, 1.03, 25, 0.0261, 1.0000, 1.0800, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 1, 97.38, 25, 2.6089, 81.8134, 99.6762, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 2, 2.62, 25, 2.6089, 0.3238, 18.1866, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CX', NULL, 1.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 1, 100.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CX', NULL, 1.03, 25, 0.0261, 1.0000, 1.0800, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 1, 97.38, 25, 2.6089, 81.8134, 99.6762, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 2, 2.62, 25, 2.6089, 0.3238, 18.1866, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 3, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CX', NULL, 1.16, 26, 0.1045, 1.0000, 1.3725, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 1, 84.27, 26, 10.4490, 51.3740, 96.4504, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 2, 15.73, 26, 10.4490, 3.5496, 48.6260, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CX', NULL, 1.06, 25, 0.0546, 1.0000, 1.1694, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 1, 94.34, 25, 5.4634, 66.8652, 99.2783, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 2, 5.66, 25, 5.4634, 0.7217, 33.1348, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 3, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CX', NULL, 1.20, 26, 0.1067, 1.0000, 1.4147, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 1, 80.50, 26, 10.6663, 50.4595, 94.3590, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 2, 19.50, 26, 10.6663, 5.6410, 49.5405, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 4, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CX', NULL, 1.27, 25, 0.0916, 1.0790, 1.4569, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 1, 73.20, 25, 9.1554, 51.0420, 87.7423, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 2, 26.80, 25, 9.1554, 12.2577, 48.9580, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 3, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CX', NULL, 4.33, 25, 0.1424, 4.0346, 4.6224, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 2, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 3, 15.25, 25, 7.5991, 5.0773, 37.7164, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 4, 36.64, 25, 10.3966, 18.6679, 59.3091, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 5, 48.10, 25, 9.8840, 29.0474, 67.7268, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CX', NULL, 2.11, 24, 0.1676, 1.7679, 2.4612, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 1, 18.09, 24, 8.5765, 6.2493, 42.2386, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 2, 57.33, 24, 10.6085, 35.3960, 76.7193, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 3, 19.62, 24, 8.8911, 7.0695, 43.9329, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 4, 4.96, 24, 4.8272, 0.6230, 30.2747, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 24, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CX', NULL, 1.09, 25, 0.0576, 1.0000, 1.2079, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 1, 91.10, 25, 5.7589, 70.2678, 97.7916, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 2, 8.90, 25, 5.7589, 2.2084, 29.7322, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CX', NULL, 1.97, 25, 0.1245, 1.7084, 2.2224, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 1, 18.06, 25, 8.0321, 6.7099, 40.3233, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 2, 67.34, 25, 9.9227, 44.8257, 83.9496, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 3, 14.60, 25, 7.8899, 4.4273, 38.6916, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CX', NULL, 1.37, 26, 0.1125, 1.1428, 1.6063, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 1, 62.54, 26, 11.2509, 38.3098, 81.7845, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 2, 37.46, 26, 11.2509, 18.2155, 61.6902, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CX', NULL, 1.27, 25, 0.1120, 1.0438, 1.5059, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 1, 76.51, 25, 9.3023, 52.8096, 90.4548, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 2, 19.51, 25, 8.8479, 7.0401, 43.6736, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 3, 3.99, 25, 3.9087, 0.5025, 25.4597, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CX', NULL, 2.07, 26, 0.2671, 1.5242, 2.6245, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 1, 45.44, 26, 10.9505, 25.1165, 67.4130, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 2, 32.65, 26, 11.0286, 14.7151, 57.6594, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 4, 12.85, 26, 7.3464, 3.6755, 36.2802, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 5, 9.06, 26, 5.2234, 2.6300, 26.8813, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CX', NULL, 1.31, 24, 0.1084, 1.0871, 1.5356, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 1, 71.32, 24, 10.2003, 46.9872, 87.4624, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 2, 26.23, 24, 10.1327, 10.7392, 51.2275, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 3, 2.46, 24, 2.4595, 0.3001, 17.3943, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 24, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 24, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CX', NULL, 2.50, 24, 0.3002, 1.8771, 3.1190, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 1, 30.55, 24, 10.0445, 14.1767, 53.9429, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 2, 25.24, 24, 9.3975, 10.7528, 48.6092, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 3, 20.80, 24, 8.9556, 7.8627, 44.7115, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 4, 10.68, 24, 6.2882, 2.9643, 31.8606, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 5, 12.73, 24, 6.6260, 4.0766, 33.3763, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CX', NULL, 1.24, 25, 0.1306, 1.0000, 1.5107, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 1, 87.94, 25, 6.5306, 67.1700, 96.2979, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 2, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 3, 12.06, 25, 6.5306, 3.7021, 32.8300, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 4, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CX', NULL, 1.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 1, 100.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 2, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CX', NULL, 2.19, 23, 0.2618, 1.6455, 2.7315, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 1, 40.00, 23, 10.8136, 20.7510, 62.9222, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 2, 27.27, 23, 9.8660, 11.7895, 51.2671, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 3, 6.62, 23, 4.6188, 1.4818, 25.0317, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 4, 26.11, 23, 9.4207, 11.3782, 49.3128, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 5, 0.00, 23, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CX', NULL, 4.03, 26, 0.1694, 3.6859, 4.3839, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 2, 3.67, 26, 3.6384, 0.4547, 24.0946, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 3, 28.01, 26, 8.2548, 14.3439, 47.4818, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 4, 29.48, 26, 9.3186, 14.2446, 51.2771, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 5, 38.84, 26, 9.5152, 21.7695, 59.1661, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CX', NULL, 4.31, 25, 0.1695, 3.9651, 4.6648, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 1, 2.56, 25, 2.5668, 0.3140, 18.0006, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 2, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 3, 13.61, 25, 6.6952, 4.6394, 33.7872, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 4, 31.03, 25, 9.6298, 15.0944, 53.2466, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 5, 52.79, 25, 10.3404, 32.2026, 72.4760, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CX', NULL, 4.04, 26, 0.1902, 3.6479, 4.4312, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 1, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 2, 10.26, 26, 6.0760, 2.8532, 30.7986, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 3, 16.62, 26, 7.1725, 6.4226, 36.6593, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 4, 32.03, 26, 9.7289, 15.8073, 54.1907, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 5, 41.09, 26, 9.6726, 23.4472, 61.3660, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CX', NULL, 2.01, 24, 0.2417, 1.5147, 2.5147, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 1, 42.57, 24, 10.3515, 23.5929, 64.0286, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 2, 26.02, 24, 8.7629, 12.0647, 47.4246, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 3, 18.76, 24, 8.5277, 6.7642, 42.3543, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 4, 12.64, 24, 8.1922, 3.0267, 40.1670, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 5, 0.00, 24, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CX', NULL, 4.30, 26, 0.2004, 3.8916, 4.7173, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 1, 0.00, 26, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 2, 7.59, 26, 5.6344, 1.5456, 30.0506, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 3, 11.50, 26, 6.5140, 3.3628, 32.6850, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 4, 23.78, 26, 8.7164, 10.3858, 45.6535, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 5, 57.13, 26, 10.5716, 35.3894, 76.4218, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CX', NULL, 2.70, 24, 0.3051, 2.0719, 3.3340, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 1, 25.19, 24, 9.2595, 10.8600, 48.1980, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 2, 23.80, 24, 8.9827, 10.0833, 46.5316, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 3, 21.89, 24, 8.9788, 8.6367, 45.3665, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 4, 13.77, 24, 6.7280, 4.7125, 34.0207, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 5, 15.35, 24, 8.4860, 4.4875, 41.1833, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CX', NULL, 4.23, 26, 0.2255, 3.7670, 4.6960, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 1, 5.36, 26, 4.8935, 0.7701, 29.2326, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 2, 6.14, 26, 4.3857, 1.3488, 23.8676, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 3, 12.86, 26, 7.1075, 3.8449, 35.2713, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 4, 11.25, 26, 6.5171, 3.2012, 32.7139, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 5, 64.38, 26, 9.2550, 44.0468, 80.5830, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CX', NULL, 3.34, 25, 0.2632, 2.8003, 3.8868, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 1, 12.26, 25, 6.8843, 3.5940, 34.3628, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 2, 13.29, 25, 7.4581, 3.8744, 36.8230, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 3, 19.16, 25, 7.9657, 7.5815, 40.6580, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 4, 38.42, 25, 9.8445, 20.9051, 59.5550, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 5, 16.87, 25, 8.0858, 5.8148, 40.0135, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CX', NULL, 4.40, 25, 0.1728, 4.0412, 4.7543, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 1, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 2, 5.49, 25, 5.3489, 0.6890, 32.7631, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 3, 6.36, 25, 4.5346, 1.3892, 24.6437, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 4, 31.02, 25, 8.8686, 16.0519, 51.4082, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 5, 57.13, 25, 9.2955, 37.8403, 74.4649, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CX', NULL, 1.00, 23, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 1, 100.00, 23, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 2, 0.00, 23, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 3, 0.00, 23, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 4, 0.00, 23, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 5, 0.00, 23, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.4', 'CT', NULL, 1.20, 25, 0.0771, 1.0360, 1.3544, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.4', 'CTP', 1, 80.48, 25, 7.7137, 59.9463, 91.9105, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.4', 'CTP', 2, 19.52, 25, 7.7137, 8.0895, 40.0537, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.4', 'CTP', 3, 0.00, 25, 0.0000, NULL, NULL, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.8', 'CT', NULL, 2.48, 26, 0.1640, 2.1391, 2.8147, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.8', 'CTP', 1, 15.16, 26, 7.9712, 4.7511, 39.0391, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.8', 'CTP', 2, 21.99, 26, 8.0127, 9.7214, 42.4493, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.8', 'CTP', 3, 62.85, 26, 10.1533, 40.8595, 80.5563, 'N', NULL, '2018-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CX', NULL, 3.35, 40, 0.1738, 2.9963, 3.6995, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 1, 3.00, 40, 2.4186, 0.5735, 14.2414, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 2, 15.19, 40, 5.9133, 6.6123, 31.1899, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 3, 26.90, 40, 9.6562, 11.9911, 49.8365, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 4, 53.83, 40, 11.9431, 30.6099, 75.5023, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 5, 1.08, 40, 0.8325, 0.2236, 5.0228, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CX', NULL, 4.92, 40, 0.0706, 4.7762, 5.0000, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 4, 8.10, 40, 7.0586, 1.2798, 37.4929, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 5, 91.90, 40, 7.0586, 62.5071, 98.7202, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CX', NULL, 3.52, 40, 0.2053, 3.1021, 3.9325, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 1, 1.59, 40, 1.5925, 0.2063, 11.2292, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 2, 17.57, 40, 8.0745, 6.4593, 39.7000, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 3, 24.05, 40, 12.9707, 7.0007, 57.1098, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 4, 41.09, 40, 12.0980, 20.2418, 65.7151, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 5, 15.70, 40, 7.7800, 5.3664, 37.9485, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CX', NULL, 4.76, 39, 0.1346, 4.4888, 5.0000, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 39, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 39, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 3, 3.08, 39, 2.4774, 0.5871, 14.5759, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 4, 17.72, 39, 13.2974, 3.2877, 57.7093, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 5, 79.20, 39, 13.1473, 43.0797, 95.0401, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CX', NULL, 4.61, 40, 0.1605, 4.2825, 4.9316, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 3, 7.93, 40, 6.9401, 1.2452, 37.0631, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 4, 23.43, 40, 10.5146, 8.5498, 50.0307, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 5, 68.64, 40, 11.6557, 42.2642, 86.7444, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CX', NULL, 4.67, 40, 0.1152, 4.4404, 4.9063, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 2, 1.10, 40, 1.1265, 0.1381, 8.2592, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 3, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 4, 29.35, 40, 11.0411, 12.3963, 54.9482, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 5, 69.55, 40, 11.0880, 44.1974, 86.8151, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CX', NULL, 4.25, 40, 0.1886, 3.8717, 4.6347, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 1, 3.01, 40, 2.4270, 0.5762, 14.2835, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 2, 4.67, 40, 3.3588, 1.0516, 18.3954, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 3, 5.69, 40, 3.0188, 1.8957, 15.8426, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 4, 37.25, 40, 11.8419, 17.5635, 62.3222, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 5, 49.38, 40, 12.4969, 26.1921, 72.8395, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CX', NULL, 4.32, 40, 0.2058, 3.9023, 4.7348, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 2, 1.10, 40, 1.1265, 0.1381, 8.2592, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 3, 16.89, 40, 10.2614, 4.4278, 47.1324, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 4, 31.05, 40, 10.2705, 14.5788, 54.3043, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 5, 50.95, 40, 12.5050, 27.4097, 74.0834, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CX', NULL, 2.21, 40, 0.2677, 1.6649, 2.7477, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 1, 29.21, 40, 12.7933, 10.5572, 59.0538, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 2, 39.07, 40, 11.8814, 18.9397, 63.7643, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 3, 13.61, 40, 7.4479, 4.1888, 36.1973, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 4, 18.12, 40, 8.8451, 6.2120, 42.4963, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CX', NULL, 4.04, 40, 0.1878, 3.6587, 4.4186, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 1, 2.25, 40, 2.2745, 0.2846, 15.6939, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 2, 0.82, 40, 0.8365, 0.1020, 6.2326, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 3, 20.31, 40, 10.5532, 6.3786, 48.7946, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 4, 44.06, 40, 12.5881, 21.8917, 68.8723, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 5, 32.57, 40, 11.0424, 14.8705, 57.1813, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CX', NULL, 3.18, 40, 0.3155, 2.5447, 3.8211, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 2, 34.34, 40, 10.7578, 16.6108, 57.8532, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 3, 29.67, 40, 11.6012, 12.0504, 56.4992, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 4, 19.37, 40, 8.0585, 7.7969, 40.5501, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 5, 16.63, 40, 12.9888, 2.9111, 57.0250, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CX', NULL, 2.74, 40, 0.1144, 2.5078, 2.9706, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 1, 2.24, 40, 2.2600, 0.2838, 15.5888, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 2, 29.20, 40, 10.1506, 13.2520, 52.6831, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 3, 60.96, 40, 11.1259, 37.7517, 80.0758, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 4, 7.60, 40, 3.5569, 2.8701, 18.6425, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CX', NULL, 1.16, 40, 0.0783, 1.0000, 1.3159, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 1, 84.24, 40, 7.8273, 61.8615, 94.6280, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 2, 15.76, 40, 7.8273, 5.3720, 38.1385, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 3, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 4, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CX', NULL, 4.53, 40, 0.2376, 4.0463, 5.0000, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 1, 2.24, 40, 2.2649, 0.2826, 15.6482, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 2, 10.35, 40, 7.2666, 2.3136, 36.0113, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 3, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 4, 7.30, 40, 5.4176, 1.5338, 28.4556, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 5, 80.11, 40, 9.0438, 56.0986, 92.6994, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CX', NULL, 1.86, 40, 0.2129, 1.4269, 2.2881, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 1, 47.14, 40, 12.6475, 24.2071, 71.3396, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 2, 35.12, 40, 12.3227, 15.3482, 61.7787, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 3, 2.60, 40, 1.4591, 0.8262, 7.8862, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 4, 15.14, 40, 6.6634, 5.8830, 33.7473, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CX', NULL, 1.38, 39, 0.1186, 1.1382, 1.6186, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 1, 67.86, 39, 10.5457, 44.2387, 84.8926, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 2, 27.66, 39, 10.1243, 12.0700, 51.5711, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 3, 3.26, 39, 2.3176, 0.7577, 12.9758, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 4, 1.22, 39, 1.0916, 0.1959, 7.1842, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 5, 0.00, 39, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CX', NULL, 1.25, 39, 0.0933, 1.0612, 1.4388, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 1, 75.18, 39, 9.3115, 52.4460, 89.2652, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 2, 24.65, 39, 9.2987, 10.6119, 47.4040, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 3, 0.18, 39, 0.1816, 0.0218, 1.4079, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 4, 0.00, 39, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 39, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CX', NULL, 1.08, 39, 0.0618, 1.0000, 1.2024, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 1, 97.08, 39, 2.2204, 87.1969, 99.3871, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 2, 0.00, 39, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 3, 1.04, 39, 1.0667, 0.1293, 7.8800, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 4, 1.88, 39, 1.9074, 0.2356, 13.4523, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 39, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CX', NULL, 2.26, 39, 0.3516, 1.5527, 2.9764, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 1, 44.63, 39, 12.9081, 21.8764, 69.8877, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 2, 13.89, 39, 7.8360, 4.1058, 37.7969, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 3, 17.14, 39, 8.0648, 6.1500, 39.5043, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 4, 19.06, 39, 10.7840, 5.4084, 49.2242, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 5, 5.28, 39, 5.0578, 0.7142, 30.1619, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CX', NULL, 2.89, 39, 0.1735, 2.5361, 3.2386, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 1, 0.00, 39, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 2, 34.63, 39, 10.5181, 17.1369, 57.5721, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 3, 44.67, 39, 13.0926, 21.6434, 70.2285, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 4, 18.05, 39, 11.0395, 4.6343, 49.9467, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 5, 2.66, 39, 2.0962, 0.5267, 12.3410, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CX', NULL, 2.40, 39, 0.2732, 1.8479, 2.9540, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 1, 33.63, 39, 12.5532, 13.9661, 61.2740, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 2, 15.43, 39, 5.8803, 6.8260, 31.2369, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 3, 33.12, 39, 13.4656, 12.6358, 62.8977, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 4, 12.85, 39, 5.3768, 5.2821, 28.0420, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 5, 4.97, 39, 2.7769, 1.5670, 14.6722, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CX', NULL, 1.50, 39, 0.1875, 1.1221, 1.8813, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 1, 66.03, 39, 10.7197, 42.4840, 83.6435, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 2, 23.11, 39, 8.9427, 9.7896, 45.4311, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 3, 5.53, 39, 3.7917, 1.3270, 20.2846, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 4, 5.34, 39, 5.0604, 0.7360, 29.9917, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 5, 0.00, 39, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CX', NULL, 1.34, 39, 0.1294, 1.0812, 1.6053, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 1, 74.47, 39, 9.7055, 50.9263, 89.1270, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 2, 19.95, 39, 9.0334, 7.3438, 43.9196, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 3, 2.38, 39, 2.2915, 0.3314, 15.2045, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 4, 3.20, 39, 2.6367, 0.5885, 15.6160, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 5, 0.00, 39, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CX', NULL, 1.54, 40, 0.1724, 1.1883, 1.8858, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 1, 68.31, 40, 9.9442, 45.9796, 84.5159, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 2, 20.23, 40, 8.5836, 7.9622, 42.6532, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 3, 5.71, 40, 3.2223, 1.7734, 16.8880, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 4, 0.94, 40, 0.9583, 0.1167, 7.0993, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 5, 4.81, 40, 3.0746, 1.2830, 16.4248, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CX', NULL, 1.20, 40, 0.1150, 1.0000, 1.4291, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 1, 88.53, 40, 6.3361, 68.6001, 96.4595, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 2, 3.30, 40, 3.1108, 0.4723, 19.6932, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 3, 8.18, 40, 5.5509, 1.9564, 28.4324, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 4, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CX', NULL, 1.02, 40, 0.0208, 1.0000, 1.0625, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 1, 98.98, 40, 1.0418, 92.3156, 99.8731, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 3, 1.02, 40, 1.0418, 0.1269, 7.6844, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CX', NULL, 1.33, 40, 0.2607, 1.0000, 1.8584, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 1, 84.20, 40, 13.0485, 42.2933, 97.4846, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 3, 15.04, 40, 13.1101, 2.1731, 58.5128, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 5, 0.76, 40, 0.7780, 0.0952, 5.8064, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CX', NULL, 1.07, 40, 0.0420, 1.0000, 1.1505, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 1, 96.41, 40, 2.2627, 87.7376, 99.0204, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 2, 1.75, 40, 1.7730, 0.2199, 12.5559, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 3, 0.71, 40, 0.7249, 0.0882, 5.4345, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 4, 1.13, 40, 1.1533, 0.1414, 8.4432, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CX', NULL, 1.08, 40, 0.0468, 1.0000, 1.1717, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 1, 94.14, 40, 3.3246, 82.6014, 98.1951, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 2, 4.02, 40, 2.6709, 1.0222, 14.5205, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 3, 1.84, 40, 1.8644, 0.2309, 13.1522, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CX', NULL, 1.06, 40, 0.0294, 1.0000, 1.1148, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 1, 95.52, 40, 2.3400, 87.5847, 98.4740, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 2, 3.42, 40, 2.0485, 1.0022, 11.0420, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 3, 1.05, 40, 0.9720, 0.1613, 6.5589, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CX', NULL, 1.46, 40, 0.2549, 1.0000, 1.9743, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 1, 76.60, 40, 12.6857, 43.8904, 93.2001, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 2, 3.69, 40, 2.7347, 0.8001, 15.3791, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 3, 16.93, 40, 12.9682, 3.0620, 56.8187, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 4, 2.77, 40, 2.1024, 0.5860, 12.1319, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CX', NULL, 1.09, 38, 0.0438, 1.0000, 1.1768, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 1, 91.20, 38, 4.3844, 77.4064, 96.9099, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 2, 8.80, 38, 4.3844, 3.0901, 22.5936, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 3, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CX', NULL, 4.36, 38, 0.1916, 3.9713, 4.7475, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 2, 5.12, 38, 5.0207, 0.6618, 30.4481, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 3, 6.21, 38, 3.6659, 1.8159, 19.1607, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 4, 36.27, 38, 11.6324, 17.0322, 61.2063, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 5, 52.40, 38, 12.5382, 28.4431, 75.2962, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CX', NULL, 2.09, 38, 0.1337, 1.8176, 2.3594, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 1, 10.33, 38, 5.1634, 3.5879, 26.2762, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 2, 75.62, 38, 9.5677, 52.0088, 89.8744, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 3, 8.93, 38, 7.1499, 1.6247, 36.7985, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 4, 5.12, 38, 5.0207, 0.6618, 30.4481, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CX', NULL, 1.02, 37, 0.0166, 1.0000, 1.0571, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 1, 97.65, 37, 1.6611, 90.5347, 99.4514, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 2, 2.35, 37, 1.6611, 0.5486, 9.4653, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 37, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CX', NULL, 1.95, 38, 0.1240, 1.7019, 2.2043, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 1, 17.36, 38, 6.8711, 7.3693, 35.6631, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 2, 76.31, 38, 8.5620, 55.2347, 89.3743, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 3, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 4, 6.33, 38, 5.1428, 1.1536, 28.1445, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CX', NULL, 1.26, 38, 0.1306, 1.0000, 1.5269, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 1, 73.77, 38, 13.0611, 41.7369, 91.6974, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 2, 26.23, 38, 13.0611, 8.3026, 58.2631, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CX', NULL, 1.19, 38, 0.1311, 1.0000, 1.4515, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 1, 81.41, 38, 13.1091, 43.0898, 96.2009, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 2, 18.59, 38, 13.1091, 3.7991, 56.9102, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 38, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CX', NULL, 2.31, 38, 0.4668, 1.3592, 3.2511, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 1, 47.24, 38, 12.3739, 24.6643, 70.9982, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 2, 25.19, 38, 11.2594, 9.1202, 53.0498, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 3, 1.03, 38, 1.0591, 0.1282, 7.8386, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 4, 2.90, 38, 2.1472, 0.6312, 12.2876, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 5, 23.64, 38, 12.8807, 6.7979, 56.7901, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CX', NULL, 1.22, 40, 0.0791, 1.0600, 1.3801, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 1, 78.75, 40, 7.7420, 59.2487, 90.4313, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 2, 20.49, 40, 7.6459, 9.0651, 39.9681, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 3, 0.76, 40, 0.7780, 0.0952, 5.8064, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CX', NULL, 2.73, 39, 0.4403, 1.8387, 3.6213, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 1, 28.12, 39, 11.1674, 11.3357, 54.4872, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 2, 25.25, 39, 9.6723, 10.6887, 48.8010, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 3, 11.13, 39, 7.4521, 2.6536, 36.5313, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 4, 16.51, 39, 8.1957, 5.6003, 39.7201, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 5, 18.99, 39, 13.2101, 3.9592, 57.1427, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CX', NULL, 1.30, 40, 0.1154, 1.0707, 1.5377, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 1, 79.03, 40, 8.3489, 57.6352, 91.2616, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 2, 15.33, 40, 7.6891, 5.1827, 37.5034, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 3, 1.81, 40, 1.2753, 0.4324, 7.2892, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 4, 3.82, 40, 2.5950, 0.9422, 14.2183, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CX', NULL, 1.04, 40, 0.0275, 1.0000, 1.0934, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 1, 96.92, 40, 2.4194, 85.9272, 99.3880, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 2, 2.37, 40, 2.2822, 0.3293, 15.1417, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 3, 0.71, 40, 0.7249, 0.0882, 5.4345, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CX', NULL, 2.76, 40, 0.3258, 2.1020, 3.4202, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 1, 25.36, 40, 9.0181, 11.4706, 47.1039, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 2, 22.74, 40, 10.5787, 8.0102, 49.8715, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 3, 11.13, 40, 7.2997, 2.7402, 35.7814, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 4, 31.98, 40, 12.7571, 12.5561, 60.6251, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 5, 8.79, 40, 7.1473, 1.5625, 36.9053, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CX', NULL, 4.15, 40, 0.2145, 3.7122, 4.5801, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 2, 5.08, 40, 3.2590, 1.3451, 17.3558, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 3, 16.04, 40, 10.2654, 3.9302, 47.1665, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 4, 38.06, 40, 11.1781, 19.0575, 61.5847, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 5, 40.82, 40, 12.7349, 19.1901, 66.7054, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CX', NULL, 4.10, 40, 0.2339, 3.6293, 4.5757, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 3, 31.58, 40, 12.1910, 12.8472, 59.0982, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 4, 26.59, 40, 8.3319, 13.2545, 46.2064, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 5, 41.83, 40, 12.6383, 20.0944, 67.2781, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CX', NULL, 4.42, 40, 0.1294, 4.1621, 4.6855, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 3, 4.15, 40, 3.4692, 0.7354, 20.1769, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 4, 49.32, 40, 12.5478, 26.0658, 72.8740, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 5, 46.53, 40, 12.2627, 24.3068, 70.2234, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CX', NULL, 2.10, 40, 0.1768, 1.7432, 2.4586, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 1, 27.91, 40, 9.4579, 13.0177, 50.0500, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 2, 34.42, 40, 12.6648, 14.4362, 62.0160, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 3, 37.33, 40, 12.1354, 17.2564, 62.9714, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 4, 0.34, 40, 0.3500, 0.0423, 2.6802, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CX', NULL, 3.81, 40, 0.1409, 3.5261, 4.0960, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 1, 2.06, 40, 2.0807, 0.2595, 14.4993, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 2, 5.54, 40, 3.4161, 1.5397, 18.0102, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 3, 18.58, 40, 8.2063, 7.0757, 40.6040, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 4, 56.90, 40, 11.5177, 33.7987, 77.3402, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 5, 16.93, 40, 6.8393, 7.0828, 35.2765, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CX', NULL, 2.78, 40, 0.4148, 1.9412, 3.6192, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 1, 28.48, 40, 10.8249, 11.9686, 53.8494, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 2, 14.64, 40, 6.6742, 5.5021, 33.5626, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 3, 26.86, 40, 10.8665, 10.7104, 52.9228, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 4, 10.41, 40, 4.3334, 4.3409, 22.9222, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 5, 19.61, 40, 12.9188, 4.4427, 56.1368, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CX', NULL, 4.63, 40, 0.1295, 4.3663, 4.8900, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 3, 0.82, 40, 0.8365, 0.1020, 6.2326, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 4, 35.55, 40, 12.9716, 14.9283, 63.4164, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 5, 63.64, 40, 12.9317, 36.1062, 84.4213, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CX', NULL, 3.95, 40, 0.2838, 3.3755, 4.5236, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 1, 2.24, 40, 2.2600, 0.2838, 15.5888, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 2, 12.33, 40, 7.7066, 3.2184, 37.2970, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 3, 17.81, 40, 6.6161, 7.9893, 35.0888, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 4, 23.47, 40, 8.5773, 10.4544, 44.6206, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 5, 44.15, 40, 12.9900, 21.4053, 69.6459, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CX', NULL, 4.21, 40, 0.1531, 3.8995, 4.5187, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 1, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 2, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 3, 11.97, 40, 5.2549, 4.7223, 27.1577, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 4, 55.16, 40, 12.5341, 30.6204, 77.4186, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 5, 32.87, 40, 12.9652, 12.9851, 61.6455, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CX', NULL, 1.02, 40, 0.0245, 1.0000, 1.0737, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 1, 97.58, 40, 2.4465, 83.2483, 99.6941, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 2, 2.42, 40, 2.4465, 0.3059, 16.7517, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 3, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 4, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 5, 0.00, 40, 0.0000, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.4', 'CT', NULL, 1.26, 40, 0.1296, 1.0008, 1.5252, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.4', 'CTP', 1, 74.76, 40, 12.9392, 42.5266, 92.2202, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.4', 'CTP', 2, 24.18, 40, 13.0034, 7.0632, 57.2457, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.4', 'CTP', 3, 1.06, 40, 1.0789, 0.1325, 7.9232, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.8', 'CT', NULL, 2.78, 40, 0.0930, 2.5952, 2.9716, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.8', 'CTP', 1, 2.24, 40, 2.2600, 0.2838, 15.5888, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.8', 'CTP', 2, 17.17, 40, 8.1510, 6.1089, 39.7883, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.8', 'CTP', 3, 80.58, 40, 8.4494, 58.1979, 92.5226, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CX', NULL, 3.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 2, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 3, 43.48, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 4, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 5, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CX', NULL, 5.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 5, 100.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CX', NULL, 4.22, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 2, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 3, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 4, 47.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 5, 39.13, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CX', NULL, 4.32, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 2, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 3, 18.18, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 4, 18.18, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 5, 59.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CX', NULL, 4.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 2, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 4, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 5, 86.96, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CX', NULL, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 2, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 3, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 4, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 5, 52.17, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CX', NULL, 4.26, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 1, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 2, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 3, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 4, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 5, 65.22, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CX', NULL, 3.87, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 1, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 2, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 3, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 4, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 5, 39.13, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CX', NULL, 2.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 1, 39.13, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 3, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CX', NULL, 3.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 1, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 2, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 3, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 4, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 5, 43.48, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CX', NULL, 3.22, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 2, 26.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 3, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 4, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 5, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CX', NULL, 3.23, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 1, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 2, 22.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 3, 36.36, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 4, 36.36, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 5, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CX', NULL, 1.32, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 1, 77.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 2, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 3, 9.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 5, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CX', NULL, 3.50, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 1, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 2, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 3, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 4, 27.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 5, 31.82, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CX', NULL, 1.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 1, 47.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 2, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 4, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CX', NULL, 2.17, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 1, 43.48, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 3, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 4, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CX', NULL, 1.96, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 1, 47.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 2, 26.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 3, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 4, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CX', NULL, 1.18, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 1, 86.36, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 2, 9.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 3, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CX', NULL, 3.32, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 1, 27.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 2, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 3, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 4, 31.82, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 5, 27.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CX', NULL, 2.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 2, 43.48, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 3, 26.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 4, 26.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CX', NULL, 2.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 1, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 3, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 4, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 5, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CX', NULL, 1.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 1, 60.87, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 3, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CX', NULL, 1.50, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 1, 68.18, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 2, 22.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 3, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 5, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CX', NULL, 1.57, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 1, 65.22, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 3, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CX', NULL, 1.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 1, 73.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 2, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CX', NULL, 1.05, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 1, 95.45, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 2, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CX', NULL, 1.05, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 1, 95.45, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 2, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CX', NULL, 1.13, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 1, 95.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 2, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CX', NULL, 1.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 1, 91.30, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 2, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CX', NULL, 1.26, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 1, 78.26, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 2, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CX', NULL, 1.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 1, 73.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 2, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CX', NULL, 1.23, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 1, 81.82, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 2, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 3, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CX', NULL, 3.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 1, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 2, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 3, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 4, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 5, 26.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CX', NULL, 2.57, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 1, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 2, 43.48, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 3, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 4, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CX', NULL, 1.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 1, 91.30, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 2, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CX', NULL, 2.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 1, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 2, 60.87, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 3, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CX', NULL, 1.30, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 1, 69.57, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 2, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CX', NULL, 1.26, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 1, 86.96, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 2, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CX', NULL, 1.52, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 1, 69.57, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 2, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 4, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CX', NULL, 1.22, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 1, 78.26, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CX', NULL, 1.61, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 1, 56.52, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 2, 26.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 3, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CX', NULL, 1.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 1, 73.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 2, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 3, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CX', NULL, 1.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 1, 95.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 2, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CX', NULL, 1.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 1, 52.17, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 2, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 3, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CX', NULL, 3.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 2, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 3, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 4, 60.87, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 5, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CX', NULL, 3.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 1, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 2, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 3, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 4, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 5, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CX', NULL, 4.13, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 2, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 3, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 4, 47.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 5, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CX', NULL, 2.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 1, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 2, 59.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 3, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 4, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 5, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CX', NULL, 3.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 1, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 2, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 3, 27.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 4, 31.82, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 5, 27.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CX', NULL, 2.59, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 1, 22.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 2, 22.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 3, 31.82, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 4, 18.18, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 5, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CX', NULL, 4.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 1, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 2, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 3, 9.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
/*! COMMIT */;
/*! START TRANSACTION */;
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 4, 59.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 5, 27.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CX', NULL, 4.14, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 1, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 2, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 3, 9.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 4, 68.18, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 5, 22.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CX', NULL, 3.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 2, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 3, 47.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 4, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 5, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CX', NULL, 1.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 1, 95.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 2, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.4', 'CT', NULL, 1.30, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.4', 'CTP', 1, 73.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.4', 'CTP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.4', 'CTP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.8', 'CT', NULL, 2.82, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.8', 'CTP', 1, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.8', 'CTP', 2, 9.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.8', 'CTP', 3, 86.36, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.c', 'CX', NULL, 2.28, 44, 0.1956, 1.8859, 2.6749, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.c', 'CXP', 1, 24.67, 44, 7.6139, 12.5334, 42.7960, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.c', 'CXP', 2, 43.64, 44, 9.2038, 26.6906, 62.2208, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.c', 'CXP', 3, 16.39, 44, 6.0840, 7.4162, 32.4308, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.c', 'CXP', 4, 9.59, 44, 4.3886, 3.6802, 22.7428, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.c', 'CXP', 5, 5.71, 44, 4.5335, 1.0966, 24.8596, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.f', 'CX', NULL, 4.78, 45, 0.0854, 4.6076, 4.9518, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.f', 'CXP', 3, 2.20, 45, 2.1954, 0.2870, 14.9554, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.f', 'CXP', 4, 17.63, 45, 7.8311, 6.7337, 38.8224, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.f', 'CXP', 5, 80.17, 45, 7.8928, 59.7812, 91.6631, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.h', 'CX', NULL, 4.96, 45, 0.0378, 4.8851, 5.0000, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.h', 'CXP', 4, 3.86, 45, 3.7836, 0.5128, 23.8491, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.h', 'CXP', 5, 96.14, 45, 3.7836, 76.1509, 99.4872, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.j', 'CX', NULL, 3.55, 45, 0.2207, 3.1013, 3.9911, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.j', 'CXP', 1, 5.41, 45, 3.6538, 1.3404, 19.4270, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.j', 'CXP', 2, 14.30, 45, 4.8924, 6.9430, 27.1680, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.j', 'CXP', 3, 33.73, 45, 9.0128, 18.4223, 53.4256, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.j', 'CXP', 4, 13.37, 45, 5.4900, 5.6074, 28.6333, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.j', 'CXP', 5, 33.19, 45, 8.5664, 18.5666, 51.9700, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.l', 'CX', NULL, 4.90, 45, 0.0508, 4.7985, 5.0000, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.l', 'CXP', 4, 9.90, 45, 5.0833, 3.3700, 25.7345, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.2.l', 'CXP', 5, 90.10, 45, 5.0833, 74.2655, 96.6300, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.4', 'CX', NULL, 4.50, 45, 0.1155, 4.2701, 4.7355, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.4', 'CXP', 1, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.4', 'CXP', 2, 2.56, 45, 2.4719, 0.3551, 16.2204, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.4', 'CXP', 3, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.4', 'CXP', 4, 42.04, 45, 8.8760, 25.8237, 60.1834, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.a.4', 'CXP', 5, 55.40, 45, 9.2059, 36.9556, 72.4649, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.e', 'CX', NULL, 4.57, 44, 0.0959, 4.3755, 4.7621, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 44, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.e', 'CXP', 2, 0.00, 44, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.e', 'CXP', 3, 3.55, 44, 2.5894, 0.7941, 14.4692, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.e', 'CXP', 4, 36.02, 44, 8.6351, 20.9153, 54.5181, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.e', 'CXP', 5, 60.43, 44, 8.7480, 42.2039, 76.1540, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.f', 'CX', NULL, 4.12, 44, 0.1857, 3.7455, 4.4946, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.f', 'CXP', 1, 4.30, 44, 3.2136, 0.9234, 17.8275, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.f', 'CXP', 2, 4.22, 44, 2.9833, 0.9869, 16.3274, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.f', 'CXP', 3, 15.76, 44, 6.0743, 6.9224, 32.0072, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.f', 'CXP', 4, 26.59, 44, 7.5654, 14.2168, 44.1763, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.f', 'CXP', 5, 49.12, 44, 9.2001, 31.4879, 66.9815, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.g', 'CX', NULL, 3.90, 45, 0.1955, 3.5014, 4.2895, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.g', 'CXP', 1, 8.35, 45, 4.8406, 2.4834, 24.5838, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.g', 'CXP', 2, 1.21, 45, 1.2009, 0.1622, 8.4766, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.g', 'CXP', 3, 21.55, 45, 7.3702, 10.2399, 39.8063, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.g', 'CXP', 4, 30.32, 45, 8.2828, 16.4916, 48.9522, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.b.1.g', 'CXP', 5, 38.57, 45, 8.2350, 23.7576, 55.8468, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.c.1', 'CX', NULL, 4.03, 45, 0.1903, 3.6431, 4.4102, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.c.1', 'CXP', 1, 3.86, 45, 3.7836, 0.5128, 23.8491, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.c.1', 'CXP', 2, 1.38, 45, 1.2984, 0.2030, 8.7491, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.c.1', 'CXP', 3, 26.48, 45, 8.3322, 13.1935, 46.0408, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.c.1', 'CXP', 4, 24.80, 45, 7.2389, 13.1076, 41.8972, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.c.1', 'CXP', 5, 43.48, 45, 8.5919, 27.5515, 60.8829, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.c.2', 'CX', NULL, 4.04, 45, 0.1873, 3.6666, 4.4216, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.c.2', 'CXP', 1, 3.86, 45, 3.7836, 0.5128, 23.8491, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.c.2', 'CXP', 2, 2.85, 45, 2.8156, 0.3781, 18.5296, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.c.2', 'CXP', 3, 23.17, 45, 7.4025, 11.5355, 41.0762, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.c.2', 'CXP', 4, 25.25, 45, 8.1886, 12.3469, 44.7427, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.c.2', 'CXP', 5, 44.87, 45, 8.4434, 29.0337, 61.8230, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.1', 'CX', NULL, 3.20, 45, 0.1325, 2.9356, 3.4698, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.1', 'CXP', 1, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.1', 'CXP', 2, 22.21, 45, 6.8760, 11.3497, 38.9034, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.1', 'CXP', 3, 38.01, 45, 9.0386, 22.0590, 57.0521, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.1', 'CXP', 4, 37.08, 45, 8.7102, 21.7350, 55.5676, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.1', 'CXP', 5, 2.70, 45, 1.8111, 0.6865, 10.0189, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.2', 'CX', NULL, 3.08, 45, 0.1612, 2.7583, 3.4079, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.2', 'CXP', 1, 2.20, 45, 2.1954, 0.2870, 14.9554, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.2', 'CXP', 2, 27.80, 45, 8.2084, 14.4510, 46.7525, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.2', 'CXP', 3, 34.01, 45, 8.0279, 20.0451, 51.4548, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.2', 'CXP', 4, 31.45, 45, 8.7171, 16.8797, 50.8913, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.2', 'CXP', 5, 4.53, 45, 2.5977, 1.3966, 13.7331, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.3', 'CX', NULL, 1.75, 45, 0.1764, 1.3965, 2.1076, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.3', 'CXP', 1, 52.65, 45, 8.7663, 35.3754, 69.3128, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.3', 'CXP', 2, 27.68, 45, 7.8536, 14.7885, 45.7648, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.3', 'CXP', 3, 11.49, 45, 5.2541, 4.3847, 26.8870, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.3', 'CXP', 4, 8.18, 45, 5.5143, 1.9881, 28.1205, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.1.d.3', 'CXP', 5, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.a', 'CX', NULL, 4.26, 45, 0.2612, 3.7370, 4.7897, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.a', 'CXP', 1, 14.72, 45, 6.5484, 5.6868, 33.0599, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.a', 'CXP', 2, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.a', 'CXP', 3, 3.86, 45, 3.7836, 0.5128, 23.8491, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.a', 'CXP', 4, 7.07, 45, 6.6886, 0.9690, 37.1802, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.a', 'CXP', 5, 74.35, 45, 8.8542, 53.2082, 88.0780, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.b', 'CX', NULL, 1.90, 45, 0.2439, 1.4128, 2.3959, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.b', 'CXP', 1, 60.61, 45, 8.5041, 42.8762, 75.9303, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.b', 'CXP', 2, 17.78, 45, 7.2117, 7.4100, 36.8872, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.b', 'CXP', 3, 5.15, 45, 3.9825, 1.0367, 21.9300, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.b', 'CXP', 4, 3.48, 45, 2.5302, 0.7855, 14.1247, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.b', 'CXP', 5, 12.98, 45, 6.0595, 4.8151, 30.5432, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.c', 'CX', NULL, 1.79, 45, 0.2365, 1.3120, 2.2653, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.c', 'CXP', 1, 62.88, 45, 8.3331, 45.2078, 77.6751, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.c', 'CXP', 2, 18.50, 45, 6.6184, 8.5662, 35.4744, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.c', 'CXP', 3, 5.64, 45, 3.2842, 1.6935, 17.1714, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.c', 'CXP', 4, 2.83, 45, 2.0132, 0.6605, 11.3000, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.c', 'CXP', 5, 10.15, 45, 5.7657, 3.0632, 28.7714, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.d', 'CX', NULL, 1.69, 44, 0.2036, 1.2791, 2.1005, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.d', 'CXP', 1, 61.23, 44, 8.5202, 43.3647, 76.5055, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.d', 'CXP', 2, 23.59, 44, 7.4508, 11.8273, 41.5406, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.d', 'CXP', 3, 6.63, 44, 3.3724, 2.3150, 17.5624, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.d', 'CXP', 4, 2.08, 44, 2.0726, 0.2715, 14.1994, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.d', 'CXP', 5, 6.47, 44, 4.7386, 1.4069, 25.1236, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.e', 'CX', NULL, 1.51, 44, 0.1678, 1.1683, 1.8452, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.e', 'CXP', 1, 72.14, 44, 8.7017, 51.9544, 86.1099, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.e', 'CXP', 2, 12.71, 44, 7.2752, 3.7344, 35.3335, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.e', 'CXP', 3, 7.50, 44, 4.6003, 2.0816, 23.5963, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.e', 'CXP', 4, 7.66, 44, 4.8138, 2.0579, 24.6583, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 44, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.f', 'CX', NULL, 2.14, 45, 0.2248, 1.6883, 2.5945, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.f', 'CXP', 1, 45.96, 45, 9.0261, 29.0212, 63.8873, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.f', 'CXP', 2, 20.73, 45, 7.1379, 9.8283, 38.5616, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.f', 'CXP', 3, 15.99, 45, 7.4188, 5.8842, 36.6798, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.f', 'CXP', 4, 7.84, 45, 3.9561, 2.7465, 20.4111, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.1.f', 'CXP', 5, 9.48, 45, 5.0497, 3.0972, 25.5317, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.3', 'CX', NULL, 2.80, 44, 0.1431, 2.5129, 3.0900, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.3', 'CXP', 1, 0.00, 44, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.3', 'CXP', 2, 44.49, 44, 8.9838, 27.7926, 62.5375, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.3', 'CXP', 3, 33.13, 44, 8.7413, 18.2684, 52.3302, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.3', 'CXP', 4, 20.12, 44, 6.8519, 9.6377, 37.3112, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.a.3', 'CXP', 5, 2.26, 44, 2.2516, 0.2936, 15.3208, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.a', 'CX', NULL, 2.73, 44, 0.2654, 2.1995, 3.2701, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.a', 'CXP', 1, 25.68, 44, 8.7926, 12.0108, 46.6687, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.a', 'CXP', 2, 21.70, 44, 7.5491, 10.1604, 40.4364, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.a', 'CXP', 3, 20.60, 44, 7.4206, 9.4120, 39.3093, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.a', 'CXP', 4, 17.50, 44, 6.3037, 8.0798, 33.8456, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.a', 'CXP', 5, 14.52, 44, 6.6446, 5.4591, 33.3358, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.b', 'CX', NULL, 1.82, 45, 0.1962, 1.4238, 2.2147, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.b', 'CXP', 1, 54.85, 45, 9.0035, 36.8611, 71.6510, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.b', 'CXP', 2, 25.00, 45, 8.1275, 12.2165, 44.3995, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.b', 'CXP', 3, 6.16, 45, 3.1845, 2.1151, 16.6134, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.b', 'CXP', 4, 11.37, 45, 5.8841, 3.8023, 29.3855, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.b', 'CXP', 5, 2.63, 45, 2.4717, 0.3830, 15.9081, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.c', 'CX', NULL, 1.59, 45, 0.1887, 1.2059, 1.9664, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.c', 'CXP', 1, 68.49, 45, 8.3407, 49.9352, 82.5655, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.c', 'CXP', 2, 18.30, 45, 7.6970, 7.3558, 38.7333, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.c', 'CXP', 3, 4.98, 45, 2.8994, 1.5033, 15.2666, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.c', 'CXP', 4, 2.56, 45, 2.4719, 0.3551, 16.2204, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.c', 'CXP', 5, 5.67, 45, 4.3702, 1.1431, 23.7836, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.d', 'CX', NULL, 2.12, 44, 0.2732, 1.5674, 2.6694, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.d', 'CXP', 1, 49.62, 44, 8.6208, 32.9436, 66.3781, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.d', 'CXP', 2, 23.91, 44, 8.0825, 11.3694, 43.4951, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.d', 'CXP', 3, 6.37, 44, 3.1546, 2.2852, 16.5048, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.d', 'CXP', 4, 5.23, 44, 3.0365, 1.5764, 15.9564, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.d', 'CXP', 5, 14.88, 44, 7.2068, 5.2569, 35.5129, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.e', 'CX', NULL, 1.52, 44, 0.1640, 1.1866, 1.8482, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.e', 'CXP', 1, 69.69, 44, 8.0506, 51.5959, 83.2158, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.e', 'CXP', 2, 14.58, 44, 5.6730, 6.3736, 29.9550, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.e', 'CXP', 3, 10.04, 44, 5.0808, 3.4682, 25.7640, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.e', 'CXP', 4, 5.69, 44, 4.4401, 1.1260, 24.2415, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 44, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.f', 'CX', NULL, 1.03, 45, 0.0224, 1.0000, 1.0770, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.f', 'CXP', 1, 96.82, 45, 2.2415, 87.5357, 99.2464, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.f', 'CXP', 2, 3.18, 45, 2.2415, 0.7536, 12.4643, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.a', 'CX', NULL, 1.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.a', 'CXP', 1, 100.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.b', 'CX', NULL, 1.93, 45, 0.2502, 1.4240, 2.4325, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.b', 'CXP', 1, 56.76, 45, 8.9613, 38.6110, 73.2640, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.b', 'CXP', 2, 18.33, 45, 6.1880, 8.8882, 34.0488, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.b', 'CXP', 3, 4.09, 45, 2.3525, 1.2575, 12.4964, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.b', 'CXP', 4, 16.96, 45, 7.6217, 6.4184, 37.8039, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.b', 'CXP', 5, 3.86, 45, 3.7836, 0.5128, 23.8491, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.c', 'CX', NULL, 1.43, 44, 0.1311, 1.1689, 1.6977, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.c', 'CXP', 1, 70.44, 44, 8.5337, 51.0426, 84.4832, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.c', 'CXP', 2, 15.80, 44, 7.2471, 5.8847, 36.0162, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.c', 'CXP', 3, 13.77, 44, 6.2736, 5.2126, 31.6680, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 44, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 44, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.d', 'CX', NULL, 1.43, 45, 0.1714, 1.0885, 1.7792, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.d', 'CXP', 1, 74.49, 45, 7.1800, 57.6893, 86.2115, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.d', 'CXP', 2, 17.52, 45, 5.9348, 8.4963, 32.7074, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.d', 'CXP', 3, 1.97, 45, 1.9048, 0.2752, 12.7847, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.d', 'CXP', 4, 2.16, 45, 2.1524, 0.2811, 14.6944, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.d', 'CXP', 5, 3.86, 45, 3.7836, 0.5128, 23.8491, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.e', 'CX', NULL, 1.49, 45, 0.1587, 1.1734, 1.8131, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.e', 'CXP', 1, 71.52, 45, 8.4862, 52.0289, 85.3285, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.e', 'CXP', 2, 16.42, 45, 7.6208, 6.0287, 37.5620, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.e', 'CXP', 3, 4.55, 45, 3.1142, 1.1129, 16.8187, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.e', 'CXP', 4, 6.22, 45, 4.5622, 1.3536, 24.2869, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.e', 'CXP', 5, 1.28, 45, 1.2926, 0.1659, 9.2271, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.f', 'CX', NULL, 1.74, 45, 0.1729, 1.3910, 2.0878, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.f', 'CXP', 1, 53.74, 45, 8.8958, 36.0956, 70.4980, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.f', 'CXP', 2, 23.94, 45, 7.6267, 11.9200, 42.2673, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.f', 'CXP', 3, 16.96, 45, 7.6217, 6.4184, 37.8039, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.f', 'CXP', 4, 5.36, 45, 4.1690, 1.0701, 22.8829, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.a', 'CX', NULL, 3.66, 44, 0.1847, 3.2894, 4.0346, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.a', 'CXP', 1, 3.94, 44, 3.8597, 0.5223, 24.2782, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.a', 'CXP', 2, 10.88, 44, 5.4259, 3.8010, 27.3980, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.a', 'CXP', 3, 20.95, 44, 7.0560, 10.0867, 38.4888, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.a', 'CXP', 4, 43.50, 44, 8.9124, 27.0322, 61.5302, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.a', 'CXP', 5, 20.74, 44, 6.3120, 10.7611, 36.2058, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.b', 'CX', NULL, 2.49, 44, 0.1465, 2.1941, 2.7850, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.b', 'CXP', 1, 6.47, 44, 4.2389, 1.6538, 22.1273, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.b', 'CXP', 2, 53.19, 44, 8.8314, 35.7229, 69.9146, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.b', 'CXP', 3, 25.27, 44, 7.3816, 13.3203, 42.6505, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.b', 'CXP', 4, 15.08, 44, 6.4586, 6.0314, 32.9305, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 44, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.c', 'CX', NULL, 1.33, 45, 0.1077, 1.1178, 1.5517, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.c', 'CXP', 1, 72.38, 45, 8.5103, 52.6375, 86.0765, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.c', 'CXP', 2, 21.75, 45, 8.0506, 9.6807, 41.9007, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.c', 'CXP', 3, 5.86, 45, 4.2348, 1.3082, 22.6252, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.d', 'CX', NULL, 2.48, 45, 0.1486, 2.1794, 2.7784, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.d', 'CXP', 1, 5.35, 45, 3.3418, 1.4716, 17.6100, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.d', 'CXP', 2, 56.02, 45, 8.9806, 37.9248, 72.6409, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.d', 'CXP', 3, 27.89, 45, 8.2630, 14.4575, 46.9584, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.d', 'CXP', 4, 6.88, 45, 3.5714, 2.3458, 18.5155, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.d', 'CXP', 5, 3.86, 45, 3.7836, 0.5128, 23.8491, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.e', 'CX', NULL, 1.67, 45, 0.0967, 1.4761, 1.8659, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.e', 'CXP', 1, 36.76, 45, 8.2585, 22.1274, 54.3288, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.e', 'CXP', 2, 59.37, 45, 8.4562, 41.8942, 74.7614, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.e', 'CXP', 3, 3.86, 45, 3.7836, 0.5128, 23.8491, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.f', 'CX', NULL, 1.31, 44, 0.0923, 1.1244, 1.4967, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.f', 'CXP', 1, 71.54, 44, 8.5832, 51.7868, 85.4675, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.f', 'CXP', 2, 27.17, 44, 8.5455, 13.5043, 47.1239, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 44, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.f', 'CXP', 4, 1.29, 44, 1.3050, 0.1671, 9.3240, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 44, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.g', 'CX', NULL, 2.24, 45, 0.2272, 1.7846, 2.7002, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.g', 'CXP', 1, 37.63, 45, 8.5063, 22.5189, 55.6061, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.g', 'CXP', 2, 33.30, 45, 8.0337, 19.4137, 50.8613, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.g', 'CXP', 3, 9.39, 45, 4.9002, 3.1433, 24.8575, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.g', 'CXP', 4, 6.55, 45, 4.9699, 1.3447, 26.4756, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.g', 'CXP', 5, 13.13, 45, 5.3402, 5.5553, 27.9698, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.h', 'CX', NULL, 1.71, 45, 0.1370, 1.4373, 1.9894, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.h', 'CXP', 1, 43.66, 45, 9.0240, 27.0065, 61.8788, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.h', 'CXP', 2, 45.21, 45, 9.1616, 28.1347, 63.4841, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.h', 'CXP', 3, 7.27, 45, 3.7106, 2.5213, 19.2066, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.h', 'CXP', 4, 3.86, 45, 3.7836, 0.5128, 23.8491, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.i', 'CX', NULL, 2.76, 44, 0.2190, 2.3161, 3.1993, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.i', 'CXP', 1, 17.94, 44, 6.5740, 8.1613, 34.9838, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.i', 'CXP', 2, 27.66, 44, 7.7541, 14.8935, 45.5145, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.i', 'CXP', 3, 26.52, 44, 8.8415, 12.6327, 47.4024, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.i', 'CXP', 4, 16.43, 44, 6.6339, 6.9091, 34.2502, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.d.1.i', 'CXP', 5, 11.44, 44, 5.2028, 4.3862, 26.6809, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.e.1.d', 'CX', NULL, 1.82, 45, 0.1955, 1.4218, 2.2099, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.e.1.d', 'CXP', 1, 58.55, 45, 9.0309, 40.0195, 74.9365, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.e.1.d', 'CXP', 2, 15.83, 45, 5.2032, 7.8840, 29.2353, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.e.1.d', 'CXP', 3, 16.60, 45, 8.1378, 5.7391, 39.4224, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.e.1.d', 'CXP', 4, 3.54, 45, 2.4757, 0.8432, 13.6621, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.e.1.d', 'CXP', 5, 5.49, 45, 3.2112, 1.6383, 16.8207, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.e.1.e', 'CX', NULL, 1.14, 45, 0.0580, 1.0277, 1.2616, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.e.1.e', 'CXP', 1, 85.53, 45, 5.8045, 69.6714, 93.8352, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.e.1.e', 'CXP', 2, 14.47, 45, 5.8045, 6.1648, 30.3286, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.1', 'CX', NULL, 2.77, 45, 0.2658, 2.2363, 3.3076, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.1', 'CXP', 1, 27.51, 45, 7.8148, 14.6950, 45.5333, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.1', 'CXP', 2, 14.96, 45, 5.8938, 6.4648, 30.9132, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.1', 'CXP', 3, 21.70, 45, 6.3128, 11.5903, 36.9499, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.1', 'CXP', 4, 24.50, 45, 8.3122, 11.5951, 44.5243, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.1', 'CXP', 5, 11.34, 45, 6.2225, 3.5412, 30.8068, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.2.a', 'CX', NULL, 3.85, 44, 0.2260, 3.3913, 4.3027, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.2.a', 'CXP', 1, 6.78, 44, 4.8686, 1.5144, 25.5887, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.2.a', 'CXP', 2, 11.96, 44, 5.2949, 4.6999, 27.2493, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.2.a', 'CXP', 3, 9.99, 44, 4.8811, 3.5840, 24.9071, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.2.a', 'CXP', 4, 32.30, 44, 8.8258, 17.4531, 51.8493, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.2.a', 'CXP', 5, 38.96, 44, 8.9862, 22.9517, 57.7630, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.2.b', 'CX', NULL, 3.90, 44, 0.2131, 3.4707, 4.3300, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.2.b', 'CXP', 1, 6.78, 44, 4.8686, 1.5144, 25.5887, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.2.b', 'CXP', 2, 8.10, 44, 4.2803, 2.6903, 21.9389, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.2.b', 'CXP', 3, 15.26, 44, 5.2526, 7.3513, 29.0015, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.2.b', 'CXP', 4, 28.03, 44, 8.8658, 13.8360, 48.5870, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.2.b', 'CXP', 5, 41.83, 44, 8.5202, 26.1936, 59.3002, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.4', 'CX', NULL, 4.12, 44, 0.2247, 3.6692, 4.5755, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.4', 'CXP', 1, 5.82, 44, 4.5461, 1.1494, 24.7550, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.4', 'CXP', 2, 5.56, 44, 3.8496, 1.3226, 20.5272, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.4', 'CXP', 3, 13.50, 44, 7.4935, 4.1046, 36.2780, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.4', 'CXP', 4, 20.79, 44, 6.8524, 10.1863, 37.7911, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.a.4', 'CXP', 5, 54.32, 44, 8.9856, 36.4265, 71.1715, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.2', 'CX', NULL, 2.14, 45, 0.1589, 1.8228, 2.4634, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.2', 'CXP', 1, 31.19, 45, 8.1878, 17.3622, 49.4399, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.2', 'CXP', 2, 30.13, 45, 8.3602, 16.2300, 48.9843, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.2', 'CXP', 3, 31.85, 45, 8.7718, 17.1520, 51.3476, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.2', 'CXP', 4, 6.82, 45, 3.4464, 2.3967, 17.9216, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.2', 'CXP', 5, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.4', 'CX', NULL, 4.15, 45, 0.1351, 3.8740, 4.4184, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.4', 'CXP', 1, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.4', 'CXP', 2, 5.77, 45, 3.4218, 1.6937, 17.8768, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.4', 'CXP', 3, 12.42, 45, 5.3991, 4.9536, 27.8284, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.4', 'CXP', 4, 43.24, 45, 8.5622, 27.3816, 60.6082, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.4', 'CXP', 5, 38.58, 45, 8.5164, 23.3356, 56.4451, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.7', 'CX', NULL, 3.36, 45, 0.2634, 2.8253, 3.8870, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.7', 'CXP', 1, 17.33, 45, 6.5987, 7.6545, 34.6590, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.7', 'CXP', 2, 17.98, 45, 6.7060, 8.0633, 35.4080, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.7', 'CXP', 3, 11.23, 45, 4.4812, 4.8606, 23.8367, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.7', 'CXP', 4, 18.65, 45, 7.6789, 7.6364, 38.8684, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.7', 'CXP', 5, 34.81, 45, 8.1597, 20.5496, 52.4264, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.8', 'CX', NULL, 4.03, 45, 0.2050, 3.6210, 4.4472, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.8', 'CXP', 1, 3.86, 45, 3.7836, 0.5128, 23.8491, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.8', 'CXP', 2, 8.45, 45, 5.1116, 2.3816, 25.9013, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.8', 'CXP', 3, 10.84, 45, 7.0132, 2.7412, 34.4160, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.8', 'CXP', 4, 34.09, 45, 8.2571, 19.7831, 52.0328, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.b.8', 'CXP', 5, 42.75, 45, 8.4821, 27.0811, 60.0229, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.c.1', 'CX', NULL, 2.48, 44, 0.2066, 2.0639, 2.8973, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.c.1', 'CXP', 1, 24.97, 44, 7.5229, 12.8983, 42.7901, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.c.1', 'CXP', 2, 26.98, 44, 7.9150, 14.1180, 45.3816, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.c.1', 'CXP', 3, 31.21, 44, 8.4416, 17.0350, 50.0673, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.c.1', 'CXP', 4, 8.68, 44, 4.8771, 2.6754, 24.7403, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.c.1', 'CXP', 5, 8.15, 44, 4.9467, 2.2883, 25.1709, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.1', 'CX', NULL, 3.70, 45, 0.1233, 3.4466, 3.9436, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.1', 'CXP', 1, 0.00, 45, 0.0000, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.1', 'CXP', 2, 11.00, 45, 4.9030, 4.3128, 25.3252, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.1', 'CXP', 3, 21.20, 45, 6.8491, 10.5374, 38.0712, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.1', 'CXP', 4, 55.07, 45, 8.9975, 37.0699, 71.8401, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.1', 'CXP', 5, 12.72, 45, 4.7513, 5.7947, 25.6652, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.3', 'CX', NULL, 1.48, 45, 0.1515, 1.1736, 1.7842, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.3', 'CXP', 1, 73.31, 45, 8.0120, 54.6129, 86.2403, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.3', 'CXP', 2, 9.90, 45, 5.1528, 3.3169, 26.0351, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.3', 'CXP', 3, 13.99, 45, 6.7442, 4.9907, 33.4789, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.3', 'CXP', 4, 1.21, 45, 1.2009, 0.1622, 8.4766, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.3', 'CXP', 5, 1.60, 45, 1.6022, 0.2069, 11.2526, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.4', 'CT', NULL, 1.11, 44, 0.0594, 1.0000, 1.2346, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.4', 'CTP', 1, 89.75, 44, 5.3060, 73.2347, 96.5539, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.4', 'CTP', 2, 9.01, 44, 4.9101, 2.8724, 24.8882, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.4', 'CTP', 3, 1.24, 44, 1.2314, 0.1661, 8.6904, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.8', 'CT', NULL, 2.23, 45, 0.1323, 1.9584, 2.4916, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.8', 'CTP', 1, 16.87, 45, 7.0968, 6.8203, 36.0087, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.8', 'CTP', 2, 43.76, 45, 9.0029, 27.1257, 61.9226, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '4.C.3.d.8', 'CTP', 3, 39.37, 45, 8.8136, 23.5796, 57.7472, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CX', NULL, 2.08, 21, 0.1991, 1.6613, 2.4920, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 1, 17.48, 21, 13.8407, 2.7847, 61.0512, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 2, 63.33, 21, 15.4799, 30.0658, 87.3978, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 3, 13.23, 21, 6.4820, 4.4831, 33.1154, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 4, 5.96, 21, 4.7371, 1.0764, 26.9764, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CX', NULL, 4.48, 21, 0.1704, 4.1254, 4.8364, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 4, 51.91, 21, 17.0425, 20.6270, 81.7665, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 5, 48.09, 21, 17.0425, 18.2335, 79.3730, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CX', NULL, 3.01, 21, 0.5100, 1.9424, 4.0701, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 1, 14.23, 21, 12.9919, 1.7692, 60.4473, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 2, 35.88, 21, 18.3338, 9.5969, 74.6826, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 3, 10.99, 21, 6.8673, 2.7776, 34.8096, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 4, 12.83, 21, 7.0427, 3.8045, 35.3767, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 5, 26.07, 21, 14.6057, 6.7662, 63.1445, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CX', NULL, 4.63, 21, 0.1820, 4.2508, 5.0000, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 4, 36.95, 21, 18.2012, 10.3016, 74.9378, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 5, 63.05, 21, 18.2012, 25.0622, 89.6984, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CX', NULL, 4.58, 21, 0.1785, 4.2070, 4.9518, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 4, 42.06, 21, 17.8527, 13.6039, 76.9901, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 5, 57.94, 21, 17.8527, 23.0099, 86.3961, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CX', NULL, 4.75, 21, 0.1190, 4.5060, 5.0000, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 2, 0.15, 21, 0.1540, 0.0161, 1.3086, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 3, 2.67, 21, 2.7638, 0.2966, 20.1584, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 4, 18.80, 21, 10.0481, 5.5407, 47.7507, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 5, 78.39, 21, 10.6415, 49.4531, 93.0769, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CX', NULL, 3.02, 21, 0.3464, 2.3009, 3.7459, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 1, 3.04, 21, 3.0088, 0.3728, 20.8450, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 2, 32.79, 21, 15.3212, 10.2664, 67.5344, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 3, 40.29, 21, 17.9270, 12.4780, 76.1511, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 4, 6.55, 21, 4.1493, 1.6731, 22.3783, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 5, 17.33, 21, 13.2062, 2.9753, 58.9120, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CX', NULL, 4.55, 21, 0.1804, 4.1693, 4.9220, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 2, 1.86, 21, 1.8031, 0.2391, 12.9773, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 3, 5.33, 21, 3.9466, 1.0918, 22.3404, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 4, 29.20, 21, 14.7699, 8.5017, 64.6701, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 5, 63.61, 21, 15.5267, 30.1388, 87.6287, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CX', NULL, 2.94, 21, 0.3026, 2.3111, 3.5737, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 2, 40.32, 21, 17.9853, 12.4410, 76.2588, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 3, 27.46, 21, 14.2978, 7.8099, 62.8524, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 4, 29.88, 21, 14.8749, 8.8344, 65.2016, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 5, 2.34, 21, 1.8484, 0.4412, 11.4653, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CX', NULL, 4.54, 20, 0.2067, 4.1100, 4.9751, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 1, 1.79, 20, 1.8387, 0.2030, 14.0103, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 2, 2.94, 20, 2.9152, 0.3550, 20.4566, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 3, 4.81, 20, 4.9264, 0.5279, 32.4619, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 4, 20.17, 20, 14.4325, 3.7242, 62.2548, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 5, 70.30, 20, 15.3022, 33.7977, 91.6498, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CX', NULL, 3.30, 21, 0.2045, 2.8685, 3.7217, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 1, 2.81, 21, 2.7813, 0.3455, 19.4619, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 2, 11.59, 21, 7.2348, 2.9205, 36.3760, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 3, 38.86, 21, 18.1139, 11.4695, 75.7145, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 4, 46.73, 21, 17.2290, 17.1572, 78.8000, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CX', NULL, 2.95, 21, 0.3446, 2.2356, 3.6734, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 1, 0.15, 21, 0.1540, 0.0161, 1.3086, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 2, 52.29, 21, 17.1644, 20.6905, 82.1518, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 3, 1.71, 21, 1.7824, 0.1900, 13.7153, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 4, 43.69, 21, 17.0292, 15.4789, 76.6780, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 5, 2.17, 21, 2.1218, 0.2736, 15.1626, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CX', NULL, 1.09, 21, 0.0549, 1.0000, 1.2064, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 1, 90.96, 21, 5.4647, 71.5544, 97.5755, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 2, 8.89, 21, 5.4421, 2.3487, 28.3803, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 3, 0.15, 21, 0.1540, 0.0161, 1.3086, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CX', NULL, 3.80, 21, 0.7319, 2.2755, 5.0000, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 1, 28.56, 21, 18.5074, 5.6860, 72.6179, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 4, 5.52, 21, 4.8650, 0.8257, 29.0396, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 5, 65.92, 21, 18.1509, 26.3939, 91.2547, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CX', NULL, 1.66, 20, 0.2023, 1.2387, 2.0856, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 1, 41.50, 20, 18.2569, 12.8150, 77.3921, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 2, 53.59, 20, 18.0128, 20.2288, 84.0193, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 3, 2.12, 20, 2.0772, 0.2647, 14.9857, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 4, 2.80, 20, 2.9081, 0.3054, 21.2641, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 5, 0.00, 20, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CX', NULL, 1.17, 21, 0.1029, 1.0000, 1.3849, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 1, 82.98, 21, 10.2921, 51.6019, 95.7063, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 2, 17.02, 21, 10.2921, 4.2937, 48.3981, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CX', NULL, 1.13, 21, 0.0735, 1.0000, 1.2836, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 1, 87.12, 21, 7.3244, 63.4142, 96.3511, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 2, 12.73, 21, 7.3016, 3.5721, 36.4922, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 3, 0.15, 21, 0.1540, 0.0161, 1.3086, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CX', NULL, 1.09, 21, 0.0817, 1.0000, 1.2620, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 1, 90.85, 21, 8.1747, 56.0741, 98.7215, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 2, 9.15, 21, 8.1747, 1.2785, 43.9259, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CX', NULL, 1.27, 21, 0.1261, 1.0030, 1.5292, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 1, 79.14, 21, 10.4064, 50.4602, 93.3874, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 2, 15.27, 21, 9.2996, 3.8660, 44.6641, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 3, 5.45, 21, 3.7306, 1.2588, 20.6928, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 4, 0.15, 21, 0.1540, 0.0161, 1.3086, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CX', NULL, 2.63, 21, 0.2976, 2.0041, 3.2459, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 2, 65.10, 21, 15.7881, 30.4464, 88.8243, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 3, 10.40, 21, 8.4128, 1.7371, 43.2765, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 4, 21.39, 21, 14.1418, 4.4971, 61.1305, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 5, 3.10, 21, 3.1987, 0.3473, 22.7493, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CX', NULL, 2.31, 21, 0.4847, 1.3030, 3.3251, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 1, 46.36, 21, 17.7621, 16.3035, 79.3159, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 2, 16.52, 21, 8.7185, 5.0239, 42.5227, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 3, 2.67, 21, 2.7638, 0.2966, 20.1584, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 4, 28.28, 21, 14.7990, 7.9220, 64.3670, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 5, 6.18, 21, 4.1805, 1.4441, 22.8610, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CX', NULL, 1.22, 21, 0.1226, 1.0000, 1.4785, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 1, 81.90, 21, 10.5815, 50.5144, 95.2480, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 2, 13.94, 21, 9.8495, 2.8408, 47.3089, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 3, 4.16, 21, 3.4277, 0.7179, 20.6840, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CX', NULL, 1.33, 21, 0.1514, 1.0140, 1.6457, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 1, 74.28, 21, 11.8504, 44.1937, 91.3289, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 2, 22.64, 21, 11.2887, 7.0891, 52.8910, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 3, 0.91, 21, 0.9577, 0.1007, 7.7471, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 4, 0.15, 21, 0.1540, 0.0161, 1.3086, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 5, 2.02, 21, 2.1024, 0.2245, 15.8936, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CX', NULL, 1.49, 21, 0.2328, 1.0027, 1.9739, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 1, 73.37, 21, 12.0103, 43.3202, 90.8511, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 2, 10.86, 21, 6.8116, 2.7293, 34.5852, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 3, 10.26, 21, 8.4022, 1.6750, 43.4123, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 4, 4.60, 21, 4.7044, 0.5138, 31.0750, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 5, 0.91, 21, 0.9577, 0.1007, 7.7471, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CX', NULL, 1.57, 21, 0.2770, 1.0000, 2.1454, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 1, 64.21, 21, 15.6777, 30.1823, 88.1573, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 2, 25.39, 21, 14.0579, 6.7474, 61.5393, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 4, 10.26, 21, 8.4022, 1.6750, 43.4123, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 5, 0.15, 21, 0.1540, 0.0161, 1.3086, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CX', NULL, 1.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 1, 100.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CX', NULL, 1.02, 21, 0.0195, 1.0000, 1.0595, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 1, 98.13, 21, 1.9524, 85.1101, 99.7920, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 2, 1.87, 21, 1.9524, 0.2080, 14.8899, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CX', NULL, 1.05, 21, 0.0438, 1.0000, 1.1460, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 1, 96.41, 21, 2.7083, 83.9914, 99.2795, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 2, 1.71, 21, 1.7556, 0.1972, 13.3095, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 3, 1.87, 21, 1.9524, 0.2080, 14.8899, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CX', NULL, 1.27, 21, 0.1759, 1.0000, 1.6382, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 1, 81.10, 21, 10.5940, 50.3706, 94.7790, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 2, 10.66, 21, 6.7786, 2.6302, 34.4982, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 3, 8.24, 21, 8.0874, 0.9547, 45.5413, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CX', NULL, 1.36, 21, 0.2005, 1.0000, 1.7763, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 1, 72.72, 21, 15.2335, 34.9472, 92.9701, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 2, 18.90, 21, 13.9144, 3.3879, 60.7571, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 3, 8.24, 21, 8.0874, 0.9547, 45.5413, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 4, 0.15, 21, 0.1540, 0.0161, 1.3086, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CX', NULL, 1.15, 21, 0.0998, 1.0000, 1.3596, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 1, 85.00, 21, 9.9634, 52.6111, 96.6577, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 2, 14.86, 21, 9.9508, 3.2701, 47.3793, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 3, 0.15, 21, 0.1540, 0.0161, 1.3086, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CX', NULL, 1.32, 21, 0.1547, 1.0000, 1.6452, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 1, 67.74, 21, 15.4669, 32.4222, 90.1904, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 2, 32.26, 21, 15.4669, 9.8096, 67.5778, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CX', NULL, 4.58, 21, 0.1610, 4.2436, 4.9155, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 3, 0.91, 21, 0.9577, 0.1007, 7.7471, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 4, 40.22, 21, 15.8179, 14.5723, 72.6329, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 5, 58.87, 21, 15.9332, 26.6167, 84.9548, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CX', NULL, 1.57, 21, 0.1856, 1.1876, 1.9620, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 1, 44.23, 21, 18.0628, 14.6865, 78.5089, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 2, 54.06, 21, 17.7244, 20.9829, 83.9090, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 3, 1.71, 21, 1.7556, 0.1972, 13.3095, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CX', NULL, 1.15, 20, 0.0946, 1.0000, 1.3431, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 1, 85.49, 20, 9.4604, 54.4198, 96.6775, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 2, 14.51, 20, 9.4604, 3.3225, 45.5802, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 20, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 20, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 20, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CX', NULL, 1.64, 20, 0.1908, 1.2452, 2.0440, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 1, 35.54, 20, 19.0839, 8.7952, 75.9176, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 2, 64.46, 20, 19.0839, 24.0824, 91.2048, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 3, 0.00, 20, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 4, 0.00, 20, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 20, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CX', NULL, 1.32, 20, 0.1589, 1.0000, 1.6531, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 1, 67.94, 20, 15.8866, 31.5269, 90.6988, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 2, 32.06, 20, 15.8866, 9.3012, 68.4731, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 20, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 20, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 20, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CX', NULL, 1.11, 21, 0.0848, 1.0000, 1.2886, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 1, 88.83, 21, 8.4809, 57.2134, 97.9294, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 2, 11.17, 21, 8.4809, 2.0706, 42.7866, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CX', NULL, 2.94, 21, 0.6015, 1.6870, 4.1963, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 1, 29.10, 21, 14.3718, 8.7597, 63.7047, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 2, 18.71, 21, 9.8870, 5.5962, 47.1778, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 3, 15.32, 21, 13.8019, 1.9278, 62.4713, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 4, 2.67, 21, 2.7638, 0.2966, 20.1584, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 5, 34.21, 21, 18.2248, 8.7596, 73.7898, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CX', NULL, 1.26, 21, 0.1181, 1.0102, 1.5030, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 1, 74.34, 21, 11.8118, 44.3273, 91.3376, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 2, 25.66, 21, 11.8118, 8.6624, 55.6727, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CX', NULL, 3.61, 21, 0.4431, 2.6840, 4.5327, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 1, 4.38, 21, 3.3605, 0.8514, 19.6308, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 2, 32.27, 21, 13.3554, 11.7499, 63.0211, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 3, 2.90, 21, 2.9921, 0.3236, 21.5240, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 4, 19.06, 21, 13.8692, 3.4835, 60.5686, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 5, 41.40, 21, 18.2523, 12.8212, 77.2398, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CX', NULL, 1.51, 21, 0.2552, 1.0000, 2.0386, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 1, 75.34, 21, 11.6594, 45.2081, 91.8773, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 2, 11.69, 21, 8.5818, 2.2819, 42.8507, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 4, 12.98, 21, 8.0725, 3.2470, 39.8463, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CX', NULL, 1.06, 21, 0.0574, 1.0000, 1.1783, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 1, 94.15, 21, 5.7433, 64.6419, 99.2990, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 2, 5.85, 21, 5.7433, 0.7010, 35.3581, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CX', NULL, 3.72, 20, 0.3465, 2.9939, 4.4445, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 1, 1.92, 20, 1.8359, 0.2527, 13.1063, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 2, 8.68, 20, 6.0873, 1.8705, 32.1678, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 3, 42.73, 20, 18.5866, 13.2069, 78.5277, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 4, 8.91, 20, 5.1994, 2.4970, 27.2128, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 5, 37.76, 20, 16.6326, 12.1223, 72.7419, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CX', NULL, 4.34, 21, 0.1908, 3.9430, 4.7392, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 2, 1.71, 21, 1.7556, 0.1972, 13.3095, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 3, 8.18, 21, 5.7608, 1.7683, 30.6119, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 4, 44.39, 21, 17.6191, 15.2602, 77.9613, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 5, 45.72, 21, 17.0957, 16.6775, 77.9936, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CX', NULL, 3.93, 21, 0.3563, 3.1908, 4.6774, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 1, 1.71, 21, 1.7556, 0.1972, 13.3095, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 2, 7.42, 21, 5.6057, 1.4380, 30.5459, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 3, 31.14, 21, 18.2304, 7.1307, 72.7090, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 4, 15.21, 21, 8.1390, 4.5860, 40.0879, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 5, 44.52, 21, 17.2298, 15.7747, 77.4709, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CX', NULL, 4.42, 21, 0.1938, 4.0191, 4.8278, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 2, 2.17, 21, 2.1218, 0.2736, 15.1626, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 3, 6.87, 21, 4.9046, 1.4709, 26.7372, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 4, 37.41, 21, 16.7647, 11.8318, 72.6855, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 5, 53.55, 21, 16.9601, 21.7567, 82.7032, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CX', NULL, 2.56, 21, 0.4551, 1.6070, 3.5058, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 1, 34.44, 21, 15.6669, 10.9983, 69.0774, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 2, 8.70, 21, 5.0292, 2.4836, 26.3055, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 3, 23.76, 21, 14.3539, 5.6344, 61.9411, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 4, 32.94, 21, 18.1082, 8.1599, 73.0884, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 5, 0.15, 21, 0.1540, 0.0161, 1.3086, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CX', NULL, 4.04, 21, 0.2533, 3.5155, 4.5722, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 2, 6.25, 21, 4.0425, 1.5581, 21.9421, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 3, 21.73, 21, 13.7561, 4.8869, 60.0046, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 4, 33.40, 21, 18.1345, 8.3859, 73.3083, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 5, 38.62, 21, 16.1703, 13.1678, 72.3051, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CX', NULL, 3.88, 21, 0.3721, 3.1045, 4.6570, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 1, 4.61, 21, 3.5524, 0.8880, 20.6755, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 2, 7.39, 21, 5.3783, 1.5248, 29.1327, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 3, 26.72, 21, 14.8752, 6.9544, 64.0101, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 4, 17.88, 21, 8.6925, 5.9581, 42.8115, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 5, 43.40, 21, 18.0696, 14.1851, 78.0551, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CX', NULL, 4.75, 21, 0.1324, 4.4720, 5.0000, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 2, 2.02, 21, 2.1024, 0.2245, 15.8936, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 3, 4.40, 21, 4.3400, 0.5305, 28.3863, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 4, 10.33, 21, 6.3628, 2.6761, 32.5584, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 5, 83.25, 21, 8.4464, 58.4181, 94.6205, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CX', NULL, 3.65, 21, 0.3784, 2.8634, 4.4420, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 1, 2.67, 21, 2.7638, 0.2966, 20.1584, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 2, 14.07, 21, 9.1072, 3.2889, 44.0735, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 3, 22.34, 21, 13.5095, 5.3648, 59.3474, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 4, 37.18, 21, 15.8538, 12.5580, 70.9157, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 5, 23.75, 21, 19.0461, 3.3552, 73.6420, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CX', NULL, 3.37, 21, 0.3651, 2.6089, 4.1321, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 2, 23.75, 21, 19.0461, 3.3552, 73.6420, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 3, 24.60, 21, 13.7039, 6.5307, 60.3745, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 4, 42.51, 21, 16.5505, 15.2555, 75.2252, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 5, 9.14, 21, 6.5485, 1.9074, 34.2541, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CX', NULL, 1.28, 21, 0.1589, 1.0000, 1.6093, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 1, 77.66, 21, 14.1865, 38.7053, 95.0365, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 2, 17.03, 21, 13.8208, 2.5978, 61.2277, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 3, 5.16, 21, 4.4918, 0.7964, 26.9552, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 4, 0.15, 21, 0.1540, 0.0161, 1.3086, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.4', 'CT', NULL, 1.23, 21, 0.1382, 1.0000, 1.5191, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.4', 'CTP', 1, 76.93, 21, 13.8227, 39.6445, 94.4200, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.4', 'CTP', 2, 23.07, 21, 13.8227, 5.5800, 60.3555, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.4', 'CTP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.8', 'CT', NULL, 2.63, 21, 0.1789, 2.2591, 3.0000, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.8', 'CTP', 1, 1.82, 21, 1.4004, 0.3620, 8.6721, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.8', 'CTP', 2, 33.12, 21, 18.1461, 8.2306, 73.2262, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.8', 'CTP', 3, 65.05, 21, 17.9654, 26.3662, 90.6348, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.c', 'CX', NULL, 2.65, 22, 0.2376, 2.1567, 3.1449, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.c', 'CXP', 1, 6.45, 22, 5.6479, 0.9767, 32.5550, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.c', 'CXP', 2, 43.78, 22, 15.2951, 17.6179, 73.9273, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.c', 'CXP', 3, 32.13, 22, 11.6135, 13.5216, 58.8947, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.c', 'CXP', 4, 13.51, 22, 8.3852, 3.3957, 40.9925, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.c', 'CXP', 5, 4.13, 22, 4.4482, 0.4134, 30.8492, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.f', 'CX', NULL, 4.58, 21, 0.1601, 4.2414, 4.9096, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.f', 'CXP', 4, 42.45, 21, 16.0150, 15.8184, 74.3282, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.f', 'CXP', 5, 57.55, 21, 16.0150, 25.6718, 84.1816, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.h', 'CX', NULL, 4.98, 22, 0.0258, 4.9220, 5.0000, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.h', 'CXP', 1, 0.61, 22, 0.6446, 0.0674, 5.2994, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.h', 'CXP', 5, 99.39, 22, 0.6446, 94.7006, 99.9326, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.j', 'CX', NULL, 3.53, 21, 0.4278, 2.6425, 4.4271, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.j', 'CXP', 1, 11.90, 21, 9.6512, 1.9391, 47.9651, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.j', 'CXP', 2, 6.70, 21, 5.9508, 0.9761, 34.3454, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.j', 'CXP', 3, 18.82, 21, 9.8505, 5.6982, 47.0833, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.j', 'CXP', 4, 41.19, 21, 19.3753, 11.6658, 78.7912, 'Y', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.j', 'CXP', 5, 21.39, 21, 11.5075, 6.1279, 53.1459, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.l', 'CX', NULL, 4.91, 21, 0.0632, 4.7803, 5.0000, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.l', 'CXP', 3, 1.04, 21, 0.8310, 0.1964, 5.3487, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.l', 'CXP', 4, 6.70, 21, 5.9508, 0.9761, 34.3454, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.2.l', 'CXP', 5, 92.26, 21, 6.0822, 66.8574, 98.5988, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.4', 'CX', NULL, 4.19, 22, 0.2102, 3.7577, 4.6321, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.4', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.4', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.4', 'CXP', 3, 17.04, 22, 9.5178, 4.8226, 45.4476, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.4', 'CXP', 4, 46.42, 22, 14.1155, 21.0228, 73.8254, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.a.4', 'CXP', 5, 36.53, 22, 15.1660, 12.8692, 69.1672, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.e', 'CX', NULL, 4.77, 21, 0.1359, 4.4908, 5.0000, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.e', 'CXP', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.e', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.e', 'CXP', 4, 22.58, 21, 13.5859, 5.4524, 59.6033, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.e', 'CXP', 5, 77.42, 21, 13.5859, 40.3967, 94.5476, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.f', 'CX', NULL, 3.34, 22, 0.7143, 1.8500, 4.8207, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.f', 'CXP', 1, 34.12, 22, 17.4124, 9.3758, 72.1736, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.f', 'CXP', 2, 0.61, 22, 0.6446, 0.0674, 5.2994, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.f', 'CXP', 3, 13.19, 22, 9.2272, 2.7655, 44.8082, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.f', 'CXP', 4, 1.75, 22, 1.2464, 0.3947, 7.4381, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.f', 'CXP', 5, 50.32, 22, 19.2870, 16.9157, 83.4418, 'Y', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.g', 'CX', NULL, 3.82, 21, 0.2641, 3.2671, 4.3690, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.g', 'CXP', 2, 5.67, 21, 6.0491, 0.5645, 38.8826, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.g', 'CXP', 3, 30.58, 21, 19.2422, 6.2373, 74.4787, 'Y', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.g', 'CXP', 4, 40.02, 21, 19.1883, 11.1823, 77.9503, 'Y', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.b.1.g', 'CXP', 5, 23.73, 21, 10.9716, 8.0752, 52.4222, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.c.1', 'CX', NULL, 3.04, 22, 0.1637, 2.6964, 3.3771, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.c.1', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.c.1', 'CXP', 2, 17.69, 22, 10.5628, 4.5360, 49.2783, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.c.1', 'CXP', 3, 61.47, 22, 13.9214, 31.9688, 84.4168, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.c.1', 'CXP', 4, 20.32, 22, 10.7774, 6.0075, 50.4478, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.c.1', 'CXP', 5, 0.52, 22, 0.5542, 0.0557, 4.6444, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.c.2', 'CX', NULL, 4.53, 22, 0.1970, 4.1241, 4.9434, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.c.2', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.c.2', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.c.2', 'CXP', 3, 11.18, 22, 7.9853, 2.3104, 40.1259, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.c.2', 'CXP', 4, 24.26, 22, 10.9088, 8.5246, 52.4024, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.c.2', 'CXP', 5, 64.56, 22, 13.7741, 34.2480, 86.4314, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.1', 'CX', NULL, 3.09, 22, 0.3149, 2.4371, 3.7469, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.1', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.1', 'CXP', 2, 33.67, 22, 17.3852, 9.1400, 71.9280, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.1', 'CXP', 3, 40.41, 22, 17.1135, 13.3994, 74.8322, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.1', 'CXP', 4, 8.95, 22, 6.1888, 1.9856, 32.2922, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.1', 'CXP', 5, 16.96, 22, 10.3469, 4.2450, 48.4851, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.2', 'CX', NULL, 2.65, 22, 0.2906, 2.0464, 3.2552, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.2', 'CXP', 1, 0.61, 22, 0.6446, 0.0674, 5.2994, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.2', 'CXP', 2, 60.08, 22, 16.9826, 25.6588, 86.7755, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.2', 'CXP', 3, 18.78, 22, 12.8840, 3.8381, 57.2545, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.2', 'CXP', 4, 14.69, 22, 8.9516, 3.7508, 43.2010, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.2', 'CXP', 5, 5.84, 22, 5.8798, 0.6682, 36.4164, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.3', 'CX', NULL, 1.36, 22, 0.1638, 1.0238, 1.7052, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.3', 'CXP', 1, 69.39, 22, 12.7394, 39.4404, 88.7542, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.3', 'CXP', 2, 24.76, 22, 11.1953, 8.6206, 53.4534, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.3', 'CXP', 3, 5.84, 22, 5.8798, 0.6682, 36.4164, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.3', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.1.d.3', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.a', 'CX', NULL, 4.71, 22, 0.2414, 4.2119, 5.0000, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.a', 'CXP', 1, 6.92, 22, 6.0124, 1.0553, 34.1255, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.a', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.a', 'CXP', 3, 0.46, 22, 0.4892, 0.0516, 4.0460, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.a', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.a', 'CXP', 5, 92.62, 22, 6.0695, 66.4494, 98.7571, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.b', 'CX', NULL, 1.02, 22, 0.0154, 1.0000, 1.0486, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.b', 'CXP', 1, 98.33, 22, 1.5363, 89.3581, 99.7595, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.b', 'CXP', 2, 1.67, 22, 1.5363, 0.2405, 10.6419, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.b', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.b', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.b', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.c', 'CX', NULL, 1.39, 22, 0.2854, 1.0000, 1.9853, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.c', 'CXP', 1, 78.34, 22, 13.3178, 41.4206, 94.8729, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.c', 'CXP', 2, 15.81, 22, 9.3481, 4.1792, 44.7224, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.c', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.c', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.c', 'CXP', 5, 5.84, 22, 5.5299, 0.7619, 33.4130, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.d', 'CX', NULL, 1.30, 22, 0.2284, 1.0000, 1.7787, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.d', 'CXP', 1, 81.32, 22, 12.5646, 43.8028, 96.0495, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.d', 'CXP', 2, 12.84, 22, 8.2283, 3.0921, 40.4649, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.d', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.d', 'CXP', 4, 5.84, 22, 5.5299, 0.7619, 33.4130, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.e', 'CX', NULL, 1.01, 22, 0.0111, 1.0000, 1.0334, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.e', 'CXP', 1, 99.48, 22, 0.5542, 95.3556, 99.9443, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.e', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.e', 'CXP', 3, 0.52, 22, 0.5542, 0.0557, 4.6444, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.e', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.f', 'CX', NULL, 1.45, 22, 0.2746, 1.0000, 2.0247, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.f', 'CXP', 1, 74.98, 22, 12.5226, 42.7856, 92.3144, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.f', 'CXP', 2, 11.66, 22, 9.1976, 2.0213, 45.8041, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.f', 'CXP', 3, 6.36, 22, 5.5681, 0.9635, 32.1831, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.f', 'CXP', 4, 6.99, 22, 5.8245, 1.1538, 32.6220, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.1.f', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.3', 'CX', NULL, 2.73, 22, 0.2340, 2.2438, 3.2169, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.3', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.3', 'CXP', 2, 51.16, 22, 14.3603, 24.0705, 77.5840, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.3', 'CXP', 3, 24.65, 22, 11.6924, 8.1150, 54.7781, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.3', 'CXP', 4, 24.19, 22, 11.6555, 7.8445, 54.4763, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.a.3', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.a', 'CX', NULL, 2.28, 22, 0.3116, 1.6286, 2.9246, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.a', 'CXP', 1, 27.61, 22, 14.6553, 7.6630, 63.6668, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.a', 'CXP', 2, 41.17, 22, 15.6469, 15.4381, 72.8376, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.a', 'CXP', 3, 13.04, 22, 7.8032, 3.4581, 38.5482, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.a', 'CXP', 4, 12.35, 22, 9.3529, 2.2820, 45.9395, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.a', 'CXP', 5, 5.84, 22, 5.8798, 0.6682, 36.4164, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.b', 'CX', NULL, 1.18, 22, 0.1659, 1.0000, 1.5203, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.b', 'CXP', 1, 88.31, 22, 11.0599, 44.8690, 98.5944, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.b', 'CXP', 2, 5.84, 22, 5.5299, 0.7619, 33.4130, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.b', 'CXP', 3, 5.84, 22, 5.5299, 0.7619, 33.4130, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.b', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.b', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.c', 'CX', NULL, 1.10, 22, 0.0745, 1.0000, 1.2570, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.c', 'CXP', 1, 92.49, 22, 6.3060, 65.0876, 98.7856, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.c', 'CXP', 2, 5.84, 22, 5.8798, 0.6682, 36.4164, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.c', 'CXP', 3, 1.15, 22, 1.3288, 0.1016, 11.7073, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.c', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.c', 'CXP', 5, 0.52, 22, 0.5542, 0.0557, 4.6444, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.d', 'CX', NULL, 1.55, 22, 0.3019, 1.0000, 2.1767, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.d', 'CXP', 1, 75.48, 22, 10.5307, 48.5255, 90.9478, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.d', 'CXP', 2, 11.69, 22, 7.4553, 2.8628, 37.2793, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.d', 'CXP', 3, 1.15, 22, 1.3288, 0.1016, 11.7073, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.d', 'CXP', 4, 5.84, 22, 5.8798, 0.6682, 36.4164, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.d', 'CXP', 5, 5.84, 22, 5.8798, 0.6682, 36.4164, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.e', 'CX', NULL, 1.08, 22, 0.0669, 1.0000, 1.2216, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.e', 'CXP', 1, 94.05, 22, 4.9981, 71.1620, 99.0212, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.e', 'CXP', 2, 4.80, 22, 4.5145, 0.6438, 28.2185, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.e', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.e', 'CXP', 4, 1.15, 22, 1.3288, 0.1016, 11.7073, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.f', 'CX', NULL, 1.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.f', 'CXP', 1, 100.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.f', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.a', 'CX', NULL, 1.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.a', 'CXP', 1, 100.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.b', 'CX', NULL, 1.03, 22, 0.0212, 1.0000, 1.0771, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.b', 'CXP', 1, 97.72, 22, 1.5948, 90.6250, 99.4781, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.b', 'CXP', 2, 1.76, 22, 1.5811, 0.2661, 10.7211, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.b', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.b', 'CXP', 4, 0.52, 22, 0.5542, 0.0557, 4.6444, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.c', 'CX', NULL, 1.06, 22, 0.0553, 1.0000, 1.1734, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.c', 'CXP', 1, 94.16, 22, 5.5299, 66.5870, 99.2381, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.c', 'CXP', 2, 5.84, 22, 5.5299, 0.7619, 33.4130, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.c', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.d', 'CX', NULL, 1.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.d', 'CXP', 1, 100.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.d', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.d', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.e', 'CX', NULL, 1.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.e', 'CXP', 1, 100.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.e', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.e', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.e', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.f', 'CX', NULL, 1.06, 21, 0.0624, 1.0000, 1.1922, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.f', 'CXP', 1, 93.79, 21, 6.2377, 61.7837, 99.2970, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.f', 'CXP', 2, 6.21, 21, 6.2377, 0.7030, 38.2163, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.f', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.a', 'CX', NULL, 4.42, 22, 0.2750, 3.8526, 4.9963, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.a', 'CXP', 2, 5.84, 22, 5.8798, 0.6682, 36.4164, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.a', 'CXP', 3, 9.46, 22, 7.0554, 1.8510, 36.6836, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.a', 'CXP', 4, 21.09, 22, 12.6104, 5.2403, 56.3731, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.a', 'CXP', 5, 63.60, 22, 16.4443, 28.5127, 88.4443, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.b', 'CX', NULL, 1.98, 22, 0.1761, 1.6167, 2.3490, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.b', 'CXP', 1, 19.50, 22, 9.4888, 6.4465, 45.9894, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.b', 'CXP', 2, 68.56, 22, 11.4015, 42.0607, 86.7590, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.b', 'CXP', 3, 6.09, 22, 4.8958, 1.0832, 27.7720, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.b', 'CXP', 4, 5.84, 22, 5.8798, 0.6682, 36.4164, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.c', 'CX', NULL, 1.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.c', 'CXP', 1, 100.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.c', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.d', 'CX', NULL, 1.57, 22, 0.2287, 1.0954, 2.0467, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.d', 'CXP', 1, 54.62, 22, 17.5987, 21.5623, 84.0465, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.d', 'CXP', 2, 33.66, 22, 14.9764, 11.1730, 67.1791, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.d', 'CXP', 3, 11.72, 22, 7.9988, 2.5925, 39.8541, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.d', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.e', 'CX', NULL, 1.13, 22, 0.0828, 1.0000, 1.3052, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.e', 'CXP', 1, 86.70, 22, 8.2785, 59.4280, 96.6677, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.e', 'CXP', 2, 13.30, 22, 8.2785, 3.3323, 40.5720, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.f', 'CX', NULL, 1.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.f', 'CXP', 1, 100.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.f', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.g', 'CX', NULL, 2.61, 22, 0.6449, 1.2676, 3.9498, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.g', 'CXP', 1, 50.51, 22, 17.5375, 19.1761, 81.4480, 'Y', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.g', 'CXP', 2, 5.84, 22, 5.6004, 0.7420, 34.0079, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.g', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.g', 'CXP', 4, 19.56, 22, 9.3432, 6.6075, 45.5353, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.g', 'CXP', 5, 24.08, 22, 11.3422, 8.0303, 53.5437, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.h', 'CX', NULL, 1.20, 22, 0.0943, 1.0062, 1.3986, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.h', 'CXP', 1, 82.06, 22, 9.3654, 54.9185, 94.4948, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.h', 'CXP', 2, 16.80, 22, 9.6105, 4.6080, 45.7598, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.h', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.h', 'CXP', 4, 1.15, 22, 1.3288, 0.1016, 11.7073, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.i', 'CX', NULL, 2.38, 22, 0.2525, 1.8511, 2.9013, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.i', 'CXP', 1, 32.13, 22, 10.6268, 14.6602, 56.5990, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.i', 'CXP', 2, 16.49, 22, 8.9725, 4.8483, 43.3595, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.i', 'CXP', 3, 36.37, 22, 19.1541, 9.2724, 76.1660, 'Y', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.i', 'CXP', 4, 11.66, 22, 9.1976, 2.0213, 45.8041, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.d.1.i', 'CXP', 5, 3.35, 22, 2.0558, 0.9179, 11.4881, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.e.1.d', 'CX', NULL, 1.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.e.1.d', 'CXP', 1, 100.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.e.1.d', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.e.1.d', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.e.1.d', 'CXP', 4, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.e.1.e', 'CX', NULL, 1.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.e.1.e', 'CXP', 1, 100.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.e.1.e', 'CXP', 2, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 21, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.1', 'CX', NULL, 2.99, 22, 0.4056, 2.1478, 3.8348, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.1', 'CXP', 1, 17.51, 22, 9.3528, 5.2316, 44.9341, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.1', 'CXP', 2, 14.25, 22, 9.2264, 3.3417, 44.4121, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.1', 'CXP', 3, 36.30, 22, 18.5098, 9.7334, 75.0690, 'Y', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.1', 'CXP', 4, 15.49, 22, 11.5920, 2.8229, 53.6169, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.1', 'CXP', 5, 16.46, 22, 10.1247, 4.0845, 47.6728, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.2.a', 'CX', NULL, 4.52, 22, 0.1767, 4.1525, 4.8873, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.2.a', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.2.a', 'CXP', 3, 1.29, 22, 1.3569, 0.1420, 10.7105, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.2.a', 'CXP', 4, 45.43, 22, 17.6169, 15.9622, 78.4914, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.2.a', 'CXP', 5, 53.28, 22, 17.5893, 20.7821, 83.2136, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.2.b', 'CX', NULL, 4.26, 22, 0.1548, 3.9429, 4.5867, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.2.b', 'CXP', 2, 1.29, 22, 1.3569, 0.1420, 10.7105, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.2.b', 'CXP', 3, 11.69, 22, 7.4553, 2.8628, 37.2793, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.2.b', 'CXP', 4, 46.28, 22, 15.2139, 19.4377, 75.4623, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.2.b', 'CXP', 5, 40.75, 22, 13.2897, 17.9579, 68.3570, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.4', 'CX', NULL, 4.12, 22, 0.3461, 3.4007, 4.8400, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.4', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.4', 'CXP', 2, 17.04, 22, 9.9972, 4.5091, 47.2006, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.4', 'CXP', 3, 1.07, 22, 0.8478, 0.2064, 5.3967, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.4', 'CXP', 4, 34.68, 22, 9.8813, 17.6536, 56.8112, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.a.4', 'CXP', 5, 47.20, 22, 16.3127, 18.6410, 77.7125, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.2', 'CX', NULL, 2.80, 22, 0.1580, 2.4735, 3.1306, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.2', 'CXP', 1, 6.92, 22, 6.0065, 1.0573, 34.0825, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.2', 'CXP', 2, 15.40, 22, 7.9809, 4.8481, 39.4221, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.2', 'CXP', 3, 68.23, 22, 11.8930, 40.6938, 87.0493, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.2', 'CXP', 4, 9.45, 22, 6.8219, 1.9483, 35.3923, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.2', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.4', 'CX', NULL, 4.69, 22, 0.1428, 4.3905, 4.9846, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.4', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.4', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.4', 'CXP', 3, 5.34, 22, 5.6825, 0.5409, 36.8938, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.4', 'CXP', 4, 20.56, 22, 9.0409, 7.5696, 45.0064, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.4', 'CXP', 5, 74.10, 22, 10.5162, 47.7911, 89.9392, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.7', 'CX', NULL, 4.37, 22, 0.1242, 4.1117, 4.6281, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.7', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.7', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.7', 'CXP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.7', 'CXP', 4, 63.01, 22, 12.4152, 36.0044, 83.7573, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.7', 'CXP', 5, 36.99, 22, 12.4152, 16.2427, 63.9956, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.8', 'CX', NULL, 4.43, 22, 0.1786, 4.0572, 4.8000, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.8', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.8', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.8', 'CXP', 3, 12.84, 22, 7.4839, 3.5346, 37.1806, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.8', 'CXP', 4, 31.47, 22, 9.7747, 15.1753, 54.0974, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.b.8', 'CXP', 5, 55.70, 22, 12.2984, 30.8389, 77.9939, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.c.1', 'CX', NULL, 3.37, 22, 0.3154, 2.7150, 4.0269, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.c.1', 'CXP', 1, 6.41, 22, 5.8671, 0.8891, 34.3544, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.c.1', 'CXP', 2, 18.33, 22, 9.3340, 5.7843, 45.0797, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.c.1', 'CXP', 3, 18.12, 22, 9.4355, 5.5674, 45.3707, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.c.1', 'CXP', 4, 46.02, 22, 17.5682, 16.3783, 78.7699, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.c.1', 'CXP', 5, 11.12, 22, 8.0670, 2.2391, 40.5870, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.1', 'CX', NULL, 4.54, 22, 0.2054, 4.1083, 4.9625, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.1', 'CXP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.1', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.1', 'CXP', 3, 7.60, 22, 6.1239, 1.3223, 33.5314, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.1', 'CXP', 4, 31.27, 22, 18.6150, 6.9853, 73.3739, 'Y', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.1', 'CXP', 5, 61.13, 22, 18.6181, 23.5670, 88.9195, 'Y', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.3', 'CX', NULL, 1.07, 22, 0.0520, 1.0000, 1.1831, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.3', 'CXP', 1, 96.48, 22, 2.5020, 85.5475, 99.2202, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.3', 'CXP', 2, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.3', 'CXP', 3, 3.05, 22, 2.3725, 0.5903, 14.2978, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.3', 'CXP', 4, 0.46, 22, 0.4941, 0.0504, 4.1318, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.3', 'CXP', 5, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.4', 'CT', NULL, 1.01, 22, 0.0055, 1.0000, 1.0167, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.4', 'CTP', 1, 99.48, 22, 0.5542, 95.3556, 99.9443, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.4', 'CTP', 2, 0.52, 22, 0.5542, 0.0557, 4.6444, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.4', 'CTP', 3, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.8', 'CT', NULL, 2.73, 22, 0.1459, 2.4251, 3.0000, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.8', 'CTP', 1, 0.00, 22, 0.0000, NULL, NULL, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.8', 'CTP', 2, 27.14, 22, 14.5946, 7.4316, 63.3530, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '4.C.3.d.8', 'CTP', 3, 72.86, 22, 14.5946, 36.6470, 92.5684, 'N', NULL, '2022-08-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CX', NULL, 2.48, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 1, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 2, 60.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 3, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 4, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CX', NULL, 4.88, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 4, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 5, 88.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CX', NULL, 5.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 5, 100.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CX', NULL, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 3, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 4, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 5, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CX', NULL, 4.92, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 4, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 5, 92.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CX', NULL, 4.52, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 3, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 4, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 5, 68.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CX', NULL, 4.44, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 3, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 4, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 5, 52.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CX', NULL, 3.04, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 1, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 2, 28.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 3, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 4, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 5, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CX', NULL, 4.21, 24, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 1, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 2, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 3, 8.33, 24, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 4, 62.50, 24, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 5, 29.17, 24, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CX', NULL, 2.16, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 1, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 2, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 3, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 4, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CX', NULL, 4.12, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 2, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 3, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 4, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 5, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CX', NULL, 3.12, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 2, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 3, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 4, 28.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 5, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CX', NULL, 2.44, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 2, 64.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 3, 28.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 4, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CX', NULL, 1.12, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 1, 92.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 3, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CX', NULL, 4.44, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CXP', 1, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, 